Ext.define('CompositeTest.view.CompTypesForTest', {
	extend: 'Ext.window.Window',
	alias: 'widget.comptypesfortest',
	title: associatedCompTypesDesc,
	id: 'comptypesfortest',
	padding:'5 10 10 10',
	width: 400,
	height: 400,
	requires: [
		'Ext.ux.form.MultiSelectSI'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	listeners : {
		afterrender: function()
		{
			Ext.Ajax.request(
			{
				url:'CompositeTest/data/CompTypesForTestJson.jsp?testName='+scompTest,
				method: 'POST',
				async:false,
				success: function( response )
				{
					if( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							temp_json = Ext.decode(jsonText);
							Ext.getCmp("itemselectAgg").clearValue();
							Ext.getCmp('itemselectAgg').getStore().loadRawData(temp_json['upperRowDataArray']);
						}
					}
				}
			});
		}
	},

	items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			flex: 1,
			margin: 10,
			items: [
				{
					xtype: 'multiselectSi',
					cls: 'multiselect',
					name: 'itemselectAgg',
					fieldName: 'itemselectAgg',
					id: 'itemselectAgg',
					store: new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					width: 350,
					frame: true
				}
			]
		}
	]

});



