var mySelectionModel = Ext.create('Ext.selection.CheckboxModel', {
	selType: 'checkboxmodel',
	mode: 'MULTI',
	checkOnly: true,
	renderer : function(val, meta, record, rowIndex, colIndex, store,view){
		var hideIconVal = view.getStore().getAt(rowIndex);
		var default_checked = record.get('default_checked');
		var view = Ext.getCmp(associated_test_measures_grid).getView();
		var headerCt = view.headerCt;
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (default_checked)
		{
			meta.trCls = 'x-grid-row x-grid-row-selected';
			Ext.getCmp(associated_test_measures_grid).getSelectionModel().select(rowIndex, true);
		}
		else
		{
			meta.trCls = 'x-grid-row';
			Ext.getCmp(associated_test_measures_grid).getSelectionModel().deselect(rowIndex, true);
			//var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
//			if (checkHd) {
//				checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
//			}
		}
			return '<img src="/final/images/spacer.gif" class="' + Ext.baseCSSPrefix + 'grid-row-checker"/>';
	},
	selectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.getCmp(associated_test_measures_grid).getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.getCmp(associated_test_measures_grid).getStore().getAt(rowIndex);
			//if (!record.get('default_checked'))
			{
				Ext.getCmp(associated_test_measures_grid).getSelectionModel().select(rowIndex, true);
			}
			rowIndex++;
		}
		var view = Ext.getCmp(associated_test_measures_grid).getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.addCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	},
	deselectAll: function(){
		var rowIndex=0;
		while(typeof(Ext.getCmp(associated_test_measures_grid).getStore().getAt(rowIndex))!='undefined') {
			var record = Ext.getCmp(associated_test_measures_grid).getStore().getAt(rowIndex);
			Ext.getCmp(associated_test_measures_grid).getSelectionModel().deselect(rowIndex, true);
			rowIndex++;
		}
		var view = Ext.getCmp(associated_test_measures_grid).getView();
		var headerCt = view.headerCt;
		var hdSelectStatus = this.selected.getCount() === this.store.getCount();
		var checkHd = headerCt.child('gridcolumn[isCheckerHd]');
		if (checkHd) {
			checkHd.el.removeCls(Ext.baseCSSPrefix +'grid-hd-checker-on');
		}
	}
});

Ext.define('CompositeTest.view.MeasureWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.measurewindow',
	id: 'measurewindow',
	width: 950,
	height: 560,
	padding:'5 10 10 10',
	title: associateTestMeasures,
	modal: true,
	closeAction:'destroy',
	autoScroll: true,
	doClose:function(){
		var me = this;
		me.focus();
		Ext.defer(function(){Ext.destroy(Ext.getCmp(me.id))},100);
	},
	requires : [
		'utilities.ScrollCombo'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	flex: 1,

	items:[
		{
			xtype: 'container',
			id: 'dp_container_2',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			cls: 'formOuter',
			padding: 5,
			defaultType: 'displayfield',
			defaults: {
				labelAlign: 'left',
				labelSeparator: ''
			},
			items: [
				{
					xtype: 'textfield',
					fieldLabel: measureDisplayNameLabel,
					cls:'textbox',
					id:'measure_display_name',
					name:'measure_display_name',
					readOnly: false,
					width: 370,
					labelWidth: 120,
					maxLength: 32,
					enforceMaxLength: true,
					margin: '5 5 5 5'
				},
				{
					xtype: 'textfield',
					fieldLabel: alarmDisplayStringLabel,
					cls:'textbox',
					id:'alarm_display_string',
					name:'alarm_display_string',
					width: 400,
					labelWidth: 150,
					maxLength: 32,
					enforceMaxLength: true,
					margin: '5 5 5 50'
				}
			]
		},
		{
			xtype: 'fieldset',
			title: indicate_measure,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			margin: '5 10 5 10',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					defaults: {
						labelSeparator: '',
						labelAlign: 'top',
						//margin: 5
					},
					margin: 5,
					items: [
						{
							xtype: 'textfield',
							fieldLabel: measureNameLabel,
							cls:'textbox',
							id:'compMeasure',
							name:'compMeasure',
							hidden: true
						},
						{
							xtype: 'scrollcombo',
							fieldLabel: 'Test (component type)',
							cls: 'dropdown',
							id:'testlist',
							name:'testlist',
							displayField:'displayField',
							valueField:'valueField',
							groupField : 'groupField',
							queryMode: 'local',
							parent:this,
							labelStyle: 'white-space: wrap;',
							store:new Ext.data.Store({
								fields: ['displayField','valueField','groupField'],
								data: []
							}),
							width: 300,
							listConfig: {
								tpl: Ext.create('Ext.XTemplate',
									'<ul><tpl for=".">',
									'<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
									'<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
									'</tpl>',
									'<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0">padding-left: 12px</tpl>">{displayField}</li>',
									'</tpl>' +
									'</ul>',
									{
										getGroupLabel: function (values) {
											return values.groupField
										}
									}
								)
							},
							listeners: {
								select: function(){
									compTestCtrlr.testChanged();
								}
							},
							editable:false,
							margin: '0 10 0 0'
						},
						{
							xtype: 'scrollcombo',
							id:'actionOnDesc',
							name:'actionOnDesc',
							hidden:false,
							fieldLabel: descriptorLabel,
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField:'displayField',
							valueField:'valueField',
							queryMode : 'local',
							editable: false,
							listeners: {
								select: function(){
									compTestCtrlr.includeExcludeChanged();
								}
							},
							width: 150,
							margin: '0 10 0 0'
						},
						{
							xtype: 'textfield',
							cls:'textbox',
							name: 'includeDescriptors',
							id: 'includeDescriptors',
							fieldLabel: descToBeIncludedLabel,
							labelStyle: 'white-space: wrap;',
							hidden:true,
							value: 'all',
							width: 250,
							listeners: {
								render: function(c) {
									Ext.QuickTips.register({
									target: c.getEl(),
									text: descriptorsInfo
									});
								}
							}
						},
						{
							xtype: 'textfield',
							cls:'textbox',
							name: 'excludeDescriptors',
							id: 'excludeDescriptors',
							fieldLabel: descToBeExcludedLabel,
							labelStyle: 'white-space: wrap;',
							hidden:true,
							value: 'none',
							width: 250,
							listeners: {
								render: function(c) {
									Ext.QuickTips.register({
									target: c.getEl(),
									text: descriptorsInfo
									});
								}
							}
						},
						{
							xtype: 'hiddenfield',
							id:'compTest',
							name:'compTest',
							value:''
						}
					]
				},
				{
					xtype: 'container',
					id: 'measuresContainer',
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					hidden: true,
					margin: 5,
					items: [
						{
							xtype: 'itemselector',
							name: 'itemselectHosts',
							fieldName: 'itemselectHosts',
							id: 'itemselectHosts',
							cls:'multiselect',
							buttons: ['add','remove'],
							buttonsText: {
								add: 'Disassociate',
								remove: 'Associate'
							},
							store: new Ext.data.Store(
							{
								fields: ['displayField','valueField'],
								data: []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							msgTarget: 'side',
							height: 125,
							width: 700,
							hidden:true,
							fromTitle: associatedMeasuresDesc,
							toTitle: availableMeasuresDesc,
							onAddBtnClick : function() {
								var me = this,
								selected = me.getSelections(me.fromField.boundList);
								me.moveRec(true, selected);
								me.toField.boundList.getSelectionModel().select(selected);
							},
							onRemoveBtnClick : function() {
								var me = this,
								selected = me.getSelections(me.toField.boundList);
								me.moveRec(false, selected);
								me.fromField.boundList.getSelectionModel().select(selected);
							},
							onItemDblClick: function(view, rec) {
								this.moveRec(view === this.fromField.boundList, rec);
							},
							syncValue: function() {
								var me = this;
								me.mixins.field.setValue.call(me, me.setupValue(me.toField.store.getRange()));
							}
						},
						{
							xtype: 'multiselect',
							title: 'Associated Measures',
							cls:'multiselect',
							id : 'defaultAssociatedMeasures',
							name: 'defaultAssociatedMeasures',
							displayField: 'displayField',
							valueField: 'valueField',
							autoScroll:true,
							scroll:false,
							hidden:true,
							height: 125,
							width: 300,
							store:new Ext.data.Store({
								fields: ['displayField','valueField'],
								data: []
							})
						}
					]
				},
				{
					xtype:'container',
					id:'associate_button_container',
					hidden:true,
					layout: {
						type:'hbox',
						pack:'center'
					},
					margin: '5 0 0 0',
					items: [
						{
							xtype: 'button',
							text: add,
							name: 'addAssociatedMeasures',
							id:'addAssociatedMeasures',
							cls:'button20',
							width: 80,
							listeners:
							{
								click:{
									fn: function (id){
										compTestCtrlr.associateNewMeasures(this);
									}
								}
							}
						}
					]
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			title: measure_in_details_desc,
			id:associated_test_measures_grid,
			emptyText: '<div class="x-grid-empty"><table border="0" width="100%" height="60px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText">'+noMeasuresAssociated+'.</div></td></tr></table></div>',
			hidden:false,
			flex:1,
			autoScroll:true,
			scroll:true,
			margin:'5 10 5 10',
			columnLines:true,
			sortableColumns:false,
			selModel :mySelectionModel,
			plugins: Ext.create('Ext.grid.plugin.CellEditing', {
				pluginId: associated_plugin_id,
				clicksToEdit: 1
			}),

			store:Ext.create('Ext.data.Store',{
				fields:['default_checked','associated_test_name','associated_test_description','associated_measure_name', 'associated_measure_description', 'associated_measure_min_threshold','associated_measure_max_threshold', 'associated_measure_type'],
				data:[]
			}),
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: true,
					isCheckerHd: false
				},
				items: [
					{
						header: "hiddenCol",
						dataIndex: 'associated_measure_name',
						hidden: true
					},
					{
						header: "hiddenCol",
						dataIndex: 'associated_test_name',
						hidden: true
					},
					{
						header: test_name_label,
						dataIndex: 'associated_test_description',
						flex: 1
					},
					{
						header: measures_name_label,
						dataIndex: 'associated_measure_description',
						flex: 1
					},
					{
						header: minimumValue,
						dataIndex: 'associated_measure_min_threshold',
						flex: 1,
						field: {
							cls:'textbox',
							allowBlank: false
						},
						cellEditing:true,
						renderer : function(value, metadata) {
							metadata.tdAttr = 'data-qtip="Critical/Major/Minor in ascending order"';
							metadata.tdCls = "grid_editable_cell";
							return value;
						}
					},
					{
						header: maximumValue,
						dataIndex: 'associated_measure_max_threshold',
						flex: 1,
						field: {
							cls:'textbox',
							allowBlank: false
						},
						cellEditing:true,
						renderer : function(value, metadata) {
							metadata.tdAttr = 'data-qtip="Critical/Major/Minor in descending order"';
							metadata.tdCls = "grid_editable_cell";
							return value;
						}
					},
					{
						header: measureType,
						dataIndex: 'associated_measure_type',
						id: 'measureTypeId',
						flex: 1,
						renderer: function (value,metadata){
							if(value=='Sup')
							{
								value='Non-key';
							}
							metadata.tdCls = "grid_editable_cell";
							return value;
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconDelete',
						sortable: false,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+deleteTooltip+"' data-qclass='yellowTip'";
						},
						handler: function(grid, rowIndex, colIndex) {
							if(grid.getStore().data.length==1)
							{
								Ext.Msg.show({
									title: pageTitle1,
									msg:Ext.getCmp('measure_display_name').getValue()+' ' + atleastAlert,
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation'
								});
							}
							else
							{
								var obj = grid.getStore().getAt(rowIndex);
								Ext.Msg.show({
									title: pageTitle1,
									msg:innerDeleteMeasureAlert+ ' '+obj.get(associated_measure_description)+' measure of ' + obj.get(associated_test_description)+' test?',
									buttons: Ext.Msg.OKCANCEL,
									icon: 'iconConfirmation',
									fn: function(response) {
										if(response == 'ok') {
											grid.getStore().remove(grid.getStore().getAt(rowIndex));
											compTestCtrlr.refreshTests();
										}
									}
								});
							}
						}
					}
				]
			}
		},
		{
			xtype:'container',
			id:'upper_measures_button_container',
			hidden:false,
			layout: {
				type:'hbox',
				pack:'center'
			},
			margin: '5 0 10 0',
			items: [
				{
					xtype: 'button',
					text: 'Update',
					name: 'addMeasures',
					id:'addMeasures',
					cls:'button20',
					width: 80,
					listeners:
					{
						click:{
							fn: function (id){
								compTestCtrlr.associateNewMeasures_update(this);
							}
						}
					}
				}
			]
		}
	]
});



