Ext.define('CompositeTest.view.TestMeasures', {
	extend: "Ext.form.Panel",
	alias: "widget.testmeasures",
	id: "testmeasures",
	scroll:false,
	autoScroll:false,
	header: false,
	width: '100%',
	height: 360,

	requires: [
		'Ext.ux.RowExpander',
		'Ext.grid.*'
	],

	layout:
	{
		type: 'vbox',
		align: 'stretch'
	},

	items: [
		{
			xtype: 'customgrid',
			id:'measuresGrid',
			cls:'gridSkin',
			header : false,
			store:Ext.create('Ext.data.Store',{
				fields:['aggTestName', 'count', 'measurenames'],
				data:[]
			}),
			autoScroll:true,
			scroll:true,
			flex:1,
			plugins: [
				{
					ptype: 'rowexpander',
					toggleRow: function(rowIdx) {
						var view = this.view,
							rowNode = view.getNode(rowIdx),
							row = Ext.get(rowNode),
							nextBd = Ext.get(row).down(this.rowBodyTrSelector),
							record = view.getRecord(rowNode),
							grid = this.getCmp();

						if (row.hasCls(this.rowCollapsedCls))
						{
							row.removeCls(this.rowCollapsedCls);
							nextBd.removeCls(this.rowBodyHiddenCls);
							this.recordsExpanded[record.internalId] = true;
							view.fireEvent('expandbody', rowNode, record, nextBd.dom);
						} 
						else
						{
							row.addCls(this.rowCollapsedCls);
							nextBd.addCls(this.rowBodyHiddenCls);
							this.recordsExpanded[record.internalId] = false;
							view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
						}
					},
					rowBodyTpl: [
						'<div>{measurenames}</div>'
					]
				}
			],
			tbar: [
				{
					xtype: 'label',
					id: 'totalAggTests',
					html:'<b>'+showMeasureBtn+'</b>'
				},
				{
					xtype: 'tbfill'
				},
				{
					xtype:'toolbar',
					ui:'footer',
					items:[
						{
							xtype: 'button',
							text: showMeasureBtn,
							isModified : 'false',
							id: 'showAll_popup',
							cls:'button20',
							status : 'hidden'
						}
					]
				}
			],
			columns: [
				{
					text: comp_test_name,
					dataIndex: 'aggTestName',
					sortableColumns: false,
					sortable: true,
					draggable : false,
					menuDisabled : true,
					flex: 1
				},
				{
					text: comp_measures_count,
					dataIndex: 'count',
					width : 120,
					sortable: true,
					draggable : false,
					menuDisabled : true
				}
			],
			margin: '10 10 10 10'
		},
		{
			xtype:'fieldset',
			id: 'imagemsg',
			border: false,
			hidden : true,
			margin: '200 0 0 0',
			style:{
				fontSize: '12px',
				'text-align':'center'
			}
		}
	]

});



