Ext.define('CompositeTest.view.Tests', {
	extend: 'utilities.innerScrollContainer',
	margin : '8 8 0 8',
	cls:'outerpanel',
	alias: 'widget.tests',
	title: pageTitle1,

	requires: [
		'utilities.ScrollCombo',
		'utilities.adminMsg',
		'utilities.CustomGrid'
	],

	dockedItems: [
		{
			xtype: 'adminmsg',
			align:'center',
			addIcon:'iconAdminInfo',
			html: pageDesc1,
			spaceforImg:5,
			padding: 5
		}
	],

	items: [
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			frame:false,
			border:false,
			padding:0,
			scroll:true,
			autoScroll:true,
			id:'udGrid',
			title: udTests,
//			features: [
//				{
//					ftype: 'rowbody',
//					getAdditionalData: function(data, idx, record, orig) {
//						var headerCt = this.view.headerCt, 
//							colspan = headerCt.getColumnCount();
//						return {
//							rowBody: '<div style="padding:5px 10px 5px 50px"><i>'+record.get("purpose_of_test")+'</i></div>',
//							rowBodyColspan: colspan
//						};
//					}
//				},
//				{
//					ftype: 'rowwrap'
//				}
//			],
			store: new Ext.data.Store({
				fields: ['test', 'displayName', 'purpose_of_test','desc_based_test','compType','dispCompType','layerName'],
				data : []
			}),
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: true
				},
				items: [
					{
						dataIndex: 'test',
						hidden: true
					},
					{
						text: displayName,
						dataIndex: 'displayName',
						flex: 1,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+value+"' data-qclass='yellowTip'";
							return "<div style='cursor:pointer'>"+value+"</div>";
						},
						listeners: {
							click: function(grid, cellElement, rowIndex, cellIndex){
								ctrler.modifyTest(grid, rowIndex, cellIndex);
							}
						}
					},
					{
						text: description,
						dataIndex: 'purpose_of_test',
						flex: 1,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+value+"' data-qclass='yellowTip'";
							return value;
						}
					},
					{
						text: descbased,
						dataIndex: 'desc_based_test',
						flex: 1
					},
					{
						dataIndex: 'compType',
						hidden: true,
						flex: 1
					},
					{
						text: compTypeDesc,
						dataIndex: 'dispCompType',
						hidden: true,
						flex: 1,
						listeners: {
							click : function(grid, rowIndex, colIndex) {
								ctrler.showTestsAndMeasures(colIndex);
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+show_comp_types+"' data-qclass='yellowTip'";
							return "<div style='cursor:pointer'>"+value+"</div>";
						}
					},
					{
						text: layerNameDesc,
						dataIndex: 'layerName',
						flex: 1,
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+value+"' data-qclass='yellowTip'";
							return value;
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconAddServer',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							var rec = grid.getStore().getAt(rowIndex);
							scompTest=rec.get('test');
							ctrler.getAssociatedServersForCompTest(rec.get('test'),grid, rowIndex, colIndex);
						},
						renderer:function(value, metaData, record, row, col, store, gridView){
							metaData.tdAttr = "data-qtip='"+associatedCompTypesDesc+"' data-qclass='yellowTip'";
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconModify',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							ctrler.modifyTest(grid, rowIndex, colIndex);
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
							return value;
						}
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						iconCls: 'iconDelete',
						sortable: false,
						handler: function(grid, rowIndex, colIndex) {
							var j = grid.getStore().getAt(rowIndex).get('test');
							if(j.indexOf('_') !=j.lastIndexOf('_')) {
								ctrler.deleteTest(grid, rowIndex, colIndex);

							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
							return value;
						},
						getClass: function(v, meta, rec)
						{
							var j = rec.get('test');
							if(j.indexOf('_')==j.lastIndexOf('_')) {
								return 'iconDeleteDisabled';
							}
							else {
								return 'iconDelete';
							}
						}
					}
				]
			},
			margin: 10,
			flex: 1,
			emptyText:  '<table border="0" width="100%" height="400px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noUdTestsAlrtDiv">'+noTestsFnd+'</div></td></tr></table>',
			viewConfig: {
				deferEmptyText: false
			},
			tools: [
				{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					emptyText: 'Search',
					id:'searchBox',
					padding:0,
					margin:'0 5 0 0',
					onTrigger1Click: function() {
						this.reset();
					},
					onTrigger2Click: function() {
						ctrler.searchTest();
					},
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					}
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					padding:0,
					margin:0,
					items: [
						{
							xtype: 'button',
							cls:'button20',
							padding:0,
							margin:0,
							id: 'addTestButton',
							text: addTest,
							width: 200
						}
					]
				}
			]
		}
	]
});



