Ext.define('CompositeUpdateTest.controller.Main',{
	extend:'Ext.app.Controller',
	views:['UpdateTestView'],
	requires : ['CompositeUpdateTest.view.DynamicGrid'],
	refs:[
		{selector:'main', ref:'main'},
	],
	init:function(){
		appController = this;
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			'main combo[id="componentType"]':
			{
				'select': this.ComponentTypeOnchange
			},
			'main combo[id="componentName"]':
			{
				'select': this.ComponentNameOnchange
			},
			'main button[action=submit]':
			{
				'click': this.ButtonOnchange
			},
			'main button[id="backbutton"]': {
				'click': this.goToUnconfigTestsSummaryPage
			},
		});
	},
	mainCheckBoxOnchange: function(newValue)
	{
		this.selectAllGridValues(newValue);
	},
	goToUnconfigTestsSummaryPage: function() {
		var unconfigCompType = Ext.getCmp('componentType').getValue();
		window.location.href='/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=unConfiguredSummary&running_below_recommended_test_period=true&componentType='+encodeURIComponent(unconfigCompType)+'&scrollPosition_back=0';
	},
	afterMainRender: function()
	{
		Ext.getCmp('gridPanel').hide();
		Ext.getCmp('updateButton').hide();
		var param = "sessid="+sessId;
		var me = this;
		Ext.Ajax.request(
		{

			url: requestURL,
			method:'GET',
			params:param,
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					Ext.getCmp('componentType').getStore().suspendEvents(true);
					Ext.getCmp('componentType').getStore().loadRawData(publicJSON['ComponentTypeList']);
					Ext.getCmp('componentType').getStore().resumeEvents();
					Ext.getCmp('componentType').select(selectedServer);
					Ext.getCmp('componentName').getStore().suspendEvents(true);
					Ext.getCmp('componentName').getStore().loadRawData(publicJSON['ComponentNameList']);
					Ext.getCmp('componentName').getStore().resumeEvents();
					Ext.getCmp('componentName').select(selectedComponent);
					if (!Ext.isEmpty(reqFrom) && reqFrom != undefined && reqFrom == 'UnconfigTests')
					{
						Ext.getCmp('backbutton').show()
					}
					else
					{
						Ext.getCmp('backbutton').hide()
					}
					if (selectedServer != "-1" && selectedComponent != "-1")
					{
						me.DynamicGridPanel(publicJSON['gridData2'],publicJSON['gridColumns'])
					}
					else
					{
						Ext.getCmp('imagemsg').hide();
						Ext.getCmp('gridPanel').hide();
						Ext.getCmp('updateButton').hide();
					}
				}
			}
		});
	},
	ComponentTypeOnchange: function()
	{
		Ext.getCmp('gridPanel').hide();
		Ext.getCmp('updateButton').hide();
		var selComponentType = Ext.getCmp('componentType').getValue();
		if(selComponentType != "-1")
		{
			var param = 'selectedServer=' +encodeURI(selComponentType)+"&sessid="+sessId;
			Ext.Ajax.request(
			{
				url: 'CompositeUpdateTest/data/updateTestPeriodsJson.jsp',
				method:'GET',
				params: param,
				success: function(response)
				{
					if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
						Ext.getCmp('componentType').setValue(selComponentType);
						Ext.getCmp('componentName').getStore().suspendEvents(true);
						Ext.getCmp('componentName').getStore().loadRawData(publicJSON['ComponentNameList']);
						Ext.getCmp('componentName').getStore().resumeEvents();
						Ext.getCmp('componentName').select(Ext.getCmp('componentName').getStore().getAt(0));
					}
				}
			});
		}
		else if(selComponentType == "-1")
		{
			this.afterMainRender()
		}
	},
	ComponentNameOnchange: function()
	{
		var me = this;
		var selComponentType = Ext.getCmp('componentType').getValue();
		var selComponentName = Ext.getCmp('componentName').getValue();
		Ext.getCmp('gridPanel').hide();
		Ext.getCmp('updateButton').hide();
		Ext.getCmp('imagemsg').hide();
		if(selComponentName != "-1")
		{
			var param = 'selectedServer=' +encodeURI(selComponentType)+'&selectedComponent=' +encodeURI(selComponentName)+"&sessid="+sessId;
			Ext.Ajax.request(
			{
				url: 'CompositeUpdateTest/data/updateTestPeriodsJson.jsp',
				method:'GET',
				params: param,
				success: function(response)
				{
					if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );
						Ext.getCmp('componentType').setValue(selComponentType);
						Ext.getCmp('componentName').setValue(selComponentName);
						Ext.getCmp('mainCheckBox').reset();
						me.DynamicGridPanel(publicJSON['gridData2'],publicJSON['gridColumns'])
					}
				}
			});

		}
		else
		{
			Ext.getCmp('imagemsg').hide();
			Ext.getCmp('gridPanel').hide();
			Ext.getCmp('updateButton').hide();
		}
	},
	DynamicGridPanel : function(gridArray,cols)
	{
		var chkCount = 0;
		var itemsArray	=  new Array();
		var i = 0;
		var colCount = 1;
		var compNamesTemp = 0;
		Ext.getCmp('imagemsg').show();
		for (var key in cols)
		{
			chkCount++;
			var colObject = cols[key];
			var fieldstoStore =  new Array();
			var mainColumnsObjArray	=  new Array();
			for (var key2 in colObject)
			{
				Ext.getCmp('gridPanel').show();
				Ext.getCmp('updateButton').show();
				Ext.getCmp('imagemsg').hide();
				var colCount = 1;
				var gridColumn = colObject[key2];
				fieldstoStore.push(key2);
				if (key2 == "col_2")
				{
					compNames[compNamesTemp] = gridColumn;
					compNamesTemp++;
					mainColumnsObjArray.push({
						header: labelTwo,
						sortable:false,
						draggable : false,
						resizable : false,
						border:0,
						menuDisabled : true,
						dataIndex: key2,
						flex:1,
						editor: new Ext.form.field.ComboBox({
							editable: false,
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							cls:'dropdown',
							margin:'2 0 0 0',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data: []
							})
						})
					});
				}
				else if(key2 == "col_3")
				{
					mainColumnsObjArray.push({
						header: '',
						sortable:false,
						draggable : false,
						resizable : false,
						menuDisabled : true,
						hidden : true,
						dataIndex: key2,
						flex:1
					});
				}
				else if(key2 == "col_4")
				{
					mainColumnsObjArray.push({
						header: currentTestPeriod,
						sortable:false,
						draggable : false,
						resizable : false,
						menuDisabled : true,
						hidden : false,
						dataIndex: key2,
						flex:1
					});
				}
				else
				{
					mainColumnsObjArray.push({
						header: gridColumn,
						sortable:false,
						draggable : false,
						resizable : false,
						menuDisabled : true,
						dataIndex: key2,
						flex:1,
						border:0
					});
				}
			}
			var temp = 0;
			var allSelectedIndex = new Array();
			var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
				clicksToEdit: 1,
				listeners : {
					'beforeedit' : function( editor, e, eOpts )
					{
						var selection = e.grid.getSelectionModel().getSelection();
						var len = e.grid.getSelectionModel().getSelection().length;
						for(var i=0; i< len; i++)
						{
							allSelectedIndex[i] = selection[i].index;
						}
						ans = e.grid.getSelectionModel().isSelected(e.grid.getStore().getAt(e.rowIdx));
					},
					'edit' : function( editor, e, eOpts )
					{
						if(!ans)
						{
							e.grid.getSelectionModel().deselect(e.rowIdx);
						}
						else
						{
							e.grid.getSelectionModel().select(e.rowIdx);
						}
						for(var i=0; i<allSelectedIndex.length; i++)
						{
							e.grid.getSelectionModel().select(allSelectedIndex[i],true);
						}
					}
				}
			});
			var gridPartID = 'gridPart_'+chkCount;
			var gridpanel = Ext.widget('dynamicgrid',{
				store:new Ext.data.Store({
					fields: fieldstoStore,
					data: gridArray[i++]
				}),
				selModel :new Ext.selection.CheckboxModel(
				{
					checkOnly: true,
					width:55,
					injectCheckbox: 'first',
					listeners : {
						'select': function(obj, record, index, eOpts )
						{
							for (var totalTypes=1;;totalTypes++)
							{
								var gridObj = Ext.getCmp('gridPart_'+totalTypes);
								if (gridObj == null || gridObj == 'undefined')
								{
									Ext.getCmp('mainCheckBox').setValue(true);
									return false;
								}
								var totalGrid = gridObj.getSelectionModel();
								var gridStore = gridObj.getStore();
								var totalCount  = gridStore.getCount();
								for (var gridRow = 0;gridRow<totalCount;gridRow++)
								{
									var rowObject = gridStore.getAt(gridRow);
									if (!totalGrid.isSelected(rowObject))
									{
										Ext.getCmp('mainCheckBox').setValue(false);
										return;
									}
								}
							}
						},
						'deselect': function(obj, record, index, eOpts )
						{
							Ext.getCmp('mainCheckBox').setValue(0);
						}
					},
				}),
				width : '100%',
				id: gridPartID,
				gridCountId : chkCount,
				sortableColumns:true,
				listeners : {
					'afterrender': function(obj, eOpts)
					{
						for (var colIndex=0;colIndex<obj.getStore().getCount();colIndex++)
						{
							var editorObject = obj.columns[3].getEditor();
							editorObject.getStore().suspendEvents(true);
							editorObject.getStore().loadRawData(publicJSON['TimePeriodList_'+obj.gridCountId+'_'+colIndex]);
							editorObject.getStore().resumeEvents();
							editorObject.setValue(editorObject.getStore().getAt(0).get("valueField"));
						}
					}
				},
				plugins: [cellEditing],
				columns:mainColumnsObjArray,
				viewConfig: {
					forceFit: true,
					stripeRows : false
				}
			});
			itemsArray.push(gridpanel);
		}
		Ext.getCmp('dynGridContainer').removeAll();
		Ext.getCmp('dynGridContainer').add(itemsArray);
		this.getMain().doLayout();
	},
	selectAllGridValues : function(action)
	{
		for(var i=1;;i++)
		{
			var gridObj = Ext.getCmp('gridPart_'+i);
			if (gridObj == null || gridObj == 'undefined')
			{
				return false;
			}
			var selectionModelObject = gridObj.getSelectionModel();
			if (action == true)
			{
				selectionModelObject.selectAll();
			}
			else
			{
				selectionModelObject.deselectAll();
			}
		}
	},
	ButtonOnchange: function()
	{
		var allSelTests = '';
		var selComponentType = Ext.getCmp('componentType').getValue();
		var selComponentName = Ext.getCmp('componentName').getValue();
		forloop:
		for (var totalTypes=1;;totalTypes++)
		{
			var gridObj = Ext.getCmp('gridPart_'+totalTypes);
			if (gridObj == null || gridObj == 'undefined')
			{
				if(allSelTests== '' || allSelTests.length == 0)
				{
					Ext.Msg.alert(pageTitle,noTestsSelected);
				}
				break forloop;
			}
			var selectedObj = gridObj.getSelectionModel();
			var gridStore = gridObj.getStore();
			var selectedTests = selectedObj.getSelection();
			for ( var i = 0;i<gridStore.getCount();i++ )
			{
				if (selectedObj.isSelected(gridStore.getAt(i)))
				{
					var selTest = gridStore.getAt(i).get('col_3');
					var selTime = gridStore.getAt(i).get('col_2');
					var comp = compNames[totalTypes-1];
					if(selTime.indexOf('mins')>0)
					{
						selTime = selTime.substring(0,selTime.indexOf(" ")) * 60+"|";
					}
					else
					{
						selTime = selTime.substring(0,selTime.indexOf(" ")) * 3600+"|";
					}
					var temp = comp+":"+selTest + ":" + selTime;
					allSelTests = allSelTests + temp + "$";
				}
			}
		}
		if(allSelTests.lastIndexOf('$') > 0)
		{
			allSelTests = allSelTests.substring(0,allSelTests.lastIndexOf("$"));
		}
		var homepage = Ext.getCmp('viewPortId');
		myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
		myMask.show();
		var param = "operation=update&selectedTests="+allSelTests+'&selectedServer='+selComponentType+'&selectedComponent='+selComponentName+"&sessid="+sessId;
		Ext.Ajax.request(
		{
			url: 'CompositeUpdateTest/data/updateTestPeriodsJson.jsp',
			method:'POST',
			params: param,
			success: function(response)
			{
				if(response.status  == 200 && !Ext.isEmpty( response.responseText ))
				{
					var jsonText = response.responseText;
					Ext.getCmp("componentName").fireEvent("select");
				}
				myMask.hide();
			},
			failure: function(response)
			{
				Ext.Msg.alert(pageTitle,'Unable to process');
				myMask.hide();
			}
		});
	}
});