
Ext.define('ConfigureIdp.controller.Main',{
	extend:'Ext.app.Controller',
	views:[
			'Main',
			'EgViewSso',
			'SsoForm',
			'SsoConfiguarationPanel',
			'ViewSsoData',
			'DeleteSso',
			'ResultPanel',
			'DeleteSso',
			'DownloadUtils',
	],
	refs:[
		{ref:'ssotree',selector:'ssotree'},
		{selector:'main', ref:'main'},
		{selector:'viewsso', ref:'viewsso'},
		{selector:'ssotree', ref:'ssotree'},
		{selector:'ssoform', ref:'ssoform'},
		{selector:'ssoconfiguarationpanel', ref:'ssoconfiguarationpanel'},
		{selector:'viewssodata', ref:'viewssodata'},
		{selector:'deletesso', ref:'deletesso'},
		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'downloadutils', ref:'downloadutils'}
	],
	init:function(){
		appCnt = this;
		this.buildMainData();
		this.control({
			'main':
			{
				'boxready': this.afterMainRender
			},
			'ssotree':
			{
				'afterrender': this.loadTreeData,
				'itemmouseenter':this.showToolTip,
				'itemclick':this.loadSsoPage
			},
			'ssotree button[id="Expand"]':
			{
				'click':this.onExpandAllClick
			},
			'ssotree button[id="Collapse"]':
			{
				'click':this.onCollapseAllClick
			},
			'ssoform #update':
			{
				'click':this.updateSsoDetails
			},
			'ssoconfiguarationpanel combo[id="ssoAction"]':
			{
				'select':this.loadActionPage
			},
			'deletesso button[id="delete"]':
			{
				'click':this.deleteSso
			},
			'main #backButton':
			{
				'click':this.loadHomePage
			},
			'ssoform #secondaryMgr':
			{
				'change':this.showSecondaryForm
			},

		});
	},

	showSecondaryForm: function() 
	{
		var checkVal = Ext.getCmp('cluster').getValue();
		if (checkVal == true)
		{
			Ext.getCmp('frmSecondaryContainer').show();
			//if (publicJSON.isIdpLogoutEnabled)
			//{
				//Ext.getCmp('seclogouturl').show();
			//}
			//else
			//{
				//Ext.getCmp('seclogouturl').hide();
			//}
		}
		else
		{
			Ext.getCmp('frmSecondaryContainer').hide();
		}
	},
	downloadMetaDataXML: function()
	{
		var qString = "filename="+encodeURIComponent(publicJSON.fileName)+"&filepath="+encodeURIComponent(publicJSON.filePath);
		var s_qryString = "/final/servlet/com.egurkha.admin.EgMetaDataXmlFileDownload?"+qString;
		var downloadUtils =  Ext.widget('downloadutils');
		downloadUtils.savePDF(s_qryString);
	},
	downloadMetaXML: function()
	{
		Ext.widget("window",{
			resizable:"false",
			title:"Service Provider Metadata",
			id:"metadataView",
			name:"metadataView",
			modal:true,
			layout: {
				type:"vbox",
				align:"center",
				pack:"center"
			},
			items:[
				{
					xtype:"container",
					layout: {
						type:"vbox",
						pack:"center"
					},
					cls: 'formOuter',
					flex: 1,
					defaults: {
						labelAlign:"top",
						labelSeparator:" ",
					},
					items:[
						{
							xtype:"displayfield",
							name:"acsURL",
							id:"acsURL",
							fieldLabel:'Assertion Consumer Service (ACS) URL',
							value:'',
							margin: '10 10 5 10'
						},
						{
							xtype:"displayfield",
							name:"logoutURL",
							id:"logoutURL",
							fieldLabel:'Logout URL',
							value:'',
							margin: '5 10 5 10'
						}
					]
				},
				{
					xtype:"button",
					cls:"button20",
					text:'Download',
					id:"ApplyBtn",
					width: 80,
					handler:function()
					{
						appCnt.downloadMetaDataXML();
					},
					margin: '5 10 10 10'
				}
			],
				listeners: {
					afterrender: function() 
					{
						Ext.getCmp('acsURL').setValue(publicJSON.strAcsURL);
						Ext.getCmp('logoutURL').setValue(publicJSON.strLogoutURL);
					}
				}
		}).show();
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url: appURL,
			method: 'POST',
			async : false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	loadHomePage : function()
	{
		var me = this;
		var ssoRightPanel = Ext.getCmp('ssoRightPanel');
		Ext.getCmp("backButton").hide();
		ssoRightPanel.removeAll();
		ssoRightPanel.add({xtype:'viewsso'});
		Ext.getCmp('ssoInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc2+'</center>');
		me.displayAllSso();
		me.enableAllToolbarControls();
		delete ssoRightPanel;
	},
	showActions: function(view, task, node, rowIndex, e) {
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).removeCls('x-hidden');
		});
	},
	updateSsoDetails : function()
	{
		var me = this;
		var validationResult = me.validateSsoForm();
		if (validationResult == true)
		{
			var qtype = c_type;
			var urlString = "";
			var idpName = Ext.getCmp('idptypes').getValue();
			var loginURL = Ext.getCmp('loginurl').getValue();
			var logoutURL = Ext.getCmp('logouturl').getValue();
			var certInfo = Ext.getCmp('idpcert').getValue();
			
			
			var params = "idpName="+idpName+"&loginURL="+loginURL+"&logoutURL="+logoutURL+"&certInfo="+encodeURIComponent(certInfo);
			
			//if (validationResult == true){return;}
			if (qtype == "Add")
			{
				urlString = 'ConfigureIdp/data/EgSsop.jsp?ctype=Add&'+params;
			}
			else if (qtype == "Modify")
			{
				params = "idpName="+encodeURIComponent(idpName)+"&loginURL="+encodeURIComponent(loginURL)+"&logoutURL="+encodeURIComponent(logoutURL)+"&certInfo="+encodeURIComponent(certInfo);
				if (publicJSON.isClusterSupported)
				{
					var isSecondaryEnable = Ext.getCmp('cluster').getValue();
					params  = params + '&isSecondary='+isSecondaryEnable
				}
				urlString = "ConfigureIdp/data/EgSsop.jsp?ctype=Modify&"+params;
			}

			if (publicJSON.isClusterSupported)
			{
				var isSecondaryEnable = Ext.getCmp('cluster').getValue();
				params  = params + '&isSecondary='+isSecondaryEnable
			}

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			var ssoForm = this.getSsoform().getForm();
			if (ssoForm.isValid())
			{
				this.getSsoform().submit({
					url: urlString,
					method: 'POST',
					success: function(form, action){
						myMask.hide();
						var resultJSON = Ext.decode(action.response.responseText);
						var requestStatus = resultJSON['requestStatus'];
						var errTitle = 'Error';
						if (requestStatus == "success")
						{
							var resultObj = resultJSON['result'];
							var successTitle = resultObj.title;
								
								Ext.Msg.show({
								title: successTitle,
								msg: resultObj.message + ".",
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
							Ext.getCmp('backButton').hide();
							
							var ssoRightPanel = Ext.getCmp('ssoRightPanel');
							ssoRightPanel.removeAll();
							ssoRightPanel.add({xtype:'viewsso'});
							me.enableAllToolbarControls();
							me.displayAllSso();
							me.updateTree();
						}
						else
						{
							var resultObj = resultJSON['errors'];
							errTitle = resultObj.title;
							Ext.Msg.show({
									title: errTitle,
									msg: resultObj.message+".",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
							});
						}
					
					},
					failure: function(form, action) // if result page doest not return success:true, this method fires
					{
						Ext.Msg.show({
									title: pageTitle,
									msg: "Error while configuring IDP.",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
							});
					
						myMask.hide();
					}
				});
			}
		}
	},
	deleteAllSso : function(urlString)
	{
		var me = this;
		Ext.MessageBox.confirm({
			title : pageTitle,
			msg: confirmMsg,
			icon : 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			width : 400,
			fn : function(btn){
				if (btn == 'yes')
				{
					var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Deleting...'});
					myMask.show();
					var viewsso = me.getViewsso().getForm();
					if (viewsso.isValid())
					{
						me.getViewsso().submit({
							url: urlString,
							method: 'POST',
							//standardSubmit: true,
							success: function(form, action){
								myMask.hide();
								var resultObj = Ext.decode(action.response.responseText);
								Ext.Msg.show({
									title: resultObj.result.title,
									msg: resultObj.result.message+".",
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
								me.updatessoTree("ConfigureIdp/data/EgViewSSOJson.jsp?date"+new Date().getTime());
								me.enableAllToolbarControls();
								me.updateTree();
								Ext.getCmp('ssoGrid').getStore().loadRawData(publicJSON['allsso']);
								
							},
							failure: function(form, action) // if result page doest not return success:true, this method fires
							{
								myMask.hide();
							}
						});
					}
				}
			}
		});
	},
	updatessoTree : function(ssoURL)
	{
		Ext.Ajax.request({
			url : ssoURL,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	showResultWindow : function(title,resultText)
	{	
		Ext.widget('window', {
			title: title,
			closeAction: 'destory',
			bodyPadding : 20,
			scroll: true,
			width : 700,
			modal : true,
			autoScroll: true,
			doClose: function() {
				this.destroy();
			},
			html: resultText
		}).show();
	},
	loadTreeData : function()
	{
		var ssoTreeObj = Ext.getCmp('ssoTreePanel');
		Ext.Ajax.request({
			url : 'ConfigureIdp/data/EgBuildTreeJSON.jsp',
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				if( !Ext.isEmpty(jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					jsonData["expanded"] = true;
					ssoTreeObj.setRootNode(jsonData);
					var record = ssoTreeObj.getStore().getNodeById(selectedSsoGroupNode);
					ssoTreeObj.getSelectionModel().select(record);
					Ext.get('Expand').on('click', function(event, target, options)
					{
						var obj = Ext.getCmp('Expand');
						if (obj.currentStatus == "expanded")
						{
							obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px;text-transform: lowercase;" id="exx">'+pageIntnl15+'</div>');
							obj.currentStatus = "collapse";
							Ext.getCmp('ssoTreePanel').collapseAll();
						}
						else
						{
							obj.currentStatus = "expanded";
							obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px;text-transform: lowercase;" id="exx">'+pageIntnl16+'</div>');
							Ext.getCmp('ssoTreePanel').expandAll();
						}
					});
				}
			},
			failure : function(response, opts){
			}
		});
	},
	showToolTip : function(obj, record, item, index, e, eOpts)
	{
		var customqtip = record.raw.customqtip;
		if (customqtip != null && customqtip != undefined)
		{
			var mytip  = Ext.create("Ext.tip.ToolTip",{
				target: e.getTarget(),
				anchor:"top",
				hideDelay : 0,
				autoHide : true,
				trackMouse : true,
				cls:"yellowTip",
				html : customqtip
			}).showAt(e.getXY());

			if (!Ext.isEmpty(mytip))
			{
				mytip.destroy();
				mytip = null;
			}
		}
	},
	loadSsoPage: function(view,record,item,index,event)
	{
		var me = this;
		var ssoRightPanel = Ext.getCmp('ssoRightPanel');
		var nodeName = record.data.text;
		var node_id = record.data.id;
		var myLink = record.raw.link;
		Ext.getCmp("backButton").hide();
		if (nodeName != 'undefined' && !Ext.isEmpty(nodeName))
		{
			if (nodeName == "SAML Identity Providers")
			{
				ssoRightPanel.removeAll();
				ssoRightPanel.setTitle(pageIntnl21);
				ssoRightPanel.add({xtype:'viewsso'});
				Ext.getCmp('ssoInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc2+'</center>');
				me.displayAllSso();
				me.enableAllToolbarControls();
			}
			else
			{
				ssoRightPanel.removeAll();
				ssoRightPanel.setTitle(pageIntnl25 +" - "+nodeName);
				ssoRightPanel.add({xtype:'ssoconfiguarationpanel'});
				me.updateSsoActionItems(nodeName);
				Ext.getCmp('ssoInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc+'</center>');
				Ext.getCmp('ssoDisName').setValue(nodeName);
				ssoDetailsArray = publicJSON['ssoSubValues'];
				me.viewSelectedSso();
			}
		}	
	},
	enableAllToolbarControls : function()
	{
		var isSsoConfigured = publicJSON['isSsoConfigured'];
		var isSsoEnabled = publicJSON['isSsoEnabled'];
		Ext.getCmp('addNewSso').setDisabled(false);
		Ext.getCmp('downloadXml').setDisabled(false);
		if (isSsoEnabled == true)
		{
			Ext.getCmp('downloadXml').setDisabled(false);
		}
		else
		{
			Ext.getCmp('downloadXml').setDisabled(true);
		}

		if (isSsoConfigured == true)
		{
			Ext.getCmp('deleteAllSso').setDisabled(false);
		}
		else
		{
			Ext.getCmp('deleteAllSso').setDisabled(true);
		}
		
	},
	disableDeleteIcon : function()
	{
		Ext.getCmp('deleteAllSso').setDisabled(true);
	},
	afterMainRender : function()
	{
		var me = this;
		var ssoRightPanel = Ext.getCmp('ssoRightPanel');
		if (selectedSsoGroupNode == "ssoroot")
		{
			ssoRightPanel.removeAll();
			ssoRightPanel.add({xtype:'viewsso'});

			Ext.getCmp('ssoInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc2+'</center>');

			var allsso = publicJSON['allsso'];
			var ssoGridObj = Ext.getCmp('ssoGrid');
			if (!Ext.isEmpty(allsso))
			{
				ssoGridObj.getStore().loadRawData(allsso);
				var gridColums = publicJSON['gridColums'];
				var gridCols = ssoGridObj.columns.length;
				for (var i = 0;i<gridCols;i++)
				{
					ssoGridObj.columns[i].setText(gridColums[i]);
					//if (ssoGridObj.columns[i].dataIndex == 'Logout URL')
					//{
						//if (publicJSON.isIdpLogoutEnabled)
						//{
							//ssoGridObj.columns[i].show();
						//}
						//else
						//{
							//ssoGridObj.columns[i].hide();
						//}
					//}else

					if (ssoGridObj.columns[i].dataIndex == 'IdP for secondary manager')
					{
						if (publicJSON.isClusterSupported)
						{
							ssoGridObj.columns[i].show();
						}
						else
						{
							ssoGridObj.columns[i].hide();
						}
					}
				}
			}
			me.enableAllToolbarControls();
			delete ssoGridObj;
			delete gridCols;
			delete gridColums;
		}
		else
		{
			ssoRightPanel.removeAll();
			ssoRightPanel.add({xtype:'ssoconfiguarationpanel'});
			me.updateSsoActionItems(selectedSsoGroupNode);
			Ext.getCmp('ssoInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc+'</center>');
			Ext.getCmp('ssoDisName').setValue(selectedSsoGroupNode);
			ssoDetailsArray = publicJSON['ssoSubValues'];
			me.viewSelectedSso();
		}
	},
	onExpandAllClick: function()
	{
		Ext.getCmp('ssoTreePanel').expandAll();
	},
	onCollapseAllClick: function()
	{
		Ext.getCmp('ssoTreePanel').collapseAll();
	},
	updateTree : function()
	{
		var ssoTreeObj = Ext.getCmp('ssoTreePanel');
		Ext.Ajax.request({
			url : 'ConfigureIdp/data/EgBuildTreeJSON.jsp?date='+new Date().getTime(),
			method : 'POST',
			async : false,
			success : function(response, opts){
				var jsonText = response.responseText;
				if( !Ext.isEmpty(jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					jsonData["expanded"] = true;
					ssoTreeObj.setRootNode(jsonData);
					var record = ssoTreeObj.getStore().getNodeById(selectedSsoGroupNode);
					ssoTreeObj.getSelectionModel().select(record);
				}
			}
		});
	},
	displayAllSso : function()
	{
		var me = this;
		this.updatessoTree("ConfigureIdp/data/EgViewSSOJson.jsp");
		var ssoGridObj = Ext.getCmp('ssoGrid');
		ssoGridObj.getStore().loadRawData(publicJSON.allsso);
		if (Ext.isEmpty(publicJSON.allsso))
		{
			me.disableDeleteIcon();
		}

		//if (ssoGridObj.columns[2].dataIndex == 'Logout URL')
		//{
			//if (publicJSON.isIdpLogoutEnabled)
			//{
				//ssoGridObj.columns[2].show();
			//}
			//else
			//{
				//ssoGridObj.columns[2].hide();
			//}
		//}

		if (ssoGridObj.columns[3].dataIndex == 'IdP for secondary manager')
		{
			if (publicJSON.isClusterSupported)
			{
				ssoGridObj.columns[3].show();
			}
			else
			{
				ssoGridObj.columns[3].hide();
			}
		}
	},
	updateSsoActionItems : function(ssoName)
	{
		var tmpStore = Ext.getCmp('ssoAction');
		var url = "ConfigureIdp/data/EgSso.jsp?idptypes="+encodeURIComponent(ssoName);
		this.updatessoTree(url);
		tmpStore.getStore().loadRawData(publicJSON['actionItems']);
		tmpStore.setValue(tmpStore.getStore().getAt(0).get("valueField"));
	},
	viewSelectedSso :  function()
	{
		var dataArray = new Array();
		var ssoDisplayName = Ext.getCmp('ssoDisName').getValue();
		var logouturl = ssoDetailsArray.logoutURL;
		var idpcert = ssoDetailsArray.certInfoDisplay;
		var loginurl = ssoDetailsArray.loginURL;
		var defaultIdp = ssoDetailsArray.defaultIdp;
	
		var item1 = {
			value : ssoDisplayName,
			fieldLabel :pageIntnl30,
			//margin: '5 0 30 0'
		}
		dataArray.push(item1);
		
		item1 = {
			value : loginurl,
			fieldLabel :pageIntnl4,
			//margin: '5 0 30 0'
		}
		dataArray.push(item1);

		//if (publicJSON.isIdpLogoutEnabled)
		{
			item1 = {
				value : logouturl,
				fieldLabel :pageIntnl5,
				//margin: '5 0 30 0'
			}
			dataArray.push(item1);
		}

		item1 = {
			value : idpcert,
			labelWrap : true,
			fieldLabel :pageIntnl6,
			cls: 'text-wrapper'
		}
		dataArray.push(item1);

		item1 = {
			value : defaultIdp,
			labelWrap : true,
			fieldLabel :pageIntnl29,
			cls: 'text-wrapper'
		}
		dataArray.push(item1);
		
		if (publicJSON.isClusterSupported)
		{
			var clusterEnable = ssoDetailsArray.clusterEnable;
			item1 = {
				value : clusterEnable,
				labelWrap : true,
				fieldLabel :pageIntnl24,
				cls: 'text-wrapper'
			}
			dataArray.push(item1);

			if (!Ext.isEmpty(clusterEnable) && clusterEnable.toLowerCase() == 'yes')
			{
				var secLoginURL = ssoDetailsArray.secLoginURL;
				item1 = {
					value : secLoginURL,
					labelWrap : true,
					fieldLabel :pageIntnl4+' ('+pageIntnl23+')',
					cls: 'text-wrapper'
				}
				dataArray.push(item1);

				//if (publicJSON.isIdpLogoutEnabled)
				{
					var secLogoutURL = ssoDetailsArray.secLogoutURL;
					item1 = {
						value : secLogoutURL,
						labelWrap : true,
						fieldLabel :pageIntnl5+' ('+pageIntnl23+')',
						cls: 'text-wrapper'
					}
					dataArray.push(item1);
				}

				var secCertInfo = ssoDetailsArray.secCertInfo;
				item1 = {
					value : secCertInfo,
					labelWrap : true,
					fieldLabel :pageIntnl6+' ('+pageIntnl23+')',
					cls: 'text-wrapper'
				}
				dataArray.push(item1);
			}
		}
		var tmpPanelObj = Ext.getCmp('displayFieldsContainer');
		tmpPanelObj.removeAll();
		tmpPanelObj.add(dataArray);
		this.getViewssodata().doLayout();
	},
	modifySsoDetails : function()
	{
		var me = this;
		c_type = "Modify";
		var ssoDisplayName = Ext.getCmp('ssoDisName').getValue();
		var ssoName = ssoDetailsArray.loginURL
		var logouturl = ssoDetailsArray.logoutURL
		var idpcert = ssoDetailsArray.certInfo
		var defaultIdp = ssoDetailsArray.defaultIdp

		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		resultViews.add({xtype: 'ssoform'});
		
		Ext.getCmp('update').setText("Update");
		
		Ext.getCmp('idptypes').setReadOnly(true);
		Ext.getCmp('idptypes').setValue(ssoDisplayName);
		Ext.getCmp('loginurl').setValue(ssoName);
		Ext.getCmp('logouturl').setValue(logouturl);
		Ext.getCmp('idpcert').setValue(idpcert);
		if (!Ext.isEmpty(defaultIdp))
		{
			if (defaultIdp.toLowerCase() == 'yes')
			{
				Ext.getCmp('yesDefault').setValue(true);
			}
			else
			{
				Ext.getCmp('noDefault').setValue(true);
			}
		}

		//if (publicJSON.isIdpLogoutEnabled)
		//{
			//Ext.getCmp('logouturl').show();
		//}
		//else
		//{
			//Ext.getCmp('logouturl').hide();
		//}

		if (publicJSON.isClusterSupported)
		{
			var clusterEnable = ssoDetailsArray.clusterEnable;
			Ext.getCmp('secondaryMgr').show();
			if (!Ext.isEmpty(clusterEnable) && clusterEnable.toLowerCase() == 'yes')
			{
				Ext.getCmp('cluster').setValue(true);
				Ext.getCmp('secloginurl').setValue(ssoDetailsArray.secLoginURL);
				Ext.getCmp('seclogouturl').setValue(ssoDetailsArray.secLogoutURL);
				Ext.getCmp('secidpcert').setValue(ssoDetailsArray.secCertInfo);
			}
			else
			{
				Ext.getCmp('cluster').setValue(false);
			}
		}
		else
		{
			Ext.getCmp('secondaryMgr').hide();
		}

	},
	deleteSso : function()
	{
		var ssoDisplayName = Ext.getCmp('ssoDisName').getValue();
		var urlString = "ConfigureIdp/data/EgSsop.jsp?ctype=delete&idptypes="+encodeURIComponent(ssoDisplayName);
		var me = this;
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Deleting...'});
		myMask.show();
		var deletesso = this.getDeletesso().getForm();
		if (deletesso.isValid())
		{
			this.getDeletesso().submit({
				url: urlString,
				method: 'POST',
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					//me.showResultWindow(action.response.responseText);
					var resultObj = Ext.decode(action.response.responseText);
					Ext.Msg.show({
						title: resultObj.result.title,
						msg: resultObj.result.message + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
					});

					me.updatessoTree("ConfigureIdp/data/EgViewSSOJson.jsp");
					var ssoTreePanel = Ext.getCmp('ssoTreePanel');
					var ssoRightPanel = Ext.getCmp('ssoRightPanel');
					me.updateTree();
					ssoRightPanel.removeAll();
					ssoRightPanel.add({xtype:'viewsso'});
					Ext.getCmp('ssoGrid').getStore().loadRawData(publicJSON['allsso']);
					me.enableAllToolbarControls();
					if (Ext.isEmpty(publicJSON.allsso))
					{
						me.disableDeleteIcon();
					}
				},
				failure: function(form, action) // if result page doest not return success:true, this method fires
				{
					myMask.hide();
				}
			});
		}
	},
	deleteSelectedSso : function()
	{
		var ssoDisplayName = Ext.getCmp('ssoDisName').getValue();
		var reqURI = "ConfigureIdp/data/EgSso.jsp?ctype=delete&idptypes="+encodeURIComponent(ssoDisplayName);
		this.updatessoTree(reqURI);
		var canDelete = publicJSON['isUserExits'];

		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		if (canDelete == false)
		{
			var innerHTML = '<div><b>'+confirmMsg2+"&nbsp;</b>'"+ssoDisplayName+"'&nbsp;<b>"+pageIntnl19+'?</div>';
			var tmpWidget = Ext.widget("deletesso",{
				buttonAlign : 'center',
				items : [
					{
						xtype : 'container',
						margin : '20 0 10 0',
						style:{'text-align':'center','margin':'0 auto 20 auto'},
						html:innerHTML
					}
				],
				buttons: [
					{
						text : pageIntnl14,
						id : 'delete',
						cls : 'button20'
					}
				]
			});
			resultViews.add(tmpWidget);
		}
		else
		{
			var innerHTML = "<div style='margin:15% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconExclamation'></div><div class='commonErrorMsgText' style='margin:5px auto auto auto'>"+pageIntnl17+". "+pageIntnl18+".</div></td></tr></table></div>";

			var tmpWidget = Ext.widget("deletesso",{
				items : [
					{
						xtype : 'component',
						style:{'text-align':'center'},
						html:innerHTML
					}
				]
			});
			resultViews.add(tmpWidget);
		}
		Ext.getCmp('deletesso').doLayout();
	},
	loadActionPage : function(actObj)
	{
		var me = this;
		var selectedCategory = actObj.getValue();
		selectedCategory = selectedCategory.toLowerCase();
		if (selectedCategory == "view")
		{
			var resultViews = Ext.getCmp('resultViews');
			resultViews.removeAll();
			resultViews.add({xtype: 'viewssodata'});
			me.viewSelectedSso();
		}
		else if (selectedCategory == "modify")
		{
			me.modifySsoDetails();
		}
		else if (selectedCategory == "delete")
		{
			me.deleteSelectedSso();
		}
		
	},
	addNewSso : function()
	{
		Ext.getCmp('ssoInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc+'</center>');
		Ext.getCmp("backButton").show();
		c_type = "Add";
		var ssoRightPanel = Ext.getCmp('ssoRightPanel');
		ssoRightPanel.removeAll();
		ssoRightPanel.add({xtype:'ssoform'});
		var url = "ConfigureIdp/data/EgSso.jsp?ctype=Add";
		this.updatessoTree(url);
		//if (publicJSON.isIdpLogoutEnabled)
		//{
			//Ext.getCmp('logouturl').show();
		//}
		//else
		//{
			//Ext.getCmp('logouturl').hide();
		//}

		if (publicJSON.isClusterSupported)
		{
			Ext.getCmp('secondaryMgr').show();
		}
		else
		{
			Ext.getCmp('secondaryMgr').hide();
		}

	},
	validateSsoForm : function()
	{
		var splChar3 = " `_~!#$%^&*()+=[]{}|\\:;\"\'<>?\/";
		var d_name = Ext.getCmp('loginurl').getValue();
		var isEnableSecondary = Ext.getCmp('cluster').getValue();
		var idptypes = Ext.getCmp('idptypes');
		var loginurl = Ext.getCmp('loginurl');
		var idpcert = Ext.getCmp('idpcert');
		var logouturl = Ext.getCmp('logouturl');
		if(!checkblank(idptypes.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl8 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					idptypes.focus(true);
				}
			});
			return false;
		}else if(!checkspecialnomess(idptypes.getValue(),splChar3))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl10 + ".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					idptypes.focus(true);
				}
			});
			return false;
		}
		else if(!checkblank(d_name))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl9 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					loginurl.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleUrl(d_name))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: enterValidURL + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					loginurl.focus(true);
				}
			});
			return false;
		}

		//if (publicJSON.isIdpLogoutEnabled)
		{
			if(!checkblank(logouturl.getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntnl22 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						logouturl.focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleUrl(logouturl.getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: enterValidURL + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						logouturl.focus(true);
					}
				});
				return false;
			}
		}
		
		if(!checkblank(idpcert.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl11 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					idpcert.focus(true);
				}
			});
			return false;
		}

		if (publicJSON.isClusterSupported && isEnableSecondary)
		{
			var secloginurlVal = Ext.getCmp('secloginurl').getValue();

			var secloginurl = Ext.getCmp('secloginurl');
			var secidpcert = Ext.getCmp('secidpcert');
			var seclogouturl = Ext.getCmp('seclogouturl');

			if(!checkblank(secloginurlVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntnl9 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						secloginurl.focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleUrl(secloginurlVal))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: enterValidURL + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						secloginurl.focus(true);
					}
				});
				return false;
			}

			//if (publicJSON.isIdpLogoutEnabled)
			{
				if(!checkblank(seclogouturl.getValue()))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: pageIntnl22 + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							seclogouturl.focus(true);
						}
					});
					return false;
				}
				else if(!validateSingleUrl(seclogouturl.getValue()))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: enterValidURL + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							seclogouturl.focus(true);
						}
					});
					return false;
				}
			}

			if(!checkblank(secidpcert.getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntnl11 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						secidpcert.focus(true);
					}
				});
				return false;
			}

		}

		
		return true;
	}
});
function closeAlert()
{
	Ext.Ajax.request({
		url:'ConfigureIdp/data/EgBuildTreeJSON.jsp', 
		method:'POST',
	});
}

function validateSingleUrl(paramValue)
{
	var toMatch = /^(http|ftp|https)\:(\\\\|\/\/)([A-Za-z0-9]+(\.)*[A-Za-z0-9]*)+/;

	if (toMatch.test(paramValue))
	{
		return true;
	}
	else
	{
		return false;
	}
}