
Ext.define('ConfigureIdp.view.EgViewSso',{
	extend:'Ext.form.Panel',
	alias:'widget.viewsso',
	headers: {'Content-type':'multipart/form-data'},
	id:'viewsso',
	border:false,
	scroll: false,
	autoScroll : false,
	cls:'outerpanel',

	requires: [
		'ConfigureIdp.view.ResultPanel'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	flex : 1,
	
	items : [
		{
			xtype: 'grid',
			id: 'ssoGrid',
			flex :1,
			cls:'gridSkin',
			margin: 10,
			store: new Ext.data.Store({
				fields: ['SAML IdP Name', 'Login URL','Logout URL','Is default IdP for login?','IdP for secondary manager'],
				data: []
			}),

			emptyText : '<div class = "iconInformation" style="margin:18% auto auto auto"></div><div  id=\"userDeferMessage2\" class="commonErrorMsgText">'+pageIntnl1+'</div>',
			viewConfig: {
				deferEmptyText: false
			},

			tbar : [
				{
					xtype:'tbfill',
				},
				{
					xtype:'toolbar',
					ui:'footer',
					items:[
						{
							xtype : 'button',
							text : pageIntnl20,
							id : 'downloadXml',
							cls : 'button20',
							handler : function()
							{
								appCnt.downloadMetaXML();
							}
						},
						{
							xtype : 'button',
							text : pageIntnl12,
							id : 'addNewSso',
							cls : 'button20',
							handler : function()
							{
								appCnt.addNewSso();
							}
						},
						{
							xtype : 'button',
							text : pageIntnl13,
							id : 'deleteAllSso',
							cls : 'button20',
							handler : function()
							{
								var ssoTreeURL = "ConfigureIdp/data/EgSsop.jsp?ctype=deleteAll";
								appCnt.deleteAllSso(ssoTreeURL);
							}
						}
					]
				}
			],

			columns: [
				{
					dataIndex: pageIntnl3,
					header: pageIntnl3,
					width: 200
				},
				{
					dataIndex: pageIntnl4,
					header: pageIntnl4,
					flex: 1
				},
				{
					dataIndex: pageIntnl5,
					header: pageIntnl5,
					flex: 1
				},
				{
					dataIndex: pageIntnl29,
					header: pageIntnl29,
					flex: 1
				},
				{
					dataIndex: pageIntnl6,
					header: pageIntnl6,
					hidden : true,
					width: 200
				}
			],

			hideHeaders: false,
			hidden : false
		}
	]
});



