Ext.define('CorrectiveScript.controller.EnableCS',{
	extend: 'Ext.app.Controller',
	views: ['EnableCorrectiveScriptTests'],
	refs: [
		{
			selector: 'enablecorrectivescripttests',
			ref: 'enablecorrectivescripttests'
		}
	],

	init: function(){
		var me = this;
		this.buildFieldData();
	},

	buildFieldData: function()
	{
		Ext.Ajax.request({
			url: 'CorrectiveScript/data/EgEnableCorrectiveScriptsJson.jsp',
			method: 'POST',
			async: false,
			success: function(d) {
				if (d.status == 200 && !Ext.isEmpty(d.responseText)) {
					var c = d.responseText;
					publicJSON = Ext.decode(c);
				}
			}
		});
	},

	initializeFields: function()
	{
		var f = this;
		var e = Ext.getCmp('enablecorrectivescripttests').getForm();
		if (componType == 'null') 
		{
			f.setValueWithOptionInList(e, 'compType', publicJSON['ComponentType'], '');
		}
		else
		{
			f.setValueWithOptionInList(e, 'compType', publicJSON['ComponentType'], componType);
		}
	},

	setValueWithOptionInList: function(l, i, j, k)
	{
		l.findField(i).getStore().clearFilter(true);
		l.findField(i).getStore().loadRawData(j);
		l.findField(i).suspendEvents(false);
		var h = false;
		if (j.length > 0) 
		{
			for (var g = 0; g < j.length; g++) 
			{
				if (j[g].valueField == k && !Ext.isEmpty(k) && k != null) 
				{
					l.findField(i).setValue(k);
					h = true;
				}
			}
		}
		if (!h)
		{
			l.findField(i).setValue(j[0].valueField);
		}
		l.findField(i).resumeEvents();
	},

	afterMainRenderCs: function(value)
	{
		Ext.getCmp('backbutton').show();
		if(value != null)
		{
			componType = '';
		}
		this.initializeFields();
		if ((componType == null && Ext.isEmpty(componType))) 
		{
			Ext.getCmp('itemselectTests').show();
			Ext.getCmp('UpdateBTN').show();
		}
		Ext.getCmp('compType').setFieldLabel(cmpType);
		Ext.getCmp('UpdateBTN').setText(updateBtnText);
		Ext.getCmp('itemselectTests').fromField.getComponent(0).setTitle(assoTests);
		Ext.getCmp('itemselectTests').toField.getComponent(0).setTitle(avlTests);
		Ext.getCmp('NoTestsAvailable').hide();
		var queryStr = '';
		if ((componType != null && !Ext.isEmpty(componType))) 
		{
			queryStr = 'componentType=' + encodeURIComponent(componType);
		}
		Ext.Ajax.request({
			url: 'CorrectiveScript/data/EgEnableCorrectiveScriptsJson.jsp?' + queryStr,
			method: 'POST',
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var b = response.responseText;
					publicJSON = Ext.decode(b);
				}
				var a = publicJSON['NoTestAvailable'];
				if (componType != -1 && typeof a != 'undefined')
				{
					Ext.getCmp('itemselectTests').hide();
					Ext.getCmp('UpdateBTN').hide();
					Ext.getCmp('NoTestsAvailable').show();
				}
				else
				{
					Ext.getCmp('NoTestsAvailable').hide();
					Ext.getCmp('itemselectTests').show();
					Ext.getCmp('UpdateBTN').show();
					var itemSelected = Ext.getCmp('itemselectTests');
					if (itemSelected.fromField.store.getCount() > 0)
					{
						itemSelected.fromField.store.removeAll();
					}

					if (itemSelected.toField.store.getCount() > 0)
					{
						itemSelected.toField.store.removeAll();
					}
					var fromFieldValues = publicJSON['allEnabledCorrectiveScriptTests'];
					var toFieldValues = publicJSON['noCorrectiveTestsArr'];
					if (fromFieldValues != undefined || !Ext.isEmpty(fromFieldValues))
					{
						Ext.getCmp('itemselectTests').fromField.store.add(fromFieldValues);
					}
					if (toFieldValues != undefined || !Ext.isEmpty(toFieldValues))
					{
						Ext.getCmp('itemselectTests').toField.store.add(toFieldValues);
					}
				}
			}
		});
	}
});



