Ext.define('CorrectiveScript.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'main', ref:'main'},
		{selector:'infogrid', ref:'infogrid'},
		{selector:'enablecorrectivescripttests', ref:'enablecorrectivescripttests'}
	],
	init:function(){
		me = this;
		//me.buildFieldData();
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			'main button[id="backbutton"]':
			{
				'click': this.backbutton
			},
			'main trigger[id="searchTrigger"]':
			{
				'change': this.getGridSearchData
			},
			'main scrollcombo[id="filterCompType"]':
			{
				'select': this.rebuildGridUsingCompType
			},
			//'main button[itemId="uploadNewCSBtn"]':
			//{
				//'click': this.showFileUploadWindow
			//},
			'main button[id="enableCorrectiveScriptTests"]':
			{
				'click': this.showEnableCorrectiveScript
			},
			'enablecorrectivescripttests combo[id="compType"]': {
				"select": this.comboLoad
			},
			'enablecorrectivescripttests button[id="UpdateBTN"]': {
				'click': this.updation
			},
			'enablecorrectivescripttests button[id="backbutton"]': {
				'click': this.CsBackButton
			}
		});
	},
	backbutton: function()
	{
		window.location.href = backBtnUrl;
	},
	handleEditIconClick: function(testName, script, osName, cType){
		btnText = 'Edit';
		var scriptName = script;
		var osName = osName;
		this.showReuploadWindow(scriptName,osName,cType);
	},
	showReuploadWindow: function(scriptName,osName,cType)
	{
		var url = 'CorrectiveScript/data/EgRemoteUploadJson.jsp?mode=reupload&osName='+osName+'&scriptName='+scriptName;
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			timeout: 120000,
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJsonData = jsonData;
					Ext.widget('window', {
						title: modifyTitleMsg,
						width: 550,
						id: 'file',
						name: 'file',
						resizable: 'false',
						modal:true,
						listeners : {
						},
						dockedItems: [
							{
								dock: 'bottom',
								layout:{
									type:'hbox',
									align:'stretch',
									pack:'center'
								},
								border:false,
								padding : '10 10 5 10',
								items: [
									{
										xtype: 'button',
										text: label_Upload,
										cls: 'quickMenuWhiteButton',
										id: 'upload',
										name: 'upload',
										action: 'upload',
										width: 80,
										handler: function (button, e)
										{
											var sub = true;
											var fileName = Ext.getCmp('uploadform').getForm().findField('file1').getValue();
											var strOSName = Ext.getCmp('uploadform').getForm().findField('agentOS').getValue();

											if (Ext.isEmpty(strOSName) || strOSName == '-1')
											{
												Ext.Msg.show({
													title: pageName,
													msg: alertMsg1,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('agentOS').focus();
													}
												});
												sub = false;
												return;
											}

											if(!validateSingleByte(fileName))
											{
												Ext.Msg.show({
													title: pageName,
													msg: dblName,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('file1').focus();
													}
												});
												sub = false;
												return;
											}

											if(fileName=="")
											{
												Ext.Msg.show({
													title: pageName,
													msg: nofileselect,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('file1').focus();
													}
												});
												sub = false;
												return;
											}
											else
												sub = true;

											//var fileNameNoExtension="";
											//if(fileName.indexOf("\\")> -1)
												//filename = fileName.substring(fileName.lastIndexOf("\\")+1,fileName.length);
											//else if(fileName.indexOf("/")> -1)
												//filename = fileName.substring(fileName.lastIndexOf("/")+1,fileName.length);
											//else
												//filename = fileName;

											var agentOS = strOSName.toUpperCase();
											var check = true;
											var exten_str="";
											var exten_idx = fileName.lastIndexOf(".");
											if(exten_idx > 0)
												exten_str = fileName.substring(exten_idx);
											exten_str = exten_str.toLowerCase();
											var exten_List = new Array(".exe",".bat",".com",".cmd",".vbs",".ps1");
											if((agentOS.indexOf("WINDOWS") == -1))
												exten_List =  new Array(".sh",".ksh",".perl",".pl");
											for(i=0;i<exten_List.length;i++)
											{
												if(exten_List[i] == exten_str)
												{
													check = false;
													break;
												}
											}

											if(check)
											{
												sub = false;
												if(agentOS.indexOf("WINDOWS") != -1)
												{
													Ext.Msg.show({
														title: pageName,
														msg: alert_upload1,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('file1').focus();
														}
													});
												}
												else
												{
													Ext.Msg.show({
														title: pageName,
														msg: alert_upload2,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('file1').focus();
														}
													});
												}
											}

											if(sub)
											{
											
												if (!Ext.isEmpty(scriptName))
												{
													var formObj = Ext.getCmp('uploadform');
													formObj.add({
														xtype: 'hidden',
														name: 'scriptFileToDelete',
														value: scriptName
													});
													var temp = "";
													if (scriptName.indexOf("_") == -1)
													{
														temp = uploadFileMsg + '. ' +uploadFileMsg2; 
													}
													else 
													{
														temp = uploadFileMsg1 + '. ' +uploadFileMsg2;
													}

													Ext.Msg.show(
													{
														title: pageName,
														msg: temp,
														buttons: Ext.MessageBox.YESNO,
														icon: 'iconConfirmation',
														fn: function(btn) 
														{
															if (btn == 'yes')
															{
																var uploadform = Ext.getCmp('uploadform').getForm();
																if (uploadform.isValid())
																{
																	var existMeasure = publicJsonData.internalMeasName;
																	Ext.getCmp('measureName').setValue(existMeasure);
																	uploadform.submit({
																		success: function (form, action) {
																			var jsonText = action.response.responseText;
																			publicUploadJson = Ext.decode(jsonText);
																			if (!Ext.isEmpty(publicUploadJson.uploadScriptStatus) && publicUploadJson.uploadScriptStatus == 'true')
																			{
																				Ext.Msg.show({
																					title: pageName,
																					msg: alert4,
																					width: 350,
																					buttons: Ext.Msg.OK,
																					icon: 'iconInformation',
																					fn: function() 
																					{
																						if (cType == 'All')
																						{
																							me.afterMainRender();
																						}
																						else
																						{
																							me.rebuildGridUsingCompType(cType);
																						}
																					}
																				});
																				button.up('.window').close();
																			}
																		},
																		failure: function (form, action) {
																			Ext.Msg.show({
																				title: pageName,
																				msg: 'FAILURE',
																				buttons: Ext.Msg.OK,
																				icon: 'iconExclamation'
																			});
																		}
																	});
																}
															}
														}
													});
												}
											}
										}
									}
								]
							}
						],
						items: [
							{
								xtype: 'form',
								id: 'uploadform',
								name: 'uploadform',
								border: false,
								url: '../servlet/com.eg.EgUploadServlet',
								params: {
									isCorrectiveActionsExt: 'reupload',
									scriptFileToDelete: scriptName
								},
								height: 165,
								layout: {
									type: 'vbox',
									pack: 'center',
									align: 'center'
								},
								defaults: {
									labelSeparator: '',
									margin: 5,
									width: 470,
									labelWidth: 200
								},
								items: [
									{
										xtype: 'textfield',
										id : 'agentOS',
										name: 'agentOS',
										cls: 'textbox',
										fieldLabel: label4,
										value: '',
										readOnly:true,
										labelSeparator: ' ',
										margin: '10 5 5 5'
									},
									{
										xtype: 'textfield',
										id : 'testName',
										name: 'testName',
										cls: 'textbox',
										fieldLabel: label6,
										value: '',
										readOnly: true,
										labelSeparator: ' '
									},
									{
										xtype: 'textfield',
										id : 'measureName',
										name: 'measureName',
										cls: 'textbox',
										fieldLabel: label9,
										value: '',
										readOnly: true,
										labelSeparator: ' '
									},
									{
										xtype: 'textfield',
										id : 'existMeasure',
										name: 'existMeasure',
										cls: 'textbox',
										fieldLabel: label8,
										value: '',
										readOnly:true,
										labelSeparator: ' '
									},
									{
										xtype: 'fileuploadfield',
										cls: 'fileupload',
										id: 'file1',
										name: 'file1',
										labelSeparator: '',
										margin: '5 5 10 5',
										emptyText: emptyMsg,
										fieldLabel: label_Load,
										buttonText: 'Browse'
									}
								],
								listeners: {
									afterrender: function () {
										me.windowupload('reupload');
									}
								}
							}
						],
						listeners: {
							afterrender: function() {
								me.reuploadWindowRender();
							}
						}
					}).show()
				}
			}
		});
	},
	handleDeleteIconClick: function(testName, script, osName, dispName, cType)
	{
		var deleteScriptName = script;
		var dispScriptName = dispName;
		var osName = osName;
		//var osName = DispValues.get('OsName');
		Ext.Msg.show({
			title: pageName,
			msg: deleteConfirmAlert+" ?",
			buttons: Ext.MessageBox.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'yes')
				{
					Ext.Ajax.request({
						url:'CorrectiveScript/data/EgCorrectiveScriptsJson.jsp?mode=single&deleteScriptFile=true&scriptName='+deleteScriptName+"&osName="+osName,
						method:'POST',
						timeout: 120000,
						async : false,
						scope:this,
						success:function(response)
						{
							Ext.Msg.show({
								title: pageName,
								msg: alert1,
								buttons: Ext.Msg.OK,
								width: alert1.length * 7,
								icon: 'iconInformation',
								fn: function() {
									if (cType == 'All')
									{
										me.afterMainRender();
									}
									else
									{
										me.rebuildGridUsingCompType(cType);
									}
								}
							});
						}
					});
				}
			}
		});
	},
	handleDeleteSelected: function() 
	{
		var record = Ext.getCmp('infoGrid').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var OSArray=new Array();
		var selectedScripts="";
		var selectedOSNames="";
		if(record == "")
		{
			Ext.Msg.show({
				title: pageName,
				msg: noDeleteScriptFileAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}

		for(var i=0; i < record.length ; i++)
		{
			values=record[i];
			id=values.get('Script');
			OSName=values.get('OsName');

			if(id!=null)
			{
				array.push(id);
			}

			if(!Ext.isEmpty(OSName))
			{
				OSArray.push(OSName);
			}
		}

		for(var j=0; j < array.length; j++)
		{
			selectedScripts +=array[j]+",";
		}

		for(var os=0; os < OSArray.length; os++)
		{
			selectedOSNames +=OSArray[os]+",";
		}
		delete array;
		delete OSArray;
		
		if(selectedScripts != null && selectedScripts.length > 0 )
		{
			Ext.Msg.show({
				title: pageName,
				msg: deleteMultipleConfirmAlert,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(response) {
					if(response == 'yes')
					{
						if(selectedScripts.length > 1)
						{
							selectedScripts = selectedScripts.substring(0,selectedScripts.length-1);
						}

						if(selectedOSNames.length > 1)
						{
							selectedOSNames = selectedOSNames.substring(0,selectedOSNames.length-1);
						}
						Ext.Ajax.request({
							url:'CorrectiveScript/data/EgCorrectiveScriptsJson.jsp?mode=multiple&deleteScriptFile=true&scriptName='+selectedScripts+"&osName="+selectedOSNames,
							method:'POST',
							async : false,
							scope:this,
							timeout: 120000,
							success:function(response)
							{
								Ext.Msg.show({
									title: pageName,
									msg: alert3,
									width: 350,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									fn: function() {
										me.afterMainRender();
									}
								});
							}
						});
					}
				}
			});
		}
	},
	afterMainRender: function()
	{
		var searchVal = Ext.getCmp('searchTrigger').getValue();
		if (searchVal != null && !Ext.isEmpty(searchVal))
		{
			Ext.getCmp('searchTrigger').reset();
		}
		Ext.getCmp('searchTrigger').setDisabled(true);
		Ext.getCmp('infoGrid').hide();

		Ext.getCmp('backbutton').hide();
		if (!Ext.isEmpty(isBackBtn) && isBackBtn == 'true')
		{
			Ext.getCmp('backbutton').show();
		}

		Ext.Ajax.request({
			url: 'CorrectiveScript/data/EgCorrectiveScriptsJson.jsp?',
			method: 'POST',
			timeout: 120000,
			scope: this,
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var hasScriptFile = publicJson['hasScriptFile'];
					Ext.getCmp('infoGrid').show();

					var newGridDataArr = publicJson['newGridDataArr'];
					var compTypeArr = publicJson['compTypeArr'];
					if (!Ext.isEmpty(compTypeArr))
					{
						Ext.getCmp('filterCompType').getStore().suspendEvents(true);
						Ext.getCmp('filterCompType').getStore().removeAll();
						Ext.getCmp('filterCompType').getStore().loadRawData(compTypeArr);
						Ext.getCmp('filterCompType').setValue(compTypeArr[0].valueField);
						Ext.getCmp('filterCompType').getStore().resumeEvents();
					}

					componentRawData = newGridDataArr;

					var isDeleteButton = publicJson['isDeleteButton'];
					var isSearchBox = publicJson['isSearchBox'];

					if (!Ext.isEmpty(newGridDataArr))
					{
						Ext.getCmp('infoGrid').getStore().suspendEvents(true);
						Ext.getCmp('infoGrid').getStore().removeAll();
						Ext.getCmp('infoGrid').getStore().loadRawData(newGridDataArr);
						Ext.getCmp('infoGrid').getStore().resumeEvents();
					}
					if (hasScriptFile)
					{
						Ext.getCmp('searchTrigger').setDisabled(false);
						Ext.getCmp('infoGrid').getSelectionModel().deselectAll(true);
					}
					else
					{
						Ext.getCmp('searchTrigger').setDisabled(true);
					}
					
				}
			},
			failure: function()
			{
			}
		});
	},
	rebuildGridUsingCompType: function(obj)
	{
		if (typeof obj == 'object')
		{
			var strCompType = obj.getValue();
		}
		if (typeof obj == 'string')
		{
			var strCompType = obj;
		}
		
		var searchVal = Ext.getCmp('searchTrigger').getValue();
		if (searchVal != null && !Ext.isEmpty(searchVal))
		{
			Ext.getCmp('searchTrigger').reset();
		}
		Ext.getCmp('searchTrigger').setDisabled(true);
		Ext.getCmp('infoGrid').hide();

		Ext.getCmp('backbutton').hide();
		if (!Ext.isEmpty(isBackBtn) && isBackBtn == 'true')
		{
			Ext.getCmp('backbutton').show();
		}

		Ext.Ajax.request({
			url: 'CorrectiveScript/data/EgCorrectiveScriptsJson.jsp?compType='+strCompType,
			method: 'POST',
			timeout: 120000,
			scope: this,
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var hasScriptFile = publicJson['hasScriptFile'];
					Ext.getCmp('infoGrid').show();

					var newGridDataArr = publicJson['newGridDataArr'];
					componentRawData = newGridDataArr;

					var isDeleteButton = publicJson['isDeleteButton'];
					var isSearchBox = publicJson['isSearchBox'];

					Ext.getCmp('infoGrid').getStore().removeAll();
					if (!Ext.isEmpty(newGridDataArr))
					{
						Ext.getCmp('infoGrid').getStore().loadRawData(newGridDataArr);
						Ext.getCmp('infoGrid').getView().features[0].expandAll();
						Ext.getCmp('collExpandBtn').setIconCls('iconCollapseAll')
					}
					else
					{
						Ext.getCmp('infoGrid').store.loadData('');
						Ext.getCmp('infoGrid').getView().emptyText = '<table align="center"><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText" id="userDeferMessage">'+alert5+'</td></tr></table></td></tr></table>';
						Ext.getCmp('infoGrid').getView().refresh();

					}

					if (hasScriptFile)
					{
						Ext.getCmp('searchTrigger').setDisabled(false);
					}
					else
					{
						Ext.getCmp('searchTrigger').setDisabled(true);
					}
					
				}
			},
			failure: function()
			{
			}
		});
	},
	getGridSearchData : function(obj)
	{
		this.filterGrid(obj.getValue());
	},
	filterGrid : function(value)
	{
		if (value == "" || value.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		var userdetailsgrid = Ext.getCmp('infoGrid');
		if (value == "" || value.length == 0)
		{
			userdetailsgrid.getStore().clearFilter();
		}
		else
		{
			userdetailsgrid.getStore().clearFilter();
			//userdetailsgrid.getStore().filter("UserName",value);
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					var testName = item.get('TestName');
					var dispName = publicJson.displayTestJsonObj[testName];
					if (dispName.toLowerCase().indexOf(value.toLowerCase()) != -1)
					{
						return true
					}
				}
			});
			userdetailsgrid.getStore().filter(userFilter);
		}

		if (userdetailsgrid.getStore().getCount() == 0)
		{
			Ext.get('userDeferMessage').update(NoScriptFileSearch+".");
		}
		this.getMain().doLayout();
	},
	showFileUploadWindow: function()
	{
		var url = 'CorrectiveScript/data/EgRemoteUploadJson.jsp?';
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			timeout: 120000,
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var strScriptFile ='';
					publicJsonData = jsonData;
					Ext.widget('window', {
						title: addTitleMsg,
						width: 550,
						id: 'file',
						name: 'file',
						resizable: 'false',
						modal:true,
						listeners : {
						},
						dockedItems: [
							{
								dock: 'bottom',
								layout:{
									type:'hbox',
									align:'stretch',
									pack:'center'
								},
								border:false,
								padding : '10 10 5 10',
								items: [
									{
										xtype: 'button',
										text: label_Upload,
										cls: 'quickMenuWhiteButton',
										id: 'upload',
										name: 'upload',
										action: 'upload',
										width: 80,
										handler: function (button, e)
										{
											var sub = true;
											var fileName = Ext.getCmp('uploadform').getForm().findField('file1').getValue();
											var strOSName = Ext.getCmp('uploadform').getForm().findField('agentOS').getValue();
											var strCompType = Ext.getCmp('uploadform').getForm().findField('compType').getValue();
										
											var strMesureName = Ext.getCmp('uploadform').getForm().findField('measureName').getValue();
											
											var strTestName = Ext.getCmp('uploadform').getForm().findField('testName').getValue();

											if (Ext.isEmpty(strOSName) || strOSName == '-1')
											{
												Ext.Msg.show({
													title: pageName,
													msg: alertMsg1,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('agentOS').focus();
													}
												});
												sub = false;
												return;
											}

											if (Ext.isEmpty(strCompType) || strCompType == '-1')
											{
												Ext.Msg.show({
													title: pageName,
													msg: alertMsg2,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('compType').focus();
													}
												});
												sub = false;
												return;
											}

											if (Ext.isEmpty(strTestName) || strTestName == '-1')
											{
												Ext.Msg.show({
													title: pageName,
													msg: alertMsg3,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('testName').focus();
													}
												});
												sub = false;
												return;
											}

											if(!validateSingleByte(fileName))
											{
												Ext.Msg.show({
													title: pageName,
													msg: dblName,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('file1').focus();
													}
												});
												sub = false;
												return;
											}

											if(fileName=="")
											{
												Ext.Msg.show({
													title: pageName,
													msg: nofileselect,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('file1').focus();
													}
												});
												sub = false;
												return;
											}
											else
												sub = true;

											//var fileNameNoExtension="";
											//if(fileName.indexOf("\\")> -1)
												//filename = fileName.substring(fileName.lastIndexOf("\\")+1,fileName.length);
											//else if(fileName.indexOf("/")> -1)
												//filename = fileName.substring(fileName.lastIndexOf("/")+1,fileName.length);
											//else
												//filename = fileName;

											var agentOS = strOSName.toUpperCase();
											var check = true;
											var exten_str="";
											var exten_idx = fileName.lastIndexOf(".");
											if(exten_idx > 0)
												exten_str = fileName.substring(exten_idx);
											exten_str = exten_str.toLowerCase();
											var exten_List = new Array(".exe",".bat",".com",".cmd",".vbs",".ps1");
											if((agentOS.indexOf("WINDOWS") == -1))
												exten_List =  new Array(".sh",".ksh",".perl",".pl");
											for(i=0;i<exten_List.length;i++)
											{
												if(exten_List[i] == exten_str)
												{
													check = false;
													break;
												}
											}

											if(check)
											{
												sub = false;
												if((agentOS.indexOf("WINDOWS") != -1))
												{
													Ext.Msg.show({
														title: pageName,
														msg: alert_upload1,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('file1').focus();
														}
													});
												}
												else
												{
													Ext.Msg.show({
														title: pageName,
														msg: alert_upload2,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('file1').focus();
														}
													});
												}
											}

											if(sub)
											{
												var indexVal = fileName.lastIndexOf('.');
												var fileLen = fileName.length;
												var subStr = fileName.substring(indexVal, fileLen);
												var strUploadFile = strMesureName+''+subStr;
												
												var allOsRelatedFiles = publicJson['allOsRelatedFiles'][strOSName];
												

												for (var i=0; i<allOsRelatedFiles.length; i++)
												{
													var osRelatedFileName = allOsRelatedFiles[i];
													var indexValue = osRelatedFileName.lastIndexOf('.');
													var fileSubStr = osRelatedFileName.substring(0, indexValue);
													if (strMesureName === fileSubStr)
													{
														strScriptFile = osRelatedFileName;
													}
												}
												
												if (!Ext.isEmpty(strScriptFile))
												{
													var formObj = Ext.getCmp('uploadform');
													formObj.add({
														xtype: 'hidden',
														name: 'scriptFileToDelete',
														value: strScriptFile
													});
													var temp = "";
													
													if (strScriptFile.indexOf("_") == -1)
													{
														temp = uploadFileMsg + '. ' +uploadFileMsg2; 
													}
													else 
													{
														temp = uploadFileMsg1 + '. ' +uploadFileMsg2;
													}

													Ext.Msg.show(
													{
														title: pageName,
														msg: temp,
														buttons: Ext.MessageBox.YESNO,
														icon: 'iconConfirmation',
														fn: function(btn) 
														{
															if (btn == 'yes')
															{
																var uploadform = Ext.getCmp('uploadform').getForm();
																if (uploadform.isValid())
																{
																	uploadform.submit({
																		success: function (form, action) {
																			var jsonText = action.response.responseText;
																			publicUploadJson = Ext.decode(jsonText);
																			if (!Ext.isEmpty(publicUploadJson.uploadScriptStatus) && publicUploadJson.uploadScriptStatus == 'true')
																			{
																				button.up('.window').close();
																				Ext.Msg.show({
																					title: pageName,
																					msg: alert2,
																					buttons: Ext.Msg.OK,
																					icon: 'iconInformation',
																					fn: function() {
																						me.afterMainRender();
																					}
																				});
																			}
																		},
																		failure: function (form, action) {
																			Ext.Msg.show({
																				title: pageName,
																				msg: 'FAILURE',
																				buttons: Ext.Msg.OK,
																				icon: 'iconExclamation'
																			});
																		}
																	});
																}
															}
														}
													});
												}
												else 
												{
													var uploadform = Ext.getCmp('uploadform').getForm();
													if (uploadform.isValid())
													{
														uploadform.submit({
															success: function (form, action) {
																var jsonText = action.response.responseText;
																publicUploadJson = Ext.decode(jsonText);
																if (!Ext.isEmpty(publicUploadJson.uploadScriptStatus) && publicUploadJson.uploadScriptStatus == 'true')
																{
																	button.up('.window').close();
																	Ext.Msg.show({
																		title: pageName,
																		msg: alert2,
																		buttons: Ext.Msg.OK,
																		icon: 'iconInformation',
																		fn: function() {
																			me.afterMainRender();
																		}
																	});
																}
															},
															failure: function (form, action) {
																Ext.Msg.show({
																	title: pageName,
																	msg: 'FAILURE',
																	buttons: Ext.Msg.OK,
																	icon: 'iconExclamation'
																});
															}
														});
													}
												}
											}
										}
									}
								]
							}
						],
						items: [
							{
								xtype: 'form',
								id: 'uploadform',
								name: 'uploadform',
								border: false,
								url: '../servlet/com.eg.EgUploadServlet',
								params: {
									isCorrectiveActionsExt: 'upload',
									scriptFileToDelete: strScriptFile
								},
								height: 165,
								layout: {
									type: 'vbox',
									pack: 'center',
									align: 'center'
								},
								defaults: {
									labelSeparator: '',
									margin: 5,
									width: 470,
									labelWidth: 200
								},
								items: [
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'agentOS',
										name: 'agentOS',
										fieldLabel: label4,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: '',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										}),
										margin: '10 5 5 5'
									},
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'compType',
										name: 'compType',
										fieldLabel: label5,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: '',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										}),
										listeners:{
											select : function() {
												me.selectComponentEvent(this);
											}
										}
									},
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'testName',
										name: 'testName',
										fieldLabel: label6,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: 'Test1',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										}),
										listeners: {
											select : {
												fn: function() {
													me.selectTestNameEvent(this);
												}
											}
										}
									},
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'measureName',
										name: 'measureName',
										fieldLabel: label7,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: '',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										})
									},
									{
										xtype: 'fileuploadfield',
										cls: 'fileupload',
										id: 'file1',
										name: 'file1',
										labelSeparator: '',
										emptyText: emptyMsg,
										fieldLabel: label_Load,
										buttonText: 'Browse',
										margin: '5 5 10 5'
									}
								],
								listeners: {
									afterrender: function () {
										me.windowupload('upload');
									}
								}
							}
						],
						listeners: {
							afterrender: function() {
								me.uploadWindowRender();
							}
						}
					}).show()
				}
			}
		});
	},
	selectComponentEvent: function(obj)
	{
		var compType = obj.getValue();
		var url = 'CorrectiveScript/data/EgRemoteUploadJson.jsp?compType='+compType;
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			scope: this,
			timeout: 120000,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJsonData = jsonData;

					var testNameArr = publicJsonData['testNameArr'];
					var measNameArr = publicJsonData['measNameArr'];

					var testNameObj = Ext.getCmp('testName');
					var measNameObj = Ext.getCmp('measureName');

					testNameObj.getStore().loadRawData(testNameArr);
					var selectedTestName = publicJson['selectedTestName'];

					if (!Ext.isEmpty(selectedTestName))
					{
						testNameObj.setValue(selectedTestName);
					}
					else
					{
						testNameObj.setValue(testNameArr[0].valueField);
						measNameObj.getStore().loadRawData(measNameArr);
						measNameObj.setValue(measNameArr[0].valueField);
					}
				}
			},
			failure: function() {
			},
		});
	}, 
	selectTestNameEvent: function(obj)
	{
		var testName = obj.getValue();
		var compType = Ext.getCmp('compType').getValue();
		var url = 'CorrectiveScript/data/EgRemoteUploadJson.jsp?compType='+compType+'&testName='+testName;
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			scope: this,
			timeout: 120000,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJsonData = jsonData;

					var measNameArr = publicJsonData['measNameArr'];
					var measNameObj = Ext.getCmp('measureName');

					var selectedTestName = publicJsonData['selectedTestName'];
					var displayTestName = publicJsonData['displayTestName'];

					measNameObj.getStore().loadRawData(measNameArr);
					if (!Ext.isEmpty(selectedTestName) && selectedTestName != '-1')
					{
						measNameObj.setValue(selectedTestName);
					}
					else
					{
						measNameObj.setValue(measNameArr[0].valueField);
					}
				}
			},
			failure: function() {
			}
		});
	},
	reuploadWindowRender: function()
	{
		var OSNameObj = Ext.getCmp('agentOS');
		var testNameObj = Ext.getCmp('testName');
		var existMeasNameObj = Ext.getCmp('existMeasure');
		var measNameObj = Ext.getCmp('measureName');

		var selectOS = publicJsonData['selectedOSName'];
		if (!Ext.isEmpty(selectOS))
		{
			OSNameObj.setValue(selectOS);
		}

		var existTestName = publicJsonData['existTestName'];
		if (!Ext.isEmpty(existTestName))
		{
			testNameObj.setValue(existTestName);
		}

		var existScriptName = publicJsonData['existScriptName'];
		if (!Ext.isEmpty(existScriptName))
		{
			existMeasNameObj.setValue(existScriptName);
		}
		
		var measureName = publicJsonData['measureName'];
		if (!Ext.isEmpty(measureName))
		{
			measNameObj.setValue(measureName);
		}
	},
	uploadWindowRender: function()
	{
		var compTypeArr = publicJsonData['compTypeArr'];
		var testNameArr = publicJsonData['testNameArr'];
		var osNameArr = publicJsonData['osNameArr'];
		var measNameArr = publicJsonData['measNameArr'];

		var compTypeObj = Ext.getCmp('compType');
		var testNameObj = Ext.getCmp('testName');
		var OSNameObj = Ext.getCmp('agentOS');
		var measNameObj = Ext.getCmp('measureName');

		OSNameObj.getStore().loadRawData(osNameArr);
		if (!Ext.isEmpty(osNameArr))
		{
			OSNameObj.setValue(osNameArr[0].valueField);
		}
		compTypeObj.getStore().loadRawData(compTypeArr);
		if (!Ext.isEmpty(compTypeArr))
		{
			compTypeObj.setValue(compTypeArr[0].valueField);
		}
		testNameObj.getStore().loadRawData(testNameArr);
		if (!Ext.isEmpty(testNameArr))
		{
			testNameObj.setValue(testNameArr[0].valueField);
		}
		measNameObj.getStore().loadRawData(measNameArr);
		if (!Ext.isEmpty(measNameArr))
		{
			measNameObj.setValue(measNameArr[0].valueField);
		}
	},
	windowupload: function (from) {
		var me = Ext.getCmp('uploadform');
		var a = me.getForm();
		var prevFileNameObj = me.down("#existMeasure");

		if (!Ext.isEmpty(from))
		{
			me.add({
				xtype: 'hidden',
				name: 'isCorrectiveActionsExt',
				value: from
			});
		}
		
		if (!Ext.isEmpty(from))
		{
			me.add({
				xtype: 'hidden',
				name: 'existMeasure',
				value: prevFileNameObj
			});
		}
		var hiddenParams = publicJsonData.hiddenParams;
		for (var hiddenParam in hiddenParams) {
			if (!a.findField("'" + hiddenParam + "'")) {
				me.add({
					xtype: 'hidden',
					name: hiddenParam,
					value: hiddenParams[hiddenParam]
				});
			} else {
				a.findField("'" + hiddenParam + "'").setValue(hiddenParams[hiddenParam]);
			}
		}
	},

	showEnableCorrectiveScript: function() 
	{
		var searchVal = Ext.getCmp('searchTrigger').getValue();
		if (searchVal != null && !Ext.isEmpty(searchVal))
		{
			Ext.getCmp('searchTrigger').reset();
		};
		Ext.getCmp("csViewport").removeAll();
		this.getController("CorrectiveScript.controller.EnableCS").buildFieldData();
		Ext.getCmp("csViewport").add({
		    xtype: "enablecorrectivescripttests"
		});
		this.getController("CorrectiveScript.controller.EnableCS").afterMainRenderCs("button");
	},
	
	CsBackButton: function()
	{
		Ext.getCmp('csViewport').removeAll();
		Ext.getCmp('csViewport').add({
		    xtype: 'main'
		});
	},

	comboLoad: function() 
	{
		var h = Ext.getCmp('compType').getValue();
		var g = "componentType=" + encodeURIComponent(h);
		Ext.Ajax.request({
			url: "CorrectiveScript/data/EgEnableCorrectiveScriptsJson.jsp?" + g,
			method: "POST",
			timeout: 120000,
			success: function(c) 
			{
				if (c.status == 200 && !Ext.isEmpty(c.responseText)) 
				{
					var b = c.responseText;
					publicJSON = Ext.decode(b);
				}
				var a = publicJSON['NoTestAvailable'];
				if (h != -1 && typeof a != "undefined") 
				{
					Ext.getCmp('NoTestsAvailable').show();
					Ext.getCmp('itemselectTests').hide();
					Ext.getCmp('UpdateBTN').hide();
				} 
				else 
				{
					Ext.getCmp('NoTestsAvailable').hide();
					Ext.getCmp('itemselectTests').show();
					Ext.getCmp('UpdateBTN').show();

					var tmpStore = Ext.getCmp('itemselectTests')
					if (tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if (tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (h != -1 )
					{
						Ext.getCmp('itemselectTests').fromField.store.add(publicJSON['allEnabledCorrectiveScriptTests']);
						Ext.getCmp("itemselectTests").toField.store.add(publicJSON['noCorrectiveTestsArr']);
						fromFieldTestsArray = publicJSON['associatedTests'];
						toFieldTestsArray = publicJSON['availableTests'];
					}
				}
			}
		});
	},
	
	updation: function()
	{
		var componentType = Ext.getCmp('compType').getValue();
		if (componentType == -1)
		{
			Ext.Msg.show(
			{
				title : pageTitle,
				msg : chooseComponentType,
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				width : 300
			});
		}
		else
		{
			var updateUrl = publicJSON['updateUrl'];
			var fromFieldTestsArray = publicJSON['associatedTests'];
			var toFieldTestsArray = publicJSON['availableTests'];
			var associatedTestsCount = Ext.getCmp('itemselectTests').fromField.store.getCount();
			var availableTestsCount = Ext.getCmp('itemselectTests').toField.store.getCount();
			var tempAssociatedArray = new Array();
			var flagAssociated = false;
			if (associatedTestsCount > 0)
			{
				for(var i=0; i<associatedTestsCount; i++)
				{
					var temp = Ext.getCmp('itemselectTests').fromField.store.getAt(i).get('valueField');
					if(fromFieldTestsArray.indexOf(temp) == -1)
					{
						flagAssociated = true;
						tempAssociatedArray.push(temp);
					}
				}
			}
			var associatedTests = tempAssociatedArray.toString();
			var availableTestsArray = new Array(); 
			var flagAvailable = false;
			if (availableTestsCount > 0)
			{
				for(var i=0; i<availableTestsCount; i++)
				{
					var temp = Ext.getCmp('itemselectTests').toField.store.getAt(i).get('valueField');
					if(toFieldTestsArray.indexOf(temp) == -1)
					{
						flagAvailable = true;
						availableTestsArray.push(temp);
					}
				}
			}
			var availableTests = availableTestsArray.toString();
			if (flagAssociated || flagAvailable)
			{
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
				myMask.show();
				var isConfigSupported = publicJSON['isConfigSupported'];
				var result = updateUrl + "&componentType=" + encodeURIComponent(componentType);
				Ext.Ajax.request({
					url: result,
					params: {
						associatedTests : associatedTests,
						availableTests : availableTests,
					},
					timeout: 6000000,
					method: 'POST',
					success: function( response )
					{
						myMask.hide();
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						if (!Ext.isEmpty( jsonText ) && response.status == 200 )
						{
							var resultStatus = publicJSON['requestStatus'];
							if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
							{
								Ext.MessageBox.show(
								{
									title : publicJSON['result']['title'],
									msg : publicJSON['result']['message1'],
									icon : 'iconInformation',
									buttons : Ext.Msg.OK,
									width : 300,
									fn : function(btn)
									{
										var qrrString = "componentType="+encodeURIComponent(componentType);
										
										Ext.Ajax.request({
											url: 'CorrectiveScript/data/EgEnableCorrectiveScriptsJson.jsp?'+qrrString,
											method: 'POST',
											timeout: 120000,
											success: function( response )
											{
												if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
												{
													var jsonText = response.responseText;
													publicJSON = Ext.decode( jsonText );
												}
												Ext.getCmp('itemselectTests').show();
												var tmpStore = Ext.getCmp('itemselectTests')
												if(tmpStore.fromField.store.getCount() > 0)
												{
													tmpStore.fromField.store.removeAll();
												}
												if(tmpStore.toField.store.getCount() > 0)
												{
													tmpStore.toField.store.removeAll();
												}
												Ext.getCmp('itemselectTests').fromField.store.add(publicJSON['allEnabledCorrectiveScriptTests']);
												Ext.getCmp('itemselectTests').toField.store.add(publicJSON['noCorrectiveTestsArr']);
											}
										});
									}
								});
							}
						}
					}
				});
			}
			else
			{
				Ext.MessageBox.show(
				{
					title : pageTitle,
					msg : chooseAnyOneTest,
					icon : 'iconInformation',
					buttons : Ext.Msg.OK,
					width : 300
				});
			}
		}
	},

	fileUploadWindow: function(event,tName)
	{
		event.stopPropagation();
		var InfogridState = Ext.getCmp('infoGrid');
		 if (InfogridState != null && InfogridState != 'undefined') { 
		 	if(InfogridState.getView().collapsible == true){
		 	}
		 }
		var url = 'CorrectiveScript/data/EgRemoteUploadJson.jsp?';
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			timeout: 120000,
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var strScriptFile ='';
					publicJsonData = jsonData;
					Ext.widget('window', {
						title: addTitleMsg,
						width: 550,
						id: 'file',
						name: 'file',
						resizable: 'false',
						modal:true,
						listeners : {
						},
						dockedItems: [
							{
								dock: 'bottom',
								layout:{
									type:'hbox',
									align:'stretch',
									pack:'center'
								},
								border:false,
								padding : '10 10 5 10',
								items: [
									{
										xtype: 'button',
										text: label_Upload,
										cls: 'quickMenuWhiteButton',
										id: 'upload',
										name: 'upload',
										action: 'upload',
										width: 80,
										handler: function (button, e)
										{
											var sub = true;
											var fileName = Ext.getCmp('uploadform').getForm().findField('file1').getValue();
											var strOSName = Ext.getCmp('uploadform').getForm().findField('agentOS').getValue();
											var strCompType = Ext.getCmp('uploadform').getForm().findField('compType').getValue();
											var strMesureName = Ext.getCmp('uploadform').getForm().findField('measureName').getValue();
											var strTestName = Ext.getCmp('uploadform').getForm().findField('testName').getValue();
											strScriptFile = '';

											if (Ext.isEmpty(strOSName) || strOSName == '-1')
											{
												Ext.Msg.show({
													title: pageName,
													msg: alertMsg1,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('agentOS').focus();
													}
												});
												sub = false;
												return;
											}

											if (Ext.isEmpty(strCompType) || strCompType == '-1')
											{
												Ext.Msg.show({
													title: pageName,
													msg: alertMsg2,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('compType').focus();
													}
												});
												sub = false;
												return;
											}

											if (Ext.isEmpty(strTestName) || strTestName == '-1')
											{
												Ext.Msg.show({
													title: pageName,
													msg: alertMsg3,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('testName').focus();
													}
												});
												sub = false;
												return;
											}

											if(!validateSingleByte(fileName))
											{
												Ext.Msg.show({
													title: pageName,
													msg: dblName,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('file1').focus();
													}
												});
												sub = false;
												return;
											}

											if(fileName=="")
											{
												Ext.Msg.show({
													title: pageName,
													msg: nofileselect,
													buttons: Ext.Msg.OK,
													icon: 'iconExclamation',
													fn: function() {
														Ext.getCmp('file1').focus();
													}
												});
												sub = false;
												return;
											}
											else
												sub = true;

											//var fileNameNoExtension="";
											//if(fileName.indexOf("\\")> -1)
												//filename = fileName.substring(fileName.lastIndexOf("\\")+1,fileName.length);
											//else if(fileName.indexOf("/")> -1)
												//filename = fileName.substring(fileName.lastIndexOf("/")+1,fileName.length);
											//else
												//filename = fileName;

											var agentOS = strOSName.toUpperCase();
											var check = true;
											var exten_str="";
											var exten_idx = fileName.lastIndexOf(".");
											if(exten_idx > 0)
												exten_str = fileName.substring(exten_idx);
											exten_str = exten_str.toLowerCase();
											var exten_List = new Array(".exe",".bat",".com",".cmd",".vbs",".ps1");
											if((agentOS.indexOf("WINDOWS") == -1))
												exten_List =  new Array(".sh",".ksh",".perl",".pl");
											for(i=0;i<exten_List.length;i++)
											{
												if(exten_List[i] == exten_str)
												{
													check = false;
													break;
												}
											}

											if(check)
											{
												sub = false;
												if((agentOS.indexOf("WINDOWS") != -1))
												{
													Ext.Msg.show({
														title: pageName,
														msg: alert_upload1,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('file1').focus();
														}
													});
												}
												else
												{
													Ext.Msg.show({
														title: pageName,
														msg: alert_upload2,
														buttons: Ext.Msg.OK,
														icon: 'iconExclamation',
														fn: function() {
															Ext.getCmp('file1').focus();
														}
													});
												}
											}

											if(sub)
											{
												var indexVal = fileName.lastIndexOf('.');
												var fileLen = fileName.length;
												var subStr = fileName.substring(indexVal, fileLen);
												var strUploadFile = strMesureName+''+subStr;
												var allOsRelatedFiles = publicJson['allOsRelatedFiles'][strOSName];

												for (var i=0; i<allOsRelatedFiles.length; i++)
												{
													var osRelatedFileName = allOsRelatedFiles[i];
													var indexValue = osRelatedFileName.lastIndexOf('.');
													var fileSubStr = osRelatedFileName.substring(0, indexValue);
													if (strMesureName === fileSubStr)
													{
														strScriptFile = osRelatedFileName;
													}
												}
												if (!Ext.isEmpty(strScriptFile))
												{
													var temp = "";
													
													if (strScriptFile.indexOf("_") == -1)
													{
														temp = uploadFileMsg + '. ' +uploadFileMsg2;
													}
													else 
													{
														temp = uploadFileMsg1 + '. ' +uploadFileMsg2;
													}

													Ext.Msg.show(
													{
														title: pageName,
														msg: temp,
														buttons: Ext.MessageBox.YESNO,
														icon: 'iconConfirmation',
														fn: function(btn) 
														{
															if (btn == 'yes')
															{
																var formObj = Ext.getCmp('uploadform');
																formObj.add({
																	xtype: 'hidden',
																	name: 'scriptFileToDelete',
																	value: strScriptFile
																});
																var uploadform = Ext.getCmp('uploadform').getForm();
																if (uploadform.isValid())
																{
																	uploadform.submit({
																		success: function (form, action) {
																			var jsonText = action.response.responseText;
																			publicUploadJson = Ext.decode(jsonText);
																			if (!Ext.isEmpty(publicUploadJson.uploadScriptStatus) && publicUploadJson.uploadScriptStatus == 'true')
																			{
																				button.up('.window').close();
																				Ext.Msg.show({
																					title: pageName,
																					msg: alert2,
																					buttons: Ext.Msg.OK,
																					icon: 'iconInformation',
																					fn: function() 
																					{
																						if (strCompType == 'All')
																						{
																							me.afterMainRender();
																						}
																						else
																						{
																							me.rebuildGridUsingCompType(strCompType);
																						}
																					}
																				});
																			}
																		},
																		failure: function (form, action) {
																			Ext.Msg.show({
																				title: pageName,
																				msg: 'FAILURE',
																				buttons: Ext.Msg.OK,
																				icon: 'iconExclamation'
																			});
																		}
																	});
																}
															}
														}
													});
												}
												else 
												{
													var uploadform = Ext.getCmp('uploadform').getForm();
													if (uploadform.isValid())
													{
														uploadform.submit({
															success: function (form, action) {
																var jsonText = action.response.responseText;
																publicUploadJson = Ext.decode(jsonText);
																if (!Ext.isEmpty(publicUploadJson.uploadScriptStatus) && publicUploadJson.uploadScriptStatus == 'true')
																{
																	button.up('.window').close();
																	Ext.Msg.show({
																		title: pageName,
																		msg: alert2,
																		buttons: Ext.Msg.OK,
																		icon: 'iconInformation',
																		fn: function() 
																		{
																			if (strCompType == 'All')
																			{
																				me.afterMainRender();
																			}
																			else
																			{
																				me.rebuildGridUsingCompType(strCompType);
																			}
																		}
																	});
																}
															},
															failure: function (form, action) {
																Ext.Msg.show({
																	title: pageName,
																	msg: 'FAILURE',
																	buttons: Ext.Msg.OK,
																	icon: 'iconExclamation'
																});
															}
														});
													}
												}
											}
										}
									}
								]
							}
						],
						items: [
							{
								xtype: 'form',
								id: 'uploadform',
								name: 'uploadform',
								border: false,
								url: '../servlet/com.eg.EgUploadServlet',
								params: {
									isCorrectiveActionsExt: 'upload',
									scriptFileToDelete: strScriptFile
								},
								height: 165,
								layout: {
									type: 'vbox',
									pack: 'center',
									align: 'center'
								},
								defaults: {
									labelSeparator: '',
									margin: 5,
									width: 470,
									labelWidth: 200
								},
								items: [
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'compType',
										name: 'compType',
										fieldLabel: label5,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: '',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										}),
										listeners:{
											select : function() {
												me.selectComponentEvent(this);
											}
										}
									},
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'testName',
										name: 'testName',
										fieldLabel: label6,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: 'Test1',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										}),
										listeners: {
											select : {
												fn: function() {
													me.selectTestNameEvent(this);
												}
											}
										}
									},
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'measureName',
										name: 'measureName',
										fieldLabel: label7,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: '',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										})
									},
									{
										xtype: 'scrollcombo',
										cls: 'dropdown',
										id : 'agentOS',
										name: 'agentOS',
										fieldLabel: label4,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										value: '',
										editable: false,
										parent:this,
										labelSeparator: ' ',
										store:new Ext.data.Store({
											fields: ['displayField','valueField'],
											data: []
										}),
										margin: '10 5 5 5'
									},
									{
										xtype: 'fileuploadfield',
										cls: 'fileupload',
										id: 'file1',
										name: 'file1',
										labelSeparator: '',
										emptyText: emptyMsg,
										fieldLabel: label_Load,
										buttonText: 'Browse',
										margin: '5 5 10 5'
									}
								],
								listeners: {
									afterrender: function () {
										me.windowupload('upload');
									}
								}
							}
						],
						listeners: {
							afterrender: function() {
								if (!Ext.isEmpty(tName) && typeof tName == 'string')
								{
									me.fileUploadRender(tName);
								}
							}
						}
					}).show()
				}
			}
		});
	},

	fileUploadRender: function(testName)
	{
		var componentType = publicJson['compType'];
		var url = 'CorrectiveScript/data/EgRemoteUploadJson.jsp?componentType='+componentType+'&tName='+testName;
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			timeout: 120000,
			success: function (response) 
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJsonData = jsonData;
					var osNameArr = publicJsonData['osNameArr'];
					var componentTypeArr = publicJsonData['componentTypeArr'];
					var tNameArr = publicJsonData['tNameArr'];
					var compTypeObj = Ext.getCmp('compType');
					var testNameObj = Ext.getCmp('testName');
					var OSNameObj = Ext.getCmp('agentOS');
					var measNameObj = Ext.getCmp('measureName');

					OSNameObj.getStore().loadRawData(osNameArr);
					if (!Ext.isEmpty(osNameArr))
					{
						OSNameObj.setValue(osNameArr[0].valueField);
					}
					compTypeObj.getStore().loadRawData(componentTypeArr);
					if (!Ext.isEmpty(componentTypeArr))
					{
						compTypeObj.setReadOnly(true);
						compTypeObj.setValue(componentTypeArr[0].valueField);
					}
					testNameObj.getStore().loadRawData(tNameArr);
					if (!Ext.isEmpty(tNameArr))
					{
						testNameObj.setReadOnly(true);
						testNameObj.setValue(tNameArr[0].valueField);
					}
					me.loadMeaureNames(testName);
				}
			}
		});
	},

	loadMeaureNames: function(testName)
	{
		var url = 'CorrectiveScript/data/EgRemoteUploadJson.jsp?testName='+testName;
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			timeout: 120000,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					publicJsonData = jsonData;

					var measNameArr = publicJsonData['measNameArr'];
					var measNameObj = Ext.getCmp('measureName');
					measNameObj.getStore().loadRawData(measNameArr);
					if (!Ext.isEmpty(measNameArr))
					{
						measNameObj.setValue(measNameArr[0].valueField);
					}
				}
			},
			failure: function() {
			}
		});
	},

	 
	clickToEnableCorrectiveScripts: function(event,testName)
	{
		event.stopPropagation();
		var displayTestName = '';
		var newGridDataArr = publicJson['newGridDataArr'];
		var specificTestArr = publicJson['specificTestArr'];
		for (var x=0; x<newGridDataArr.length; x++)
		{
			var dataObj = newGridDataArr[x];
			var title = dataObj.title;
			var idx = title.indexOf(":");
			var tName = dataObj.TestName;
			if (tName == testName)
			{
				if (idx > -1)
				{
					displayTestName = title.substring(0, idx);
				}
				else
				{
					displayTestName = title;
				}
			}
		}
		var alertMsg = alertMsgEnableCs +' '+displayTestName+' '+alertMsgCs2+' '+alertMsgCs3+' '+alertMsgCs4;
		if (specificTestArr != null && specificTestArr != undefined)
		{
			for (var y=0; y<specificTestArr.length; y++)
			{
				var specificTest = specificTestArr[y];
				if (specificTest == testName)
				{
					alertMsg = alertMsgEnableCs +' '+displayTestName+' '+alertMsgCs2+' '+alertMsgCs4;
				}
			}
		}
		
		Ext.Msg.show(
			{
				title: enableDisableCsTitle,
				msg: alertMsg,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(btn) 
				{
					if (btn == 'yes')
					{
						var ctype = publicJson['compType'];
						Ext.Ajax.request({
							url:'CorrectiveScript/data/EgEnableDisableCorrectiveScriptspJson.jsp?compType='+encodeURIComponent(ctype)+'&testName='+encodeURIComponent(testName)+'&reqFrom=enableCsLink',
							method:'POST',
							timeout: 120000,
							success:function(response)
							{
								if(response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var jsonText = response.responseText;
									publicJsonDataObj = Ext.decode(jsonText);
									var requestStatus = publicJsonDataObj['requestStatus'];
									if (!Ext.isEmpty(requestStatus) && requestStatus != undefined)
									{
										Ext.Msg.show({
											title: enableDisableCsTitle,
											msg: alertMsgCsSuccess1,
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation',
											fn: function() {
												if (ctype == 'All')
												{
													me.afterMainRender();
												}
												else
												{
													me.rebuildGridUsingCompType(ctype);
												}
											}
										});
									}
								}
							}
						});
					}
				}
			}
		);
	},

	clickToDisableCorrectiveScripts: function(event,testName)
	{
		event.stopPropagation();
		var displayTestName = '';
		var newGridDataArr = publicJson['newGridDataArr'];
		var specificTestArr = publicJson['specificTestArr'];

		for (var x=0; x<newGridDataArr.length; x++)
		{
			var dataObj = newGridDataArr[x];
			var title = dataObj.title;
			var idx = title.indexOf(":");
			var tName = dataObj.TestName;
			if (tName == testName)
			{
				if (idx > -1)
				{
					displayTestName = title.substring(0, idx);
				}
				else
				{
					displayTestName = title;
				}
			}
		}
		var alertMsg = alertMsgDisableCs +' '+displayTestName+' '+alertMsgCs2+' '+alertMsgCs3+' '+alertMsgCs4; 
		if (specificTestArr !=null && specificTestArr !=undefined && specificTestArr.length > 0)
		{
			for (var x=0; x<specificTestArr.length; x++)
			{
				var specificTest = specificTestArr[x];
				if (specificTest == testName)
				{
					alertMsg = alertMsgDisableCs+' '+displayTestName+' '+alertMsgCs2+' '+alertMsgCs4;
				}
			}
		}
		Ext.Msg.show(
			{
				title: enableDisableCsTitle,
				msg: alertMsg,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(btn) 
				{
					if (btn == 'yes')
					{
						var ctype = publicJson['compType'];

						Ext.Ajax.request({
							url:'CorrectiveScript/data/EgEnableDisableCorrectiveScriptspJson.jsp?compType='+encodeURIComponent(ctype)+'&testName='+encodeURIComponent(testName)+'&reqFrom=disableCsLink',
							method:'POST',
							timeout: 120000,
							success:function(response)
							{
								if(response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var jsonText = response.responseText;
									publicJsonDataObj = Ext.decode(jsonText);
									var requestStatus = publicJsonDataObj['requestStatus'];
									if (!Ext.isEmpty(requestStatus) && requestStatus != undefined)
									{
										Ext.Msg.show({
											title: enableDisableCsTitle,
											msg: alertMsgCsSuccess2,
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation',
											fn:function() {
												if (ctype == 'All')
												{
													me.afterMainRender();
												}
												else
												{
													me.rebuildGridUsingCompType(ctype);
												}
											}
										});
									}
								}
							}
						});
					}
				}
			}
		);
	}
});



