Ext.define('CorrectiveScript.view.InfoGrid', {
	extend : 'utilities.CustomGrid',
	alias : 'widget.infogrid',
	cls:'gridSkin_expander',
	id:'infoGrid',
	store : new Ext.data.Store({
		fields:['title','TestName', 'isConfigured'],
		groupField: 'title',
		data : [],
		sortOnLoad : false // disables the default sorting of an extjs grid
	}),
	margin: 8,

	features: [{
		ftype: 'grouping',
		id : 'testWiseGrouping',
		groupHeaderTpl: [
			'{name:this.formatServerName}',
			{
				formatServerName: function(name) {
					var gridTitle = '';
					if (name.indexOf("BothCsAndScript") > -1)
					{
						var idx1 = name.indexOf("BothCsAndScript");
						var test_idx1 = name.indexOf(":");
						var displayName = name.substring(0,test_idx1);
						var orgTestName = name.substring(test_idx1+1,idx1);
						gridTitle = displayName+'<div class="button_div" style="position: absolute;z-index: 9; right:0px;"><div style="position:relative; top:-22px; margin-right:10px;" align="right"><a href="javascript:void(0);" onclick="me.clickToDisableCorrectiveScripts(event,\''+orgTestName+'\')"><img src="/final/images/clear.png" class="iconScriptEnable mouse"  data-qtip="Disable Corrective Script" style="vertical-align:middle;"/> </a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="javascript:void(0);" onclick="me.fileUploadWindow(event,\''+orgTestName+'\')"><img src="/final/images/clear.png" class="iconScriptUploadEnable mouse" data-qtip="Upload Corrective Script" style="vertical-align:middle;"/></a></div></div>';
					}
					else if (name.indexOf("CSEnabled") > -1)
					{
						var idx2 = name.indexOf("CSEnabled");
						var test_idx2 = name.indexOf(":");
						var displayName = name.substring(0,test_idx2);
						var orgTestName = name.substring(test_idx2+1,idx2);
						gridTitle = displayName+'<div class="button_div" style="position: absolute;z-index: 9; right:0px;"><div style="position:relative; top:-22px; margin-right:10px;" align="right"><a href="javascript:void(0);" onclick="me.clickToDisableCorrectiveScripts(event,\''+orgTestName+'\')"><img src="/final/images/clear.png" class="iconScriptEnable mouse"  data-qtip="Disable Corrective Script" style="vertical-align:middle;"/></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="javascript:void(0);" onclick="me.fileUploadWindow(event,\''+orgTestName+'\')"><img src="/final/images/clear.png" class="iconScriptUploadDisable mouse" data-qtip="Upload Corrective Script" style="vertical-align:middle;"/></a></div></div>';
					}
					else if (name.indexOf("CSNotEnabled") > -1)
					{
						var idx3 = name.indexOf("CSNotEnabled");
						var test_idx3 = name.indexOf(":");
						var displayName = name.substring(0,test_idx3);
						var orgTestName = name.substring(test_idx3+1,idx3);
						gridTitle = displayName+'<div class="button_div" style="position: absolute;z-index: 9; right:0px;"><div style="position:relative; top:-22px; margin-right:10px;" align="right"><a href="javascript:void(0);" onclick="me.clickToEnableCorrectiveScripts(event,\''+orgTestName+'\')"><img src="/final/images/clear.png" class="iconScriptDisable mouse"  data-qtip="Enable Corrective Script" style="vertical-align:middle;"/></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="javascript:void(0);" onclick="me.fileUploadWindow(event,\''+orgTestName+'\')"><img src="/final/images/clear.png" class="iconScriptUploadEnable mouse" data-qtip="Upload Corrective Script" style="vertical-align:middle;"/></a></div></div>';
					}
					else if (name.indexOf("NoCsAndNoScript") > -1)
					{
						var idx4 = name.indexOf("NoCsAndNoScript");
						var test_idx4 = name.indexOf(":");
						var displayName = name.substring(0, test_idx4);
						var orgTestName = name.substring(test_idx4+1, idx4);
						gridTitle = displayName+'<div class="button_div" style="position: absolute;z-index: 9; right:0px;"><div style="position:relative; top:-22px; margin-right:10px;" align="right"><a href="javascript:void(0);" onclick="me.clickToEnableCorrectiveScripts(event,\''+orgTestName+'\')"><img src="/final/images/clear.png" class="iconScriptDisable mouse"  data-qtip="Enable Corrective Script" style="vertical-align:middle;"/></a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="javascript:void(0);" onclick="me.fileUploadWindow(event,\''+orgTestName+'\')"><img src="/final/images/clear.png" class="iconScriptUploadDisable mouse" data-qtip="Upload Corrective Script" style="vertical-align:middle;"/></a></div></div>';
					}
					else if (name.indexOf("SpecTestHasScript") > -1)
					{
						var idx5 = name.indexOf("SpecTestHasScript");
						var test_idx5 = name.indexOf(":");
						var displayName = name.substring(0,test_idx5);
						var orgTestName = name.substring(test_idx5+1,idx5);
						gridTitle = displayName+'<div class="button_div" style="position: absolute;z-index: 9; right:0px;"><div style="position:relative; top:-22px; margin-right:10px;" align="right"><a href="javascript:void(0);" onclick="me.fileUploadWindow(event,\''+orgTestName+'\')"><img src="/final/images/clear.png" class="iconScriptUploadEnable mouse" data-qtip="Upload Corrective Script" style="vertical-align:middle;"/></a></div></div>';
					}
					else if (name.indexOf("SpecTestNoScript") > -1)
					{
						var idx6 = name.indexOf("SpecTestNoScript");
						var test_idx6 = name.indexOf(":");
						var displayName = name.substring(0,test_idx6);
						var orgTestName = name.substring(test_idx5+1,idx6);
						gridTitle = displayName+'<div class="button_div" style="position: absolute;z-index: 9; right:0px;"><div style="position:relative; top:-22px; margin-right:10px;" align="right"><a href="javascript:void(0);" onclick="me.fileUploadWindow(event,\''+orgTestName+'\')"><img src="/final/images/clear.png" class="iconScriptUploadDisable mouse" data-qtip="Upload Corrective Script" style="vertical-align:middle;"/></a></div></div>';
					}
					return gridTitle;
				}
			}
		],
		hideGroupedHeader: false,
		startCollapsed: false
	}],

	//tools: [{
			//xtype:'button',
			//id :'tc',
			//name :'tc',
			//iconCls: 'iconCollapseAll',
			//enableToggle : true,
			//style: {
				//background: 'none',
				//border: '0px'
			//},
			//listeners:{
			//'toggle':function(obj, pressed, eOpts){
				//var thisGrid = Ext.getCmp('infoGrid'),
				//groupingFeature = thisGrid.view.getFeature('testWiseGrouping');
				//if(pressed){
						//groupingFeature.collapseAll();
						//obj.setIconCls('iconExpandAll');
				//}else{
						//groupingFeature.expandAll();
						//obj.setIconCls('iconCollapseAll');
				//}
				//thisGrid.doLayout();
			//}
		//}
	//}],
	hideHeaders : true,
	viewConfig: {
		emptyText: '<table align="center"><tr><td align="center" height="300"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText" id="userDeferMessage">'+noCompManaged+'</td></tr></table></td></tr></table>',
		deferEmptyText: false,
		cls:'gridSkin_expander_view gridview_admin'
	},
	columns :{
		items:[
			{
				text : 'Test',
				dataIndex : 'TestName',
				flex : 1,
				renderer : function(value)
				{
					if (value != "" && value.length > 0)
					{
						var tmpStr = "";
						var flag = true;
						var compType = publicJson['compType'];
						var csEnabledTestArr = publicJson['csEnabledTestArr'];
						var noCsEnabledTestArr = publicJson['noCsEnabledTestArr'];
						var noCsAndScriptTestArr = publicJson['noCsAndScriptTestArr'];

						for (var x=0; x<csEnabledTestArr.length; x++)
						{
							var csEnabledTest = csEnabledTestArr[x];
							if (value == csEnabledTest)
							{
								return '<div style="margin-left:5px;margin-right:5px;margin-top:5px;margin-bottom:5px;"><div align="left" ><div class="iconInformationSmall"><span style="vertical-align:sub;">&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp;Upload corrective script files.</span></div></div></div>';
							}
						}

						for (var y=0; y<noCsEnabledTestArr.length; y++)
						{
							var noCsEnabledTest = noCsEnabledTestArr[y];
							if (value == noCsEnabledTest)
							{
								tmpStr = tmpStr +'<div style="margin-left:5px;margin-right:5px;margin-top:5px;margin-bottom:12px;"><div align="left" ><div class="iconInformationSmall"><span style="vertical-align:sub;">&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp;Enable corrective script feature.</span></div></div></div>';
							}
						}

						for (var z=0; z<noCsAndScriptTestArr.length; z++)
						{
							var noCsAndScriptTest = noCsAndScriptTestArr[z];
							if (value == noCsAndScriptTest)
							{
								return '<div style="margin-left:5px;margin-right:5px;margin-top:5px;margin-bottom:5px;"><div align="left" ><div class="iconInformationSmall"><span style="vertical-align:sub;">&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp;Enable corrective script feature and upload script files.</span></div</div></div>';
							}
						}

						var finalResultDataObj = publicJson.finalResultDataObj;
						var displayOSNameObj = publicJson.displayOSNameObj;
						var htmlStr = "<table border='0' cellpadding='0' cellspacing='0' style='width:100%'>";
						var rowTestName = value; 
						if (!Ext.isEmpty(finalResultDataObj))
						{
							var dataForTest = finalResultDataObj[rowTestName];
							var dataLength = dataForTest.length;
							var cellFlag = false;

							tmpStr = tmpStr +'<div style="margin-left:5px;margin-right:5px;margin-top:5px;margin-bottom:5px;"><table cellspacing="0" cellpadding="0" border="0" width="100%" class="OStable admin_table"><tr style=""><th style="text-align: left;padding:8px 10px 4px 10px" class="alarmTooltipHeaderfont OStable_td" nowrap>OS</th><th style="text-align: left;padding:8px 10px 4px 10px" class="alarmTooltipHeaderfont OStable_td" nowrap>Measure</th><th style="text-align: left;padding:8px 10px 4px 10px" class="alarmTooltipHeaderfont OStable_td" nowrap>Applied to component?</th><th style="text-align: left;padding:8px 10px 4px 10px" class="alarmTooltipHeaderfont OStable_td"></th><th style="text-align: left;padding:8px 10px 4px 10px" class="alarmTooltipHeaderfont OStable_td">&nbsp;&nbsp;</th></tr>';

							for (var d=0; d<dataLength;d++ )
							{
								var resultObj = dataForTest[d];
								var strOSName = resultObj.OS;
								var strdelDispName = '';
								var strTestName = resultObj.Test;
								var strMeasureName = resultObj.Measure;
								var isEnabled = resultObj.Enabled;
								var dispTestName = strTestName;
								var dispOSName = displayOSNameObj[strOSName];
								var strScriptName = publicJson.fileNameObj[strOSName+'|#|'+strTestName+'|#|'+strMeasureName];

								//var clsForTR = "background-color:#fff;";
								//if (cellFlag)
								//{
									//clsForTR = 'background-color:#f4f4f4;';
								//}

								if (!Ext.isEmpty(strMeasureName))
								{
									if (strMeasureName.toLowerCase() == 'all measures' || strMeasureName.toLowerCase() == 'other measures')
									{
										strdelDispName = publicJson.displayTestJsonObj[strTestName];
									}
									else
									{
										strdelDispName = publicJson.displayTestJsonObj[rowTestName]+" - "+publicJson.displayMeasureJsonObj[strMeasureName];
									}
								}

								if (!Ext.isEmpty(dispTestName))
								{
									dispTestName = publicJson.displayTestJsonObj[dispTestName];
								}

								if (!Ext.isEmpty(strMeasureName) && (strMeasureName.toLowerCase() != 'all measures' && strMeasureName.toLowerCase() != 'other measures') )
								{
									strMeasureName = publicJson.displayMeasureJsonObj[strMeasureName];
								}

								tmpStr = tmpStr +'<tr>';
								tmpStr = tmpStr + '<td style="width:18%;padding:8px 10px 4px 10px;" nowrap>'+dispOSName+'</td>';
								tmpStr = tmpStr + '<td style="width:31%;padding:8px 10px 4px 10px;" nowrap>'+strMeasureName+'</td>';

								isDelDisabled = 'iconDelete';
								if (!Ext.isEmpty(isEnabled) && isEnabled.toLowerCase() == 'true')
								{
									tmpStr = tmpStr + '<td style="width:13%;text-align:left;padding:8px 10px 4px 10px;" nowrap>Yes</td>';
									isDelDisabled = '';
									tmpStr = tmpStr + '<td class="alarmTooltipHeaderfont admin_last_col" style="width:4%;text-align: center;padding:0px 0px 0px 0px" nowrap><a href="javascript:void(0);"  onclick="me.handleEditIconClick(\''+rowTestName+'\',\''+strScriptName+'\',\''+strOSName+'\',\''+compType+'\');"><img src="/final/images/clear.png" class="iconScriptReupload mouse"  data-qtip="Reupload" style="vertical-align:middle;"></a></td><td class="alarmTooltipHeaderfont admin_last_col" style="width:4%;text-align: center;padding:2px 0px 0px 0px" nowrap><img src="/final/images/clear.png" class="iconDeleteDisabled" style="vertical-align:middle;"></td>';

								}
								else if (!Ext.isEmpty(isEnabled) && isEnabled.toLowerCase() == 'false')
								{
									tmpStr = tmpStr + '<td style="width:13%;text-align: left;padding:8px 10px 4px 10px;" nowrap>No</td>';
									tmpStr = tmpStr + '<td class="alarmTooltipHeaderfont admin_last_col" style="width:4%;text-align: center;padding:0px 0px 0px 0px" nowrap><a href="javascript:void(0);"  onclick="me.handleEditIconClick(\''+rowTestName+'\',\''+strScriptName+'\',\''+strOSName+'\',\''+compType+'\');"><img src="/final/images/clear.png" class="iconScriptReupload mouse"  data-qtip="Reupload" style="vertical-align:middle;"></a></td><td class="alarmTooltipHeaderfont admin_last_col" style="width:4%;text-align: center;padding:2px 0px 0px 0px" nowrap><a href="javascript:void(0);"  onclick="me.handleDeleteIconClick(\''+rowTestName+'\',\''+strScriptName+'\',\''+strOSName+'\',\''+strdelDispName+'\',\''+compType+'\');"><img src="/final/images/clear.png" class="iconDelete mouse" style="vertical-align:middle;"  data-qtip="Delete" ></a></td>';

								}
								tmpStr = tmpStr + '</tr>';
								cellFlag = !cellFlag;
							}
							tmpStr = tmpStr + '</table></div>';
						}
						htmlStr = htmlStr + "</table>";
						return '<div id="mainDiv">'+tmpStr+'</div>';
					}
				}
			}
		]
	},
	tbar: [
			{
				xtype: 'scrollcombo',
				cls: 'dropdown',
				id : 'filterCompType',
				name: 'filterCompType',
				fieldLabel: label5,
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				value: '',
				editable: false,
				parent:this,
				labelSeparator: ' ',
				store:new Ext.data.Store({
					fields: ['displayField','valueField'],
					data: []
				}),
				width: 370,
				labelWidth: 120
			},
			{
				xtype:'tbfill',
			},
			{
				xtype: 'trigger',
				id: 'searchTrigger',
				trigger1Cls: 'x-form-clear-trigger',
				trigger2Cls: 'x-form-search-trigger',
				cls: 'whitedropdown_search',
				emptyText: 'Search test name',
				disabled: true,
				getTriggerMarkup: function() {
					var me = this,
					i = 0,
					hideTrigger = (me.readOnly || me.hideTrigger),
					triggerCls,
					triggerBaseCls = me.triggerBaseCls,
					triggerConfigs = [],
					unselectableCls = Ext.dom.Element.unselectableCls,
					style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
					cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
					// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
					// single triggerCls config. Should rethink this, perhaps something more structured like a list of
					// trigger config objects that hold cls, handler, etc.
					// triggerCls is a synonym for trigger1Cls, so copy it.
					if (!me.trigger1Cls) {
						me.trigger1Cls = me.triggerCls;
					}
					// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
					for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
						if (i == 0)
						{
							triggerConfigs.push({
								tag: 'td',
								role: 'presentation',
								valign: 'top',
								cls: cls,
								id : 'MyTrigger_'+i,
								style: style + "display:none;",
								cn: {
									cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
									role: 'presentation'
								}
							});
						}
						else
						{
							triggerConfigs.push({
								tag: 'td',
								role: 'presentation',
								valign: 'top',
								cls: cls,
								id : 'MyTrigger_'+i,
								style: style,
								cn: {
									cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
									role: 'presentation'
								}
							 });
						}
					}
					triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
					return Ext.DomHelper.markup(triggerConfigs);
				},
				onTrigger1Click: function()
				{
					this.reset();
				},
				onTrigger2Click: function()
				{
					me.filterGrid(this.getValue());
				}
			},
			{
				xtype: 'toolbar',
				ui: 'footer',
				items:[
					//{
						//xtype: 'button',
						//itemId: 'uploadNewCSBtn',
						//text: label1,
						//cls: 'button20',
						//margin: '0 8 0 0'
					//},
					{
						xtype: 'button',
						id: 'enableCorrectiveScriptTests',
						name: 'enableCorrectiveScriptTests',
						text: label10,
						cls: 'button20',
						margin: '0 2 0 0'
					}
				]
			},
			{
				xtype:'button',
				id :'collExpandBtn',
				name :'collExpandBtn',
				iconCls: 'iconCollapseAll',
				enableToggle : true,
				style: {
					background: 'none',
					border: '0px'
				},
				listeners:{
					'toggle':function(obj, pressed, eOpts){
						var thisGrid = Ext.getCmp('infoGrid'),
						groupingFeature = thisGrid.view.getFeature('testWiseGrouping');
						if(pressed){
								groupingFeature.collapseAll();
								obj.setIconCls('iconExpandAll');
						}else{
								groupingFeature.expandAll();
								obj.setIconCls('iconCollapseAll');
						}
						thisGrid.doLayout();
					}
				}
			}

				//,{
					//xtype: 'button',
					//id : 'nodeExpand',
					//iconCls: 'iconExpandAll',
					//hidden:false,
					//style: {
						//background: 'none',
						//border: '0px'
					//},
					//listeners: {
						//'click':function(obj){
							//this.hide();
							//Ext.getCmp('nodeCollapse').show();
							//for (var i = 0;i<this.up('grid').getStore().getCount();i++)
							//{
								//this.up('grid').expandAllRow(i);
							//}
							//this.up('grid').view.refreshSize();
						//}
					//}
				//},
				//{
					//xtype:'button',
					//id :'nodeCollapse',
					//iconCls: 'iconCollapseAll',
					//hidden:true,
					//style: {
						//background: 'none',
						//border: '0px'
					//},
					//listeners: {
						//'click':function(obj) {
							//this.hide();
							//Ext.getCmp('nodeExpand').show();
							//for (var i = 0;i<this.up('grid').getStore().getCount();i++)
							//{
								//this.up('grid').collapseAllRow(i);
							//}
							//this.up('grid').view.refreshSize();
						//}
					//}
				//}
			]
});



