Ext.define('DefaultTestConfiguration.controller.FunctionController',{
	extend:'Ext.app.Controller',

	refs:[
		{selector:'egconfigurerulenames', ref:'egconfigurerulenames'},
		{selector:'eghlspublishedresources', ref:'eghlspublishedresources'},
		{selector:'egemailconfiguration', ref:'egemailconfiguration'},
		{selector:'eghorizonwssimulator', ref:'eghorizonwssimulator'},
		{selector:'egsystemproperties', ref:'egsystemproperties'},
		{selector:'egamazonwssimulator', ref:'egamazonwssimulator'}
	],

	init:function(){
		func = this;
		this.control({
			'egconfigurerulenames button[id="addRuleNamebtn"]': {
				'click': this.addMainContact
			},
			'egconfigurerulenames button[id="clearRuleName"]': {
				'click': this.clearFilterRules
			},
			'egconfigurerulenames button[id="updateRuleName"]': {
				'click': this.updateRuleFilters
			},
			'egemailconfiguration button[id="addEmailBtn"]': {
				'click': this.addMainEmailContact
			},
			'egemailconfiguration button[id="clearEmailBtn"]': {
				'click': this.clearEmailFields
			},
			'egemailconfiguration button[id="updateEmailBtn"]': {
				'click': this.updateEmailSets
			},
			'eghlspublishedresources button[id="addMultiHLSbtn"]': {
				'click': this.addMultiHLSSource
			},
			'eghlspublishedresources button[id="clearMultiHLSbtn"]': {
				'click': this.ClearMultiHLSSource
			},
			'eghlspublishedresources button[id="updateMultiHLSbtn"]': {
				'click': this.UpdateMultiHLSSource
			},
			'eghorizonwssimulator button[id="addResourcebtn"]': {
				'click': this.addHorizonWSResourceSet
			},
			'eghorizonwssimulator button[id="clearResourceBtn"]': {
				'click': this.clearResourceFieldSets
			},
			'eghorizonwssimulator button[id="updateResourceBtn"]': {
				'click': this.updateResourceSets
			},
			'egsystemproperties button[id="addPropBtn"]': {
				'click': this.addMainPropertySet
			},
			'egsystemproperties button[id="clearPropBtn"]': {
				'click': this.clearPropertyFields
			},
			'egsystemproperties button[id="updatePropBtn"]': {
				'click': this.updatePropertySets
			},
			'egamazonwssimulator button[id="addAmazonResourcebtn"]': {
				'click': this.addAmazonWSResourceSet
			},
			'egamazonwssimulator button[id="clearAmazonResourceBtn"]': {
				'click': this.clearAmazonResourceFieldSets
			},
			'egamazonwssimulator button[id="updateAmazonResourceBtn"]': {
				'click': this.updateAmazonResourceSets
			},

		});
	},

	// Horizon cloud POD starts
	configHorizonMultiUsers: function(btn) 
	{  
		Ext.create('DefaultTestConfiguration.view.HorizonCloudMultipleUsers').show();

		var multidom = '';
		inputsmulti = 2;
		ismulti = 'false';

		var ValueConnSerName = Ext.getCmp('Connection_server_name').getValue();
		var ValueUsrdomain = Ext.getCmp('Domain_name').getValue();
		var Valueuser = Ext.getCmp('User_name').getValue();
		var Valuepass = Ext.getCmp('Password').getValue();

		var splitUsrSerName = ValueConnSerName.split(",");
		var splitUsrDomain = ValueUsrdomain.split(",");
		var splituser = Valueuser.split(",");
		var splitpass = Valuepass.split("#~#");

		if (ValueUsrdomain != null || ValueUsrdomain != undefined)
		{
			for (var k =0;k<splitUsrDomain.length-1;k++ )
			{
				addHorizonMultiSet();
			}
			for (multidom=1;multidom<splitUsrDomain.length+1;multidom++)
			{
				Ext.getCmp('servnamemultiusr'+multidom).setValue(splitUsrSerName[multidom-1]);
				Ext.getCmp('domainmultiusr'+multidom).setValue(splitUsrDomain[multidom-1]);
				Ext.getCmp('usermultiusr'+multidom).setValue(splituser[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('confpwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
				Ext.getCmp('confpwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
			}
		}
		Ext.Ajax.request({
			url: 'DefaultTestConfiguration/data/defaulttesthelpJson.jsp?mode=egconfiguremultipleusers',
			method: 'POST',
			async: false
		});
	},
	clearHorizonCloudMultiSet: function(btn) 
	{
		var backupmulticontainer = Ext.getCmp('backupmulticontainer');
		backupmulticontainer.removeAll();
		Ext.getCmp('addServersMultiSet').setText('Add');
		Ext.getCmp('NoServersPattern').show();
		if (Ext.getCmp('conmulti_1') != null || Ext.getCmp('conmulti_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('conmulti_1').removeAll();
			Ext.getCmp('conmulti_1').hide();
		}
		Ext.getCmp('updateServersMultiSet').disable();
		Ext.getCmp('clearServersMultiSet').disable();
	},
	updateHorizonCloudMultiSet: function(btn) 
	{
		var multiinputs = inputsmulti;

		for (var mul=1;mul<multiinputs-1;mul++)
		{
			if (Ext.getCmp('domainmultiusr'+mul) == undefined)
			{
				continue;
			}
			var server = Ext.getCmp('servnamemultiusr'+mul).getValue();
			var domain = Ext.getCmp('domainmultiusr'+mul).getValue();
			var uname = Ext.getCmp('usermultiusr'+mul).getValue();
			var pass = Ext.getCmp('pwdmultiusr'+mul).getValue();
			var confpasswd = Ext.getCmp('confpwdmultiusr'+mul).getValue();

			if(!checkblank(server))
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: enterServname,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('servnamemultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if (!validateIpOrHNameExt(multiServersTitle,Ext.getCmp('servnamemultiusr'+mul)))
			{
				Ext.getCmp('servnamemultiusr'+mul).focus();
				return;
			}

			if(!checkblank(domain))
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			if (!checkDomain(domain,"true"))
			{
				Ext.getCmp('domainmultiusr'+mul).focus(true);
				return;
			}
			else if (domain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if(!checkHyphenText(domain,domain))
			{
				Ext.getCmp('domainmultiusr'+mul).focus();
				return;
			}
			else if (domain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if (!checkspecial(uname,"@*+=|:;\"\'<>\/[]?,"))
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true);
					}
				});
				return;
			}
			if(pass == "")
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if (pass.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if(!checkspecialnomess(pass,"|"))
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: PwdNotContainPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if(pass.indexOf("#~#")>-1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: _checkHashTildeHash,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if(!checkForPassValidity(pass))
			{
				Ext.getCmp('pwdmultiusr'+mul).focus();
				sub = false;
				return;
			}
			else if(confpasswd == "")
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: enterCnfPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
			else if (confpasswd.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true);
					}
				});
				return;
			}
			else if(pass != confpasswd)
			{
				Ext.Msg.show({
					title: multiServersTitle,
					msg: matchPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true);
					}
				});
				sub = false;
				return;
			}
		}

		var multiUsrServnameVal = "";
		var multiUsrdomainVal = "";
		var multiUsrVal = "";
		var multiUsrpassVal = "";

		for(var mulusr=1; mulusr<multiinputs; mulusr++)
		{
			if (Ext.getCmp('domainmultiusr'+mulusr) == undefined)
			{
				continue;
			}

			var multiservname= Ext.getCmp('servnamemultiusr'+mulusr).getValue();
			if(multiservname == null) continue;
			if(multiservname != null)
			{
				if(!checkblank(multiservname))
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: enterServname,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('servnamemultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (!validateIpOrHNameExt(multiServersTitle,Ext.getCmp('servnamemultiusr'+mulusr)))
				{
					Ext.getCmp('servnamemultiusr'+mulusr).focus();
					return;
				}
			}

			var multidomain= Ext.getCmp('domainmultiusr'+mulusr).getValue();
			if(multidomain == null) continue;
			if(multidomain != null)
			{
				if (!checkDomain(multidomain,"true"))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus(true);
					return;
				}
				else if (multidomain.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multidomain.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multidomain,multidomain))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus();
					return;
				}
			}

			var multiUname = Ext.getCmp('usermultiusr'+mulusr).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{

					Ext.Msg.show({
						title: multiServersTitle,
						msg: enterUsr,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkspecial(multiUname,"@*+=|:;\"\'<>\/[]?,"))
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
			}
			var multipass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
			var multiconfpasswd = Ext.getCmp('confpwdmultiusr'+mulusr).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(multipass,"|"))
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('pwdmultiusr'+mulusr).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: multiServersTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true);
						}
					});
					return;
				}
			}

			if(multiservname!=null && multidomain!=null && multiUname!=null && multipass!=null && multiconfpasswd!=null )
			{
				var tempmultiServname = Ext.getCmp('servnamemultiusr'+mulusr).getValue();
				multiUsrServnameVal+=tempmultiServname+",";

				var tempmultiUsrdoma = Ext.getCmp('domainmultiusr'+mulusr).getValue();
				multiUsrdomainVal+=tempmultiUsrdoma+",";

				var tempmultiUsr = Ext.getCmp('usermultiusr'+mulusr).getValue();
				multiUsrVal+=tempmultiUsr+",";

				var tempmultiUsrPass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
				multiUsrpassVal+=tempmultiUsrPass+"#~#";
			}
		}
		multiUsrServnameVal = multiUsrServnameVal.substring(0,multiUsrServnameVal.length-1);
		Ext.getCmp('Connection_server_name').setValue(multiUsrServnameVal);

		multiUsrdomainVal = multiUsrdomainVal.substring(0,multiUsrdomainVal.length-1);
		Ext.getCmp('Domain_name').setValue(multiUsrdomainVal);

		multiUsrVal = multiUsrVal.substring(0,multiUsrVal.length-1);
		Ext.getCmp('User_name').setValue(multiUsrVal);

		multiUsrpassVal = multiUsrpassVal.substring(0,multiUsrpassVal.length-3);
		Ext.getCmp('Password').setValue(multiUsrpassVal);
		Ext.getCmp('Password').backupValue = multiUsrpassVal;

		if (!Ext.isEmpty(Ext.getCmp('Passwordconfirmpassword')))
		{
			Ext.getCmp('Passwordconfirmpassword').setValue(multiUsrpassVal);
			Ext.getCmp('Passwordconfirmpassword').backupValue = multiUsrpassVal;
			Ext.getCmp('Passwordconfirmpassword').setReadOnly(true);
		}

		Ext.getCmp('Connection_server_name').setReadOnly(true);
		Ext.getCmp('Domain_name').setReadOnly(true);
		Ext.getCmp('User_name').setReadOnly(true);
		Ext.getCmp('Password').setReadOnly(true);
		Ext.getCmp('horizoncloudmultipleusers').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},

	// Horizon cloud POD ends

	// AmazonWS workspace logon simulator starts...
	updateAmazonResourceSets: function(btn) 
	{
		var setPublisResource = "";
		var setRegCode = "";
		var setDomain = "";
		var setUsername = "";
		var setPassword = "";

		var rdCnt = 0;
		var totalRules = inputsResourceSet;
		var arrPublisResource = new Array();

		for(var j=1; j<totalRules; j++)
		{
			if (Ext.getCmp('publisresource'+j) == undefined)
			{
				continue;
			}

			var pubresource = Ext.getCmp('publisresource'+j).getValue();
			var regcode = Ext.getCmp('regcode'+j).getValue();
			var domain = Ext.getCmp('domain'+j).getValue();
			var uname = Ext.getCmp('username'+j).getValue();
			var pass = Ext.getCmp('pwd'+j).getValue();
			var confpass = Ext.getCmp('confpwd'+j).getValue();

			if (!checkblank(pubresource))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPubRsrc,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (pubresource.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(pubresource,"`*+=#.|;\"\'<>\/[]{}()?:"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (trim(pubresource) == "")
			{
				Ext.getCmp('publisresource'+j).focus();
				return;
			}
			else if(!checkHyphenText(pubresource,pubresource))
			{
				Ext.getCmp('publisresource'+j).focus();
				return;
			}
			else if (pubresource.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (pubresource.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}

			if(!checkblank(regcode))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterRegcode,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+j).focus(true,true);
					}
				});
				return;
			}
			else if (regcode.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+j).focus(true,true);
					}
				});
				return;
			}
			else if (regcode.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+j).focus(true,true);
					}
				});
				return;
			}
			else if (regcode.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+j).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(regcode,"|"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('regcode'+j).focus(true,true);
					}
				});
				return;
			}

			if(!checkblank(domain))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+j).focus(true,true);
					}
				});
				return;
			}
			else if (domain.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+j).focus(true,true);
					}
				});
				return;
			}

			if (!checkDomain(domain,"true"))
			{
				Ext.getCmp('domain'+j).focus(true,true);
				return;
			}
			else if (domain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+j).focus(true,true);
					}
				});
				return;
			}
			else if(!checkHyphenText(domain,domain))
			{
				Ext.getCmp('domain'+j).focus();
				return;
			}
			else if (domain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+j).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(uname,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('username'+j).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('username'+j).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}

			if(pass!=null)
			{
				if(pass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if (pass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(pass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkForPassValidity(pass))
				{
					Ext.getCmp('pwd'+j).focus();
					sub = false;
					return;
				}
				else if(confpass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(pass != confpass)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+j).focus(true,true);
						}
					});
					return;
				}
			}
		}

		var multiPublishSrcVal = "";
		var hiddenPublishSrcVal = "";
		var multiRegCodeVal = "";
		var multiDomainVal = "";
		var multiUsrVal = "";
		var multiUsrpassVal = "";
		var multiUsrdisclaimVal = "";
		var multi2FAuthVal = "";

		for(var multi=1; multi<totalRules; multi++)
		{
			if (Ext.getCmp('publisresource'+multi) == undefined)
			{
				continue;
			}

			var multiSrcPublis = Ext.getCmp('publisresource'+multi).getValue();
			if(multiSrcPublis!=null)
			{
				if(!checkblank(multiSrcPublis))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPubRsrc,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiSrcPublis,"`*+=#.|;\"\'<>\/[]{}()?:"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiSrcPublis) == "")
				{
					Ext.getCmp('publisresource'+multi).focus();
					return;
				}
				else if (multiSrcPublis.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiSrcPublis,multiSrcPublis))
				{
					Ext.getCmp('publisresource'+multi).focus();
					return;
				}
			}

			var multiRegCode = Ext.getCmp('regcode'+multi).getValue();
			if(!checkblank(multiRegCode))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterRegcode,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+multi).focus(true,true);
					}
				});
				return;
			}
			else if (multiRegCode.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+multi).focus(true,true);
					}
				});
				return;
			}
			
			if (multiRegCode.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+multi).focus(true,true);
					}
				});
				return;
			}
			else if (multiRegCode.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('regcode'+multi).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(multiRegCode,"|"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('regcode'+multi).focus(true,true);
					}
				});
				return;
			}

			var multiDomain = Ext.getCmp('domain'+multi).getValue();
			if(!checkblank(multiDomain))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+multi).focus(true,true);
					}
				});
				return;
			}
			else if (multiDomain.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+multi).focus(true,true);
					}
				});
				return;
			}
			else if (!checkDomain(multiDomain,"true"))
			{
				Ext.getCmp('domain'+multi).focus(true,true);
				return;
			}
			else if (multiDomain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+multi).focus(true,true);
					}
				});
				return;
			}
			else if(!checkHyphenText(multiDomain,multiDomain))
			{
				Ext.getCmp('domain'+multi).focus();
				return;
			}
			else if (multiDomain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domain'+multi).focus(true,true);
					}
				});
				return;
			}

			var multiUname = Ext.getCmp('username'+multi).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{

					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterUsrId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiUname,"*+=|:;\"\'<>\/[]?,"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('usermultiusr'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('usermultiusr'+multi).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('username'+multi).focus();
					return;
				}
			}

			var multipass = Ext.getCmp('pwd'+multi).getValue();
			var multiconfpasswd = Ext.getCmp('confpwd'+multi).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(multipass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('pwd'+multi).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
			}
			
			if (multiPublishSrcVal != null && 
				multiRegCode != null && 
				multiDomain != null && 
				multiUname!=null && 
				multipass!=null && 
				multiconfpasswd!=null )
			{
				var tempRegCode = Ext.getCmp('regcode'+multi).getValue();
				multiRegCodeVal+=tempRegCode+"#~#";

				var tempmultiSrcPublis = Ext.getCmp('publisresource'+multi).getValue();
				var tmpHiddenPublishSrc = tempmultiSrcPublis;
				if (!Ext.isEmpty(tmpHiddenPublishSrc) && tmpHiddenPublishSrc.indexOf(",") != -1)
				{
					tmpHiddenPublishSrc = tmpHiddenPublishSrc.replace(/,/g,'~#~');
				}
				multiPublishSrcVal+=tempmultiSrcPublis+",";
				hiddenPublishSrcVal+=tmpHiddenPublishSrc+"|";

				var tempDomain = Ext.getCmp('domain'+multi).getValue();
				multiDomainVal+=tempDomain+",";

				var tempmultiUsr = Ext.getCmp('username'+multi).getValue();
				multiUsrVal+=tempmultiUsr+"|";

				var tempmultiUsrPass = Ext.getCmp('pwd'+multi).getValue();
				multiUsrpassVal+=tempmultiUsrPass+"#~#";
			}
		}

		multiPublishSrcVal = multiPublishSrcVal.substring(0,multiPublishSrcVal.length-1);
		Ext.getCmp('Published_resources').setValue(multiPublishSrcVal);

		hiddenPublishSrcVal = hiddenPublishSrcVal.substring(0,hiddenPublishSrcVal.length-1);
		Ext.getCmp('hiddenPublishedResource').setValue(hiddenPublishSrcVal);


		multiRegCodeVal = multiRegCodeVal.substring(0,multiRegCodeVal.length-3);
		Ext.getCmp('Registration_code').setValue(multiRegCodeVal);
		Ext.getCmp('Registration_code').backupValue = multiRegCodeVal;

		multiDomainVal = multiDomainVal.substring(0,multiDomainVal.length-1);
		Ext.getCmp('Domain').setValue(multiDomainVal);

		multiUsrVal = multiUsrVal.substring(0,multiUsrVal.length-1);
		Ext.getCmp('Username').setValue(multiUsrVal);

		multiUsrpassVal = multiUsrpassVal.substring(0,multiUsrpassVal.length-3);
		Ext.getCmp('Password').setValue(multiUsrpassVal);
		Ext.getCmp('Password').backupValue = multiUsrpassVal;

		if (Ext.getCmp('cpwd') != null && Ext.getCmp('cpwd') != undefined)
		{
			Ext.getCmp('cpwd').setValue(multiUsrpassVal);
			Ext.getCmp('cpwd').setReadOnly(true);
		}

		if (Ext.getCmp('Passwordconfirmpassword') != null && Ext.getCmp('Passwordconfirmpassword') != undefined)
		{
			Ext.getCmp('Passwordconfirmpassword').setValue(multiUsrpassVal);
			Ext.getCmp('Passwordconfirmpassword').backupValue = multiUsrpassVal;
			Ext.getCmp('Passwordconfirmpassword').setReadOnly(true);
		}
		Ext.getCmp('Published_resources').setReadOnly(true);


		Ext.getCmp('Username').setReadOnly(true);
		Ext.getCmp('Username').hide();
		Ext.getCmp('Password').setReadOnly(true);
		Ext.getCmp('Password').hide();
		Ext.getCmp('Registration_code').setReadOnly(true);
		Ext.getCmp('Registration_code').hide();
		Ext.getCmp('Domain').setReadOnly(true);
		Ext.getCmp('Domain').hide();

		Ext.getCmp('egamazonwssimulator').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	clearAmazonResourceFieldSets: function(btn) 
	{
		var rulenamescontainer = Ext.getCmp('backupamazonresrccontainer');
		rulenamescontainer.removeAll();
		Ext.getCmp('addAmazonResourcebtn').setText('Add');
		Ext.getCmp('NoAmazonResourcePattern').show();
		if (Ext.getCmp('con_1') != null || Ext.getCmp('con_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('con_1').removeAll();
			Ext.getCmp('con_1').hide();
		}
		Ext.getCmp('updateAmazonResourceBtn').disable();
		Ext.getCmp('clearAmazonResourceBtn').disable();
	},
	addAmazonWSResourceSet: function(btn) 
	{
		addAmazonResourceSetFields(btn);
	}, 
	configAmazonWSResourceSet: function(btn) 
	{  
		Ext.create('DefaultTestConfiguration.view.EgAmazonWSSimulator').show();
		ismulti = 'false';

		var rname = '';
		inputsResourceSet = 2;
		
		Ext.suspendLayouts();


		var ValuePublisresources = '';
		var ValueHiddenPubResources = Ext.getCmp('hiddenPublishedResource').getValue();

		if (!Ext.isEmpty(ValueHiddenPubResources))
		{
			ValuePublisresources = ValueHiddenPubResources;
		}


		var domain = Ext.getCmp('Domain').getValue();
		var username = Ext.getCmp('Username').getValue();
		var password = Ext.getCmp('Password').getValue();
		var ValueRegCode = Ext.getCmp('Registration_code').getValue();

		var splitPublisResource = ValuePublisresources.split("|");
		var splitUser = username.split(",");
		var splitPass = password.split("#~#");
		var splitRegCode = ValueRegCode.split("#~#");
		var splitDomain = domain.split(",");

		if (splitPublisResource != null || splitPublisResource != undefined)
		{
			for (var k =0;k<splitPublisResource.length-1;k++ )
			{
				addAmazonResourceSetFields();
			}

			for (rname=1;rname<splitPublisResource.length+1;rname++)
			{
				if (Ext.getCmp('publisresource'+rname) == undefined)
				{
					continue;
				}

				var tmpPubResource = splitPublisResource[rname-1];
				if (!Ext.isEmpty(tmpPubResource) && tmpPubResource.indexOf('~#~') != -1)
				{
					tmpPubResource = tmpPubResource.replace(/~#~/g,',');
				}
				var tmpDomain = splitDomain[rname-1];
				var tmpUserId = splitUser[rname-1];
				var tmpPassword = splitPass[rname-1];

				var strRegCode = splitRegCode[rname-1];

				Ext.getCmp('publisresource'+rname).setValue(tmpPubResource);
				Ext.getCmp('regcode'+rname).setValue(strRegCode);
				Ext.getCmp('regcode'+rname).backupValue = strRegCode;
				Ext.getCmp('domain'+rname).setValue(tmpDomain);
				Ext.getCmp('username'+rname).setValue(tmpUserId);
				Ext.getCmp('pwd'+rname).setValue(tmpPassword);
				Ext.getCmp('confpwd'+rname).setValue(tmpPassword);
				Ext.getCmp('pwd'+rname).backupValue = tmpPassword;
				Ext.getCmp('confpwd'+rname).backupValue = tmpPassword;
			}
		}

		Ext.resumeLayouts(true);

		Ext.Ajax.request({
			url: 'DefaultTestConfiguration/data/defaulttesthelpJson.jsp?mode=configureawslogonsimulator',
			method: 'POST',
			async: false
		});
	},
	// AmazonWS workspace logon simulator ends...

	// System properties works starts...
	updatePropertySets: function(btn) 
	{
		var setPropKey = "";
		var setPropVal = "";
		var rdCnt = 0;
		var totalRules = inputsEmail;
		var arrEmailIds = new Array();

		for(var j=1; j<totalRules; j++)
		{
			if (Ext.getCmp('syspropkey'+j) == undefined)
			{
				continue;
			}
			var propKey = Ext.getCmp('syspropkey'+j).getValue();
			var propVal = Ext.getCmp('syspropval'+j).getValue();

			if(propKey!=null)
			{
				if (!checkblank(propKey))
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: enterSystemPropKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('syspropkey'+j).focus(true,true);
						}
					});
					return;
				}
				else if (!checkspecialExt(propKey,"@*+=|:;\"\'<>\/[]?,!"))
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('syspropkey'+j).focus(true,true);
						}
					});
					return;
				}
				else if (propKey.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('syspropkey'+j).focus(true,true);
						}
					});
					return;
				}

				if (!checkblank(propVal))
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: enterSystemPropValue,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('syspropval'+j).focus(true,true);
						}
					});
					return;
				}
				else if (!checkspecialExt(propVal,"~#@*+=|:;\"\'<>\/[]?"))
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('syspropval'+j).focus(true,true);
						}
					});
					return;
				}
				else if (propVal.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: SysPropTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('syspropval'+j).focus(true,true);
						}
					});
					return;
				}
				setPropKey += propKey + ",";
				if (propVal.indexOf(",") != -1)
				{
					propVal = propVal.replace(/,/g,'~#~');
				}
				setPropVal += propVal + ",";
			}
		}

		setPropKey = setPropKey.substring(0,setPropKey.length-1);
		setPropVal = setPropVal.substring(0,setPropVal.length-1);

		Ext.getCmp('system_property_key').setValue(setPropKey);
		Ext.getCmp('system_property_value').setValue(setPropVal);
		Ext.getCmp('egsystemproperties').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	clearPropertyFields: function(btn) 
	{
		var propetiesmorecontainer = Ext.getCmp('propetiesmorecontainer');
		propetiesmorecontainer.removeAll();
		Ext.getCmp('addPropBtn').setText('Add');
		Ext.getCmp('NoPropContainer').show();
		if (Ext.getCmp('con_1') != null || Ext.getCmp('con_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('con_1').removeAll();
			Ext.getCmp('con_1').hide();
		}
		Ext.getCmp('updatePropBtn').disable();
		Ext.getCmp('clearPropBtn').disable();
	},
	addMainPropertySet: function(btn) 
	{
		addSystemProperties(btn);
	},
	configSystemProperties: function(btn) 
	{  
		Ext.create('DefaultTestConfiguration.view.EgSystemProperties').show();

		ismulti = 'false';

		var rname = '';
		inputsEmail = 2;
		
		Ext.suspendLayouts();

		var propKey = Ext.getCmp('system_property_key').getValue();
		var propValue = Ext.getCmp('system_property_value').getValue();

		var splitPropKey = propKey.split(",");
		var splitPropVal = propValue.split(",");

		if (splitPropKey != null || splitPropKey != undefined)
		{
			for (var k =0;k<splitPropKey.length-1;k++ )
			{
				addSystemProperties();
			}
			for (rname=1;rname<splitPropKey.length+1;rname++)
			{
				if (Ext.getCmp('syspropkey'+rname) == undefined)
				{
					continue;
				}

				var sysPropKey = splitPropKey[rname-1];
				var sysPropVal = splitPropVal[rname-1];
				
				if (!Ext.isEmpty(sysPropVal) && sysPropVal.indexOf("~#~") != -1)
				{
					sysPropVal = sysPropVal.replace(/~#~/g,',');
				}
				Ext.getCmp('syspropkey'+rname).setValue(sysPropKey);
				Ext.getCmp('syspropval'+rname).setValue(sysPropVal);
			}
		}
		Ext.resumeLayouts(true);

		Ext.Ajax.request({
			url: 'DefaultTestConfiguration/data/defaulttesthelpJson.jsp?mode=configurerules',
			method: 'POST',
			async: false
		});
	},
	// System properties works ends...

	// Horizon Workspace simulator starts...
	updateResourceSets: function(btn) 
	{
		var setPublisResource = "";
		var setUsername = "";
		var setPassword = "";
		var setSSO = "";

		var rdCnt = 0;
		var totalRules = inputsResourceSet;
		var arrPublisResource = new Array();

		for(var j=1; j<totalRules; j++)
		{
			if (Ext.getCmp('publisresource'+j) == undefined)
			{
				continue;
			}

			pubresource = Ext.getCmp('publisresource'+j).getValue();
			uname = Ext.getCmp('username'+j).getValue();
			pass = Ext.getCmp('pwd'+j).getValue();
			confpass = Ext.getCmp('confpwd'+j).getValue();

			var twoFactAuth = Ext.getCmp('twofacttoken'+j).getValue();
			var twofa = Ext.getCmp('twofact'+j).getChecked()[0];
			var istwofaenabled = twofa.getGroupValue();

			if (!checkblank(pubresource))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPubRsrc,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (pubresource.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(pubresource,"`*+=#.|;\"\'<>\/[]{}()?:"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (trim(pubresource) == "")
			{
				Ext.getCmp('publisresource'+j).focus();
				return;
			}
			else if(!checkHyphenText(pubresource,pubresource))
			{
				Ext.getCmp('publisresource'+j).focus();
				return;
			}
			else if (pubresource.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}
			else if (pubresource.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+j).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(uname,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('username'+j).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('username'+j).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('username'+j).focus(true,true);
					}
				});
				return;
			}

			if(pass!=null)
			{
				if(pass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if (pass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(pass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkForPassValidity(pass))
				{
					Ext.getCmp('pwd'+j).focus();
					sub = false;
					return;
				}
				else if(confpass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+j).focus(true,true);
						}
					});
					return;
				}
				else if(pass != confpass)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+j).focus(true,true);
						}
					});
					return;
				}
			}

			if (istwofaenabled == 'true')
			{
				if(!checkblank(twoFactAuth))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enter2FAToken,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+j).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+j).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+j).focus(true,true);
						}
					});
					return;
				}
				else if (!checkspecialExt(twoFactAuth,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('twofacttoken'+j).focus(true,true);
						}
					});
					return;
				}
			}
			else
			{
				twoFactAuth = 'none';
			}
		}

		var multiPublishSrcVal = "";
		var hiddenPublishSrcVal = "";
		//var multiUsrSSOVal = "";
		var multiUsrVal = "";
		var multiUsrpassVal = "";
		var multiUsrdisclaimVal = "";
		var multi2FAuthVal = "";

		for(var multi=1; multi<totalRules; multi++)
		{
			if (Ext.getCmp('publisresource'+multi) == undefined)
			{
				continue;
			}

			var multiSrcPublis = Ext.getCmp('publisresource'+multi).getValue();
			if(multiSrcPublis!=null)
			{
				if(!checkblank(multiSrcPublis))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPubRsrc,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiSrcPublis,"`*+=#.|;\"\'<>\/[]{}()?:"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiSrcPublis) == "")
				{
					Ext.getCmp('publisresource'+multi).focus();
					return;
				}
				else if (multiSrcPublis.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiSrcPublis,multiSrcPublis))
				{
					Ext.getCmp('publisresource'+multi).focus();
					return;
				}
			}

			//var multisso = Ext.getCmp('sso'+multi+'_1').getValue();
			//if(multisso == null) continue;

			var multiUname = Ext.getCmp('username'+multi).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{

					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterUsrId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiUname,"*+=|:;\"\'<>\/[]?,"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('usermultiusr'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('usermultiusr'+multi).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('username'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('username'+multi).focus();
					return;
				}
			}

			var multipass = Ext.getCmp('pwd'+multi).getValue();
			var multiconfpasswd = Ext.getCmp('confpwd'+multi).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(multipass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwd'+multi).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('pwd'+multi).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwd'+multi).focus(true,true);
						}
					});
					return;
				}
			}
			
			var multidisclaimer= Ext.getCmp('disclaimermultiusr'+multi+'_1').getValue();
			if(multidisclaimer == null) continue;

			var multi2FAuth= Ext.getCmp('twofacttoken'+multi).getValue();
			var multitwofa = Ext.getCmp('twofact'+multi).getChecked()[0];
			var ismultitwofaenabled = multitwofa.getGroupValue()
			if(multi2FAuth == null) continue;
			if(multi2FAuth != null)
			{
				if (ismultitwofaenabled == 'true')
				{
					if(!checkblank(multi2FAuth))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: enter2FAToken,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+multi).focus(true,true);
							}
						});
						return;
					}
					else if (multi2FAuth.indexOf(",") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+multi).focus(true,true);
							}
						});
						return;
					}
					else if (multi2FAuth.indexOf("..") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkdots,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+multi).focus(true,true);
							}
						});
						return;
					}
					else if (!checkspecialExt(multi2FAuth,"|"))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('twofacttoken'+multi).focus(true,true);
							}
						});
						return;
					}
				}
				else
				{
					multi2FAuth = 'none';
				}
			}


			//if(multiPublishSrcVal != null && multisso!=null && multiUname!=null && multipass!=null && multiconfpasswd!=null )
			if(multiPublishSrcVal != null && multiUname!=null && multipass!=null && multiconfpasswd!=null && multi2FAuth != null && multidisclaimer!=null)
			{
				//var tempmultiUsrSSO = Ext.getCmp('sso'+multi+'_1').getValue();
				//var strSSOValue = 'false';
				//if (tempmultiUsrSSO)
				//{
				//	strSSOValue = 'true';
				//}
				//multiUsrSSOVal+=strSSOValue+"|";

				var tempmultiUsrdisclaim = Ext.getCmp('disclaimermultiusr'+multi+'_1').getValue();
				var strdisclaimValue = 'false';
				if (tempmultiUsrdisclaim)
				{
					strdisclaimValue = 'true';
				}
				multiUsrdisclaimVal+=strdisclaimValue+",";

				var tempmulti2FA = Ext.getCmp('twofacttoken'+multi).getValue();
				var multi2FA = Ext.getCmp('twofact'+multi).getChecked()[0];
				var tempismulti2FA = multi2FA.getGroupValue();
				if (tempismulti2FA == 'false')
				{
					tempmulti2FA = 'none';
				}
				multi2FAuthVal+=tempmulti2FA+"#~#";

				var tempmultiSrcPublis = Ext.getCmp('publisresource'+multi).getValue();
				var tmpHiddenPublishSrc = tempmultiSrcPublis;
				if (!Ext.isEmpty(tmpHiddenPublishSrc) && tmpHiddenPublishSrc.indexOf(",") != -1)
				{
					tmpHiddenPublishSrc = tmpHiddenPublishSrc.replace(/,/g,'~#~');
				}
				multiPublishSrcVal+=tempmultiSrcPublis+",";
				hiddenPublishSrcVal+=tmpHiddenPublishSrc+"|";

				var tempmultiUsr = Ext.getCmp('username'+multi).getValue();
				multiUsrVal+=tempmultiUsr+"|";

				var tempmultiUsrPass = Ext.getCmp('pwd'+multi).getValue();
				multiUsrpassVal+=tempmultiUsrPass+"#~#";
			}
		}

		multiPublishSrcVal = multiPublishSrcVal.substring(0,multiPublishSrcVal.length-1);
		Ext.getCmp('Published_resources').setValue(multiPublishSrcVal);

		hiddenPublishSrcVal = hiddenPublishSrcVal.substring(0,hiddenPublishSrcVal.length-1);
		Ext.getCmp('hiddenPublishedResource').setValue(hiddenPublishSrcVal);


		//multiUsrSSOVal = multiUsrSSOVal.substring(0,multiUsrSSOVal.length-1);
		//Ext.getCmp('Single_signon').setValue(multiUsrSSOVal);

		multiUsrVal = multiUsrVal.substring(0,multiUsrVal.length-1);
		Ext.getCmp('User_id').setValue(multiUsrVal);

		multiUsrpassVal = multiUsrpassVal.substring(0,multiUsrpassVal.length-3);
		Ext.getCmp('Password').setValue(multiUsrpassVal);
		Ext.getCmp('Password').backupValue = multiUsrpassVal;

		if (Ext.getCmp('cpwd') != null && Ext.getCmp('cpwd') != undefined)
		{
			Ext.getCmp('cpwd').setValue(multiUsrpassVal);
			Ext.getCmp('cpwd').backupValue = multiUsrpassVal;
			Ext.getCmp('cpwd').setReadOnly(true);
		}
		if (Ext.getCmp('Passwordconfirmpassword') != null && Ext.getCmp('Passwordconfirmpassword') != undefined)
		{
			Ext.getCmp('Passwordconfirmpassword').setValue(multiUsrpassVal);
			Ext.getCmp('Passwordconfirmpassword').backupValue = multiUsrpassVal;
			Ext.getCmp('Passwordconfirmpassword').setReadOnly(true);
		}
		Ext.getCmp('Published_resources').setReadOnly(true);

		multi2FAuthVal = multi2FAuthVal.substring(0,multi2FAuthVal.length-3);
		Ext.getCmp('Two_factor_auth_password').setValue(multi2FAuthVal);
		Ext.getCmp('Two_factor_auth_password').backupValue = multi2FAuthVal;

		multiUsrdisclaimVal = multiUsrdisclaimVal.substring(0,multiUsrdisclaimVal.length-1);
		Ext.getCmp('Disclaimer').setValue(multiUsrdisclaimVal);


		//Ext.getCmp('Single_signon').setReadOnly(true);
		//Ext.getCmp('Single_signon').hide();
		Ext.getCmp('User_id').setReadOnly(true);
		Ext.getCmp('User_id').hide();
		Ext.getCmp('Password').setReadOnly(true);
		Ext.getCmp('Password').hide();
		Ext.getCmp('Two_factor_auth_password').setReadOnly(true);
		Ext.getCmp('Two_factor_auth_password').hide();
		Ext.getCmp('Disclaimer').setReadOnly(true);
		Ext.getCmp('Disclaimer').hide();

		Ext.getCmp('eghorizonwssimulator').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	clearResourceFieldSets: function(btn) 
	{
		var rulenamescontainer = Ext.getCmp('backupmulticontainer');
		rulenamescontainer.removeAll();
		Ext.getCmp('addResourcebtn').setText('Add');
		Ext.getCmp('NoResourcePattern').show();
		if (Ext.getCmp('con_1') != null || Ext.getCmp('con_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('con_1').removeAll();
			Ext.getCmp('con_1').hide();
		}
		Ext.getCmp('updateResourceBtn').disable();
		Ext.getCmp('clearResourceBtn').disable();
	},
	addHorizonWSResourceSet: function(btn) 
	{
		addResourceSetFields(btn);
	}, 
	configHorizonWSResourceSet: function(btn) 
	{  
		Ext.create('DefaultTestConfiguration.view.EgHorizonWSSimulator').show();

		ismulti = 'false';

		var rname = '';
		inputsResourceSet = 2;
		
		Ext.suspendLayouts();


		var ValuePublisresources = '';
		var ValueHiddenPubResources = Ext.getCmp('hiddenPublishedResource').getValue();

		if (!Ext.isEmpty(ValueHiddenPubResources))
		{
			ValuePublisresources = ValueHiddenPubResources;
		}


		var username = Ext.getCmp('User_id').getValue();
		var password = Ext.getCmp('Password').getValue();
		var ValueUsrdisclaimer = Ext.getCmp('Disclaimer').getValue();
		var ValueUsr2FA = Ext.getCmp('Two_factor_auth_password').getValue();

		//var sso = Ext.getCmp('Single_signon').getValue();

		var splitPublisResource = ValuePublisresources.split("|");
		var splitUser = username.split("|");
		//var splitSSO = sso.split("|");
		var splitPass = password.split("#~#");
		var splitUsr2FA = ValueUsr2FA.split("#~#");
		var splitUsrDisclaim = ValueUsrdisclaimer.split(",");

		if (splitPublisResource != null || splitPublisResource != undefined)
		{
			for (var k =0;k<splitPublisResource.length-1;k++ )
			{
				addResourceSetFields();
			}

			for (rname=1;rname<splitPublisResource.length+1;rname++)
			{
				if (Ext.getCmp('publisresource'+rname) == undefined)
				{
					continue;
				}

				var tmpPubResource = splitPublisResource[rname-1];
				if (!Ext.isEmpty(tmpPubResource) && tmpPubResource.indexOf('~#~') != -1)
				{
					tmpPubResource = tmpPubResource.replace(/~#~/g,',');
				}
				var tmpUserId = splitUser[rname-1];
				var tmpPassword = splitPass[rname-1];

				var str2FAToken = splitUsr2FA[rname-1];
				var strDisClaimer = splitUsrDisclaim[rname-1];
				if (!Ext.isEmpty(str2FAToken) && (str2FAToken != 'FF6EBC35F4F93E0C1057BBC2E53B1DF3' && str2FAToken.toLowerCase() != 'none'))
				{
					Ext.getCmp('twofactlabel'+rname+'_1').setValue(true);
					Ext.getCmp('twofacttoken'+rname).setVisible(true);
					Ext.getCmp('twofacttoken'+rname).setValue(str2FAToken);
					Ext.getCmp('twofacttoken'+rname).backupValue = str2FAToken;
				}

				if (!Ext.isEmpty(strDisClaimer))
				{
					if (strDisClaimer.toLowerCase() == 'true')
					{
						Ext.getCmp('disclaimermultiusr'+rname+'_1').setValue(true);
					}
					else
					{
						Ext.getCmp('disclaimermultiusr'+rname+'_2').setValue(true);
					}
				}

				Ext.getCmp('publisresource'+rname).setValue(tmpPubResource);
				Ext.getCmp('username'+rname).setValue(tmpUserId);
				Ext.getCmp('pwd'+rname).setValue(tmpPassword);
				Ext.getCmp('confpwd'+rname).setValue(tmpPassword);
				Ext.getCmp('pwd'+rname).backupValue = tmpPassword;
				Ext.getCmp('confpwd'+rname).backupValue = tmpPassword;
				//var strSSO = splitSSO[rname-1];
				//if (!Ext.isEmpty(strSSO))
				//{
				//	if (strSSO.toLowerCase() == 'true')
				//	{
				//		Ext.getCmp('sso'+rname+'_1').setValue(true);
				//	}
				//	else
				//	{
				//		Ext.getCmp('sso'+rname+'_2').setValue(true);
				//	}
				//}
			}
		}

		Ext.resumeLayouts(true);

		Ext.Ajax.request({
			url: 'DefaultTestConfiguration/data/defaulttesthelpJson.jsp?mode=configurerules',
			method: 'POST',
			async: false
		});
	},
	// Horizon Workspace simulator ends...
		
	// for Horizon Logon simulator starts
	configMultiHLSFieldSet: function(btn) {
		Ext.create('DefaultTestConfiguration.view.EgHLSPublishedResources').show();


		var multidom = '';
		inputsmultisrc = 2;
		ismultisrc = 'false';

		//var ValuePublisresources = Ext.getCmp('Published_resources').getValue();
		var ValuePublisresources = '';
		var ValueHiddenPubResources = Ext.getCmp('hiddenPublishedResource').getValue();

		var ValueUsrdomain = Ext.getCmp('Domain').getValue();
		var ValueUsrdisclaimer = Ext.getCmp('Disclaimer').getValue();
		var ValueUsr2FA = Ext.getCmp('Two_factor_auth_password').getValue();
		var Valueuser = Ext.getCmp('Username').getValue();
		var Valuepass = Ext.getCmp('Password').getValue();
		if (!Ext.isEmpty(ValueHiddenPubResources))
		{
			ValuePublisresources = ValueHiddenPubResources;
		}

		var splitPublisSrc = ValuePublisresources.split("|");
		var splitUsr2FA = ValueUsr2FA.split("#~#");
		var splitUsrDomain = ValueUsrdomain.split(",");
		var splitUsrDisclaim = ValueUsrdisclaimer.split(",");
		var splituser = Valueuser.split(",");
		var splitpass = Valuepass.split("#~#");

		if (ValueUsrdomain != null || ValueUsrdomain != undefined)
		{
			for (var k =0;k<splitUsrDomain.length-1;k++ )
			{
				addMultiHLSContact();
			}
			for (multidom=1;multidom<splitUsrDomain.length+1;multidom++)
			{
				if (!Ext.isEmpty(splitPublisSrc[multidom-1]) && splitPublisSrc[multidom-1].indexOf('~#~') != -1)
				{
					splitPublisSrc[multidom-1] = splitPublisSrc[multidom-1].replace(/~#~/g,',');
				}

				var str2FAToken = splitUsr2FA[multidom-1];
				var strDisClaimer = splitUsrDisclaim[multidom-1];
				if (!Ext.isEmpty(str2FAToken) && (str2FAToken != 'FF6EBC35F4F93E0C1057BBC2E53B1DF3' && str2FAToken.toLowerCase() != 'none'))
				{
					Ext.getCmp('twofactlabel'+multidom+'_1').setValue(true);
					Ext.getCmp('twofacttoken'+multidom).setVisible(true);
					Ext.getCmp('twofacttoken'+multidom).setValue(str2FAToken);
					Ext.getCmp('twofacttoken'+multidom).backupValue = str2FAToken;
				}

				Ext.getCmp('publisresource'+multidom).setValue(splitPublisSrc[multidom-1]);
				
				if (!Ext.isEmpty(strDisClaimer))
				{
					if (strDisClaimer.toLowerCase() == 'true')
					{
						Ext.getCmp('disclaimermultiusr'+multidom+'_1').setValue(true);
					}
					else
					{
						Ext.getCmp('disclaimermultiusr'+multidom+'_2').setValue(true);
					}
				}
				Ext.getCmp('domainmultiusr'+multidom).setValue(splitUsrDomain[multidom-1]);
				Ext.getCmp('usermultiusr'+multidom).setValue(splituser[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('confpwdmultiusr'+multidom).setValue(splitpass[multidom-1]);
				Ext.getCmp('pwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
				Ext.getCmp('confpwdmultiusr'+multidom).backupValue = splitpass[multidom-1];
			}
		}
		Ext.Ajax.request({
			url: 'DefaultTestConfiguration/data/defaulttesthelpJson.jsp?mode=egconfiguremultipleusers',
			method: 'POST',
			async: false
		});
	},
	addMultiHLSSource: function(btn) {
		addMultiHLSContact(btn);
	},
	ClearMultiHLSSource: function() {
		var backupmulticontainer = Ext.getCmp('backupmulticontainer');
		backupmulticontainer.removeAll();
		Ext.getCmp('addMultiHLSbtn').setText('Add');
		Ext.getCmp('NoMultiUsrPattern').show();
		if (Ext.getCmp('conmulti_1') != null || Ext.getCmp('conmulti_1') != undefined)
		{
			ismultisrc = 'true';
			Ext.getCmp('conmulti_1').removeAll();
			Ext.getCmp('conmulti_1').hide();
		}
		Ext.getCmp('updateMultiHLSbtn').disable();
		Ext.getCmp('clearMultiHLSbtn').disable();
	},
	UpdateMultiHLSSource: function() {

		var multiinputs = inputsmultisrc;

		for (var mul=1;mul<multiinputs-1;mul++)
		{
			if (Ext.getCmp('domainmultiusr'+mul) == undefined)
			{
				continue;
			}
			var publishResource = Ext.getCmp('publisresource'+mul).getValue();
			var twoFactAuth = Ext.getCmp('twofacttoken'+mul).getValue();
			var domain = Ext.getCmp('domainmultiusr'+mul).getValue();
			var uname = Ext.getCmp('usermultiusr'+mul).getValue();
			var pass = Ext.getCmp('pwdmultiusr'+mul).getValue();
			var confpasswd = Ext.getCmp('confpwdmultiusr'+mul).getValue();

			var twofa = Ext.getCmp('twofact'+mul).getChecked()[0];
			var istwofaenabled = twofa.getGroupValue();

			if (!checkblank(publishResource))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPubRsrc,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(publishResource,"`*+=#.|;\"\'<>\/[]{}()?"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(publishResource) == "")
			{
				Ext.getCmp('publisresource'+mul).focus();
				return;
			}
			else if(!checkHyphenText(publishResource,publishResource))
			{
				Ext.getCmp('publisresource'+mul).focus();
				return;
			}
			else if (publishResource.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('publisresource'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (publishResource.indexOf(":") > -1)
			{
				var val = publishResource;
				if (val.indexOf(",") != -1)
				{
					var values = val.split(",");
					for(var v=0;v < values.length;v++)
					{
						var tmpVal = values[v];

						if(tmpVal.charAt(0) == ':' || tmpVal.charAt(tmpVal.length - 1) == ':')
						{
							Ext.Msg.show ({
								title: pageName,
								msg: "Published resource should not start or end with a colon",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mul).focus(true,true);
								}
							});
							return;
						}
						else
						{
							var moreColons = new Array();
							for(var k=0;k < tmpVal.length;k++)
							{
								if (tmpVal.charAt(k) == ':')
								{
									moreColons.push(k);
								}

								if(tmpVal.charAt(k) == ':' && tmpVal.charAt(k + 1) == ':')
								{
									Ext.Msg.show ({
										title: pageName,
										msg: "Cannot have ':' in consecutive positions",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mul).focus(true,true);
										}
									});
									moreColons = new Array();
									return;
								}
								else
								{
									continue;
								}
							}
							
							if (moreColons.length > 1)
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mul).focus(true,true);
									}
								});
								moreColons = new Array();
								return;
							}
						}
					}
				}
				else
				{
					if(val.charAt(0) == ':' || val.charAt(val.length - 1) == ':')
					{
						Ext.Msg.show ({
							title: pageName,
							msg: "Published resource should not start or end with a colon",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('publisresource'+mul).focus(true,true);
							}
						});
						return;
					}
					else
					{
						var moreColons = new Array();
						for(var k=0;k < val.length;k++)
						{
							if (val.charAt(k) == ':')
							{
								moreColons.push(k);
							}

							if(val.charAt(k) == ':' && val.charAt(k + 1) == ':')
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Cannot have ':' in consecutive positions",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mul).focus(true,true);
									}
								});
								moreColons = new Array();
								return ;
							}
							else
							{
								continue;
							}
						}

						if (moreColons.length > 1)
						{
							Ext.Msg.show ({
								title: pageName,
								msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mul).focus(true,true);
								}
							});
							moreColons = new Array();
							return;
						}
					}
				}
			}
			
			if (istwofaenabled == 'true')
			{
				if(!checkblank(twoFactAuth))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enter2FAToken,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (twoFactAuth.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
				else if (!checkspecialExt(twoFactAuth,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('twofacttoken'+mul).focus(true,true);
						}
					});
					return;
				}
			}
			else
			{
				twoFactAuth = 'none';
			}

			if(!checkblank(domain))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterDomain,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			if (!checkDomain(domain,"true"))
			{
				Ext.getCmp('domainmultiusr'+mul).focus(true,true);
				return;
			}
			else if (domain.indexOf(",") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(!checkHyphenText(domain,domain))
			{
				Ext.getCmp('domainmultiusr'+mul).focus();
				return;
			}
			else if (domain.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('domainmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}

			if (!checkblank(uname))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterUsrId,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (!checkspecialExt(uname,"*+=|:;\"\'<>\/[]?,"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (trim(uname) == "")
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if(!checkHyphenText(uname,uname))
			{
				Ext.getCmp('usermultiusr'+mul).focus();
				return;
			}
			else if (uname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkdots,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if (uname.indexOf("  ") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkSpaces,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('usermultiusr'+mul).focus(true,true);
					}
				});
				return;
			}

			if(pass == "")
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if (pass.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(!checkspecialnomess(pass,"|"))
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: PwdNotContainPipe,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if(pass.indexOf("#~#")>-1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: _checkHashTildeHash,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('pwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if(!checkForPassValidity(pass))
			{
				Ext.getCmp('pwdmultiusr'+mul).focus();
				sub = false;
				return;
			}
			else if(confpasswd == "")
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: enterCnfPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
			else if (confpasswd.indexOf("$unconfigured") > -1)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: donotSpecifyKey,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				return;
			}
			else if(pass != confpasswd)
			{
				Ext.Msg.show({
					title: alertMsgSrcTitle,
					msg: matchPwd,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('confpwdmultiusr'+mul).focus(true,true);
					}
				});
				sub = false;
				return;
			}
		}

		var multiPublishSrcVal = "";
		var hiddenPublishSrcVal = "";
		var multiUsrdomainVal = "";
		var multiUsrdisclaimVal = "";
		var multi2FAuthVal = "";
		var multiUsrVal = "";
		var multiUsrpassVal = "";

		for(var mulusr=1; mulusr<multiinputs; mulusr++)
		{
			if (Ext.getCmp('domainmultiusr'+mulusr) == undefined)
			{
				continue;
			}

			var multiSrcPublis = Ext.getCmp('publisresource'+mulusr).getValue();
			if(multiSrcPublis!=null)
			{
				if(!checkblank(multiSrcPublis))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPubRsrc,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiSrcPublis,"`*+=#.|;\"\'<>\/[]{}()?"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiSrcPublis) == "")
				{
					Ext.getCmp('publisresource'+mulusr).focus();
					return;
				}
				else if (multiSrcPublis.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiSrcPublis.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('publisresource'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiSrcPublis,multiSrcPublis))
				{
					Ext.getCmp('publisresource'+mulusr).focus();
					return;
				}
				else if (multiSrcPublis.indexOf(":") > -1)
				{
					var val = multiSrcPublis;
					if (val.indexOf(",") != -1)
					{
						var values = val.split(",");
						for(var v=0;v < values.length;v++)
						{
							var tmpVal = values[v];

							if(tmpVal.charAt(0) == ':' || tmpVal.charAt(tmpVal.length - 1) == ':')
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Published resource should not start or end with a colon",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mulusr).focus(true,true);
									}
								});
								return;
							}
							else
							{
								var moreColons = new Array();
								for(var k=0;k < tmpVal.length;k++)
								{
									if (tmpVal.charAt(k) == ':')
									{
										moreColons.push(k);
									}
									if(tmpVal.charAt(k) == ':' && tmpVal.charAt(k + 1) == ':')
									{
										Ext.Msg.show ({
											title: pageName,
											msg: "Cannot have ':' in consecutive positions",
											buttons: Ext.Msg.OK,
											icon: 'iconExclamation',
											fn: function() {
												Ext.getCmp('publisresource'+mulusr).focus(true,true);
											}
										});
										moreColons = new Array();
										return;
									}
									else
									{
										continue;
									}
								}

								if (moreColons.length > 1)
								{
									Ext.Msg.show ({
										title: pageName,
										msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mulusr).focus(true,true);
										}
									});
									moreColons = new Array();
									return;
								}
							}
						}
					}
					else
					{
						if(val.charAt(0) == ':' || val.charAt(val.length - 1) == ':')
						{
							Ext.Msg.show ({
								title: pageName,
								msg: "Published resource should not start or end with a colon",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('publisresource'+mulusr).focus(true,true);
								}
							});
							return;
						}
						else
						{
							var moreColons = new Array();
							for(var k=0;k < val.length;k++)
							{
								if (val.charAt(k) == ':')
								{
									moreColons.push(k);
								}

								if(val.charAt(k) == ':' && val.charAt(k + 1) == ':')
								{
									Ext.Msg.show ({
										title: pageName,
										msg: "Cannot have ':' in consecutive positions",
										buttons: Ext.Msg.OK,
										icon: 'iconExclamation',
										fn: function() {
											Ext.getCmp('publisresource'+mulusr).focus(true,true);
										}
									});
									moreColons = new Array();
									return ;
								}
								else
								{
									continue;
								}
							}

							if (moreColons.length > 1)
							{
								Ext.Msg.show ({
									title: pageName,
									msg: "Please enter the application/desktop name in this format ApplicationOrDesktop[:WindowTitle]",
									buttons: Ext.Msg.OK,
									icon: 'iconExclamation',
									fn: function() {
										Ext.getCmp('publisresource'+mulusr).focus(true,true);
									}
								});
								moreColons = new Array();
								return;
							}
						}
					}
				}
			}

			var multidisclaimer= Ext.getCmp('disclaimermultiusr'+mulusr+'_1').getValue();
			if(multidisclaimer == null) continue;

			var multidomain= Ext.getCmp('domainmultiusr'+mulusr).getValue();
			if(multidomain == null) continue;
			if(multidomain != null)
			{
				if (!checkDomain(multidomain,"true"))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
					return;
				}
				else if (multidomain.indexOf(",") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multidomain.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('domainmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multidomain,multidomain))
				{
					Ext.getCmp('domainmultiusr'+mulusr).focus();
					return;
				}
			}

			var multi2FAuth= Ext.getCmp('twofacttoken'+mulusr).getValue();
			var multitwofa = Ext.getCmp('twofact'+mulusr).getChecked()[0];
			var ismultitwofaenabled = multitwofa.getGroupValue()
			if(multi2FAuth == null) continue;
			if(multi2FAuth != null)
			{
				if (ismultitwofaenabled == 'true')
				{
					if(!checkblank(multi2FAuth))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: enter2FAToken,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
					else if (multi2FAuth.indexOf(",") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
					else if (multi2FAuth.indexOf("..") > -1)
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkdots,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
					else if (!checkspecialExt(multi2FAuth,"|"))
					{
						Ext.Msg.show({
							title: alertMsgSrcTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('twofacttoken'+mulusr).focus(true,true);
							}
						});
						return;
					}
				}
				else
				{
					multi2FAuth = 'none';
				}
			}
			
			var multiUname = Ext.getCmp('usermultiusr'+mulusr).getValue();
			if(multiUname!=null)
			{
				if(!checkblank(multiUname))
				{

					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterUsrId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialExt(multiUname,"*+=|:;\"\'<>\/[]?,"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(trim(multiUname) == "")
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
				else if (multiUname.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiUname.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('usermultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkHyphenText(multiUname,multiUname))
				{
					Ext.getCmp('usermultiusr'+mulusr).focus();
					return;
				}
			}

			var multipass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
			var multiconfpasswd = Ext.getCmp('confpwdmultiusr'+mulusr).getValue();
			if(multipass!=null && multiconfpasswd!=null )
			{
				if (multipass == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multipass.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(multipass,"|"))
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(multipass.indexOf("#~#")>-1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: _checkHashTildeHash,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pwdmultiusr'+mulusr).focus(true,true);
						}
					});
					sub = false;
					return;
				}
				else if(!checkForPassValidity(multipass))
				{
					Ext.getCmp('pwdmultiusr'+mulusr).focus();
					sub = false;
					return;
				}
				else if(multiconfpasswd == "")
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if (multiconfpasswd.indexOf("$unconfigured") > -1)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: donotSpecifyKey,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
				else if(multipass != multiconfpasswd)
				{
					Ext.Msg.show({
						title: alertMsgSrcTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpwdmultiusr'+mulusr).focus(true,true);
						}
					});
					return;
				}
			}

			if(multiPublishSrcVal != null && multi2FAuth != null && multidomain!=null && multidisclaimer!=null && multiUname!=null && multipass!=null && multiconfpasswd!=null )
			{
				var tempmultiUsrdoma = Ext.getCmp('domainmultiusr'+mulusr).getValue();
				multiUsrdomainVal+=tempmultiUsrdoma+",";

				var tempmultiUsrdisclaim = Ext.getCmp('disclaimermultiusr'+mulusr+'_1').getValue();
				var strdisclaimValue = 'false';
				if (tempmultiUsrdisclaim)
				{
					strdisclaimValue = 'true';
				}
				multiUsrdisclaimVal+=strdisclaimValue+",";

				var tempmulti2FA = Ext.getCmp('twofacttoken'+mulusr).getValue();
				var multi2FA = Ext.getCmp('twofact'+mulusr).getChecked()[0];
				var tempismulti2FA = multi2FA.getGroupValue();
				if (tempismulti2FA == 'false')
				{
					tempmulti2FA = 'none';
				}
				multi2FAuthVal+=tempmulti2FA+"#~#";

				var tempmultiSrcPublis = Ext.getCmp('publisresource'+mulusr).getValue();
				var tmpHiddenPublishSrc = tempmultiSrcPublis;
				if (!Ext.isEmpty(tmpHiddenPublishSrc) && tmpHiddenPublishSrc.indexOf(",") != -1)
				{
					tmpHiddenPublishSrc = tmpHiddenPublishSrc.replace(/,/g,'~#~');
				}
				multiPublishSrcVal+=tempmultiSrcPublis+",";
				hiddenPublishSrcVal+=tmpHiddenPublishSrc+"|";

				var tempmultiUsr = Ext.getCmp('usermultiusr'+mulusr).getValue();
				multiUsrVal+=tempmultiUsr+",";

				var tempmultiUsrPass = Ext.getCmp('pwdmultiusr'+mulusr).getValue();
				multiUsrpassVal+=tempmultiUsrPass+"#~#";
			}
		}
		multiPublishSrcVal = multiPublishSrcVal.substring(0,multiPublishSrcVal.length-1);
		Ext.getCmp('Published_resources').setValue(multiPublishSrcVal);

		hiddenPublishSrcVal = hiddenPublishSrcVal.substring(0,hiddenPublishSrcVal.length-1);
		Ext.getCmp('hiddenPublishedResource').setValue(hiddenPublishSrcVal);

		multi2FAuthVal = multi2FAuthVal.substring(0,multi2FAuthVal.length-3);
		Ext.getCmp('Two_factor_auth_password').setValue(multi2FAuthVal);
		Ext.getCmp('Two_factor_auth_password').backupValue = multi2FAuthVal;

		multiUsrdomainVal = multiUsrdomainVal.substring(0,multiUsrdomainVal.length-1);
		Ext.getCmp('Domain').setValue(multiUsrdomainVal);

		multiUsrdisclaimVal = multiUsrdisclaimVal.substring(0,multiUsrdisclaimVal.length-1);
		Ext.getCmp('Disclaimer').setValue(multiUsrdisclaimVal);

		multiUsrVal = multiUsrVal.substring(0,multiUsrVal.length-1);
		Ext.getCmp('Username').setValue(multiUsrVal);

		multiUsrpassVal = multiUsrpassVal.substring(0,multiUsrpassVal.length-3);
		Ext.getCmp('Password').setValue(multiUsrpassVal);
		Ext.getCmp('Password').backupValue = multiUsrpassVal;

		if (Ext.getCmp('cpwd') != null && Ext.getCmp('cpwd') != undefined)
		{
			Ext.getCmp('cpwd').setValue(multiUsrpassVal);
			Ext.getCmp('cpwd').backupValue = multiUsrpassVal;
			Ext.getCmp('cpwd').setReadOnly(true);
		}
		if (Ext.getCmp('Passwordconfirmpassword') != null && Ext.getCmp('Passwordconfirmpassword') != undefined)
		{
			Ext.getCmp('Passwordconfirmpassword').setValue(multiUsrpassVal);
			Ext.getCmp('Passwordconfirmpassword').backupValue = multiUsrpassVal;
			Ext.getCmp('Passwordconfirmpassword').setReadOnly(true);
		}
		Ext.getCmp('Published_resources').setReadOnly(true);
		Ext.getCmp('Two_factor_auth_password').setReadOnly(true);
		Ext.getCmp('Two_factor_auth_password').hide();
		Ext.getCmp('Domain').setReadOnly(true);
		Ext.getCmp('Domain').hide();
		Ext.getCmp('Disclaimer').setReadOnly(true);
		Ext.getCmp('Disclaimer').hide();
		Ext.getCmp('Username').setReadOnly(true);
		Ext.getCmp('Username').hide();
		Ext.getCmp('Password').setReadOnly(true);
		Ext.getCmp('Password').hide();
		Ext.getCmp('eghlspublishedresources').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	// for Horizon Logon simulator ends

	// Exchange site email starts...
	updateEmailSets: function(btn) 
	{
		var setEmailId = "";
		var setPassword = "";
		var rdCnt = 0;
		var totalRules = inputsEmail;
		var arrEmailIds = new Array();

		for(var j=1; j<totalRules; j++)
		{
			if (Ext.getCmp('emailid'+j) == undefined)
			{
				continue;
			}
			emailID = Ext.getCmp('emailid'+j).getValue();
			pass = Ext.getCmp('pass'+j).getValue();
			confpass = Ext.getCmp('confpass'+j).getValue();

			if(emailID!=null)
			{
				var result = validateEmail(emailID);
				rdCnt++;
				if(!checkblank(emailID) || (emailID == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: mailRcv_valid,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('emailid'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!validateSingleByte(emailID))
				{
					Ext.Msg.show(
					{
						title : ExchangeTitle,
						msg : mailIDDBL+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('emailid'+j).focus(true,true);
						}
					});
					return;
				}
				else if(result == null || result == undefined || result == false)
				{
					Ext.Msg.show({
						title : ExchangeTitle,
						msg : mailRcv_valid+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('emailid'+j).focus(true,true);
						}
					});
					return;
				}
				else if (emailID.indexOf(',') != -1)
				{
					Ext.Msg.show({
						title : ExchangeTitle,
						msg : mail_valid+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('emailid'+j).focus(true,true);
						}
					});
					return;
				}

				var x_idx = arrEmailIds.indexOf(emailID);
				if (x_idx != -1)
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: duplicateMailId,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('emailid'+j).focus(true,true);
						}
					});
					return;
				}
				arrEmailIds[j] = emailID;
			}


			if(pass!=null)
			{
				if(pass == "")
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: enterPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pass'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspecialnomess(pass,"|"))
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: PwdNotContainPipe,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('pass'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkForPassValidity(pass))
				{
					Ext.getCmp('pass'+j).focus();
					sub = false;
					return;
				}
				else if(confpass == "")
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: enterCnfPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpass'+j).focus(true,true);
						}
					});
					return;
				}
				else if(pass != confpass)
				{
					Ext.Msg.show({
						title: ExchangeTitle,
						msg: matchPwd,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('confpass'+j).focus(true,true);
						}
					});
					return;
				}
			}

			setEmailId += emailID+"|";
			setPassword += pass+"#~#";
		}

		setEmailId = setEmailId.substring(0,setEmailId.length-1);
		setPassword = setPassword.substring(0,setPassword.length-3);

		Ext.getCmp('Email_id').setValue(setEmailId);
		Ext.getCmp('Email_password').setValue(setPassword);
		Ext.getCmp('Email_password').backupValue = setPassword;
		Ext.getCmp('egemailconfiguration').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	clearEmailFields: function(btn) 
	{
		var rulenamescontainer = Ext.getCmp('emailmorecontainer');
		rulenamescontainer.removeAll();
		Ext.getCmp('addEmailBtn').setText('Add');
		Ext.getCmp('NoEmailContainer').show();
		if (Ext.getCmp('con_1') != null || Ext.getCmp('con_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('con_1').removeAll();
			Ext.getCmp('con_1').hide();
		}
		Ext.getCmp('updateEmailBtn').disable();
		Ext.getCmp('clearEmailBtn').disable();
	},
	addMainEmailContact: function(btn) 
	{
		addEmailContactFields(btn);
	},
	configEMailCredential: function(btn) 
	{  
		Ext.create('DefaultTestConfiguration.view.EgEMailConfiguration').show();

		ismulti = 'false';

		var rname = '';
		inputsEmail = 2;
		
		Ext.suspendLayouts();

		var emailID = Ext.getCmp('Email_id').getValue();
		var password = Ext.getCmp('Email_password').getValue();

		var splitMailID = emailID.split("|");
		var splitPass = password.split("#~#");

		if (splitMailID != null || splitMailID != undefined)
		{
			for (var k =0;k<splitMailID.length-1;k++ )
			{
				addEmailContactFields();
			}
			for (rname=1;rname<splitMailID.length+1;rname++)
			{
				if (Ext.getCmp('emailid'+rname) == undefined)
				{
					continue;
				}
				var tmpMailId = splitMailID[rname-1];
				var tmpPassword = splitPass[rname-1];
				Ext.getCmp('emailid'+rname).setValue(tmpMailId);
				Ext.getCmp('pass'+rname).setValue(tmpPassword);
				Ext.getCmp('confpass'+rname).setValue(tmpPassword);
				Ext.getCmp('pass'+rname).backupValue = tmpPassword;
				Ext.getCmp('confpass'+rname).backupValue = tmpPassword;
			}
		}
		Ext.resumeLayouts(true);

		Ext.Ajax.request({
			url: 'DefaultTestConfiguration/data/defaulttesthelpJson.jsp?mode=configurerules',
			method: 'POST',
			async: false
		});
	},
	// Exchange site email ends...

	overrideFilterLogicForUpdate: function(obj) 
	{
		var allOk = true;
		var fieldID = obj.id;
		var textId = obj.id;
		var textBoxId = textId;
		var textValue = obj.value;

		if (!Ext.isEmpty(textValue))
		{
			if (textValue.charAt(0) == ' ' || textValue.charAt(textValue.length - 1) == ' ')
			{
				textValue = textValue.trim();
			}
		}
		textId = textId.substring(textId.lastIndexOf("c")+1);

		//Ext.getCmp('flaccept_'+textId).setDisabled(true);
		//Ext.getCmp('flaccept_'+textId).show();

		var childIncArr = new Array();
		var mainContainer = Ext.getCmp('includePatternContainer'+textId);
		var conLength = mainContainer.items.length;
		var isFromDisable = false;
		var disableId = '';
		if (conLength > 0)
		{
			for (var cnt=0;cnt< conLength;cnt++ )
			{
				var tmpLevelObj = Ext.getCmp('rulename'+textId+'_outercont'+(cnt+1));
				if (!Ext.isEmpty(tmpLevelObj) && tmpLevelObj.hasCls('disabled-mycomponent'))
				{
					isFromDisable = true;
					disableId = tmpLevelObj.id;
					continue;
				}
				childIncArr.push((cnt+1).toString());
			}
		}

		if (isFromDisable)
		{
			var fieldLength = disableId.length;
			var levelNumber = disableId.charAt((fieldLength-1));

			if (!Ext.isEmpty(textValue) && textValue.indexOf(levelNumber) != -1)
			{
				allOk = false;
				return false;
			}
			else
			{
				allOk = filterLogicFromRemoveMsg(Ext.getCmp('filterlogic'+textId),disableId);
			}
		}

		if (!Ext.isEmpty(childIncArr))
		{
			if (Ext.isEmpty(textValue))
			{
				allOk = false;
				return false;
			}
			else if (!checkFilterLogicFormat(textValue))
			{
				allOk = false;
				return false;
			}

			var valuesArr = new Array();
			valuesArr  = textValue.split(' ');

			var tmpArr = new Array();
			for (var v=0;v<valuesArr.length ;v++ )
			{
				var tmpStr = valuesArr[v];
				if (!Ext.isEmpty(tmpStr))
				{
					if (tmpStr.indexOf('(') != -1)
					{
						tmpStr = tmpStr.replace(/\(/g,"");
					}
					if (tmpStr.indexOf(')') != -1)
					{
						tmpStr = tmpStr.replace(/\)/g,"");
					}

					if (tmpStr.toLowerCase().indexOf('and') != -1 || tmpStr.toLowerCase().indexOf('or') != -1 )
					{
						continue;
					}
					else
					{
						tmpArr.push(tmpStr);
					}
				}
			}

			valuesArr = new Array();
			valuesArr = tmpArr;
			delete tmpArr;

			if (childIncArr != null && childIncArr.length > 0)
			{
				var definedFilters = '';
				childIncArr.forEach(function(item,index){
					if (!Ext.isEmpty(item))
					{
						if (valuesArr.indexOf(item.toString()) == -1) 
						{
							definedFilters += item+',';
						}
					}
				});

				if (!Ext.isEmpty(definedFilters))
				{
					allOk = false;
					return false;
				}
			}

			if (valuesArr != null && valuesArr.length > 0)
			{
				var definedFilters = '';
				valuesArr.forEach(function(item,index){
					if (childIncArr.indexOf(item.toString()) == -1) 
					{
						definedFilters += item+',';
					}
				});

				if (!Ext.isEmpty(definedFilters))
				{
					allOk = false;
					return false;
				}
			}
		}

		if (allOk)
		{
			Ext.getCmp('errorState_'+textId).update('');
			Ext.getCmp('flaccept_'+textId).setDisabled(false);
		}
		return allOk;
	},
	overrideFilterLogic: function(obj) 
	{
		var allOk = true;
		var fieldID = obj.id;
		var textId = obj.id;
		var textBoxId = textId;
		var textValue = obj.value;

		if (!Ext.isEmpty(textValue))
		{
			if (textValue.charAt(0) == ' ' || textValue.charAt(textValue.length - 1) == ' ')
			{
				textValue = textValue.trim();
			}
		}
		textId = textId.substring(textId.lastIndexOf("c")+1);

		Ext.getCmp('flaccept_'+textId).setDisabled(true);
		Ext.getCmp('flaccept_'+textId).show();

		var childIncArr = new Array();
		var mainContainer = Ext.getCmp('includePatternContainer'+textId);
		var conLength = mainContainer.items.length;
		var isFromDisable = false;
		var disableId = '';
		if (conLength > 0)
		{
			for (var cnt=0;cnt< conLength;cnt++ )
			{
				var tmpLevelObj = Ext.getCmp('rulename'+textId+'_outercont'+(cnt+1));
				if (!Ext.isEmpty(tmpLevelObj) && tmpLevelObj.hasCls('disabled-mycomponent'))
				{
					isFromDisable = true;
					disableId = tmpLevelObj.id;
					continue;
				}
				childIncArr.push((cnt+1).toString());
			}
		}

		if (isFromDisable)
		{
			var fieldLength = disableId.length;
			var levelNumber = disableId.charAt((fieldLength-1));

			if (!Ext.isEmpty(textValue) && textValue.indexOf(levelNumber) != -1)
			{
				var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+deleteFilterMsg+'</td></tr></table>';

				Ext.getCmp('errorState_'+textId).update(htm1);
				allOk = false;
				return false;
			}
			else
			{
				allOk = filterLogicFromRemoveMsg(Ext.getCmp('filterlogic'+textId),disableId);
			}
		}

		if (!Ext.isEmpty(childIncArr))
		{
			if (Ext.isEmpty(textValue))
			{
				var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+_checkempty+'</td></tr></table>';

				Ext.getCmp('errorState_'+textId).update(htm1);
				allOk = false;
				return false;
			}
			else if (!checkFilterLogicFormat(textValue))
			{
				var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+filterLogicPatternMsg+'</td></tr></table>';

				Ext.getCmp('errorState_'+textId).update(htm1);
				allOk = false;
				return false;
			}

			var valuesArr = new Array();
			valuesArr  = textValue.split(' ');

			var tmpArr = new Array();
			for (var v=0;v<valuesArr.length ;v++ )
			{
				var tmpStr = valuesArr[v];
				if (!Ext.isEmpty(tmpStr))
				{
					if (tmpStr.indexOf('(') != -1)
					{
						tmpStr = tmpStr.replace(/\(/g,"");
					}
					if (tmpStr.indexOf(')') != -1)
					{
						tmpStr = tmpStr.replace(/\)/g,"");
					}

					if (tmpStr.toLowerCase().indexOf('and') != -1 || tmpStr.toLowerCase().indexOf('or') != -1 )
					{
						continue;
					}
					else
					{
						tmpArr.push(tmpStr);
					}
				}
			}

			valuesArr = new Array();
			valuesArr = tmpArr;
			delete tmpArr;

			if (childIncArr != null && childIncArr.length > 0)
			{
				var definedFilters = '';
				childIncArr.forEach(function(item,index){
					if (!Ext.isEmpty(item))
					{
						if (valuesArr.indexOf(item.toString()) == -1) 
						{
							definedFilters += item+',';
						}
					}
				});

				if (!Ext.isEmpty(definedFilters))
				{
					definedFilters = definedFilters.substring(0,definedFilters.length-1);
					var alertMsg = 'Filter condition '+definedFilters+' is defined but not referenced in your filter logic';
					if (!Ext.isEmpty(definedFilters) && definedFilters.indexOf(',') != -1)
					{
						alertMsg = 'Filter conditions '+definedFilters+' are defined but not referenced in your filter logic';
					}

					var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+alertMsg+'</td></tr></table>';

					Ext.getCmp('errorState_'+textId).update(htm1);
					allOk = false;
					return false;
				}
			}

			if (valuesArr != null && valuesArr.length > 0)
			{
				var definedFilters = '';
				valuesArr.forEach(function(item,index){
					if (childIncArr.indexOf(item.toString()) == -1) 
					{
						definedFilters += item+',';
					}
				});

				if (!Ext.isEmpty(definedFilters))
				{
					var tmpStr = 'The filter logic references an undefined filter';
					var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+tmpStr+'</td></tr></table>';

					Ext.getCmp('errorState_'+textId).update(htm1);
					allOk = false;
					return false;
				}
			}
		}

		if (allOk)
		{
			Ext.getCmp('errorState_'+textId).update('');
			Ext.getCmp('flaccept_'+textId).setDisabled(false);
		}
		return true;
	},
	buildFilterLogic: function(obj) 
	{
		var textId = obj.id;
		var textBoxId = textId;
		var textValue = obj.value;
		if (Ext.isEmpty(textValue))
		{
			Ext.Msg.show({
				title: rulePageTitle,
				msg: _checkempty,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp(obj.id).focus(true,true);
				}
			});
			return;
		}
	},
	addMainContact: function(btn) 
	{
		addRuleContact(btn);
	},
	clearFilterRules: function(btn) 
	{
		var rulenamescontainer = Ext.getCmp('rulenamescontainer');
		rulenamescontainer.removeAll();
		Ext.getCmp('addRuleNamebtn').setText('Add');
		Ext.getCmp('NoRuleNamePattern').show();
		if (Ext.getCmp('configrule_1') != null || Ext.getCmp('configrule_1') != undefined)
		{
			ismulti = 'true';
			Ext.getCmp('configrule_1').removeAll();
			Ext.getCmp('configrule_1').hide();
		}
		Ext.getCmp('updateRuleName').disable();
		Ext.getCmp('clearRuleName').disable();
	},
	createRulesForSyslog: function(btn) 
	{  
		Ext.create('DefaultTestConfiguration.view.EgConfigureRulenames').show();

		ismulti = 'false';

		var testName = publicJson['testName'];
		var rname = '';
		inputsRule = 2;
		
		Ext.suspendLayouts();

		var ruleName = Ext.getCmp('rule_name').getValue();
		var facility = Ext.getCmp('facility').getValue();
		var filterHost = Ext.getCmp('filter_host').getValue();
		var level = Ext.getCmp('level').getValue();
		var filterLogic = Ext.getCmp('filter_logic').getValue();
		var excludePattern = Ext.getCmp('exclude_Patterns').getValue();

		var splitRuleName = ruleName.split("^#^");
		var splitFacility = facility.split("^#^");
		var splitFilterHost = filterHost.split("^#^");
		var splitLevel = level.split("^#^");
		var splitFilterLogic = filterLogic.split("^#^");
		if (!Ext.isEmpty(splitFilterLogic) && (splitFilterLogic == '$unconfigured' || splitFilterLogic == 'none'))
		{
			splitFilterLogic = '1';
		}

		var splitExcPattern = excludePattern.split("^#^");
		if (splitRuleName != null || splitRuleName != undefined)
		{
			for (var k =0;k<splitRuleName.length-1;k++ )
			{
				addRuleContact();
			}
			for (rname=1;rname<splitRuleName.length+1;rname++)
			{
				if (Ext.getCmp('rulename'+rname) == undefined)
				{
					continue;
				}
				var tmpRuleName = splitRuleName[rname-1];
				var tmpFacility = splitFacility[rname-1];
				var tmpFilterHost = splitFilterHost[rname-1];
				var tmpLevel = splitLevel[rname-1];
				var tmpFltLogic = splitFilterLogic[rname-1];
				var tmpExcPattern = splitExcPattern[rname-1];
				
				var includePatterns = '';
				if (!Ext.isEmpty(tmpRuleName) && tmpRuleName != '$unconfigured')
				{
					includePatterns = tmpRuleName.substring(tmpRuleName.indexOf("=")+1);
					tmpRuleName = tmpRuleName.substring(0,tmpRuleName.indexOf("="));
				}

				var incPattArr = new Array();
				if (!Ext.isEmpty(includePatterns))
				{
					incPattArr = includePatterns.split("|");
				}

				tmpFacility = tmpFacility.substring(tmpFacility.indexOf("=")+1);
				if (!Ext.isEmpty(tmpFacility) && tmpFacility.indexOf("|") != -1)
				{
					tmpFacility = tmpFacility.replace(/\|/g,',');
				}

				tmpFilterHost = tmpFilterHost.substring(tmpFilterHost.indexOf("=")+1);
				if (!Ext.isEmpty(tmpFilterHost) && tmpFilterHost.indexOf("|") != -1)
				{
					tmpFilterHost = tmpFilterHost.replace(/\|/g,',');
				}

				tmpLevel = tmpLevel.substring(tmpLevel.indexOf("=")+1);
				if (!Ext.isEmpty(tmpLevel) && tmpLevel.indexOf("|") != -1)
				{
					tmpLevel = tmpLevel.replace(/\|/g,',');
				}

				tmpFltLogic = tmpFltLogic.substring(tmpFltLogic.indexOf("=")+1);
				if (!Ext.isEmpty(tmpFltLogic) && tmpFltLogic.indexOf("|") != -1)
				{
					tmpFltLogic = tmpFltLogic.replace(/\|/g,',');
				}

				tmpExcPattern = tmpExcPattern.substring(tmpExcPattern.indexOf("=")+1);
				if (!Ext.isEmpty(tmpExcPattern) && tmpExcPattern.indexOf("|") != -1)
				{
					tmpExcPattern = tmpExcPattern.replace(/\|/g,',');
				}

				Ext.getCmp('rulename'+rname).setValue(tmpRuleName);
				Ext.getCmp('facility'+rname).setValue(tmpFacility);
				Ext.getCmp('filterhost'+rname).setValue(tmpFilterHost);
				Ext.getCmp('level'+rname).setValue(tmpLevel);
				if (incPattArr != null && incPattArr.length > 0)
				{
					for (var ip =1;ip<incPattArr.length;ip++ )
					{
						addIncludePatternWithValue('multiPatternDiv'+rname);
					}

					for (var inc = 0;inc<incPattArr.length ;inc++ )
					{
						Ext.getCmp('rulename'+rname+'_incpatt'+(inc+1)).setValue(incPattArr[inc]);
					}
				}

				//Ext.getCmp('filterlogic'+rname).setValue(tmpFltLogic);
				Ext.getCmp('filterlogic'+rname).setRawValue(tmpFltLogic);
				Ext.getCmp('excludepattern'+rname).setValue(tmpExcPattern);

				if (testName == 'DeviceSyslogMsgs')
				{
					var tmpFilterHostVal = Ext.getCmp('filterhost'+rname).getValue();
					Ext.getCmp('filterhost'+rname).hide();
					if (!Ext.isEmpty(tmpFilterHostVal) && tmpFilterHostVal.indexOf("$") != -1)
					{
						 Ext.getCmp('filterhost'+rname).setValue("all")
					}
				}
			}
		}
		Ext.resumeLayouts(true);

		Ext.Ajax.request({
			url: 'DefaultTestConfiguration/data/defaulttesthelpJson.jsp?mode=configurerules',
			method: 'POST',
			async: false
		});
	},
	updateRuleFilters: function(btn) 
	{
		var setRuleName = "";
		var setFacility = "";
		var setFilterHost = "";
		var setLevel = "";
		var setFilterLogic  = "";
		var setExcPattern = "";
		var rdCnt = 0;
		var totalRules = inputsRule;
		var arrURLNames = new Array();

		for(var j=1; j<totalRules; j++)
		{
			if (Ext.getCmp('rulename'+j) == undefined)
			{
				continue;
			}
			ruleName = Ext.getCmp('rulename'+j).getValue();
			facility = Ext.getCmp('facility'+j).getValue();
			filterHost = Ext.getCmp('filterhost'+j).getValue();
			level = Ext.getCmp('level'+j).getValue();
			filterLogic = Ext.getCmp('filterlogic'+j).getValue();
			excPattern = Ext.getCmp('excludepattern'+j).getValue();

			if(ruleName!=null)
			{
				rdCnt++;
				if(!checkblank(ruleName) || (ruleName == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterRuleName,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('rulename'+j).focus(true,true);
						}
					});
					return;
				}
				//else if(!checkspace(ruleName))
				//{
					//Ext.getCmp('rulename'+j).focus(true,true);
					//return;
				//}
				else if(!checkspecialExt(ruleName,"$@*.+=|:;\"\'<>\/[]?,\\&"))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('rulename'+j).focus(true,true);
						}
					});
					return;
				}

				var x_idx = arrURLNames.indexOf(ruleName);
				if (x_idx != -1)
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: duplicateRuleName,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('rulename'+j).focus(true,true);
						}
					});
					return;
				}
				arrURLNames[j] = ruleName;
			}

			if(facility!=null)
			{
				if(!checkblank(facility) || (facility == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterFacility,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('facility'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspace(facility))
				{
					Ext.getCmp('facility'+j).focus(true,true);
					return;
				}
				else if(!checkspecialExt(facility,"$@*.+=|:;\"\'<>\/[]?\\&"))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('facility'+j).focus(true,true);
						}
					});
					return;
				}
				else if (facility.indexOf(",") > -1)
				{
					if (facility.indexOf(",") == 0 || 
						facility.lastIndexOf(",") == facility.length-1 || 
						facility.indexOf(",,") > -1)
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: validValue,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('facility'+j).focus(true,true);
							}
						});
						return
					}
				}
			}

			if(filterHost!=null)
			{
				if(!checkblank(filterHost) || (filterHost == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterFilterHost,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('filterhost'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspace(filterHost))
				{
					Ext.getCmp('filterhost'+j).focus(true,true);
					return;
				}
				else if(!checkspecialExt(filterHost,"$@*+=|;\"\'<>\/[]?\\&"))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('filterhost'+j).focus(true,true);
						}
					});
					return;
				}
				else if (filterHost.indexOf(",") > -1)
				{
					if (filterHost.indexOf(",") == 0 || 
						filterHost.lastIndexOf(",") == filterHost.length-1 || 
						filterHost.indexOf(",,") > -1)
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: validValue,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('filterhost'+j).focus(true,true);
							}
						});
						return;
					}
				}
			}

			if(level!=null)
			{
				if(!checkblank(level) || (level == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterLevel,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('level'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspace(level))
				{
					Ext.getCmp('level'+j).focus(true,true);
					return;
				}
				else if(!checkspecialExt(level,"$@*.+=|:;\"\'<>\/[]?\\&"))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('level'+j).focus(true,true);
						}
					});
					return;
				}
				else if (level.indexOf(",") > -1)
				{
					if (level.indexOf(",") == 0 || 
						level.lastIndexOf(",") == level.length-1 || 
						level.indexOf(",,") > -1)
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: validValue,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('level'+j).focus(true,true);
							}
						});
						return
					}
				}
			}

			var mainContainer = Ext.getCmp('includePatternContainer'+j);
			var conLength = mainContainer.items.length;
			var includeMsgArr = new Array();
			if (conLength > 0)
			{
				for (var cnt=0;cnt< conLength;cnt++ )
				{
					var incPattOther = Ext.getCmp('rulename'+j+'_incpatt'+(cnt+1)).getValue();
					if(!checkblank(incPattOther) || (incPattOther == "$unconfigured" ))
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: enterIncPattern,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('rulename'+j+'_incpatt'+(cnt+1)).focus(true,true);
							}
						});
						return;
					}
					else if(!checkspecialExt(incPattOther,"$,@*.+=|:;\"\'<>\/[]?\\&"))
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function()
							{
								Ext.getCmp('rulename'+j+'_incpatt'+(cnt+1)).focus(true,true);
							}
						});
						return;
					}
					else
					{
						func.buildFilterLogic(Ext.getCmp('rulename'+j+'_incpatt'+(cnt+1)));
					}
					includeMsgArr.push(incPattOther);
				}
			}

			if (filterLogic != null)
			{
				if(!checkblank(filterLogic) || (filterLogic == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterFilterLogic,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('filterlogic'+j).focus(true,true);
						}
					});
					return;
				}
				else
				{
					var itsOkFirstCondition = func.overrideFilterLogicForUpdate(Ext.getCmp('filterlogic'+j));
					if (!itsOkFirstCondition)
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: filterLogicPatternMsg,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('filterlogic'+j).focus(true,true);
							}
						});
						return;
					}
					else
					{
						var filterLogicArr = filterLogic.split(" ");
						var hasParenthesis = (filterLogic.indexOf("(") != -1);
						var availAndArray = new Array();
						var availOrArray = new Array();
						for (var f=0;f<filterLogicArr.length ;f++ )
						{
							var tmpFLogic = filterLogicArr[f];
							if (!Ext.isEmpty(tmpFLogic) && tmpFLogic.toLowerCase() == 'and')
							{
								availAndArray.push(tmpFLogic);
							}
							else if (!Ext.isEmpty(tmpFLogic) && tmpFLogic.toLowerCase() == 'or')
							{
								availOrArray.push(tmpFLogic);
							}
						}

						var newOperandsArr = Ext.Array.map(filterLogicArr,function(item,index) {

							if (index != (filterLogicArr.length -2))
							{
								if (!Ext.isEmpty(item) && ((item.toLowerCase() == 'and' && filterLogicArr[index+2].toLowerCase() == 'or') || (item.toLowerCase() == 'or' && filterLogicArr[index+2].toLowerCase() == 'and')))
								{
									var number = filterLogicArr[index+1];
									if (number.indexOf(')') == -1 && number.indexOf('(') == -1)
									{
										hasParenthesis = false;
									}
								}
							}
						});

						var hasBothOperators = ((!Ext.isEmpty(availAndArray) && availAndArray.length > 0) && (!Ext.isEmpty(availOrArray) && availOrArray.length > 0))
						if (!hasParenthesis && hasBothOperators)
						{
							Ext.Msg.show({
								title: rulePageTitle,
								msg: enterFilterLogicMsg1,
								minWidth : 300,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn: function() {
									Ext.getCmp('filterlogic'+j).focus(true,true);
								}
							});
							return;
						}
					}
				}
			}

			if(excPattern!=null)
			{
				if (Ext.isEmpty(excPattern))
				{
					excPattern = "none";
				}

				if(!checkblank(excPattern) || (excPattern == "$unconfigured" ))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: enterExecPattern,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('excludepattern'+j).focus(true,true);
						}
					});
					return;
				}
				else if(!checkspace(excPattern))
				{
					Ext.getCmp('excludepattern'+j).focus(true,true);
					return;
				}
				else if(!checkspecialExt(excPattern,"$@*.+=|:;\"\'<>\/[]?\\&"))
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('excludepattern'+j).focus(true,true);
						}
					});
					return;
				}
				else if (excPattern.indexOf(",") > -1)
				{
					if (excPattern.indexOf(",") == 0 || 
						excPattern.lastIndexOf(",") == excPattern.length-1 || 
						excPattern.indexOf(",,") > -1)
					{
						Ext.Msg.show({
							title: rulePageTitle,
							msg: validValue,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('excludepattern'+j).focus(true,true);
							}
						});
						return;
					}
				}

				var isIncludeAndExcludeSame = false;
				includeMsgArr.forEach(function(item){
					if (excPattern.indexOf(',') != -1)
					{
						if (excPattern.indexOf(item+',') != -1 || excPattern.indexOf(','+item+',') != -1 || excPattern.indexOf(','+item) != -1 )
						{
							isIncludeAndExcludeSame = true;
						}
					}
					else
					{
						if (item == excPattern)
						{
							isIncludeAndExcludeSame = true;
						}
					}
				});

				if (isIncludeAndExcludeSame)
				{
					Ext.Msg.show({
						title: rulePageTitle,
						msg: repeatedKeywords,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function()
						{
							Ext.getCmp('excludepattern'+j).focus(true,true);
						}
					});
					return;
				}
			}

			var inputPattCont = Ext.getCmp('includePatternContainer'+j);
			var inputPattCount = inputPattCont.items.getCount();
			var otherIncPatterns = '';
			if (inputPattCount > 0)
			{
				for (var it=0;it<inputPattCount ;it++ )
				{
					otherIncPatterns += Ext.getCmp('rulename'+j+'_incpatt'+(it+1)).getValue() +"|";
				}
			}

			if (!Ext.isEmpty(otherIncPatterns))
			{
				otherIncPatterns = otherIncPatterns.substring(0,otherIncPatterns.length -1);
			}

			var combinePatterns = otherIncPatterns;
			if (combinePatterns.charAt(combinePatterns.length -1) == '|')
			{
				combinePatterns = combinePatterns.substring(0,combinePatterns.length -1);
			}

			facility = facility.replace(/,/g,'|');
			level = level.replace(/,/g,'|');
			filterHost = filterHost.replace(/,/g,'|');
			excPattern = excPattern.replace(/,/g,'|');

			setRuleName += ruleName+"="+combinePatterns+"^#^";
			setFacility += ruleName+"="+facility+"^#^";
			setFilterHost += ruleName+"="+filterHost +"^#^";
			setLevel += ruleName+"="+level +"^#^";
			setFilterLogic += ruleName+"="+filterLogic +"^#^";
			setExcPattern += ruleName+"="+excPattern +"^#^";
		}

		setRuleName = setRuleName.substring(0,setRuleName.length-3);
		setFacility = setFacility.substring(0,setFacility.length-3);
		setFilterHost = setFilterHost.substring(0,setFilterHost.length-3);
		setLevel = setLevel.substring(0,setLevel.length-3);
		setFilterLogic = setFilterLogic.substring(0,setFilterLogic.length-3);
		setExcPattern = setExcPattern.substring(0,setExcPattern.length-3);

		Ext.getCmp('rule_name').setValue(setRuleName);
		Ext.getCmp('facility').setValue(setFacility);
		Ext.getCmp('filter_host').setValue(setFilterHost);
		Ext.getCmp('level').setValue(setLevel);
		Ext.getCmp('filter_logic').setValue(setFilterLogic);
		Ext.getCmp('exclude_Patterns').setValue(setExcPattern);
		Ext.getCmp('egconfigurerulenames').destroy();

		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+encodeURIComponent(compTypeVal)+'&componentType='+encodeURIComponent(compTypeVal)+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	}

});

// system properties works starts...

function addSystemProperties(btn) {
	var isNeedFocus = false;
	if (!Ext.isEmpty(btn))
	{
		isNeedFocus = true;
	}

	var mainForm = Ext.getCmp('egsystemproperties');
	var propetiesmorecontainer = Ext.getCmp('propetiesmorecontainer');
	var conId = "con_"+inputsEmail

	var tmpContainer = {
			xtype : 'fieldset',
			id : conId,
			width: 800,
			/*layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},*/
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelAlign: 'top'
					},
					items: [
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Property',
							style:{'white-space':'nowrap'},
							id: 'syspropkey'+inputsEmail,
							name: 'syspropkey'+inputsEmail,
							value: 'none',
							margin: '2 5 2 2',
							columnWidth:.48
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Value',
							style:{'white-space':'nowrap'},
							id: 'syspropval'+inputsEmail,
							name: 'syspropval'+inputsEmail,
							value: 'none',
							margin: '2 5 2 5',
							columnWidth: 0.48
						},
						{
							xtype: 'component',
							html: '<center><div class="iconMinus" style="cursor:pointer;" data-qtip="<b>Remove</b>" onclick="javascript:removeProperties('+conId+')"></center>',
							columnWidth: 0.04,
							margin: '24 0 0 2'
						}
					]
				}
			]
	};
	propetiesmorecontainer.add(tmpContainer);
	propetiesmorecontainer.doLayout();
	Ext.getCmp('addPropBtn').setText('Add More');
	Ext.getCmp('updatePropBtn').enable();
	Ext.getCmp('clearPropBtn').enable();
	Ext.getCmp('NoPropContainer').hide();

	if (isNeedFocus)
	{
		Ext.getCmp('syspropkey'+inputsEmail).focus(true);
	}
	inputsEmail++;
}

function removeProperties(containerSet) 
{
	var containerID = containerSet;
	if (!Ext.isEmpty(containerID) && containerID instanceof Object)
	{
		containerID = containerSet.id;
	}

	var propetiesmorecontainer = Ext.getCmp('propetiesmorecontainer');
	propetiesmorecontainer.remove(containerID);
	if (containerID == 'con_1')
	{
		ismulti = 'true';
		Ext.getCmp('con_1').removeAll();
		Ext.getCmp('con_1').hide();
	}

	var bckitemsmultiLen = propetiesmorecontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		if (ismulti == 'true')
		{
			Ext.getCmp('addPropBtn').setText('Add');
			Ext.getCmp('NoPropContainer').show();
			Ext.getCmp('updatePropBtn').disable();
			Ext.getCmp('clearPropBtn').disable();
		}
	}
}
// system propeties works ends

function addEmailContactFields(btn) {
	var isNeedFocus = false;
	if (!Ext.isEmpty(btn))
	{
		isNeedFocus = true;
	}

	var mainForm = Ext.getCmp('egemailconfiguration');
	var emailmorecontainer = Ext.getCmp('emailmorecontainer');
	var conId = "con_"+inputsEmail

	var tmpContainer = {
			xtype : 'fieldset',
			id : conId,
			width: 800,
			/*layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},*/
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeEmailNameContact(conId);
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelAlign: 'top'
					},
					items: [
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Email ID',
							style:{'white-space':'nowrap'},
							id: 'emailid'+inputsEmail,
							name: 'emailid'+inputsEmail,
							value: '$unconfigured',
							columnWidth:.34
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Password',
							style:{'white-space':'nowrap'},
							id: 'pass'+inputsEmail,
							name: 'pass'+inputsEmail,
							//value: '$unconfigured',
							columnWidth: 0.33,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Confirm Password',
							style:{'white-space':'nowrap'},
							id: 'confpass'+inputsEmail,
							name: 'confpass'+inputsEmail,
							//value: '$unconfigured',
							columnWidth: 0.33,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						}
					]
				}
			]
	};
	emailmorecontainer.add(tmpContainer);
	emailmorecontainer.doLayout();
	Ext.getCmp('addEmailBtn').setText('Add More');
	Ext.getCmp('updateEmailBtn').enable();
	Ext.getCmp('clearEmailBtn').enable();
	Ext.getCmp('NoEmailContainer').hide();

	if (isNeedFocus)
	{
		Ext.getCmp('emailid'+inputsEmail).focus(true);
	}
	inputsEmail++;
}

function removeEmailNameContact(containerID) 
{
	var emailmorecontainer = Ext.getCmp('emailmorecontainer');
	emailmorecontainer.remove(containerID);
	if (containerID == 'con_1')
	{
		ismulti = 'true';
		Ext.getCmp('con_1').removeAll();
		Ext.getCmp('con_1').hide();
	}

	var bckitemsmultiLen = emailmorecontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		if (ismulti == 'true')
		{
			Ext.getCmp('addEmailBtn').setText('Add');
			Ext.getCmp('NoEmailContainer').show();
			Ext.getCmp('updateEmailBtn').disable();
			Ext.getCmp('clearEmailBtn').disable();
		}
	}
}

function addRuleContact(btn) {
	var isNeedFocus = false;
	if (!Ext.isEmpty(btn))
	{
		isNeedFocus = true;
	}

	var mainForm = Ext.getCmp('egconfigurerulenames');
	var rulenamescontainer = Ext.getCmp('rulenamescontainer');
	var conId = "con_"+inputsRule

	var tmpContainer = {
		xtype: 'container',
		id : conId,
		padding: 4,
		margin: '5 5 5 5',
		border: true,
		style: 'border: lightGrey 3px solid !important',
		layout : {
			type : 'hbox',
			pack : 'start'
		},
		items : [
			{
				xtype: 'container',
				layout : {
					type : 'vbox',
					pack : 'start',
					align : 'stretch'
				},
				flex: 0.30,
				defaults: {
					labelSeparator: ' ',
					labelAlign: 'top',
					margin: 5
				},
				items: [
					{
						xtype: 'container',
						layout: {
							type: 'hbox',
							pack: 'start'
						},
						margin: '0 0 2 0',
						items : [
							{
								xtype : 'button',
								iconCls : 'img_removeShift',
								tooltip : '<b>Remove rule</b>',
								style : {
									background : 'none',
									border : '0px'
								},
								margin: 0,
								padding: 0,
								handler: function()
								{
									removeRuleNameContact(conId);
								}
							}
						]
					},
					{
						xtype: 'textfield',
						id: 'rulename'+inputsRule,
						cls: 'textbox',
						fieldLabel: ruleNameLbl,
						value: ''
					},
					{
						xtype: 'textfield',
						id: 'facility'+inputsRule,
						cls: 'textbox',
						fieldLabel: faceLbl,
						value: 'all'
					},
					{
						xtype: 'textfield',
						id: 'filterhost'+inputsRule,
						cls: 'textbox',
						fieldLabel: filterHostLbl,
						value: 'all'
					},
					{
						xtype: 'textfield',
						id: 'level'+inputsRule,
						cls: 'textbox',
						fieldLabel: levelLbl,
						value: 'all'
					}
				]
			},
			{
				xtype: 'container',
				layout : {
					type : 'vbox',
					pack : 'start',
					align : 'stretch'
				},
				flex: 1,
				margin: '0 0 0 5',
				items: [
					{
						xtype: 'fieldset',
						title: incPattLbl,
						style: {
							background : 'none',
							border : '1px solid lightGrey'
						},
						layout : {
							type : 'vbox',
							pack : 'start',
							align : 'stretch'
						},
						margin: '0 0 5 0',
						items: [
							{
								xtype: 'container',
								id : 'includePatternContainer'+inputsRule,
								layout: 'column',
								columnWidth: 1,
								defaults: {
									labelSeparator: '',
									margin: '0 5 5 5',
									columnWidth: 0.25
								},
								items: [
									{
										xtype : 'container',
										id: 'multiPatternDiv'+inputsRule,
										layout: 'column',
										items : [
											{
												xtype: 'textfield',
												id : 'rulename'+inputsRule+'_incpatt1',
												name : 'rulename'+inputsRule+'_incpatt1',
												fieldLabel: ' 1',
												labelAlign: 'top',
												labelSeparator: ' ',
												cls:"textbox",
												value: '$unconfigured',
												columnWidth: 0.90,
												listeners: {
													blur: function()
													{
														func.buildFilterLogic(this);
													}
												}
											},
											{
												xtype: 'component',
												id:'rulename'+inputsRule+'_icon1',
												html: '<center><div class="iconPlus" style="cursor:pointer;"  onclick="javascript:addIncludePattern(multiPatternDiv'+inputsRule+')"></center>',
												columnWidth: 0.03,
												margin: '24 0 0 2'
											}
										]
									}
								]
							},
							{
									xtype: 'fieldcontainer',
									id: 'flfieldcontainer'+inputsRule,
									layout: 'column',
									columnWidth: 1,
									margin: '10 0 0 0',
									items: [
										{
											xtype: 'textfield',
											id: 'filterlogic'+inputsRule,
											cls: 'textbox',
											margin: '5 0 5 5',
											fieldLabel: filterLogLbl,
											labelAlign: 'top',
											columnWidth: 0.90,
											labelSeparator: ' ',
											enableKeyEvents:true,
											value: '1',
											listeners: {
												change: function()
												{
													func.overrideFilterLogic(this);
												}
											}
										},
										{
											xtype: 'button',
											cls: 'button20',
											id: 'flaccept_'+inputsRule,
											name: 'flaccept_'+inputsRule,
											hidden:true,
											text: 'OK',
											margin:'26 0 0 10',
											columnWidth: 0.10,
											handler: function()
											{
												allOKEvent(this);
											}
										}
									]
								},
								{
									xtype: 'component',
									id:'errorState_'+inputsRule,
									anchor:'100%',
									margin:'0px 0px 0px 5px',
									bodyPadding:'0px'
								}
						]
					},
					{
						xtype: 'fieldset',
						title: execPattLbl,
						style: {
							background : 'none',
							border : '1px solid lightGrey'
						},
						layout : {
							type : 'vbox',
							pack : 'start',
							align : 'stretch'
						},
						margin: 0,
						items: [
							{
								xtype: 'textfield',
								id: 'excludepattern'+inputsRule,
								name: 'excludepattern'+inputsRule,
								cls: 'textbox',
								value: 'none'
							}
						]
					}
				]
			}
		]
	};
	rulenamescontainer.add(tmpContainer);
	mainForm.doLayout();
	Ext.getCmp('addRuleNamebtn').setText('Add More');
	Ext.getCmp('updateRuleName').enable();
	Ext.getCmp('clearRuleName').enable();
	Ext.getCmp('NoRuleNamePattern').hide();

	if (isNeedFocus)
	{
		Ext.getCmp('rulename'+inputsRule).focus(true);
	}

	if (testName == 'DeviceSyslogMsgs')
	{
		Ext.getCmp('filterhost'+inputsRule).hide();
	}

	inputs++;
	inputsRule++;

}

function removeRuleNameContact(containerID) 
{
	var rulenamescontainer = Ext.getCmp('rulenamescontainer');
	rulenamescontainer.remove(containerID);
	if (containerID == 'configrule_1')
	{
		ismulti = 'true';
		Ext.getCmp('configrule_1').removeAll();
		Ext.getCmp('configrule_1').hide();
	}

	var bckitemsmultiLen = rulenamescontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		if (ismulti == 'true')
		{
			Ext.getCmp('addRuleNamebtn').setText('Add');
			Ext.getCmp('NoRuleNamePattern').show();
			Ext.getCmp('updateRuleName').disable();
			Ext.getCmp('clearRuleName').disable();
		}
	}
}

function checkFilterLogicFormat(value)
{
	var numbers = "andorANDOR0123456789 ";
	var logicAlpha = "andorANDOR";
	var logicNumbers = "0123456789";
	var logicOtherChars = " ()";
	var hasNonNumericalCharacter = "false";
	var hasLogicAlphas = false;
	var hasLogicNums = false;
	for (var i=0;i<value.length;i++)
	{
		var strChar = value.charAt(i);
		if (logicOtherChars.indexOf(strChar) != -1)
		{
			continue;
		}
		if (numbers.indexOf(strChar) == -1)
		{
			hasNonNumericalCharacter = "true";
			break;
		}

		if (logicAlpha.indexOf(strChar) != -1)
		{
			hasLogicAlphas = true;
		}

		if (logicNumbers.indexOf(strChar) != -1)
		{
			hasLogicNums = true;
		}
	}

	var valuesArr = new Array();
	valuesArr  = value.split(' ');

	if (valuesArr != null && valuesArr.length >0)
	{
		valuesArr.forEach(function(item){
			if (item.indexOf('(') != -1)
			{
				item = item.replace(/\(/g,"");
			}
			if (item.indexOf(')') != -1)
			{
				item = item.replace(/\)/g,"");
			}
			if (logicNumbers.indexOf(item) == -1 && item.toLowerCase() != 'and' && item.toLowerCase() !='or')
			{
				hasNonNumericalCharacter = "true";
			}
		});
	}
	var map = new Ext.util.HashMap();
	var open = 0;
	var close = 0;
	for (var v=0;v<valuesArr.length; v++ )
	{
		var item = valuesArr[v];
		var closeItem = item;

		if (valuesArr[0].toLowerCase() == 'and' || valuesArr[0].toLowerCase() == 'or' || valuesArr[valuesArr.length - 1].toLowerCase() == 'and' || valuesArr[valuesArr.length - 1].toLowerCase() == 'or')
		{
			hasNonNumericalCharacter = "true";
			break;
		}

		if (v != (valuesArr.length -1))
		{
			var checkSequence = item;
			var checkNextSequence = valuesArr[v+1];
			if (checkSequence.indexOf('(') != -1)
			{
				checkSequence = checkSequence.replace(/\(/g,"");
			}
			if (checkSequence.indexOf(')') != -1)
			{
				checkSequence = checkSequence.replace(/\)/g,"");
			}

			if (checkNextSequence.indexOf('(') != -1)
			{
				checkNextSequence = checkNextSequence.replace(/\(/g,"");
			}

			if (checkNextSequence.indexOf(')') != -1)
			{
				checkNextSequence = checkNextSequence.replace(/\)/g,"");
			}

			if (logicNumbers.indexOf(checkSequence) != -1 && logicNumbers.indexOf(checkNextSequence) != -1)
			{
				hasNonNumericalCharacter = "true";
				break;
			}
			else if (logicAlpha.indexOf(checkSequence) != -1 && logicAlpha.indexOf(checkNextSequence) != -1)
			{
				hasNonNumericalCharacter = "true";
				break;
			}
		}

		for(var k=0;k < item.length;k++)
		{
			if(item.charAt(k) == '(' && item.charAt(k + 1) == ')')
			{
				hasNonNumericalCharacter = "true";
				break;
			}
			else if((item.charAt(k) == '(' &&  logicAlpha.indexOf(item.charAt(k+1)) != -1) ||					(item.charAt(k) == ')' && logicAlpha.indexOf(item.charAt(k-1)) != -1))
			{
				hasNonNumericalCharacter = "true";
				break;
			}
		}

		if (hasNonNumericalCharacter == 'true')
		{
			map = new Ext.util.HashMap();
			break;
		}

		while(item.indexOf('(') != -1)
		{
			if (item.indexOf('(') != -1)
			{
				map.add('(',++open);
				item = item.substring(item.indexOf('(')+1);
			}
		}

		while(closeItem.indexOf(')') != -1)
		{
			if (closeItem.indexOf(')') != -1)
			{
				map.add(')',++close);
				closeItem = closeItem.substring(closeItem.indexOf(')')+1);
			}
		}
	}

	if (hasNonNumericalCharacter != "true")
	{
		var hasParanthesis = false;
		if (value.indexOf("(") != -1 && value.indexOf(")") != -1)
		{
			hasParanthesis = true;
		}

		if (!Ext.isEmpty(map))
		{
			var openCnt = map.get('(');
			var closeCnt = map.get(')');
			if (openCnt != closeCnt)
			{
				hasNonNumericalCharacter = 'true';
			}
		}

		if ((value.indexOf("(") != -1 && value.indexOf(")") == -1) || (value.indexOf(")") != -1 && value.indexOf("(") == -1))
		{
			hasNonNumericalCharacter = "true";
		}

		if (hasLogicAlphas && !hasLogicNums)
		{
			hasNonNumericalCharacter = "true";
		}
		else if (hasLogicAlphas && hasLogicNums)
		{
			var firstChar = value.charAt(0);
			var lastChar = value.charAt(value.length -1);
			if (!hasParanthesis)
			{
				if (logicNumbers.indexOf(firstChar) == -1 || logicNumbers.indexOf(lastChar) == -1)
				{
					hasNonNumericalCharacter = "true";
				}
			}

			for(var a=0;a < value.length;a++)
			{
				var eachChar = value.charAt(a);
				if (logicNumbers.indexOf(eachChar) != -1)
				{
					if (!hasParanthesis)
					{
						if (a == value.length-1)
						{
							if (value.charAt(a-1) != ' ')
							{
								hasNonNumericalCharacter = "true";
								break;
							}
							continue;
						}

						if (value.charAt(a+1) != ' ')
						{
							hasNonNumericalCharacter = "true";
							break;
						}
					}
					else
					{
						if ((firstChar == '(' && (a == 0)) && (lastChar == ')' && (a == value.length-2)))
						{
							continue;
						}

						if (lastChar != ')')
						{
							if (a == value.length-1)
							{
								continue;
							}
						}
						if (value.charAt(a+1) != ' ' && value.charAt(a+1) != '(' && 
						value.charAt(a+1) != ')')
						{
							hasNonNumericalCharacter = "true";
							break;
						}
					}
				}
			}
		}
	}

	if (hasNonNumericalCharacter == "true")
	{
		return false;
	}
	else
	{
		return true;
	}
}

function checkspecialExt(field,s_spl)
{
	if (typeof(field)=='object')
	{
		obj_val = field.value;
	}
	else
	{
		obj_val = field;
	}
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			return false;
		}
	}
	return true;
}

function allOKEvent(obj)
{
	var selectedRuleID = obj.id;
	if (!Ext.isEmpty(obj))
	{
		selectedRuleID = selectedRuleID.substring(selectedRuleID.indexOf("_")+1);
	}
	
	var isHTMLData = Ext.getCmp('errorState_'+selectedRuleID).html;
	if (Ext.isEmpty(isHTMLData))
	{
		//set value after click OK button ...

		var mainContainer = Ext.getCmp('includePatternContainer'+selectedRuleID);
		var conLength = mainContainer.items.length;
		var hasApplyDisabledCls = false;
		var disableElementId = '';
		if (conLength > 0)
		{
			inputsIncPatt = 0;
			var existValues = new Array();
			for (var i = 0;i<=conLength;i++)
			{
				var tmpLevelObj = Ext.getCmp('rulename'+selectedRuleID+'_outercont'+(i+1));
				if (tmpLevelObj == null || tmpLevelObj == undefined)
				{
					continue;
				}
				else if (!Ext.isEmpty(tmpLevelObj) && tmpLevelObj.hasCls('disabled-mycomponent'))
				{
					hasApplyDisabledCls = true;
					disableElementId = tmpLevelObj.id;
					mainContainer.remove(tmpLevelObj);
					continue;
				}

				var tmpID = tmpLevelObj.getId();
				var value = Ext.getCmp('rulename'+selectedRuleID+'_incpatt'+(i+1)).getValue();
				existValues[inputsIncPatt] = value;
				inputsIncPatt++;
				mainContainer.remove(tmpLevelObj);
			}

			if (existValues != null && existValues.length > 0)
			{
				for (var e=0;e<existValues.length;e++)
				{
					var existVal =existValues[e];
					addIncludePatternWithValue('multiPatternDiv'+selectedRuleID,existVal);
				}
			}
		}


		var filterLogicValue = Ext.getCmp('filterlogic'+selectedRuleID).getValue();
		if (hasApplyDisabledCls)
		{
			var disableIDLength = disableElementId.length;
			var levelNumber = disableElementId.charAt((disableIDLength-1));
			var changedFLValue = filterLogicValue;
			var filterLogicValueArr = new Array();
			filterLogicValueArr = filterLogicValue.split(" ");

			var tmpArr = new Array();
			for (var v=0;v<filterLogicValueArr.length ;v++ )
			{
				var tmpStr = filterLogicValueArr[v];
				if (!Ext.isEmpty(tmpStr))
				{
					if (tmpStr.indexOf('(') != -1)
					{
						tmpStr = tmpStr.replace(/\(/g,"");
					}
					
					if (tmpStr.indexOf(')') != -1)
					{
						tmpStr = tmpStr.replace(/\)/g,"");
					}

					if (tmpStr.toLowerCase().indexOf('and') != -1 || tmpStr.toLowerCase().indexOf('or') != -1 )
					{
						continue;
					}
					else
					{
						tmpArr.push(tmpStr);
					}
				}
			}

			filterLogicValueArr = new Array();
			filterLogicValueArr = tmpArr;
			delete tmpArr;

			var map = new Ext.util.HashMap();
			var intLevel = parseInt(levelNumber);

			if (filterLogicValueArr != null)
			{
				for (var fl=intLevel;fl<=filterLogicValueArr.length ;fl++ )
				{
					map.add(fl+1,fl);
				}
			}

			if (!Ext.isEmpty(map))
			{
				var mapKeyArr = map.getKeys();
				for (var m=0;m<mapKeyArr.length;m++ )
				{
					var mapKey = mapKeyArr[m];
					var mapKey1 = map.get(m);
					if (!Ext.isEmpty(changedFLValue) && changedFLValue.indexOf(mapKey) != -1)
					{
						var mapValue = map.get(mapKey).toString();
						changedFLValue = changedFLValue.replace(new RegExp(mapKey, 'g'), mapValue);
					}
				}

				if (!Ext.isEmpty(changedFLValue))
				{
					if (changedFLValue.charAt(0) == ' ' || changedFLValue.charAt(changedFLValue.length - 1) == ' ')
					{
						changedFLValue = changedFLValue.trim();
					}
				}
				Ext.getCmp('filterlogic'+selectedRuleID).setRawValue(changedFLValue);
			}
		}
		else
		{
			if (!Ext.isEmpty(filterLogicValue))
			{
				if (filterLogicValue.charAt(0) == ' ' || filterLogicValue.charAt(filterLogicValue.length - 1) == ' ')
				{
					filterLogicValue = filterLogicValue.trim();
				}
			}
			Ext.getCmp('filterlogic'+selectedRuleID).setRawValue(filterLogicValue);
		}

		if (!Ext.isEmpty(Ext.get('rulename'+selectedRuleID+'_icon1')))
		{
			Ext.get('rulename'+selectedRuleID+'_icon1').dom.innerHTML='<center><div class="iconPlus" style="cursor:pointer;" onclick="javascript:addIncludePattern(multiPatternDiv'+selectedRuleID+')"></center>';

			var incPattContainer = Ext.getCmp('includePatternContainer'+selectedRuleID);
			var includePattLength = incPattContainer.items.length;
			if (includePattLength > 1)
			{
				for (var i = 1;i<includePattLength;i++)
				{
					var tmpLevelObj = Ext.getCmp('rulename'+selectedRuleID+'_icon'+(i+1));
					if ((tmpLevelObj == null || tmpLevelObj == undefined) || (!Ext.isEmpty(selectedRuleID) && selectedRuleID == (i+1)))
					{
						continue;
					}
					Ext.get('rulename'+selectedRuleID+'_icon'+(i+1)).dom.innerHTML='<center><div class="iconMinus" style="cursor:pointer;" onclick="javascript:removeIncludePattern(rulename'+selectedRuleID+"_outercont"+(i+1)+')"></center>';
				}
			}
		}
		Ext.getCmp('flaccept_'+selectedRuleID).setDisabled(true);
		Ext.getCmp('flaccept_'+selectedRuleID).hide();
		//set value after click OK button ...
	}
}

function addIncludePattern(fieldValue)
{
	var fieldID = Ext.get(fieldValue).id;
	if (Ext.isEmpty(fieldID))
	{
		fieldID = fieldValue;
	}
	fieldID = fieldID.substring(fieldID.indexOf('Div')+3);

	var mainForm = Ext.getCmp('egconfigurerulenames');
	var escMailIDsDiv = Ext.getCmp('includePatternContainer'+fieldID);
	if ((escMailIDsDiv.items.getCount()) == totalIncPatt)
	{
		Ext.Msg.show({
			title: rulePageTitle,
			msg: limitedIncludePatterns,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}

	var isFilterLogicOk = true;
	var filterLogicValue = Ext.getCmp('filterlogic'+fieldID).getValue();
	isFilterLogicOk = func.overrideFilterLogic(Ext.getCmp('filterlogic'+fieldID));
	if (isFilterLogicOk)
	{
		var levelStr = (escMailIDsDiv.items.getCount() + 1);
		var conId = 'rulename'+fieldID+"_outercont"+(escMailIDsDiv.items.getCount() + 1);
		var tmpContainer = {
			xtype : 'container',
			id : conId,
			layout: 'column',
			items : [
				{
					xtype:'textfield',
					id: 'rulename'+fieldID+'_incpatt'+(escMailIDsDiv.items.getCount() + 1),
					name: 'rulename'+fieldID+'_incpatt'+(escMailIDsDiv.items.getCount() + 1),
					cls: 'textbox',
					fieldLabel : ' '+levelStr,
					value : '$unconfigured',
					labelAlign: 'top',
					labelSeparator: ' ',
					columnWidth: 0.90,
					listeners: {
						blur: function()
						{
							//func.buildFilterLogic(this);
						}
					}
				},
				{
					xtype: 'component',
					id: 'rulename'+fieldID+'_icon'+(escMailIDsDiv.items.getCount() + 1),
					html: '<center><div class="iconMinus" style="cursor:pointer;" onclick="javascript:removeIncludePattern('+conId+')"></center>',
					columnWidth: 0.03,
					margin: '24 0 0 2'
				}
			]
		}
		escMailIDsDiv.add(tmpContainer);
		mainForm.doLayout();

		var isFilterLogicContHide = Ext.getCmp('filterlogic'+fieldID).isHidden();
		if (!isFilterLogicContHide)
		{
			var existFilterLogicValues = Ext.getCmp('filterlogic'+fieldID).getValue();
			Ext.getCmp('filterlogic'+fieldID).setRawValue(existFilterLogicValues+" and "+levelStr);
		}
		Ext.getCmp('flaccept_'+fieldID).setDisabled(true);
		Ext.getCmp('flaccept_'+fieldID).hide();
	}

}

function removeIncludePattern(containerID)
{
	var fieldID = containerID.id;
	var mainContID = fieldID;
	mainContID = mainContID.substring(0,mainContID.indexOf("_"));
	mainContID = mainContID.substring(mainContID.lastIndexOf("e")+1);

	var fieldLength = fieldID.length;
	var levelNumber = fieldID.charAt((fieldLength-1));

	var isFilterLogicContHide = Ext.getCmp('filterlogic'+mainContID).isHidden();
	if (!isFilterLogicContHide)
	{
		var mainContainer = Ext.getCmp('includePatternContainer'+mainContID);
		var auxiliaryInputMsgDiv = Ext.getCmp(fieldID);
		Ext.getCmp('rulename'+mainContID+'_incpatt'+levelNumber).setReadOnly(true);
		auxiliaryInputMsgDiv.addCls('disabled-mycomponent');
		var filterLogicValue = Ext.getCmp('filterlogic'+mainContID).getValue();

		if (!Ext.isEmpty(filterLogicValue))
		{
			if (filterLogicValue.charAt(0) == ' ' || filterLogicValue.charAt(filterLogicValue.length - 1) == ' ')
			{
				filterLogicValue = filterLogicValue.trim();
			}
		}

		Ext.getCmp('flaccept_'+mainContID).setDisabled(true);
		Ext.getCmp('flaccept_'+mainContID).show();

		if (!Ext.isEmpty(Ext.get('rulename'+mainContID+'_icon1')))
		{
			Ext.get('rulename'+mainContID+'_icon1').dom.innerHTML='<center><div class="iconPlus" style="cursor:pointer;"></div></center>';

			var incPattContainer = Ext.getCmp('includePatternContainer'+mainContID);
			var includePattLength = incPattContainer.items.length;
			if (includePattLength > 1)
			{
				for (var i = 1;i<includePattLength;i++)
				{
					var tmpLevelObj = Ext.getCmp('rulename'+mainContID+'_icon'+(i+1));
					if ((tmpLevelObj == null || tmpLevelObj == undefined))
					{
						continue;
					}
					else if (!Ext.isEmpty(levelNumber) && levelNumber == (i+1))
					{
						continue;
					}
					Ext.get('rulename'+mainContID+'_icon'+(i+1)).dom.innerHTML='<center><div class="iconMinus" style="cursor:pointer;"></div></center>';
				}
			}
		}

		if (!Ext.isEmpty(filterLogicValue))
		{
			if (filterLogicValue.indexOf(levelNumber) != -1)
			{
				var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+deleteFilterMsg+'</td></tr></table>';
				Ext.getCmp('errorState_'+mainContID).update(htm1);
			}

			Ext.getCmp('filterlogic'+mainContID).reset();
			Ext.getCmp('filterlogic'+mainContID).setValue(filterLogicValue);
		}
		Ext.getCmp('filterlogic'+mainContID).focus();
	}
	else
	{
		var mainContainer = Ext.getCmp('includePatternContainer'+mainContID);
		var conLength = mainContainer.items.length;

		if (!Ext.isEmpty(Ext.get('rulename'+mainContID+'_icon1')))
		{
			Ext.get('rulename'+mainContID+'_icon1').dom.innerHTML='<center><div class="iconPlus" style="cursor:pointer;" onclick="javascript:addIncludePattern(MultiPatternDiv'+mainContID+')"></center>';
		}

		if (conLength > 0)
		{
			inputsIncPatt = 0;
			var existValues = new Array();
			for (var i = 0;i<=conLength;i++)
			{
				var tmpLevelObj = Ext.getCmp('rulename'+mainContID+'_outercont'+(i+1));
				if (tmpLevelObj == null || tmpLevelObj == undefined)
				{
					continue;
				}
				else if (!Ext.isEmpty(levelNumber) && levelNumber == (i+1))
				{
					mainContainer.remove(tmpLevelObj);
					continue;
				}

				var tmpID = tmpLevelObj.getId();
				var value = Ext.getCmp('rulename'+mainContID+'_incpatt'+(i+1)).getValue();
				existValues[inputsIncPatt] = value;
				inputsIncPatt++;
				mainContainer.remove(tmpLevelObj);
			}

			if (existValues != null && existValues.length > 0)
			{
				for (var e=0;e<existValues.length;e++)
				{
					var existVal =existValues[e];
					addIncludePatternWithValue('MultiPatternDiv'+mainContID,existVal);
				}
			}
		}

	// set value after click OK button ...
	}
}

function filterLogicFromRemoveMsg(obj,removeId) 
{
	var fieldID = obj.id;
	var removeContent = removeId;

	var fieldLength = removeContent.length;
	var levelNumber = removeContent.charAt((fieldLength-1));

	var blockNumber = fieldID;
	blockNumber = blockNumber.substring(blockNumber.lastIndexOf("c")+1);
	var filterLogicValue = obj.value;

	if (!Ext.isEmpty(filterLogicValue))
	{
		if (filterLogicValue.charAt(0) == ' ' || filterLogicValue.charAt(filterLogicValue.length - 1) == ' ')
		{
			filterLogicValue = filterLogicValue.trim();
		}
	}

	if (Ext.isEmpty(filterLogicValue))
	{
		var errMsg = "You must enter a value";
		var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+errMsg+'</td></tr></table>';
		Ext.getCmp('errorState_'+blockNumber).update(htm1);
		return false;
	}
	else if (!checkFilterLogicFormat(filterLogicValue))
	{
		var htm1 = '<table cellpadding="0px" cellspacing="0"><tr><td align="middle" valign="middle" style="margin:3px 0px 0px 5px;font-size:11px;color:red"> Error: '+filterLogicPatternMsg+'</td></tr></table>';

		Ext.getCmp('errorState_'+blockNumber).update(htm1);
		return false;
	}
	return true;
}

function addIncludePatternWithValue(fieldObj,fieldValue)
{
	var fieldID = fieldObj;
	fieldID = fieldID.substring(fieldID.indexOf('Div')+3);

	var mainForm = Ext.getCmp('egconfigurerulenames');
	var escMailIDsDiv = Ext.getCmp('includePatternContainer'+fieldID);
	if (!Ext.isEmpty(escMailIDsDiv.items))
	{
		if ((escMailIDsDiv.items.getCount()) == totalIncPatt)
		{
			Ext.Msg.show({
				title: rulePageTitle,
				msg: limitedIncludePatterns,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
	}

	var levelStr = (escMailIDsDiv.items.getCount() + 1);
	var conId = 'rulename'+fieldID+"_outercont"+(escMailIDsDiv.items.getCount() + 1);
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: 'rulename'+fieldID+'_incpatt'+(escMailIDsDiv.items.getCount() + 1),
				name: 'rulename'+fieldID+'_incpatt'+(escMailIDsDiv.items.getCount() + 1),
				cls: 'textbox',
				fieldLabel : ' '+levelStr,
				value : fieldValue,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.90,
				listeners: {
					blur: function()
					{
						func.buildFilterLogic(this);
					}
				}
			},
			{
				xtype: 'component',
				id: 'rulename'+fieldID+'_icon'+(escMailIDsDiv.items.getCount() + 1),
				html: '<center><div class="iconMinus" style="cursor:pointer;" onclick="javascript:removeIncludePattern('+conId+')"></center>',
				columnWidth: 0.03,
				margin: '24 0 0 2'
			}
		]
	};
	escMailIDsDiv.add(tmpContainer);
	mainForm.doLayout();
}

// for Horizon workspace Logon simulator
function addResourceSetFields(btn) {
	var isNeedFocus = false;
	if (!Ext.isEmpty(btn))
	{
		isNeedFocus = true;
	}
	var backupmulticontainer = Ext.getCmp('backupmulticontainer');
	var conId = "con_"+inputsResourceSet

	var tmpContainer = {
			xtype : 'fieldset',
			id : conId,
			width: 800,
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeResourceSet(conId);
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelWidth:150
					},
					items: [
					{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Published resources',
							style:{'white-space':'nowrap'},
							id:'publisresource'+inputsResourceSet,
							name:'publisresource'+inputsResourceSet,
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: User,
							style:{'white-space':'nowrap'},
							id:'username'+inputsResourceSet,
							name:'username'+inputsResourceSet,
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Password',
							style:{'white-space':'nowrap'},
							id: 'pwd'+inputsResourceSet,
							name: 'pwd'+inputsResourceSet,
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Confirm Password',
							style:{'white-space':'nowrap'},
							id: 'confpwd'+inputsResourceSet,
							name: 'confpwd'+inputsResourceSet,
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'fieldcontainer',
							id: 'twofaCont'+inputsResourceSet,
							fieldLabel: 'Is 2FA enabled?',
							columnWidth: 0.5,
							layout: 'column',
							items : [
								{
									xtype: 'radiogroup',
									columnWidth: 0.6,
									cls: 'radiobt',
									id: 'twofact'+inputsResourceSet,
									vertical: false,
									columns: 2,
									items: [
										{ boxLabel: 'Yes', name: 'twofactlabel'+inputsResourceSet, id: 'twofactlabel'+inputsResourceSet+'_1',  inputValue: 'true'},
										{ boxLabel: 'No', name: 'twofactlabel'+inputsResourceSet, id: 'twofactlabel'+inputsResourceSet+'_2',  inputValue: 'false', checked: true}
									],
									listeners : {
										'change' : function(obj, value)
										{
											var value = this.getChecked()[0];
											var twofa = this.getId().replace("twofact","twofacttoken");
											if (value.getGroupValue() == 'false')
											{
												Ext.getCmp(twofa).setVisible(false);
											}
											else
											{
												Ext.getCmp(twofa).setVisible(true);
											}
										}
									}
								},
								{
									xtype: 'textfield',
									cls: 'textbox',
									style:{'white-space':'nowrap'},
									id:'twofacttoken'+inputsResourceSet,
									inputType: 'password',
									emptyText: '2FA code',
									columnWidth: 0.4,
									margin: '0 0 0 5',
									hidden: true,
									backupValue: '',
									listeners:{
										afterrender: function () {
											this.setValue(this.backupValue);
										},
										change: function() {
											var changeValue = this.getValue();
											if (!Ext.isEmpty(changeValue))
											{
												this.backupValue = changeValue;
											}
										},
										blur :function()
										{
											var passObj = this;
											if (passObj.getValue() !== undefined || passObj.getValue() != "")
											{
												var backupValue = this.backupValue;
												passObj.setValue(backupValue);
											}
										},
										focus:function()
										{
											this.setValue("");
										}
									}
								}
							]
						},
						{
							xtype: 'radiogroup',
							columnWidth: 0.5,
							cls: 'radiobt',
							id: 'disclaimer_radioGrp'+inputsResourceSet,
							fieldLabel: 'Is disclaimer enabled?',
							vertical: false,
							columns: 2,
							items: [
								{ boxLabel: 'Yes', name: 'disclaimermultiusr'+inputsResourceSet, id: 'disclaimermultiusr'+inputsResourceSet+'_1',  inputValue: 'true'},
								{ boxLabel: 'No', name: 'disclaimermultiusr'+inputsResourceSet, id: 'disclaimermultiusr'+inputsResourceSet+'_2',  inputValue: 'false', checked: true}
							]
						}
						//,{
							//xtype: 'radiogroup',
							//columnWidth: 0.5,
							//cls: 'radiobt',
							//id: 'sso_radioGrp'+inputsResourceSet,
							//fieldLabel: 'Single Sign On',
							//vertical: false,
							//columns: 2,
							//items: [
								//{ boxLabel: 'Yes', name: 'sso'+inputsResourceSet, id: 'sso'+inputsResourceSet+'_1',  inputValue: 'true'},
								//{ boxLabel: 'No', name: 'sso'+inputsResourceSet, id: 'sso'+inputsResourceSet+'_2',  inputValue: 'false', checked: true}
							//]
						//}
					]
				}
			]
	};
	backupmulticontainer.add(tmpContainer);
	backupmulticontainer.doLayout();
	Ext.getCmp('addResourcebtn').setText('Add More');
	Ext.getCmp('updateResourceBtn').enable();
	Ext.getCmp('clearResourceBtn').enable();
	Ext.getCmp('NoResourcePattern').hide();

	if (isNeedFocus)
	{
		Ext.getCmp('publisresource'+inputsResourceSet).focus(true);
	}
	inputsResourceSet++;
}

function removeResourceSet(containerID) 
{
	var backupmulticontainer = Ext.getCmp('backupmulticontainer');
	backupmulticontainer.remove(containerID);
	if (containerID == 'con_1')
	{
		ismulti = 'true';
		Ext.getCmp('con_1').removeAll();
		Ext.getCmp('con_1').hide();
	}

	var bckitemsmultiLen = backupmulticontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		if (ismulti == 'true')
		{
			Ext.getCmp('addResourcebtn').setText('Add');
			Ext.getCmp('NoResourcePattern').show();
			Ext.getCmp('updateResourceBtn').disable();
			Ext.getCmp('clearResourceBtn').disable();
		}
	}
}
// for Horizon workspace Logon simulator

// for Horizon Logon simulator
function addMultiHLSContact() 
{
	var mainForm = Ext.getCmp('eghlspublishedresources');
	var backupmulticontainer = Ext.getCmp('backupmulticontainer');
	var conIdMulti = "con_"+inputsmultisrc
	var tmpMultiContainer = {

		xtype : 'fieldset',
		id : conIdMulti,
		width: 800,
		layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeMultiHLSSet(conIdMulti);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 10,
					labelSeparator:' ',
					labelWidth:150
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: 'Published resources',
						style:{'white-space':'nowrap'},
						id:'publisresource'+inputsmultisrc,
						value: '$unconfigured',
						columnWidth: 1
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: Domain,
						style:{'white-space':'nowrap'},
						id:'domainmultiusr'+inputsmultisrc,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: User,
						style:{'white-space':'nowrap'},
						id:'usermultiusr'+inputsmultisrc,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: PasswordLbl,
						style:{'white-space':'nowrap'},
						id:'pwdmultiusr'+inputsmultisrc,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: CnfPassLbl,
						style:{'white-space':'nowrap'},
						id:'confpwdmultiusr'+inputsmultisrc,
						inputType: 'password',
						//value: '$unconfigured',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'fieldcontainer',
						id: 'twofaCont'+inputsmultisrc,
						fieldLabel: 'Is 2FA enabled?',
						columnWidth: 0.5,
						layout: 'column',
						items : [
							{
								xtype: 'radiogroup',
								columnWidth: 0.6,
								cls: 'radiobt',
								id: 'twofact'+inputsmultisrc,
								vertical: false,
								columns: 2,
								items: [
									{ boxLabel: 'Yes', name: 'twofactlabel'+inputsmultisrc, id: 'twofactlabel'+inputsmultisrc+'_1',  inputValue: 'true'},
									{ boxLabel: 'No', name: 'twofactlabel'+inputsmultisrc, id: 'twofactlabel'+inputsmultisrc+'_2',  inputValue: 'false', checked: true}
								],
								listeners : {
									'change' : function(obj, value)
									{
										var value = this.getChecked()[0];
										var twofa = this.getId().replace("twofact","twofacttoken");
										if (value.getGroupValue() == 'false')
										{
											Ext.getCmp(twofa).setVisible(false);
										}
										else
										{
											Ext.getCmp(twofa).setVisible(true);
										}
									}
								}
							},
							{
								xtype: 'textfield',
								cls: 'textbox',
								style:{'white-space':'nowrap'},
								id:'twofacttoken'+inputsmultisrc,
								inputType: 'password',
								emptyText: '2FA code',
								columnWidth: 0.4,
								margin: '0 0 0 5',
								hidden: true,
								backupValue: '',
								listeners:{
									afterrender: function () {
										this.setValue(this.backupValue);
									},
									change: function() {
										var changeValue = this.getValue();
										if (!Ext.isEmpty(changeValue))
										{
											this.backupValue = changeValue;
										}
									},
									blur :function()
									{
										var passObj = this;
										if (passObj.getValue() !== undefined || passObj.getValue() != "")
										{
											var backupValue = this.backupValue;
											passObj.setValue(backupValue);
										}
									},
									focus:function()
									{
										this.setValue("");
									}
								}
							}
						]
					},
					{
						xtype: 'radiogroup',
						columnWidth: 0.5,
						cls: 'radiobt',
						id: 'disclaimer_radioGrp'+inputsmultisrc,
						fieldLabel: 'Is disclaimer enabled?',
						vertical: false,
						columns: 2,
						items: [
							{ boxLabel: 'Yes', name: 'disclaimermultiusr'+inputsmultisrc, id: 'disclaimermultiusr'+inputsmultisrc+'_1',  inputValue: 'true'},
							{ boxLabel: 'No', name: 'disclaimermultiusr'+inputsmultisrc, id: 'disclaimermultiusr'+inputsmultisrc+'_2',  inputValue: 'false', checked: true}
						]
					}
				]
			}
		]
	}
	backupmulticontainer.add(tmpMultiContainer);
	mainForm.doLayout();
	Ext.getCmp('publisresource'+inputsmultisrc).focus(true);

	Ext.getCmp('addMultiHLSbtn').setText('Add More');
	Ext.getCmp('updateMultiHLSbtn').enable();
	Ext.getCmp('clearMultiHLSbtn').enable();
	Ext.getCmp('NoMultiUsrPattern').hide();

	inputsmultisrc++;
}

function removeMultiHLSSet(containerID) 
{
	var backupcontainer = Ext.getCmp('backupmulticontainer');
	backupcontainer.remove(containerID);
	if (containerID == 'conmulti_1')
	{
		ismultisrc = 'true';
		Ext.getCmp('conmulti_1').removeAll();
		Ext.getCmp('conmulti_1').hide();
	}

	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		Ext.getCmp('addMultiHLSbtn').setText('Add');
		if (ismultisrc == 'true')
		{
			Ext.getCmp('NoMultiUsrPattern').show();
			Ext.getCmp('clearMultiHLSbtn').disable();
			Ext.getCmp('updateMultiHLSbtn').disable();
		}
	}
}

// AmazonWS workspace logon simulator starts...
function addAmazonResourceSetFields(btn) {
	var isNeedFocus = false;
	if (!Ext.isEmpty(btn))
	{
		isNeedFocus = true;
	}
	var backupmulticontainer = Ext.getCmp('backupamazonresrccontainer');
	var conId = "con_"+inputsResourceSet

	var tmpContainer = {
			xtype : 'fieldset',
			id : conId,
			width: 800,
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeAmazonResourceSet(conId);
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelWidth:150
					},
					items: [
					{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Published resources',
							style:{'white-space':'nowrap'},
							id:'publisresource'+inputsResourceSet,
							name:'publisresource'+inputsResourceSet,
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: registrationCode,
							style:{'white-space':'nowrap'},
							inputType: 'password',
							id:'regcode'+inputsResourceSet,
							name:'regcode'+inputsResourceSet,
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: Domain,
							style:{'white-space':'nowrap'},
							id:'domain'+inputsResourceSet,
							name:'domain'+inputsResourceSet,
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: User,
							style:{'white-space':'nowrap'},
							id:'username'+inputsResourceSet,
							name:'username'+inputsResourceSet,
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Password',
							style:{'white-space':'nowrap'},
							id: 'pwd'+inputsResourceSet,
							name: 'pwd'+inputsResourceSet,
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							inputType:'password',
							fieldLabel: 'Confirm Password',
							style:{'white-space':'nowrap'},
							id: 'confpwd'+inputsResourceSet,
							name: 'confpwd'+inputsResourceSet,
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						}
					]
				}
			]
	};
	backupmulticontainer.add(tmpContainer);
	backupmulticontainer.doLayout();
	Ext.getCmp('addAmazonResourcebtn').setText('Add More');
	Ext.getCmp('updateAmazonResourceBtn').enable();
	Ext.getCmp('clearAmazonResourceBtn').enable();
	Ext.getCmp('NoAmazonResourcePattern').hide();

	if (isNeedFocus)
	{
		Ext.getCmp('publisresource'+inputsResourceSet).focus(true);
	}
	inputsResourceSet++;
}

function removeAmazonResourceSet(containerID) 
{
	var backupmulticontainer = Ext.getCmp('backupamazonresrccontainer');
	backupmulticontainer.remove(containerID);
	if (containerID == 'con_1')
	{
		ismulti = 'true';
		Ext.getCmp('con_1').removeAll();
		Ext.getCmp('con_1').hide();
	}

	var bckitemsmultiLen = backupmulticontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		if (ismulti == 'true')
		{
			Ext.getCmp('addAmazonResourcebtn').setText('Add');
			Ext.getCmp('NoAmazonResourcePattern').show();
			Ext.getCmp('updateAmazonResourceBtn').disable();
			Ext.getCmp('clearAmazonResourceBtn').disable();
		}
	}
}
// AmazonWS workspace logon simulator ends...

// Horizon cloud POD starts
function addHorizonMultiSet() {
	if (inputs == totalInputs)
	{
		Ext.Msg.show({
			title: alertTitle,
			msg: limitedLevel,
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}

	var mainForm = Ext.getCmp('horizoncloudmultipleusers');
	var backupmulticontainer = Ext.getCmp('backupmulticontainer');
	var conIdMulti = "con_"+inputsmulti
	var tmpMultiContainer = {

		xtype : 'fieldset',
		id : conIdMulti,
		width: 800,
		layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
					{
						xtype : 'button',
						iconCls : 'img_removeShift',
						tooltip : '<b>Remove</b>',
						style : {
							background : 'none',
							border : '0px'
						},
						handler: function()
						{
							removeHorizonMultiSet(conIdMulti);
						}
					}
				]
			},
			{
				xtype: 'container',
				layout: 'column',
				defaults: {
					margin: 10,
					labelSeparator:' ',
					labelWidth:120
				},
				items: [
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: serNameLbl,
						style:{'white-space':'nowrap'},
						id:'servnamemultiusr'+inputsmulti,
						value: '$unconfigured',
						labelWidth:150,
						columnWidth: 1
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: domNameLbl,
						style:{'white-space':'nowrap'},
						id:'domainmultiusr'+inputsmulti,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: userNameLbl,
						style:{'white-space':'nowrap'},
						id:'usermultiusr'+inputsmulti,
						value: '$unconfigured',
						columnWidth: 0.5
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: PasswordLbl,
						style:{'white-space':'nowrap'},
						id:'pwdmultiusr'+inputsmulti,
						inputType: 'password',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					},
					{
						xtype: 'textfield',
						cls: 'textbox',
						fieldLabel: CnfPassLbl,
						style:{'white-space':'nowrap'},
						id:'confpwdmultiusr'+inputsmulti,
						inputType: 'password',
						columnWidth: 0.5,
						backupValue: '$unconfigured',
						listeners:{
							afterrender: function () {
								this.setValue(this.backupValue);
							},
							change: function() {
								var changeValue = this.getValue();
								if (!Ext.isEmpty(changeValue))
								{
									this.backupValue = changeValue;
								}
							},
							blur :function()
							{
								var passObj = this;
								if (passObj.getValue() !== undefined || passObj.getValue() != "")
								{
									var backupValue = this.backupValue;
									passObj.setValue(backupValue);
								}
							},
							focus:function()
							{
								this.setValue("");
							}
						}
					}
				]
			}
		]
	}
	backupmulticontainer.add(tmpMultiContainer);
	mainForm.doLayout();
	inputsmulti++;
	Ext.getCmp('addServersMultiSet').setText('Add More');
	Ext.getCmp('updateServersMultiSet').enable();
	Ext.getCmp('clearServersMultiSet').enable();
	Ext.getCmp('NoServersPattern').hide();
}
function removeHorizonMultiSet(containerID) {
	var backupcontainer = Ext.getCmp('backupmulticontainer');
	backupcontainer.remove(containerID);
	if (containerID == 'conmulti_1')
	{
		ismulti = 'true';
		Ext.getCmp('conmulti_1').removeAll();
		Ext.getCmp('conmulti_1').hide();
	}

	var bckitemsmultiLen = backupcontainer.items.length;
	if (bckitemsmultiLen == 0)
	{
		Ext.getCmp('addServersMultiSet').setText('Add');
		if (ismulti == 'true')
		{
			Ext.getCmp('NoServersPattern').show();
			Ext.getCmp('updateServersMultiSet').disable();
			Ext.getCmp('clearServersMultiSet').disable();
		}
	}
}

// Horizon cloud POD starts




