Ext.define('DefaultTestConfiguration.view.BusinessTransactionRuleGrid', {
	extend: 'Ext.form.Panel',
	alias: 'widget.businesstransactionrulegrid',
	ui:'simplePanel simplePanelHeaderBorder',
	title: btRulesGridTitle,
	margin: '8 8 0 8',
	id: 'businesstransactionrulegrid',
	isBackButton: '',

	layout: 'fit',
	requires: [
		'utilities.CustomGrid'
	],

	items:[
		{
			xtype: 'customgrid',
			id: 'btRulesGrid',
			ui:'newGridPanel bodyTextWrap',
			name: 'btRulesGrid',
			border: true,
			flex: 1,
			store:new Ext.data.Store({
				fields: ["variable","Rule_Name", "Matching_URL_Pattern", "Rule_Details"],
				data: []
			}),
			selModel: {
					selType: 'checkboxmodel',
					mode: 'MULTI',
					checkOnly: true
			},
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: '<table align="center"><tr><td align="center" height="309"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noBTRules+'</td></tr></table></td></tr></table>',
			scroll : true,
			autoScroll : false,
			flex: 1,
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: true,
					resizable: true,
					isCheckerHd: false,
					cellWrap:true
				},
				items: [
					{
						text: 'Variable',
						dataIndex: "variable",
						id: "variable",
						flex: 1,
						hidden:true
					},
					{
						text: 'Rule Name',
						dataIndex: "Rule_Name",
						id: "Rule_Name",
						flex: 0.5
					},
					{
						text: 'Matching URL Pattern',
						dataIndex: "Matching_URL_Pattern",
						id: "Matching_URL_Pattern",
						flex: 1
					},
					{
						text: 'Rule Details',
						dataIndex: 'Rule_Details',
						id: 'Rule_Details',
						flex: 1
						
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						id: 'updateBTRule',
						//iconCls: 'iconModify',
						sortable: false,
						listeners: {
							click: function(grid, item, rowIndex, colIndex, metaData){
								var currentRowIndex = rowIndex;
								var currentColIndex = colIndex;
								var currentGrid = grid;
								
								var ruleNameData = currentGrid.getStore().getAt(currentRowIndex).data['Rule_Name'];
								var urlPatternData = currentGrid.getStore().getAt(currentRowIndex).data['Matching_URL_Pattern'];
								var ruleDetailsData = currentGrid.getStore().getAt(currentRowIndex).data['Rule_Details'];
								ruleDetailsData = ruleDetailsData.substring(1,ruleDetailsData.length);
								var splitRuleDetails = ruleDetailsData.split('/');
								//console.log(currentGrid.getStore().getAt(currentRowIndex));
								//console.log(currentGrid.getStore().getAt(currentRowIndex).data['Rule_Details']);
								var variable = currentGrid.getStore().getAt(currentRowIndex).data['variable'];
								var innerCardObj = Ext.getCmp('resultPanel');
								innerCardObj.removeAll();
								innerCardObj.add({
									xtype: "businesstransactionrule"
								});
								Ext.getCmp('name').setValue(ruleNameData);
								var uriSpec = "";
								if (urlPatternData.startsWith("CONTAINS")){
									uriSpec = 'CON'
								}else if (urlPatternData.startsWith("ENDS WITH")){
									uriSpec = 'EW'
								}else if (urlPatternData.startsWith("STARTS WITH")){
									uriSpec = 'SW'
								}else if (urlPatternData.startsWith("EQUALS")){
									uriSpec = 'EQ'
								}
								//console.log(urlPatternData);
								Ext.getCmp('nameURL1').setValue(urlPatternData.split(" : ")[1].split('*').join(''));
								Ext.getCmp('uri_1').setValue(uriSpec)

								var maxIniCount=0;
								var segmentCount=0;
								for(var ruleDetail in splitRuleDetails){
									var urlSegmentType = '';
									var paramKey='';
									var regex = '';
									var iniNum = '';
									if(ruleDetail<splitRuleDetails.length && splitRuleDetails[ruleDetail].startsWith('URL_SEGMENT')){
										var currentIniCount = splitRuleDetails[ruleDetail].split('#')[1];
										if(currentIniCount==1){
											maxIniCount=0;
											var idx=ruleDetail;
											var iniCount=1;
											segmentCount++;

											while( idx < splitRuleDetails.length && iniCount==splitRuleDetails[idx++].split('#')[1] ){
												maxIniCount++;
												iniCount++;
											}
											urlSegmentType = '1stFew';
											iniNum = maxIniCount;										
										}else if(!(currentIniCount<=maxIniCount)){
											urlSegmentType = 'specific';
											iniNum = currentIniCount;										
											segmentCount++;
										}
									}else if(splitRuleDetails[ruleDetail].startsWith('REQUEST_PARAM_VALUE_FOR')){
										//console.log(splitRuleDetails[ruleDetail])
										var requestParam = splitRuleDetails[ruleDetail].split(',');
//										console.log(requestParam[0].split(':'));
										 paramKey = requestParam[0].split(':')[1].trim();
										regex= (requestParam[1] != undefined)? requestParam[1].split(':')[1].trim() : '';
										urlSegmentType = 'param';
										segmentCount++;
									}
									if(!(urlSegmentType == '' && paramKey == '' && regex == '' && iniNum == '')){
										if(segmentCount==1){
											Ext.getCmp('urlsegment_1_1').setValue(urlSegmentType);
											if(urlSegmentType == '1stFew'){
												Ext.getCmp('urlsegmentNo_1_1').setValue(iniNum);
											}else if(urlSegmentType == 'specific'){
												Ext.getCmp('urlspecificsegmentNo_1_1').setValue(iniNum);
											}else{
												Ext.getCmp('urlParam_1_1').setValue(paramKey);
												Ext.getCmp('urlRegEx_1_1').setValue(regex);
											}										
										}else{										
											addUrlPropsContainer('urlPropsfieldset1',urlSegmentType,iniNum,paramKey,regex);
										}
									}
								}
								Ext.getCmp('createRule').setText('Update Rule');
								Ext.getCmp('cpcVariable').setValue(variable);
								Ext.getCmp('name').focus(true, true);
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView) {
							//console.log(metaData);
							metaData.tdCls = "noEllipsis";
							metaData.tdAttr = "data-qtip='"+editRuleLabel+"' data-qclass='yellowTip'";
							return "<img src='/final/images/spacer.gif' style='cursor:pointer'  class='iconModify'/>";
						}
					},
					{
						header : '<div class="iconDeleteAll" data-qtip="Delete Selected" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						width: 36,
						id: 'deleteBTRule',
						sortable: false,
						listeners: {
							headerclick: function (c, a, b) {
								var grid=Ext.getCmp('btRulesGrid').getSelectionModel().getSelection();
								//console.log(grid);
								var values='';
								var array=new Array();
								var selectedRules="";
								if(grid=="")
								{
									Ext.MessageBox.show({
										title : btRulesGridTitle,
										msg : noBTRulesSelected,
										icon : 'iconExclamation',
										buttons : Ext.Msg.OK
									});
									return false;
								}
								for(var i=0; i < grid.length ; i++)
								{
									values=grid[i];
									id=values.get('variable');
									if(id!=null )
									{
										array.push(id);
									}
									
								}
								for(var j=0; j < array.length; j++)
								{
									selectedRules +=array[j]+",";
								}
								//console.log(selectedRules);
								Ext.Msg.show({
									title : btRulesGridTitle,
									msg : "Delete Selected Rules ?",
									icon : 'iconConfirmation',
									buttons : Ext.Msg.YESNO,
									fn : function(buttonText) {
										if (buttonText == "yes") 
										{
											var testName = publicJson['testName'];
											var compType = publicJson['selectedCompType'];
											var compName = publicJson['selectedCompName'];
											var resultUrl = "DefaultTestConfiguration/data/EGBTNamingJson.jsp?compName="+compName+"&compType="+compType+"&testName="+testName+"&crud=delete&variable="+encodeURIComponent(selectedRules);
											Ext.Ajax.request({
												url: resultUrl,
												method: 'POST',
												async:false,
												success: function( response )
												{
															//console.log(response);
													if ( response.status == 200  ) {
														me.getRulesData();
													}
												}
											});
										}
									}
								});
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView) {
							metaData.tdCls = "noEllipsis";
							metaData.tdAttr = "data-qtip='"+deleteRuleLabel+"' data-qclass='yellowTip'";
							return "<img src='/final/images/spacer.gif' style='cursor:pointer' onclick=\"javascript:me.handleDeleteIconClick('"+gridView+"','"+row+"','"+col+"')\" class='iconDelete'/>";
						}
					}
				]
			},
			margin: 10,
			tbar: [
				{
					xtype:'tbfill',
				},
				
				{
					xtype: 'toolbar',
					ui: 'footer',
					items: [
						{
							xtype: 'button',
							cls: 'button20',
							id: 'addNewRulebtn',
							text: addNewRuleLabel,
							width: 110,
							margin: '0 6 0 2'
						}
						
					]
				}
			]
		}
	]
	
});



