Ext.define('DefaultTestConfiguration.view.EgAmazonWSSimulator',{
	extend: 'Ext.window.Window',
	alias: 'widget.egamazonwssimulator',

	border: false,
	title: multiSrcTitle,
	id: 'egamazonwssimulator',
	width: 850,
	height: 480,
	padding:'5 10 10 10',
	autoScroll: true,
	modal: true,

	layout: {
		type: 'vbox',
		pack: 'start',
		align: 'stretch'
	},

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					id: 'addAmazonResourcebtn',
					name: 'addAmazonResourcebtn',
					width: 80,
					text: addmore_lbl
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Update,
					width: 80,
					id: 'updateAmazonResourceBtn',
					name: 'updateAmazonResourceBtn',
					margin: '0 0 0 10'
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Clear,
					width: 80,
					id: 'clearAmazonResourceBtn',
					name: 'clearAmazonResourceBtn',
					margin: '0 0 0 10'
				}
			]
		}
	],

	items: [
		{
			xtype: 'container',
			id: 'NoAmazonResourcePattern',
			hidden: true,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table><tr><td align="center" height="400"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">'+NoPublishedResource+'.</div></td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype : 'fieldset',
			id : 'con_1',
			width: 800,
			layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeAmazonResourceSet('con_1');
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelWidth:150
					},
					items: [
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Published resources',
							style:{'white-space':'nowrap'},
							id:'publisresource1',
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: registrationCode,
							inputType: 'password',
							style:{'white-space':'nowrap'},
							id:'regcode1',
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: Domain,
							style:{'white-space':'nowrap'},
							id:'domain1',
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: User,
							style:{'white-space':'nowrap'},
							id:'username1',
							value: '$unconfigured',
							columnWidth: 0.5
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: PasswordLbl,
							style:{'white-space':'nowrap'},
							id:'pwd1',
							inputType: 'password',
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: CnfPassLbl,
							style:{'white-space':'nowrap'},
							id:'confpwd1',
							inputType: 'password',
							//value: '$unconfigured',
							columnWidth: 0.5,
							backupValue: '$unconfigured',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id: 'backupamazonresrccontainer',
			layout: {
				type: 'vbox',
				align: 'stretch'
			}
		}
	]
});



