Ext.define('DefaultTestConfiguration.view.EgConfigureNamePattern',{
	extend: 'Ext.window.Window',
	alias: 'widget.egconfigurenamepattern',

	border: false,
	title: confNameTitle,
	id: 'egconfigurenamepattern',
	width: 850,
	height: 480,
	padding:'5 10 10 10',
	autoScroll: true,
	modal: true,

	layout: {
		type: 'vbox',
		pack: 'start',
		align: 'stretch'
	},

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					id: 'addUrlNamebtn',
					width: 80,
					text: addmore_lbl
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Update,
					width: 80,
					id: 'updateUrlPattern',
					name: 'updateUrlPattern',
					margin: '0 0 0 10'
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Clear,
					width: 80,
					id: 'clearUrlPattern',
					name: 'clearUrlPattern',
					margin: '0 0 0 10'
				}
			]
		}
	],

	items: [
		{
			xtype: 'container',
			id: 'NoUrlPattern',
			hidden: true,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table><tr><td align="center" height="400"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">'+nonamePatrn+'.</div></td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype : 'fieldset',
			id : 'con_1',
			width: 800,
			layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeUrlNameContact('con_1');
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelAlign: 'top'
					},
					items: [
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: Name,
							id: 'nameurl1',
							name: 'nameurl1',
							value: '$unconfigured',
							columnWidth: 0.40
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: Pattern,
							id: 'patternurl1',
							name: 'patternurl1',
							value: '$unconfigured',
							columnWidth: 0.40
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: Threshold_Value,
							id: 'thresholdurl1',
							name: 'thresholdurl1',
							value: '$unconfigured',
							columnWidth: 0.20
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id: 'urlpatterncontainer',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'stretch'
			}
		}
	]
});



