Ext.define('DefaultTestConfiguration.view.EgConfigureUrlAndCredentials',{
	extend: 'Ext.window.Window',
	alias: 'widget.egconfigureurlandcredentials',

	border: false,
	title: urlTitle,
	id: 'egconfigureurlandcredentials',
	width: 850,
	height: 480,
	padding:'5 10 10 10',
	autoScroll: true,
	modal: true,

	layout: {
		type: 'vbox',
		pack: 'start',
		align: 'stretch'
	},

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					id: 'addCredUrlbtn',
					width: 80,
					text: addmore_lbl
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Update,
					width: 80,
					id: 'updateCredUrl',
					name: 'updateCredUrl',
					margin: '0 0 0 10'
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Clear,
					width: 80,
					id: 'clearCredUrl',
					name: 'clearCredUrl',
					margin: '0 0 0 10'
				}
			]
		}
	],

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	items: [
		{
			xtype: 'container',
			id: 'NoCredUrlPattern',
			hidden: true,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table><tr><td align="center" height="400"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">'+noUrlCred+'.</div></td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype : 'fieldset',
			id : 'concred_1',
			style: {
				background : 'none',
				border : '1px solid lightGrey'
			},
			width: 800,
			layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin:'0 10 0 0',
					items : [
						{
							xtype : 'button',
							iconCls : 'img_removeShift',
							tooltip : '<b>Remove</b>',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeCredUrlContact('concred_1');
							}
						}
					]
				},
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelAlign: 'top'
					},
					items: [
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: Name,
							id: 'nameCred1',
							name: 'nameCred1',
							value: '$unconfigured',
							columnWidth: 0.25
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: urlLbl,
							id: 'urlCred1',
							name: 'urlCred1',
							value: '$unconfigured',
							columnWidth: 0.75
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: urlUnmeLbl,
							id: 'usrnameCred1',
							name: 'usrnameCred1',
							value: 'none',
							columnWidth: 0.25
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: urlPwdLbl,
							id: 'pwdCred1',
							name: 'pwdCred1',
							inputType: 'password',
							//value: 'none',
							columnWidth: 0.25,
							backupValue: 'none',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'fieldcontainer',
							layout: 'column',
							columnWidth: 0.30,
							fieldLabel: urlContentLbl,
							items: [
								{
									xtype: 'scrollcombo',
									cls: 'dropdown',
									id : 'contentCred1',
									name: 'contentCred1',
									displayField: 'displayField',
									columnWidth: 0.4,
									valueField: 'valueField',
									queryMode: 'local',
									value: 'none',
									editable: false,
									parent:this,
									store:new Ext.data.Store(
										{
											fields: ['displayField','valueField'],
											data: [{'displayField':'None','valueField':'none'},
											{'displayField':'Include','valueField':'Inc'},{'displayField':'Exclude','valueField':'Exc'}
											]
										}
									)
								},
								{
									xtype: 'textfield',
									cls: 'textbox',
									id: 'subcontentCred1',
									name: 'subcontentCred1',
									columnWidth: 0.6,
									margin: '0 0 0 5',
									value: 'none'
								}
							]
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: urlEncodeLbl,
							id: 'encodeCred1',
							name: 'encodeCred1',
							value: 'none',
							columnWidth: 0.20
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: urlPrivateLbl,
							id: 'privateKey1',
							name: 'privateKey1',
							value: 'none',
							columnWidth: 0.75,
							hidden: true
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: urlPwdLbl,
							id: 'passKey1',
							name: 'passKey1',
							//value: 'none',
							inputType: 'password',
							columnWidth: 0.25,
							hidden: true,
							backupValue: 'none',
							listeners:{
								afterrender: function () {
									this.setValue(this.backupValue);
								},
								change: function() {
									var changeValue = this.getValue();
									if (!Ext.isEmpty(changeValue))
									{
										this.backupValue = changeValue;
									}
								},
								blur :function()
								{
									var passObj = this;
									if (passObj.getValue() !== undefined || passObj.getValue() != "")
									{
										var backupValue = this.backupValue;
										passObj.setValue(backupValue);
									}
								},
								focus:function()
								{
									this.setValue("");
								}
							}
						},
						{
							xtype: 'fieldset',
							id:'syspropsfieldset1',
							name:'syspropsfieldset1',
							columnWidth: 1,
							hidden: true,
							title: urlSystemPropsTitleLbl,
							style: {
								background : 'none',
								border : '1px solid lightGrey'
							},
							layout : {
								type : 'vbox',
								pack : 'start',
								align : 'stretch'
							},
							margin: '10 10 0 10',
							items: [
								{
									xtype: 'container',
									id : 'sysPropsMainContainer1',
									layout: 'column',
									columnWidth: 1,
									defaults: {
										labelSeparator: '',
										margin: '0 5 5 5'
									},
									items: [
										{
											xtype : 'container',
											id: 'sysPropsContainer_1_1',
											name: 'sysPropsContainer_1_1',
											layout: 'column',
											columnWidth: 1,
											items : [
												{
													xtype: 'textfield',
													cls: 'textbox',
													fieldLabel: urlSystemKeyLbl,
													id: 'syspropkey_1_1',
													name: 'syspropkey_1_1',
													value: 'jsse.enableSNIExtension',
													margin: 5,
													columnWidth: 0.48,
													labelSeparator: ' ',
													labelAlign: 'top'
												},
												{
													xtype: 'textfield',
													cls: 'textbox',
													fieldLabel: urlSystemValLbl,
													id: 'syspropval_1_1',
													name: 'syspropval_1_1',
													value: 'false',
													columnWidth: 0.48,
													margin: 5,
													labelSeparator: ' ',
													labelAlign: 'top'
												},
												{
													xtype: 'component',
													html: '<center><div class="iconPlus" style="cursor:pointer;" data-qtip="<b>Add System Property</b>" onclick="javascript:addSysPropsContainer(sysPropsContainer_1_1)"></center>',
													columnWidth: 0.04,
													margin: '25 0 0 2'
												}
											]
										}
									]
								}
							]
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id: 'credurlcontainer',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'stretch'
			}
		}
	]
});



