Ext.define('DefaultTestConfiguration.view.EgSystemProperties',{
	extend: 'Ext.window.Window',
	alias: 'widget.egsystemproperties',

	border: false,
	title: SysPropTitle,
	id: 'egsystemproperties',
	width: 850,
	height: 480,
	padding:'5 10 10 10',
	autoScroll: true,
	modal: true,

	layout: {
		type: 'vbox',
		pack: 'start',
		align: 'stretch'
	},

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					id: 'addPropBtn',
					width: 80,
					text: 'Add More'
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Update,
					width: 80,
					id: 'updatePropBtn',
					name: 'updatePropBtn',
					margin: '0 0 0 10'
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Clear,
					width: 80,
					id: 'clearPropBtn',
					name: 'clearPropBtn',
					margin: '0 0 0 10'
				}
			]
		}
	],

	items: [
		{
			xtype: 'container',
			id: 'NoPropContainer',
			hidden: true,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table><tr><td align="center" height="400"><table><tr><td align="center"><div class="iconInformation"></div><div class="commonErrorMsgText">'+NoPropConfigured+'.</div></td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype : 'fieldset',
			id : 'con_1',
			width: 800,
			layout : {
				type : 'vbox',
				pack : 'center',
				align : 'stretch'
			},
			margin: '5 5 5 5',
			items: [
			
				{
					xtype: 'container',
					layout: 'column',
					defaults: {
						margin: 10,
						labelSeparator:' ',
						labelAlign: 'top'
					},
					items: [
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Property',
							style:{'white-space':'nowrap'},
							id: 'syspropkey1',
							name: 'syspropkey1',
							value: 'none',
							margin: '2 5 2 2',
							columnWidth: 0.48
						},
						{
							xtype: 'textfield',
							cls: 'textbox',
							fieldLabel: 'Value',
							style:{'white-space':'nowrap'},
							id: 'syspropval1',
							name: 'syspropval1',
							value: 'none',
							margin: '2 5 2 5',
							columnWidth: 0.48
						},
						{
							xtype: 'component',
							html: '<center><div class="iconMinus" style="cursor:pointer;" data-qtip="<b>Remove</b>" onclick="javascript:removeProperties(con_1)"></center>',
							columnWidth: 0.04,
							margin: '24 0 0 2'
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			id: 'propetiesmorecontainer',
			layout: {
				type: 'vbox',
				align: 'stretch'
			}
		}
	]
});



