Ext.define('DefaultTestConfiguration.view.MinMaxValues',{
	extend: 'Ext.window.Window',
	alias: 'widget.minmaxvalues',

	border: false,
	title: 'Performance Rating Test - Configure Minimum and Maximum Values',
	id: 'minmaxvalues',
	width: 850,
	height: 480,
	padding:'5 10 10 10',
	autoScroll: true,
	modal: true,
	closeAction:'destroy',
	doClose:function(){
		var me = this;
		me.focus();
		Ext.defer(function(){Ext.destroy(Ext.getCmp(me.id))},100);
	},

	layout: {
		type: 'vbox',
		pack: 'start',
		align: 'stretch'
	},

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Update,
					width: 80,
					id: 'updateMinMaxValues',
					margin: '0 0 0 10'
				}
			]
		}
	],

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'DefaultTestConfiguration/data/EgConfigureDefaultTestParamsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	items:[
		{
			xtype: 'container',
			id: 'ratingMeasuresContr',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'stretch'
			}
		}
	]
});



