<%
/*
 *   File		:	EgConfigureDefaultTestParamsp.jsp
 *   Purpose	:	Processing page for default test configuration
 *   Author		:	S.Anand (2009)
*/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="com.eg.EgUtils" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import="com.eg.EgCrypt" %>
<%@ page import="com.eg.EgServicesInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.IniHelper"%>
<%@ page import="com.eg.EgConfigInfo"%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>
<jsp:useBean id="servicer" scope="request" class="egurkha.ServiceBean"/>

<%!
	//param to be continued for snmpV1 and snmpV2
	String[] snmpV1V2ParamToContinue = {"username","authpass","authtype","encryptflag","encrypttype","encryptpassword"};

	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgServicesInfo egserInfo = new EgServicesInfo("manager");

	public ArrayList getArrayList(String strValue,String delimiter)
	{
		ArrayList aL = new ArrayList();
		StringTokenizer stTempTokens = new StringTokenizer(strValue,delimiter);
		while (stTempTokens.hasMoreTokens())
		{
			String str = stTempTokens.nextToken().trim();
			aL.add(str);
		}
		return aL;
	}

	public boolean isParameter(String encryptParam)
	{
		String decryptParam = EgCrypt.decrypt(encryptParam);
		if (decryptParam.equals(encryptParam)) // not password
		{
			return (true);
		}
		return false;
	}

	private ArrayList getParameterList(String str,boolean needLowerCaseKey)
	{
		String delimiter = " -";
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		str = str.substring(str.indexOf("-"));
		int spaceHyphenIdx = str.indexOf(delimiter);
		while (spaceHyphenIdx != -1)
		{
			String cutString = str.substring(0,spaceHyphenIdx);

			//This check will be carried out when the cutString contains only the key
			//for e.g.:-
			//str : -admin_password -103:98:88:90:79:76:81:-110:52 -ssl false
			//cutString : -admin_password
			if (cutString.trim().indexOf(" ") == -1)
			{
				String strPart1 = str.substring(cutString.length()+1);
				String strPart2 = strPart1.substring(0,strPart1.indexOf(delimiter));
				cutString = cutString+" "+strPart2;
				spaceHyphenIdx = cutString.length();
			}

			if (cutString.indexOf("\"") != -1)
			{
				String strAfterDoubleQuotes = str.substring(spaceHyphenIdx);
				String remainingPiece = strAfterDoubleQuotes.substring(0,strAfterDoubleQuotes.indexOf("\"")+1);
				cutString = cutString + remainingPiece;

				String key = cutString.substring(0,cutString.indexOf(" "));
				String value = cutString.substring(cutString.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(key.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(key.trim());
				}
				aListResultant.add(value.trim());

				String remainingString = strAfterDoubleQuotes.substring(strAfterDoubleQuotes.indexOf("\"")+1);
				str = remainingString.trim();
				if (str.length() == 0)
				{
					spaceHyphenIdx = -1;
				}
				else
				{
					spaceHyphenIdx = str.indexOf(delimiter);
				}
			}
			else
			{
				if (cutString.startsWith("- "))
				{
					int idx = aListResultant.indexOf(prevKey);
					String strValue = (String)aListResultant.get(idx+1);
					strValue = strValue + " " + cutString;
					aListResultant.remove(idx+1);
					aListResultant.add(strValue);

					str = str.substring(cutString.length()+1);
				}
				else
				{
					String key = cutString.substring(0,cutString.indexOf(" "));
					String value = cutString.substring(cutString.indexOf(" ")+1);
					if (needLowerCaseKey)
					{
						aListResultant.add(key.trim().toLowerCase());
						prevKey = key.trim().toLowerCase();
					}
					else
					{
						aListResultant.add(key.trim());
						prevKey = key.trim();
					}
					aListResultant.add(value.trim());

					str = str.substring(spaceHyphenIdx+1);
				}
				spaceHyphenIdx = str.indexOf(delimiter);
			}
		}

		if (str.length() > 0)
		{
			if (str.startsWith("- "))
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + " " + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
			else
			{
				String lastKey = str.substring(0,str.indexOf(" "));
				String lastValue = str.substring(str.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(lastKey.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(lastKey.trim());
				}
				aListResultant.add(lastValue.trim());
			}
		}

		return aListResultant;
	}

	public ArrayList updateOtherUnconfiguredParamValues (ArrayList aListProcessedParamNamesAndValues)
	{
		// For handling -measure_mode changes in JvmMemPoolGCTest 
		boolean isLogFile = (aListProcessedParamNamesAndValues.contains("-JREHome") && 
						aListProcessedParamNamesAndValues.contains("-LogFileName"));

		boolean isMeasureModeParamExist = (isLogFile && 
								aListProcessedParamNamesAndValues.contains("-measure_mode") && 
								aListProcessedParamNamesAndValues.contains("-Jmx_Remote_Port"));

		if (isMeasureModeParamExist)
		{
			int modeIdx = aListProcessedParamNamesAndValues.indexOf("-measure_mode");
			String modeValue = (String) aListProcessedParamNamesAndValues.get(modeIdx + 1);
			if (modeValue.equalsIgnoreCase("true"))
			{
				int paramIdx = aListProcessedParamNamesAndValues.indexOf("-Jmx_Remote_Port");
				String jmx_remote_port_value = (String) aListProcessedParamNamesAndValues.get(paramIdx + 1);
				if (jmx_remote_port_value != null && jmx_remote_port_value.equalsIgnoreCase("$unconfigured"))
				{
					aListProcessedParamNamesAndValues.set(paramIdx + 1, "none");
				}
			}
			else
			{
				int param1Idx = aListProcessedParamNamesAndValues.indexOf("-JREHome");
				int param2Idx = aListProcessedParamNamesAndValues.indexOf("-LogFileName");
				String jreHome_value = (String) aListProcessedParamNamesAndValues.get(param1Idx + 1);
				String logFile_value = (String) aListProcessedParamNamesAndValues.get(param2Idx + 1);
				if (jreHome_value != null && jreHome_value.equalsIgnoreCase("$unconfigured"))
				{
					aListProcessedParamNamesAndValues.set(param1Idx + 1, "none");
				}
				if (logFile_value != null && logFile_value.equalsIgnoreCase("$unconfigured"))
				{
					aListProcessedParamNamesAndValues.set(param2Idx + 1, "none");
				}
			}
		}
		return aListProcessedParamNamesAndValues;
	}

%>

<%
	try
	{
		//code for auditlog  - starts 
		boolean isAuditLogEnabled = egserInfo.isAuditlogEnabled();
		AuditLogThread auditLogThread = null;
		StringBuffer strAuditBuffer = null;
		ArrayList aListAuditCurrentSettingParams = null;
		ArrayList aListAuditPreviousSettingParams = null;
		String tempHost = null;
		ArrayList aListTempParamNamesAndValues = null;
		String oldTestPeriodValue = null;
		if (isAuditLogEnabled)
		{
			auditLogThread = new AuditLogThread();
			auditLogThread.setValue("Category","Admin");
			auditLogThread.setValue("User_id",_user.getLoginID());
			auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
			auditLogThread.setValue("Session_id",session.getId());
			auditLogThread.setValue("Module","Default Test Configuration");
			auditLogThread.setValue("Activity","Configure Test");

			strAuditBuffer = new StringBuffer();
			aListAuditCurrentSettingParams = new ArrayList();
			aListAuditPreviousSettingParams = new ArrayList();
			aListTempParamNamesAndValues = new ArrayList();
			tempHost = "";
		}
		//code for auditlog  - ends

		Arrays.sort(snmpV1V2ParamToContinue, String.CASE_INSENSITIVE_ORDER);

		String componentType = request.getParameter("componentType");
		String testName = request.getParameter("testName");
		String query = "";
		//This list will contain user updated parameter name and values
		ArrayList aListTemp = new ArrayList();

		ArrayList aListDisplayParamNamesAndValues = new ArrayList();

		//variables declared for config file sync - starts
		ArrayList aListSpecsIniEntries = new ArrayList();
		ArrayList aListServicesIniEntries = null;
		//variables declared for config file sync - ends

		Hashtable hashTestsAndDelimiters = new Hashtable();

		//contains tests having '#' as delimiter - starts
		String testNameDelimiter[] = egSpecs.getTestInfosWithDelimiters();
		ArrayList aListTestsWithDelimiterHash = new ArrayList();
		for (int i=0; i<testNameDelimiter.length; i++)
		{
			String delimiter = egSpecs.getTestInfoDelimiter(testNameDelimiter[i]);
			if (delimiter.equals("#"))
			{
				if (!aListTestsWithDelimiterHash.contains(testNameDelimiter[i]))
				{
					aListTestsWithDelimiterHash.add(testNameDelimiter[i]);
				}
			}
			hashTestsAndDelimiters.put(testNameDelimiter[i].trim(),delimiter);
		}
		boolean isHashDelimiter = aListTestsWithDelimiterHash.contains(testName);
		//contains tests having '#' as delimiter - ends

		Hashtable hashDelimitersAndMasks = new Hashtable();
		IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
		String strDelimiters[] = testsIni.getVariables("TEST_INFO_DELIMITER_MASK");
		for (int m=0;m<strDelimiters.length;m++)
		{
			String strDelimiterTemp = strDelimiters[m];
			String strMaskTemp = testsIni.getValue("TEST_INFO_DELIMITER_MASK",strDelimiterTemp);
			hashDelimitersAndMasks.put(strDelimiterTemp,strMaskTemp);
		}

		String strDelimiter = "";
		String strMask = "";
		boolean b_testWithDelimiter = hashTestsAndDelimiters.containsKey(testName.trim());
		boolean b_delimiterWithMask = false;
		if (b_testWithDelimiter)
		{
			strDelimiter = (String)hashTestsAndDelimiters.get(testName);
		}

		ArrayList aListPasswordParameters = (ArrayList)session.getAttribute("aListPasswordParameters");
		boolean hasPasswordParameters = false;
		if (aListPasswordParameters != null)
		{
			hasPasswordParameters = true;
		}

		boolean isOldSnmp = false;
		Boolean isOldSnmpObj = (Boolean)session.getAttribute("isOldSnmp");
		if (isOldSnmpObj != null)
		{
			isOldSnmp = isOldSnmpObj.booleanValue();
		}

		ArrayList aListDefaultPasswordParameters = (ArrayList)session.getAttribute("aListDefaultPasswordParameters");
		boolean hasDefaultPasswordParameter = false;
		if (aListDefaultPasswordParameters != null)
		{
			hasDefaultPasswordParameter = true;
		}

		ArrayList aListParamsWithDoubleQuotes = (ArrayList)session.getAttribute("aListParamsWithDoubleQuotes");
		if (aListParamsWithDoubleQuotes == null)
		{
			aListParamsWithDoubleQuotes = new ArrayList();
		}

		String strFilterType = request.getParameter("selectedFilterType");
		Enumeration e = request.getParameterNames();
		testName = testName.trim();
		while (e.hasMoreElements())
		{
			String strParamName = (String)e.nextElement();
			b_delimiterWithMask = hashDelimitersAndMasks.containsKey(testName+":"+strParamName+":"+strDelimiter);
			if (b_delimiterWithMask)
			{
				strMask = (String)hashDelimitersAndMasks.get(testName+":"+strParamName+":"+strDelimiter);
			}
			String strParamValue = request.getParameter(strParamName);
			boolean isPasswordParameter = false;
			boolean allowToTrim = true;
			if (hasPasswordParameters)
			{
				if (aListPasswordParameters.contains("-"+strParamName))
				{
					isPasswordParameter = true;
					allowToTrim = false;
				}
			}
			if (strParamValue.indexOf(" -") > -1 || aListParamsWithDoubleQuotes.contains(strParamName.toLowerCase()))
			{
				strParamValue = "\"" + strParamValue + "\"";
				allowToTrim = false;
			}
			//a line feed ('\n') or enter key
			while(strParamValue.indexOf("\n") > -1)
			{
				int idx = strParamValue.indexOf("\n");
				String strPrefix = strParamValue.substring(0,idx-1);
				String strSuffix = strParamValue.substring(idx+1,strParamValue.length());
				strSuffix = strSuffix.trim();
				strParamValue = strPrefix + strSuffix;
			}
			//special case - if the user selects multiple value for filter
			if (strParamName.equalsIgnoreCase("filter") || strParamName.equalsIgnoreCase("filter_combo"))
			{
				String[] filterValue = null;
				if  (!StringUtils.isNull(strFilterType) && strFilterType.equals("combo")) 
				{
					strParamName = "filter";
					filterValue = request.getParameterValues("filter_combo");
				}
				else
				{
					filterValue = request.getParameterValues("filter");
				}
				ArrayList aListFilterValue = new ArrayList(Arrays.asList(filterValue));
				strParamValue = aListFilterValue.toString();
				strParamValue = strParamValue.substring(1,strParamValue.length()-1);
				if (strParamValue.indexOf(",") > -1)
				{
					if (strParamValue.indexOf(";") == -1)
					{
						if (strParamValue.indexOf(":") > -1)
						{
							strParamValue = StringUtils.replace(strParamValue,",","|");
						}
						else
						{
							strParamValue = StringUtils.replace(strParamValue,",",";");
							strParamValue = StringUtils.replace(strParamValue," ","");
						}
					}
					else
					{
						strParamValue = StringUtils.replace(strParamValue,",","|");
					}
				}
			}
			else if (strParamName.equalsIgnoreCase("Target_DiskIO_Rate"))
			{
				String targetDiskIORate_select = request.getParameter("TargetDiskIORate_select");
				String targetDiskIORate = request.getParameter("Target_DiskIO_Rate");
				strParamValue = targetDiskIORate_select + "_" + targetDiskIORate;
			}
			else if (strParamName.equalsIgnoreCase("executiontime") && 
				request.getParameter("minutes") != null && 
				request.getParameter("hours") != null)
			{
				strParamValue = request.getParameter("hours") + ":" + request.getParameter("minutes");
			}
			else if (b_testWithDelimiter && strParamValue.indexOf(strDelimiter) != -1 && b_delimiterWithMask)
			{
				strParamValue = StringUtils.replace(strParamValue,strDelimiter,strMask);
			}

			aListTemp.add("-"+strParamName);
			if (allowToTrim)
			{
				strParamValue = strParamValue.trim();
			}
			aListTemp.add(strParamValue);
		}

		ArrayList aListEnabledTestForCompType = null;
		//tells whether _cf test is enabled or not
		boolean isConfigSupported = EgInstallInfo.isConfigSupported;

		//ensure whether the user is configuration management enabled
		if (_user != null && isConfigSupported)
		{
			EgUserRole userRole = _user.getUserRole();
			isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
		}

		if (isConfigSupported)
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
			aListEnabledTestForCompType.addAll(egSpecs.getEnabledTests(componentType,true));
		}
		else
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		}
		//code to get test relations from eg_testparam.ini starts here
		prgBean.createFile("eg_testparam.ini");
		String testRelationVariables[] = prgBean.getVariables("TEST_RELATIONS");
		String testRelation = prgBean.getStrValue("TEST_RELATIONS",testName);
		ArrayList aListRelationTests = new ArrayList();
		ArrayList aListConfigurableTest = new ArrayList();
		if (!testRelation.equals("") && testRelation.length() > 0)
		{
			aListRelationTests.add(testName);
			aListRelationTests.addAll(getArrayList(testRelation,","));
		}
		else if (testRelation.equals("") && testRelation.length() == 0)
		{
			aListRelationTests.add(testName);
		}

		if (aListEnabledTestForCompType != null)
		{
			for(int k=0;k<aListRelationTests.size();k++)
			{
				String strTestName = (String)aListRelationTests.get(k);
				if (aListEnabledTestForCompType.contains(strTestName))
				{
					aListConfigurableTest.add(strTestName);
				}
			}
		}

		String commonTestRelationVariables[] = prgBean.getVariables("COMMON_TEST_RELATIONS");
		ArrayList aListCommonTestRelationVariables = new ArrayList();
		for (int i=0;i<commonTestRelationVariables.length;i++)
		{
			String eachVariable = commonTestRelationVariables[i];
			ArrayList aListTempVariable = getArrayList(eachVariable,",");
			if (aListTempVariable.contains(testName))
			{
				aListCommonTestRelationVariables.addAll(aListTempVariable);
				break;
			}
		}

		String port = "";
		if (componentType.equals("Oracle_server"))
		{
			port = "$portNo:$sid";
		}
		else
		{
			port = "$portNo";
		}

		//stopping discovery before writing to eg_specs
		//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
		IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
		servicer.stopDiscovery();

		String strTestPeriod = "";
		for (int i=0;i<aListConfigurableTest.size();i++)
		{
			String strTestName = ((String)aListConfigurableTest.get(i)).trim();
			String patternA = strTestName + ":" + componentType + ":" + "$hostName" + ":" + port;
			String patternB = strTestName + ":" + componentType + ":" + "$hostName";
			String patternC = strTestName + "::" + "$hostName" + ":" + port;
			String patternD = strTestName + "::" + "$hostName";

			List listSpecficationVariables = Arrays.asList(egSpecs.getTestSpecVar());
			String resultantPattern = "";
			if (listSpecficationVariables.contains(patternA))
			{
				resultantPattern = patternA;
			}
			else if (listSpecficationVariables.contains(patternB))
			{
				resultantPattern = patternB;
			}
			else if (listSpecficationVariables.contains(patternC))
			{
				resultantPattern = patternC;
			}
			else if (listSpecficationVariables.contains(patternD))
			{
				resultantPattern = patternD;
			}

			if (resultantPattern.equals("")) continue;

			String defaultTestParams = egSpecs.getArgsForTest(resultantPattern);
			StringTokenizer stParamTokens = new StringTokenizer(defaultTestParams,",");
			String param1 = stParamTokens.nextToken().trim();
			String param2 = stParamTokens.nextToken();
			String testParams = stParamTokens.nextToken();
			oldTestPeriodValue = stParamTokens.nextToken().trim();
			String testPeriod = request.getParameter("testPeriod");
			testPeriod = testPeriod.trim();

			if (isOldSnmp)
			{
				ArrayList aListOldParams = getParameterList(testParams,true);
				if (!aListOldParams.contains("-snmpversion"))
				{
					int snmpComIdx=aListOldParams.indexOf("-snmpcommunity");
					aListOldParams = getParameterList(testParams,false);
					aListOldParams.add(snmpComIdx+2,"-snmpversion");
					aListOldParams.add(snmpComIdx+3,"v1");

					testParams = aListOldParams.toString();
					testParams = testParams.substring(1,testParams.length()-1);
					testParams = StringUtils.replace(testParams,",","");
				}
			}

			ArrayList aListParamNamesAndValues = getParameterList(testParams,false);
			ArrayList aListUpdatedParamNamesAndValues = new ArrayList();

			//code for auditlog  - starts
			if (isAuditLogEnabled && i==0 )
			{
				for (int j=0;j<aListParamNamesAndValues.size();j=j+2)
				{
					String str = ((String)aListParamNamesAndValues.get(j)).toUpperCase();
					aListTempParamNamesAndValues.add(str);
					str = ((String)aListParamNamesAndValues.get(j+1));
					aListTempParamNamesAndValues.add(str);
				}
			}
			//code for auditlog  - ends

			for (int j=0;j<aListParamNamesAndValues.size();j=j+2)
			{
				String paramName = (String)aListParamNamesAndValues.get(j);
				String paramValue = (String)aListParamNamesAndValues.get(j+1);
				aListUpdatedParamNamesAndValues.add(paramName);
				boolean allowToModifyParameterValue = true;
				if (i != 0)
				{
					if (paramName.equalsIgnoreCase("-ddfreq"))
					{
						allowToModifyParameterValue = false;
					}
				}
				if (aListTemp.contains(paramName) && allowToModifyParameterValue)
				{
					int idx = aListTemp.indexOf(paramName);
					String strValue = (String)aListTemp.get(idx+1);
					if (isHashDelimiter && strValue.indexOf(',') > -1)
					{
						strValue = StringUtils.replace(strValue,",","#");
					}
					//No else if block to replace comma with pipe because
					//down the line we have to process the parameter value where 
					//each token is separated using comma.After processing the parameter,
					//comma is replaced with pipe symbol.
					//for eg credentials,url parameter value have to be processed.
					aListUpdatedParamNamesAndValues.add(strValue);
				}
				else
				{
					aListUpdatedParamNamesAndValues.add(paramValue);
				}
			}

			ArrayList aListProcessedParamNamesAndValues = new ArrayList();
			for (int j=0; j<aListUpdatedParamNamesAndValues.size(); j=j+2)
			{
				String strParamName = (String)aListUpdatedParamNamesAndValues.get(j);
				String strParamValue = (String)aListUpdatedParamNamesAndValues.get(j+1);

				boolean encryptPasswordData = false;
				if (hasPasswordParameters && aListPasswordParameters.contains(strParamName))
				{
					encryptPasswordData = true;
				}
				else if (hasDefaultPasswordParameter && aListDefaultPasswordParameters.contains(strParamName.toLowerCase()))
				{
					encryptPasswordData = true;
				}

				if (strParamName.equals("-url"))
				{
					//handling parameter value for url
					if (strParamValue.indexOf(",") > -1)
					{
						String encodedUrl = "";
						StringTokenizer st12 = new StringTokenizer(strParamValue,",");
						String tempUrl = "";
						while (st12.hasMoreTokens())
						{
							tempUrl = st12.nextToken();
							if (tempUrl.indexOf("?") > -1)
							{
								int urlIndex = tempUrl.indexOf("?");
								tempUrl = tempUrl.substring(0, urlIndex) + "?" + URLEncoder.encode(tempUrl.substring(urlIndex + 1));
							}

							if (encodedUrl != null && !encodedUrl.equals(""))
								encodedUrl = encodedUrl + "|" + tempUrl;
							else
								encodedUrl = tempUrl;
						}
						strParamValue = encodedUrl;
					}
					else
					{
						if(strParamValue.indexOf("?") > -1)
						{
							int vecValIndex = strParamValue.indexOf("?");
							strParamValue = strParamValue.substring(0, vecValIndex) + "?" + URLEncoder.encode(strParamValue.substring(vecValIndex + 1));
						}
					}
				}
				else if (encryptPasswordData)
				{
					//handling parameter value for password type data
					strParamValue = EgCrypt.decrypt(strParamValue);
					String passList = "";
					if((testName.equals("CtxAuthTest") || testName.equals("WinAuthTest") || testName.equals("TermAuthTest") || testName.equals("WindowshareTest")) && strParamValue.indexOf("#~#") > -1)
					{
						ArrayList aListTokens = StringUtils.myTokenizer(strParamValue, "#~#");
						for(int m=0;m<aListTokens.size();m++)
						{
							passList += EgCrypt.encrypt((String)aListTokens.get(m))+"|";
						}
						passList = passList.substring(0, passList.length()-1);
					}
					else
					{
						passList = EgCrypt.encrypt(strParamValue);
					}
					strParamValue = passList;
				}
				else if(strParamName.equalsIgnoreCase("-credentials"))
				{
					//handling parameter value for credentials
					String credentialUser = "";
					String credentialPassword = "";
					int thisCount = 0;
					StringBuffer credentialResultantBuffer = new StringBuffer();
					StringTokenizer credentialTokens = new StringTokenizer(strParamValue,",");
					while (credentialTokens.hasMoreTokens())
					{
						thisCount++;
						if (thisCount > 1)
						{
							credentialResultantBuffer.append("|");
						}
						String eachUnameUpass = credentialTokens.nextToken();
						credentialUser = eachUnameUpass.substring(0,eachUnameUpass.indexOf(":"));
						if (egserInfo.isAesEncryptForTestConfig())
						{
							credentialPassword = EgCrypt.encrypt(eachUnameUpass.substring(eachUnameUpass.indexOf(":")+1,eachUnameUpass.length()));
						}
						else
						{
							credentialPassword = EgCrypt.encrypt(eachUnameUpass.substring(eachUnameUpass.indexOf(":")+1,eachUnameUpass.length()), true);
						}
						credentialResultantBuffer.append(credentialUser+":"+credentialPassword);
					}
					strParamValue = credentialResultantBuffer.toString();
				}
				else if(strParamName.equalsIgnoreCase("-privateKey"))
				{
					//handling parameter value for File password
					String filePath="none";
					String filePassword = "none";
					String encryptedFilePassword= "";
					int thisCount = 0;
					StringBuffer resultantBuffer = new StringBuffer();
					StringTokenizer resultTokens = new StringTokenizer(strParamValue,",");
					while (resultTokens.hasMoreTokens())
					{
						thisCount++;
						if (thisCount > 1)
						{
							resultantBuffer.append("|");
						}
						String eachFnameFpass = resultTokens.nextToken();
						String tokens[] = EgUtils.getTokens(eachFnameFpass,"#~~#");
						if(tokens != null && tokens.length==2)
						{
							filePath = tokens[0];
							filePassword = tokens[1];
						}
						if (egserInfo.isAesEncryptForTestConfig())
						{
							encryptedFilePassword = EgCrypt.encrypt(filePassword);
						}
						else
						{
							encryptedFilePassword = EgCrypt.encrypt(filePassword, true);
						}
						resultantBuffer.append(filePath+":"+encryptedFilePassword);
					}
					strParamValue = resultantBuffer.toString();
				}

				//replacing pipe in place of comma for the tests having pipe as delimiter
				if (!isHashDelimiter && strParamValue.indexOf(",") > -1)
				{
					strParamValue = StringUtils.replace(strParamValue,",","|");
				}
				if (!isHashDelimiter && strParamValue.indexOf(";") > -1)
				{
					strParamValue = StringUtils.replace(strParamValue,";","~#~");
				}

				aListProcessedParamNamesAndValues.add(strParamName);
				aListProcessedParamNamesAndValues.add(strParamValue);
			}

			aListProcessedParamNamesAndValues = updateOtherUnconfiguredParamValues(aListProcessedParamNamesAndValues);

			String resultantTestParameterSet = aListProcessedParamNamesAndValues.toString();
			resultantTestParameterSet = resultantTestParameterSet.substring(1,resultantTestParameterSet.length()-1);
			resultantTestParameterSet =StringUtils.replace(resultantTestParameterSet,",","");

			//for testperiod - starts
			if (strTestName.equals(testName))//userInitiatedTest
			{
				strTestPeriod = testPeriod;
			}
			else
			{
				if (aListCommonTestRelationVariables.contains(strTestName))
				{
					strTestPeriod = testPeriod;
				}
				else
				{
					strTestPeriod = oldTestPeriodValue;
				}
			}
			//for testperiod - ends

			resultantTestParameterSet = param1 + "," + param2 + ", " + resultantTestParameterSet + ", " + strTestPeriod;

			//set the value in the specs
			aListSpecsIniEntries.add(new IniHelper(IniHelper.SET,EgSpecsInfo.testSpecSection,resultantPattern,resultantTestParameterSet));

			//to display the updated parameters and their values to the user-starts
			if (i == 0)
			{
				String tempValue = new String(testPeriod);
				tempValue = tempValue.trim();
				if (Integer.parseInt(tempValue) <= 60)
				{
					tempValue+=" secs";
				}
				else if (Integer.parseInt(tempValue) <= 3599)
				{
					int tpmin=Integer.parseInt(tempValue)/60;
					tempValue=""+tpmin+" mins";
				}
				else if (tempValue.equals("3600"))
				{
					tempValue="1 hr";
				}
				else
				{
					int tphr=Integer.parseInt(tempValue)/3600;
					tempValue=""+tphr+" hrs";
				}

				aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test.TEST PERIOD"));
				aListDisplayParamNamesAndValues.add(tempValue);

				//for auditlog -starts
				if (isAuditLogEnabled)
				{
					if(Integer.parseInt(oldTestPeriodValue) < Integer.parseInt(testPeriod))
					{
						aListAuditCurrentSettingParams.add("TEST PERIOD");
						aListAuditCurrentSettingParams.add(tempValue);

						oldTestPeriodValue = oldTestPeriodValue.trim();

						if (Integer.parseInt(oldTestPeriodValue) <= 60)
						{
							oldTestPeriodValue+=" secs";
						}
						else if (Integer.parseInt(oldTestPeriodValue) <= 3599)
						{
							int tpmin=Integer.parseInt(oldTestPeriodValue)/60;
							oldTestPeriodValue=""+tpmin+" mins";
						}
						else if (oldTestPeriodValue.equals("3600"))
						{
							oldTestPeriodValue="1 hr";
						}
						else
						{
							int tphr=Integer.parseInt(oldTestPeriodValue)/3600;
							oldTestPeriodValue=""+tphr+" hrs";
						}

						aListAuditPreviousSettingParams.add("TEST PERIOD");
						aListAuditPreviousSettingParams.add(oldTestPeriodValue);
					}
				}
				//for auditlog - ends

				ArrayList aListDisplay = (ArrayList)session.getAttribute("aListDisplay");

				if (aListProcessedParamNamesAndValues.contains("-snmpversion"))
				{
					int snmpVerIdx = aListProcessedParamNamesAndValues.indexOf("-snmpversion");
					String temp1 = (String)aListProcessedParamNamesAndValues.remove(snmpVerIdx);
					String temp2 = (String)aListProcessedParamNamesAndValues.remove(snmpVerIdx);
					int snmpComIdx = aListProcessedParamNamesAndValues.indexOf("-snmpCommunity");
					aListProcessedParamNamesAndValues.add(snmpComIdx+2,temp2);
					aListProcessedParamNamesAndValues.add(snmpComIdx+2,temp1);
				}

				for(int j=0;j<aListProcessedParamNamesAndValues.size();j=j+2)
				{
					String paramName = (String)aListProcessedParamNamesAndValues.get(j);
					paramName = paramName.substring(1).trim();

					if (request.getParameter(paramName) == null)
					{
						continue;
					}

					String paramValue = (String)aListProcessedParamNamesAndValues.get(j+1);
					paramValue = paramValue.trim();

					if (paramName.equalsIgnoreCase("agentless") || 
						paramName.equalsIgnoreCase("site") || 
						paramName.equalsIgnoreCase("aluser") || 
						paramName.equalsIgnoreCase("alpassword") || 
						paramName.equalsIgnoreCase("almode") || 
						paramName.equalsIgnoreCase("sshPort") || 
						paramName.equalsIgnoreCase("host") || 
						paramName.equalsIgnoreCase("port"))
					{
						continue;
					}

					boolean showConfirmPassWord = false;
					if (hasPasswordParameters && aListPasswordParameters.contains("-"+paramName))
					{
						continue;
					}
					else if (hasDefaultPasswordParameter && aListDefaultPasswordParameters.contains("-" + paramName.toLowerCase()))
					{
						continue;
					}

					if (paramName.equalsIgnoreCase("rptName") || 
						paramName.equalsIgnoreCase("mCount"))
					{
						continue;
					}

					if (paramValue.startsWith("\"") && paramValue.endsWith("\""))
					{
						paramValue = paramValue.substring(1,paramValue.length()-1);
					}

					if (paramName.equalsIgnoreCase("os"))
					{
						if (paramValue.equalsIgnoreCase("xp"))
						{
							paramValue = "Window XP";
						}
						else if (paramValue.equalsIgnoreCase("2003"))
						{
							paramValue = "Windows 2003";
						}
						else if (paramValue.equalsIgnoreCase("2008"))
						{
							paramValue = "Windows 2008";
						}
						else if (paramValue.equalsIgnoreCase("w2k"))
						{
							paramValue = "Windows 2000";
						}
						else if (paramValue.equalsIgnoreCase("nt"))
						{
							paramValue = "Windows NT";
						}
						else if (paramValue.equalsIgnoreCase("hpux") || 
							paramValue.equalsIgnoreCase("aix"))
						{
							paramValue = paramValue.toUpperCase();
						}
						else if (paramValue.equalsIgnoreCase("tru64"))
						{
							paramValue = "Tru64";
						}
						else if (paramValue.equalsIgnoreCase("linux"))
						{
							paramValue = "Linux";
						}
						else if (paramValue.equalsIgnoreCase("solaris"))
						{
							paramValue = "Solaris";
						}
						else if (paramValue.equalsIgnoreCase("other"))
						{
							paramValue = "Other";
						}
					}
					else if (paramName.equalsIgnoreCase("Target_DiskIO_Rate"))
					{
						String tempTargetDiskIORate = paramValue.substring(0,paramValue.indexOf("_"));
						String tempTargetDiskIORateValue = paramValue.substring(paramValue.indexOf("_")+1,paramValue.length());

						if (tempTargetDiskIORate.equalsIgnoreCase("eq"))
						{
							tempTargetDiskIORate = "Equals";
						}
						else if (tempTargetDiskIORate.equalsIgnoreCase("lt"))
						{
							tempTargetDiskIORate = "Less Than";
						}
						else if (tempTargetDiskIORate.equalsIgnoreCase("le"))
						{
							tempTargetDiskIORate = "Less Than or Equal To";
						}
						else if (tempTargetDiskIORate.equalsIgnoreCase("gt"))
						{
							tempTargetDiskIORate = "Greater Than";
						}
						else
						{
							tempTargetDiskIORate = "Greater Than or Equal To";
						}

						paramValue = tempTargetDiskIORate + " " + tempTargetDiskIORateValue;
					}

					if(paramName.equalsIgnoreCase("credentials"))
					{
						String temp = "";
						ArrayList aListUsers = getArrayList(paramValue,"|");
						for(int b=0;b<aListUsers.size();b++)
						{
							String str=(String)aListUsers.get(b);
							str = str.substring(0,str.indexOf(":"));
							temp = temp + str + ",";
						}
						temp = temp.substring(0,temp.length()-1);
						paramValue = temp;
					}

					if (!aListDisplay.contains(paramName+"#"+paramValue) && 
						(paramValue.equalsIgnoreCase("false") || paramValue.equalsIgnoreCase("n")))
					{
						aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
						aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.common.No"));
						
					}
					else if (!aListDisplay.contains(paramName+"#"+paramValue) && 
						(paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("y")))
					{
						aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
						aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.common.Yes"));
					}
					else
					{
						aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
						if(paramValue.indexOf("|")>-1)
						{
							paramValue = StringUtils.replace(paramValue,"|",",");
						}
						if (paramValue.indexOf("~#~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~#~",";");
						}

						if(!paramName.equalsIgnoreCase("snmpcommunity") && paramValue.indexOf("#")>-1)
						{
							paramValue = StringUtils.replace(paramValue,"#",",");
						}

						if (paramName.equalsIgnoreCase("url"))
						{
							int tempUrlIdx = aListTemp.indexOf("-"+paramName);
							paramValue = (String)aListTemp.get(tempUrlIdx+1);
						}

						if (b_testWithDelimiter && strMask.length() > 0 && paramValue.indexOf(strMask) != -1)
						{
							paramValue = StringUtils.replace(paramValue,strMask,strDelimiter);
						}

						if (aListDisplay.contains(paramName+"#"+paramValue))
						{
							int paramValIdx = aListDisplay.indexOf(paramName+"#"+paramValue);
							paramValue = (String)aListDisplay.get(paramValIdx+1);
						}
						aListDisplayParamNamesAndValues.add(paramValue);
					}

					if (paramName.equalsIgnoreCase("snmpversion") && 
						(paramValue.equalsIgnoreCase("v1") || paramValue.equalsIgnoreCase("v2")))
					{
						//Displaying the needed parameters in the ui for snmpV1 and snmpV2 only.
						int snmpParamIdx = Arrays.binarySearch(snmpV1V2ParamToContinue,paramName,String.CASE_INSENSITIVE_ORDER);

						if (snmpParamIdx > -1) continue;
					}
					if (paramName.equalsIgnoreCase("encryptflag") && 
						paramValue.equalsIgnoreCase("false"))
					{
						break;
					}
				}
			}
			//to display the updated paramters and their values to the user-ends
		}

		// for discovery changes - starts
		if (aListTemp.contains("-virtual_center"))
		{
			int vcidx = aListTemp.indexOf("-virtual_center");
			String virtual_centerValue = (String)aListTemp.get(vcidx+1);

			if (!virtual_centerValue.equalsIgnoreCase("other") && !virtual_centerValue.equalsIgnoreCase("none"))
			{
				IniFile eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

				int esxUserIdx = aListTemp.indexOf("-Esx_user");
				String strEsxUserValue = (String)aListTemp.get(esxUserIdx+1);

				int esxPasswordIdx = aListTemp.indexOf("-Esx_password");
				String strEsxPasswordValue = (String)aListTemp.get(esxPasswordIdx+1);
				strEsxPasswordValue = EgCrypt.decrypt(strEsxPasswordValue);
				strEsxPasswordValue = EgCrypt.encrypt(strEsxPasswordValue);

				int esxSslIdx = aListTemp.indexOf("-ssl");
				String strSslValue = (String)aListTemp.get(esxSslIdx+1);

				int webPortIdx = aListTemp.indexOf("-webPort");
				String webPort = (String)aListTemp.get(webPortIdx+1);

				String isDiscovery = "No";
				String virtualCenterPattern = eg_servicesIni.getValue("VIRTUAL_CENTER",virtual_centerValue);
				StringTokenizer sst = new StringTokenizer(virtualCenterPattern,"#");
				if (sst.hasMoreTokens())
				{
					sst.nextToken();
					sst.nextToken();
					sst.nextToken();
					isDiscovery = sst.nextToken();
				}

				if (strSslValue != null)
				{
					if (strSslValue.equalsIgnoreCase("true"))
					{
						if (webPort != null)
						{
							if (webPort.equalsIgnoreCase("default"))
							{
								webPort = "443";
							}
						}
						else
						{
							webPort = "443";
						}
					}
					else
					{
						if (webPort != null)
						{
							if (webPort.equalsIgnoreCase("default"))
							{
								webPort = "80";
							}
						}
						else
						{
							webPort = "80";
						}
					}
				}

				String pattern = strSslValue + "#" + strEsxUserValue + "#" + strEsxPasswordValue + "#" + isDiscovery + "#" + webPort;
				if (aListServicesIniEntries == null)
				{
					aListServicesIniEntries = new ArrayList();
				}

				aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER",virtual_centerValue,pattern));
			}
		}
		// for discovery changes - ends

		if (aListTemp.contains("-hmc_server") && aListTemp.contains("-hmc_user"))
		{
			IniFile eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

			int hmcServerIdx = aListTemp.indexOf("-hmc_server");
			String hmcServerValue = (String)aListTemp.get(hmcServerIdx+1);

			int hmcUserIdx = aListTemp.indexOf("-hmc_user");
			String hmcUserValue = (String)aListTemp.get(hmcUserIdx+1);

			int hmcPasswordIdx = aListTemp.indexOf("-hmc_password");
			String hmcPasswordValue = (String)aListTemp.get(hmcPasswordIdx+1);
			hmcPasswordValue = EgCrypt.decrypt(hmcPasswordValue);
			hmcPasswordValue = EgCrypt.encrypt(hmcPasswordValue);

			int sslIdx = aListTemp.indexOf("-ssl");
			String sslValue = (String)aListTemp.get(sslIdx+1);

			String isDiscovery = "No";
			String hmcPattern = eg_servicesIni.getValue("HMC",hmcServerValue);
			StringTokenizer sst = new StringTokenizer(hmcPattern,"#");
			if (sst.hasMoreTokens())
			{
				sst.nextToken();
				sst.nextToken();
				sst.nextToken();
				isDiscovery = sst.nextToken();
			}

			String pattern = sslValue + "#" + hmcUserValue + "#" + hmcPasswordValue + "#" + isDiscovery + "#" + hmcServerValue;
			if (aListServicesIniEntries == null)
			{
				aListServicesIniEntries = new ArrayList();
			}
			aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"HMC",hmcServerValue,pattern));
		}

		// for RHEV discovery changes - starts
		if (aListTemp.contains("-Rhel_mgr_host"))
		{
			int rhevIdx = aListTemp.indexOf("-Rhel_mgr_host");
			String rhev_mgrValue = (String)aListTemp.get(rhevIdx+1);

			if (!rhev_mgrValue.equalsIgnoreCase("other") && !rhev_mgrValue.equalsIgnoreCase("none"))
			{
				IniFile eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");

				int rhevUserIdx = aListTemp.indexOf("-Rhel_mgr_user");
				String strRhevUserValue = (String)aListTemp.get(rhevUserIdx+1);

				int rhevPasswordIdx = aListTemp.indexOf("-Rhel_mgr_password");
				String strRhevPasswordValue = (String)aListTemp.get(rhevPasswordIdx+1);
				strRhevPasswordValue = EgCrypt.decrypt(strRhevPasswordValue);
				strRhevPasswordValue = EgCrypt.encrypt(strRhevPasswordValue);

				int rhevSSLIdx = aListTemp.indexOf("-ssl");
				String strSslValue = (String)aListTemp.get(rhevSSLIdx+1);

				int mgrPortIdx = aListTemp.indexOf("-Rhel_mgr_port");
				String mgrPort = (String)aListTemp.get(mgrPortIdx+1);

				int domainIdx = aListTemp.indexOf("-Rhel_mgr_domain");
				String domain = (String)aListTemp.get(domainIdx+1);

				String isDiscovery = "No";
				String rhevMgrPattern = eg_servicesIni.getValue("RHEV",rhev_mgrValue);
				StringTokenizer sst = new StringTokenizer(rhevMgrPattern,"#");
				if (sst.hasMoreTokens())
				{
					sst.nextToken();
					sst.nextToken();
					sst.nextToken();
					isDiscovery = sst.nextToken();
				}

				if (strSslValue != null)
				{
					if (strSslValue.equalsIgnoreCase("true"))
					{
						if (mgrPort != null)
						{
							if (mgrPort.equalsIgnoreCase("default"))
							{
								mgrPort = "8443";
							}
						}
						else
						{
							mgrPort = "8443";
						}
					}
					else
					{
						if (mgrPort != null)
						{
							if (mgrPort.equalsIgnoreCase("default"))
							{
								mgrPort = "8080";
							}
						}
						else
						{
							mgrPort = "8080";
						}
					}
				}

				String pattern = strSslValue + "#" + strRhevUserValue + "#" + strRhevPasswordValue + "#" + isDiscovery + "#" + mgrPort +"#"+ domain;
				if (aListServicesIniEntries == null)
				{
					aListServicesIniEntries = new ArrayList();
				}

				aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"RHEV",rhev_mgrValue,pattern));
			}
		}
		// for discovery changes - ends

		//for auditlog -starts
		if (isAuditLogEnabled)
		{
			auditLogThread.setValue("Description","Default parameters of test " + "$test$:" +testName + " have been configured for server " + "$ctype$:" + componentType);

			for (int i=0;i<aListDisplayParamNamesAndValues.size();i=i+2)
			{
				String eachParam = (String)aListDisplayParamNamesAndValues.get(i);
				String eachParamValue = (String)aListDisplayParamNamesAndValues.get(i+1);

				if (aListTempParamNamesAndValues.contains("-"+eachParam))
				{
					int tempIdx = aListTempParamNamesAndValues.indexOf("-"+eachParam);
					String strValue = (String)aListTempParamNamesAndValues.get(tempIdx+1);
					if (eachParamValue.equalsIgnoreCase("Yes") && strValue.equalsIgnoreCase("true")) continue;
					if (eachParamValue.equalsIgnoreCase("No") && strValue.equalsIgnoreCase("false")) continue;

					if (!eachParamValue.equals(strValue))
					{
						aListAuditCurrentSettingParams.add(eachParam);
						aListAuditCurrentSettingParams.add(eachParamValue);

						aListAuditPreviousSettingParams.add(eachParam);
						if (strValue.equalsIgnoreCase("true") || 
							strValue.equalsIgnoreCase("yes") || 
							strValue.equalsIgnoreCase("y")) 
						{
							strValue = "Yes";
						}
						else if (strValue.equalsIgnoreCase("false") || 
								strValue.equalsIgnoreCase("no") || 
								strValue.equalsIgnoreCase("n"))
						{
							strValue = "No";
						}
						aListAuditPreviousSettingParams.add(strValue);
					}
				}
			}

			for(int i=0;i<aListAuditPreviousSettingParams.size();i=i+2)
			{
				String temp1 = (String)aListAuditPreviousSettingParams.get(i);
				String temp2 = (String)aListAuditPreviousSettingParams.get(i+1);
				auditLogThread.setPreviousValue(temp1,temp2);

				temp1 = (String)aListAuditCurrentSettingParams.get(i);
				temp2 = (String)aListAuditCurrentSettingParams.get(i+1);
				auditLogThread.setCurrentValue(temp1,temp2);
			}

			auditLogThread.sendItToDB();
		}
		//for auditlog -ends

		//for eg_specs.ini - starts
		if (aListSpecsIniEntries != null)
		{
			IniFile eg_specsIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_specs.ini");
			for (int i=0;i<aListSpecsIniEntries.size();i++)
			{
				IniHelper iniHelper= (IniHelper)aListSpecsIniEntries.get(i);
				String iniAction = iniHelper.getAction();
				String sub = iniHelper.getSubject();
				String key = iniHelper.getVariable();
				String val = iniHelper.getValue();
				if (iniAction != null)
				{
					if (iniAction.equals(IniHelper.SET))
					{
						eg_specsIniSync.setValue(sub,key,val);
					}
				}
			}
			eg_specsIniSync.saveFile();
			EgConfigFilesSync.releaseInstance(eg_specsIniSync);
		}
		//for eg_specs.ini - ends

		//for eg_services.ini - starts
		if (aListServicesIniEntries != null)
		{
			IniFile eg_servicesIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
			for (int i=0;i<aListServicesIniEntries.size();i++)
			{
				IniHelper iniHelper= (IniHelper)aListServicesIniEntries.get(i);
				String iniAction = iniHelper.getAction();
				String sub = iniHelper.getSubject();
				String key = iniHelper.getVariable();
				String val = iniHelper.getValue();
				if (iniAction != null)
				{
					if (iniAction.equals(IniHelper.SET))
					{
						eg_servicesIniSync.setValue(sub,key,val);
					}
				}
			}
			eg_servicesIniSync.saveFile();
			EgConfigFilesSync.releaseInstance(eg_servicesIniSync);
		}
		//for eg_services.ini - ends

		servicer.startDiscovery("1");
		EgConfigFilesSync.releaseInstance(infraIni);
		//ends here

		//forward to result page - starts
		session.setAttribute("aListDisplayParamNamesAndValues",aListDisplayParamNamesAndValues);
		query = "EgConfigureDefaultParamResult.jsp?compType="+EgURLEncoder.encode(componentType,"UTF-8")+"&testName="+EgURLEncoder.encode(testName,"UTF-8");
%>
		<jsp:forward page="<%=query%>" />
<%
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
%>



