Ext.define('DefaultThreshold.view.DefaultThresholds', {
	extend: 'Ext.form.Panel',
	alias: 'widget.defaultthresholds',
	cls:'outerpanel',
	title: pageName,
	margin: '8 8 0 8',
	//frame: true,
	autoScroll: true,
	scroll: true,

	requires : [
		'utilities.ScrollCombo'
	],

	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDesc+'.</center>',
			}
		]
	}],

	items: [
		{
			xtype:'container',
			layout : {
				type : 'vbox',
				align : 'center',
				pack : 'center'
			},
			items:[
			{
				xtype: 'container',
				cls:'formOuter',
				layout: {
					type: 'hbox',
					pack: 'center'
				},
				margin: '15 10 10 10',
				padding:10,
				items: [
					{
						xtype: 'scrollcombo',
						id: 'compTypeCombo',
						fieldLabel: label1,
						labelAlign: 'top',
						labelSeparator: ' ',
						width: 250,
						store: new Ext.data.Store(
						{
							fields: ['displayField','valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						editable: false,
						queryMode: 'local'
					},
					{
						xtype: 'scrollcombo',
						id: 'testNameCombo',
						fieldLabel: label2,
						labelAlign: 'top',
						labelSeparator: ' ',
						width: 250,
						margin: '0 0 0 20',
						store: new Ext.data.Store(
						{
							fields: ['displayField','valueField','groupField'],
							data: []
						}),
						displayField: 'displayField',
						groupField: 'groupField',
						valueField: 'valueField',
						queryMode: 'local',
						editable: false,
						listConfig: {
							tpl: Ext.create('Ext.XTemplate',
								'<ul><tpl for=".">',
								'<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
								'<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
								'</tpl>',
								'<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 1">padding-left: 12px</tpl>">{displayField}</li>',
								'</tpl>' +
								'</ul>',
								{
									getGroupLabel: function (values) {
										return values.groupField
									}
								}
							)
						}
					}
				]
			}]
		},
		{
			xtype: 'container',
			id: 'resultContainer',
			margin:10,
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			items:[
				{
					xtype: 'container',
					id: 'hostTestMsgContainer',
					hidden: true,
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					items: [
						{
							xtype: 'label',
							id: 'hostMsgLabel',
							html: ''
						}
					]
				},
				{
					xtype: 'grid',
					cls:'gridSkin',
					id: 'measureGrid',
					margin: '10 0 10 0',
					title: titleGrid1,
					store:new Ext.data.Store(
					{
						fields: ['Measure','Threshold','AlarmPolicy','isToolTip'],
						data: []
					}),
					autoScroll: true,
					hideHeaders: true,
					columns: {
						defaults: {
							sortable: false,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: measureText,
								dataIndex: 'Measure',
								width: 245
							},
							{
								text: thresholdText,
								dataIndex: 'Threshold',
								width: 550,
								renderer :  function(value, metaData, record, row, col, store, gridView) {
									metaData.tdCls ="threshold_tdcls";
									//value = "Min|-|2|-#Max|99|90|80"
									var measures = value.split("#");
									var measuresLen = measures.length;
									var result = "";

									var toolTipMsg = record.data.isToolTip;
									var critMsg = '';
									var majorMsg = '';
									if (toolTipMsg)
									{
										critMsg = '<img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>';
										majorMsg = '<img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>';
									}
									else
									{
										critMsg = '';
										majorMsg = '';
									}

									if (measuresLen == 1)
									{
										var vals = measures[0].split("|");
										result = '<table border="0" cellspacing="0" cellpadding="0" class="font_normal11 threshold_table"><tr><td width="70" height="20" class="font_bold11 " valign="top">'+vals[0]+'</td><td width="160" height="20" valign="top">'+vals[1]+' '+critMsg+'</td><td width="160" height="20" valign="top">'+vals[2]+' '+majorMsg+'</td><td width="160" height="20" valign="top">'+vals[3]+'</td></tr></table>'
									}
									else
									{
										var val0 = measures[0].split("|");
										var val1 = measures[1].split("|");
										result = '<table border="0" style="width:550px;padding:0px;" cellspacing="0" cellpadding="0" class="font_normal11 threshold_table"><tr><td class="font_bold11" style="width:70px !important;padding:0px;" valign="top">'+val0[0]+'</td><td  height="20" style="width:160px !important;padding:0px;" valign="top">'+val0[1]+' '+critMsg+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val0[2]+' '+majorMsg+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val0[3]+'</td></tr><tr><td style="width:70px !important;padding:0px;" height="20" class="font_bold11" valign="top">'+val1[0]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val1[1]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val1[2]+'</td><td style="width:160px !important;padding:0px;" height="20" valign="top">'+val1[3]+'</td></tr></table>'
									}
									return result;
								}
							},
							{
								text: alarmPolText,
								dataIndex: 'AlarmPolicy',
								width: 114
							},
							{
								xtype: 'actioncolumn',
								//cls: 'tasks-icon-column-header tasks-edit-column-header',
								width: 36,
								//icon: '../../../../resources/images/edit_task.png',
								iconCls: 'iconModify',
								//tooltip: 'Modify',
								sortable: false,
								handler: function(view, rowIndex, colIndex, column, e) {
									me.handleEditIconClick(view, rowIndex, colIndex, column, e);
								},
								renderer: function(value, metaData, record, row, col, store, gridView)
								{
									metaData.tdAttr = "data-qtip='Modify' data-qclass='yellowTip'";
								}
							}
						]
					},
					hidden: true,
					dockedItems: [
						{
							xtype: 'toolbar',
							dock: 'top',
							height: 25,
							padding: 0,
							items: [
								{
									xtype: 'label',
									text: measureText,
									width: 245,
									height: 25,
									cls:'gridlabelheader'
								},
								{
									xtype: 'label',
									text: maxminText,
									width: 70,
									height: 25,
									cls:'gridlabelheader',
									margin: '0 0 0 -2'
								},
								{
									xtype: 'label',
									text: criticalText,
									width: 160,
									height: 25,
									cls:'gridlabelheader'
								},
								{
									xtype: 'label',
									text: majorText,
									width: 160,
									height: 25,
									cls:'gridlabelheader',
									margin: '0 0 0 -2'
								},
								{
									xtype: 'label',
									text: minorText,
									width: 160,
									height: 25,
									cls:'gridlabelheader'
								},
								{
									xtype: 'label',
									text: alarmPolText,
									width: 114,
									height: 25,
									cls:'gridlabelheader',
									margin: '0 0 0 -2'
								},
								{
									xtype: 'label',
									text: '',
									width: 36,
									cls:'gridlabelheader',
									height: 25
								}
							]
						}
					]
				},
				{
					xtype: 'grid',
					cls:'gridSkin cellmodel_single',
					id: 'noMeasureGrid',
					title: titleGrid2,
					store:new Ext.data.Store({
						fields: ['Measure1','Measure2','Measure3'],
						data: []
					}),
					width: 947,
					autoScroll: true,
					hideHeaders: true,
					hidden: true,
					selModel: {
						selType: 'cellmodel',
						mode: 'SINGLE'
					},
					columns: {
						defaults: {
							sortable: false,
							hideable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						items: [
							{
								text: '',
								dataIndex: 'Measure1',
								id:'measOne',
								flex: 1,
								renderer:function( val )
								{
									if (val != null || val != '')
										val = '<div style="cursor:pointer;">'+val+'</div>';
									return val;
								}
							},
							{
								text: '',
								dataIndex: 'Measure2',
								id: 'measTwo',
								flex: 1,
								renderer:function( val )
								{
									if (val != null || val != '')
										val = '<div style="cursor:pointer;">'+val+'</div>';
									return val;
								}
							},
							{
								text: '',
								dataIndex: 'Measure3',
								id: 'measThree',
								flex: 1,
								renderer:function( val )
								{
									if (val != null || val != '')
										val = '<div style="cursor:pointer;">'+val+'</div>';
									return val;
								}
							}
						]
					}
				}
			]
		}
	],

	tools: [
		{
			xtype : 'button',
			id: 'fromSpecificBackBtn',
			text : btnText1,
			iconCls:'iconBack',
			cls:'backbutton',
			hidden: true
		}
	]

});



