Ext.define('DeleteUsers.controller.Main',{
	extend:'Ext.app.Controller',
	views:['FormItems'],
	refs:[
		{selector:'FormItems', ref:'FormItems'},
	],
	init:function(){
		appCnt = this;
		this.control({
			'formitems':
			{
				'afterrender': this.afterMainRender
			},
			'formitems button[id="deleteusers"]':
			{
				'click': this.deleteUsers
			},
			'formitems combo[id="usertypes"]':
			{
				'select': this.changeUserCategory
			},
			'formitems button[id="selectAll"]':
			{
				'click':this.selectAllNodes
			}
		});
	},
	getSelectedNodeDetails: function()
	{
		selectedUsersCount=0;
		var selectedUsersArray = new Array();
		var tree = Ext.getCmp('userTreePanel');
		if(tree.getRootNode() != null && tree.getRootNode() != 'undefined')
		{
			for(var i=0;i<tree.getRootNode().childNodes.length ;i++ )
			{
				var nodeVal = tree.getRootNode().childNodes[i];
				if(nodeVal.data.checked)// check if root node is selected
				{
					selectedUsersCount++;
					selectedUsersArray.push(nodeVal.data.text);
					selectedUsersCount +=nodeVal.childNodes.length;
				}
				else 
				{
					var childNodes = nodeVal.childNodes;
					if(childNodes.length>0)
					{
						if(nodeVal.data.checked)
						{
							selectedUsersArray.push(nodeVal.data.text);
						}
						appCnt.getChildrenDetails(childNodes,selectedUsersArray);
					}
					else
					{
						if(nodeVal.data.checked)
						{
							selectedUsersArray.push(nodeVal.data.text);
						}
					}
				}
			}
		}
		return selectedUsersArray;
	},
	getChildrenDetails: function(obj,selectedUsersArray)
	{
		var val='';
		for(var i=0;i<obj.length;i++)
		{
			var nodeVal_inner = obj[i];
			if(nodeVal_inner.data.checked)
			{
				selectedUsersCount++;
				selectedUsersArray.push(nodeVal_inner.data.text);
				selectedUsersCount +=nodeVal_inner.childNodes.length;
			}
			else
			{
				var childNodesNew = nodeVal_inner.childNodes;
				if(childNodesNew.length==0)
				{
					if(val.indexOf(',')==-1)
					{
						val+=','+nodeVal_inner.data.text;
						if(nodeVal_inner.data.checked)
						{
							selectedUsersArray.push(nodeVal_inner.data.text);
						}
					}
					else
					{
						val+=','+nodeVal_inner.data.text;
						if(nodeVal_inner.data.checked)
						{
							selectedUsersArray.push(nodeVal_inner.data.text);
						}
					}
				}
				else
				{
					if(val.indexOf(',')==-1)
					{
						val=','+nodeVal_inner.data.text;
						if(nodeVal_inner.data.checked)
						{
							selectedUsersArray.push(nodeVal_inner.data.text);
						}
					}
					else
					{
						val+=','+nodeVal_inner.data.text;
						if(nodeVal_inner.data.checked)
						{
							selectedUsersArray.push(nodeVal_inner.data.text);
						}
					}
					val+=appCnt.getChildrenDetails(childNodesNew,selectedUsersArray);
				}
			}
		}
		return selectedUsersArray;
	},
	selectAllNodes: function(obj)
	{
		var tree = Ext.ComponentQuery.query( 'treepanel[id=userTreePanel]')[0];
		var button = Ext.getCmp('selectAll');
		var btnText = button.getText();
		if(btnText != null && btnText != 'undefined' && btnText == selectTxt)
		{
			tree.getRootNode().cascadeBy(function()
			{
				var tmp_value = this.data.text;
				if(tmp_value!='egenterprise')
				{
					if(publicJSON['editableNodes'].indexOf(tmp_value)>-1)
					{
						this.set( 'checked', true );
						button.setText(deSelectTxt);
					}
				}
			});
		}
		else
		{
			tree.getRootNode().cascadeBy(function()
			{
				var tmp_value = this.data.text;
				if(tmp_value!='egenterprise')
				{
					if(publicJSON['editableNodes'].indexOf(tmp_value)>-1)
					{
						this.set( 'checked', false );
						button.setText(selectTxt);
					}

				}
			});
		}
	},
	afterMainRender : function()
	{
		Ext.Ajax.request({
			url:'/final/admin/DeleteUsers/data/EgDeleteUserElementsJson.jsp?operation=renderer&categoryType=all',
			method: 'POST',
			success: function(response)
			{
				if(response.status == 200)
				{
					if(!Ext.isEmpty(response.responseText.trim()))
					{
						//Ext.getCmp('header_container').show();
						Ext.getCmp('delete_button_container').show();
						var jsonText = response.responseText;
						publicJSON = Ext.decode(jsonText);
						if(publicJSON.noUsersConfigured)
						{
							usersNotYetConfigured();
						}
						else
						{
							Ext.getCmp('single_listbox_container').show();
							var rootData = {
								text:'Enterprise Organizations',
								expanded: true,
								children:publicJSON['exportDataArr']
							};
							Ext.getCmp('userTreePanel').setRootNode(rootData);
							Ext.getCmp('selectAll').setText(selectTxt);
						}
					}
					else
					{
						usersNotYetConfigured();
					}
				}
			}
		});
	},
	deleteUsers : function()
	{
		var usernamesarray = this.getSelectedNodeDetails();
		if(usernamesarray.length==0)
		{
			Ext.MessageBox.show({
				title : pageTitle,
				msg : select_users+'.',
				width: select_users.length * 7,
				icon : 'iconInformation',
				buttons : Ext.Msg.OK
			});
		}
		else
		{
			var currentMsg = null;
			if(manager_model=='msp')
			{
				if(alert_type=='1')
				{
					currentMsg = confirmation_common1;
					if(selectedUsersCount>1)
					{
						currentMsg = confirmation_common2;
					}
				}
				else
				{
					currentMsg = confirmation_common3;
					if(selectedUsersCount>1)
					{
						currentMsg = confirmation_common4;
					}
				}
			}
			else
			{
				if(alert_type=='1')
				{
					currentMsg = confirmation_common1;
					if(selectedUsersCount>1)
					{
						currentMsg = confirmation_common2;
					}
				}
				else
				{
					currentMsg = confirmation_common3;
					if(selectedUsersCount>1)
					{
						currentMsg = confirmation_common4;
					}
				}
			}
			var categoryType = Ext.getCmp('usertypes').getValue();
			Ext.Msg.show(
			{
				title : pageTitle,
				msg : currentMsg,
				width: currentMsg.length * 7,
				icon : 'iconConfirmation',
				buttons : Ext.Msg.YESNO,
				fn : function(buttonText)
				{
					if(buttonText == "yes")
					{
						callDeleteUserCode(usernamesarray,categoryType);
					}
				}
			});
		}
	},
	changeUserCategory : function()
	{
		var selected_user_type = Ext.getCmp('usertypes').getValue();
		if(selected_user_type != currentSelection)
		{
			Ext.getCmp('imagemsg').hide();
			currentSelection=selected_user_type;
			Ext.Ajax.request({
				url:'/final/admin/DeleteUsers/data/EgDeleteUserElementsJson.jsp?operation=renderer&categoryType='+currentSelection,
				method: 'POST',
				success: function(response)
				{
					if(response.status == 200)
					{
						if(!Ext.isEmpty(response.responseText.trim()))
						{
							publicJSON = Ext.decode(response.responseText);
							if(publicJSON.orgUsersNotFound)
							{
								Ext.getCmp('delete_button_container').hide();
								Ext.getCmp('searchbox').setDisabled(true);
								Ext.getCmp('selectAll').setDisabled(true);
								Ext.getCmp('nodeExpand').setDisabled(true);
								Ext.getCmp('nodeCollapse').setDisabled(true);
								var rootData = {
									text:'Organizations',
									expanded: true,
									children:publicJSON['exportDataArr']
								};
								Ext.getCmp('userTreePanel').setRootNode(rootData);

								var elemNoData = Ext.getElementById('noDataFound');
								if (elemNoData == null || elemNoData === undefined)
								{
									Ext.DomHelper.append(Ext.get(Ext.getCmp('userTreePanel').getView().id), {
										tag: 'div',
										style:{'width':'100%','textAlign':'center','display': 'table'}, 
										cls: 'new-div-cls', 
										id: 'noDataFound',
										html:LoadAlert
									});
								}
								else
								{
									elemNoData.style.display = "table";
								}
							}
							else
							{
								Ext.getCmp('deleteusers').show();
								Ext.getCmp('searchbox').setDisabled(false);
								Ext.getCmp('selectAll').setDisabled(false);
								Ext.getCmp('nodeExpand').setDisabled(false);
								Ext.getCmp('nodeCollapse').setDisabled(false);
								Ext.getCmp('delete_button_container').show();
								Ext.getCmp('single_listbox_container').show();

								var rootData = {
									text:'Organizations',
									expanded: true,
									children:publicJSON['exportDataArr']
								};
								Ext.getCmp('userTreePanel').setRootNode(rootData);
								Ext.getCmp('selectAll').setText(selectTxt);
								var elemNoData = Ext.getElementById('noDataFound');
								if (elemNoData != null && elemNoData != undefined)
								{
									elemNoData.style.display = "none";
								}
							}
						}
						else // when user are not yet created into eG System
						{
							Ext.getCmp('deleteusers').hide();
							Ext.getCmp('searchbox').setDisabled(true);
							Ext.getCmp('selectAll').setDisabled(true);
							Ext.getCmp('nodeExpand').setDisabled(true);
							Ext.getCmp('nodeCollapse').setDisabled(true);
							Ext.getCmp('delete_button_container').hide();
							var rootData = {
								text:'Organizations',
								expanded: true,
								children:publicJSON['exportDataArr']
							};
							Ext.getCmp('userTreePanel').setRootNode(rootData);
							var elemNoData = Ext.getElementById('noDataFound');
							if (elemNoData == null || elemNoData === undefined)
							{
								Ext.DomHelper.append(Ext.get(Ext.getCmp('userTreePanel').getView().id), {
									tag: 'div',
									style:{'width':'100%','textAlign':'center','display': 'table'}, 
									cls: 'new-div-cls', 
									id: 'noDataFound',
									html:LoadAlert
								});
							}
							else
							{
								elemNoData.style.display = "table";
							}
						}
					}
				}
			});
		}
	}
});
function callDeleteUserCode(userStr,categoryType)
{
	var this_url = '/final/admin/DeleteUsers/data/Egdeleteuserp.jsp';
	var myMask = new Ext.LoadMask(Ext.getBody(), {msg: processingLabel});
	myMask.show();
	try
	{
		for (var a in userStr)
			userStr[a]= parent.filterEncode(userStr[a]);
	}
	catch (e)
	{
		userStr = parent.filterEncode(userStr);
	}

	Ext.Ajax.request({
		url:this_url,
		method: 'POST',
		params:{"uname":userStr},
		standardSubmit: false,
		timeout: 300000,
		success: function(response)
		{
			myMask.hide();
			if(response.status == 200)
			{
					Ext.Ajax.request({
					url:'/final/admin/DeleteUsers/data/EgDeleteUserElementsJson.jsp?operation=afterDelete&categoryType='+categoryType,
					method: 'POST',
					success: function(response)
					{
						if(response.status == 200)
						{
							Ext.MessageBox.show({
								title : pageTitle,
								msg : deletedMessage+'.',
								width: deletedMessage.length * 7,
								icon : 'iconInformation',
								buttons : Ext.Msg.OK
							});
							if(!Ext.isEmpty(response.responseText.trim()))
							{
								var jsonText = response.responseText;
								publicJSON = Ext.decode(jsonText);
								if(publicJSON.noUsersConfigured)
								{
									usersNotYetConfigured();
								}
								else if(publicJSON.orgUsersNotFound)
								{
									Ext.getCmp('single_listbox_container').hide();
									Ext.getCmp('imagemsg').show();
									Ext.getCmp('delete_button_container').hide();
								}
								else
								{
									Ext.getCmp('single_listbox_container').show();
									var rootData = {
										text:'Organizations',
										expanded: true,
										children:publicJSON['exportDataArr']
									};
									Ext.getCmp('userTreePanel').setRootNode(rootData);
									Ext.getCmp('selectAll').setText(deSelectTxt);
								}
							}
							else
							{
								usersNotYetConfigured();
							}
						}
					}
				});
			}
		},
		failure: function(response)
		{
			myMask.hide();
		}
	});
}
function usersNotYetConfigured()
{
	Ext.getCmp('no_user_container').show();
	//Ext.getCmp('header_container').hide();
	Ext.getCmp('single_listbox_container').hide();
	Ext.getCmp('delete_button_container').hide();
}
function egTitleSearch()
{
	//alert('search is on');
	var obj = Ext.getCmp("userTreePanel");
	var egTitleSearchStr = Ext.getCmp('searchbox').getValue();
	var firstId = 'MyTrigger_searchbox_0';
	var secondId = 'MyTrigger_searchbox_1';

	if (egTitleSearchStr == "" || egTitleSearchStr .length == 0)
	{
		Ext.get(firstId).setStyle('display','none');
		Ext.get(secondId).setStyle('display','block');
	}
	else
	{
		Ext.get(secondId).setStyle('display','none');
		Ext.get(firstId).setStyle('display','block');
	}
	if(egTitleSearchStr==null || egTitleSearchStr=="")
	{
		Ext.getCmp('userTreePanel').filterBy(egTitleSearchStr, 'text');
		//No data found message removal
		var elemNoData = Ext.getElementById('noDataFound');
		if (elemNoData)
		{
			Ext.getCmp('delete_button_container').show();
			elemNoData.style.display = "none";
		}
	}
	else
	{
		Ext.getCmp('userTreePanel').filterBy(egTitleSearchStr, 'text');
	}
}
