
var isIE11 = window.location.hash = !!window.MSInputMethodContext;

Ext.define('DeleteUsers.view.FormItems', {
	extend:'Ext.form.Panel',
	alias: 'widget.formitems',
	title: homeTitle,
	id : 'userdeleteformid',
	margin: '8 8 0 8',

	ui:'simplePanel simplePanelHeaderBorder',

	requires: [
		'Ext.ux.form.MultiSelectSI',
		'Ext.ux.TreePicker',
		'utilities.ScrollCombo'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
			},
			id: 'no_user_container',
			hidden: true,
			margin: 15,
			padding:'175 0 0 0',
			items: [
				{
					xtype: 'label',
					html: '<table align="center"><tr><td align="center" height="100"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+no_users_conf+'.</td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			flex: 1,
			margin: 5,
			hidden:true,
			hidden: true,
			margin: '10 0 5 0',
			id: 'imagemsg',
			flex: 1,
			items: [
				{
					xtype: 'label',
					html: '<table><tr><td align="center" height="350"><table><tr><td align="center"><img src="/final/admin/eg_images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+no_users_found_category+'</td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			flex: 1,
			margin: '5 10 5 10',
			hidden:true,
			id:'single_listbox_container',
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'center',
						align: 'stretch'
					},
					margin: '10 0 5 0',
					flex: 1,
					items: [
						{
							xtype: 'treepanel',
							cls: 'gridSkin treePanelDesign_chk',
							//cls:'gridSkin',
							id: 'userTreePanel',
							//width: 500,
							flex: 1,
							frame: false,
							listeners:{
								afterrender : function()
								{
									//Ext.getCmp('userTreePanel').addCls("x-autowidth-table");
									Ext.getCmp('userTreePanel').addCls("gridSkin");
								},
								checkchange: function(node, checked, options)
								{
									var childrenChecked = function (current)
									{
										if(current.parentNode)
										{
											var parent = current.parentNode;
											current.set('checked', parent.get('checked'));
										}
										if (current.hasChildNodes())
										{
											current.eachChild(arguments.callee);
										}
									};
									if(node.hasChildNodes())
									{
										node.eachChild(childrenChecked);
									}
									var updateParent = function (current)
									{
										if(current.parentNode)
										{
											if(current.parentNode.data.text!='egenterprise')
											{
												if(publicJSON['editableNodes'].indexOf(current.parentNode.data.text)>-1)
												{
													var parent = current.parentNode;
													parent.set('checked', false);
													updateParent(current.parentNode);//this is newly added to uncheck all parent and fore parent nodes of current node
												}
											}
										}
									}
									updateParent(node);
								}
							},
							viewConfig:{
								animate:Ext.isIE ? false :true,
								listeners:{
									afteritemcollapse:function( node, index, item, eOpts ){
										if(Ext.isIE == true || isIE11 == true){
											Ext.fly(item).removeCls('x-grid-tree-node-expanded');
										}
									},
									afteritemexpand:function( node, index, item, eOpts ){
										if(Ext.isIE == true || isIE11 == true){
											Ext.fly(item).addCls('x-grid-tree-node-expanded');
										}
									}
								}
							},
							autoShow: true,
							autoScroll: true,
							//store: Ext.create('Ext.data.TreeStore', {}),
							store: Ext.create('Ext.data.TreeStore', {
								fields: [{name: 'text', sortType:Ext.data.SortTypes.asUCString},
										{name: 'role', sortType:Ext.data.SortTypes.asUCString}],
								sorters: [{
									property: 'text',
									direction: 'ASC'
								}]
							}),
							rootVisible: false,
							columns: [
								{
									xtype: 'treecolumn',
									dataIndex: 'text',
									flex: 1,
									header: 'User Name'
								},
								{
									dataIndex: 'role',
									flex: 1,
									header: 'Role'
								}
							],
							dockedItems:[
								{
									xtype: 'toolbar',
									padding: 5,
									dock: 'top',
									items: [
										{
											xtype:'scrollcombo',
											cls:'dropdown',
											name: 'usertypes',
											id: 'usertypes',
											displayField:'displayField',
											valueField:'valueField',
											queryMode:'local',
											width: 180,
											parent:this,
											fields : ['displayField', 'valueField'],
											store: [
												['all',allUsersLabel],
												['live',liveUsersLabel],
												['expired',expiredUsersLabel]
											],
											value: 'all',
											editable: false
										},
										{
											xtype: 'tbfill' 
										},
										{
											xtype: 'trigger',
											name:'searchbox',
											id:'searchbox',
											trigger1Cls: 'x-form-clear-trigger',
											trigger2Cls: 'x-form-search-trigger', 
											cls: 'whitedropdown_search',
											emptyText: searchLbl,
											onTrigger1Click: function() {
												this.reset();
											},
											onTrigger2Click: function() {
												egTitleSearch();
											},
											listeners :
											{
												change : function(field, newVal)
												{
													egTitleSearch();
												},
												specialkey: function(field, e){
													// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
													// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
													if (e.getKey() == e.ENTER) {
														egTitleSearch();
													}
												}
											},
											getTriggerMarkup: function() {
												var me = this,
												i = 0,
												hideTrigger = (me.readOnly || me.hideTrigger),
												triggerCls,
												triggerBaseCls = me.triggerBaseCls,
												triggerConfigs = [],
												unselectableCls = Ext.dom.Element.unselectableCls,
												style = 'width:' + me.triggerWidth-20 + 'px;' + (hideTrigger ? 'display:none;' : ''),
												cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
												// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
												// single triggerCls config. Should rethink this, perhaps something more structured like a list of
												// trigger config objects that hold cls, handler, etc.
												// triggerCls is a synonym for trigger1Cls, so copy it.
												if (!me.trigger1Cls) {
													me.trigger1Cls = me.triggerCls;
												}
												// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
												for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
													if (i == 0)
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+me.id+'_'+i,
															style: style + "display:none;",
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
													else
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+me.id+'_'+i,
															style: style,
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
												}
												triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
												return Ext.DomHelper.markup(triggerConfigs);
											},
											disabled: false
										},
										{
											xtype: 'button',
											cls: 'button20 x-btn-default-small',
											id: 'selectAll',
											text: selectTxt,
											margin: '0 3 0 5',
											width: 80
										},
										{
											xtype: 'button',
											id : 'nodeExpand',
											iconCls: 'iconExpandAll',
											hidden:true,
											tooltip: 'Expand all',
											style: {
												background: 'none',
												border: '0px'
											},
											listeners: {
												'click':function(obj){
													this.hide();
													Ext.getCmp('nodeCollapse').show();
													Ext.getCmp('userTreePanel').expandAll();
												}
											}
										},
										{
											xtype:'button',
											id :'nodeCollapse',
											iconCls: 'iconCollapseAll',
											hidden:false,
											tooltip: 'Collapse all',
											style: {
												background: 'none',
												border: '0px'
											},
											listeners:{
												'click':function(obj){
													this.hide();
													Ext.getCmp('nodeExpand').show();
													Ext.getCmp('userTreePanel').collapseAll();
												}
											}
										}
									]
								}
							],
							clearFilter: function() {
								var view = this.getView();
								if (this.getRootNode())
								{
									this.getRootNode().cascadeBy(function(tree, view){
										var uiNode = view.getNodeByRecord(this);

										if(uiNode) {
											Ext.get(uiNode).setDisplayed('table-row');
										}
									}, null, [this, view]);

									//No data found message removal
									var elemNoData = Ext.getElementById('noDataFound');
									if (elemNoData)
									{
										elemNoData.style.display = "none";
										Ext.getCmp('delete_button_container').show();
									}
								}
							},
							filterBy: function(text, by) {
								this.clearFilter();

								var view = this.getView(),
									me = this,
									nodesAndParents = [];

								// Find the nodes which match the search term, expand them.
								// Then add them and their parents to nodesAndParents.
								if (this.getRootNode())
								{
									this.getRootNode().cascadeBy(function(tree, view){
										var currNode = this;
										if(currNode && currNode.data[by] && currNode.data[by].toString().toLowerCase().indexOf(text.toLowerCase()) > -1) {
											me.expandPath(currNode.getPath());

											while(currNode.parentNode) {
												nodesAndParents.push(currNode.id);
												currNode = currNode.parentNode;
											}
										}
									}, null, [me, view]);

									// Hide all of the nodes which aren't in nodesAndParents
									this.getRootNode().cascadeBy(function(tree, view){
										var uiNode = view.getNodeByRecord(this);
										if(uiNode && !Ext.Array.contains(nodesAndParents, this.id) && this.data.id != -1) {
											Ext.get(uiNode).setDisplayed('none');
										}
										
									}, null, [me, view]);

									//No data found message show
									if(Ext.isEmpty(nodesAndParents))
									{
										var elemNoData = Ext.getElementById('noDataFound');
										if (elemNoData == null || elemNoData === undefined)
										{
											Ext.DomHelper.append(Ext.get(view.id), {
												tag: 'div',
												style:{'height':'100%','width':'100%','textAlign':'center','display': 'table'}, 
												cls: 'new-div-cls', 
												id: 'noDataFound',
												html:LoadSearchAlert
											});
											Ext.getCmp('delete_button_container').hide();
										}
										else
										{
											elemNoData.style.display = "table";
											Ext.getCmp('delete_button_container').hide();
										}
									}
								}
							}
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '5 0 10 0',
			hidden:true,
			id:'delete_button_container',
			items: [
				{
					xtype: 'button',
					text: deletebutton,
					id: 'deleteusers',
					cls: "button20"
				}
			]
		}
	],

	listeners: {
		close: function()
		{
			window.location.href = '/final/admin/EgAdminOperations.jsp?fromAction='+fromWizard;
		},
		boxready: function()
		{
			new Ext.ToolTip({
				target: document.getElementById('homeTitle'),
				anchor: 'top',
				anchorOffset:42,
				mouseOffset: [-55, 0],
				html: pageDescc,
				cls: "adminInfoTooltip"
			});
		}
	}

});



