Ext.define('DescriptorPatternThreshold.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'configurethresholds', ref:'configurethresholds'},
		{selector:'thresholdpatterns', ref:'thresholdpatterns'},
		{selector:'createdescriptorpattern', ref:'createdescriptorpattern'},
	],
	init:function(){
		me = this,
		this.control({
			'configurethresholds button[id="updateBtn"]':
			{
				'click': this.applyThresholdsData
			},
			'configurethresholds button[id="configureBackBtn"]':
			{
				'click': this.configureThresholdsPageBack,
			},
			'configurethresholds slider[id="relMinCritical"]':
			{
				'drag': this.minRelCriticalSlider,
				'change': this.minRelCriticalSlider,
			},
			'configurethresholds slider[id="relMinMajor"]':
			{
				'drag': this.minRelMajorSlider,
				'change': this.minRelMajorSlider,
			},
			'configurethresholds slider[id="relMinMinor"]':
			{
				'drag': this.minRelMinorSlider,
				'change': this.minRelMinorSlider,
			},
			'configurethresholds slider[id="relMaxCritical"]':
			{
				'drag': this.maxRelCriticalSlider,
				'change': this.maxRelCriticalSlider,
			},
			'configurethresholds slider[id="relMaxMajor"]':
			{
				'drag': this.maxRelMajorSlider,
				'change': this.maxRelMajorSlider,
			},
			'configurethresholds slider[id="relMaxMinor"]':
			{
				'drag': this.maxRelMinorSlider,
				'change': this.maxRelMinorSlider,
			},
			'configurethresholds':
			{
				'afterrender': this.configureMainRender,
			},
			'configurethresholds checkbox[id="minStaticCheck"]':
			{
				'change': this.minStaticCheckChange,
			},
			'configurethresholds checkbox[id="minAutoCheck"]':
			{
				'change': this.minAutoCheckChange,
			},
			'configurethresholds checkbox[id="maxStaticCheck"]':
			{
				'change': this.maxStaticCheckChange,
			},
			'configurethresholds checkbox[id="maxAutoCheck"]':
			{
				'change': this.maxAutoCheckChange,
			},
			'configurethresholds combo[id="alarmPolicyCombo"]':
			{
				'select': this.alarmPolicyChange,
			},
			'thresholdpatterns':
			{
				'afterrender': this.afterThreshPatternMainRender
			},
			'thresholdpatterns trigger[id="searchRuleTrigger"]':
			{
				'change': this.thresholdPatternSearchEvent
			},
			'thresholdpatterns button[id="createNewRuleBtn"]':
			{
				'click': this.addNewPatternEvent
			},
			'createdescriptorpattern':
			{
				'afterrender': this.afterThreshPatternCreateRender
			},
			'createdescriptorpattern [id="noMeasureGrid"]':
			{
				'cellclick': this.noThreshMeasureModify,
			},
			'createdescriptorpattern button[id="newPatternPageBackBtn"]':
			{
				'click': this.newPatternPageBackEvent
			},
			'createdescriptorpattern combo[id="compTypeCombo"]':
			{
				'select': this.compTypeChangeEvent
			},
			'createdescriptorpattern combo[id="testNameCombo"]':
			{
				'select': this.testNameChangeEvent
			},
			'createdescriptorpattern button[id="addNewPatternBtn"]':
			{
				'click': this.createNewPatternEvent
			},
		});
	},
	thresholdPatternSearchEvent: function(obj)
	{
		var findVal = obj.getValue();
		if (findVal == "" || findVal.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		var compStore = componentRawData;//publicJson['grpDataGridArr'];

		var compObj = Ext.getCmp('descPatternsGrid');
		if ( Ext.isEmpty( obj.getValue() ) )
		{
			Ext.suspendLayouts();
			compObj.getStore().removeAll(); 
			compObj.getStore().loadRawData(compStore);
			Ext.resumeLayouts(true);
		}
		else
		{
			var isRecordFound = false;
			var genStore = new Ext.data.Store({
									fields : ['TestName','DescPatterns','modifyUrl','deleteUrl'],
									data : [] ,
									groupField: 'TestName'
								});
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getTestName = compStore[i]['TestName'];
				var getDescPattern = compStore[i]['DescPatterns'];
				if (( getTestName.toLowerCase().indexOf(findVal.toLowerCase()) > -1 ) || ( getDescPattern.toLowerCase().indexOf(findVal.toLowerCase()) > -1 ))
				//if (( getDescPattern.toLowerCase().indexOf(findVal.toLowerCase()) > -1 ))
				{
					isRecordFound = true;
					genStore.add({
						'TestName': compStore[i]['TestName'],
						'DescPatterns': compStore[i]['DescPatterns'],
						'modifyUrl': compStore[i]['modifyUrl'],
						'deleteUrl': compStore[i]['deleteUrl']
					});
				}
			}
			if ( isRecordFound )
			{
				Ext.suspendLayouts();
				compObj.getStore().removeAll();  
				compObj.getStore().loadRecords(genStore.getRange(0,genStore.getCount()),{addRecords: false});
				// compObj.reconfigure(genStore);
				//for ( var i = 0; i < genStore.getCount() ; i++ )
				//{
					//var getRecord = genStore.getAt(i);
					//compObj.getStore().add(getRecord);
				//}
				Ext.resumeLayouts(true);
			}
			else
			{
				compObj.getStore().removeAll();
				var htmlPreDefData = "<table align='center'><tr><td align='center' height='400'><table><tr><td align='center'><img src='/final/images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+noRuleSearchText+".</td></tr></table></td></tr></table>";

				compObj.store.loadData('');
				compObj.getView().emptyText = htmlPreDefData;
				compObj.getView().refresh();
			}
			obj.focus();
		}
	},
	handleThreshRuleDeleteIconClick: function(grid, rowIndex, colIndex){
		var GridValues = Ext.getCmp('descPatternsGrid').getStore().getAt(rowIndex);

		var pattName = GridValues.get('DescPatterns');
		var deleteUrl = GridValues.get('deleteUrl');
		Ext.Msg.show({
			title: pageName,
			msg: patternDelMsg+" '"+pattName+"'?", 
			icon: 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			fn: function(response) {
				if (response == "yes") 
				{
					Ext.Ajax.request({
						url: deleteUrl,
						method: 'POST',
						scope: this,
						timeout: 6000000,
						success: function( response )
						{
							if (response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								var jsonText = Ext.decode(response.responseText);
								if (jsonText.successUpdate)
								{
									Ext.Msg.show({
										title: pageName,
										msg: delAlertMsg,
										icon: 'iconInformation',
										buttons: Ext.Msg.OK,
										fn: function() { 
											me.afterThreshPatternMainRender();
										}
									});
								}
							}
						}
					});
				}
			}
		});
	},
	handleThreshPatternEditIconClick: function(grid, rowIndex, colIndex){
		var rec = Ext.getCmp('descPatternsGrid').getStore().getAt(rowIndex);
		var testName = rec.get('TestName');
		var pattName = rec.get('DescPatterns');
		modifyThreshRuleUrl = rec.get('modifyUrl');
		isModifyRule = 'true';
		strTestName = testName;
		strPattName = pattName;
		var homepage = Ext.getCmp('viewPortId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'createdescriptorpattern' });
		myMask.hide();
	},
	createNewPatternEvent: function()
	{
		var allowUpdate = true;
		var patternName = Ext.getCmp('pattNameText').getValue();
		//var regExp = /[@#&,~^$()+%=<>;?\"\'\]\|\}\[\{]/;
		var regExp = /[&,~^$%=<>;?\"\'\|]/;
		var patCheck = regExp.test(patternName)||(patternName.indexOf('\\')>=0);
		var testName = Ext.getCmp('testNameCombo').getValue(); //thisForm.testName.options[thisForm.testName.selectedIndex].value;

		if(Ext.isEmpty(patternName) || patternName == 'null' || patternName == 'undefined')
		{
			Ext.Msg.show({
				title: pageName,
				msg: pattErrMsg1,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('pattNameText').focus();
			return;
		}
		//if (patternName.indexOf(" ") > -1)
		//{
			//Ext.Msg.show({
				//title: pageName,
				//msg: noSpaceMsg,
				//buttons: Ext.MessageBox.OK,
				//icon: 'iconExclamation'
			 //});
			//Ext.getCmp('pattNameText').focus();
			//allowUpdate = false;
			//return;
		//}else 
		if(patternName.indexOf('*') != -1 && !checkStars(patternName))
		{
			Ext.getCmp('pattNameText').focus();
			allowUpdate = false;
			return;
		}
		else if(patCheck)
		{
			Ext.Msg.show({
				title: pageName,
				msg: specialCharMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('pattNameText').focus();
			allowUpdate = false;
			return;
		}
		else if (!Ext.isEmpty(patternName) && patternName.indexOf('*') != -1  && patternName.length < 2)
		{
			Ext.Msg.show({ 
				title: pageName,
				msg: pattErrMsg2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			allowUpdate = false;
			Ext.getCmp('pattNameText').focus();
			return false;
		}

		var pattNamesJson = publicJson['patternNames'];
		if(pattNamesJson != null && pattNamesJson != "" && !Ext.isEmpty(pattNamesJson))
		{
			//var hasContainPattern = false;
			//var containsPattName = '';
			var policyNames = pattNamesJson.split(',');
			for(var x=0;x<policyNames.length;x++)
			{
				//if (patternName.indexOf('*') == 0 )
				//{
					//if (policyNames[x].toLowerCase() == testName.toLowerCase()+':'+patternName.toLowerCase()+'*')
					//{
						//containsPattName = patternName.toLowerCase()+'*';
						//hasContainPattern = true;
					//}
				//}
				//else if (patternName.indexOf('*') == patternName.length - 1)
				//{
					//if (policyNames[x].toLowerCase() == testName.toLowerCase()+':*'+patternName.toLowerCase())
					//{
						//containsPattName = '*'+patternName.toLowerCase();
						//hasContainPattern = true;
					//}
				//}

				if(policyNames[x].toLowerCase() == testName.toLowerCase()+':'+patternName.toLowerCase())
				{
					Ext.Msg.show({
						title: pageName,
						msg: existPattNameAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					Ext.getCmp('pattNameText').focus();
					return;
				}
			}
			
			//if (hasContainPattern)
			//{
				//Ext.Msg.show({
					//title: pageName,
					//msg: 'pattern already exist '+containsPattName,
					//buttons: Ext.MessageBox.OK,
					//icon: 'iconExclamation',
					//fn: function() {
						//Ext.getCmp('pattNameText').focus();
					//}
				 //});
				//return;
			//}
		}

		var myRuleMask = new Ext.LoadMask(Ext.getBody(), {msg:"Loading..."});
		myRuleMask.show();
		if (allowUpdate)
		{
			var myPatternMask = new Ext.LoadMask(Ext.getBody(), {msg:"Loading..."});
			myPatternMask.show();

			Ext.Ajax.request({
				url: 'DescriptorPatternThreshold/data/EgDefinePatternJson.jsp?from=update&operation=updatepattern&testName='+encodeURIComponent(testName)+'&pattName='+encodeURIComponent(patternName),
				method: 'POST',
				scope: this,
				timeout: 60000000,
				success: function(response) {
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						myPatternMask.hide();
						var jsonText = Ext.decode(response.responseText);
						var successUpdate = jsonText['successUpdate'];
						if(successUpdate)
						{
							Ext.Msg.show ({
								title: pageName,
								msg: patternSuccessMsg1,
								buttons: Ext.MessageBox.OK,
								icon: 'iconInformation',
								fn: function()
								{
									strPattName = '';
									isFromDelete = 'false';
									var homepage = Ext.getCmp('viewPortId');
									var myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
									homepage.removeAll();
									myMask.show();
									homepage.add({ xtype : 'thresholdpatterns' });
									myMask.hide();
								}
							});
						}
					}
				},
				failure: function(response) { 
					Ext.Msg.show ({
						title: pageName,
						msg: 'Updating error from server side',
						buttons: Ext.MessageBox.OK,
						icon: 'iconInformation',
						fn: function()
						{
							strPattName = '';
							isFromDelete = 'false';
						}
					});
				}
			});
		}
	},
	createNewPatternEvent1: function()
	{
		var testName = Ext.getCmp('testNameCombo').getValue(); //thisForm.testName.options[thisForm.testName.selectedIndex].value;
		var patternName = Ext.getCmp('pattNameText').getValue(); //thisForm.ThresholdPolicy.value;
		//var regExp = /[@#&,~^$()+%=<>;?\"\'\]\|\}\[\{]/;
		var regExp = /[&,~^$%=<>;?\"\'\|]/;
		var patCheck = regExp.test(patternName)||(patternName.indexOf('\\')>=0);
		var policyNames = new Array();
		if(patternName == '' || patternName == 'null' || patternName == 'undefined')
		{
			Ext.Msg.show({
				title: pageName,
				msg: pattErrMsg1,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('pattNameText').focus();
			return;
		}
		//if (patternName.indexOf(" ") > -1)
		//{
			//Ext.Msg.show({
				//title: pageName,
				//msg: noSpaceMsg,
				//buttons: Ext.MessageBox.OK,
				//icon: 'iconExclamation'
			 //});
			//Ext.getCmp('pattNameText').focus();
			//return;
		//}
		//else 
		if( patternName.indexOf('*') != -1  && !checkStars(patternName))
		{
			Ext.getCmp('pattNameText').focus();
			allowUpdate = false;
			return;
		}
		else if(patCheck)
		{
			Ext.Msg.show({
				title: pageName,
				msg: specialCharMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('pattNameText').focus();
			return;
		}
		else if (!Ext.isEmpty(patternName) && patternName.indexOf('*') != -1  && patternName.length < 2)
		{
			Ext.Msg.show({ 
				title: pageName,
				msg: pattErrMsg2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			allowUpdate = false;
			Ext.getCmp('pattNameText').focus();
			return false;
		}

		patternNamesJson = publicJson['patternNames'];
		if(patternNamesJson != null && patternNamesJson != "" && !Ext.isEmpty(patternNamesJson))
		{
			var patternNames = patternNamesJson.split(',');
			for(var x=0;x<patternNames.length;x++)
			{
				if(patternNames[x] == patternName)
				{
					Ext.Msg.show({
						title: pageName,
						msg: existRuleNameAlertMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					Ext.getCmp('pattNameText').focus();
					return;
				}
			}
		}

		var params = "testName="+testName+"&pattName="+patternName+"&operation=newpattern";
		Ext.Ajax.request({
			url:'DescriptorPatternThreshold/data/EgDefinePatternJson.jsp?from=update&'+params,
			method: 'POST',
			scope: this,
			timeout: 6000000,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = Ext.decode(response.responseText);
					var successUpdate = jsonText['successUpdate'];
					if(successUpdate)
					{
						hiddenFieldsVal = this.getHiddenFieldsForMeasure(actualMeasName);
						var homepage = Ext.getCmp('viewPortId');
						homepage.removeAll();
						homepage.add({ xtype : 'configurethresholds' });
					}
				}
			}
		});
	},
	testNameChangeEvent: function()
	{
		Ext.getCmp('displayContainer').hide();
		//EgGroupThreshPolicies.jsp?from=addPolicy&compType=Citrix_server&testName=CtxLicenseStatsTest&comeFrom=admin
		var ruleCompType = Ext.getCmp('compTypeCombo').getValue();
		var ruleTestName = Ext.getCmp('testNameCombo').getValue();

		if (ruleTestName != null && !Ext.isEmpty(ruleTestName) )
		{
			if (ruleTestName == '-1')
			{
				ruleTestName = '';
			}
			strTestName = ruleTestName;
			Ext.Ajax.request({
				url:'DescriptorPatternThreshold/data/EgDefinePatternJson.jsp?from=first&compType='+ruleCompType+'&testName='+ruleTestName,
				method:'POST',
				scope:this,
				//async: false,
				timeout: 6000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						publicJson = Ext.decode(response.responseText);
						strCompType = publicJson['selectedCType'];
						strTestName = publicJson['selectedTestName'];
						var isTextBox = publicJson['text_box'];
						var measureValArr = publicJson['measureValArr'];
						var noMeasureValArr = publicJson['noMeasureValArr'];
						var displayTestName = publicJson['displayTestName'];
						var displayPolicyName = publicJson['displayPolicyName'];
						if (isTextBox)
						{
							Ext.getCmp('pattNameText').show();
							Ext.getCmp('addBtnContainer').show();
						}
						else
						{
							Ext.getCmp('pattNameText').hide();
							Ext.getCmp('addBtnContainer').hide();
						}
						if (!Ext.isEmpty(measureValArr) && measureValArr != 'undefined')
						{
							Ext.getCmp('measureGrid').show();
							Ext.getCmp('measureGrid').getStore().removeAll();
							Ext.getCmp('measureGrid').getStore().loadRawData(measureValArr);
						}else
						{
							Ext.getCmp('measureGrid').hide();
						}
						if (!Ext.isEmpty(noMeasureValArr) && noMeasureValArr != 'undefined')
						{
							Ext.getCmp('noMeasureGrid').show();
							Ext.getCmp('noMeasureGrid').getStore().removeAll();
							Ext.getCmp('noMeasureGrid').getStore().loadRawData(noMeasureValArr);
						}else
						{
							Ext.getCmp('noMeasureGrid').hide();
						}
					}
				}
			});
		}
	},
	compTypeChangeEvent: function()
	{
		patternCompType = Ext.getCmp('compTypeCombo').getValue();
		
		if (patternCompType != null && !Ext.isEmpty(patternCompType) )
		{
			if (patternCompType == '-1')
			{
				patternCompType = '';
			}
			strCompType = patternCompType;
			var tmpTest = '';
			if (!Ext.isEmpty(strTestName) && strTestName != 'undefined')
			{
				tmpTest = strTestName;
			}
			else
			{
				tmpTest = '';
			}

			Ext.Ajax.request({
				url:'DescriptorPatternThreshold/data/EgDefinePatternJson.jsp?from=first&testName='+tmpTest+'&comeFrom=admin&compType='+patternCompType,
				method:'POST',
				scope:this,
				//async: false,
				timeout: 6000000,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						publicJson = Ext.decode(response.responseText);
						var isManagedCompAvailable = publicJson['isManagedCompAvailable'];
						strCompType = publicJson['selectedCType'];
						strTestName = publicJson['selectedTestName'];
						var action = publicJson['hiddenObj']['action'];
						//if((action == null || Ext.isEmpty(action) || action == 'undefined') && (action != 'modify' && action != 'view'))
						{
							var grpTestNameArr = publicJson['grpTestNameArr'];
							Ext.getCmp('testNameCombo').getStore().removeAll();
							Ext.getCmp('testNameCombo').getStore().clearFilter(true);
							Ext.getCmp('testNameCombo').getStore().loadRawData(grpTestNameArr);
							if (!Ext.isEmpty(strTestName))
							{
								Ext.getCmp('testNameCombo').setValue(strTestName);
							}
							else
							{
								Ext.getCmp('testNameCombo').setValue(grpTestNameArr[0].valueField);
							}
							Ext.getCmp('testNameCombo').fireEvent('select', Ext.getCmp('testNameCombo'));
						}
					}
				}
			});
		}
	},
	noThreshMeasureModify: function( grid, td, cellIndex, record, tr, rowIndex, e, eOpts )
	{
		var pos = grid.getSelectionModel().getCurrentPosition();
		record = grid.store.getAt(pos.row);
		colname = grid.getHeaderCt().getHeaderAtIndex(cellIndex).dataIndex;
		cellvalue = record.data[colname];
		actualMeasName = publicJson['measureDataObj'][cellvalue];
		if (actualMeasName != null && actualMeasName != 'undefined' && actualMeasName != '')
		{
			var entryVal = publicJson['hiddenObj']['action'];
			if(entryVal != null && entryVal == "first")
			{
				var testName = Ext.getCmp('testNameCombo').getValue(); //thisForm.testName.options[thisForm.testName.selectedIndex].value;
				var patternName = Ext.getCmp('pattNameText').getValue(); //thisForm.ThresholdPolicy.value;
				//var regExp = /[@#&,~^$()+%=<>;?\"\'\]\|\}\[\{]/;
				var regExp = /[&,~^$%=<>;?\"\'\|]/;

				var patCheck = regExp.test(patternName)||(patternName.indexOf('\\')>=0);
				var policyNames = new Array();
				if(patternName == '' || patternName == 'null' || patternName == 'undefined')
				{
					Ext.Msg.show({
						title: pageName,
						msg: pattErrMsg1,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					Ext.getCmp('pattNameText').focus();
					return;
				}

				//if (patternName.indexOf(" ") > -1)
				//{
					//Ext.Msg.show({
						//title: pageName,
						//msg: noSpaceMsg,
						//buttons: Ext.MessageBox.OK,
						//icon: 'iconExclamation'
					 //});
					//Ext.getCmp('pattNameText').focus();
					//return;
				//}
				//else 
				if( patternName.indexOf('*') != -1  && !checkStars(patternName))
				{
					Ext.getCmp('pattNameText').focus();
					allowUpdate = false;
					return;
				}
				else if(patCheck)
				{
					Ext.Msg.show({
						title: pageName,
						msg: specialCharMsg,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation'
					 });
					Ext.getCmp('pattNameText').focus();
					return;
				}
				else if (!Ext.isEmpty(patternName) && patternName.indexOf('*') != -1  && patternName.length < 2)
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: pattErrMsg2,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					allowUpdate = false;
					Ext.getCmp('pattNameText').focus();
					return false;
				}

				patternNamesJson = publicJson['patternNames'];
				if(patternNamesJson != null && patternNamesJson != "" && !Ext.isEmpty(patternNamesJson))
				{
					var patternNames = patternNamesJson.split(',');
					for(var x=0;x<patternNames.length;x++)
					{
						if(patternNames[x] == patternName)
						{
							Ext.Msg.show({
								title: pageName,
								msg: existRuleNameAlertMsg,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation'
							 });
							Ext.getCmp('pattNameText').focus();
							return;
						}
					}
				}

				var params = "testName="+testName+"&pattName="+patternName+"&operation=newpattern";
				Ext.Ajax.request({
					url:'DescriptorPatternThreshold/data/EgDefinePatternJson.jsp?from='+entryVal+'&'+params,
					method: 'POST',
					scope: this,
					timeout: 6000000,
					success:function(response)
					{
						if(response.status == 200 && !Ext.isEmpty(response.responseText))
						{
							publicJson = Ext.decode(response.responseText);
							//var successUpdate = jsonText['successUpdate'];
							strPattName = patternName;
							//if(successUpdate)
							{
								hiddenFieldsVal = this.getHiddenFieldsForMeasure(actualMeasName);
								var homepage = Ext.getCmp('viewPortId');
								homepage.removeAll();
								homepage.add({ xtype : 'configurethresholds' });
							}
						}
					}
				});
				//this.createNewPatternEvent1();
			}
			else
			{
				var dispTestName = Ext.getCmp('testNameDisplayField').getValue();
				var dispPattName = Ext.getCmp('pattNameDisplayField').getValue();
				if (!Ext.isEmpty(dispPattName))
				{
					//strTestName = dispTestName;
					strPattName = dispPattName;
					//isModifyRule = 'true';
				}
				hiddenFieldsVal = this.getHiddenFieldsForMeasure(actualMeasName);
				var homepage = Ext.getCmp('viewPortId');
				homepage.removeAll();
				homepage.add({ xtype : 'configurethresholds' });
			}
		}
	},
	getHiddenFieldsForMeasure : function(measureActualVal)
	{
		var hiddenFields = publicJson['hiddenDataObj'][measureActualVal.trim()];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			if(key == 'strPattName' && Ext.isEmpty(hiddenFields[key]))
			{
				var policyValue = Ext.getCmp('pattNameText').getValue();
				hiddenQstr += key+'='+encodeURIComponent(policyValue)+"&";
			}
			else
				hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	afterThreshPatternCreateRender: function()
	{
		Ext.getCmp('comboBoxContainer').hide();
		Ext.getCmp('displayContainer').hide();
		Ext.getCmp('addBtnContainer').hide();

		if (!Ext.isEmpty(isModifyRule) && isModifyRule == 'true')
		{
			if(modifyThreshRuleUrl != null && !Ext.isEmpty(modifyThreshRuleUrl) )
			{
				urlVal = modifyThreshRuleUrl+'&urlForModifyRule='+encodeURIComponent(modifyThreshRuleUrl)+'&isModifyRule='+isModifyRule;
			}
			else if (!Ext.isEmpty(urlForModifyRule))
			{
				urlVal = urlForModifyRule+'&urlForModifyRule='+encodeURIComponent(urlForModifyRule)+'&isModifyRule='+isModifyRule;
			}
			
		}
		else
		{
			urlVal = 'DescriptorPatternThreshold/data/EgDefinePatternJson.jsp?';
			var qStr = '';
			if (strCompType != null && strCompType != 'undefined' && strCompType.length > 0)
			{
				qStr = 'compType='+strCompType;
			}
			if (strTestName != null && strTestName != 'undefined' && strTestName.length > 0)
			{
				qStr += '&testName='+strTestName;
			}

			if (!Ext.isEmpty(strPattName))
			{
				qStr += '&pattName='+strPattName;
			}
			
			if (!Ext.isEmpty(from) && from != 'undefined' && from != 'null')
			{
				qStr += '&from='+from;
			}
			else
			{
				qStr += '&from=first';
			}
			
			if (qStr != null && qStr.length > 0)
			{
				urlVal += '&'+qStr;
			}
		}
		
		Ext.Ajax.request({
			url:urlVal,
			method:'POST',
			scope:this,
			//async: false,
			timeout: 6000000,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					publicJson = Ext.decode(response.responseText);
					var isManagedCompAvailable = publicJson['isManagedCompAvailable'];
					if (!isManagedCompAvailable)
					{
						Ext.getCmp('noComponentsContainer').show();
						Ext.getCmp('comboBoxContainer').hide();
					}
					else
					{
						Ext.getCmp('noComponentsContainer').hide();
						Ext.getCmp('comboBoxContainer').show();

						var action = publicJson['hiddenObj']['action'];
						strCompType = publicJson['selectedCType'];
						if (!Ext.isEmpty(publicJson.selectedTest))
						{
							strTestName = publicJson['selectedTest'];
						}
						if(!Ext.isEmpty(action) && action != 'modify')
						{
							Ext.getCmp('createdescriptorpattern').setTitle(labelTxt12);

							Ext.getCmp('displayContainer').hide();
							Ext.getCmp('comboBoxContainer').show();

							//Ext.getCmp('addBtnContainer').show();
							var grpCompTypeArr = publicJson['grpCompTypeArr'];
							var grpTestNameArr = publicJson['grpTestNameArr'];
							Ext.getCmp('compTypeCombo').getStore().removeAll();
							Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
							Ext.getCmp('compTypeCombo').getStore().loadRawData(grpCompTypeArr);
							//Ext.getCmp('compTypeCombo').setValue(grpCompTypeArr[0].valueField);
							if (!Ext.isEmpty(strCompType))
							{
								Ext.getCmp('compTypeCombo').setValue(strCompType);
							}
							else
							{
								Ext.getCmp('compTypeCombo').setValue(grpTestNameArr[0].valueField);
							}
							Ext.getCmp('compTypeCombo').fireEvent('select', Ext.getCmp('compTypeCombo'));

							//var grpTestNameArr = publicJson['grpTestNameArr'];
							//Ext.getCmp('testNameCombo').getStore().removeAll();
							//Ext.getCmp('testNameCombo').getStore().loadRawData(grpTestNameArr);
							//if (!Ext.isEmpty(strTestName))
							//{
								//Ext.getCmp('testNameCombo').setValue(strTestName);
							//}
							//else
							//{
								//Ext.getCmp('testNameCombo').setValue(grpTestNameArr[0].valueField);
							//}
						}
						else
						{
							Ext.getCmp('createdescriptorpattern').setTitle(labelTxt19);
							var measureValArr = publicJson['measureValArr'];
							var noMeasureValArr = publicJson['noMeasureValArr'];
							var displayTestName = publicJson['displayTestName'];
							var displayPattName = publicJson['pattName'];

							Ext.getCmp('comboBoxContainer').hide();
							Ext.getCmp('addBtnContainer').hide();
							Ext.getCmp('displayContainer').show();
							
							Ext.getCmp('testNameDisplayField').setValue(displayTestName);
							Ext.getCmp('pattNameDisplayField').setValue(displayPattName);

							if (measureValArr != null && !Ext.isEmpty(measureValArr))
							{
								Ext.getCmp('measureGrid').show();
								Ext.getCmp('measureGrid').getStore().removeAll();
								Ext.getCmp('measureGrid').getStore().loadRawData(measureValArr);
							}else
							{
								Ext.getCmp('measureGrid').hide();
							}
							if (noMeasureValArr != null && !Ext.isEmpty(noMeasureValArr))
							{
								Ext.getCmp('noMeasureGrid').show();
								Ext.getCmp('noMeasureGrid').getStore().removeAll();
								Ext.getCmp('noMeasureGrid').getStore().loadRawData(noMeasureValArr);
							}else
							{
								Ext.getCmp('noMeasureGrid').hide();
							}
						}
					}
				}
			}
		});
	},
	addNewPatternEvent: function()
	{
		modifyThreshRuleUrl = '';
		isModifyRule = '';
		strCompType = '';
		strTestName = '';
		strPattName = '';
		from = '';
		var homepage = Ext.getCmp('viewPortId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'createdescriptorpattern' });
		myMask.hide();
	},
	newPatternPageBackEvent : function()
	{
		var homepage = Ext.getCmp('viewPortId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		homepage.removeAll();
		myMask.show();
		homepage.add({ xtype : 'thresholdpatterns' });
		myMask.hide();
	},
	afterThreshPatternMainRender: function()
	{
		var searchVal = Ext.getCmp('searchRuleTrigger').getValue();
		if (searchVal != null && !Ext.isEmpty(searchVal))
		{
			Ext.getCmp('searchRuleTrigger').reset();
		}
		Ext.getCmp('searchRuleTrigger').setDisabled(true);

		var urlVal = 'DescriptorPatternThreshold/data/EgShowDescThreshPatternJson.jsp?';
		
		Ext.Ajax.request({
			url:urlVal,
			method:'POST',
			scope:this,
			//async: false,
			timeout: 6000000,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					publicJson = Ext.decode(response.responseText);
					var isNoData = publicJson['isNoData'];
					Ext.getCmp('descPatternsGrid').show();
					var grpRuleGridDataArr = publicJson['descPatternGridDataArr'];
					Ext.getCmp('descPatternsGrid').getStore().removeAll();
					Ext.getCmp('descPatternsGrid').getStore().loadRawData(grpRuleGridDataArr);

					if (!isNoData)
					{
						Ext.getCmp('searchRuleTrigger').setDisabled(false);
						componentRawData = grpRuleGridDataArr;
					}
					else
					{
						Ext.getCmp('searchRuleTrigger').setDisabled(true);
					}
				}
			}
		});
	},
	noThreshMeasureDefinePattern: function( grid, td, cellIndex, record, tr, rowIndex, e, eOpts )
	{
		var pos = grid.getSelectionModel().getCurrentPosition();
		record = grid.store.getAt(pos.row);
		colname = grid.getHeaderCt().getHeaderAtIndex(cellIndex).dataIndex;
		cellvalue = record.data[colname];
		actualMeasName = publicJson['measureDataObj'][cellvalue];
		var pattName = Ext.getCmp('pattNameText').getValue(); //thisForm.ThresholdPolicy.value;
//		var regExp = /[@#&,~^$()+%=<>;?\"\'\]\|\}\[\{]/;
		var regExp = /[&,~^$%=<>;?\"\'\|]/;

		var patCheck = regExp.test(pattName)||(pattName.indexOf('\\')>=0);
		if(Ext.isEmpty(pattName) || pattName == 'null' || pattName == 'undefined')
		{
			Ext.Msg.show({
				title: pageName3,
				msg: pattErrMsg1,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('pattNameText').focus();
			allowUpdate = false;
			return;
		}
		//else if (pattName.indexOf(" ") > -1)
		//{
			//Ext.Msg.show({
				//title: pageName,
				//msg: noSpaceMsg,
				//buttons: Ext.MessageBox.OK,
				//icon: 'iconExclamation'
			 //});
			//Ext.getCmp('pattNameText').focus();
			//allowUpdate = false;
			//return;
		//}
		else if(!checkStars(pattName))
		{
			Ext.getCmp('pattNameText').focus();
			allowUpdate = false;
			return;
		}
		else if(patCheck)
		{
			Ext.Msg.show({
				title: pageName,
				msg: specialCharMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('pattNameText').focus();
			allowUpdate = false;
			return;
		}
		else if (!Ext.isEmpty(pattName) && (pattName.indexOf("*") == -1 || pattName.length < 2 ))
		{
			Ext.Msg.show({ 
				title: pageName3,
				msg: pattErrMsg2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			allowUpdate = false;
			Ext.getCmp('pattNameText').focus();
			return false;
		}
		if (actualMeasName != null && actualMeasName != 'undefined' && actualMeasName != '')
		{
			hiddenFieldsVal = this.getHiddenFields(actualMeasName);
			strPattName = pattName;
			strTestName = publicJson['testName'];
			var homepage = Ext.getCmp('viewPortId');
			homepage.removeAll();
			homepage.add({ xtype : 'configurethresholds' });
		}
	},
	handleSetThresholdEditIconClick: function(grid, rowIndex, colIndex)
	{
		var dispPattName = Ext.getCmp('pattNameDisplayField').getValue();
		if (!Ext.isEmpty(dispPattName))
		{
			isModifyRule = 'true';
		}
		var record = Ext.getCmp('measureGrid').getStore().getAt(rowIndex);
		this.showEditWindowPatternPage(record);
    },
	showEditWindowPatternPage: function(task)
	{
		var measureName = task.get('Measure');
		var thresholds = task.get('Thresholds');
		var alarmPol = task.get('AlarmPolicy');
		if(measureName.lastIndexOf(' ') != -1)
		{
			measureName = measureName.substring(0,measureName.lastIndexOf(' '));
		}
		var measureActualObj = publicJson.measureDataObj;
		hiddenFieldsVal = this.getHiddenFields(measureActualObj[measureName.trim()]);
		if (Ext.isEmpty(isModifyRule) || !isModifyRule)
		{
			var patternName = Ext.getCmp('pattNameText').getValue(); //thisForm.ThresholdPolicy.value;
			//var regExp = /[@#&,~^$()+%=<>;?\"\'\]\|\}\[\{]/;
			var regExp = /[&,~^$%=<>;?\"\'\|]/;

			var patCheck = regExp.test(patternName)||(patternName.indexOf('\\')>=0);
			if(Ext.isEmpty(patternName) || patternName == 'null' || patternName == 'undefined')
			{
				Ext.Msg.show({
					title: pageName3,
					msg: pattErrMsg1,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				 });
				Ext.getCmp('pattNameText').focus();
				allowUpdate = false;
				return;
			}
			//else if (patternName.indexOf(" ") > -1)
			//{
				//Ext.Msg.show({
					//title: pageName,
					//msg: noSpaceMsg,
					//buttons: Ext.MessageBox.OK,
					//icon: 'iconExclamation'
				 //});
				//Ext.getCmp('pattNameText').focus();
				//allowUpdate = false;
				//return;
			//}
			else if(patternName.indexOf('*') != -1  && !checkStars(patternName))
			{
				Ext.getCmp('pattNameText').focus();
				allowUpdate = false;
				return;
			}
			else if(patCheck)
			{
				Ext.Msg.show({
					title: pageName,
					msg: specialCharMsg,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				 });
				Ext.getCmp('pattNameText').focus();
				allowUpdate = false;
				return;
			}
			else if (!Ext.isEmpty(patternName) && patternName.indexOf('*') != -1  && patternName.length < 2)
			{
				Ext.Msg.show({ 
					title: pageName3,
					msg: pattErrMsg2,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				allowUpdate = false;
				Ext.getCmp('pattNameText').focus();
				return false;
			}
			strPattName = patternName;
		}
		else {
			strPattName = Ext.getCmp('pattNameDisplayField').getValue();

		}
		strTestName = publicJson['testName'];
		var homepage = Ext.getCmp('viewPortId');
		homepage.removeAll();
		homepage.add({ xtype : 'configurethresholds' });
	},
	definePatternUpdate: function() {
		var allowUpdate = true;
		var patternTestName = publicJson['testName'];
		var patternName = Ext.getCmp('pattNameText').getValue();
		//var regExp = /[@#&,~^$()+%=<>;?\"\'\]\|\}\[\{]/;
		var regExp = /[&,~^$%=<>;?\"\'\|]/;

		var patCheck = regExp.test(patternName)||(patternName.indexOf('\\')>=0);

		if(Ext.isEmpty(patternName) || patternName == 'null' || patternName == 'undefined')
		{
			Ext.Msg.show({
				title: pageName3,
				msg: pattErrMsg1,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('pattNameText').focus();
			return;
		}

		//if (patternName.indexOf(" ") > -1)
		//{
			//Ext.Msg.show({
				//title: pageName,
				//msg: noSpaceMsg,
				//buttons: Ext.MessageBox.OK,
				//icon: 'iconExclamation'
			 //});
			//Ext.getCmp('pattNameText').focus();
			//allowUpdate = false;
			//return;
		//}
		//else 
		
		if( patternName.indexOf('*') != -1  && !checkStars(patternName))
		{
			Ext.getCmp('pattNameText').focus();
			allowUpdate = false;
			return;
		}
		else if(patCheck)
		{
			Ext.Msg.show({
				title: pageName,
				msg: specialCharMsg,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			 });
			Ext.getCmp('pattNameText').focus();
			allowUpdate = false;
			return;
		}
		else if (!Ext.isEmpty(patternName) && patternName.indexOf("*") != -1 && patternName.length < 2) 
		{
			Ext.Msg.show({ 
				title: pageName3,
				msg: pattErrMsg2,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			allowUpdate = false;
			Ext.getCmp('pattNameText').focus();
			return false;
		}
		if (allowUpdate)
		{
			var myPatternMask = new Ext.LoadMask(Ext.getBody(), {msg:"Loading..."});
			myPatternMask.show();

			Ext.Ajax.request({
				url: 'DescriptorPatternThreshold/data/EgDefinePatternJson.jsp?from=update&operation=newpattern&testName='+encodeURIComponent(patternTestName)+'&pattName='+encodeURIComponent(patternName),
				method: 'POST',
				scope: this,
				timeout: 60000000,
				success: function(response) {
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						myPatternMask.hide();
						var jsonText = Ext.decode(response.responseText);
						var successUpdate = jsonText['successUpdate'];
						if(successUpdate)
						{
							Ext.Msg.show ({
								title: pageName3,
								msg: patternSuccessMsg1,
								buttons: Ext.MessageBox.OK,
								icon: 'iconInformation',
								fn: function()
								{
									strPattName = '';
									isFromDelete = 'false';
									var homepage = Ext.getCmp('viewPortId');
									var myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
									homepage.removeAll();
									myMask.show();
									homepage.add({ xtype : 'thresholdpatterns' });
									myMask.hide();
								}
							});
						}
					}
				},
				failure: function(response) { 
					Ext.Msg.show ({
						title: pageName3,
						msg: 'Updating error from server side',
						buttons: Ext.MessageBox.OK,
						icon: 'iconInformation',
						fn: function()
						{
							strPattName = '';
							isFromDelete = 'false';
						}
					});
				}
			});
		}
	},
	applyThresholdsData: function()
	{
		var flag = true;
		var v_testname = publicJson['hiddenObj']['testName'];
		if (v_testname == "null")
		{
			flag = false;
			return false;
		}

		var v_measure =  publicJson['hiddenObj']['measure'];
		if (v_measure == "null")
		{
			flag = false;
			return false;
		}

		var v_policy = "mix";
		var minThreshold = "-1";
		var maxThreshold = "-1";
		var v_alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var lastItem = "HML";

		var abs_MinCritical = "-";
		var abs_MinMajor = "-";
		var abs_MinMinor = "-";
		var abs_MinOpt = Ext.getCmp('minStaticCheck').getValue();
		var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
		if (!abs_MinOpt)
		{
			abs_MinCritical = Ext.getCmp('absMinCritical').getValue();
			abs_MinMajor =  Ext.getCmp('absMinMajor').getValue();
			abs_MinMinor =  Ext.getCmp('absMinMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNonNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MinCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}

			//check ascending order...
			if (abs_MinCritical != "-" && abs_MinMajor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinMajor != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinMajor) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinCritical != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MinCritical = "-";
		var rel_MinMajor = "-";
		var rel_MinMinor = "-";
		var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
		if (!minAutoCheck)
		{
			var v_amount_A = Ext.getCmp('relMinCriticalText').getValue();
			if (v_amount_A != 0)
			{
				if (v_amount_A == 100)
				{
					rel_MinCritical = "sqc";
				}
				else
				{
					rel_MinCritical = (v_amount_A/100) + "*sqc";
				}
			}

			var v_amount_B = Ext.getCmp('relMinMajorText').getValue();
			if (v_amount_B != 0)
			{
				if (v_amount_B == 100)
				{
					rel_MinMajor = "sqc";
				}
				else
				{
					rel_MinMajor = (v_amount_B/100) + "*sqc";
				}
			}

			var v_amount_C = Ext.getCmp('relMinMinorText').getValue();
			if (v_amount_C != 0)
			{
				if (v_amount_C == 100)
				{
					rel_MinMinor = "sqc";
				}
				else
				{
					rel_MinMinor = (v_amount_C/100) + "*sqc";
				}
			}

			//check ascending order...
			var relCri,relMaj,relMin;
			relCri = rel_MinCritical;
			relMaj = rel_MinMajor;
			relMin = rel_MinMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMaj))
				{
					Ext.Msg.show ({
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) >= parseFloat(relMin))
				{
					Ext.Msg.show ({
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMin))
				{
					Ext.Msg.show ({
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MinCritical.indexOf(".") != -1 )
		{
			var abs_MinCriticalDecimal = abs_MinCritical.substring(abs_MinCritical.indexOf(".")+1);
			if (abs_MinCriticalDecimal == "0000" || 
				abs_MinCriticalDecimal == "000" ||
				abs_MinCriticalDecimal == "00" ||
				abs_MinCriticalDecimal == "0" )
			{
				abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.indexOf("."));
			}
			else if(abs_MinCriticalDecimal.length > 1)
			{
				if ((abs_MinCriticalDecimal.charAt(3) == "0" && abs_MinCriticalDecimal.charAt(2) == "0") ||
					(abs_MinCriticalDecimal.charAt(3) == "0"))
				{
					abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMajor.indexOf(".") != -1 )
		{
			var abs_MinMajorDecimal = abs_MinMajor.substring(abs_MinMajor.indexOf(".")+1);
			if (abs_MinMajorDecimal == "0000" || 
				abs_MinMajorDecimal == "000" || 
				abs_MinMajorDecimal == "00" || 
				abs_MinMajorDecimal == "0")
			{
				abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.indexOf("."));
			}
			else if(abs_MinMajorDecimal.length > 1)
			{
				if ((abs_MinMajorDecimal.charAt(3) == "0" && abs_MinMajorDecimal.charAt(2) == "0") || 
					(abs_MinMajorDecimal.charAt(3) == "0"))
				{
					abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMinor.indexOf(".") != -1 )
		{
			var abs_MinMinorDecimal = abs_MinMinor.substring(abs_MinMinor.indexOf(".")+1);
			if (abs_MinMinorDecimal == "0000" || 
				abs_MinMinorDecimal == "000" || 
				abs_MinMinorDecimal == "00" || 
				abs_MinMinorDecimal == "0")
			{
				abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.indexOf("."));
			}
			else if(abs_MinMinorDecimal.length > 1)
			{
				if ((abs_MinMinorDecimal.charAt(3) == "0" && abs_MinMinorDecimal.charAt(2) == "0") || 
					(abs_MinMinorDecimal.charAt(3) == "0"))
				{
					abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.lastIndexOf("0"));
				}
			}
		}

		var minCritical = "-";
		if (abs_MinCritical != "-" && rel_MinCritical != "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString() + "&" + rel_MinCritical;
			}
			else
			{
				minCritical = rel_MinCritical;
			}
		}
		else if (abs_MinCritical != "-" && rel_MinCritical == "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString();
			}
			else
			{
				minCritical = "-";
			}
		}
		else if (abs_MinCritical == "-" && rel_MinCritical != "-")
		{
			minCritical = rel_MinCritical;
		}

		var minMajor = "-";
		if (abs_MinMajor != "-" && rel_MinMajor != "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString() + "&" + rel_MinMajor;
			}
			else
			{
				minMajor = rel_MinMajor;
			}
		}
		else if (abs_MinMajor != "-" && rel_MinMajor == "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString();
			}
			else
			{
				minMajor = "-";
			}
		}
		else if (abs_MinMajor == "-" && rel_MinMajor != "-")
		{
			minMajor = rel_MinMajor;
		}

		var minMinor = "-";
		if (abs_MinMinor != "-" && rel_MinMinor != "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString() + "&" + rel_MinMinor;
			}
			else
			{
				minMinor = rel_MinMinor;
			}
		}
		else if (abs_MinMinor != "-" && rel_MinMinor == "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString();
			}
			else
			{
				minMinor = "-";
			}
		}
		else if (abs_MinMinor == "-" && rel_MinMinor != "-")
		{
			minMinor = rel_MinMinor;
		}

		if (minCritical != "-" || minMajor != "-" || minMinor != "-")
		{
			minThreshold = minCritical + "/" + minMajor + "/" + minMinor
		}

		var abs_MaxCritical = "-";
		var abs_MaxMajor = "-";
		var abs_MaxMinor = "-";
		var abs_MaxOpt = Ext.getCmp('maxStaticCheck').getValue();
		if (!abs_MaxOpt)
		{
			abs_MaxCritical = Ext.getCmp('absMaxCritical').getValue();
			abs_MaxMajor =  Ext.getCmp('absMaxMajor').getValue();
			abs_MaxMinor =  Ext.getCmp('absMaxMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MaxCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}
			//check descending order...
			if (abs_MaxCritical != "-" && abs_MaxMajor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxMajor != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxMajor) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxCritical != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MaxCritical = "-";
		var rel_MaxMajor = "-";
		var rel_MaxMinor = "-";
		var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
		if (!maxAutoCheck)
		{
			var v_amount_D = Ext.getCmp('relMaxCriticalText').getValue();
			if (v_amount_D != 0)
			{
				if (v_amount_D == 100)
				{
					rel_MaxCritical = "sqc";
				}
				else
				{
					rel_MaxCritical = (v_amount_D/100) + "*sqc";
				}
			}

			var v_amount_E =  Ext.getCmp('relMaxMajorText').getValue();
			if (v_amount_E != 0)
			{
				if (v_amount_E == 100)
				{
					rel_MaxMajor = "sqc";
				}
				else
				{
					rel_MaxMajor = (v_amount_E/100) + "*sqc";
				}
			}

			var v_amount_F = Ext.getCmp('relMaxMinorText').getValue();
			if (v_amount_F != 0)
			{
				if (v_amount_F == 100)
				{
					rel_MaxMinor = "sqc";
				}
				else
				{
					rel_MaxMinor = (v_amount_F/100) + "*sqc";
				}
			}

			//check descending order...
			var relCri,relMaj,relMin;
			relCri = rel_MaxCritical;
			relMaj = rel_MaxMajor;
			relMin = rel_MaxMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMaj))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) <= parseFloat(relMin))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMin))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MaxCritical.indexOf(".") != -1 )
		{
			var abs_MaxCriticalDecimal = abs_MaxCritical.substring(abs_MaxCritical.indexOf(".")+1);
			if (abs_MaxCriticalDecimal == "0000" || 
				abs_MaxCriticalDecimal == "000" || 
				abs_MaxCriticalDecimal == "00" || 
				abs_MaxCriticalDecimal == "0")
			{
				abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.indexOf("."));
			}
			else if(abs_MaxCriticalDecimal.length > 1)
			{
				if ((abs_MaxCriticalDecimal.charAt(3) == "0" && abs_MaxCriticalDecimal.charAt(2) == "0") ||
					(abs_MaxCriticalDecimal.charAt(3) == "0"))
				{
					abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMajor.indexOf(".") != -1 )
		{
			var abs_MaxMajorDecimal = abs_MaxMajor.substring(abs_MaxMajor.indexOf(".")+1);
			if (abs_MaxMajorDecimal == "0000" || 
				abs_MaxMajorDecimal == "000" || 
				abs_MaxMajorDecimal == "00" || 
				abs_MaxMajorDecimal == "0")
			{
				abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.indexOf("."));
			}
			else if(abs_MaxMajorDecimal.length > 1)
			{
				if ((abs_MaxMajorDecimal.charAt(3) == "0" && abs_MaxMajorDecimal.charAt(2) == "0") ||
					(abs_MaxMajorDecimal.charAt(3) == "0"))
				{
					abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMinor.indexOf(".") != -1 )
		{
			var abs_MaxMinorDecimal = abs_MaxMinor.substring(abs_MaxMinor.indexOf(".")+1);
			if (abs_MaxMinorDecimal == "0000" || 
				abs_MaxMinorDecimal == "000" || 
				abs_MaxMinorDecimal == "00" || 
				abs_MaxMinorDecimal == "0")
			{
				abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.indexOf("."));
			}
			else if(abs_MaxMinorDecimal.length > 1)
			{
				if ((abs_MaxMinorDecimal.charAt(3) == "0" && abs_MaxMinorDecimal.charAt(2) == "0") || 
					(abs_MaxMinorDecimal.charAt(3) == "0"))
				{
					abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.lastIndexOf("0"));
				}
			}
		}

		var maxCritical = "-";
		if (abs_MaxCritical != "-" && rel_MaxCritical != "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString() + "&" + rel_MaxCritical;
			}
			else
			{
				maxCritical = rel_MaxCritical;
			}
		}
		else if (abs_MaxCritical != "-" && rel_MaxCritical == "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString();
			}
			else
			{
				maxCritical = "-";
			}
		}
		else if (abs_MaxCritical == "-" && rel_MaxCritical != "-")
		{
			maxCritical = rel_MaxCritical;
		}

		var maxMajor = "-";
		if (abs_MaxMajor != "-" && rel_MaxMajor != "-")
		{
			if(abs_MaxMajor > -1 || abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString() + "&" + rel_MaxMajor;
			}
			else
			{
				maxMajor = rel_MaxMajor;
			}
		}
		else if (abs_MaxMajor != "-" && rel_MaxMajor == "-")
		{
			if(abs_MaxMajor > -1 || + abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString();
			}
			else
			{
				maxMajor = "-";
			}
		}
		else if (abs_MaxMajor == "-" && rel_MaxMajor != "-")
		{
			maxMajor = rel_MaxMajor;
		}

		var maxMinor = "-";
		if (abs_MaxMinor != "-" && rel_MaxMinor != "-")
		{
			if(abs_MaxMinor > -1 || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString() + "&" + rel_MaxMinor;
			}
			else
			{
				maxMinor = rel_MaxMinor;
			}
		}
		else if (abs_MaxMinor != "-" && rel_MaxMinor == "-")
		{
			if(abs_MaxMinor > -1  || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString();
			}
			else
			{
				maxMinor = "-";
			}
		}
		else if (abs_MaxMinor == "-" && rel_MaxMinor != "-")
		{
			maxMinor = rel_MaxMinor;
		}

		if (maxCritical != "-" || maxMajor != "-" || maxMinor != "-")
		{
			maxThreshold = maxCritical + "/" + maxMajor + "/" + maxMinor
		}

		if (flag)
		{
			var myHomeMask = new Ext.LoadMask(Ext.getBody(), {msg:"Updating..."});
			myHomeMask.show();
			var v_threshold = v_measure + ":" + v_policy + ":" + minThreshold + ":" + maxThreshold + ":" + v_alarmPolicy + ":" + lastItem;
			//this.updateThresholds(v_testname,v_threshold);
			strTestName = v_testname;
			var params = '';
			var urlVal = '';

			var descVal = publicJson['pattName'];
			strPattName = descVal;
			var check = Ext.getCmp('allMeasureCheck').getValue();
			var allMeasVal = "";
			if(check)
			{
				allMeasVal = "true";
			}
			if (!Ext.isEmpty(descVal) && descVal.indexOf("*") != -1)
			{
				params = "testName="+v_testname+"&from=update&pattName="+encodeURIComponent(descVal)+"&threshold="+escape(v_threshold)+"&operation=modifypattern&allMeasure="+allMeasVal;
				urlVal = 'DescriptorPatternThreshold/data/EgDefinePatternJson.jsp?'+params;
			}
			else
			{
				params = "testName="+v_testname+"&descName="+encodeURIComponent(descVal)+"&threshold="+escape(v_threshold)+"&operation=updateThresholds&allMeasure="+allMeasVal;
				urlVal = 'DescriptorPatternThreshold/data/EgApplyDescThresholds.jsp?'+params;
			}
			
			Ext.Ajax.request({
				url:urlVal,
				method:'POST',
				timeout: 60000000,
				//async:false,
				scope:this,
				success:function(response)
				{
					var jsonText = response.responseText;
					//publicJson = Ext.decode(jsonText);
					if (response.status == 200 && !Ext.isEmpty(jsonText))
					{
						myHomeMask.hide();
						Ext.Msg.show ({
							title: pageName,
							msg: successMsg1,
							buttons: Ext.MessageBox.OK,
							icon: 'iconInformation',
						});
						var homepage = Ext.getCmp('viewPortId');
						from = 'modify';
						myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
						homepage.removeAll();
						myMask.show();
						homepage.add({ xtype : 'createdescriptorpattern' });
						myMask.hide();
					}
				},
				failure: function()
				{
					myHomeMask.hide();
					Ext.Msg.show({
						title: pageName,
						msg: 'Updating problem in server side...',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
				}
			});
		}
	},
	alarmPolicyChange: function()
	{
		var alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicy]
		//Ext.getCmp('alarmDispField').el.update(tmpDescription);
		Ext.getCmp('alarmDispField').setValue(tmpDescription);
	},
	maxStaticFieldChange: function(field){
        var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (maxStaticCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	maxAutoFieldChange: function(field){
        var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (maxAutoCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	minStaticFieldChange: function(field){
        var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (minStaticCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	minAutoFieldChange: function(field){
        var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (minAutoCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	maxStaticCheckChange: function(box, checked)
	{
		//max static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('absMaxCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('absMaxMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('absMaxCritical').setFieldLabel(criticalText);
			Ext.getCmp('absMaxMajor').setFieldLabel(majorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('textfield'), this.maxStaticFieldChange, this);
        Ext.Array.forEach(fieldset.query('textfield'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });

		if(checked)
		{
			//if (renderFrom != null && renderFrom != 'undefined' && (renderFrom == 'defaultDescriptorThresholds' || renderFrom == 'definePatternThresholds'))
			{
				var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
				var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
				var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
				var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
				if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
				{
					Ext.getCmp('allMeasureContainer').show();
				}
				else
				{
					Ext.getCmp('allMeasureContainer').hide();
				}
			}
		}
    },
	maxAutoCheckChange: function(box, checked)
	{
		//max static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('relMaxCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('relMaxMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('relMaxCritical').setFieldLabel(autoCriText);
			Ext.getCmp('relMaxMajor').setFieldLabel(autoMajorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('slider'), this.maxAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('slider'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });
        Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'maxThreshDisplayField')
			{
			}
			else
			{

				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });

		if(checked)
		{
			//if (renderFrom != null && renderFrom != 'undefined' && (renderFrom == 'defaultDescriptorThresholds' || renderFrom == 'definePatternThresholds'))
			{
				var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
				var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
				var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
				var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
				if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
				{
					Ext.getCmp('allMeasureContainer').show();
				}
				else
				{
					Ext.getCmp('allMeasureContainer').hide();
				}
			}
		}
		//Ext.getCmp('minThreshDisplayField').el.animate({opacity: 1});
    },
	minStaticCheckChange: function(box, checked)
	{
		//min static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('absMinCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('absMinMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('absMinCritical').setFieldLabel(criticalText);
			Ext.getCmp('absMinMajor').setFieldLabel(majorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('textfield'), this.minStaticFieldChange, this);
        Ext.Array.forEach(fieldset.query('textfield'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });

		if(checked)
		{
			//if (renderFrom != null && renderFrom != 'undefined' && (renderFrom == 'defaultDescriptorThresholds' || renderFrom == 'definePatternThresholds'))
			{
				var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
				var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
				var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
				var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
				if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
				{
					Ext.getCmp('allMeasureContainer').show();
				}
				else
				{
					Ext.getCmp('allMeasureContainer').hide();
				}
			}
		}
    },
	minAutoCheckChange: function(box, checked)
	{
		//min auto block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('relMinCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('relMinMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('relMinCritical').setFieldLabel(autoCriText);
			Ext.getCmp('relMinMajor').setFieldLabel(autoMajorText);
		}

		Ext.getCmp('allMeasureContainer').hide();
        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('slider'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('slider'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });
        Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'minThreshDisplayField')
			{
			}
			else
			{

				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });

		if(checked)
		{
			//if (renderFrom != null && renderFrom != 'undefined' && (renderFrom == 'defaultDescriptorThresholds' || renderFrom == 'definePatternThresholds'))
			{
				var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
				var minAutoCheck  = Ext.getCmp('minAutoCheck').getValue();
				var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
				var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
				if(minStaticCheck && minAutoCheck && maxStaticCheck && maxAutoCheck)
				{
					Ext.getCmp('allMeasureContainer').show();
				}
				else
				{
					Ext.getCmp('allMeasureContainer').hide();
				}
			}
		}
		//Ext.getCmp('minThreshDisplayField').el.animate({opacity: 1});
    },
	getHiddenFields : function(measureActualVal)
	{
		var hiddenFields = publicJson['hiddenDataObj'][measureActualVal.trim()];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	configureMainRender: function()
	{
		
		var urlVal = '';
		if (!Ext.isEmpty(strPattName)  && strPattName.indexOf('*') != -1)
		{
			urlVal = 'DescriptorPatternThreshold/data/EgConfigurePatternThresholdsJson.jsp?'+hiddenFieldsVal+'&pattName='+strPattName;
		}
		else 
		{
			var strTestName = publicJson['selectedTest'];
			//var descName = publicJson['pattName'];
			urlVal = 'DescriptorPatternThreshold/data/EgConfigureDescThresholdsJson.jsp?'+hiddenFieldsVal+'&testName='+strTestName+'&descName='+strPattName;
		}
		Ext.Ajax.request({
			url:urlVal,
			method:'POST',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				var testDescription = publicJson['screenLabels']['test_description'];
				if (Ext.getCmp('allMeasureContainer').isVisible())
				{
					Ext.getCmp('allMeasureContainer').hide();
				}
				var descComp = Ext.getCmp('testDescriptionId');
				var alarmPolicyCombo = publicJson['alarmPolicyArr'];
				var minThreshObj = publicJson['minThreshObj'];
				var maxThreshObj = publicJson['maxThreshObj'];
				var selectAlarm = publicJson['selectedAlarmType'];
				var selectedAlarmDescription = publicJson['selectedAlarmDescription'];
				var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
				var isGlobalThresholds = publicJson['isGlobalThresholds'];
				if (!Ext.isEmpty(publicJson.selectedTest))
				{
					strTestName =  publicJson['selectedTest'];
				}
				if (!Ext.isEmpty(publicJson.pattName))
				{
					strPattName =  publicJson['pattName'];
				}
				if(isGlobalThresholds)
				{
					Ext.getCmp('minAutoCheck').hide();
					Ext.getCmp('minAutoFieldContainer').hide();
					Ext.getCmp('maxAutoCheck').hide();
					Ext.getCmp('maxAutoFieldContainer').hide();
				}

				var toolTipMsg = publicJson.isToolTip;

				var minStaticOption = minThreshObj.minStaticOption;
				var minStaticBlock = minThreshObj.minStaticBlock;
				if(minStaticOption != null && !Ext.isEmpty(minStaticOption) && minStaticOption == 'selected')
				{
					//min static block specific description for BusinessTransTest,KBusinessTransTest
					if (toolTipMsg)
					{
						Ext.getCmp('absMinCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						Ext.getCmp('absMinMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
					}
					else
					{
						Ext.getCmp('absMinCritical').setFieldLabel(criticalText);
						Ext.getCmp('absMinMajor').setFieldLabel(majorText);
					}

					var absMinCritical = minThreshObj.absMinCritical;
					var absMinMajor = minThreshObj.absMinMajor;
					var absMinMinor = minThreshObj.absMinMinor;
					Ext.getCmp('minStaticCheck').setValue(false);
					Ext.getCmp('absMinCritical').setValue(absMinCritical);
					Ext.getCmp('absMinMajor').setValue(absMinMajor);
					Ext.getCmp('absMinMinor').setValue(absMinMinor);
					
				}
				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var minAutomaticOption = minThreshObj.minAutomaticOption;
						var minAutomaticBlock = minThreshObj.minAutomaticBlock;
						if (minAutomaticOption != null && !Ext.isEmpty(minAutomaticOption) && minAutomaticOption == 'selected')
						{
							var relMinCritical = minThreshObj.relMinCritical;
							var relMinMajor = minThreshObj.relMinMajor;
							var relMinMinor = minThreshObj.relMinMinor;
							Ext.getCmp('minAutoCheck').show();
							Ext.getCmp('minAutoFieldContainer').show();
							Ext.getCmp('minAutoCheck').setValue(false);
							Ext.getCmp('relMinCritical').setValue(relMinCritical);
							Ext.getCmp('relMinCriticalText').setValue(relMinCritical);
							Ext.getCmp('relMinMajor').setValue(relMinMajor);
							Ext.getCmp('relMinMajorText').setValue(relMinMajor);
							Ext.getCmp('relMinMinor').setValue(relMinMinor);
							Ext.getCmp('relMinMinorText').setValue(relMinMinor);

							if (toolTipMsg)
							{
								Ext.getCmp('relMinCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
								Ext.getCmp('relMinMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
							}
							else
							{
								Ext.getCmp('relMinCritical').setFieldLabel(autoCriText);
								Ext.getCmp('relMinMajor').setFieldLabel(autoMajorText);
							}
						}
					}
				}

				var maxStaticOption = maxThreshObj.maxStaticOption;
				var maxStaticBlock = maxThreshObj.maxStaticBlock;
				if (maxStaticOption != null && !Ext.isEmpty(maxStaticOption) && maxStaticOption == 'selected')
				{
					//max static block specific description for BusinessTransTest,KBusinessTransTest
					if (toolTipMsg)
					{
						Ext.getCmp('absMaxCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						Ext.getCmp('absMaxMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
					}
					else
					{
						Ext.getCmp('absMaxCritical').setFieldLabel(criticalText);
						Ext.getCmp('absMaxMajor').setFieldLabel(majorText);
					}

					var absMaxCritical = maxThreshObj.absMaxCritical;
					var absMaxMajor = maxThreshObj.absMaxMajor;
					var absMaxMinor = maxThreshObj.absMaxMinor;
					Ext.getCmp('maxStaticCheck').setValue(false);
					Ext.getCmp('absMaxCritical').setValue(absMaxCritical);
					Ext.getCmp('absMaxMajor').setValue(absMaxMajor);
					Ext.getCmp('absMaxMinor').setValue(absMaxMinor);
					
				}

				if (!isGlobalThresholds)
				{
					if (!isNegativeValuesAllowed)
					{
						var maxAutomaticOption = maxThreshObj.maxAutomaticOption;
						var maxAutomaticBlock = maxThreshObj.maxAutomaticBlock;
						if (maxAutomaticOption != null && !Ext.isEmpty(maxAutomaticOption) && maxAutomaticOption == 'selected')
						{
							var relMaxCritical = maxThreshObj.relMaxCritical;
							var relMaxMajor = maxThreshObj.relMaxMajor;
							var relMaxMinor = maxThreshObj.relMaxMinor;
							Ext.getCmp('maxAutoCheck').show();
							Ext.getCmp('maxAutoFieldContainer').show();
							Ext.getCmp('maxAutoCheck').setValue(false);
							Ext.getCmp('relMaxCritical').setValue(relMaxCritical);
							Ext.getCmp('relMaxCriticalText').setValue(relMaxCritical);
							Ext.getCmp('relMaxMajor').setValue(relMaxMajor);
							Ext.getCmp('relMaxMajorText').setValue(relMaxMajor);
							Ext.getCmp('relMaxMinor').setValue(relMaxMinor);
							Ext.getCmp('relMaxMinorText').setValue(relMaxMinor);

							if (toolTipMsg)
							{
								Ext.getCmp('relMaxCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
								Ext.getCmp('relMaxMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
							}
							else
							{
								Ext.getCmp('relMaxCritical').setFieldLabel(autoCriText);
								Ext.getCmp('relMaxMajor').setFieldLabel(autoMajorText);
							}
						}
					}
				}
				var isHostTest = publicJson['isHostTest'];
				descComp.update('<center>'+testDescription+'</center>');
				var alarmDispField = Ext.getCmp('alarmDispField');
				var alarmCombo = Ext.getCmp('alarmPolicyCombo');
				if(alarmPolicyCombo != null && !Ext.isEmpty(alarmPolicyCombo))
				{
					alarmDispField.el.animate({opacity: 1});
					alarmCombo.getStore().suspendEvents(true);
					alarmCombo.getStore().removeAll();
					alarmCombo.getStore().loadRawData(alarmPolicyCombo);
					alarmCombo.getStore().resumeEvents();

					if (selectAlarm != null && !Ext.isEmpty(selectAlarm))
					{
						alarmCombo.setValue(selectAlarm);
					}
					else
					{
						//selectAlarm = alarmPolicyCombo[0].valueField;
						alarmCombo.setValue(alarmPolicyCombo[0].valueField);
					}
					if (selectedAlarmDescription != null && !Ext.isEmpty(selectedAlarmDescription))
					{
						//alarmDispField.el.update(selectedAlarmDescription);
						alarmDispField.setValue(selectedAlarmDescription);
					}
					else
					{
						var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicyCombo[0].valueField]
						//alarmDispField.el.update(tmpDescription);
						alarmDispField.setValue(tmpDescription);
					}
				}
				var allMeasureCheck = publicJson['allMeasureCheck'];
				if (allMeasureCheck != null && allMeasureCheck != 'undefined' && (allMeasureCheck == 'true'))
				{
					Ext.getCmp('allMeasureContainer').show();
				}
			}
		});
	},
	maxRelCriticalSlider: function()
	{
		Ext.getCmp('relMaxCriticalText').setValue(Ext.getCmp('relMaxCritical').getValue());
	},
	maxRelMajorSlider: function()
	{
		Ext.getCmp('relMaxMajorText').setValue(Ext.getCmp('relMaxMajor').getValue());
	},
	maxRelMinorSlider: function()
	{
		Ext.getCmp('relMaxMinorText').setValue(Ext.getCmp('relMaxMinor').getValue());
	},
	minRelCriticalSlider: function()
	{
		Ext.getCmp('relMinCriticalText').setValue(Ext.getCmp('relMinCritical').getValue());
	},
	minRelMajorSlider: function()
	{
		Ext.getCmp('relMinMajorText').setValue(Ext.getCmp('relMinMajor').getValue());
	},
	minRelMinorSlider: function()
	{
		Ext.getCmp('relMinMinorText').setValue(Ext.getCmp('relMinMinor').getValue());
	},
	configureThresholdsPageBack: function()
	{
		var homepage = Ext.getCmp('viewPortId');
		myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
		myMask.show();
		homepage.removeAll();
		homepage.add({ xtype : 'createdescriptorpattern' });
		myMask.hide();
	}
});


function checkValidValue(val)
{
	var regExp = /^(\-)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeValue(val)
{
	if (val == "-")
	{
		val = "0";
	}
	var regExp = /^\-([0-9]+\.|\.)?[0-9]+/;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeFormat(val)
{
	var regExp= /^(\-{0,1})[0-9]{1,10}(\.[0-9]{1,4})?$/;
	var ret = regExp.test(val);
	return ret;
}

function checkNonNegativeFormat(val)
{
	var regExp= /^[0-9]{0,10}(\.[0-9]{1,4})?$/;
	var ret = regExp.test(val);
	return ret;
}

function checkStars(fieldvalue)
{
	var val = fieldvalue;
	if (val.length == 2)
	{
		if(val.charAt(0) == '*' && val.charAt(val.length - 1) == '*')
		{
			Ext.Msg.show ({
				title: pageName,
				msg: checkStarMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return false;
		}
	}
	else
	{
		for(var k=0;k < val.length;k++)
		{
			if(val.charAt(k) == '*' && val.charAt(k + 1) == '*')
			{
				Ext.Msg.show ({
					title: pageName,
					msg: checkStarMsg,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
				});
				return false;
			}
			else
			{
				continue;
			}
		}
	}
	return true;
}