var serverData = "";

if (agentUploadLink.indexOf("http") == 0)
{
	agentUploadLink = '<a class="aInfoMsgLinkText aLinkBottomBorder" href="'+agentUploadLink+'" target="_blank"><span style="font-weight:500;">'+agentUploadLink+'</span></a>';
}
else
{
	agentUploadLink = '<span style="font-weight:500;">'+agentUploadLink+'</span>';
}

if (vmAgentUploadLink.indexOf("http") == 0)
{
	vmAgentUploadLink = '<a class="aInfoMsgLinkText aLinkBottomBorder" href="'+vmAgentUploadLink+'" target="_blank"><span style="font-weight:500;">'+vmAgentUploadLink+'</span></a>';
}
else
{
	vmAgentUploadLink = '<span style="font-weight:500;">'+vmAgentUploadLink+'</span>';
}

var procedure = '<div class="agentBuildGuide"><table width="100%"><tr><td align="left" valign="middle">'+
				'<p class="header" style="padding:10px 0px 0px 0px">Making the eG Agents downloadable from the eG Manager</p>'+
				'<ol class="listCount"><li>Download the agents from the location '+agentUploadLink+'.</li><li>Upload the downloaded zip files to the location <span style="font-weight:500;">&lt;EG_INSTALL_DIR&gt;\\manager\\agents\\Universal\\Latest</span>.</li></ol>'+
				'<p class="header">Making the eG VM Agents downloadable from the eG Manager</p>'+
				'<ol class="listCount"><li>Download the agents from the location '+vmAgentUploadLink+'.</li><li>Upload the downloaded zip files to the location <span style="font-weight:500;">&lt;EG_INSTALL_DIR&gt;\\manager\\agents\\VM\\Latest</span>.</li></ol>'+
				'</td></tr></table></div>';

Ext.define('DownloadAgentPack.controller.Main',{
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'DownloadUtils'
	],
	refs : [
		{ selector : 'main', ref : 'main' },
		{ selector : 'downloadutils', ref : 'downloadutils' }
	],

	init : function()
	{
		appCnt = this;
		this.control({
			'main' :
			{
				'afterrender' : this.afterMainRender
			},
			'main button[id="helpbutton"]':
			{
				'click': this.helpbutton
			},
			'main button[id="iconClose"]':
			{
				'click': this.iconClose
			}
		});
	},

	afterMainRender : function()
	{
		Ext.Ajax.request(
		{
			url : 'DownloadAgentPack/data/agentPackDownloadJson.jsp',
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);

				Ext.getCmp('agentVersion').getStore().suspendEvents(true);
				Ext.getCmp('agentVersion').getStore().loadRawData(publicJSON.agentVersion);
				Ext.getCmp('agentVersion').getStore().resumeEvents();
				Ext.getCmp('agentVersion').setValue(publicJSON.selectedAgentVersion);

				Ext.getCmp('agentType').setValue("All");
				Ext.getCmp('osname').getStore().clearFilter();
				
				if (!Ext.isEmpty(publicJSON.listOfOS))
				{
					Ext.getCmp('emptyMsg').hide();
					Ext.getCmp('osname').getStore().loadRawData(publicJSON.listOfOS);
					Ext.getCmp('osname').getStore().sort('valueField', 'ASC');

					Ext.getCmp('osname').getStore().each(function(rec) {
						Ext.getCmp('osname').getStore().remove(Ext.getCmp('osname').getStore().findRecord("folder","VM"));
					});
					Ext.getCmp('osname').show();
					Ext.getCmp('osnameContainer').show();

					
					if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
					{
						Ext.getCmp('WhatNextObj').destroy();
					}

					Ext.getCmp('mainCont').add({
						xtype: 'WhatNext',
						id:'WhatNextObj',
					});

					Ext.getCmp('whatNextText').update('<div class="whatNextHeader">'+whatNextTitle+'</div><div><ol class="listDefault"><li>'+downloadAgentWhatNext1+'.</li><br/><li><a class="whatNextLink" href="https://www.eginnovations.com/product/universal-monitoring-agent" target="_blank">'+downloadAgentWhatNext2+'.</a></li></ol></div>');

					Ext.getCmp('WhatNextObj').setWidth(250);
					Ext.getCmp('WhatNextObj').setHeight(140); 
				}
				else
				{
					Ext.getCmp('osname').hide();
					Ext.getCmp('osnameContainer').hide();
					if (!hideProcedure)
					{
						Ext.getCmp('emptyMsg').update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+'. <br/><a href="javascript:appCnt.helpbutton()">'+downloadAgentEmptyMsg2+' <span src="/final/images/spacer.gif" class="iconClickHere" style="display:inline-block;vertical-align: text-bottom;" border="0"></span> '+downloadAgentEmptyMsg3+'.</a></div></div>'); 
					}
					else
					{
						Ext.getCmp("emptyMsg").update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+". <br/>"+downloadAgentEmptyMsg4+".</div></div>");
					}
					Ext.getCmp('emptyMsg').show();
				}
				
				Ext.getCmp('osname').getStore().clearFilter();
				if (from != null && (from == 'External' || from == 'Remote' || from == 'Internal'))
				{
					appCnt.goToAgentModel(from);
				}
				
				if (Ext.isEmpty(Ext.getCmp('osname').getStore().data.items))
				{
					Ext.getCmp('osname').hide();
					Ext.getCmp('osnameContainer').hide();
					if (!hideProcedure)
					{
						Ext.getCmp('emptyMsg').update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+'. <br/><a href="javascript:appCnt.helpbutton()">'+downloadAgentEmptyMsg2+' <span src="/final/images/spacer.gif" class="iconClickHere" style="display:inline-block;vertical-align: text-bottom;" border="0"></span> '+downloadAgentEmptyMsg3+'.</a></div></div>'); 
					}
					else
					{
						Ext.getCmp("emptyMsg").update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+". <br/>"+downloadAgentEmptyMsg4+".</div></div>");
					}
					Ext.getCmp('emptyMsg').show();
					if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
					{
						Ext.getCmp('WhatNextObj').hide();
					}
				}
				else
				{
					Ext.getCmp('WhatNextObj').show();
				}
			}
		});
	},
	
	helpbutton : function()
	{
		Ext.getCmp('helpbutton').hide();
		Ext.getCmp('iconClose').show();
		Ext.getCmp('osname').hide();
		Ext.getCmp('osnameContainer').hide();
		Ext.getCmp('agentModel').hide();
		Ext.getCmp('dockMsg').hide();
		Ext.getCmp('emptyMsg').update(procedure);
		Ext.getCmp('emptyMsg').show();
		Ext.getCmp('main').setTitle('<div>'+procedureTitle+'</div>');
		if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
		{
			Ext.getCmp('WhatNextObj').hide();
		}
	},
	
	iconClose : function()
	{
		Ext.getCmp('helpbutton').show();
		Ext.getCmp('iconClose').hide();
		if (Ext.isEmpty(Ext.getCmp('osname').getStore().data.items))
		{
			Ext.getCmp('osname').hide();
			Ext.getCmp('osnameContainer').hide();
			Ext.getCmp('agentModel').show();
			if (!hideProcedure)
			{
				Ext.getCmp('emptyMsg').update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+'. <br/><a href="javascript:appCnt.helpbutton()">'+downloadAgentEmptyMsg2+' <span src="/final/images/spacer.gif" class="iconClickHere" style="display:inline-block;vertical-align: text-bottom;" border="0"></span> '+downloadAgentEmptyMsg3+'.</a></div></div>'); 
			}
			else
			{
				Ext.getCmp("emptyMsg").update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+". <br/>"+downloadAgentEmptyMsg4+".</div></div>");
			}
			Ext.getCmp('emptyMsg').show();
			if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
			{
				Ext.getCmp('WhatNextObj').hide();
			}
		}
		else
		{
			Ext.getCmp('emptyMsg').hide();
			Ext.getCmp('osname').show();
			Ext.getCmp('osnameContainer').show();
			Ext.getCmp('agentModel').show();
			Ext.getCmp('WhatNextObj').show();
		}
		if (!Ext.isEmpty(fromAgentModel))
		{
			appCnt.goToAgentModel(fromAgentModel);
		}
		else
		{
			appCnt.goToAgentModel('Internal');
		}
	},

	loadAgentsBasedOnVersion : function()
	{
		var category = Ext.getCmp('agentType').getValue();
		var agentVersion = Ext.getCmp('agentVersion').getValue();
		Ext.Ajax.request(
		{
			url : 'DownloadAgentPack/data/agentPackDownloadJson.jsp?agentVersion='+encodeURIComponent(agentVersion),
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				Ext.getCmp('agentVersion').getStore().suspendEvents(true);
				Ext.getCmp('agentVersion').getStore().loadRawData(jsonData.agentVersion);
				Ext.getCmp('agentVersion').getStore().resumeEvents();
				Ext.getCmp('agentVersion').setValue(jsonData.selectedAgentVersion);
				
				if (!Ext.isEmpty(jsonData.listOfOS))
				{
					Ext.get('emptyMsg').hide();
					Ext.getCmp('osname').getStore().suspendEvents(true);
					Ext.getCmp('osname').getStore().loadRawData(jsonData.listOfOS);
					Ext.getCmp('osname').getStore().resumeEvents();
					Ext.getCmp('osname').getStore().sort('valueField', 'ASC');
					Ext.getCmp('osname').show();
					Ext.getCmp('osnameContainer').show();
				}
				else
				{
					Ext.getCmp('osname').hide();
					Ext.getCmp('osnameContainer').hide();
					if (!hideProcedure)
					{
						Ext.getCmp('emptyMsg').update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+'. <br/><a href="javascript:appCnt.helpbutton()">'+downloadAgentEmptyMsg2+' <span src="/final/images/spacer.gif" class="iconClickHere" style="display:inline-block;vertical-align: text-bottom;" border="0"></span> '+downloadAgentEmptyMsg3+'.</a></div></div>'); 
					}
					else
					{
						Ext.getCmp("emptyMsg").update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+". <br/>"+downloadAgentEmptyMsg4+".</div></div>");
					}
					Ext.getCmp('emptyMsg').show();
				}

				Ext.getCmp('osname').getStore().clearFilter();
				if (category != null && category != 'All')
				{
					Ext.getCmp('osname').getStore().filter('category',category);
					if (category == 'Windows')
					{
						Ext.getCmp('osname').getStore().sort('valueField', 'DESC');
					}
				}

				if (from != null && (from == 'External' || from == 'Remote' || from == 'Internal'))
				{
					appCnt.goToAgentModel(from);
				}

				if (Ext.isEmpty(Ext.getCmp('osname').getStore().data.items))
				{
					Ext.getCmp('osname').hide();
					Ext.getCmp('osnameContainer').hide();
					if (!hideProcedure)
					{
						Ext.getCmp('emptyMsg').update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+'. <br/><a href="javascript:appCnt.helpbutton()">'+downloadAgentEmptyMsg2+' <span src="/final/images/spacer.gif" class="iconClickHere" style="display:inline-block;vertical-align: text-bottom;" border="0"></span> '+downloadAgentEmptyMsg3+'.</a></div></div>'); 
					}
					else
					{
						Ext.getCmp("emptyMsg").update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+". <br/>"+downloadAgentEmptyMsg4+".</div></div>");
					}
					Ext.getCmp('emptyMsg').show();
					if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
					{
						Ext.getCmp('WhatNextObj').hide();
					}
				}
				else
				{
					Ext.getCmp('osname').show();
					Ext.getCmp('osnameContainer').show();
					Ext.getCmp('WhatNextObj').show();
				}
			}
		});
	},
	
	loadAgentsBasedOnCategory : function()
	{
		Ext.getCmp('osname').getStore().clearFilter();
		Ext.getCmp('osname').getStore().sort('valueField', 'ASC');
		var category = Ext.getCmp('agentType').getValue();

		appCnt.goToAgentModel("");

		if (category != null && category != 'All')
		{
			Ext.getCmp('osname').getStore().filter('category',category);
			if (category == 'Windows')
			{
				Ext.getCmp('osname').getStore().sort('valueField', 'DESC');
			}
		}
		Ext.get('emptyMsg').hide();
		if (Ext.isEmpty(Ext.getCmp('osname').getStore().data.items))
		{
			Ext.getCmp('osname').hide();
			Ext.getCmp('osnameContainer').hide();
			if (!hideProcedure)
			{
				Ext.getCmp('emptyMsg').update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+'. <br/><a href="javascript:appCnt.helpbutton()">'+downloadAgentEmptyMsg2+' <span src="/final/images/spacer.gif" class="iconClickHere" style="display:inline-block;vertical-align: text-bottom;" border="0"></span> '+downloadAgentEmptyMsg3+'.</a></div></div>'); 
			}
			else
			{
				Ext.getCmp("emptyMsg").update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+". <br/>"+downloadAgentEmptyMsg4+".</div></div>");
			}
			Ext.getCmp('emptyMsg').show();
			if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
			{
				Ext.getCmp('WhatNextObj').hide();
			}
		}
		else
		{
			Ext.getCmp('osname').show();
			Ext.getCmp('osnameContainer').show();
			Ext.getCmp('WhatNextObj').show();
		}
	},
	
	goToAgentModel :  function(agentModel)
	{
		if (!Ext.isEmpty(agentModel))
		{
			Ext.getCmp('agentType').setValue('All');
			fromAgentModel = agentModel;
		}
		else
		{
			agentModel = fromAgentModel;
		}
		
		if (agentModel != null && agentModel == 'External')
		{
			Ext.getCmp('main').setTitle('<div><a href="javascript:void(0)" onclick="javascript:appCnt.backbutton()"> <img src="/final/images/spacer.gif" class="aIconBackArrow" style="display:'+hideback+';"/> </a>'+''+externalAgentTitle+' <img src="/final/images/spacer.gif" class="iconInfoCircle" style="vertical-align:middle" id="homeTitle"></div>');
			appCnt.boxready("External");

			Ext.getCmp('agentModel').update('<ul><li class="aPanelMsg">'+agentModelDesc1+' <a class="aPanelMsgLinkText" id="listOfServers" onclick="javascript:appCnt.openListOfServersWin(\'External\')">'+agentModelDesc4+'</a> '+agentModelDesc5+'.</li><li class="aPanelRegularText" style="margin:10px 0px 10px 0px;">'+agentModelLink+' <a class="aPanelHighlightText aLinkBottomBorder" href="javascript:void(0)"  onclick="javascript:appCnt.goToAgentModel(\'Internal\')">'+agentbasedMonitoring+'</a> '+agentModelLink3+' <a class="aPanelHighlightText aLinkBottomBorder" href="javascript:void(0)"  onclick="javascript:appCnt.goToAgentModel(\'Remote\')">'+agentlessMonitoring+'</a> '+agentModelLink4+'.</li></ul>');

			if (!hasVMLink)
			{
				Ext.getCmp('dockMsg').show();
			}
			
			
			Ext.getCmp('osname').getStore().clearFilter();
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					if (item.get('category').indexOf('Windows') != -1 || item.get('displayField').indexOf('Linux') != -1)
					{
						return true
					}
				}
			});
			Ext.getCmp('osname').getStore().filter(userFilter);
			Ext.getCmp('osname').getStore().each(function(rec) {
				Ext.getCmp('osname').getStore().remove(Ext.getCmp('osname').getStore().findRecord("folder","VM"));
			});

			if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
			{
				Ext.getCmp('WhatNextObj').destroy();
			}

			Ext.getCmp('mainCont').add({
				xtype: 'WhatNext',
				id:'WhatNextObj',
			});

			Ext.getCmp('whatNextText').update('<div class="whatNextHeader">'+whatNextTitle+'</div><div><ol class="listDefault"><li>'+downloadAgentExternalWhatNext+'.</li></ol></div>');
			Ext.getCmp('WhatNextObj').setWidth(250);
			Ext.getCmp('WhatNextObj').setHeight(120);
		}
		else if (agentModel != null && agentModel == 'Remote')
		{
			Ext.getCmp('main').setTitle('<div><a href="javascript:void(0)" onclick="javascript:appCnt.backbutton()"> <img src="/final/images/spacer.gif" class="aIconBackArrow" style="display:'+hideback+';"/> </a>'+''+remoteAgentTitle+' <img src="/final/images/spacer.gif" class="iconInfoCircle" style="vertical-align:middle" id="homeTitle"></div>');
			appCnt.boxready("Remote");

			Ext.getCmp('agentModel').update('<ul><li class="aPanelMsg">'+agentModelDesc1+' <a class="aPanelMsgLinkText" id="listOfServers" onclick="javascript:appCnt.openListOfServersWin(\'Remote\')">'+agentModelLink5+'</a> '+agentModelLink6+'.</li><li class="aPanelRegularText" style="margin:10px 0px 10px 0px;">'+agentModelLink+' <a class="aPanelHighlightText aLinkBottomBorder" href="javascript:void(0)"  onclick="javascript:appCnt.goToAgentModel(\'Internal\')">'+agentbasedMonitoring+'</a> '+agentModelLink3+' <a class="aPanelHighlightText aLinkBottomBorder" href="javascript:void(0)" onclick="javascript:appCnt.goToAgentModel(\'External\')">'+externalMonitoring+'</a> '+agentModelLink2+'.</li></ul>');

			if (!hasVMLink)
			{
				Ext.getCmp('dockMsg').show();
			}
			
			Ext.getCmp('osname').getStore().clearFilter();
			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					if (item.get('category').indexOf('Windows') != -1 || item.get('displayField').indexOf('Linux') != -1)
					{
						return true;
					}
				}
			});
			Ext.getCmp('osname').getStore().filter(userFilter);
			Ext.getCmp('osname').getStore().each(function(rec) {
				Ext.getCmp('osname').getStore().remove(Ext.getCmp('osname').getStore().findRecord("folder","VM"));
			});

			if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
			{
				Ext.getCmp('WhatNextObj').destroy();
			}

			Ext.getCmp('mainCont').add({
				xtype: 'WhatNext',
				id:'WhatNextObj',
			});

			Ext.getCmp('whatNextText').update('<div class="whatNextHeader">'+whatNextTitle+'</div><div><ol class="listDefault"><li>'+downloadAgentRemoteWhatNext1+'.</li><br><li><a class="whatNextLink"  href="https://www.eginnovations.com/product/agentless-monitoring" target="_blank">'+downloadAgentRemoteWhatNext2+'.</a></li></ol></div>');

			Ext.getCmp('WhatNextObj').setWidth(250);
			Ext.getCmp('WhatNextObj').setHeight(170);
		}
		else if (agentModel != null && agentModel == 'Internal')
		{
			Ext.getCmp('main').setTitle('<div><a href="javascript:void(0)" onclick="javascript:appCnt.backbutton()"> <img src="/final/images/spacer.gif" class="aIconBackArrow" style="display:'+hideback+';"/> </a>'+''+internalAgentTitle+' <img src="/final/images/spacer.gif" class="iconInfoCircle" style="vertical-align:middle" id="homeTitle"></div>');
			appCnt.boxready("Internal");

			Ext.getCmp('agentModel').update('<ul><li class="aPanelMsg" >'+agentModelDesc1+' <a class="aPanelMsgLinkText" id="listOfServers" onclick="javascript:appCnt.openListOfServersWin(\'Internal\')">'+agentModelDesc2+'</a> '+agentModelDesc3+'.</li><li class="aPanelRegularText" style="margin:10px 0px 10px 0px;">'+agentModelLink+' <a class="aPanelHighlightText aLinkBottomBorder" href="javascript:void(0)"  onclick="javascript:appCnt.goToAgentModel(\'Remote\')">'+agentlessMonitoring+'</a> '+agentModelLink1+' <a class="aPanelHighlightText aLinkBottomBorder" href="javascript:void(0)" onclick="javascript:appCnt.goToAgentModel(\'External\')">'+externalMonitoring+'</a> '+agentModelLink2+'.</li></ul>');

			if (!hasVMLink)
			{
				Ext.getCmp('dockMsg').show();
			}
			
			Ext.getCmp('osname').getStore().clearFilter();
			Ext.getCmp('osname').getStore().loadRawData(publicJSON.listOfOS);

			Ext.getCmp('osname').getStore().each(function(rec) {
				Ext.getCmp('osname').getStore().remove(Ext.getCmp('osname').getStore().findRecord("folder","VM"));
			});

			if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
			{
				Ext.getCmp('WhatNextObj').destroy();
			}

			Ext.getCmp('mainCont').add({
				xtype: 'WhatNext',
				id:'WhatNextObj',
			});

			Ext.getCmp('whatNextText').update('<div class="whatNextHeader">'+whatNextTitle+'</div><div><ol class="listDefault"><li>'+downloadAgentWhatNext1+'.</li><br><li><a class="whatNextLink" href="https://www.eginnovations.com/product/universal-monitoring-agent" target="_blank">'+downloadAgentWhatNext2+'.</a></li></ol></div>');

			Ext.getCmp('WhatNextObj').setWidth(250);
			Ext.getCmp('WhatNextObj').setHeight(140);
		}
		else if (agentModel != null && agentModel == 'VM')
		{
			Ext.getCmp('main').setTitle('<div><a href="javascript:void(0)" onclick="javascript:appCnt.backbutton()"> <img src="/final/images/spacer.gif" class="aIconBackArrow" style="display:'+hideback+';"/> </a>'+''+vmAgentTitle+' <img src="/final/images/spacer.gif" class="iconInfoCircle" style="vertical-align:middle" id="homeTitle"></div>');
			appCnt.boxready("VM");

			Ext.getCmp('agentModel').update('<ul><li class="aPanelMsg">'+agentModelLink7+'.</li><li class="aPanelRegularText" style="margin:10px 0px 10px 0px;">'+agentModelLink+' <a class="aPanelHighlightText aLinkBottomBorder" href="javascript:void(0)"  onclick="javascript:appCnt.goToAgentModel(\'Internal\')">'+agentbasedMonitoring+'</a> '+agentModelLink8+', <a class="aPanelHighlightText aLinkBottomBorder" href="javascript:void(0)"  onclick="javascript:appCnt.goToAgentModel(\'Remote\')">'+agentlessMonitoring+'</a> '+agentModelLink1+' <a class="aPanelHighlightText aLinkBottomBorder" href="javascript:void(0)" onclick="javascript:appCnt.goToAgentModel(\'External\')">'+externalMonitoring+'</a> '+agentModelLink2+'.</li></ul>');
			Ext.getCmp('dockMsg').hide();
		
			Ext.getCmp('osname').getStore().clearFilter();
			Ext.getCmp('osname').getStore().loadRawData(publicJSON.listOfOS);
			Ext.getCmp('osname').getStore().sort('displayField', 'ASC');

			var userFilter = new Ext.util.Filter({
				filterFn: function(item) {
					if (item.get('displayField').indexOf('VM') != -1)
					{
						return true
					}
				}
			});
			Ext.getCmp('osname').getStore().filter(userFilter);
			
			if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
			{
				Ext.getCmp('WhatNextObj').destroy();
			}

			Ext.getCmp('mainCont').add({
				xtype: 'WhatNext',
				id:'WhatNextObj',
			});

			Ext.getCmp('whatNextText').update('<div class="whatNextHeader">'+whatNextTitle+'</div><div class="newFont_normal11"><ol class="listDefault"><li>'+downloadAgentVMWhatNext+'.</li></ol></div>');
			Ext.getCmp('WhatNextObj').setWidth(250);
			Ext.getCmp('WhatNextObj').setHeight(120);
		}

		Ext.getCmp('WhatNextObj').show();

		if (Ext.isEmpty(Ext.getCmp('osname').getStore().data.items))
		{
			Ext.getCmp('osname').hide();
			Ext.getCmp('osnameContainer').hide();
			if (!hideProcedure)
			{
				Ext.getCmp('emptyMsg').update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+'. <br/><a href="javascript:appCnt.helpbutton()">'+downloadAgentEmptyMsg2+' <span src="/final/images/spacer.gif" class="iconClickHere" style="display:inline-block;vertical-align: text-bottom;" border="0"></span> '+downloadAgentEmptyMsg3+'.</a></div></div>'); 
			}
			else
			{
				Ext.getCmp("emptyMsg").update('<div class="emptyMsgDiv"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+downloadAgentEmptyMsg1+". <br/>"+downloadAgentEmptyMsg4+".</div></div>");
			}
			Ext.getCmp('emptyMsg').show();
			if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
			{
				Ext.getCmp('WhatNextObj').hide();
			}
		}
		else
		{
			Ext.getCmp('osname').show();
			Ext.getCmp('osnameContainer').show();
			Ext.getCmp('emptyMsg').hide();
			Ext.getCmp('WhatNextObj').show();
		}
	},

	openListOfServersWin : function(typeOfAgent)
	{
		Ext.Ajax.request({
			url : 'DownloadAgentPack/data/EgServerListJson.jsp?typeOfAgent='+typeOfAgent,
			success: function(response)
			{
				var publicServerJSON = Ext.decode(response.responseText);
				var tmpCount = parseInt(publicServerJSON['generalSettings']['configuredServersCount']);
				serverData = publicServerJSON['generalSettings']['configuredServersList'];
			
				var agentTitle = serverListWinTitleAgentbased;
				var pageDesc = serverListWinPageDescAgentbased+".";
				if (typeOfAgent == 'Remote')
				{
					agentTitle = serverListWinTitleAgentless;
					pageDesc = serverListWinPageDescAgentless+".";
				}
				else if (typeOfAgent == 'External')
				{
					agentTitle = serverListWinTitleExternal;
					pageDesc = serverListWinPageDescExternal+".";
				}

				Ext.create('Ext.window.Window', {
					title: "<span style='text-transform:none;'>"+agentTitle+"</span>",
					modal:true,
					ui:'newPopupWindow newplainHeader_border popupWindowBlueHeader', 
					ghost:false,
					id:'listOfServWindow',
					closeAction:'destroy',
					height:500,
					width: 900,
					border:true,
					bodyPadding:0,
					header:{
						padding:'12 0',
						margin:'0 20 0 20',
					},
					layout: {
						type: 'vbox',
						align: 'center',
						pack: 'start'
					},
					listeners: {
						show: function(h) {
							if (this.modal) {
								var g = Ext.dom.Query.select(".x-mask");
								for (var f in g) {
									this.dom = g[f];
									if (!Ext.isEmpty(this.dom.offsetParent)) {
										if (this.dom.offsetParent.tagName == "BODY") {
											Ext.fly(this.dom).addCls("windowModal");
										}
									}
								}
							}
						},
						hide: function(f) {
							if (this.modal) {
								Ext.fly(this.dom).removeCls("windowModal");
							}
						},
						afterrender: function() {
							Ext.EventManager.onWindowResize(function() {
								var f = this;
								f.center();
							}, this);
						}
					},
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							flex: 1,
							margin: '0 20 20 20',
							items : [
								{
									xtype: 'container',
									border:true,
									bodyPadding:'0px',
									margin: '10 0 10 0',
									hidden: false,
									html: "<div class='aPanelMsg'>"+pageDesc+"</div>"
								},
								{
									xtype: 'dataview',
									id : 'selectedServerListGrid',
									layout: 'fit',
									data: serverData,
									emptyText: "<div style='margin:15% auto auto auto'><table border='0' width='100%'><tr><td align='center' valign='middle'><div class='gen-info size32 color-info'></div><div class='commonErrorMsgText' id=\"userDeferMessage\" >"+emptyMsg+"</div></td></tr></table></div>",
									viewConfig: {
										deferEmptyText: false
									},
									flex: 1,
									padding:'0 10 10 0',
									scroll:true,
									autoScroll : true,
									hidden: false,
									tpl: [             
										'<ul>',
											'<tpl for="this.merge(values)">',
												'<tpl for="row">',
													'<li>',
														'<div class="aCurveOuterBorder" style="margin:0px 0px 15px 0px;display:inline-table;width:100%;">',
															'<div class="aContainerHeaderText" style="padding:15px 10px 4px 20px;">{title}</div>',
															'<div style="padding:9px 0px 9px 0px;display:inline-table;width:100%;">',
																'<tpl for="subcat">',
																	'<div class="appListDivRow">',
																		'<tpl for=".">',
																			'<div class="aNewLineRight nowrapText" style="float:left;padding:5px 10px 4px 20px;width:33%;" {[this.getqtip(values.displayField)]}> {[this.truncate(values.displayField, 26)]} </div>',
																		'</tpl>',
																	'</div>',
																'</tpl>',
															'</div>',
														'</div>',
													'</li>',
												'</tpl>',
											'</tpl>',
										'</ul>',
										{
											merge: function(a1)
											{
												var len = a1.length;
												for(var i=0, arr=[]; i<len; i++)
												{
													for(var k=0;k<a1.length;k++)
													{
														if (Ext.Object.getKeys(a1[k])[0] != 'title')
														{
															a1[k].title = Ext.Object.getKeys(a1[k])[0];
															a1[k].value =  Ext.Object.getValues(a1[k])[0];
														}
													}
													var chunks = [];

													a1[i]['value'].forEach(function (item) {
														if (!chunks.length || chunks[chunks.length - 1].length == 3)
															chunks.push([]);
														chunks[chunks.length - 1].push(item);
													});
													a1[i]['subcat'] = chunks;
													arr.push({ row: a1[i] });
												}
												return arr;
											},
											truncate : function (fullStr, strLen, separator) {
												if (fullStr.length <= strLen) return fullStr;
												
												separator = separator || '...';
												
												var sepLen = separator.length,
													charsToShow = strLen - sepLen,
													frontChars = Math.ceil(charsToShow/2),
													backChars = Math.floor(charsToShow/2);
												
												return fullStr.substr(0, frontChars) + separator + fullStr.substr(fullStr.length - backChars);
											},
											getqtip : function(displayField)
											{
												if (!Ext.isEmpty(displayField) && displayField != '&nbsp;')
												{
													return "data-qtip='"+displayField+"'";
												}
												else
												{
													return "";
												}
											}
										}
									]
								}
							]
						}
					],
					tools: [
						{
							xtype: 'trigger',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							//cls:'whitedropdown_search',
							cls:'aSearch',
							id: 'gridSearch',
							name: 'gridSearch',
							emptyText: searchEmptyText,
							margin:'10 20 10 10',
							getTriggerMarkup: function() {
								var me = this,
									i = 0,
									hideTrigger = (me.readOnly || me.hideTrigger),
									triggerCls,
									triggerBaseCls = me.triggerBaseCls,
									triggerConfigs = [],
									unselectableCls = Ext.dom.Element.unselectableCls,
									style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
									cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}

								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
								return Ext.DomHelper.markup(triggerConfigs);
							},
							onTrigger1Click : function() {
								this.reset();
								Ext.getCmp('selectedServerListGrid').show();
							},
							onTrigger2Click : function() {
								appCnt.mainGridSearch(typeOfAgent);
							},
							listeners : {
								change : function()
								{
									appCnt.mainGridSearch(typeOfAgent);
								},
								'render': function(cmp) 
								{ 
									cmp.getEl().on('click', function(){
										cmp.focus(200,true)
									}); 
								}
							}
						}
					],
					resizable:false,
					layout: 'fit',
				}).show();
			}
		});
	},

	boxready:function(agentDesc){
		var agentTypeDescMsg = '';
		if (!Ext.isEmpty(agentDesc))
		{
			if (agentDesc == 'Remote')
			{
				agentTypeDescMsg = remoteAgentDesc;
			}
			else if (agentDesc == 'External')
			{
				agentTypeDescMsg = externalAgentDesc;
			}
			else if (agentDesc == 'VM')
			{
				agentTypeDescMsg = vmAgentDesc;
			}
			else
			{
				agentTypeDescMsg = internalAgentDesc;
			}
		}
		new Ext.ToolTip({
			target:document.getElementById("homeTitle"),anchor:"top",
			anchorOffset:42,
			mouseOffset:[-55,0],
			dismissDelay:60000,
			html:agentTypeDescMsg,
			cls:"adminInfoTooltip"
		});
	},
	
	WhatNextClose :function()
	{
		if (!Ext.isEmpty(Ext.getCmp('WhatNextObj')))
		{
			Ext.getCmp('WhatNextObj').hide();
		}
	},

	mainGridSearch : function(typeOfAgent)
	{
		var gridsearch = Ext.getCmp('gridSearch').getValue();

		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		var selectedServerListGrid = Ext.getCmp('selectedServerListGrid');
		
		Ext.Ajax.request({
			url : 'DownloadAgentPack/data/EgServerListJson.jsp?typeOfAgent='+typeOfAgent+'&keywordsearch='+gridsearch,
			success: function(response)
			{
				var publicServerJSON = Ext.decode(response.responseText);
				var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
				var tmpCount = parseInt(publicServerJSON['generalSettings']['configuredServersCount']);
				serverData = publicServerJSON['generalSettings']['configuredServersList'];
				if (!Ext.isEmpty(serverData))
				{
					selectedServerListGridObj.update(serverData);
				}
				else
				{
					selectedServerListGridObj.update('<div class="emptyText"><div class="gen-info size32 color-info"></div><div align="center" class="commonErrorMsgText">'+emptyMsg+'</div></div>');
				}
			}
		});
	},

	backbutton: function()
	{
		var queryStr = '';
		if (!Ext.isEmpty(fromWizard))
		{
			queryStr = "?fromWizard="+fromWizard;
		}
		if (isCompView != null && isCompView == "true")
		{
			window.location.href = "/final/admin/EgDispServer.jsp"+queryStr;
		}
		else
		{
			if (from != null && from == "External")
			{
				window.location.href = "/final/admin/EgExternalAgents.jsp"+queryStr;
			}
			else if (from != null && from == "Remote")
			{
				window.location.href = "/final/admin/EgRemoteAgents.jsp"+queryStr;
			}
			else
			{
				window.location.href = backHref;
			}
		}
	},


	downloadAgentPack : function(osname,folder,agentVersion,displayField)
	{
		var AgentToBeConfigured = '';
		if (fromAgentModel == null || Ext.isEmpty(fromAgentModel))
		{
			AgentToBeConfigured = 'Internal';
		}
		else if (fromAgentModel == 'VM')
		{
			AgentToBeConfigured = 'Internal';
		}
		else
		{
			AgentToBeConfigured = fromAgentModel;
		}
		var downloadUtils =  Ext.widget('DownloadUtils');
		var urlStr = '../servlet/com.eg.AgentDownloadServlet?from='+encodeURIComponent(AgentToBeConfigured)+'&os='+osname+'&folder='+folder+'&agentVersion='+agentVersion+'&unzipit=false&issueUID=yes';
		downloadUtils.download(urlStr,displayField);
	}
});



