Ext.define('EgAddUser.controller.Main',{
	extend:'Ext.app.Controller',
	requires : [
		'EgAddUser.view.FileUpload',
		'EgAddUser.view.UserFormContainer',
		'EgAddUser.view.ShiftsPicker',
		'EgAddUser.view.ElementAssociationForm',
		'EgAddUser.view.EgMailAlertSuppress',
		'EgAddUser.view.UserGridPanel',
		'Ext.ux.form.MultiSelectSI',
		'Ext.ux.form.ItemSelectorSI',		
		'utilities.ScrollCombo',
	],
	views:['Main','EmptyPanel','ComponentGroupedSummaryGrid','EgDomainGroupTree','ConfigureComponentTypes'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'fileupload', ref:'fileupload'},
		{selector:'userformcontainer', ref:'userformcontainer'},
		{selector:'userformcontainer #domainName', ref:'domainName'},
		{selector:'userformcontainer #uname', ref:'uname'},
		{selector:'userformcontainer #eGShiftPeriods', ref:'shifPeroidsCt'},
		{selector:'userformcontainer #validate', ref:'btnValidate'},
		{selector:'elementassociationform', ref:'elementassociationform'},
		{selector:'egmailalertsuppress', ref:'egmailalertsuppress'},
		{selector:'shiftspicker', ref:'shiftspicker'},
		{selector:'configurecomponenttypes', ref:'configurecomponenttypes'}
	],
	init:function(){
		appCnt = this;
		this.buildMainData();
		this.control({
			'main':
			{
				'boxready':this.afterMainRender
			},
			'main button[id="backButton"]':
			{
				'click':this.goBack
			},
			'main button[id="cloneUser"]':
			{
				'click':this.cloneExistingUser
			},
			'userformcontainer combo[id="userModel"]':
			{
				'select':this.onUserModelChange
			},
			'userformcontainer combo[id="utype"]':
			{
				'select':this.onUserTypeChange
			},
			'userformcontainer radiogroup[id="userAuth"]':
			{
				'change':this.authenticationMode
			},
			'userformcontainer radiogroup[id="userAuthSAML"]':
			{
				'change':this.authenticationMode
			},
			'userformcontainer button[id="validate"]':
			{
				'click':this.validateDomainIdpDetails
			},
			'userformcontainer radiogroup[id="rdoOperation"]':
			{
				'change':this.operationOnChange
			},
			'userformcontainer combo[id="domainName"]':
			{
				'select':this.domainSelect
			},
			'userformcontainer treepicker[id="org"]':
			{
				'select':this.onOrganizationChange
			},
			//'userformcontainer button[id="validate"]':
			//{
				//'click':this.validateDomainDetails
			//},
			'userformcontainer button[id="commandButton"]':
			{
				'click':this.showCommandInWindow
			},
			'userformcontainer radiogroup[id="alarmMsgMode"]':
			{
				'change':this.setMeasureInMailMode
			},
			'userformcontainer button[id="btnAddUser"]':
			{
				'click':this.submitUserDetails
			},
			'userformcontainer button[id="btnNext"]':
			{
				'click':this.moveTab
			},
			'userformcontainer button[id="btnPrev"]':
			{
				'click':this.movePreviousTab
			},
			'userformcontainer checkboxfield[id="chkuser"]':
			{
				'change':this.showAvailableUsers
			},
			'userformcontainer checkbox[id="Never"]':
			{
				'change':this.userValidityChange
			},
			'userformcontainer checkbox[id="logoCheck"]':
			{
				'change':this.logoConfiguration
			},
			'userformcontainer checkbox[id="high"]':
			{
				'change':this.showalarmRet
			},
			'userformcontainer checkbox[id="medium"]':
			{
				'change':this.showalarmRet
			},
			'userformcontainer checkbox[id="low"]':
			{
				'change':this.showalarmRet
			},
			'userformcontainer radiogroup[id="eGRemoteExec"]':
			{
				'change':this.eGRemoteExecution
			},
			'userformcontainer radiogroup[id="mailshift"]':
			{
				'change':this.loadMailShiftAlerts
			},
			'userformcontainer radiogroup[id="Execshift"]':
			{
				'change':this.loadCommandShiftAlerts
			},
			'userformcontainer radiogroup[id="smsshift"]':
			{
				'change':this.loadSMSShiftAlerts
			},
			'userformcontainer radiogroup[id="escshift"]':
			{
				'change':this.loadESCShiftAlerts
			},
			'userformcontainer combo[id="loginLogo1"]':
			{
				'select':this.loginLogoController
			},
			'userformcontainer combo[id="monitorLogo1"]':
			{
				'select':this.monitorLogoController
			},
			'userformcontainer combo[id="reporterLogo1"]':
			{
				'select':this.repLogoController
			},
			'userformcontainer combo[id="configLogo1"]':
			{
				'select':this.configLogoController
			},
			'fileupload #uploadUsrIcon':
			{
				'click':this.uploadUsrImage
			},
			'userformcontainer':
			{
				'tabchange':this.loadUserTab
			},
			'elementassociationform':
			{
				'afterrender':this.initUserElements
			},
			'egmailalertsuppress':
			{
				'afterrender':this.initUserMailConfigs
			},
			'elementassociationform combo[id="associate"]':
			{
				'select':this.associateOnChange
			},
			'elementassociationform checkbox[id="compAssociation"]':
			{
				'change':this.associateServerType
			},
			'elementassociationform combo[id="compType"]':
			{
				'select':this.getServerDetails
			},
			'elementassociationform button[id="apply"]':
			{
				'click':this.assignAndAddMore
			},
			'elementassociationform button[id="finish"]':
			{
				'click':this.submitUserElements
			},
			'elementassociationform button[id="btnViewElements"]':
			{
				'click':this.viewUserAssociatedElements
			},
			'egmailalertsuppress combo[id="filter"]':
			{
				'select':this.popFilterDetails
			},
			'egmailalertsuppress combo[id="CompTypes"]':
			{
				'select':this.popCompTypes
			},
			'egmailalertsuppress button[id="includeMore"]':
			{
				'click':this.assignAndAddMoreFilters
			},
			'egmailalertsuppress button[id="mailSubmit"]':
			{
				'click':this.submitUserFilterElements
			},
			'egmailalertsuppress button[id="btnViewFilters"]':
			{
				'click':this.viewFilteredElements
			},
			'userformcontainer textfield[id="uname"]':
			{
				'change':this.onCheck
			},
			'userformcontainer textfield[id="upass"]':
			{
				'change': this.passStrength
			},
			'userformcontainer radio[id="alarmNotifyNew"]':
			{
				change:this.setDDInMailMode
			},
			'configurecomponenttypes button[id="btnApply"]':
			{
				'click':this.applySeverChange
			}
		});
	},
	setDDInMailMode : function() {
		var typeVal = Ext.getCmp('alarmNotifyNew').getValue();
		if(typeVal == false || typeVal == 'false')
			Ext.getCmp('detailsDiagnosisAlerts').setVisible(false);
		else
			Ext.getCmp('detailsDiagnosisAlerts').setVisible(true);
	},
	passStrength: function()
	{
		var pwdLength = publicJSON.pwdLength;
		var pwdComplexityCount = publicJSON.pwdComplexityCount;
		if (pwdLength == "" || pwdLength < 2)
		{
			pwdLength = 8;
		}
		else if(pwdLength != "" && pwdLength < pwdComplexityCount)
		{
			pwdLength = pwdComplexityCount;
		}
		var loginPassword = Ext.getCmp('upass').getValue();
		var regExp = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[^\da-zA-Z]).+$/;
		var regExp2 = /^(?=.*\d)(?=.*[a-zA-Z])(?=.*[^\da-zA-Z]).+$/;
		var regExp3 = /^(?=.*\d)(?=.*[a-zA-Z]).+$/;
		if (loginPassword.length >= pwdLength && regExp.test(loginPassword))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Strong);
		}
		else if(loginPassword.length >= pwdLength && loginPassword.match(regExp2))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Good);
		}
		else if(loginPassword.length >= pwdLength && loginPassword.match(regExp3))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Fair);
		}
		else if (loginPassword.length == 0)
		{
			Ext.getCmp('passScore').setText(passLabel1+" "+pwdLength+" "+passLabel2);
		}
		else
		{
			Ext.getCmp('passScore').setText(passStr+': '+Weak);
		}
	},
	pwdComplexityCheck : function(loginPassword)
	{
		var _start = "^";
		var _mid = "";
		var _end = ".+$";
		var result = "";
		var dot = ".";
		var brk = "<br/>";
		var pwdComplexity = publicJSON.pwdComplexity;
		if(pwdComplexity != null && pwdComplexity != undefined)
		{
			if(pwdComplexity.indexOf(",") > -1)
			{
				result = "false#";
				var pwdComplexVal = pwdComplexity.split(",");
				for(var k=0; k<pwdComplexVal.length; k++)
				{
					var temp = pwdComplexVal[k].toLowerCase().trim();
					if(temp == "lc")
					{
						_mid += "(?=.*[a-z])";
						result += brk+(k+1)+dot+" "+userIDValidationMsg69;
					}
					else if(temp == "uc")
					{
						_mid += "(?=.*[A-Z])";
						result += brk+(k+1)+dot+" "+userIDValidationMsg70;
					}
					else if(temp == "dg")
					{
						_mid += "(?=.*[0-9])";
						result += brk+(k+1)+dot+" "+userIDValidationMsg71;
					}
					else if(temp == "sp")
					{
						_mid += "(?=.*[^0-9a-zA-Z])";
						result += brk+(k+1)+dot+" "+userIDValidationMsg72;
					}
				}
			}
			else
			{
				result = "false#";
				var temp = pwdComplexity.toString().toLowerCase().trim();
				if(temp == "lc")
				{
					_mid += "(?=.*[a-z])";
					result += userIDValidationMsg69;
				}
				else if(temp == "uc")
				{
					_mid += "(?=.*[A-Z])";
					result +=  userIDValidationMsg70;
				}
				else if(temp == "dg")
				{
					_mid += "(?=.*[0-9])";
					result +=  userIDValidationMsg71;
				}
				else if(temp == "sp")
				{
					_mid += "(?=.*[^0-9a-zA-Z])";
					result +=  userIDValidationMsg72;
				}
			}
			var regExp = new RegExp(_start + _mid + _end);
			if(regExp.test(loginPassword))
			{
				result = "true";
			}
		}
		return result;
	},
	onCheck: function()
	{
		var Username = Ext.getCmp('uname').getValue();
		var hiddenFields = publicJSON.hiddenFields;
		var usname = hiddenFields.username1;
		if(Username !=null && Username!="")
		{
			var userCheckEg = Ext.getCmp('eGAuth').getValue();
			if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
			{
				if (Ext.getCmp('idpAuthSAML').getValue() == true)
				{
					userCheckEg = true;
				}
				else if (Ext.getCmp('eGAuthSAML').getValue() == true)
				{
					userCheckEg = true;
				}
			}
			if(usname!=null && usname!="" && userCheckEg == true )
			{
				var myarr = usname.split("|hash|");
				if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
				{
					if (Ext.getCmp('idpAuthSAML').getValue() == true)
					{
						var idpName = Ext.getCmp('idpName').getValue();
						Username = 'samlsso/'+idpName+'/'+Username;
					}
				}
				if( Ext.Array.contains(myarr,Username) || Ext.Array.contains(myarr,Username.toLowerCase()) ||
					Ext.Array.contains(myarr,Username.toUpperCase()))
				{
					Ext.getCmp('userImage').update('<center><img src="/final/images/spacer.gif" class="iconWrong" style="cursor:pointer;" border="0" width="15" height="10" data-qtip="User ID already exists" data-qclass="yellowtip"></center>')
				}
				else
				{
					Ext.getCmp('userImage').update('<center><img src="/final/images/spacer.gif" class="iconRight" style="cursor:pointer;" border="0" width="15" height="10" data-qtip="User ID available" data-qclass="yellowtip"></center>')
				}
				Ext.getCmp('userImage').show();
			}
		}
		else
		{
			Ext.getCmp('userImage').hide();
		}
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url : appURL,
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	getErrorMessageTemplate :function(tmpObj)
	{
		var tmpTable = '<div class="x-table" style="width:90%"><table cellspacing="0" width="100%" cellpadding="5" border="0" align="center"><thead><tr><th><div class="x-panel-header x-docked x-panel-header-default x-horizontal x-panel-header-horizontal x-panel-header-default-horizontal x-top x-panel-header-top x-panel-header-default-top x-docked-top x-panel-header-docked-top x-panel-header-default-docked-top x-unselectable"><span>'
		+errorTitle+' : '+pageIntnl75+'</span></div></td></tr></thead>'
		for (var key in tmpObj)
		{
			if (key == "title") continue ;
			var errorMessage = tmpObj[key];
			tmpTable = tmpTable + '<tr class="x-grid-row"><td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner" >'+errorMessage+'</div></td></tr>';
		}
		tmpTable = tmpTable + '</table></div>';
		return tmpTable;
	},
	cloneExistingUser : function()
	{
		window.location.href = "/final/admin/EgReplicateUser.jsp?fromWizard="+fromWizard;
	},
	getErrorTemplate :function()
	{
		 var tabledata = new Ext.XTemplate(
			'<div class="x-table" style="width:100%">', 
			'<table cellspacing="0" width="90%" cellpadding="5" border="0" align="center" class="x-grid-table" style="border: 1px #e1e1e1 solid;"><col width="20%"><col width="70%">', 
				'<thead>', 
					'<tr class="x-grid-row">', 
						'<th colspan="2" class="x-grid-cell">', 
							'<div><span><b class="font_bold">'+pageIntnl75+'</b></span></div>', 
						'</th>', 
					'</tr>', 
				'</thead>', 
			'<tbody>', 
			'<tpl for=".">', 
				'<tr class="x-grid-row">', 
					'<td class=" x-grid-cell x-grid-cell-first">', 
						'<div class="x-grid-cell-inner" ><b>'+pageIntnl76+'</b></div>', 
					'</td>', 
					'<td class=" x-grid-cell x-grid-cell-first" style="border-left:0px" >', 
						'<div class="x-grid-cell-inner" >{ERROR}</div>', 
					'</td>', 
				'</tr>',
				'<tr class="x-grid-row">', 
					'<td class=" x-grid-cell">', 
						'<div class="x-grid-cell-inner"><b>'+pageIntnl77+'</b></div>', 
					'</td>', 
					'<td class="x-grid-cell" style="border-left:0px">', 
						'<div class="x-grid-cell-inner" >{DESCRIPTION}</div>', 
					'</td>', 
				'</tr>',
				'<tr class="x-grid-row">', 
					'<td class="x-grid-cell">', 
						'<div class="x-grid-cell-inner"><b>'+pageIntnl78+'</b></div>', 
					'</td>', 
					'<td class=" x-grid-cell" style="border-left:0px">', 
						'<div class="x-grid-cell-inner" >{RESOLUTION}</div>', 
					'</td>', 
				'</tr>', 
			'</tpl>', 
			'</tbody>', 
			'</table>', 
			'</div>'
		);
		return tabledata;
	},
	setMeasureInMailMode : function(obj)
	{
		var selectedVal = obj.getValue().msgmode;
		var measure_in_mail_mode = Ext.getCmp('measure_in_mail_mode');
		var tmpData = publicJSON['measure_in_mail_mode'];
		if (selectedVal == "H")
		{
			measure_in_mail_mode.getStore().loadRawData(tmpData);
			measure_in_mail_mode.setValue(measure_in_mail_mode.getStore().getAt(0).get("valueField"));
			
		}
		else
		{
			measure_in_mail_mode.getStore().loadRawData(tmpData);
			measure_in_mail_mode.setValue(measure_in_mail_mode.getStore().getAt(0).get("valueField"));
			measure_in_mail_mode.getStore().removeAt(1);
		}
	},
	userValidityChange : function(obj,newValue,oldValue,eOpts)
	{
		var tmptilldateObj = Ext.getCmp('tmptilldate');
		var validity = obj.getValue();
		if (validity == true)
		{
			//tmptilldateObj.setValue("");
			tmptilldateObj.setDisabled(true);
		}
		else
		{
			tmptilldateObj.setDisabled(false);
		}
	},
	showAvailableUsers : function(obj,newValue,oldValue,eOpts)
	{
		var showUsers = obj.getValue();
		var userAssociateObj = Ext.getCmp('availusers');
		if (showUsers == true)
		{
			userAssociateObj.show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y);
		}
		else
		{
			userAssociateObj.hide();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y);
		}
	},
	submitUserElements : function()
	{
		var tmpURL = "EgAddUser/data/EgusersiteserverspJson.jsp?date="+new Date().getTime();
		var me = this;
		me.associateValue('finish');
		var hiddenFieldsKeys = userElementJSON['hiddenFields'];
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var thisForm = this.getElementassociationform().getForm();
		//var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating please wait...'});
		//myMask.show();
		if (thisForm.isValid())
		{
			this.getElementassociationform().submit({
				url: tmpURL+'&'+hiddenFields,
				method: 'POST',
				//standardSubmit: true,
				success: function(form, action){
					//me.showResultQBox(action.response.responseText);
					me.showUserAddForm();
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					//me.showResultQBox(action.response.responseText);
					me.showUserAddForm();
				}
			});
		}
	},
	submitUserFilterElements : function(obj)
	{
		var me = this;
		obj.setDisabled(true);
		var filterBy = Ext.getCmp('filter').getValue();
		var tmpURL = "EgAddUser/data/EgMailAlertSuppresspJson.jsp?reqfrom=add&userID="+encodeURIComponent(username);
		if(username == "-1")
		{
			Ext.MessageBox.alert("Mail Filter","Please choose a user id");
			return;
		}
		if(username != "-1")
		{
			me.setFilterValues("finish");
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			//var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating please wait...'});
			//myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL+'&'+hiddenFields,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						//myMask.hide();
						//me.showResultQBox(action.response.responseText);
						me.showUserAddForm();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						//myMask.hide();
						//me.showResultQBox(action.response.responseText);
						me.showUserAddForm();
					}
				});
			}
		}
		obj.setDisabled(false);
	},
	assignAndAddMoreFilters : function(obj)
	{
		var me = this;
		obj.setDisabled(true);
		var userID = "raju";
		var filterBy = Ext.getCmp('filter').getValue();
		var tmpURL = "EgAddUser/data/EgMailAlertSuppresspJson.jsp?reqfrom=add&userID="+encodeURIComponent(username);
		if(userID == "-1")
		{
			Ext.MessageBox.alert("Mail Filter","Please choose a user id");
			return;
		}
		if(userID != "-1" && filterBy != "-1")
		{
			me.setFilterValues("addMore");
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL+'&'+hiddenFields,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						//var url = "EgAddUser/data/EgMailAlertSuppressJson.jsp?userID="+encodeURIComponent(username)+"&reqfrom=add&date="+new Date().getTime();
						//me.updateUserMailSuppressList(url);
						//me.updateFilterResultPanel();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
						//var url = //"EgAddUser/data/EgMailAlertSuppressJson.jsp?userID="+encodeURIComponent(username)+"&reqfrom=add&date="+new Date().getTime();
						//me.updateUserMailSuppressList(url);
						//me.updateFilterResultPanel();
					}
				});
			}
		}
		obj.setDisabled(false);
	},
	showUserAddForm : function()
	{
		var selectedUserType = Ext.getCmp('utype').getValue();
		window.location.href = "EgAddUser.jsp?qctr=1&usertype="+encodeURIComponent(selectedUserType)+"&fromWizard="+fromWizard;
	},
	assignAndAddMore : function()
	{
		var tmpURL = "EgAddUser/data/EgusersiteserverspJson.jsp?date="+new Date().getTime();
		var me = this;
		me.associateValue('apply');
		var hiddenFieldsKeys = userElementJSON['hiddenFields'];
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var thisForm = this.getElementassociationform().getForm();
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		if (thisForm.isValid())
		{
			this.getElementassociationform().submit({
				url: tmpURL+'&'+hiddenFields,
				method: 'POST',
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					/*var utype = Ext.getCmp('utype').getValue();
					var associateELValue = Ext.getCmp('associate').getValue();
					var url = "EgAddUser/data/EgUserSiteServersJson.jsp?qctr=1&assousers="+encodeURIComponent(assousers)+"&username="+encodeURIComponent(username)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom=add&utype="+utype+"&associate="+encodeURIComponent(associateELValue);
					if (associateELValue == "Independent servers")
					{
						var componentType = Ext.getCmp('associate').getValue();
						url = url + "&compType="+encodeURIComponent(componentType);
					}
					me.updateUserElementPage(url);
					me.updateResultPanel();*/
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
				}
			});
		}
	},
	setFilterValues : function(cntValue)
	{
		var hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer');
		var tmpStore = Ext.getCmp('exclude');
		var arrInc = new Array();
		var arrExc = new Array();
		var fromStore = tmpStore.fromField.store;
		var toStore = tmpStore.toField.store;
		for(var z = 0;z<fromStore.getCount();z++)
		{
			var tmpVal = fromStore.getAt(z).get("valueField");
			arrExc.push(tmpVal);
		}

		for(var z = 0;z<toStore.getCount();z++)
		{
			var tmpVal = toStore.getAt(z).get("valueField");
			arrInc.push(tmpVal);
		}
		if(userMailJSON['excludedBoxHostVal'] && userMailJSON['excludedBoxHostVal'] != undefined)
		{
			var valueHost =userMailJSON['excludedBoxHostVal'];
			if(valueHost !=null && valueHost != "")
			{
				arrExc[arrExc.length] = valueHost;
			}
		}
		var includedBoxVal = {
			xtype : 'hiddenfield',
			name : 'includedBoxVal',
			value : arrInc
		}
		var excludedBoxVal = {
			xtype : 'hiddenfield',
			name : 'excludedBoxVal',
			value : arrExc
		}
		var tmpActionObj = {
			xtype : 'hiddenfield',
			name : 'control',
			value : cntValue
		}
		hiddenFieldsContainerObj.removeAll();
		hiddenFieldsContainerObj.add(includedBoxVal);
		hiddenFieldsContainerObj.add(excludedBoxVal);
		hiddenFieldsContainerObj.add(tmpActionObj);
	},
	associateValue : function(actionMethod)
	{
		var elementassociationformObj = Ext.getCmp('elementassociationform');
		var elementsHiddenContainerObj = Ext.getCmp('elementsHiddenContainer');
		elementsHiddenContainerObj.removeAll();
		var associateObj = Ext.getCmp('associate');
		var tmpStore = Ext.getCmp('otherHosts');
		var marray = new Array();
		var fromStore = tmpStore.fromField.store;
		for(var z = 0;z<fromStore.getCount();z++)
		{
			var tmpVal = fromStore.getAt(z).get("valueField");
			marray.push(tmpVal);
		}
		var chosenHosts = {
			xtype : 'hiddenfield',
			name : 'chosenHosts',
			value : marray
		}
		var tmpActionObj = {
			xtype : 'hiddenfield',
			name : 'action',
			value : actionMethod
		}
		elementsHiddenContainerObj.add(chosenHosts);
		elementsHiddenContainerObj.add(tmpActionObj);
		var majorType = associateObj.getValue();
		if (!(majorType=="Segment") || (majorType == "Service"))
		{
			if (majorType == "Zone")
			{
				var dbArray = new Array();
				for(var i=0; i<fromStore.getCount();i++)
				{
					var tmpVal = fromStore.getAt(i).get("valueField");
					dbArray[i] = ",Zone:"+tmpVal;
				}
				var permanentAssociation = {
					xtype : 'hiddenfield',
					name : 'permanentAssociation',
					value : dbArray
				}
				elementsHiddenContainerObj.add(permanentAssociation);
			}
			else
			{
				var permanentAssociation = {
					xtype : 'hiddenfield',
					name : 'permanentAssociation',
					value : Ext.getCmp('compType').getValue()
				}
				elementsHiddenContainerObj.add(permanentAssociation);
			}
		}
	},
	getServerDetails : function(obj)
	{

		var me = this;
		var selectedComponent = obj.getValue();
		var associate = Ext.getCmp('associate').getValue();
		var url = "EgAddUser/data/EgUserSiteServersJson.jsp?qctr=1&assousers="+encodeURIComponent(assousers)+"&username="+encodeURIComponent(username)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom=add&utype="+utype+"&associate="+encodeURIComponent(associate)+"&compType="+encodeURIComponent(selectedComponent)+"&date="+new Date().getTime();
		me.updateUserElementPage(url);
		var tmpStore = Ext.getCmp('otherHosts');
		var associatedItems = userElementJSON['associatedItems'];
		var disAssociatedItems = userElementJSON['disAssociatedItems'];
		tmpStore.getStore().removeAll();
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		if (!Ext.isEmpty(associatedItems))
		{
			//tmpStore.getStore().loadRawData(associatedItems);
			tmpStore.fromField.store.add(associatedItems);
		}
		if (!Ext.isEmpty(disAssociatedItems))
		{
			tmpStore.toField.store.add(disAssociatedItems);
		}
	},
	associateServerType : function(obj)
	{
		if (obj.getValue() == true)
		{
			var tmpStore = Ext.getCmp('otherHosts');
			var toStore = tmpStore.toField.store;
			var fromStore = tmpStore.fromField.store;
			//tmpStore.getStore().loadRawData(associatedItems);
			//tmpStore.fromField.store.add(disAssociatedItems);
			//tmpStore.fromField.store.loadData(toStore,true)
			for(var z = 0;z<toStore.getCount();z++)
			{
				var tmpVal = toStore.getAt(z);
				tmpStore.fromField.store.add(tmpVal);
			}
			tmpStore.toField.store.removeAll();
		}
	},
	associateOnChange : function(obj)
	{
		var me = this;
		var selectedValue = obj.getValue();
		if (selectedValue == "-1")
		{
			var tmpStore = Ext.getCmp('otherHosts');
			Ext.getCmp('compType').hide();
			Ext.getCmp('compAssociation').hide();
			tmpStore.getStore().removeAll();
			if(tmpStore.fromField.store.getCount() > 0)
			{
				tmpStore.fromField.store.removeAll();
			}
			if(tmpStore.toField.store.getCount() > 0)
			{
				tmpStore.toField.store.removeAll();
			}
		}
		else
		{
			var url = "EgAddUser/data/EgUserSiteServersJson.jsp?qctr=1&assousers="+encodeURIComponent(assousers)+"&username="+encodeURIComponent(username)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom=add&utype="+utype+"&associate="+encodeURIComponent(selectedValue)+"&date="+new Date().getTime();
			me.updateUserElementPage(url);
			var associatedItems = userElementJSON['associatedItems'];
			var disAssociatedItems = userElementJSON['disAssociatedItems'];
			var toTitle = userElementJSON['toTitle'];
			var fromTitle = userElementJSON['fromTitle'];
			var tmpStore = Ext.getCmp('otherHosts');
			tmpStore.fromField.getComponent(0).setTitle(toTitle);
			tmpStore.toField.getComponent(0).setTitle(fromTitle);
			if (selectedValue == "Independent servers")
			{
				var tmpStoreObj = Ext.getCmp('compType');
				var compAssociation = Ext.getCmp('compAssociation');
				tmpStoreObj.getStore().loadRawData(userElementJSON['componentTypes']);
				tmpStoreObj.setValue(tmpStoreObj.getStore().getAt(0).get("valueField"));
				tmpStoreObj.show();
				//compAssociation.show();
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(associatedItems))
				{
					//tmpStore.getStore().loadRawData(associatedItems);
					tmpStore.fromField.store.add(associatedItems);
				}
				if (!Ext.isEmpty(disAssociatedItems))
				{
					tmpStore.toField.store.add(disAssociatedItems);
				}
			}
			else if (selectedValue == "Segment")
			{
				Ext.getCmp('compType').hide();
				Ext.getCmp('compAssociation').hide();
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(associatedItems))
				{
					//tmpStore.getStore().loadRawData(associatedItems);
					tmpStore.fromField.store.add(associatedItems);
				}
				if (!Ext.isEmpty(disAssociatedItems))
				{
					tmpStore.toField.store.add(disAssociatedItems);
				}
			}
			else if (selectedValue == "Zone")
			{
				Ext.getCmp('compType').hide();
				Ext.getCmp('compAssociation').hide();
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(associatedItems))
				{
					//tmpStore.getStore().loadRawData(associatedItems);
					tmpStore.fromField.store.add(associatedItems);
				}
				if (!Ext.isEmpty(disAssociatedItems))
				{
					tmpStore.toField.store.add(disAssociatedItems);
				}
			}
			else if (selectedValue == "Service")
			{
				Ext.getCmp('compType').hide();
				Ext.getCmp('compAssociation').hide();
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(associatedItems))
				{
					//tmpStore.getStore().loadRawData(associatedItems);
					tmpStore.fromField.store.add(associatedItems);
				}
				if (!Ext.isEmpty(disAssociatedItems))
				{
					tmpStore.toField.store.add(disAssociatedItems);
				}
			}
			else if (selectedValue == "ServiceGroup")
			{
				Ext.getCmp('compType').hide();
				Ext.getCmp('compAssociation').hide();
				tmpStore.getStore().removeAll();
				//alert(tmpStore.getStore().getCount())
				//alert("1-->"+tmpStore.fromField.store.getCount())
				//alert("2-->"+tmpStore.toField.store.getCount())
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(associatedItems))
				{
					//tmpStore.getStore().loadRawData(associatedItems);
					tmpStore.fromField.store.add(associatedItems);
				}
				if (!Ext.isEmpty(disAssociatedItems))
				{
					tmpStore.toField.store.add(disAssociatedItems);
				}
			}
		}
	},
	uploadUsrImage : function()
	{
		var me = this;
		var fileExt = 'gif/jpg/jpeg/png';
		var isUpload=false;
		var fileObj = Ext.getCmp('FILE_0');
		var fileName = fileObj.getValue();
		var fileExtension = fileName.substring((fileName.lastIndexOf('.'))+1,fileName.length);

		if(!validateSingleByte(fileObj.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg61+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}

		if (fileExtension.toLowerCase() != 'gif' && fileExtension.toLowerCase() != 'jpg' && fileExtension.toLowerCase() != 'jpeg' && fileExtension.toLowerCase() != 'png')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg62+": '" +fileExt+ "'"+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}

		var nameStr = "FILE_0_dstFile";
		var valueStr = filePath;
		valueStr = valueStr.replace(".gif","."+fileExtension);

		var fileuploadObj = Ext.getCmp('hiddenFieldsContainer');
		fileuploadObj.removeAll();
		var tmpHiddenElement = {
			xtype: 'hiddenfield',
			name : 'FILE_0_dstFile',
			value : valueStr
		}
		fileuploadObj.add(tmpHiddenElement);
		var me = this;
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Uploading...'});
		myMask.show();
		var userForm = this.getFileupload().getForm();
		fileUploadURI = fileUploadURI.replace("fileExt=gif","fileExt="+fileExtension);
		if (userForm.isValid())
		{
			this.getFileupload().submit({
				url: fileUploadURI,
				method: 'POST',
				success: function(form, action){
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg65+".",
						buttons: Ext.Msg.OK,
						icon: 'iconInformation'
					});
					myMask.hide();
					me.updateImageStatus();
					Ext.getCmp('fileUpLoader').destroy();
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					Ext.getCmp('fileUpLoader').destroy();
				}
			});
		}
	},
	updateImageStatus : function()
	{
		var fileUpLoaderEx = Ext.getCmp('fileUpLoader');
		if (fileUpLoaderEx.getCurrentUploaderInfo() == "login")
		{
			isLoginImgUpdated = true;
		}
		else if (fileUpLoaderEx.getCurrentUploaderInfo() == "monitor")
		{
			isAdminMonImgUpdated = true;
		}
		else if (fileUpLoaderEx.getCurrentUploaderInfo() == "reporter")
		{
			isRepImgUpdated = true;
		}
		else if (fileUpLoaderEx.getCurrentUploaderInfo() == "config")
		{
			isConfigImgUpdated = true;
		}
	},
	monitorLogoController : function(obj)
	{
		var selectedOption = obj.getValue();
		var logoObj = Ext.getCmp('monitorLogoIMG');
		if (selectedOption == "show")
		{
			logoObj.show();
		}
		else
		{
			logoObj.hide();
		}
	},
	loginLogoController : function(obj)
	{
		var selectedOption = obj.getValue();
		var logoObj = Ext.getCmp('loginLogoIMG');
		if (selectedOption == "show")
		{
			logoObj.show();
		}
		else
		{
			logoObj.hide();
		}
	},
	repLogoController : function(obj)
	{
		var selectedOption = obj.getValue();
		var logoObj = Ext.getCmp('reporterLogoIMG');
		if (selectedOption == "show")
		{
			logoObj.show();
		}
		else
		{
			logoObj.hide();
		}
	},
	configLogoController : function(obj)
	{
		var selectedOption = obj.getValue();
		var logoObj = Ext.getCmp('configLogoIMG');
		if (selectedOption == "show")
		{
			logoObj.show();
		}
		else
		{
			logoObj.hide();
		}
	},
	loadMailShiftAlerts : function(obj)
	{
		var selectedOption = obj.getValue().mailshift;
		if (selectedOption == 'yes')
		{
			var isMailValid = true;
			var tmpVal1 = Ext.getCmp('tomailid').getValue();
			var tmpVal2 = Ext.getCmp('ccmailid').getValue();
			var tmpVal3 = Ext.getCmp('bccmailid').getValue();
			var tmpVal4 = Ext.getCmp('escmailid').getValue();

			var toMailResult=validateEmail(tmpVal1);
			var ccMailResult=validateEmail(tmpVal2);
			var bccMailResult=validateEmail(tmpVal3);
			var escMailResult=validateEmail(tmpVal4);

			if(tmpVal1 =="" && tmpVal3 =="" && tmpVal2 =="")
			{
				isMailValid = false;
			}
			
			if((tmpVal1 !="" && toMailResult == false) || (tmpVal3 != "" && bccMailResult == false) || (tmpVal2 != "" && ccMailResult == false))
			{
				var flag1 = validateMailID(tmpVal1);
				var flag2 = validateMailID(tmpVal3);
				var flag3 = validateMailID(tmpVal2);

				if(!flag1 && !flag2 && !flag3)
				{
					isMailValid = false;
				}
			}
			if(!isMailValid)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg23+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				Ext.getCmp('emailAlert_1').setValue(true);
				return false;
			}
			Ext.getCmp('emailMailAlert').show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
		}
		else
		{
			Ext.getCmp('emailMailAlert').hide();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
		}
	},
	loadCommandShiftAlerts : function(obj)
	{
		var selectedOption = obj.getValue().Execshift;
		if (selectedOption == 'yes')
		{
			var toCmd = Ext.getCmp('customScript');
			if (toCmd.getValue() == null || toCmd.getValue() == "")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg40+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				Ext.getCmp('shiftAlert_1').setValue(true);
				return false;
			}
			else if(!checkspecial(toCmd.getValue(),"@*+=[]|;\"\'<>?~`"))
			{
				toCmd.focus(true);
				Ext.getCmp('shiftAlert_1').setValue(true);
				return false;
			}
			Ext.getCmp('commandAlert').show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
		}
		else
		{
			Ext.getCmp('commandAlert').hide();
			//if (!Ext.getCmp('commandAlert').isHidden())
			//{
				Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
			//}
		}
	},
	loadSMSShiftAlerts : function(obj)
	{
		var regExp1=/^(\+\d\d)?[0-9]+$/g;

		var selectedOption = obj.getValue().smsshift;
		if (selectedOption == 'yes')
		{
			var isValidMobileNo = true;
			var tmpVal1 = Ext.getCmp('tomailid').getValue();
			var tmpVal2 = Ext.getCmp('ccmailid').getValue();
			var tmpVal3 = Ext.getCmp('bccmailid').getValue();
			var tmpVal4 = Ext.getCmp('escmailid').getValue();

			var toMobResult=(tmpVal1).match(regExp1);
			var ccMobResult=(tmpVal2).match(regExp1);
			var bccMobResult=(tmpVal3).match(regExp1);
			var escMobResult=(tmpVal4).match(regExp1);

			if(tmpVal1 =="" && tmpVal3 =="" && tmpVal2 =="")
			{
				isValidMobileNo = false;
			}
			
			if((tmpVal1 !="" && toMobResult!=tmpVal1) || (tmpVal3 != "" && bccMobResult!=tmpVal3) || (tmpVal2 != "" && ccMobResult!=tmpVal2))
			{
				var flag1 = validateMobileNo(tmpVal1);
				var flag2 = validateMobileNo(tmpVal3);
				var flag3 = validateMobileNo(tmpVal2);

				if(!flag1 && !flag2 && !flag3)
				{
					isValidMobileNo = false;
				}
			}
			if(!isValidMobileNo)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg26+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				Ext.getCmp('smsAlert_1').setValue(true);
				return false;
			}
			Ext.getCmp('smsAlert').show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
		}
		else
		{
			Ext.getCmp('smsAlert').hide();
			//if (!Ext.getCmp('smsAlert').isHidden())
			//{
				Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
			//}
		}
	},
	loadESCShiftAlerts : function(obj)
	{
		var regExp1=/^(\+\d\d)?[0-9]+$/g;
		var reg3 = /(((([\+]?([0-9]){4,15})|([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])+)\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z])|((\+\d\d)?[0-9]+))/g

		var selectedOption = obj.getValue().escshift;
		if (selectedOption == 'yes')
		{
			var escMail = Ext.getCmp('escmailid').getValue();
			var escshiftNo = Ext.getCmp("escshiftNo");
			var escMailResult=validateEmail(escMail);
			var escMobResult=(escMail).match(regExp1);
			var escResult=(escMail).match(reg3);

			if (escMail != null && escMail == '' && !checkmultiplemailid(escMail))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg28+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				Ext.getCmp('escAlert_1').setValue(true);
				return false;
			}
			
			if ((escMail != "") && (escMailResult==null || escMailResult==false) && escMobResult  == null && escResult != escMail )
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg22+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('escmailid').focus(true);
					}
				});
				Ext.getCmp('escAlert_1').setValue(true);
				return false;
			}
			Ext.getCmp('escMailAlert').show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
		}
		else
		{
			Ext.getCmp('escMailAlert').hide();
			//if (!Ext.getCmp('escMailAlert').isHidden())
			//{
				Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
			//}
		}
	},
	eGRemoteExecution : function(obj,newValue,oldValue,eOpts)
	{
		var remotecontrol = obj.getValue().remotecontrol;
		if (remotecontrol == "true")
		{
			Ext.getCmp('execcommands').show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y);
		}
		else
		{
			Ext.getCmp('execcommands').hide();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y);
		}
	},
	configureMailAlert : function(isChecked)
	{
		if (isChecked == true)
		{
			Ext.getCmp('high').setValue(true);
			Ext.getCmp('medium').setValue(true);
			Ext.getCmp('low').setValue(true);
			Ext.getCmp('frmAlarmContainer').show();
		}
		else
		{
			Ext.getCmp('high').setValue(false);
			Ext.getCmp('medium').setValue(false);
			Ext.getCmp('low').setValue(false);
			Ext.getCmp('frmAlarmContainer').hide();
		}
	},
	showalarmRet : function(obj,newValue,oldValue,eOpts)
	{
		var high = Ext.getCmp('high').getValue();
		var medium = Ext.getCmp('medium').getValue();
		var low = Ext.getCmp('low').getValue();
		if (high == true || medium == true || low == true)
		{
			Ext.getCmp('frmAlarmContainer').show();
			if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no')
			{
				Ext.getCmp('customScript').hide();
				Ext.getCmp('Execshift').hide();
			}
		}
		else
		{
			Ext.getCmp('frmAlarmContainer').hide();
		}
		Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('high').getBox().y - 200);
	},
	logoConfiguration : function(obj,newValue,oldValue,eOpts)
	{
		var repLogoContainer = Ext.getCmp('imgRepPage');
		var configLogoContainer = Ext.getCmp('imgConfigPage');
		var isConfigSupported = publicJSON['isConfigSupported'];
		if (obj.getValue() == true)
		{
			repLogoContainer.hide();
			configLogoContainer.hide();
		}
		else
		{
			if (isConfigSupported == true)
			{
				repLogoContainer.show();
				configLogoContainer.show();
			}
			else
			{
				repLogoContainer.show();
			}
		}
	},
	validateDomainDetails : function(obj)
	{
		var me = this;
		var selectedUserType = Ext.getCmp('utype').getValue();
		var authentication = Ext.getCmp('userAuth').getValue().authentication;
		if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
		{
			authentication = Ext.getCmp('userAuthSAML').getValue().authenticationSAML
		}
		var operation = Ext.getCmp('rdoOperation').getValue().operation;
		var unameObj = Ext.getCmp('uname');
		var uname = Ext.getCmp('uname').getValue();
		var selectedDomain = Ext.getCmp('domainName').getValue();

		var unameck = uname;
		var hiddenFields = publicJSON.hiddenFields;
		var usname = hiddenFields.username1;

		if(selectedUserType == 'none')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userRoleValidationMsg+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}

		if(selectedDomain == 'none')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userDomainValidationMsg+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		if(!checkblank(uname))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg2+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					Ext.getCmp('uname').focus(true);
				}
			});
			return;
		}
		else if(!checkSpecial(unameObj,"=\"/"))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _checkspecial,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function()
				{
					Ext.getCmp('uname').focus(true);
				}
			});
			return;
		}
		else if(trim(uname) == "")
		{
			Ext.getCmp('uname').focus(true);
			return;
		}
		else if (uname.indexOf("..") > -1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _checkdots+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					Ext.getCmp('uname').focus(true);
				}
			});
			return;
		}

		if(unameck !=null && unameck!="")
		{
			if(usname != null && usname!="")
			{
				var myarr = usname.split("|hash|");
				if (authentication == 'Domain')
					unameck= selectedDomain +"/"+unameck
				for (i=0;i<myarr.length;i++)
				{
					if(myarr[i].toLowerCase()==unameck.toLowerCase())
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: userIDValidationMsg+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn){
								Ext.getCmp('uname').focus(true);
							}
						});
						return;
					}
				}
			}
		}

		var urlString = "EgAddUser/data/EgAddUserJson.jsp?qctr=1&usertype="+encodeURIComponent(selectedUserType)+"&authentication="+authentication+"&operation="+encodeURIComponent(operation)+"&domain="+encodeURIComponent(selectedDomain)+"&uname="+encodeURIComponent(uname)+"&ldapPass="+encodeURIComponent(ldapPass)+"&date="+new Date().getTime();
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Validating...'});
		myMask.show();

		var resultJSONObj = '';
		Ext.Ajax.request({
			url : urlString,
			method: 'POST',
			//async: false,
			success: function(response)
			{
				resultJSONObj = Ext.decode(response.responseText);
				myMask.hide();
				if (resultJSONObj.requestStatus == "success")
				{
					obj.hide();
					Ext.getCmp('uname').setReadOnly(true);
					Ext.getCmp('userExpFieldContainer').show();
					Ext.getCmp('btnNext').show();
				}
				else
				{
					Ext.getCmp('btnNext').hide();
					var errorObj = resultJSONObj.errors;
					var errorMessageTemplate = me.getErrorTemplate();
					var message = errorMessageTemplate.apply(errorObj);
					//Ext.Msg.alert(pageIntnl76,tmp);
					me.showResultWindow(pageIntnl76,message);
				}
				resultJSONObj = '';
			},
			failure : function(response)
			{
				Ext.getCmp('btnNext').hide();
				myMask.hide();
			}
		});
	},
	domainSelect : function(obj)
	{
		var me = this;
		var selectedDomain = obj.getValue();
		if (selectedDomain != "none")
		{
			me.isPwdConfiguredWithSelectedDomain(selectedDomain);
			var operation = Ext.getCmp('rdoOperation').getValue().operation;
			if (operation == "Group")
			{
				var selectedUserType = Ext.getCmp('utype').getValue();
				var authentication = Ext.getCmp('userAuth').getValue().authentication;
				if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
				{
					authentication = Ext.getCmp('userAuthSAML').getValue().authenticationSAML
				}

				var urlString = "EgAddUser/data/EgAddUserJson.jsp?qctr=1&usertype="+encodeURIComponent(selectedUserType)+"&authentication="+authentication+"&operation="+encodeURIComponent(operation)+"&domain="+encodeURIComponent(selectedDomain)+"&ldapPass="+encodeURIComponent(ldapPass)+"&date="+new Date().getTime();
				me.updateUserPage(urlString);
				Ext.getCmp('grpname').setValue('  ----Click on the icon to select a group----  ');
			}
			else
			{
				me.resetUserOptions();
			}
		}
		else
		{
			Ext.getCmp('rdoOperation').getBoxes()[0].setValue(true);
		}
	},
	resetUserOptions : function()
	{
		Ext.suspendLayouts();
		Ext.getCmp('validate').show();
		Ext.getCmp('btnAddUser').hide();
		Ext.getCmp('btnPrev').hide();
		Ext.getCmp('btnNext').hide();
		Ext.getCmp('uname').setValue("");
		Ext.getCmp('uname').setReadOnly(false);
		Ext.getCmp('uname').show();
		Ext.getCmp('userCont').show();
		Ext.getCmp('grpnameCon').hide();
		Ext.getCmp('userExpFieldContainer').hide();
		Ext.resumeLayouts(true);
	},
	isPwdConfiguredWithSelectedDomain : function(selectedDomain)
	{
		var me = this;
		var params = "domainName="+selectedDomain+"&validatePwd=yes";
		var urlStr = "/final/servlet/com.egurkha.ADDomainAuth?"+params;
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var resObj = Ext.decode(response.responseText);
				if (resObj.isPasswordConfigured == false)
				{
					me.showAuthenticationWindow(resObj.domainName,resObj.domUser);
				}
			}
		});
	},
	viewUserAssociatedElements : function()
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			title : intnlLabel6,
			id:'userElementsWindow',
			width: '95%',
			height: 400,
			border : false,
			autoScroll:true,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			dockedItems: [{
				xtype: 'toolbar',
				id : 'dockedItem1',
				dock: 'top',
				items : [
					{
						xtype : 'tbfill'
					},
					{
						text : 'Expand All',
						cls : 'button20',
						handler : function()
						{
							var thisGrid = Ext.getCmp('componentgroupedsummarygrid');
							var groupingFeature = thisGrid.view.getFeature('componentGrouping');
							groupingFeature.expandAll();
						}
					},
					{
						text : 'Close All',
						cls : 'button20',
						handler : function()
						{
							var thisGrid = Ext.getCmp('componentgroupedsummarygrid');
							var groupingFeature = thisGrid.view.getFeature('componentGrouping');
							groupingFeature.collapseAll();
						}
					}
				],
			}],
			listeners : {
				afterrender : function()
				{
					var utype = Ext.getCmp('utype').getValue();
					var associateELValue = Ext.getCmp('associate').getValue();
					var url = "EgAddUser/data/EgUserSiteServersJson.jsp?qctr=1&assousers="+encodeURIComponent(assousers)+"&username="+encodeURIComponent(username)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom=add&utype="+utype+"&associate="+encodeURIComponent(associateELValue);
					if (associateELValue == "Independent servers")
					{
						var componentType = Ext.getCmp('associate').getValue();
						url = url + "&compType="+encodeURIComponent(componentType);
					}
					me.updateUserElementPage(url);
					me.updateResultPanel();
				}
			},
			items:[
				{
					xtype: 'container',
					id: 'userAssociationContainer',
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					margin: '10',
				}
			]
		}).show();
	},
	viewFilteredElements : function()
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			id:'userFilterWindow',
			width: '95%',
			height: 400,
			border : false,
			autoScroll:true,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					var title = filterMessage + ": "+username;
					Ext.getCmp('userFilterWindow').setTitle(title);
					var tmpUserID = Ext.getCmp('uname').getValue();
					var url = "EgAddUser/data/EgMailAlertSuppressJson.jsp?userID="+encodeURIComponent(tmpUserID)+"&reqfrom=add&date="+new Date().getTime();
					me.updateUserMailSuppressList(url);
					me.updateFilterResultPanel();
				}
			},
			items:[
				{
					xtype: 'container',
					id: 'userFilterContainer',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					defaults: {
						style: {
							padding: '10px'
						}
					},
				}
			]
		}).show();
	},
	showAuthenticationWindow : function(domainName,domUser)
	{
		Ext.widget("window",{
			title : pageIntnl79,
			id:'authWindow',
			width: 600,
			height: 170,
			modal : true,
			border : false,
			autoScroll:false,
			closeAction: 'destory',
			doClose: function() {
				Ext.getCmp("domainName").setValue("none");
				this.destroy();
			},
			buttonAlign : 'center',
			items:[
				{
					xtype : 'container',
					layout : {
						type : 'vbox',
						align : 'center',
						pack : 'center',
						padding : '6'
					},
					defaults: {
						labelAlign : 'top',
						labelSeparator : '',
						margin : '5'
					},
					items : [
						{
							xtype : 'displayfield',
							fieldLabel : '<b>Domain User</b>',
							width : 320,
							value : domainName + "\\" + domUser
						},
						{
							xtype:'textfield',
							id: 'userInput',
							cls: 'textbox',
							fieldLabel : '<b>Domain User\'s Password</b>',
							width : 320,
							inputType : 'password',
						}
					]
				}
			],
			buttons : [
				{
					text : 'Submit',
					cls : 'quickMenuWhiteButton',
					handler : function()
					{
						var userInput = Ext.getCmp('userInput').getValue();
						if (userInput == null || userInput == "" || userInput.length == 0)
						{
							Ext.Msg.show({
								title: pageTitle,
								msg: userIDValidationMsg7+".",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn : function(btn){
									Ext.getCmp('userInput').focus(true);
								}
							});
							return false;
						}
						ldapPass = userInput;
						Ext.getCmp('authWindow').destroy();
					}
				}
			]
		}).show();
	},
	operationOnChange : function(obj, newValue, oldValue, eOpts)
	{
		var me = this;
		var selectedDomain = Ext.getCmp('domainName').getValue();
		var operation = newValue.operation;
		if (operation == "User")
		{
			Ext.suspendLayouts();
			Ext.getCmp('validate').show();
			Ext.getCmp('btnAddUser').hide();
			Ext.getCmp('btnPrev').hide();
			Ext.getCmp('btnNext').hide();
			Ext.getCmp('uname').setValue("");
			Ext.getCmp('uname').setReadOnly(false);
			Ext.getCmp('uname').show();
			Ext.getCmp('userCont').show();
			Ext.getCmp('grpnameCon').hide();
			Ext.getCmp('userExpFieldContainer').hide();
			Ext.resumeLayouts(true);
		}
		else
		{
			if (selectedDomain == "none")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userDomainValidationMsg+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				Ext.getCmp('radioOperation1').setValue(true);
				return false;
			}

			Ext.getCmp('userExpFieldContainer').show();
			var selectedUserType = Ext.getCmp('utype').getValue();
			var authentication = Ext.getCmp('userAuth').getValue().authentication;
			if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
			{
				authentication = Ext.getCmp('userAuthSAML').getValue().authenticationSAML
			}

			var operation = Ext.getCmp('rdoOperation').getValue().operation;
			var selectedDomain = Ext.getCmp('domainName').getValue();

			var urlString = "EgAddUser/data/EgAddUserJson.jsp?qctr=1&usertype="+encodeURIComponent(selectedUserType)+"&authentication="+authentication+"&operation="+encodeURIComponent(operation)+"&domain="+encodeURIComponent(selectedDomain)+"&ldapPass="+encodeURIComponent(ldapPass)+"&date="+new Date().getTime();
			me.updateUserPage(urlString);

			Ext.suspendLayouts();
			Ext.getCmp('validate').hide();
			Ext.getCmp('btnAddUser').hide();
			Ext.getCmp('btnPrev').hide();
			Ext.getCmp('btnNext').show();
			Ext.getCmp('uname').hide();
			Ext.getCmp('userCont').hide();
			Ext.getCmp('grpname').setValue('  ----Click on the icon to select a group----  ');
			Ext.getCmp('grpnameCon').show();
			Ext.resumeLayouts(true);
		}
	},
	validateDomainIdpDetails : function(obj)
	{
		var me = this;
		var selectedUserType = Ext.getCmp('utype').getValue();
		var authentication = Ext.getCmp('userAuth').getValue().authentication;
		var operation = Ext.getCmp('rdoOperation').getValue().operation;
		var unameObj = Ext.getCmp('uname');
		var uname = Ext.getCmp('uname').getValue();
		var selectedDomain = Ext.getCmp('domainName').getValue();
		var selectedIdp = Ext.getCmp('idpName').getValue();
		var unamechk = uname;
		var hiddenFields = publicJSON.hiddenFields;
		var usname = hiddenFields.username1;

		if (!Ext.isEmpty(Ext.getCmp('userAuthSAML')) && Ext.getCmp('userAuthSAML').isVisible())
		{
			authentication = Ext.getCmp('userAuthSAML').getValue().authenticationSAML;
		}

		if(selectedUserType == 'none')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userRoleValidationMsg+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}

		if (authentication == 'Domain' && selectedDomain == 'none')
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userDomainValidationMsg+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		if (authentication == 'SAML' )
		{
			if (selectedIdp == 'none')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIdpValidationMsg+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}
			
			var samlUserName = Ext.getCmp('uname').getValue();
			if(!checkblank(samlUserName))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg2+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('uname').focus(true);
					}
				});
				return;
			}
		}

		if(!checkblank(uname))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg2+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					Ext.getCmp('uname').focus(true);
				}
			});
			return;
		}
		else if(!checkSpecial(unameObj,"=\"/\\"))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _checkspecial,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn: function()
				{
					Ext.getCmp('uname').focus(true);
				}
			});
			return;
		}
		else if(trim(uname) == "")
		{
			Ext.getCmp('uname').focus(true);
			return;
		}
		else if (uname.indexOf("..") > -1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _checkdots+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					Ext.getCmp('uname').focus(true);
				}
			});
			return;
		}

		if(unamechk !=null && unamechk!="")
		{
			if(usname != null && usname!="")
			{
				var myarr = usname.split("|hash|");
				if (authentication == 'Domain')
					unamechk= selectedDomain +"/"+unamechk
				else if (authentication == 'SAML')
					unamechk = 'samlsso/'+selectedIdp+"/"+unamechk
				
				for (i=0;i<myarr.length;i++)
				{
					if(myarr[i].toLowerCase() == unamechk.toLowerCase())
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: userIDValidationMsg+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn){
								Ext.getCmp('uname').focus(true);
							}
						});
						return;
					}
				}
			}
		}

		if (authentication == 'SAML')
		{
			obj.hide();
			Ext.getCmp('uname').setReadOnly(true);
			Ext.getCmp('userExpFieldContainer').show();
			Ext.getCmp('btnNext').show();
			return;
		}

		var urlString = "EgAddUser/data/EgAddUserJson.jsp?qctr=1&usertype="+encodeURIComponent(selectedUserType)+"&authentication="+authentication+"&operation="+encodeURIComponent(operation)+"&domain="+encodeURIComponent(selectedDomain)+"&uname="+encodeURIComponent(uname)+"&ldapPass="+encodeURIComponent(ldapPass)+"&date="+new Date().getTime();
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Validating...'});
		myMask.show();

		var resultJSONObj = '';
		Ext.Ajax.request({
			url : urlString,
			method: 'POST',
			//async: false,
			success: function(response)
			{
				resultJSONObj = Ext.decode(response.responseText);
				myMask.hide();
				if (resultJSONObj.requestStatus == "success")
				{
					obj.hide();
					Ext.getCmp('uname').setReadOnly(true);
					Ext.getCmp('userExpFieldContainer').show();
					Ext.getCmp('btnNext').show();
				}
				else
				{
					Ext.getCmp('btnNext').hide();
					var errorObj = resultJSONObj.errors;
					var errorMessageTemplate = me.getErrorTemplate();
					var message = errorMessageTemplate.apply(errorObj);
					//Ext.Msg.alert(pageIntnl76,tmp);
					me.showResultWindow(pageIntnl76,message);
				}
				resultJSONObj = '';
			},
			failure : function(response)
			{
				Ext.getCmp('btnNext').hide();
				myMask.hide();
			}
		});
	},
	authenticationMode : function(obj, newValue, oldValue, eOpts)
	{
		var me = this;
		var selectedUserType = Ext.getCmp('utype').getValue();
		var authen = newValue.authentication

		if (obj.id == 'userAuthSAML')
		{
			authen = newValue.authenticationSAML
		}
		var hasmonitoraccess = publicJSON['hasmonitoraccess'];
		var tmpUserObj = Ext.getCmp('uname');
		Ext.suspendLayouts();
		if (authen == "Eg")
		{
			Ext.getCmp('validate').hide();
			Ext.getCmp('btnAddUser').hide();
			Ext.getCmp('btnPrev').hide();
			Ext.getCmp('btnNext').show();
			Ext.getCmp('domainName').hide();
			Ext.getCmp('rdoOperation').hide();
			Ext.getCmp('uname').setReadOnly(false);
			Ext.getCmp('uname').show();
			Ext.getCmp('userCont').show();
			Ext.getCmp('upass').show();
			Ext.getCmp('pasCont').show();
			tmpUserObj.show();
			tmpUserObj.maxLength = 256;
			Ext.getCmp('confpasswd').show();
			Ext.getCmp('grpnameCon').hide();
			Ext.getCmp('idpName').hide();
			Ext.getCmp('userExpFieldContainer').show();
			document.getElementById("uname-inputEl").setAttribute("maxLength","256");
		}
		else if (authen == "SAML")
		{
			tmpUserObj.show();
			tmpUserObj.maxLength = 256;
			Ext.getCmp('idpName').show();
			Ext.getCmp('validate').hide();
			Ext.getCmp('uname').setReadOnly(false);
			
			Ext.getCmp('domainName').hide();
			Ext.getCmp('rdoOperation').hide();
			Ext.getCmp('grpnameCon').hide();
			Ext.getCmp('btnAddUser').hide();
			Ext.getCmp('btnPrev').hide();
			Ext.getCmp('btnNext').show();
			Ext.getCmp('upass').hide();
			Ext.getCmp('pasCont').hide();
			Ext.getCmp('confpasswd').hide();
			Ext.getCmp('userExpFieldContainer').show();
			var idps = Ext.getCmp('idpName');
			idps.getStore().loadRawData(publicJSON['idpList']);
			idps.setValue(idps.getStore().getAt(0).get("valueField"));
			document.getElementById("uname-inputEl").setAttribute("maxLength","156");
			
		}
		else
		{
			tmpUserObj.maxLength = 156;
			Ext.getCmp('btnAddUser').hide();
			Ext.getCmp('btnPrev').hide();
			Ext.getCmp('btnNext').hide();
			Ext.getCmp('validate').show();
			Ext.getCmp('domainName').show();
			Ext.getCmp('rdoOperation').show();
			Ext.getCmp('upass').hide();
			Ext.getCmp('pasCont').hide();
			tmpUserObj.show();
			Ext.getCmp('confpasswd').hide();
			Ext.getCmp('grpnameCon').hide();
			Ext.getCmp('userExpFieldContainer').hide();
			Ext.getCmp('radioOperation1').setValue(true);
			Ext.getCmp('idpName').hide();

			var domains = Ext.getCmp('domainName')
			domains.getStore().loadRawData(publicJSON['domainsList']);
			domains.setValue(domains.getStore().getAt(0).get("valueField"));
			document.getElementById("uname-inputEl").setAttribute("maxLength","156");
		}
		Ext.resumeLayouts(true);
		if (selectedUserType == "none")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userRoleValidationMsg+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		tmpUserObj.setValue("");
	},
	onUserTypeChange : function(obj)
	{
		var me = this;
		var selectedUserType = obj.getValue();
		if (Ext.isEmpty(selectedUserType))
		{
			selectedUserType = "none";
			obj.setValue("none");
		}
		var userformcontainerObj = Ext.getCmp('userformcontainer');

		var userModel = Ext.getCmp('userModel').getValue();
		if (!Ext.isEmpty(userModel) && userModel == '-1')
		{
			Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg75+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('userModel').focus(true,true);
						Ext.getCmp('utype').setValue("none");
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
		}
		else if (!Ext.isEmpty(userModel) && (userModel == 'SubOrganization' || userModel == 'User'))
		{
			var org = Ext.getCmp('org').getValue();
			if (org == "-1")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg74+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('org').focus(true,true);
						Ext.getCmp('utype').setValue("none");
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
		}

		if (selectedUserType == "none")
		{
			userformcontainerObj.child("#tab2").tab.setDisabled(true);
			return false;
		}
		isLoginImgUpdated = false;
		isAdminMonImgUpdated = false;
		isRepImgUpdated = false;
		isConfigImgUpdated = false;
		userformcontainerObj.child("#tab2").tab.setDisabled(false);
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		var org = Ext.getCmp('org').getValue();
		var urlString = "EgAddUser/data/EgAddUserJson.jsp?qctr=1&usertype="+encodeURIComponent(selectedUserType)+"&org="+encodeURIComponent(org)+"&date="+new Date().getTime();
		me.updateUserPage(urlString);
		me.loadUserControls(selectedUserType);
		myMask.hide();
	},
	loadUserControls : function(selectedUserType)
	{
		var urlString = "EgAddUser/data/EgAddUserJson.jsp?qctr=1&usertype="+encodeURIComponent(selectedUserType)+"&org="+encodeURIComponent(org)+"&date="+new Date().getTime();
		this.updateUserPage(urlString);
		inputs = 0;
		mailShiftPeriodsCount = 0;
		smsShiftPeriodsCount = 0;
		escShiftPeriodsCount = 0;
		ExecShiftPeriodsCount= 0;

		var me = this;
		Ext.getCmp('eGAuth').setValue(true);
		Ext.getCmp('radioOperation1').setValue(true);
		var hasmonitoraccess = publicJSON['hasmonitoraccess'];
		var hasAllComponentAccess = publicJSON['hasAllComponentAccess'];
		var loginLogo1 = Ext.getCmp('loginLogo1');
		var monitorLogo1 = Ext.getCmp('monitorLogo1');
		var reporterLogo1 = Ext.getCmp('reporterLogo1');
		var configLogo1 = Ext.getCmp('configLogo1');
		var timeZone = Ext.getCmp('timeZone');
		var userDataFormat = Ext.getCmp('userDataFormat');
		var timeOpt = Ext.getCmp('timeOpt');

		timeZone.getStore().loadRawData(publicJSON['timeZone']);
		if (publicJSON.selectedTimeZone == 'undefined' || publicJSON.selectedTimeZone == undefined)
		{
			timeZone.setValue(timeZone.getStore().getAt(0).get("valueField"));
		}
		else
		{
			timeZone.setValue(publicJSON['selectedTimeZone']);
		}
		userDataFormat.getStore().loadRawData(publicJSON['userDataFormat']);
		userDataFormat.setValue(publicJSON['selectedDateFormat']);
		var isDescEnabled = publicJSON['isDescEnabled'];
		if(isDescEnabled != null && isDescEnabled != undefined && isDescEnabled)
		{
			Ext.getCmp('description').setValue(publicJSON['description']);
			Ext.getCmp('description').show();
		}

		var mailSenders = Ext.getCmp('mailSenders'); // aruna - modified - start
		mailSenders.getStore().loadRawData(publicJSON['mailSenders']);
		mailSenders.setValue(mailSenders.getStore().getAt(0).get("valueField")); // aruna - modified - end

		if (hasmonitoraccess == true)
		{
			var monhomecombo = Ext.getCmp('monitorHomePage');
			var monitorHomePageSelection=Ext.getCmp('userProf_monitorHomeOpt');
			if(!Ext.isEmpty(monitorHomePageSelection))
			{
				monitorHomePageSelection.suspendEvents(false);
				monitorHomePageSelection.setValue({
					selectedMonHomeOpt: "Default"
				});
				monitorHomePageSelection.resumeEvents();
				monitorHomePageSelection.on('change',function(){
					var monitorHomeOptObj = monitorHomePageSelection.getChecked();
					var monitorHomeOpt = monitorHomeOptObj[0].inputValue;
					if(monitorHomeOpt!=null && monitorHomeOpt=='dynamic')
					{
						monhomecombo.getStore().removeAll();
						monhomecombo.getStore().loadRawData(publicJSON['monitoringDomains']);
						monhomecombo.setValue(publicJSON['selectedMonitorDomain']);
					}
					else
					{
						monhomecombo.getStore().removeAll();
						monhomecombo.getStore().loadRawData(publicJSON['monhomearray']);
						monhomecombo.setValue(publicJSON['monHomePage']);
					}
				});
			}
			var selectedMonHomePageOpt=publicJSON['selectedMonitorDomain'];
			if(monitorHomePageSelection!=null && monitorHomePageSelection=='dynamic')
			{
				monhomecombo.getStore().removeAll();
				monhomecombo.getStore().loadRawData(publicJSON['monitoringDomains']);
				monhomecombo.setValue(publicJSON['selectedMonitorDomain']);
			}
			else
			{
				monhomecombo.getStore().removeAll();
				monhomecombo.getStore().loadRawData(publicJSON['monhomearray']);
				monhomecombo.setValue(publicJSON['monHomePage']);
			}


			Ext.getCmp('monitorFieldsContainer').show();
			Ext.getCmp('mailsmsalerts').show();
			//var monitorHomePage = Ext.getCmp('monitorHomePage');
			var measure_in_mail_mode = Ext.getCmp('measure_in_mail_mode');
			//var timeOpt = Ext.getCmp('timeOpt');
			//var mailSenders = Ext.getCmp('mailSenders'); // aruna - modified
			var remoteEnabled = publicJSON['remoteEnabled'];
			var isShiftPeriodsEnabled = publicJSON['isShiftPeriodsEnabled'];

			var td = publicJSON['td'];
			if (isShiftPeriodsEnabled == true)
			{
				me.getShifPeroidsCt().show();
			}
			else
			{
				me.getShifPeroidsCt().hide();
			}

			if (remoteEnabled == false)
			{
				Ext.getCmp('eGRemoteExec').hide();
			}
			else
			{
				var execcommands = Ext.getCmp('execcommands');
				execcommands.getStore().loadRawData(publicJSON['execcommands']);
				execcommands.setValue(execcommands.getStore().getAt(0).get("valueField"));
				Ext.getCmp('eGRemoteExec').show();
			}
			//monitorHomePage.getStore().loadRawData(publicJSON['monitorHomePage']);
			//monitorHomePage.setValue(publicJSON['selectedMonitorHomePage']);

			measure_in_mail_mode.getStore().loadRawData(publicJSON['measure_in_mail_mode']);
			measure_in_mail_mode.setValue(measure_in_mail_mode.getStore().getAt(0).get("valueField"));

			var monitorHomeDisable = publicJSON['monitorHomeDisable'];
			if (monitorHomeDisable == "disabled")
			{
				monhomecombo.setDisabled(true);
			}
			else
			{
				monhomecombo.setDisabled(false);
			}
			//timeOpt.getStore().loadRawData(publicJSON['chgTimeOpt']);
			//timeOpt.setValue(publicJSON['chgTimeOptSeleted']);
			//mailSenders.getStore().loadRawData(publicJSON['mailSenders']);
			//mailSenders.setValue(mailSenders.getStore().getAt(0).get("valueField")); // aruna - modified

			var mailFilterObj = Ext.getCmp('mail_filter_optionGrp');
			if (publicJSON.isFilterControlEnabled == true)
			{
				mailFilterObj.show();
				mailFilterOption = publicJSON.filterControlDefaultSelection;
				if (mailFilterOption == "Descriptors_Only")
				{
					Ext.getCmp("mail_filter_option2").setValue(true);
				}
				else
				{
					Ext.getCmp("mail_filter_option1").setValue(true);
				}
			}
			else
			{
				mailFilterObj.hide();
			}

			Ext.getCmp('availusers').hide();
			Ext.getCmp('autoassociatetousers').hide();
			Ext.getCmp('selectedServerListGrid').hide();

			var hasAllCompAccess = publicJSON['hasAllCompAccess'];
			var isShareRole = publicJSON['isShareRole'];
			var userModel = Ext.getCmp('userModel').getValue();
			if (hasAllCompAccess == false)
			{
				//if (isEnterpriseModel)
				//{
					//Ext.getCmp('selectedServerListGrid').show();
				//}
				//else
				{
					if (!Ext.isEmpty(userModel) && userModel == 'User')
					{
						if (!Ext.isEmpty(isShareRole) && isShareRole == false)
						{
							Ext.getCmp('selectedServerListGrid').show();
						}
						else
						{
							Ext.getCmp('selectedServerListGrid').hide();
						}
					}
					else if (!Ext.isEmpty(userModel) && userModel == 'SubOrganization')
					{
						Ext.getCmp('selectedServerListGrid').show();
					}
					else
					{
						Ext.getCmp('selectedServerListGrid').hide();
					}
				}
			}
			else
			{
				Ext.getCmp('selectedServerListGrid').hide();
			}

			if (td == true)
			{
				Ext.getCmp('chkuser').show();
				if (!Ext.isEmpty(userModel) && userModel == 'User')
				{
					if (!Ext.isEmpty(isShareRole) && isShareRole == false)
					{
						Ext.getCmp('autoassociatetousers').show();
						Ext.getCmp('availusers').getStore().loadRawData(publicJSON['availusers']);
					}
					else
					{
						Ext.getCmp('autoassociatetousers').hide();
					}
				}
				else
				{
					Ext.getCmp('autoassociatetousers').hide();
				}
				//Ext.getCmp('autoassociatetousers').show();
				//Ext.getCmp('availusers').getStore().loadRawData(publicJSON['availusers']);
			}
			else
			{
				Ext.getCmp('autoassociatetousers').hide();
			}
		}
		else
		{
			Ext.getCmp('monitorFieldsContainer').hide();
			Ext.getCmp('mailsmsalerts').hide();
			Ext.getCmp('autoassociatetousers').hide();
			Ext.getCmp('selectedServerListGrid').hide();
		}

		var hasReporterTab  = publicJSON['hasReporterTab'];
		var  hasMemReporterChek =publicJSON['hasMemReporterChek'];
		if (hasReporterTab == false || hasMemReporterChek == false)
		{
			timeOpt.getStore().removeAll();
			Ext.getCmp('reporterTimeLine').hide();
		}
		else
		{
			timeOpt.getStore().loadRawData(publicJSON['chgTimeOpt']);
			timeOpt.setValue(publicJSON['chgTimeOptSeleted']);
			Ext.getCmp('reporterTimeLine').show();
		}

		var tmpLogoArr = publicJSON['logoArr'];
		loginLogo1.getStore().loadRawData(tmpLogoArr);
		loginLogo1.setValue(loginLogo1.getStore().getAt(0).get("valueField"));

		monitorLogo1.getStore().loadRawData(tmpLogoArr);
		monitorLogo1.setValue(monitorLogo1.getStore().getAt(0).get("valueField"));

		var logoCheck = Ext.getCmp('logoCheck');
		logoCheck.hide();
		if(selectedUserType != null && selectedUserType != "AlarmViewer" && selectedUserType != "SuperAlarmViewer")
		{
			logoCheck.show();
			reporterLogo1.getStore().loadRawData(tmpLogoArr);
			reporterLogo1.setValue(reporterLogo1.getStore().getAt(0).get("valueField"));

			var isConfigSupported = publicJSON['isConfigSupported'];
			var configLogoContainer = Ext.getCmp('configLogoContainer');
			if (isConfigSupported == true)
			{
				configLogo1.getStore().loadRawData(tmpLogoArr);
				configLogo1.setValue(configLogo1.getStore().getAt(0).get("valueField"));
				var applyToOtherModule = Ext.getCmp('logoCheck').getValue();
				if (applyToOtherModule == true)
				{
					Ext.getCmp('imgRepPage').hide();
					Ext.getCmp('imgConfigPage').hide();
				}
				else
				{
					Ext.getCmp('imgConfigPage').show();
				}
			}
			else
			{
				Ext.getCmp('imgConfigPage').hide();
			}
		}
		else
		{
			Ext.getCmp('imgRepPage').hide();
			Ext.getCmp('imgConfigPage').hide();
		}
	},
	goBack : function()
	{
		if (backHref.indexOf('?') != -1)
		{
			backHref += "&fromWizard="+fromWizard;
		}
		else
		{
			backHref += "?fromWizard="+fromWizard;
		}
		window.location.href = backHref;
	},
	afterMainRender:function()
	{
		if (reqfrom != 'navlink')
		{
			Ext.getCmp('backButton').show();
		}

		var isSAMLLoginEnabled = publicJSON.isSAMLLoginEnabled
		
		if (!Ext.isEmpty(isSAMLLoginEnabled) && isSAMLLoginEnabled)
		{
			Ext.getCmp('userAuthSAML').setDisabled(false);
			Ext.getCmp('userAuthSAML').show();

			Ext.getCmp('userAuth').setDisabled(true);
			Ext.getCmp('userAuth').hide();
		}
		else
		{
			Ext.getCmp('userAuth').setDisabled(false);
			Ext.getCmp('userAuth').show();

			Ext.getCmp('userAuthSAML').setDisabled(true);
			Ext.getCmp('userAuthSAML').hide();

		}

		Ext.getCmp('userModel').getStore().loadRawData(publicJSON['userModel']);

		var rootData = {
			text: 'Choose Organization / Organizational Unit',
			id: '-1',
			name: '-1',
			expanded: true,
			children:publicJSON['organization']
		};
		Ext.getCmp('org').getStore().setRootNode(rootData);
		if (selectedUType == 'none')
		{
			if (hasAllComponentAccess)
			{
				if (isEnterpriseModel)
				{
					Ext.getCmp('userModel').setValue("User");
					Ext.getCmp('org').setValue('egenterprise');
				}
				else
				{
					if (isdefuser)
					{
						Ext.getCmp('userModel').setValue("Organization");
						Ext.getCmp('org').setValue('-1');
					}
					else
					{
						Ext.getCmp('userModel').setValue("User");
						if (!Ext.isEmpty(orgName))
						{
							Ext.getCmp('org').setValue(orgName);
						}
						else
						{
							Ext.getCmp('org').setValue('-1');
						}
					}
				}
			}
			else
			{
				Ext.getCmp('userModel').setValue("User");
				if (!Ext.isEmpty(orgName))
				{
					Ext.getCmp('org').setValue(orgName);
				}
				else
				{
					Ext.getCmp('org').setValue('-1');
				}
			}
		}
		else
		{
			if (!Ext.isEmpty(selectedUserModel))
			{
				Ext.getCmp('userModel').setValue(selectedUserModel);
			}
			else
			{
				Ext.getCmp('userModel').setValue('-1');
			}
			if (!Ext.isEmpty(orgName))
			{
				Ext.getCmp('org').setValue(orgName);
			}
			else
			{
				Ext.getCmp('org').setValue('-1');
			}
		}
		
		this.onOrganizationChange(Ext.getCmp('org'));

		var me = this;
		me.loadDefaults();
		if (selectedUType != "none")
		{
			var userformcontainerObj = Ext.getCmp('userformcontainer');
			userformcontainerObj.child("#tab2").tab.setDisabled(false);
			me.loadUserControls(selectedUType);
		}
		else
		{
			var userformcontainerObj = Ext.getCmp('userformcontainer');
			userformcontainerObj.child("#tab2").tab.setDisabled(true);
		}
		var pwdLength = publicJSON.pwdLength;
		var pwdComplexityCount = publicJSON.pwdComplexityCount;
		if (pwdLength == "" || pwdLength < 2)
		{
			pwdLength = 8;
		}
		else if(pwdLength != "" && pwdLength < pwdComplexityCount)
		{
			pwdLength = pwdComplexityCount;
		}
		Ext.getCmp('passScore').setText(passLabel1+" "+pwdLength+" "+passLabel2);

		var org = Ext.getCmp('org').getValue();

		var userModel = Ext.getCmp('userModel').getValue();
		Ext.getCmp('utype').getStore().clearFilter();
		if (!isdefuser)
		{
			if (!Ext.isEmpty(userModel) && (userModel == 'Organization' || userModel == 'SubOrganization'))
			{
				Ext.getCmp('utype').getStore().filter('isShareRole',true);
				//me.onUserTypeChange(Ext.getCmp('utype'));
			}
			else
			{
				if (org.toLowerCase() == "egenterprise")
				{
					Ext.getCmp('utype').getStore().filter('isShareRole',false);
				}
				else
				{
					Ext.getCmp('utype').getStore().filter('hasallcompaccess',false);
				}
			}
		}
		else
		{
			if (!Ext.isEmpty(userModel) && (userModel == 'Organization' || userModel == 'SubOrganization'))
			{
				if (userModel == 'Organization')
				{
					Ext.getCmp('org').hide();
					Ext.getCmp('selectedServerListGrid').hide();
				}
				else
				{
					Ext.getCmp('selectedServerListGrid').show();
				}
				
				Ext.getCmp('utype').getStore().filter('isShareRole',true);
				//me.onUserTypeChange(Ext.getCmp('utype'));
			}
			else
			{
				Ext.getCmp('org').show();
				var org = Ext.getCmp('org').getValue();
				var isShareRole = publicJSON['isShareRole'];
				if (!Ext.isEmpty(isShareRole) && isShareRole == false)
				{
					Ext.getCmp('selectedServerListGrid').show();
				}
				else
				{
					Ext.getCmp('selectedServerListGrid').hide();
				}
				Ext.getCmp('utype').getStore().filter('isShareRole',false);
				
				if (!Ext.isEmpty(isSAMLLoginEnabled) && isSAMLLoginEnabled)
				{
					Ext.getCmp('userAuthSAML').setDisabled(false);
					Ext.getCmp('userAuthSAML').show();

					Ext.getCmp('userAuth').setDisabled(true);
					Ext.getCmp('userAuth').hide();
				}
				else
				{
					Ext.getCmp('userAuth').setDisabled(false);
					Ext.getCmp('userAuth').show();

					Ext.getCmp('userAuthSAML').setDisabled(true);
					Ext.getCmp('userAuthSAML').hide();
				}
			}
		}
		me.onUserTypeChange(Ext.getCmp('utype'));

		var org = Ext.getCmp('org').getValue();

		if (org == 'egenterprise')
		{
			Ext.getCmp('Never').setValue(true);
		}

		if (!isEnterpriseModel)
		{
			Ext.getCmp('userAuth').setDisabled(true);
			Ext.getCmp('userAuth').hide();
			Ext.getCmp('userAuthSAML').setDisabled(true);
			Ext.getCmp('userAuthSAML').hide();
			Ext.getCmp('eGAuth').setValue(true);
			Ext.getCmp('eGAuthSAML').setValue(true);
		}
	},

	onUserModelChange : function()
	{
		var userModel = Ext.getCmp('userModel').getValue();
		Ext.getCmp('utype').getStore().clearFilter();
		if (!Ext.isEmpty(userModel) && userModel == 'Organization')
		{
			Ext.getCmp('org').hide();
			Ext.getCmp('selectedServerListGrid').hide();
			Ext.getCmp('utype').getStore().filter('isShareRole',true);
			Ext.getCmp('utype').setValue("none");

			Ext.getCmp('org').setValue("-1");
			this.onOrganizationChange(Ext.getCmp('org'));
		}
		else if (!Ext.isEmpty(userModel) && userModel == 'SubOrganization')
		{
			Ext.getCmp('org').show();
			Ext.getCmp('selectedServerListGrid').show();
			Ext.getCmp('utype').getStore().filter('isShareRole',true);
			Ext.getCmp('utype').setValue("none");
		}
		else
		{
			Ext.getCmp('org').show();
			Ext.getCmp('selectedServerListGrid').show();
			
			var org = Ext.getCmp('org').getValue();
			if (!Ext.isEmpty(org) && org.toLowerCase() == "egenterprise")
			{
				Ext.getCmp('utype').getStore().filter('isShareRole',false);
			}
			else
			{
				Ext.getCmp('utype').getStore().filter('hasallcompaccess',false);
			}
			Ext.getCmp('utype').setValue("none");
		}
	},

	onOrganizationChange : function(obj)
	{
		var me = this;

		var userModel = Ext.getCmp('userModel').getValue();
		if (!Ext.isEmpty(userModel) && userModel == '-1')
		{
			Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg75+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('userModel').focus(true,true);
						Ext.getCmp('utype').setValue("none");
						Ext.getCmp('org').setValue("-1");
						//me.onOrganizationChange(Ext.getCmp('org'));
					}
				});
				Ext.getCmp('userformcontainer').setActiveTab(0);
				return false;
		}

		var selectedOrg = obj.getValue();

		if (!Ext.isEmpty(selectedOrg) && selectedOrg != '-1')
		{
			var urlString = "EgAddUser/data/EgAddUserJson.jsp?qctr=1&org="+encodeURIComponent(selectedOrg)+"&date="+new Date().getTime();

			Ext.Ajax.request({
				url : urlString,
				method: 'POST',
				success: function(response)
				{
					var JSONObj = Ext.decode(response.responseText);
					Ext.getCmp('utype').getStore().loadRawData(JSONObj['utype']);
					if (selectedUType != 'none')
					{
						var fieldIndex = Ext.getCmp('utype').getStore().findExact("valueField",selectedUType);
						if (fieldIndex != -1)
						{
							Ext.getCmp('utype').setValue(selectedUType);
						}
						else
						{
							Ext.getCmp('utype').setValue("none");
						}
					}
					else
					{
						Ext.getCmp('utype').setValue("none");
					}
					if (JSONObj.requestStatus == "failed")
					{
						Ext.Msg.show({
							title: JSONObj.errors.title,
							msg: JSONObj.errors.message1 + ". "+JSONObj.errors.message2+".",
							width: 500,
							buttons: Ext.Msg.OK,
							icon: 'iconError',
							fn : function (btn){
								if (btn == "ok")
								{
									Ext.getCmp('org').setValue("-1");
									Ext.getCmp('org').focus(true);
									me.onOrganizationChange(Ext.getCmp('org'));
								}
							}
						});
					}
				},
				failure : function(response)
				{
				}
			});
		}

		selectedOrg = obj.getValue();
		if (selectedOrg == "-1")
		{
			if (!Ext.isEmpty(userModel) && userModel != 'Organization')
			{
				Ext.getCmp('utype').getStore().clearFilter();
			}
			
			Ext.getCmp('tmptilldate').setValue("");
			Ext.getCmp('Never').setValue("");
			Ext.getCmp('userformcontainer').child("#tab2").tab.setDisabled(true);
		}
		else
		{
			var record = obj.getStore().getNodeById(selectedOrg);
			var uvalidtill = record.raw.uvalidtill;
			
			Ext.getCmp('tmptilldate').setValue("");
			Ext.getCmp('Never').setValue("");

			if (uvalidtill != null && uvalidtill != "12/12/9999")
			{
				Ext.getCmp('tmptilldate').setValue(uvalidtill);
				Ext.getCmp('tmptilldate').setMaxValue(uvalidtill);
				Ext.getCmp('Never').setDisabled(true);
				Ext.getCmp('Never').setValue(false);
			}
			else
			{
				Ext.getCmp('tmptilldate').setMaxValue("12/12/9999");
				Ext.getCmp('Never').setDisabled(false);
				Ext.getCmp('Never').setValue(true);
			}
			
			var userModel = Ext.getCmp('userModel').getValue();
			Ext.getCmp('utype').getStore().clearFilter();
			if (!Ext.isEmpty(userModel) && userModel == 'Organization')
			{
				Ext.getCmp('org').hide();
				Ext.getCmp('selectedServerListGrid').hide();

				Ext.getCmp('utype').setValue("none");
				Ext.getCmp('utype').getStore().filter('isShareRole',true);
			}
			else if (!Ext.isEmpty(userModel) && userModel == 'SubOrganization')
			{
				Ext.getCmp('org').show();
				Ext.getCmp('selectedServerListGrid').show();

				Ext.getCmp('utype').setValue("none");
				Ext.getCmp('utype').getStore().filter('isShareRole',true);
			}
			else
			{
				Ext.getCmp('org').show();
				Ext.getCmp('selectedServerListGrid').show();
				if (selectedOrg == 'egenterprise')
				{
					Ext.getCmp('utype').setValue("none");
					Ext.getCmp('utype').getStore().filter('isShareRole',false);
				}
				else
				{
					Ext.getCmp('utype').setValue("none");
					Ext.getCmp('utype').getStore().filter('hasallcompaccess',false);
				}
			}
		}
		
		if (selectedUType != 'none')
		{
			var fieldIndex = Ext.getCmp('utype').getStore().findExact("valueField",selectedUType);
			if (fieldIndex != -1)
			{
				Ext.getCmp('utype').setValue(selectedUType);
			}
			else
			{
				Ext.getCmp('utype').setValue("none");
			}
		}
		else
		{
			Ext.getCmp('utype').setValue("none");
		}
		Ext.getCmp('userformcontainer').child("#tab2").tab.setDisabled(true);
	},

	loadDefaults : function()
	{
		var utype = Ext.getCmp('utype');
		utype.getStore().loadRawData(publicJSON['utype']);
		utype.setValue(selectedUType);
		this.setLangEntries(publicJSON.langEntries);
	},
	setLangEntries : function(landEntriesJson)
	{
		for (var key in landEntriesJson)
		{
			var tmpObj = Ext.getCmp(key);
			if (tmpObj ==  null || tmpObj == 'undefined')
			{
				continue;
			}
			if (tmpObj.getXType() == "checkboxfield" || tmpObj.getXType() == "radiofield")
			{
				if (tmpObj.boxLabelEl == null || tmpObj.boxLabelEl == undefined || tmpObj.boxLabelEl == 'undefined')
				{
					continue;
				}
				tmpObj.boxLabelEl.update(landEntriesJson[key]);
			}
			else
			{
				tmpObj.setFieldLabel(landEntriesJson[key]);
			}
		}
	},
	updateUserPage : function(urlStr)
	{
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	showCommandInWindow : function(obj)
	{
		var commandVal = Ext.getCmp('customScript').getValue();
		obj.setDisabled(true);
		Ext.widget('window', {
			extend: 'Ext.panel.Panel',
			title: "Command",
			id : 'commandWindow',
			closeAction: 'destory',
			width: 625,
			height: 300,
			modal: true,
			scroll: true,
			autoScroll: true,
			doClose: function() {
				obj.setDisabled(false);
				this.destroy();
			},
			padding : '40px 5px 10px 5px',
			buttonAlign : 'center',
			items : [
			{
				xtype: 'textareafield',
				id : 'tmpTextArea',
				cls: 'text-area',
				fieldLabel : 'Command',
				height : 160,
				grow : true,
				value: commandVal,
				rows : 9,
				cols : 72
			}],
			buttons : [{
				text : 'Apply',
				id : 'applyCommand',
				cls: 'button20',
				margin: '0 0 10 0',
				handler: function()
				{
					obj.setDisabled(false);
					Ext.getCmp('customScript').setValue(Ext.getCmp('tmpTextArea').getValue());
					Ext.getCmp('commandWindow').destroy();
				}
			}]
			
		}).show();
	},
	showResultWindow : function(title,resultText)
	{
		Ext.widget('window', {
			title: title,
			closeAction: 'destory',
			bodyPadding : 20,
			scroll: true,
			width : 700,
			modal : true,
			autoScroll: true,
			doClose: function() {
				this.destroy();
			},
			html: resultText
		}).show();
	},
	showResultQBox : function(resultText)
	{
		var resultJsonObj = Ext.decode(resultText);
		var requestStatus = resultJsonObj['requestStatus'];
		var title = '';
		if (requestStatus == "success")
		{
			var resultObj = resultJsonObj['result'];
			title = resultObj.title;
		}
		else
		{
			var resultObj = resultJsonObj['errors'];
			title = resultObj.title;
		}
		Ext.widget('window', {
			title: title,
			closeAction: 'destory',
			width: 600,
			height: 300,
			scroll: true,
			autoScroll: true,
			doClose: function() {
				resultJsonObj = '';
				this.destroy();
			},
			html: resultText
		}).show()
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			if (key == "vsTypes")
			{
				continue;
			}
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	submitUserDetails : function(obj)
	{
		var me = this;
		this.buildMainData();
		var validationStatus = me.validateUserForm('formsubmit');
		if (validationStatus == true)
		{
			var assoUsers = me.getSelectedUsers();
			var servType = "";
			Ext.getCmp('selectedServerListGrid').getStore().each(function(rec)
			{
				if (!Ext.isEmpty(rec.get("valueField_1")))
				{
					servType+=rec.get("valueField_1") + ",";
				}
				if (!Ext.isEmpty(rec.get("valueField_2")))
				{
					servType+=rec.get("valueField_2") + ",";
				}
				if (!Ext.isEmpty(rec.get("valueField_3")))
				{
					servType+=rec.get("valueField_3") + ",";
				}
			});
			servType = servType.substring(0,servType.length-1);
			Ext.getCmp('interestedDomains').setValue(servType);
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Adding new user...'});
			myMask.show();
			//var hiddenFields = this.getHiddenFields();
			var userForm = this.getMain().getForm();
			if (userForm.isValid())
			{
				var _uname = Ext.getCmp('uname').getValue();
				var _upass = Ext.getCmp('upass').getValue();
				
				_uname = parent.filterEncode(_uname);
				_upass = parent.filterEncode(_upass);
				
				Ext.getCmp('uname').setValue(_uname);
				Ext.getCmp('upass').setValue(_upass);

				Ext.getCmp('availusers').setDisabled(true);
				Ext.getCmp('confpasswd').setDisabled(true);
				this.getMain().submit({
					url: 'EgAddUser/data/EgadduserpJson.jsp?count='+inputs+'&assousers='+encodeURIComponent(assoUsers)+'&date='+new Date().getTime(),
					method: 'POST',
					success: function(form, action){
						if(action.response.status == 200 && !Ext.isEmpty(action.response.responseText)) 
						{
							myMask.hide();
							var tmpJosnData = Ext.decode(action.response.responseText);
							if (tmpJosnData.requestStatus == "success")
							{
								// for 2fa - start here
								var twoFAMailSend = tmpJosnData.TwoFAMailSend;
								if (!Ext.isEmpty(twoFAMailSend) && twoFAMailSend.toLowerCase() == "failed")
								{
									var mailSendErrMsg = tmpJosnData.MailSendErrMsg;
									Ext.Msg.show({
										title: pageTitle,
										msg: mailSendErrMsg + ".",
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
									//Ext.Msg.alert(pageTitle,mailSendErrMsg);
									//return;
								}
								// for 2fa - end here
								assousers = assoUsers;
								utype = tmpJosnData.utype;
								username = tmpJosnData.username;

								var hasallcompaccess = tmpJosnData.hasallcompaccess;
								var userModel = tmpJosnData.userModel;
								var ShareCompsAcrossOU = tmpJosnData.ShareCompsAcrossOU;
								var isShareRole = tmpJosnData.isShareRole;
								isAlarmEnabled = tmpJosnData.isAlarmEnabled;
								isFilterMailAlertsEnabled = tmpJosnData.isFilterMailAlertsEnabled;
								if (hasallcompaccess == false && utype != 'FannieMae-InfoSec')
								{
									//var result = tmpJosnData.result;
									//Ext.Msg.alert(result.title,result.message1);

									//Ext.getCmp('btnAddUser').hide();
									//var userformcontainerObj = Ext.getCmp('userformcontainer');
									//userformcontainerObj.child("#tab1").setDisabled(true);
									//userformcontainerObj.child("#tab2").setDisabled(true);
									//me.loadUserElementsTab();
									if (!Ext.isEmpty(userModel) && userModel == 'Organization')
									{
										if (!Ext.isEmpty(ShareCompsAcrossOU) && ShareCompsAcrossOU == 'true')
										{
											me.configureUserElements('association');
										}
										else if (isAlarmEnabled == true && isFilterMailAlertsEnabled == true)
										{
											me.configureUserElements('filter');
										}
										else
										{
											var result = tmpJosnData.result;
											Ext.Msg.show({
												title: result.title,
												msg: result.message1 + ".",
												buttons: Ext.Msg.OK,
												icon: 'iconInformation',
												fn : function(btn){
													if (btn == "ok")
													{
														me.showUserAddForm();
													}
												}
											});
										}
									}
									else if (!Ext.isEmpty(userModel) && userModel == 'User')
									{
										if (!Ext.isEmpty(isShareRole) && isShareRole == false)
										{
											me.configureUserElements('association');
										}
										else if (isAlarmEnabled == true && isFilterMailAlertsEnabled == true)
										{
											me.configureUserElements('filter');
										}
										else
										{
											var result = tmpJosnData.result;
											Ext.Msg.show({
												title: result.title,
												msg: result.message1 + ".",
												buttons: Ext.Msg.OK,
												icon: 'iconInformation',
												fn : function(btn){
													if (btn == "ok")
													{
														me.showUserAddForm();
													}
												}
											});
										}
									}
									else
									{
										me.configureUserElements('association');
									}
								}
								else if (isAlarmEnabled == true && isFilterMailAlertsEnabled == true && utype != 'FannieMae-InfoSec')
								{
									//var result = tmpJosnData.result;
									//Ext.Msg.alert(result.title,result.message1);

									me.configureUserElements('filter');
									//Ext.getCmp('btnAddUser').hide();
									//var userformcontainerObj = Ext.getCmp('userformcontainer');
									//userformcontainerObj.child("#tab1").setDisabled(true);
									//userformcontainerObj.child("#tab2").setDisabled(true);
									//me.loadMailFilterAndConfigTab();
								}
								else
								{
									var result = tmpJosnData.result;
									Ext.Msg.show({
										title: result.title,
										msg: result.message1 + ".",
										buttons: Ext.Msg.OK,
										icon: 'iconInformation',
										fn : function(btn){
											if (btn == "ok")
											{
												me.showUserAddForm();
											}
										}
									});
								}
							}
							else
							{
								Ext.Msg.show({
									title: tmpJosnData.errors.title,
									msg: tmpJosnData.errors.message1 + ". "+tmpJosnData.errors.message2+".",
									width: 500,
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}
						}
						Ext.getCmp('availusers').setDisabled(false);
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						Ext.getCmp('availusers').setDisabled(false);
						Ext.Msg.show({
							title: 'Ajax Failed',
							msg: "Could not update user details.",
							width: 400,
							buttons: Ext.Msg.OK,
							icon: 'iconError'
						});
						myMask.hide();
					}
				});
			}
		}
	},

	getDeepAllChildNodes : function(org){ 
		var superOU = "";
		Ext.Ajax.request({
			url : "EgAddUser/data/EgAddUserJson.jsp?qctr=1&from=getSuperOU&org="+encodeURIComponent(org)+"&date="+new Date().getTime(),
			method: 'POST',
			async: false,
			success: function(response)
			{
				var superjsonText = response.responseText;
				var superOrgJson = Ext.decode(superjsonText);
				superOU = superOrgJson['SuperOU'];
			}
		});
		return superOU;
	},

	moveTab : function(obj)
	{
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		if (this.validateUserForm1() == true)
		{
			userformcontainerObj.setActiveTab(1);
			obj.hide();
			Ext.getCmp('btnAddUser').show();
			Ext.getCmp('btnPrev').show();

			var selectedUserType = Ext.getCmp('utype').getValue();
			if (selectedUserType == "FannieMae-InfoSec"){
				Ext.getCmp('mailsmssettings').hide();
				Ext.getCmp('imgAdminPage').hide();
				Ext.getCmp('imgRepLogin').hide();
			}
		}
	},
	validateUserForm1 : function()
	{
		var me = this;
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		var userModel = Ext.getCmp('userModel').getValue();
		if (!Ext.isEmpty(userModel) && userModel == '-1')
		{
			Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg75+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('userModel').focus(true,true);
						Ext.getCmp('utype').setValue("none");
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
		}
		else if (!Ext.isEmpty(userModel) && (userModel == 'SubOrganization' || userModel == 'User'))
		{
			var org = Ext.getCmp('org').getValue();
			if (org == "-1")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg74+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('org').focus(true,true);
						Ext.getCmp('utype').setValue("none");
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
		}

		var selectedUserType = Ext.getCmp('utype').getValue();
		if (selectedUserType == "none")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userRoleValidationMsg+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			userformcontainerObj.setActiveTab(0);
			return false;
		}
		var utype = Ext.getCmp('utype').getValue();
		var never = Ext.getCmp('Never').getValue();
		var orStr = " or ";
		var sep="'";

		var tilldate = Ext.getCmp('tilldate').getValue();
		var tilldate_h = Ext.getCmp('tilldate_h').getValue();
		var hiddenFields = publicJSON.hiddenFields;
		var usname = hiddenFields.username1;
		var pwdLen = publicJSON.pwdLength;
		var pwdComplexityCount = publicJSON.pwdComplexityCount;
		if (pwdLen == "" || pwdLen < 2)
		{
			pwdLen = 8;
		}
		else if(pwdLen != "" && pwdLen < pwdComplexityCount)
		{
			pwdLen = pwdComplexityCount;
		}
		var tillhr = hiddenFields.tillhr;
		var tillmin = hiddenFields.tillmin;
		var currentdate = hiddenFields.currentdate;
		var currenthr = hiddenFields.currenthr;
		var currentmin = hiddenFields.currentmin;
		var eedateforpro;
		var authType='';

		if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
		{
			if (Ext.getCmp('eGAuthSAML').getValue() == true)
			{
				authType ='Eg';
			}
			else if (Ext.getCmp('idpAuthSAML').getValue() == true)
			{
				authType ='SAML';
			}
			else
			{
				authType = 'Domain';
			}
		}
		else
		{
			if (Ext.getCmp('eGAuth').getValue() == true)
			{
				authType ='Eg';
			}
			else
			{
				authType = 'Domain';
			}
		}

		if (authType == 'SAML')
		{
			var idpName = Ext.getCmp('idpName').getValue();
			if (!Ext.isEmpty(idpName) && idpName == 'none')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIdpValidationMsg+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}

			var samlUserName = Ext.getCmp('uname').getValue();
			if(!checkblank(samlUserName))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg2+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('uname').focus(true);
					}
				});
				return;
			}
		}

		var unameck = "";
		unameck = Ext.getCmp('uname').getValue();
		var user_Id = true;
		var user_pwd = true;
		var regExp1=/^(\+\d\d)?[0-9]+$/g;
		var reg3 = /(((([\+]?([0-9]){4,15})|([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])+)\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z])|((\+\d\d)?[0-9]+))/g

		if(unameck !=null && unameck!="")
		{
			if(usname!=null&&usname!="")
			{
				if (authType == 'SAML')
				{
					var idpName = Ext.getCmp('idpName').getValue();
					unameck = 'samlsso/'+idpName+"/"+unameck
				}

				var myarr = usname.split("|hash|");
				for (i=0;i<myarr.length;i++)
				{
					if(myarr[i].toLowerCase()==unameck.toLowerCase())
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: userIDValidationMsg+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn){
								Ext.getCmp('uname').focus(true);
							}
						});
						userformcontainerObj.setActiveTab(0);
						return false;
					}
				}
			}
		}

		var userName = Ext.getCmp('uname');
		if (userName != null && userName != 'undefined' && authType == 'Eg')
		{
			var tmpUname = userName.getValue();
			if(!checkblank(tmpUname))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg2+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!checkSpecial(userName,"=\"/\\"))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: _checkspecial,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						userformcontainerObj.setActiveTab(0);
						userName.focus(true);
					}
				});
				return false;
			}
			else if(trim(tmpUname) == "")
			{
				userformcontainerObj.setActiveTab(0);
				userName.focus(true);
				return false;
			}
			else if (tmpUname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: _checkdots+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if (tmpUname.toUpperCase() == "ADMIN" || tmpUname.toUpperCase() == "SUPERMONITOR" || tmpUname.toUpperCase() == "MONITOR" || tmpUname.toUpperCase() == "NONE" )
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg3 +" "+tmpUname+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}

			if (tmpUname.toUpperCase() == "NULL")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg3 +" "+tmpUname+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			checkSpace = tmpUname;
			if (checkSpace.indexOf(' ') == 0 ) //||checkSpace.indexOf('.')==0 || checkSpace.indexOf('-')==0 || checkSpace.indexOf('_')==0 )
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg4+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}

			if (checkSpace.lastIndexOf(' ')==checkSpace.length-1)//jamesthomas
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg5+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			if (isDoubleByteEnabled == "false")
			{
				user_Id = validateSingleByte(tmpUname);
				user_pwd = validateSingleByte(Ext.getCmp('upass').getValue());
				//userformcontainerObj.setActiveTab(0);
			}
			if (!user_Id)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg6+".",
					buttons: Ext.Msg.OK,
					width : 400,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}

			if (!Ext.isEmpty(enforceEmailIDInMSP) && enforceEmailIDInMSP.toLowerCase() == 'true')
			{
				var org = Ext.getCmp('org').getValue();
				var getDeepAllChildNodes = appCnt.getDeepAllChildNodes(org);

				if(!Ext.isEmpty(getDeepAllChildNodes) && getDeepAllChildNodes.toLowerCase() != 'egenterprise')
				{
					var regExp = /[\#]?([a-zA-Z0-9]+[\#\ \_\.\-\&]?)*[a-zA-Z0-9]\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]/g;
					var toMailResult= tmpUname.match(regExp);
					if (toMailResult != tmpUname.toString())
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: userIDEmailValidationMsg+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn){
								userName.focus(true);
							}
						});
						userformcontainerObj.setActiveTab(0);
						return false;
					}
				}
			}
		}

		if (authType == 'Eg')
		{
			var passObj =  Ext.getCmp('upass');
			var cpassObj =  Ext.getCmp('confpasswd');
			var loginPassword = Ext.getCmp('upass').getValue();
			var cloginPassword = Ext.getCmp('confpasswd').getValue();
			var pwdComplexity = me.pwdComplexityCheck(loginPassword);
			if(loginPassword == "")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg7+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						passObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!checkloginpass(loginPassword))
			{
				userformcontainerObj.setActiveTab(0);
				passObj.focus(true);
				return false;
			}
			else if(loginPassword.length<pwdLen)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: passLabel1+" "+pwdLen+" "+passLabel2,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						passObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(pwdComplexity.indexOf("false") > -1)
			{
				var resMsg = pwdComplexity.substring(pwdComplexity.indexOf("false#")+6);
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg73+". "+passLabel1+" "+resMsg+".",
					width : 400,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						passObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!user_pwd)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg9+".",
					width : 400,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						passObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(cloginPassword == "")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg10+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						cpassObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!checkloginpass(cloginPassword))
			{
				userformcontainerObj.setActiveTab(0);
				cpassObj.focus(true);
				return false;
			}
			else if(loginPassword != cloginPassword)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg11+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						cpassObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
		}
		else if (authType == 'Domain' || authType == 'domain')
		{
			var operationType = '';
			if (Ext.getCmp('radioOperation2').getValue() == true)
			{
				operationType = "Group";
			}
			if (operationType != null && operationType == 'Group')
			{
				var grpname = Ext.getCmp('grpname').getValue();
				if (grpname.indexOf("Click on the icon to select a group") != -1 || grpname.length == 0)
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg12+".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							Ext.getCmp('grpname').focus(true);
						}
					});
					userformcontainerObj.setActiveTab(0);
					return false;
				}
			}
		}
		return true;
	},
	movePreviousTab : function(obj)
	{
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		userformcontainerObj.setActiveTab(0);
		obj.hide();
		Ext.getCmp('btnAddUser').hide();
		var usrType = Ext.getCmp('userAuth').getValue().authentication
		if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
		{
			usrType = Ext.getCmp('userAuthSAML').getValue().authenticationSAML
		}
		
		if (usrType == "Domain" && Ext.getCmp('rdoOperation').getValue().operation == "User")
		{
			if (!this.getBtnValidate().isHidden())
			{
				Ext.getCmp('btnNext').hide();
			}
			else
			{
				Ext.getCmp('btnNext').show();
			}
		}
		else
		{
			Ext.getCmp('btnNext').show();
		}
	},
	configureUserElements : function(actionType)
	{
		if (actionType == "association")
		{
			window.location.href = "EgChangeUserProfile.jsp?qctr=1&reqfrom=adduser&username="+encodeURIComponent(parent.filterEncode(username))+"&selectedTab=3&showAlert=yes&fromWizard="+fromWizard;
		}
		else
		{
			window.location.href = "EgChangeUserProfile.jsp?qctr=1&reqfrom=adduser&username="+encodeURIComponent(parent.filterEncode(username))+"&selectedTab=4&showAlert=yes&fromWizard="+fromWizard;
		}
	},
	loadMailFilterAndConfigTab : function()
	{
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		var elementFilteringTabObj = Ext.getCmp('elementFilteringTab');
		elementFilteringTabObj.removeAll();
		elementFilteringTabObj.add({xtype : 'egmailalertsuppress'});
		userformcontainerObj.child("#tab4").tab.show();
		userformcontainerObj.child("#tab3").tab.show();
	},
	loadUserElementsTab : function()
	{
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		var elementAssociationTab = Ext.getCmp('elementAssociationTab');
		elementAssociationTab.removeAll();		
		elementAssociationTab.add({xtype : 'elementassociationform'});
		userformcontainerObj.child("#tab3").tab.show();

		var utype = Ext.getCmp('utype').getValue();
		var url = "EgAddUser/data/EgUserSiteServersJson.jsp?qctr=1&assousers="+encodeURIComponent(assousers)+"&username="+encodeURIComponent(username)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom=add&utype="+utype+"&date="+new Date().getTime();
		this.updateUserElementPage(url);
		userformcontainerObj.setActiveTab(2);

		if ((isAlarmEnabled == true || isAlarmEnabled == 'true' )&& (isFilterMailAlertsEnabled == true || isFilterMailAlertsEnabled == 'true'))
		{
			var elementFilteringTab = Ext.getCmp('elementFilteringTab');
			elementFilteringTab.removeAll();
			elementFilteringTab.add({xtype : 'egmailalertsuppress'});
			userformcontainerObj.child("#tab4").tab.show();
		}
		else
		{
			userformcontainerObj.child("#tab4").tab.hide();
		}
	},
	loadUserTab : function(tabPanel, newCard, oldCard, eOpts)
	{
		var me = this;
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		var tmpUserID = Ext.getCmp('uname').getValue();
		var selectedTab = newCard.itemId;
		if (selectedTab == "tab1")
		{
			var usrType = Ext.getCmp('userAuth').getValue().authentication
			if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
			{
				usrType = Ext.getCmp('userAuthSAML').getValue().authenticationSAML
			}

			if (usrType == "Domain" && Ext.getCmp('rdoOperation').getValue().operation == "User")
			{
				if (!me.getBtnValidate().isHidden())
				{
					Ext.getCmp('btnNext').hide();
				}
				else
				{
					Ext.getCmp('btnNext').show();
				}
			}
			else
			{
				Ext.getCmp('btnNext').show();
			}
			Ext.getCmp('btnAddUser').hide();
			Ext.getCmp('btnPrev').hide();
		}
		if (selectedTab == "tab2")
		{
			Ext.getCmp('btnNext').hide();
			Ext.getCmp('btnAddUser').show();
			Ext.getCmp('btnPrev').show();
			this.setDDInMailMode();

			var selectedUserType = Ext.getCmp('utype').getValue();
			if (selectedUserType == "FannieMae-InfoSec"){
				Ext.getCmp('mailsmssettings').hide();
				Ext.getCmp('imgAdminPage').hide();
				Ext.getCmp('imgRepLogin').hide();
			}
		}
		else if (selectedTab == "tab4")
		{
			var tmpUserID = Ext.getCmp('uname').getValue();
			var url = "EgAddUser/data/EgMailAlertSuppressJson.jsp?userID="+encodeURIComponent(tmpUserID)+"&reqfrom=add&date="+new Date().getTime();
			me.updateUserMailSuppressList(url);
			me.updateFilterComponents();
		}
		myMask.hide();
		Ext.Ajax.request({
			url: 'EgAddUser/data/egadduserhelpJson.jsp?selectTab='+selectedTab,
			method: 'POST',
			async: false,
		});
	},
	initUserElements : function()
	{
		var associations = userElementJSON.associations;
		var associateObj = Ext.getCmp('associate');
		associateObj.getStore().loadRawData(associations);
		associateObj.setValue("-1");
		var tmpStore = Ext.getCmp('otherHosts');
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		//this.updateResultPanel();
		this.setLangEntries(userElementJSON.langEntries);
		
	},
	initUserMailConfigs : function()
	{
		var queryStatus = userMailJSON.requestStatus;
		if (queryStatus == "success")
		{
			var tmpUserID = Ext.getCmp('uname').getValue();
			this.setLangEntries(userMailJSON.langEntries);
			var message = "<div class = \"iconExclamation\" style=\"margin:0 auto\"></div><div>No components have been associated for <b>'"+tmpUserID+"'</b></div>";
			var filters = userMailJSON.filters;
			var isComboNeeded = userMailJSON.isComboNeeded;
			var isComponentsAssociated = userMailJSON.isComponentsAssociated;
			var userFieldContainerObj = Ext.getCmp("userFieldContainer");
			if (isComponentsAssociated == true)
			{
				/*if (isComboNeeded == true)
				{
					var tmpCombo = {
						xtype:'combo',
						cls: 'dropdown',
						labelWidth: 80,
						width: 160,
						editable : false,
						fieldLabel:userIDValidationMsg60,
						name: 'userID',
						id: 'userID',
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						hidden : true
					}
					userFieldContainerObj.removeAll();
					userFieldContainerObj.add(tmpCombo);
				}
				else
				{
					var tmpTextField = {
						xtype:'textfield',
						id: 'userID',
						cls: 'textbox24',
						name: 'userID',
						fieldLabel : userIDValidationMsg59,
						labelWidth: 80,
						width: 260,
						value : tmpUserID,
						readOnly : true
					}
					userFieldContainerObj.removeAll();
					userFieldContainerObj.add(tmpTextField);
				}*/
				var associateObj = Ext.getCmp('filter');
				associateObj.getStore().loadRawData(filters);
				associateObj.setValue("-1");
				var tmpStore = Ext.getCmp('exclude');
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				//this.updateFilterResultPanel();
			}
			else
			{
				var userformcontainerObj = Ext.getCmp('userformcontainer');
				var elementFilteringTabObj = Ext.getCmp('elementFilteringTab');
				elementFilteringTabObj.removeAll();
				elementFilteringTabObj.add({
					xtype : 'panel',
					border :false,
					padding:130,
					style:{'text-align':'center'},
					html:message
				});
				elementFilteringTabObj.doLayout();
			}
		}
	},
	updateFilterComponents : function()
	{
		var elementFilteringTabObj = Ext.getCmp('elementFilteringTab');
		var isComponentsAssociated = userMailJSON.isComponentsAssociated;
		if (isComponentsAssociated == true)
		{
			var egmailalertsuppressObj = Ext.getCmp('egmailalertsuppress');
			if (egmailalertsuppressObj == null || egmailalertsuppressObj == 'undefined' || egmailalertsuppressObj == undefined)
			{
				elementFilteringTabObj.removeAll();
				elementFilteringTabObj.add({xtype : 'egmailalertsuppress'});
			}
		}
		else
		{
			var tmpUserID = Ext.getCmp('uname').getValue();
			var message = "<div class = \"iconExclamation\" style=\"margin:0 auto\"></div><div>No components have been associated for <b>'"+tmpUserID+"'</b></div>";
			elementFilteringTabObj.removeAll();
			elementFilteringTabObj.add({
				xtype : 'panel',
				border : false,
				padding:130,
				style:{'text-align':'center'},
				html:message
			});
		}
	},
	updateFilterResultPanel : function()
	{
		var me = this;
		var userFilterContainerObj = Ext.getCmp('userFilterContainer');
		var filters = userMailJSON.filters;
		userFilterContainerObj.removeAll();
		//Ext.getCmp('userFilterWindow').removeAll();
		if (userMailJSON['isFiltersAvailable'] != null && userMailJSON['isFiltersAvailable'] != undefined && userMailJSON['isFiltersAvailable'] == true)
		{
			var excludedElements = userMailJSON.excludedElements;
			var gridHeaderMapping = userMailJSON.gridHeaderMapping;
			for (var key in excludedElements)
			{
				var gridObj = excludedElements[key];
				if (key == "excludedComponents" || key == "allExcludedLayersByType" || key == "exculdedTestsForAllTypes")
				{
					var gridTitle = gridHeaderMapping[key];
					if (gridObj == "" || gridObj.length == 0)
					{
						continue;
					}
					var tmpPanel = {
						xtype : 'panel',
						border : false,
						width : '85%',
						title : gridTitle,
						bodyPadding:'0 0 10 0',
						html : gridObj
					}
					userFilterContainerObj.add(tmpPanel);
					//Ext.getCmp('userFilterWindow').add(tmpPanel);
				}
				else
				{
					var gridTitle = gridHeaderMapping[key];
					if (Ext.isEmpty(gridObj))
					{
						continue;
					}
					var tmpResult = me.getGridPanel(gridObj,gridTitle);
					userFilterContainerObj.add(tmpResult);
					//Ext.getCmp('userFilterWindow').add(tmpResult);
				}
			}
		}
		else
		{
			var message = "<div class = \"iconExclamation\" style=\"margin:0 auto\"></div><div>No elements are excluded for this user</b></div>";
			var tmpPanel = {
				xtype : 'component',
				border : false,
				padding : 120,
				html : message
			}
			userFilterContainerObj.add(tmpPanel);
		}
		Ext.getCmp('userFilterWindow').doLayout();
	},
	getGridPanel : function(gridArray,gridTitle)
	{
		var fieldstoStore =  new Array();
		fieldstoStore.push("compType_1");
		fieldstoStore.push("compType_2");
		fieldstoStore.push("compType_3");
		var mainColumnsObjArray	=  new Array();
		var itemsArray	=  new Array();
		for (var key in fieldstoStore)
		{
			var gridColumn = fieldstoStore[key];
			mainColumnsObjArray.push({
				header: gridColumn,
				dataIndex: gridColumn,
				flex:1
			});
		}
		var gridpanel = Ext.widget('usergridpanel',{
			store:new Ext.data.Store({
				fields: fieldstoStore,
				data: gridArray
			}),
			sortableColumns:false,
			cls:'gridSkin',
			title : gridTitle,
			width : '85%',
			columns:mainColumnsObjArray,
			viewConfig: {
				forceFit: true,
				stripeRows : false
			},
			sortable: false,
			hideable: false,
			hideHeaders : true
		});
		return gridpanel;
	},
	popFilterDetails : function(obj)
	{
		var me = this;
		var page ="EgAddUser/data/EgMailAlertSuppressJson.jsp?userID="+encodeURIComponent(username)+"&reqfrom=add";
		var selectedOption = obj.getValue();
		if(selectedOption != "-1")
		{
			page = page+"&filterBy="+selectedOption;
			if(selectedOption == "filterByCName")
			{
				page = page + "&serverType=-1";
			}
			else if(selectedOption == "filterByLayer" || selectedOption == "filterByTest")
			{
				page = page + "&serverType=filterByAll";
			}
			page = page + "&date="+new Date().getTime();
			me.updateUserMailSuppressList(page);
			var tmpStore = Ext.getCmp('exclude');
			var includedItems = userMailJSON['includedAlerts'];
			var excludedItems = userMailJSON['excludedAlerts'];
			tmpStore.getStore().removeAll();
			if(tmpStore.fromField.store.getCount() > 0)
			{
				tmpStore.fromField.store.removeAll();
			}
			if(tmpStore.toField.store.getCount() > 0)
			{
				tmpStore.toField.store.removeAll();
			}
			if (!Ext.isEmpty(excludedItems))
			{
				//tmpStore.getStore().loadRawData(excludedItems);
				tmpStore.fromField.store.add(excludedItems);
			}
			if (!Ext.isEmpty(includedItems))
			{
				tmpStore.toField.store.add(includedItems);
			}
			var compTypeContainer = Ext.getCmp('CompTypes');
			compTypeContainer.hide();
			if(selectedOption == "filterByCName" || selectedOption == "filterByLayer" || selectedOption == "filterByTest")
			{
				var tmpCompObj = Ext.getCmp('CompTypes');
				var compopnentTypes = userMailJSON['compopnentTypes'];
				tmpCompObj.getStore().loadRawData(compopnentTypes);
				if (selectedOption == "filterByCName")
				{
					tmpCompObj.setValue("-1");
				}
				else
				{
					tmpCompObj.setValue("filterByAll");
				}
				compTypeContainer.show();
			}
			tmpStore.fromField.getComponent(0).setTitle(userMailJSON['itemTitle1']);
			tmpStore.toField.getComponent(0).setTitle(userMailJSON['itemTitle2']);
		}
	},
	popCompTypes : function(obj)
	{
		var page ="EgAddUser/data/EgMailAlertSuppressJson.jsp?userID="+encodeURIComponent(username)+"&reqfrom=add";
		var filterBy = Ext.getCmp('filter').getValue();
		var serverType = obj.getValue();
		page = page + "&filterBy="+filterBy+"&serverType="+encodeURIComponent(serverType)+"&date="+new Date().getTime();
		this.updateUserMailSuppressList(page);

		var tmpStore = Ext.getCmp('exclude');
		var includedItems = userMailJSON['includedAlerts'];
		var excludedItems = userMailJSON['excludedAlerts'];
		tmpStore.getStore().removeAll();
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}

		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}

		if (!Ext.isEmpty(excludedItems))
		{
			tmpStore.toField.store.add(excludedItems);
			//tmpStore.getStore().loadRawData(excludedItems);
		}
		if (!Ext.isEmpty(includedItems))
		{
			tmpStore.toField.store.add(includedItems);
		}
	},
	getSelectedUsers : function()
	{
		var asso_users="";
		if(Ext.getCmp('chkuser').getValue() == true)
		{
			var tmpAssoStore= Ext.getCmp('availusers').getSelected();
			for (var key in tmpAssoStore)
			{
				asso_users = asso_users+tmpAssoStore[key].get("valueField")+"~,~";	
			}
			if(asso_users.length>0)
			{
				asso_users = asso_users.substring(0,asso_users.length-3);
			}
		}
		return asso_users;
	},
	updateResultPanel : function()
	{
		var isElementsAssociated = userElementJSON.isElementsAssociated;
		var userAssociationContainer = Ext.getCmp('userAssociationContainer');
		var elementassociationcontainer = Ext.getCmp('elementassociationcontainer');
		userAssociationContainer.removeAll();
		if (isElementsAssociated == true)
		{
			Ext.getCmp('dockedItem1').show();
			userAssociationContainer.add({xtype : 'componentgroupedsummarygrid'});
			var userTableData = userElementJSON.userTableData;
			Ext.getCmp('componentgroupedsummarygrid').getStore().loadRawData(userTableData);
		}
		else
		{
			Ext.getCmp('dockedItem1').hide();
			var message = "<div class = \"iconExclamation\" style=\"margin:0 auto\"></div><div>"+intnlLabel5+"</div>";
			var tmpPanel = {
				xtype : 'component',
				border : false,
				padding : 120,
				style:{'text-align':'center'},
				html : message
			}
			userAssociationContainer.add(tmpPanel);
		}
		Ext.getCmp('userElementsWindow').doLayout();
	},
	updateUserMailSuppressList : function(urlStr)
	{
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userMailJSON = Ext.decode(jsonText);
			}
		});
	},
	updateUserElementPage : function(urlStr)
	{
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userElementJSON = Ext.decode(jsonText);
			}
		});
	},
	validateUserForm : function(from)
	{
		var me = this;
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		var userModel = Ext.getCmp('userModel').getValue();
		if (!Ext.isEmpty(userModel) && userModel == '-1')
		{
			Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg75+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('userModel').focus(true,true);
						Ext.getCmp('utype').setValue("none");
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
		}
		else if (!Ext.isEmpty(userModel) && (userModel == 'SubOrganization' || userModel == 'User'))
		{
			var org = Ext.getCmp('org').getValue();
			if (org == "-1")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg74+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('org').focus(true,true);
						Ext.getCmp('utype').setValue("none");
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
		}

		var selectedUserType = Ext.getCmp('utype').getValue();
		if (selectedUserType == "none")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userRoleValidationMsg+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			userformcontainerObj.setActiveTab(0);
			return false;
		}
		var monitoraccess = publicJSON['hasmonitoraccess'];
		var pwdminlen = publicJSON['pwdLength'];
		var pwdComplexityLength = publicJSON['pwdComplexityCount'];
		if (pwdminlen == "" || pwdminlen < 2)
		{
			pwdminlen = 8;
		}
		else if(pwdminlen != "" && pwdminlen < pwdComplexityLength)
		{
			pwdminlen = pwdComplexityLength;
		}
		var checkStr = "";
		var radioval = "";
		var msgmode = "";
		var high = "";
		var medium = "";
		var low = "";
		var sub = true;
		var utype = Ext.getCmp('utype').getValue();
		var never = Ext.getCmp('Never').getValue();
		var tomail;
		var ccmail;
		var bccmail;
		var customScr;//add by sunder
		var escmail;
		var checkToStr
		var checkCcStr;
		var checkBccStr;
		var checkScriptStr;//add by sunder
		var checkEscStr;
		var orStr = " or ";
		var sep="'";

		// aruna - modified - start
		tomail= Ext.getCmp('tomailid');
		ccmail = Ext.getCmp('ccmailid');
		bccmail = Ext.getCmp('bccmailid');

		checkToStr = tomail.getValue();
		checkCcStr = ccmail.getValue();
		checkBccStr = bccmail.getValue();

		// aruna - modified - end

		if(monitoraccess == true || monitoraccess == 'true')
		{
			//tomail= Ext.getCmp('tomailid'); // aruna - modified
			//ccmail = Ext.getCmp('ccmailid');
			//bccmail = Ext.getCmp('bccmailid'); put these code outside the if condition
			escmail = Ext.getCmp('escmailid');
			customScr =  Ext.getCmp('customScript');

			//checkToStr = tomail.getValue(); // aruna - modified
			//checkCcStr = ccmail.getValue();
			//checkBccStr = bccmail.getValue(); put these code outside the if condition
			checkScriptStr = customScr.getValue();
			checkEscStr = escmail.getValue();
		}
		var tilldate = Ext.getCmp('tilldate').getValue();
		var tilldate_h = Ext.getCmp('tilldate_h').getValue();
		var hiddenFields = publicJSON.hiddenFields;
		var usname = hiddenFields.username1;

		var tillhr = hiddenFields.tillhr;
		var tillmin = hiddenFields.tillmin;
		var currentdate = hiddenFields.currentdate;
		var currenthr = hiddenFields.currenthr;
		var currentmin = hiddenFields.currentmin;
		var eedateforpro;
		var authType='';

		if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
		{
			if (Ext.getCmp('eGAuthSAML').getValue() == true)
			{
				authType ='Eg';
			}
			else if (Ext.getCmp('idpAuthSAML').getValue() == true)
			{
				authType ='SAML';
			}
			else
			{
				authType = 'Domain';
			}
		}
		else
		{
			if (Ext.getCmp('eGAuth').getValue() == true)
			{
				authType ='Eg';
			}
			else
			{
				authType = 'Domain';
			}
		}

		if (authType == 'SAML')
		{
			var idpName = Ext.getCmp('idpName').getValue();
			if (!Ext.isEmpty(idpName) && idpName == 'none')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIdpValidationMsg+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
		}

		var unameck = "";
		unameck = Ext.getCmp('uname').getValue();
		var user_Id = true;
		var user_pwd = true;
		var regExp1=/^(\+\d\d)?[0-9]+$/g;
		var reg3 = /(((([\+]?([0-9]){4,15})|([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])+)\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z])|((\+\d\d)?[0-9]+))/g

		var tmpVal1 = Ext.getCmp('tomailid').getValue();
		var tmpVal2 = Ext.getCmp('ccmailid').getValue();
		var tmpVal3 = Ext.getCmp('bccmailid').getValue();
		var tmpVal4 = Ext.getCmp('escmailid').getValue();

		var toMailResult=validateEmail(tmpVal1);
		var ccMailResult=validateEmail(tmpVal2);
		var bccMailResult=validateEmail(tmpVal3);
		var escMailResult=validateEmail(tmpVal4);

		var toMobResult=(tmpVal1).match(regExp1);
		var ccMobResult=(tmpVal2).match(regExp1);
		var bccMobResult=(tmpVal3).match(regExp1);
		var escMobResult=(tmpVal4).match(regExp1);

		var toResult=(tmpVal1).match(reg3);
		var ccResult=(tmpVal2).match(reg3);
		var bccResult=(tmpVal3).match(reg3);
		var escResult=(tmpVal4).match(reg3);

		if(unameck !=null && unameck!="")
		{
			if(usname!=null&&usname!="")
			{
				if (authType=='SAML')
				{
					var idpName = Ext.getCmp('idpName').getValue();
					unameck = 'samlsso/'+idpName+'/'+unameck;
				}
				var myarr = usname.split("|hash|");
				for (i=0;i<myarr.length;i++)
				{
					if(myarr[i].toLowerCase()==unameck.toLowerCase())
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: userIDValidationMsg+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn){
								Ext.getCmp('uname').focus(true);
							}
						});
						userformcontainerObj.setActiveTab(0);
						return false;
					}
				}
			}
		}

		var userName = Ext.getCmp('uname');
		if (userName != null && userName != 'undefined' && authType == 'Eg')
		{
			var tmpUname = userName.getValue();
			if(!checkblank(tmpUname))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg2+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				sub = false;
				return sub;
			}
			else if(!checkSpecial(userName,"=\"/"))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: _checkspecial,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn: function()
					{
						userformcontainerObj.setActiveTab(0);
						userName.focus(true);
					}
				});
				sub = false;
				return sub;
			}
			else if(trim(tmpUname) == "")
			{
				userformcontainerObj.setActiveTab(0);
				userName.focus(true);
				sub = false;
				return sub;
			}
			else if (tmpUname.indexOf("..") > -1)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: _checkdots+".",
					buttons: Ext.Msg.OK,
					width : 300,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				sub = false;
				return sub;
			}
			else if (tmpUname.toUpperCase() == "ADMIN" || tmpUname.toUpperCase() == "SUPERMONITOR" || tmpUname.toUpperCase() == "MONITOR" || tmpUname.toUpperCase() == "NONE" )
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg3 +" '"+tmpUname+"'.",
					buttons: Ext.Msg.OK,
					width : 300,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				sub = false;
				return sub;
			}

			if (tmpUname.toUpperCase() == "NULL")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg3 +" '"+tmpUname+"'.",
					buttons: Ext.Msg.OK,
					width : 300,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				sub = false;
				return sub;
			}
			checkSpace = tmpUname;
			if (checkSpace.indexOf(' ') == 0 ) //||checkSpace.indexOf('.')==0 || checkSpace.indexOf('-')==0 || checkSpace.indexOf('_')==0 )
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg4 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}

			if (checkSpace.lastIndexOf(' ')==checkSpace.length-1)//jamesthomas
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg5 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			if (isDoubleByteEnabled == "false")
			{
				user_Id = validateSingleByte(tmpUname);
				user_pwd = validateSingleByte(Ext.getCmp('upass').getValue());
				//userformcontainerObj.setActiveTab(0);
			}
			if (!user_Id)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg6 +".",
					buttons: Ext.Msg.OK,
					width : 500,
					icon: 'iconExclamation',
					fn : function(btn){
						userName.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}

			if (!Ext.isEmpty(enforceEmailIDInMSP) && enforceEmailIDInMSP.toLowerCase() == 'true')
			{
				var org = Ext.getCmp('org').getValue();
				var getDeepAllChildNodes = appCnt.getDeepAllChildNodes(org);

				if(!Ext.isEmpty(getDeepAllChildNodes) && getDeepAllChildNodes.toLowerCase() != 'egenterprise')
				{
					var regExp = /[\#]?([a-zA-Z0-9]+[\#\ \_\.\-\&]?)*[a-zA-Z0-9]\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]/g;
					var toMailResult= tmpUname.match(regExp);
					if (toMailResult != tmpUname.toString())
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: userIDEmailValidationMsg+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn){
								userName.focus(true);
							}
						});
						userformcontainerObj.setActiveTab(0);
						return false;
					}
				}
			}
		}

		// aruna - modified - start
		//if(monitoraccess == true || monitoraccess == 'true')
		//{
			if((checkToStr != "") && (toMailResult==false && toMobResult == null) && (toResult != tmpVal1))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg15 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						tomail.focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(tomail.getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg16 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						tomail.focus(true);
					}
				});
				return false;
			}
			else if((checkCcStr != "") && (ccMailResult==null || ccMailResult==false) && ccMobResult == null && (ccResult!= tmpVal2))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg17 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						ccmail.focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(tmpVal2))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg18 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						ccmail.focus(true);
					}
				});
				return false;
			}
			else if((checkBccStr != "") && (bccMailResult==null || bccMailResult==false) && bccMobResult == null && bccResult != tmpVal3)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg19 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						bccmail.focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(tmpVal3))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg20 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						bccmail.focus(true);
					}
				});
				return false;
			}
		//}
		// aruna - modified - end

		if (authType == 'Eg')
		{
			var passObj =  Ext.getCmp('upass');
			var cpassObj =  Ext.getCmp('confpasswd');
			var loginPassword = Ext.getCmp('upass').getValue();
			var cloginPassword = Ext.getCmp('confpasswd').getValue();
			if(loginPassword == "")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg7 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						passObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!checkloginpass(loginPassword))
			{
				userformcontainerObj.setActiveTab(0);
				passObj.focus(true);
				return false;
			}
			else if(loginPassword.length<pwdminlen)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: passLabel1+" "+pwdminlen+" "+passLabel2,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						passObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!user_pwd)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg9 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						passObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(cloginPassword == "")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg10 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						cpassObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!checkloginpass(cloginPassword))
			{
				userformcontainerObj.setActiveTab(0);
				cpassObj.focus(true);
				return false;
			}
			else if(loginPassword != cloginPassword)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg11 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						cpassObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
		}
		else if (authType == 'Domain' || authType == 'domain')
		{
			var operationType = '';
			var domainNameText = me.getDomainName().getValue();
			if (Ext.getCmp('radioOperation2').getValue() == true)
			{
				operationType = "Group";
			}
			if (operationType != null && operationType == 'Group')
			{
				var grpname = Ext.getCmp('grpname').getValue();
				if (grpname.indexOf("Click on the icon to select a group") != -1 || grpname.length == 0)
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg12 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							Ext.getCmp('grpname').focus(true);
						}
					});
					userformcontainerObj.setActiveTab(0);
					return false;
				}
			}
			else
			{
				if (domainNameText == "-1" || domainNameText == 'none')
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userDomainValidationMsg +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					userformcontainerObj.setActiveTab(0);
					return false;
				}
				else if (me.getUname().getValue() == "" || me.getUname().getValue().length == 0)
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg2 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							me.getUname().focus(true);
						}
					});
					userformcontainerObj.setActiveTab(0);
					return false;
				}
				else if (!this.getBtnValidate().isHidden())
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg63 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							me.getUname().focus(true);
						}
					});
					userformcontainerObj.setActiveTab(0);
					return false;
				}
			}
		}

		if(Ext.getCmp('Never').getValue() == false)
		{
			var comFormat = "";
			var ssdate = currentdate;
			var eedateforpro = formatDate(new Date(getDateFromFormat(Ext.getCmp('tilldate_h').getValue(),currentDFormat)),"MM/dd/yyyy");
			Ext.getCmp('dateforpro').setValue(eedateforpro);
			if(!checkblank(tilldate))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg13 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('tmptilldate').focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!checkUserValidityTime(ssdate,eedateforpro,currenthr,tillhr,currentmin,tillmin))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg14 +".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('tmptilldate').focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
		}

		if(from == "logoUpload")
		{
			return 'userValid';//if valform called from logoUpload return back,after checking valid uName;
		}

		if(monitoraccess==true || monitoraccess=='true')
		{
			var high = Ext.getCmp('high').getValue();
			var medium = Ext.getCmp('medium').getValue();
			var low = Ext.getCmp('low').getValue();
			var a_high = Ext.getCmp('alarm_h').getValue();
			var a_medium = Ext.getCmp('alarm_m').getValue();
			var a_low = Ext.getCmp('alarm_l').getValue();

			if(high==true || medium==true || low ==true)
			{
				radioval = Ext.getCmp('alarmNotify').notify;
				msgmode = Ext.getCmp('alarmMsgMode').msgmode;

				if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no')
				{
					if (!customScr.isVisible() && !Ext.isEmpty(checkScriptStr) && checkScriptStr.length > 0)
					{
						checkScriptStr = '';
					}
				}
				if(checkToStr == "" && checkScriptStr == "")
				{
					var msgStr = userIDValidationMsg43+sep+userIDValidationMsg44+sep+orStr+sep+userIDValidationMsg45+sep +".";
					var widthVal = 500;
					if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no')
					{
						msgStr = userIDValidationMsg66;
						widthVal = 400;
					}

					if (checkToStr == "")
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: msgStr,
							buttons: Ext.Msg.OK,
							width : widthVal,
							icon: 'iconExclamation',
							fn : function(btn){
								tomail.focus(true);
							}
						});
						return false;
					}
					else
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: msgStr,
							buttons: Ext.Msg.OK,
							width : widthVal,
							icon: 'iconExclamation',
							fn : function(btn){
								customScr.focus(true);
							}
						});
						return false;
					}
					
				}

				if((checkToStr != "") && (toMailResult==false && toMobResult == null) && (toResult != tmpVal1))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg15 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							tomail.focus(true);
						}
					});
					return false;
				}
				else if(!validateSingleByte(tmpVal1))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg16 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							tomail.focus(true);
						}
					});
					return false;
				}
				else if((checkCcStr != "") && (ccMailResult==null || ccMailResult==false) && ccMobResult == null && (ccResult!= tmpVal2))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg17 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							ccmail.focus(true);
						}
					});
					return false;
				}
				else if(!validateSingleByte(tmpVal2))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg18 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							ccmail.focus(true);
						}
					});
					return false;
				}
				else if((checkBccStr != "") && (bccMailResult==null || bccMailResult==false) && bccMobResult == null && bccResult != tmpVal3)
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg19 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							bccmail.focus(true);
						}
					});
					return false;
				}
				else if(!validateSingleByte(tmpVal3))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg20 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							bccmail.focus(true);
						}
					});
					return false;
				}


				
				if(!checkspecial(checkScriptStr,"@*+=[]|;\"\'<>?"))
				{
						customScr.focus(true);
						return false;
				}
				else if(!validateSingleByte(customScr.getValue()))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg20 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							bccmail.focus(true);
						}
					});
					return false;
				}
				else if(!validateSingleByte(tmpVal4))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg21 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							escmail.focus(true);
						}
					});
					return false;
				}
				
				if (checkEscStr != "" && (escMailResult==null || escMailResult==false) && escMobResult  == null && escResult != tmpVal4 )
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg22 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							escmail.focus(true);
						}
					});
					return false;
				}

				if(checkBccStr != "" || checkCcStr != "")
				{
					if(checkToStr == "")
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: userIDValidationMsg15 +".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn : function(btn){
								Ext.getCmp('tomailid').focus(true);
							}
						});
						return false;
					}
				}


				var mailshiftField = Ext.getCmp('mailshift').getValue()
				if(checkToStr == "" && mailshiftField == true)
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg23+orStr+userIDValidationMsg24+sep+userIDValidationMsg25+sep +".",
						buttons: Ext.Msg.OK,
						width : 500,
						icon: 'iconExclamation',
						fn : function(btn){
							Ext.getCmp('tomailid').focus(true);
						}
					});
					return false;
				}
				
				if(checkToStr !="" && mailshiftField == "yes")
				{
					var isMailValid = true;
					if((checkToStr !="" && toMailResult==false) || (checkBccStr != "" && bccMailResult==false) || (checkCcStr != "" && ccMailResult==false))
					{
						var flag1 = validateMailID(tmpVal1);
						var flag2 = validateMailID(tmpVal3);
						var flag3 = validateMailID(tmpVal2);

						if(!flag1 && !flag2 && !flag3)
						{
							isMailValid = false;
						}
					}
					if(!isMailValid)
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: userIDValidationMsg23+orStr+userIDValidationMsg24+sep+userIDValidationMsg25+sep +".",
							buttons: Ext.Msg.OK,
							width : 500,
							icon: 'iconExclamation',
							fn : function(btn){
								Ext.getCmp('tomailid').focus(true);
							}
						});
						return false;
					}
				}
				
				var smsshiftField = Ext.getCmp('smsshift').getValue();
				if(checkToStr =="" && smsshiftField == true)
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg26+orStr+userIDValidationMsg24+sep+userIDValidationMsg27+sep +".",
						buttons: Ext.Msg.OK,
						width : 500,
						icon: 'iconExclamation',
						fn : function(btn){
							Ext.getCmp('tomailid').focus(true);
						}
					});
					return false;
				}
				if(checkToStr !="" && smsshiftField == "yes")
				{
					var isMobileValid = true;
					if((checkToStr !="" && toMobResult!=tmpVal1) || (checkBccStr != "" && bccMobResult!=tmpVal3) || (checkCcStr != "" && ccMobResult!=tmpVal2))
					{
						var flag1 = validateMobileNo(tmpVal1);
						var flag2 = validateMobileNo(tmpVal3);
						var flag3 = validateMobileNo(tmpVal2);

						if(!flag1 && !flag2 && !flag3)
						{
							isMobileValid = false;
						}
					}
					if(!isMobileValid)
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: userIDValidationMsg26+orStr+userIDValidationMsg24+sep+userIDValidationMsg27+sep+".",
							buttons: Ext.Msg.OK,
							width : 500,
							icon: 'iconExclamation',
							fn : function(btn){
								Ext.getCmp('tomailid').focus(true);
							}
						});
						return false;
					}
				}
				//if((checkEscStr == "") ||(checkEscStr != ""))
			//	if(true)
				{
					var firstlevel="";
					var firstlev;
					if (inputs>0)
					{
						var escLev1=Ext.getCmp('escmailid');
						var escLev1Value = escLev1.getValue();
						var escLev1Result=validateEmail(escLev1Value);
						var escLev1MobResult=(escLev1Value).match(regExp1);
						var escResult=(escLev1Value).match(reg3);
						
						if (escLev1Value == "")
						{
							Ext.Msg.show({
								title: pageTitle,
								msg: userIDValidationMsg28+".",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn : function(btn){
									escLev1.focus(true);
								}
							});
							return false;
						}
						else if((escLev1Result==null || escLev1Result==false) && escLev1MobResult == null && escResult != escLev1Value)
						{
							Ext.Msg.show({
								title: pageTitle,
								msg: userIDValidationMsg28+".",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn : function(btn){
									escLev1.focus(true);
								}
							});
							return false;
						}
						else if(!validateSingleByte(escLev1Value))
						{
							Ext.Msg.show({
								title: pageTitle,
								msg: userIDValidationMsg29+".",
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation',
								fn : function(btn){
									escLev1.focus(true);
								}
							});
							return false;
						}
					}

					for(var i=0;i<=inputs;i++)
					{
						var ecsElclevelvar = (("email")+i);
						var inpVal = Ext.getCmp(ecsElclevelvar);
						if (inpVal == null | inpVal == 'undefined')
						{
							continue;
						}
						var thisMailID = inpVal.getValue();
						if (thisMailID == "")
						{
							Ext.Msg.show({
								title: pageTitle,
								msg: userIDValidationMsg30+" "+(i+2)+" "+userIDValidationMsg31+".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconExclamation',
								fn : function(btn){
									if (escmail.getValue() =="")
									{
										escmail.focus(true);
									}
									else
									{
										inpVal.focus(true);
									}
								}
							});
							return false;
						}

						var tempResult=validateEmail(thisMailID);
						var tempMobResult=(thisMailID).match(regExp1);
						var tempRegResult=(thisMailID).match(reg3);
						if((tempResult==null || tempResult==false) && tempMobResult == null && tempRegResult != thisMailID)
						{
							Ext.Msg.show({
								title: pageTitle,
								msg: userIDValidationMsg30+" "+(i+2)+" "+userIDValidationMsg31+".",
								buttons: Ext.Msg.OK,
								width : 300,
								icon: 'iconExclamation',
								fn : function(btn){
									if (escmail.value=="")
									{
										escmail.focus(true);
									}
									else
									{
										inpVal.focus(true);
									}
								}
							});
							return false;
						}
						else if(!validateSingleByte(thisMailID))
						{
							Ext.Msg.show({
								title: pageTitle,
								msg: userIDValidationMsg30+" "+(i+2)+" "+userIDValidationMsg32+".",
								buttons: Ext.Msg.OK,
								width : 500,
								icon: 'iconExclamation',
								fn : function(btn){
									inpVal.focus(true);
								}
							});
							return false;
						}
					}
				}
				if(radioval == "")
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg33+".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false
				}
				if(msgmode == "")
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg34+".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false
				}
			}
			if(a_high == false && a_medium== false && a_low == false)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg35+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false
			}
		}

		var count = parseInt(noOfShiftPeriods);
		var mailshiftField = Ext.getCmp('mailshift').getValue().mailshift;
		if (mailshiftField != null && mailshiftField == 'yes')
		{
			for (var i=0;i<count;i++)
			{
				var mailday = Ext.getCmp('mailday'+i);
				var mailshift = Ext.getCmp('mailshift'+i);
				if (mailday == null || mailshift == null)
				{
					continue;
				}
				if ((high == true || medium == true || low == true) && (!checkblank(mailday.getValue()) || !checkblank(mailshift.getValue())))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg36+".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}
		}

		var smsShiftAlerts = Ext.getCmp('smsshift').getValue().smsshift;
		if (smsShiftAlerts != null && smsShiftAlerts == 'yes')
		{
			for (var i=0;i<count;i++)
			{
				var smsday =  Ext.getCmp('smsday'+i);
				var smsshift =  Ext.getCmp('smsshift'+i);
				if (smsday == null || smsshift == null)
				{
					continue;
				}
				if ((high == true || medium == true || low == true) && (!checkblank(smsday.getValue()) || !checkblank(smsshift.getValue())))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg37+".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}
		}

		var escShiftAlerts = Ext.getCmp('escshift').getValue().escshift;
		if (escShiftAlerts != null && escShiftAlerts == 'yes')
		{
			if (escmail != null && escmail.value=='')
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg28+orStr+userIDValidationMsg24+sep+userIDValidationMsg38+sep+".",
					width : 400,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
			for (var i=0;i<count;i++)
			{
				var escday = Ext.getCmp('escday'+i);
				var escshift = Ext.getCmp('escshift'+i);
				if (escday == null || escshift == null)
				{
					continue;
				}
				if ((high == true || medium == true || low == true) && (!checkblank(escday.getValue()) || !checkblank(escshift.getValue())))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg39+".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}
		}

		var commandShiftAlerts = Ext.getCmp('Execshift').getValue().Execshift;
		if(commandShiftAlerts != null && commandShiftAlerts == 'yes')
		{
			var command = Ext.getCmp('customScript').getValue();
			if(command == "")
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg40+orStr+userIDValidationMsg24+sep+userIDValidationMsg41+sep+".",
					buttons: Ext.Msg.OK,
					width : 500,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('customScript').focus(true);
					}
				});
				return false;
			}
			for (var i=0;i<count;i++)
			{
				var mailday = Ext.getCmp('Execday'+i);
				var mailshift = Ext.getCmp('Execshift'+i);
				if (mailday == null || mailshift == null)
				{
					continue;
				}
				if ((high == true || medium == true || low == true) && (!checkblank(mailday.getValue()) || !checkblank(mailshift.getValue())))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg42+".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					return false;
				}
			}

		}
		var loginLogo1 = Ext.getCmp('loginLogo1').getValue();
		var monitorLogo1 = Ext.getCmp('monitorLogo1').getValue();
		var reporterLogo1 = Ext.getCmp('reporterLogo1').getValue();
		var configLogo1 = Ext.getCmp('configLogo1').getValue();
		if(loginLogo1 == "hide")
		{
			Ext.getCmp('loginImageStatus').setValue('');
			Ext.getCmp('loginImageUploadStatusForAudit').setValue('no');
		}
		else
		{
			if (!isLoginImgUpdated)
			{
				Ext.Msg.alert(pageTitle,uploadImgMsg + " '"+uploadImgMsg4+"'");
				return false;
			}
			Ext.getCmp('loginImageUploadStatusForAudit').setValue('yes');
		}

		if(monitorLogo1=="hide")
		{
			Ext.getCmp('monitorImageStatus').setValue('');
			Ext.getCmp('monitorImageUploadStatusForAudit').setValue('no');
		}
		else
		{
			if (!isAdminMonImgUpdated)
			{
				Ext.Msg.alert(pageTitle,uploadImgMsg + " '"+uploadImgMsg5+"' "+uploadImgMsg1);
				return false;
			}
			Ext.getCmp('monitorImageUploadStatusForAudit').setValue('yes');
		}

		if(reporterLogo1=="hide")
		{
			Ext.getCmp('reporterImageStatus').setValue('');
			Ext.getCmp('reporterImageUploadStatusForAudit').setValue('no');
		}
		else
		{
			Ext.getCmp('reporterImageUploadStatusForAudit').setValue('yes');
		}

		if(configLogo1=="hide")
		{
			Ext.getCmp('configMgmtImageStatus').setValue('');
			Ext.getCmp('configMgmtImageUploadStatusForAudit').setValue('no');
		}
		else
		{
			Ext.getCmp('configMgmtImageUploadStatusForAudit').setValue('yes');
		}

		var logoCheck = Ext.getCmp('logoCheck').getValue();
		if (logoCheck == true)
		{
			Ext.getCmp('reporterImageStatus').setValue('');
			Ext.getCmp('reporterImageUploadStatusForAudit').setValue('no');
			Ext.getCmp('configMgmtImageStatus').setValue('');
			Ext.getCmp('configMgmtImageUploadStatusForAudit').setValue('no');
		}
		else
		{
			if(reporterLogo1 == "show" && utype != "AlarmViewer" && utype != "SuperAlarmViewer")
			{
				if (!isRepImgUpdated)
				{
					Ext.Msg.alert(pageTitle,uploadImgMsg + " '"+uploadImgMsg6+"' "+uploadImgMsg1);
					return false;
				}
			}

			if(configLogo1 == "show" && utype != "AlarmViewer" && utype != "SuperAlarmViewer" && isConfigEnabled == 'true')
			{
				if (!isConfigImgUpdated)
				{
					Ext.Msg.alert(pageTitle,uploadImgMsg + " '"+uploadImgMsg7+"' "+uploadImgMsg1);
					return false;
				}
			}
		}

		// 2fa validation - starts here

		var flag = new Boolean(true);
		var is2FACFlagEnabled = publicJSON['is2FACFlagEnabled'];

		var isVisibleUserAuthSAML = Ext.getCmp('userAuthSAML').isVisible();
		var userAuthSAMLVal = Ext.getCmp('idpAuthSAML').getGroupValue();

		if (isVisibleUserAuthSAML && userAuthSAMLVal.toLowerCase() == 'saml')
		{
			flag = new Boolean(false);
		}

		if (flag == true && !Ext.isEmpty(is2FACFlagEnabled) && is2FACFlagEnabled.toLowerCase() == "yes")
		{
			var tomailid2FAVal = Ext.getCmp('tomailid').getValue();

			if (Ext.isEmpty(tomailid2FAVal) || Ext.String.trim(tomailid2FAVal).length == 0)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg67+'. '+userIDValidationMsg68,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('tomailid').focus(true);
					}
				});
				return false;
			}
		}
		// 2fa validation - ends here

		return true;
	},

	onSrvGroupChange : function(obj)
	{
		var selectedValue = obj.getValue();
		Ext.getCmp('selectedServerListGrid').getStore().each(function(rec)
		{
			if (!Ext.isEmpty(rec.get("valueField_1")))
			{
				srvListArray.push(rec.get("valueField_1"));
			}
			if (!Ext.isEmpty(rec.get("valueField_2")))
			{
				srvListArray.push(rec.get("valueField_2"));
			}
			if (!Ext.isEmpty(rec.get("valueField_3")))
			{
				srvListArray.push(rec.get("valueField_3"));
			}
		});

		var tmpStore = Ext.getCmp('selectedCompDetails');
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		
		var url = 'EgAddUser/data/EgConfigureCompTypeJson.jsp?from=commonSettings&DiscOptions='+selectedValue+'&ServerDisplay='+srvListArray+'&LoadCount='+loadCount;
		this.updateCofigData(url);
		
		var managedServers = userCompJSON['generalSettings']['discSrvrArray'];
		var unmanagedServers = userCompJSON['generalSettings']['allSrvrArray'];

		tmpStore.fromField.store.add(managedServers);
		tmpStore.toField.store.add(unmanagedServers);
		loadCount++;
	},
	
	updateCofigData : function(url)
	{
		Ext.Ajax.request({
			url : url,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userCompJSON = Ext.decode(jsonText);
			}
		});
	},
	
	applySeverChange : function()
	{
		var me = this;
		var selectedSrvList = srvListArray;
		//if (selectedSrvList.length > 0)
		{
			var selectedCompDetails = srvListArray.toString();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Saving...'});
			myMask.show();
			Ext.Ajax.request({
				url : 'EgAddUser/data/EgConfigureCompTypeJson.jsp?LoadCount='+loadCount,
				params : {
					'from' : 'commonSettings',
					'selectedCompDetails' : selectedCompDetails
				},
				success: function(response)
				{
					myMask.hide();
					userCompJSON = Ext.decode(response.responseText);
					var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
					selectedServerListGridObj.getStore().loadRawData(userCompJSON['generalSettings']['configuredServersList']);
					var tmpCount = parseInt(userCompJSON['generalSettings']['configuredServersCount']);
					selectedServerListGridObj.doLayout();
					selectedServerListGridObj.view.refresh();
					if (tmpCount > 9)
					{
						selectedServerListGridObj.setHeight(100);
					}
					Ext.getCmp('resultHeaderCt').show();
					isApplied = true;
					if(isSavedFromPrompt)
					{
						compSaveMask.hide();
						Ext.getCmp('configurationWindow').close();
					}
				}
			});
		}
		//else
		//{
			//Ext.MessageBox.show({
				//title: pageTitle,
				//msg: intnlLabel13 + ".",
				//buttons: Ext.MessageBox.OK,
				//icon: 'iconExclamation'
			//});
			//return;
		//}
	},

	refreshWindow:function()
	{
		var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
		selectedServerListGridObj.getStore().loadRawData(publicJSON['generalSettings']['configuredServersList']);
		selectedServerListGridObj.doLayout();
		selectedServerListGridObj.view.refresh();
	}
});

function validateMailID(toMail)
{
	var regExp1=/^(\+\d\d)?[0-9]+$/g;
	var arr = toMail.split(',');
	var arrCnt = arr.length;
	var isValidMailid = false;
	if(arrCnt != null && arrCnt == 1)
	{
		var toMailResult= validateEmail(arr);
		if (arr != null && toMailResult == true)
		{
			var isValidMailid = true;
		}
	}
	else
	{
		for(var i=0; i<arr.length; i++)
		{
			var toMailResult= validateEmail(arr[i]);
			var toSmsResult= arr[i].match(regExp1);
			if (arr[i] != null && toMailResult == true)
			{
				isValidMailid = true;
				//break;
			}
			else if (arr[i] != null && toSmsResult == arr[i])
			{
				continue;
			}
			else
			{
				isValidMailid = false;
				break;
			}
		}
	}
	return isValidMailid;
}

function validateMobileNo(toSms)
{
	var regExp1=/^(\+\d\d)?[0-9]+$/g;
	var arr = toSms.split(',');
	var arrCnt = arr.length;
	var isValidNumber = false;

	if(arrCnt != null && arrCnt == 1)
	{
		var toSmsResult= arr.toString().match(regExp1);
		if (arr != null && toSmsResult == arr.toString())
		{
			isValidNumber = true;
		}
	}
	else
	{
		for(var i=0; i<arr.length; i++)
		{
			var toSmsResult= arr[i].match(regExp1);
			var toMailResult= validateEmail(arr[i]);
			if (arr[i] != null && toSmsResult == arr[i])
			{
				isValidNumber = true;
				//break;
			}
			else if (arr[i] != null && toMailResult == true)
			{
				continue;
			}
			else
			{
				isValidNumber = false;
				break;
			}
		}
	}
	return isValidNumber;
}

/*function loadDomainGroupWindow()
{
	Ext.widget("window",{
		extend:'Ext.panel.Panel',
		alias:'widget.groupWindow',
		title : 'Domain Groups',
		width: 900,
		height: 500,
		modal : true,
		floatable:true,
		floating :true,
		autoScroll:true,
		id:'groupWindow',
		closeAction: 'destory',
		doClose: function() {
			this.destroy();
		},
		layout:{
			type:'fit'
		},
		items:[{
			xtype : "component",
			id:"drillDownContentDiv",
			autoEl:{
				tag:'iframe',
				frameborder:'0',
				height:'100%',
				src :'/final/admin/EgListGroupTree.jsp?'+new Date().getTime()
			}
		}]
	}).show();
}*/

function loadDomainGroupWindow()
{
	selectedDomainDisplayName = Ext.getCmp('domainName').getValue();
	if (selectedDomainDisplayName == "none")
	{
		Ext.Msg.show({
			title: pageTitle,
			msg: userDomainValidationMsg+".",
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return false;
	}

	Ext.widget("window",{
		extend:'Ext.container.Container',
		alias:'widget.groupWindow',
		title : 'Domain Groups',
		id:'groupWindow',
		width: 900,
		height: 505,
		padding : '5px 10px 10px 10px',
		modal : true,
		border : false,
		floatable:true,
		floating :true,
		autoScroll:false,
		resizable: false,
		closeAction: 'destory',
		doClose: function() {
			this.destroy();
		},
		layout:{
			type:'fit'
		},
		items:[{
			xtype : 'egdomaingrouptree'
		}]
	}).show();
}

function setSelectedGroupName(grpName)
{
	if (grpName != null && grpName.length > 0)
	{
		Ext.getCmp('grpname').setValue(grpName);
	}
	Ext.getCmp('groupWindow').destroy();
}

function setWindowTitle(title)
{
	Ext.getCmp('rightPane').setTitle(title);
}

function addContact()
{
	var mainForm = Ext.getCmp('userformcontainer');
	if(inputs == 4)
	{
		Ext.Msg.show({
			title: pageTitle,
			msg: userIDValidationMsg46+".",
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	var levelStr = inputs+2
	var conId = "con_"+inputs
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		//layout : {
		//	type : 'hbox',
		//},
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: 'email'+inputs,
				cls: 'textbox',
				name: 'email'+inputs,
				fieldLabel : 'Level '+levelStr,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.97,
				margin: '1 0 10 0'
			},
			{
				xtype : 'container',
				columnWidth: 0.03,
				margin: '20 0 5 2',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove level'
					});
					}
					},
					//tooltip : '<b>remove level</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeContact(conId);
					}
				}]
			}
		]
	}
	escMailIDsDiv.add(tmpContainer);
	mainForm.doLayout();
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('escmailid').getBox().y - 200);
	inputs++;
}


function addEscLevel(fieldValue)
{
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	var levelStr = inputs+2;
	var conId = "con_"+inputs;
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		//layout : {
		//	type : 'hbox',
		//	//padding : '5px'
		//},
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: 'email'+inputs,
				cls: 'textbox',
				name: 'email'+inputs,
				fieldLabel : 'Level '+levelStr,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.97,
				margin: '1 0 10 0',
				value : fieldValue,
			},
			{
				xtype : 'container',
				columnWidth: 0.03,
				margin: '20 0 5 2',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove level'
					});
					}
					},
					//tooltip : '<b>remove level</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeContact(conId);
					}
				}]
			}
		]
	}
	escMailIDsDiv.add(tmpContainer);
	inputs++;
}

function removeContact(containerID)
{
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	escMailIDsDiv.remove(containerID);
	inputs--;

	var conLength = escMailIDsDiv.items.length - 1;
	if (conLength > 0)
	{
		inputs = 0;
		var tnpCount = 0;
		for (var i = 0;i<=conLength;i++)
		{
			var tmpLevelObj = Ext.getCmp("con_"+i);
			if (tmpLevelObj == null || tmpLevelObj == undefined)
			{
				continue;
			}
			var tmpID = tmpLevelObj.getId();
			var value = Ext.getCmp('email'+i).getValue();
			escMailIDsDiv.remove(tmpID);
			addEscLevel(value);
		}
	}
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('escmailid').getBox().y - 200);
}

function addShifts(type)
{
	var shiftPeriodsCount;
	if (type == "mail")
	{
		var emailMailAlert = Ext.getCmp('emailMailAlert');
		if (mailShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg47+' ('+noOfShiftPeriods+')'+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		shiftPeriodsCount = mailShiftPeriodsCount;
		emailMailAlert.add(getMailShiftTemplate(shiftPeriodsCount));
		mailShiftPeriodsCount++;
		emailMailAlert.doLayout();
		Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('mailday0').getBox().y - 200);
	}
	else if (type == "Exec")
	{
		var commandObj = Ext.getCmp('commandAlert');
		if (ExecShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg47+' ('+noOfShiftPeriods+')'+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		shiftPeriodsCount = ExecShiftPeriodsCount;
		commandObj.add(getExecTemplate(shiftPeriodsCount));
		ExecShiftPeriodsCount++;
		commandObj.doLayout();
		Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('Execday0').getBox().y - 200);
	}
	else if (type == "sms")
	{
		var smsAlert = Ext.getCmp('smsAlert');
		if (smsShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg47+' ('+noOfShiftPeriods+')'+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		shiftPeriodsCount = smsShiftPeriodsCount;
		smsAlert.add(getSMSTemplate(shiftPeriodsCount));
		smsShiftPeriodsCount++;
		smsAlert.doLayout();
		Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('smsday0').getBox().y - 200);
	}
	else if (type == "esc")
	{
		var escMailAlert = Ext.getCmp('escMailAlert');
		if (escShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg47+' ('+noOfShiftPeriods+')'+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		shiftPeriodsCount = escShiftPeriodsCount;
		escMailAlert.add(getEscTemplate(shiftPeriodsCount));
		escShiftPeriodsCount++;
		escMailAlert.doLayout();
		Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('escday0').getBox().y - 200);
	}
}

function removeMailShift(containerID)
{
	var escMailIDsDiv = Ext.getCmp('emailMailAlert');
	escMailIDsDiv.remove(containerID);
	mailShiftPeriodsCount--;
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('mailday0').getBox().y - 200);
}

function removeExecShift(containerID)
{
	var commandAlert = Ext.getCmp('commandAlert');
	commandAlert.remove(containerID);
	ExecShiftPeriodsCount--;
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('Execday0').getBox().y - 200);
}

function removeSMSShift(containerID)
{
	var smsAlert = Ext.getCmp('smsAlert');
	smsAlert.remove(containerID);
	smsShiftPeriodsCount--;
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('smsday0').getBox().y - 200);
}

function removeEscShift(containerID)
{
	var escMailAlert = Ext.getCmp('escMailAlert');
	escMailAlert.remove(containerID);
	escShiftPeriodsCount--;
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('escday0').getBox().y - 200);
}

function getMailShiftTemplate(id)
{
	var tmpId = "mailday"+(id+1);
	var tmpId2 = "mailshift"+(id+1);
	var conId = "mailShift_"+id
	var tmpShiftData = {
		xtype : 'container',
		id : conId,
		//layout : {
		//	type : 'hbox',
		//	//padding : '5px'
		//},
		margin: 5,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: tmpId,
				name : tmpId,
				cls: 'textbox',
				fieldLabel: userIDValidationMsg52,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\''+tmpId+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype:'textfield',
				id: tmpId2,
				name : tmpId2,
				cls: 'textbox',
				fieldLabel: userIDValidationMsg53,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\''+tmpId2+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype : 'container',
				columnWidth: 0.04,
				margin: '22 0 5 30',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove shift period'
					});
					}
					},
					//tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeMailShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function getExecTemplate(id)
{
	var tmpId = "Execday"+(id+1);
	var tmpId2 = "Execshift"+(id+1);
	var conId = "ExecShift_"+id
	var tmpShiftData = {
		xtype : 'container',
		id : conId,
		//layout : {
		//	type : 'hbox',
			//padding : '5px'
		//},
		margin: 5,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: tmpId,
				cls: 'textbox',
				name: tmpId,
				columnWidth: 0.4,
				margin: '1 0 10 20',
				fieldLabel: userIDValidationMsg52,
				labelAlign: 'top',
				labelSeparator: ' ',
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\''+tmpId+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype:'textfield',
				id: tmpId2,
				cls: 'textbox',
				name: tmpId2,
				columnWidth: 0.4,
				margin: '1 0 10 20',
				fieldLabel: userIDValidationMsg53,
				labelAlign: 'top',
				labelSeparator: ' ',
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\''+tmpId2+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype : 'container',
				columnWidth: 0.04,
				margin: '22 0 5 30',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove shift period'
					});
					}
					},
					//tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeExecShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function getSMSTemplate(id)
{
	var tmpId = "smsday"+(id+1);
	var tmpId2 = "smsshift"+(id+1);
	var conId = "SMSShift_"+id
	var tmpShiftData = {
		xtype : 'container',
		id : conId,
		//layout : {
		//	type : 'hbox',
		//	//padding : '5px'
		//},
		margin: 5,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: tmpId,
				cls: 'textbox',
				name: tmpId,
				columnWidth: 0.4,
				margin: '1 0 10 20',
				fieldLabel: userIDValidationMsg52,
				labelAlign: 'top',
				labelSeparator: ' ',
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\''+tmpId+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype:'textfield',
				id: tmpId2,
				cls: 'textbox',
				name: tmpId2,
				columnWidth: 0.4,
				margin: '1 0 10 20',
				fieldLabel: userIDValidationMsg53,
				labelAlign: 'top',
				labelSeparator: ' ',
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\''+tmpId2+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype : 'container',
				columnWidth: 0.04,
				margin: '22 0 5 30',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove shift period'
					});
					}
					},
					//tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeSMSShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function getEscTemplate(id)
{
	var tmpId = "escday"+(id+1);
	var tmpId2 = "escshift"+(id+1);
	var conId = "ESCShift_"+id
	var tmpShiftData = {
		xtype : 'container',
		id : conId,
		//layout : {
		//	type : 'hbox',
			//padding : '5px'
		//},
		margin: 5,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: tmpId,
				cls: 'textbox',
				name: tmpId,
				columnWidth: 0.4,
				margin: '1 0 10 20',
				fieldLabel: userIDValidationMsg52,
				labelAlign: 'top',
				labelSeparator: ' ',
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\''+tmpId+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype:'textfield',
				id: tmpId2,
				cls: 'textbox',
				name: tmpId2,
				columnWidth: 0.4,
				margin: '1 0 10 20',
				fieldLabel: userIDValidationMsg53,
				labelAlign: 'top',
				labelSeparator: ' ',
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\''+tmpId2+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype : 'container',
				columnWidth: 0.04,
				margin: '22 0 5 30',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove shift period'
					});
					}
					},
					//tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeEscShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function showDaysPicker(mailDayID)
{
	var tmpStore = publicJSON['daysPicker'];
	var expandWindow = Ext.create('Ext.window.Window',{
		title:'DAYS',
		width:150,
		modal : true,
		doClose: function() {
			this.destroy();
		},
		buttonAlign:'center',
		items:[
			{
				xtype: 'multiselectSi',
				cls:"multiselect",
				width: 200,
				scroll:true,
				name: 'multiselect',
				labelAlign:'left',
				id: 'daysList',
				name: 'daysList',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			}
		],
		buttons : [
			{
				text : 'Add',
				id : 'daysAdd',
				name : 'daysAdd',
				cls: 'quickMenuWhiteButton',
				margin: '0 0 10 0',
				handler : function()
				{
					var tmpStr = "";
					var daysList = Ext.getCmp('daysList');
					var objTemp = daysList.getSelected();
					if (!Ext.isEmpty(objTemp))
					{
						for (key in objTemp)
						{
							tmpStr = tmpStr + objTemp[key].get("valueField") + ",";
						}
						tmpStr = tmpStr.substring(0,tmpStr.length - 1);
						Ext.getCmp(mailDayID).setValue(tmpStr);
						expandWindow.destroy();
						expandWindow = null;
					}
					else
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: userIDValidationMsg64+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			}
		]
	}).show();
	var daysListObj = Ext.getCmp('daysList');
	daysListObj.getStore().loadRawData(tmpStore);
	var selectedDays = Ext.getCmp(mailDayID).getValue();
	daysListObj.setValue(selectedDays);
}

function showShiftsPicker(shiftId)
{
	var tmpHeight = 0;
	var expandWindow = Ext.create('Ext.window.Window',{
		title:'SHIFTS',
		requires : ['EgAddUser.view.ShiftsPicker'],
		width:460,
		//height:128,
		modal : true,
		id : 'shiftsPickerWinow',
		doClose: function() {
			tmpShiftPeriodsCount = 0
			this.destroy();
		},
		buttonAlign:'center',
		items : [
			{
				xtype: 'shiftspicker',
				border :false,
				listeners : {
					afterrender : function()
					{
						var selectedTimeVal = Ext.getCmp(shiftId).getValue();
						var shiftsPickerHour = publicJSON['shiftsPickerHour'];
						var shiftsPickerMi = publicJSON['shiftsPickerMi'];
						Ext.getCmp('frHr0').getStore().loadRawData(shiftsPickerHour);
						Ext.getCmp('frMi0').getStore().loadRawData(shiftsPickerMi);
						Ext.getCmp('toHr0').getStore().loadRawData(shiftsPickerHour);
						Ext.getCmp('toMi0').getStore().loadRawData(shiftsPickerMi);
					
						if (Ext.isEmpty(selectedTimeVal))
						{
							Ext.getCmp('frHr0').setValue(Ext.getCmp('frHr0').getStore().getAt(0).get("valueField"));
							Ext.getCmp('frMi0').setValue(Ext.getCmp('frMi0').getStore().getAt(0).get("valueField"));
							Ext.getCmp('toHr0').setValue(Ext.getCmp('toHr0').getStore().getAt(0).get("valueField"));
							Ext.getCmp('toMi0').setValue(Ext.getCmp('toMi0').getStore().getAt(0).get("valueField"));
						}
						else
						{
							var shiftTimeArr = selectedTimeVal.split(",");
							var tmpcount = 1;
							for (var i = 0;i<shiftTimeArr.length;i++)
							{
								if (tmpcount > 1)
								{
									tmpHeight = tmpHeight + 30;
									addShiftTimeTemp();
								}
								var tmpData = shiftTimeArr[i];
								var from = tmpData.substring(0,tmpData.indexOf("-"));
								var to = tmpData.substring(tmpData.indexOf("-")+1);
								var fromHr = from.substring(0,from.indexOf(":"));
								var fromMi = from.substring(from.indexOf(":")+1);
								var toHr = to.substring(0,to.indexOf(":"));
								var toMi = to.substring(to.indexOf(":")+1);
								Ext.getCmp('frHr'+i).setValue(fromHr);
								Ext.getCmp('frMi'+i).setValue(fromMi);
								Ext.getCmp('toHr'+i).setValue(toHr);
								Ext.getCmp('toMi'+i).setValue(toMi);
								tmpcount++;
							}
						}
					}
				}
			}
		],
		buttons : [
			{
				text : 'Add',
				cls: 'quickMenuWhiteButton',
				margin: '0 0 10 0',
				handler : function()
				{
					if (checkInputs())
					{
						var tmpStr = "";
						for (var i=0;i<5;i++)
						{
							var tmpFHr = Ext.getCmp('frHr'+i);
							if (tmpFHr == null)
								continue;

							var tmpFMi = Ext.getCmp('frMi'+i);
							var tmpTHr = Ext.getCmp('toHr'+i);
							var tmpTMi = Ext.getCmp('toMi'+i);
							var tmp = tmpFHr.value+":"+tmpFMi.value+"-"+tmpTHr.value+":"+tmpTMi.value;
							tmpStr += tmp+",";
						}
						tmpStr = tmpStr.substring(0,tmpStr.length-1);
						Ext.getCmp(shiftId).setValue(tmpStr);
						expandWindow.destroy();
						expandWindow = null; 
						tmpShiftPeriodsCount = 0;
					}
				}
			}
		]
	}).show();
	//Ext.getCmp(shiftId).setValue(tmpStr);
	//if (tmpHeight != 0)
	//{
	//	var windowHeight = 128+tmpHeight;
	//	expandWindow.setHeight(windowHeight);
	//}
}

function addShiftTime()
{
	var shiftspickerObj = Ext.getCmp('shiftspicker');
	if (tmpShiftPeriodsCount > 3)
	{
		Ext.Msg.show({
			title: pageTitle,
			msg: userIDValidationMsg48+".",
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}
	shiftspickerObj.add(getShiftTimeTemplate(tmpShiftPeriodsCount));
	addValuesToTimePicker(tmpShiftPeriodsCount);
	tmpShiftPeriodsCount++;
	var winObj = Ext.getCmp('shiftsPickerWinow');
	//var windowHeight = winObj.getHeight();
	//windowHeight = windowHeight + 30;
	//winObj.setHeight(windowHeight);
	shiftspickerObj.doLayout();
}

function addShiftTimeTemp()
{
	var shiftspickerObj = Ext.getCmp('shiftspicker');
	shiftspickerObj.add(getShiftTimeTemplate(tmpShiftPeriodsCount));
	addValuesToTimePicker(tmpShiftPeriodsCount);
	tmpShiftPeriodsCount++;
	var winObj = Ext.getCmp('shiftsPickerWinow');
	//var windowHeight = winObj.getHeight();
	//windowHeight = windowHeight + 30;
	//winObj.setHeight(windowHeight);
	shiftspickerObj.doLayout();
}

function removeShiftTime(containerID)
{
	var shiftspickerObj = Ext.getCmp('shiftspicker');
	shiftspickerObj.remove(containerID);
	tmpShiftPeriodsCount--;
	var winObj = Ext.getCmp('shiftsPickerWinow');
	//var windowHeight = winObj.getHeight();
	//windowHeight = windowHeight - 30;
	//winObj.setHeight(windowHeight);
	shiftspickerObj.doLayout();
}

function getShiftTimeTemplate(id)
{
	var tmpId1 = "frHr"+(id+1);
	var tmpId2 = "frMi"+(id+1);
	var tmpId3 = "toHr"+(id+1);
	var tmpId4 = "toMi"+(id+1);
	var conId = "shiftTime"+id
	var tmpShiftData = {
		xtype : 'container',
		id : 'shiftTime'+id,
		layout : {
			type : 'hbox',
			padding : 5
		},
		items : [
			{
				xtype : 'fieldcontainer',
				layout : {
					type : 'hbox',
				},
				labelAlign: 'top',
				labelSeparator: ' ',
				fieldLabel : 'From',
				items : [
					{
						xtype:'scrollcombo',
						id: tmpId1,
						name: tmpId1,
						cls: 'dropdown',
						editable : false,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						width: 100,
					},
					{
						xtype : 'tbspacer',
						width : 20
					},
					{
						xtype:'scrollcombo',
						id: tmpId2,
						name: tmpId2,
						cls: 'dropdown',
						editable : false,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						width: 50,
					},
				]
			},
			{
				xtype : 'tbspacer',
				width : 20
			},
			{
				xtype : 'fieldcontainer',
				layout : {
					type : 'hbox',
				},
				labelAlign: 'top',
				labelSeparator: ' ',
				fieldLabel : 'To',
				items : [
					{
						xtype:'scrollcombo',
						id: tmpId3,
						name: tmpId3,
						cls: 'dropdown',
						editable : false,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						width: 100,
						labelWidth: 50,
					},
					{
						xtype : 'tbspacer',
						width : 20
					},
					{
						xtype:'scrollcombo',
						id: tmpId4,
						name: tmpId4,
						cls: 'dropdown',
						editable : false,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						width: 50,
					},
					{
						xtype : 'tbspacer',
						width : 20
					},
					{
						xtype : 'container',
						items : [{
							xtype : 'button',
							iconCls : 'iconMinus',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeShiftTime(conId);
							}
						}]
					}
				]
			}
		]
	}
	return tmpShiftData;
}

function addValuesToTimePicker(id)
{
	id = id +1;
	var shiftsPickerHour = publicJSON['shiftsPickerHour'];
	var shiftsPickerMi = publicJSON['shiftsPickerMi'];
	Ext.getCmp('frHr'+id).getStore().loadRawData(shiftsPickerHour);
	Ext.getCmp('frHr'+id).setValue(Ext.getCmp('frHr'+id).getStore().getAt(0).get("valueField"));
	Ext.getCmp('frMi'+id).getStore().loadRawData(shiftsPickerMi);
	Ext.getCmp('frMi'+id).setValue(Ext.getCmp('frMi'+id).getStore().getAt(0).get("valueField"));
	Ext.getCmp('toHr'+id).getStore().loadRawData(shiftsPickerHour);
	Ext.getCmp('toHr'+id).setValue(Ext.getCmp('toHr'+id).getStore().getAt(0).get("valueField"));
	Ext.getCmp('toMi'+id).getStore().loadRawData(shiftsPickerMi);
	Ext.getCmp('toMi'+id).setValue(Ext.getCmp('toMi'+id).getStore().getAt(0).get("valueField"));
}


function checkInputs()
{
	for (var i=0;i<5;i++)
	{
		var tmpFHr = Ext.getCmp('frHr'+i);
		if (tmpFHr == null)
			continue;

		var tmpFMi = Ext.getCmp('frMi'+i);
		var tmpTHr = Ext.getCmp('toHr'+i);
		var tmpTMi = Ext.getCmp('toMi'+i);

		if ((tmpFHr.value == tmpTHr.value && tmpFMi.value == tmpTMi.value) ||
			(tmpFHr.value > tmpTHr.value) || ((tmpFHr.value == tmpTHr.value) && (tmpFMi.value > tmpTMi.value)))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg49+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
	}
	return true;
}


function uploadUserImage(imageFor)
{
	var result = appCnt.validateUserForm('logoUpload');
	if(result=="userValid")
	{
		var url  = "";
		var logoPath  = "";
		if (imageFor == "login")
		{
			url = "../servlet/com.eg.EgFileUpload?fromPage=EgConfigLogoMsg.jsp&uploadFor=login&fileExt=gif&uploadFir=manager/tomcat/webapps/final/admin/eg_images/";
			logoPath = "manager/tomcat/webapps/final/admin/eg_images/";
		}
		else if (imageFor == "monitor")
		{
			url = "../servlet/com.eg.EgFileUpload?fromPage=EgConfigLogoMsg.jsp&uploadFor=monitor&fileExt=gif&uploadFir=manager/tomcat/webapps/final/monitor/eg_images/";
			logoPath = "manager/tomcat/webapps/final/monitor/eg_images/";
		}
		else if (imageFor == "reporter")
		{
			url = "../servlet/com.eg.EgFileUpload?fromPage=EgConfigLogoMsg.jsp&uploadFor=reporter&fileExt=gif&uploadFir=manager/tomcat/webapps/final/reporter/images/";
			logoPath = "manager/tomcat/webapps/final/reporter/images/";
		}
		else if (imageFor == "config")
		{
			url = "../servlet/com.eg.EgFileUpload?fromPage=EgConfigLogoMsg.jsp&uploadFor=config&fileExt=gif&uploadFir=manager/tomcat/webapps/final/config/images/";
			logoPath = "manager/tomcat/webapps/final/config/images/";
		}

		var uname = Ext.getCmp('uname').getValue();
		var authenticationType = Ext.getCmp('userAuth').getValue().authentication;
		if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
		{
			authenticationType = Ext.getCmp('userAuthSAML').getValue().authenticationSAML
		}

		if (authenticationType == "Domain")
		{
			if (Ext.getCmp('rdoOperation').getValue().operation == "Group")
			{
				uname = Ext.getCmp('domainName').getValue() + "/" +Ext.getCmp('grpname').getValue();
			}
			else
			{
				uname = Ext.getCmp('domainName').getValue() + "/" + uname;
			}
			
		}

		if(!Ext.isEmpty(uname))
		{

			var logoname = uname+"_"+imageFor+".gif";
			if(uname.indexOf("/")>-1)
			{
				var domainName=uname.substring(0,uname.indexOf("/"));
				var userName=uname.substring(uname.indexOf("/")+1,uname.length);
				if(userName.indexOf("(")>-1)
				{
					userName=uname.substring(uname.indexOf("/")+1,uname.indexOf("(")-1);
				}
				logoname=domainName.toLowerCase()+"_"+userName+"_"+imageFor+".gif";
			}
			logoPath = logoPath +logoname;
			url=url+escape(logoname);
		}
		showUserImageUploader(imageFor,url,logoPath);
	}
}

function showUserImageUploader(imageFor,url,logoPath)
{
	fileUploadURI = url;
	filePath = logoPath;
	var expandWindow = Ext.create('Ext.window.Window',{
		title:'Files to be uploaded',
		requires : ['EgAddUser.view.FileUpload'],
		width:500,
		imageFor : imageFor,
		id : 'fileUpLoader',
		modal : true,
		doClose: function() {
			this.destroy();
		},
		getCurrentUploaderInfo : function()
		{
			return this.imageFor;
		},
		items : [
			{
				xtype : 'fileupload',
			}
		],
	}).show();
	if (!Ext.isEmpty(imageFor) && imageFor == 'login')
	{
		Ext.getCmp('specificationId').setValue('Type:GIF, JPEG, PNG, JPG;  Size:300KB;  Resolution:225x70pixels');
	}
}

function loadConfigPage(category,serverName)
{
	var url = '';
	if (category == "userZones")
	{
		url = "/final/admin/EgConfigZone.jsp?qctr=0&mode=modify&zone="+encodeURIComponent(serverName);
	}
	if (category == "userServices")
	{
		url = "/final/admin/EgConfigSites.jsp?modify=true&site="+encodeURIComponent(serverName);
	}
	if (category == "userServiceGroups")
	{
		url = "/final/admin/EgConfigServiceGroup.jsp?modify=true&site="+encodeURIComponent(serverName);
	}
	if (category == "userSegments")
	{
		url = "/final/admin/EgAdminTopology.jsp?qctr=0&segment="+encodeURIComponent(serverName);
	}
	if (category == "userComponenets" || category == "userAutoComps")
	{
		url = "/final/admin/EgDispServer.jsp?qctr=1&server="+encodeURIComponent(serverName);
	}

	if (!Ext.isEmpty(fromWizard))
	{
		url += "&fromWizard="+fromWizard;
	}

	window.location.href = url;
}

function checkSpecial(field,s_spl)
{
	obj_val = field.value;
	for(var i=0; i<obj_val.length; i++)
	{
		check_char = s_spl.indexOf(obj_val.charAt(i))
		//Returns value 1 if the special character listed in splChar is found
		if(check_char >= 0)
		{
			//alert(_checkspecial);
			return false;
		}
	}
	return true;
}

function addAutomanageSrvs(tmpSrvList,obj)
{
	var selectedCategoryList = Ext.getCmp('serverCategoryList').getValue();
	var tempSrvList = tmpSrvList.toString();
	
	var temp;
	if (tempSrvList != null)
	{
		temp = tempSrvList.split(",");
	}

	if (temp != "" && temp.length > 0)
	{
		if (selectedCategoryArr.indexOf(selectedCategoryList) == -1)
		{
			selectedCategoryArr.push(selectedCategoryList);
			for (var i=0; i<temp.length; i++)
			{
				var tmpStr = temp[i];
				if (srvListArray.indexOf(tmpStr) == -1)
				{
					srvListArray.push(tmpStr);
				}				
			}
			if (obj.getValue() !== undefined)
			{
				toFieldData(obj);
			}
		}
		else
		{
			for (var i=0; i<temp.length; i++)
			{
				var tmpStr2 = temp[i];
				if (srvListArray.indexOf(tmpStr2) == -1)
				{
					srvListArray.push(tmpStr2);
				}
			}
			if (obj.getValue() !== undefined)
			{
				toFieldData(obj);
			}
		}
	}
	else
	{
		toFieldData(obj);
	}
}

function fromFieldData(obj)
{
	var itemSelObj = obj;
	var storeObj = itemSelObj.fromField.store;
	var associatedNow = '';
	var count = storeObj.getCount();
	for (var s=0; s < count; s++)
	{
		var newVal = storeObj.getAt(s).get('valueField');
		if (s == (count-1))
		{
			associatedNow += newVal;
		}
		else
		{
			associatedNow += newVal+',';
		}
	}
	addAutomanageSrvs(associatedNow,obj);
}

function toFieldData(obj)
{
	unmanageList = obj.getValue();
	var tmpList = unmanageList.toString();
	var tmpArr = tmpList.split(",");

	if (tmpArr != "" && tmpArr.length > 0)
	{
		for (var i=0; i<tmpArr.length; i++)
		{
			var tmpStr = tmpArr[i];
			for (var u=0; u<srvListArray.length; u++)
			{
				if (srvListArray[u].indexOf(tmpStr) != -1)
				{
					var pos = srvListArray.indexOf(srvListArray[u]);
					srvListArray.splice(pos, 1);
				}
			}
		}
	}
}






