Ext.define('EgAddUser.view.EgDomainGroupTree', {
	extend:'Ext.panel.Panel',
	alias:'widget.egdomaingrouptree',
	requires : ['utilities.OuterPanel','utilities.ScrollableTreePanel'],

	layout:'border',
	//cls: 'outerpanel',
	scroll: false,
	autoScroll : false,
	border :false,
	margin : '5',
	defaults: {
		collapsible: true,
		split: true,
	},
	listeners : {
		afterrender : function()
			{
				this.setDomainDefaultEntries();
			}
	},
	setDomainDefaultEntries : function()
	{
		Ext.getCmp('leftPane').setTitle(selectedDomainDisplayName);
		var domainNameForGrp = publicJSON.domainNameForGrp;
		var baseURI = "EgAddUser/data/EgListGroupTreeUI.jsp?highLightNode="+domainNameForGrp+"&com.eg.CSRF_NONCE="+csrfToken;
		var ListGroupTreeObj = Ext.select("#ListGroupTree");
		ListGroupTreeObj.set({
			src : baseURI
		});
	},
	items:[
		{
			region:'west',
			title : selectedDomainDisplayName,
			titleAlign : 'center',
			id : 'leftPane',
			width:200,
			layout:'fit',
			cls:'treePanelDesign removeTreeLeftBorder',
			collapsible:true,
			hideCollapseTool:true,
			scroll:false,
			autoScroll:false,
			split: true,
			collapsed:false,
			frame:true,			
			collapseMode :'mini',			
			items:[
			{
				xtype : "component",
				style:{'background-color':'transparent'},
				padding:4,
				id : "ListGroupTree",
				autoEl:{
					tag:'iframe',
					frameborder:'0',
					height:'100%',
					src :''
				}
			}]
		}, 
		{
			region:'center',
			id : 'rightPane',
			hideCollapseTool:true,
			title: pageTitle,
			//xtype : 'outerPanel',
			cls: 'helpouterpanel',
			titleAlign : 'center',
			layout:'fit',
			margin :'0',
			bodyPadding : 0,
			flex:4,
			frame:true,
			autoScroll : false,
			items:[{
				xtype : "component",				
				id:"ListGroupView",
				autoEl:{
					tag:'iframe',
					frameborder:'0',
					height:'100%',
					src :"EgAddUser/data/EgListDomainGroups.jsp?frmPage=main&com.eg.CSRF_NONCE="+csrfToken+"&date="+new Date().getTime()
				}
			}]
		}	
	]
});



