Ext.QuickTips.init();
Ext.apply(Ext.QuickTips.getQuickTip(), {
	dismissDelay: 0
});

Ext.define('EgAddUser.view.UserFormContainer', {
	//extend: 'utilities.ScrollTabPanel',
	extend: 'Ext.TabPanel',
	alias: 'widget.userformcontainer',
	id : 'userformcontainer',

	requires : [
		'Ext.ux.form.MultiSelectSI',
		'Ext.ux.form.ItemSelectorSI',
		'Ext.ux.TreePicker',
		'EgAddUser.view.ElementAssociationForm',
		'EgAddUser.view.EgMailAlertSuppress',
		'utilities.ScrollCombo',
		'utilities.CustomGrid',
		'EgAddUser.view.ConfigureComponentTypes'
		//'utilities.DatePicker'
	],	
	cls: 'tablayout', //Apply this class to get tab skin	
	plain: true,
	style:{'border':'0px !important'},
	border: false,
	frame: false,
	tabPosition: 'top',
	flex: 1,
	margin: 10,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	//cls: 'tablayout', //Apply this class to get tab skin
	items: [
		{
			title: pageIntnl84,
			itemId: 'tab1',
			scroll:false,
			autoScroll:true,
			cls:'tabLayoutInnerBorder',
			style:{'border-top':'0px'},
			bodyStyle:{'overflow':'auto !important'},
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					defaults: {
						labelSeparator: '',
						margin: 5,
						width: 550,
						labelWidth: 200
					},
					margin: '50 0 0 0',
					items: [
						{
							xtype:'scrollcombo',
							editable : true,
							fieldLabel:'Entity type',
							name: 'userModel',
							id: 'userModel',
							store: new Ext.data.Store({
								fields : ['displayField','valueField'],
								data : []
							}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local'
						},
						{
							xtype: 'treepicker',
							cls: 'dropdown24',
							displayField: 'text',
							fieldLabel: 'Belongs to',
							maxPickerHeight: 200,
							id: 'org',
							name: 'org',
							store: new Ext.data.TreeStore({
								sorters: [{
									property: 'text',
									direction: 'ASC' 
								}]
							})
						},
						{
							xtype:'scrollcombo',
							//cls: 'dropdown',
							editable : false,
							fieldLabel:'Role',
							name: 'utype',
							id: 'utype',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField',"groupField","hasallcompaccess","tips","isShareRole"],
								data : []
							}),
							displayField : 'displayField',
							valueField : 'valueField',
							groupField: 'groupField',
							hasallcompaccess: 'hasallcompaccess',
							tips: 'tips',
							isShareRole: 'isShareRole',
							queryMode : 'local',
							listConfig: {
								tpl: Ext.create('Ext.XTemplate',
									'<ul><tpl for=".">',
									'<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
									'<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
									'</tpl>',
									'<li role="option" class="x-boundlist-item" data-qtip="{tips}" style="<tpl if="xindex != 1">padding-left: 12px</tpl>">{displayField}</li>',
									'</tpl>' +
									'</ul>',
									{
										getGroupLabel: function (values) {
											return values.groupField
										}
									}
								),
								getInnerTpl: function() {
									return '<div data-qtip="{displayField}">{displayField}</div>';
								}
							}
						},
						{
							xtype: 'radiogroup',
							fieldLabel: 'User type',
							cls: 'radiobt',
							id : 'userAuthSAML',
							name : 'userAuthSAML',
							columns: 3,
							//disabled: true,
							hidden: true,
							vertical: false,
							items: [
								{ boxLabel: 'Local', labelAlign: 'top',name: 'authenticationSAML',id:'eGAuthSAML',inputValue: 'Eg',checked: true},
								{ boxLabel: 'Domain', labelAlign: 'top',name: 'authenticationSAML',id:'domainAuthSAML',inputValue: 'Domain'},
								{ boxLabel: 'SAML', labelAlign: 'top',name: 'authenticationSAML',id:'idpAuthSAML',inputValue: 'SAML'}
							]
						},
						{
							xtype: 'radiogroup',
							fieldLabel: 'User type',
							cls: 'radiobt',
							id : 'userAuth',
							name : 'userAuth',
							columns: 2,
							vertical: false,
							items: [
								{ boxLabel: 'Domain', labelAlign: 'top',name: 'authentication',id:'domainAuth',inputValue: 'Domain'},
								{ boxLabel: 'Local', labelAlign: 'top',name: 'authentication',id:'eGAuth',inputValue: 'Eg',checked: true}
							]
						},
						{
							xtype:'scrollcombo',
							id: 'domainName',
							name: 'domain',
							//cls: 'dropdown',
							editable : false,
							fieldLabel : 'Domain',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							hidden : true
						},
						{
							xtype:'scrollcombo',
							id: 'idpName',
							name: 'idpName',
							//cls: 'dropdown',
							editable : false,
							fieldLabel : 'Identity Provider',
							store: new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
							displayField : 'displayField',
							valueField : 'valueField',
							queryMode : 'local',
							hidden : true
						},
						{
							xtype: 'radiogroup',
							id : 'rdoOperation',
							fieldLabel: 'Operation',
							cls: 'radiobt',
							columns: 2,
							vertical: false,
							items: [
								{ boxLabel: 'User', labelAlign: 'top',name: 'operation',id:'radioOperation1',inputValue: 'User',checked: true},
								{ boxLabel: 'Group', labelAlign: 'top',name: 'operation',id:'radioOperation2',inputValue: 'Group'}
							],
							hidden : true
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: 'ID',
							id : 'userCont',
							layout: 'column',
							items: [
								{
									xtype:'textfield',
									id: 'uname',
									cls:'textbox',
									width: 300,
									columnWidth: 1,
									maxLength : 256,
									enforceMaxLength : true,
									name: 'uname'
								},
								{
									xtype: 'component',
									id: 'userImage',
									html: '<center><img src="/final/images/spacer.gif" class="iconRight" style="cursor:pointer;" border="0" width="15" height="10" data-qtip="User ID available" data-qclass="yellowtip"></center>',
									margin: '5 0 0 5',
									hidden:true
								}
							]
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: 'Password',
							id : 'pasCont',
							layout: {
								type: 'vbox',
								pack: 'center',
								//align: 'left'
							},
							items: [
								{
									xtype: 'textfield',
									id: 'upass',
									name: 'upass',
									cls: 'textbox',
									inputType: 'password',
									width: 345,
									listeners:{
										blur :function()
										{
											Ext.getCmp('passScore').hide();
										},
										focus:function()
										{
											Ext.getCmp('passScore').show();
										}
									}
								}
								,
								{
									xtype:'label',
									id: 'passScore',
									name: 'passScore',
									//text: passLabel1+" "+publicJSON['pwdLength']+" "+passLabel2,
									width: 345,
									textAlign: 'left',
									cls: 'font_normal9'
								}
							]
						},
						{
							xtype:'textfield',
							id: 'confpasswd',
							cls:"textbox",
							name: 'confpasswd',
							fieldLabel : 'Retype password',
							inputType : 'password',
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: 'Group Name',
							id : 'grpnameCon',
							layout: 'column',
							items: [
								{
									xtype: 'textfield',
									width: 300,
									readOnly : true,
									columnWidth: 0.9,
									id: 'grpname',
									cls:"textbox",
									name: 'grpname',
									value : '  ----Click on the icon to select a group----  '
								},
								{
									xtype: 'component',
									html: '<center><img src="/final/images/spacer.gif" class="iconSecurityGroup" style="cursor:pointer;" border="0" width="15" height="10" data-qtip="Domain Groups" data-qclass="yellowtip" onclick="javascript:loadDomainGroupWindow()"></center>',
									columnWidth: 0.1,
									margin: '3 0 0 0'
								}
							],
							hidden: true
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: 'Expiry date',
							id : 'userExpFieldContainer',
							layout: 'column',
							items: [
								{
									xtype: 'datefield',
									columnWidth: 0.7,
									id: 'tmptilldate',
									name: 'tmptilldate',
									format: mgrDateFormat,
									cls: 'datepicker',
									editable : false,
									disabled: false,
									minValue : new Date(),
									listeners : {
										change : function(obj,The,eOpts)
										{
											var selected = obj.getValue();
											var tillDate = Ext.Date.dateFormat(selected, mgrDateFormat);
											if (tillDate != null && tillDate.length > 0)
											{
												Ext.getCmp('tilldate_h').setValue(tillDate);
												var tmpDate = tillDate + " 23:59:59";
												Ext.getCmp('tilldate').setValue(tmpDate);
											}
										}
									}
								},
								{
									xtype : 'hiddenfield',
									name : 'tilldate',
									id : 'tilldate'
								},
								{
									xtype : 'hiddenfield',
									name : 'tilldate_h',
									id : 'tilldate_h'
								},
								{
									xtype : 'hiddenfield',
									name : 'dateforpro',
									id : 'dateforpro'
								},
								{
									xtype: 'checkbox',
									boxLabel: 'No Expiry',
									checked: false,
									columnWidth: 0.3,
									margin: '3 0 0 10',
									inputValue : 'Never',
									cls: 'checkbt',
									name : 'Never',
									id : 'Never'
								}
							]
						},
						{
							xtype:'textareafield',
							id: 'description',
							cls:"textbox",
							name: 'description',
							fieldLabel : 'Description',
							hidden: true
						},
						{
							xtype: 'button',
							margin: '20 0 0 0',
							hidden: true,
							cls: "button20",
							text : validateBtn,
							id : 'validate',
							width: 80
						}
					]
				}
			]
		},
		{
			title: pageIntnl80,
			itemId: 'tab2',
			id : 'userpref',
			scroll:false,
			autoScroll:true,
			cls:'tabLayoutInnerBorder',
			style:{'border-top':'0px'},
			bodyStyle:{'overflow':'auto !important'},
			items: [
				{
					xtype: 'fieldset',
					title: '<b>General</b>',
					collapsible: true,
					margin: 20,
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								width: 580,
								labelWidth: 300
							},
							items: [
								{
									xtype: 'customgrid',
									id : 'selectedServerListGrid',
									margin : 10,
									cls:'gridSkin',
									border:true,
									hidden : true,
									title:'<span class="font_bold">'+assoLabel+'</span>',
									store: new Ext.data.Store({
										fields : ['col_1', 'col_2','col_3','valueField_1','valueField_2','valueField_3'],
										data : []
									}),
									emptyText: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconInformation" style="margin:2% auto 0% auto"></div>'+intnlLabel7+'</td></tr></table>',
									viewConfig: {
										deferEmptyText: false
									},

									//height : 100,
									maintainFlex:true,
									scroll:true,
									autoScroll : true,
									bodyPadding:0,
									padding:0,
									hideHeaders: true,
									columns: {
										defaults: {
											sortable: false,
											hideable: false,
											menuDisabled: true,
											draggable: false,
											resizable: false
										},
										items: [
											{
												text: '',
												dataIndex: 'col_1',
												flex: 1
											},
											{
												text: '',
												dataIndex: 'col_2',
												flex: 1
											},
											{
												text: '',
												dataIndex: 'col_3',
												flex: 1
											},
										]
									},
									tools : [
										{
											xtype:"container",
											cls:"iconBg",
											items:[{
												xtype:"button",
												iconCls:"iconModify",
												style:{background:"none",border:"0px"},
												listeners:{
													afterrender:function(){
														Ext.create("Ext.tip.ToolTip",{
															target:this.id,
															anchor:"top",
															cls:"yellowTip",
															trackMouse:true,
															html:intnlLabel45
														});
													}
												},
												handler: function() {
													Ext.widget('configurecomponenttypes').show();
												}
											}]
										}
									]
								},
								{
									xtype : 'hiddenfield',
									id : 'interestedDomains',
									name : 'interestedDomains',
								},
								{
									xtype:'scrollcombo',
									id: 'timeZone',
									name: 'timeZone',
									//cls: 'dropdown',
									editable : true,
									fieldLabel : 'Time Zone',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									disabled : false
								},
								{
									xtype:'scrollcombo',
									id: 'userDataFormat',
									name: 'userDataFormat',
									//cls: 'dropdown',
									editable : false,
									fieldLabel : 'Date format',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									disabled : false
								},
								{
									xtype: 'fieldcontainer',
									fieldLabel: 'Login Page',
									id : 'imgLoginPage',
									layout: 'column',
									items: [
										{
											xtype:'scrollcombo',
											id: 'loginLogo1',
											name: 'loginLogo1',
											//cls: 'dropdown',
											editable : false,
											store: new Ext.data.Store({
												fields : ['displayField', 'valueField'],
												data : []
											}),
											displayField : 'displayField',
											valueField : 'valueField',
											queryMode : 'local',
											disabled : false,
											columnWidth: 0.9
										},
										{
											xtype : 'hiddenfield',
											id : 'loginImageStatus',
											name : 'loginImageStatus',
										},
										{
											xtype : 'hiddenfield',
											id : 'loginImageUploadStatusForAudit',
											name : 'loginImageUploadStatusForAudit',
											value : 'no',
										},
										{
											xtype: 'component',
											hidden : true,
											id : 'loginLogoIMG',
											html: '<center><div class="iconUpload" style="cursor:pointer;margin-top: -3px" border="0" width="20" height="18" onclick="javascript:uploadUserImage(\'login\')"></div></center>',
											columnWidth: 0.1,
											margin: '4 0 0 2'
										}
									]
								},
								{
									xtype: 'fieldcontainer',
									fieldLabel: 'Admin / Monitor',
									id : 'imgAdminPage',
									layout: 'column',
									items: [
										{
											xtype:'scrollcombo',
											id: 'monitorLogo1',
											name: 'monitorLogo1',
											editable : false,
											//cls: 'dropdown',
											store: new Ext.data.Store({
												fields : ['displayField', 'valueField'],
												data : []
											}),
											displayField : 'displayField',
											valueField : 'valueField',
											queryMode : 'local',
											columnWidth: 0.9,
											disabled : false
										},
										{
											xtype : 'hiddenfield',
											id : 'monitorImageStatus',
											name : 'monitorImageStatus',
										},
										{
											xtype : 'hiddenfield',
											id : 'monitorImageUploadStatusForAudit',
											name : 'monitorImageUploadStatusForAudit',
											value : 'no',
										},
										{
											xtype: 'component',
											id : 'monitorLogoIMG',
											hidden : true,
											html: '<center><div class="iconUpload" style="cursor:pointer;margin-top: -3px" border="0" width="20" height="18" onclick="javascript:uploadUserImage(\'monitor\')"></div></center>',
											columnWidth: 0.1,
											margin: '4 0 0 2'
										}
									]
								},
								{
									xtype: 'checkboxgroup',
									fieldLabel: userIDValidationMsg57,
									id : 'imgRepLogin',
									cls: 'checkbt',
									columns: 1,
									vertical: false,
									items: [
										{ labelAlign: 'top',name: 'logoCheck',id:'logoCheck',inputValue: 'yes',checked: true}
									]
								},
								{
									xtype: 'fieldcontainer',
									id : 'imgRepPage',
									hidden : true,
									fieldLabel: 'Reporter',
									layout: 'column',
									items: [
										{
											xtype:'scrollcombo',
											id: 'reporterLogo1',
											name: 'reporterLogo1',
											editable : false,
											//cls: 'dropdown',
											store: new Ext.data.Store({
												fields : ['displayField', 'valueField'],
												data : []
											}),
											displayField : 'displayField',
											valueField : 'valueField',
											queryMode : 'local',
											columnWidth: 0.9,
											disabled : false
										},
										{
											xtype : 'hiddenfield',
											id : 'reporterImageStatus',
											name : 'reporterImageStatus',
										},
										{
											xtype : 'hiddenfield',
											id : 'reporterImageUploadStatusForAudit',
											name : 'reporterImageUploadStatusForAudit',
											value : 'no',
										},
										{
											xtype: 'component',
											hidden : true,
											id : 'reporterLogoIMG',
											html: '<center><div class="iconUpload" style="cursor:pointer;margin-top: -3px" border="0" width="20" height="18" onclick="javascript:uploadUserImage(\'reporter\')"></center>',
											columnWidth: 0.1,
											margin: '4 0 0 2'
										}
									]
								},
								{
									xtype: 'fieldcontainer',
									id : 'imgConfigPage',
									fieldLabel: 'Configuration',
									layout: 'column',
									hidden : true,
									items: [
										{
											xtype:'scrollcombo',
											id: 'configLogo1',
											name: 'configLogo1',
											editable : false,
											//cls: 'dropdown',
											store: new Ext.data.Store({
												fields : ['displayField', 'valueField'],
												data : []
											}),
											displayField : 'displayField',
											valueField : 'valueField',
											queryMode : 'local',
											columnWidth: 0.9,
											disabled : false
										},
										{
											xtype : 'hiddenfield',
											id : 'configMgmtImageStatus',
											name : 'configMgmtImageStatus',
										},
										{
											xtype : 'hiddenfield',
											id : 'configMgmtImageUploadStatusForAudit',
											name : 'configMgmtImageUploadStatusForAudit',
											value : 'no',
										},
										{
											xtype: 'component',
											hidden : true,
											id : 'configLogoIMG',
											html: '<center><div class="iconUpload" style="cursor:pointer;margin-top: -3px" border="0" width="20" height="18" onclick="javascript:uploadUserImage(\'config\')"></center>',
											columnWidth: 0.1,
											margin: '4 0 0 2'
										}
									]
								}
							]
						}


//						{
//							xtype: 'container',
//							layout: {
//								type: 'hbox',
//								pack: 'start'
//							},
//							items: [
//								{
//									xtype:'combo',
//									id: 'timeZone',
//									name: 'timeZone',
//									//cls: 'dropdown',
//									editable : false,
//									fieldLabel : 'Time Zone',
//									store: new Ext.data.Store({
//										fields : ['displayField', 'valueField'],
//										data : []
//									}),
//									displayField : 'displayField',
//									valueField : 'valueField',
//									queryMode : 'local',
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									width: 300,
//									disabled : false
//								},
//								{
//									xtype:'combo',
//									id: 'userDataFormat',
//									name: 'userDataFormat',
//									//cls: 'dropdown',
//									editable : false,
//									fieldLabel : 'Date format to be used',
//									store: new Ext.data.Store({
//										fields : ['displayField', 'valueField'],
//										data : []
//									}),
//									displayField : 'displayField',
//									valueField : 'valueField',
//									queryMode : 'local',
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									width: 300,
//									margin: '0 0 0 10',
//									disabled : false
//								},
//							]
//						},
//						{
//							xtype: 'fieldcontainer',
//							fieldLabel: 'Personalize Logo for',
//							id : 'personalizedLogo',
//							labelAlign: 'top',
//							labelSeparator: ' ',
//							layout: 'column',
//							margin: '15 0 0 0',
//							items: [
//								{
//									xtype: 'fieldcontainer',
//									fieldLabel: 'Login Page',
//									id : 'imgLoginPage',
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									layout: 'column',
//									columnWidth: 0.2,
//									items: [
//										{
//											xtype:'combo',
//											id: 'loginLogo1',
//											name: 'loginLogo1',
//											//cls: 'dropdown',
//											editable : false,
//											store: new Ext.data.Store({
//												fields : ['displayField', 'valueField'],
//												data : []
//											}),
//											displayField : 'displayField',
//											valueField : 'valueField',
//											queryMode : 'local',
//											disabled : false,
//											columnWidth: 0.9
//										},
//										{
//											xtype : 'hiddenfield',
//											id : 'loginImageStatus',
//											name : 'loginImageStatus',
//										},
//										{
//											xtype : 'hiddenfield',
//											id : 'loginImageUploadStatusForAudit',
//											name : 'loginImageUploadStatusForAudit',
//											value : 'no',
//										},
//										{
//											xtype: 'component',
//											hidden : true,
//											id : 'loginLogoIMG',
//											html: '<center><img src="/final/admin/eg_images/upload-icon.png" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:uploadUserImage(\'login\')"></center>',
//											columnWidth: 0.1,
//											margin: '4 0 0 2'
//										}
//									]
//								},
//								{
//									xtype: 'fieldcontainer',
//									fieldLabel: 'Admin / Monitor',
//									id : 'imgAdminPage',
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									layout: 'column',
//									margin: '0 0 0 10',
//									columnWidth: 0.2,
//									items: [
//										{
//											xtype:'combo',
//											id: 'monitorLogo1',
//											name: 'monitorLogo1',
//											editable : false,
//											//cls: 'dropdown',
//											store: new Ext.data.Store({
//												fields : ['displayField', 'valueField'],
//												data : []
//											}),
//											displayField : 'displayField',
//											valueField : 'valueField',
//											queryMode : 'local',
//											columnWidth: 0.9,
//											disabled : false
//										},
//										{
//											xtype : 'hiddenfield',
//											id : 'monitorImageStatus',
//											name : 'monitorImageStatus',
//										},
//										{
//											xtype : 'hiddenfield',
//											id : 'monitorImageUploadStatusForAudit',
//											name : 'monitorImageUploadStatusForAudit',
//											value : 'no',
//										},
//										{
//											xtype: 'component',
//											id : 'monitorLogoIMG',
//											hidden : true,
//											html: '<center><img src="/final/admin/eg_images/upload-icon.png" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:uploadUserImage(\'monitor\')"></center>',
//											columnWidth: 0.1,
//											margin: '4 0 0 2'
//										}
//									]
//								},
//								{
//									xtype: 'checkbox',
//									boxLabel: userIDValidationMsg57,
//									//cls: 'checkbt',
//									name : 'logoCheck',
//									id : 'logoCheck',
//									inputValue : 'yes',
//									value : 'yes',
//									columnWidth: 0.2,
//									margin: '23 0 0 12',
//									checked : true
//								},
//								{
//									xtype: 'fieldcontainer',
//									id : 'imgRepPage',
//									hidden : true,
//									fieldLabel: 'Reporter',
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									layout: 'column',
//									margin: '0 0 0 10',
//									columnWidth: 0.2,
//									items: [
//										{
//											xtype:'combo',
//											id: 'reporterLogo1',
//											name: 'reporterLogo1',
//											editable : false,
//											//cls: 'dropdown',
//											store: new Ext.data.Store({
//												fields : ['displayField', 'valueField'],
//												data : []
//											}),
//											displayField : 'displayField',
//											valueField : 'valueField',
//											queryMode : 'local',
//											columnWidth: 0.9,
//											disabled : false
//										},
//										{
//											xtype : 'hiddenfield',
//											id : 'reporterImageStatus',
//											name : 'reporterImageStatus',
//										},
//										{
//											xtype : 'hiddenfield',
//											id : 'reporterImageUploadStatusForAudit',
//											name : 'reporterImageUploadStatusForAudit',
//											value : 'no',
//										},
//										{
//											xtype: 'component',
//											hidden : true,
//											id : 'reporterLogoIMG',
//											html: '<center><img src="/final/admin/eg_images/upload-icon.png" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:uploadUserImage(\'reporter\')"></center>',
//											columnWidth: 0.1,
//											margin: '4 0 0 2'
//										}
//									]
//								},
//								{
//									xtype: 'fieldcontainer',
//									id : 'imgConfigPage',
//									fieldLabel: 'Configuration',
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									layout: 'column',
//									margin: '0 0 0 10',
//									hidden : true,
//									columnWidth: 0.2,
//									items: [
//										{
//											xtype:'combo',
//											id: 'configLogo1',
//											name: 'configLogo1',
//											editable : false,
//											//cls: 'dropdown',
//											store: new Ext.data.Store({
//												fields : ['displayField', 'valueField'],
//												data : []
//											}),
//											displayField : 'displayField',
//											valueField : 'valueField',
//											queryMode : 'local',
//											columnWidth: 0.9,
//											disabled : false
//										},
//										{
//											xtype : 'hiddenfield',
//											id : 'configMgmtImageStatus',
//											name : 'configMgmtImageStatus',
//										},
//										{
//											xtype : 'hiddenfield',
//											id : 'configMgmtImageUploadStatusForAudit',
//											name : 'configMgmtImageUploadStatusForAudit',
//											value : 'no',
//										},
//										{
//											xtype: 'component',
//											hidden : true,
//											id : 'configLogoIMG',
//											html: '<center><img src="/final/admin/eg_images/upload-icon.png" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:uploadUserImage(\'config\')"></center>',
//											columnWidth: 0.1,
//											margin: '4 0 0 2'
//										}
//									]
//								}
//							]
//						}


					]
				},
				{
					xtype: 'fieldset',
					id : 'mailsmssettings',
					title: '<b>Mail/SMS Settings</b>',
					collapsible: true,
					margin: 20,
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								width: 580,
								labelWidth: 300
							},
							items: [
								{
									xtype:'scrollcombo',
									id: 'mailSenders',
									name: 'mailSenders',
									//cls: 'dropdown',
									editable : false,
									fieldLabel : 'Mail Sender',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									disabled : false
								},
								{
									xtype: 'fieldcontainer',
									fieldLabel: 'Mail ID / Mobile number',
									id : 'mailIDsContainer',
									layout: 'column',
									items: [
										{
											xtype:'textfield',
											id: 'tomailid',
											cls:"textbox",
											name: 'tomailid',
											fieldLabel : 'To',
											labelAlign: 'top',
											labelSeparator: ' ',
											columnWidth: 1,
											margin: '1 0 10 0'
										},
										{
											xtype:'textfield',
											id: 'ccmailid',
											cls:"textbox",
											name: 'ccmailid',
											fieldLabel : 'Cc',
											labelAlign: 'top',
											labelSeparator: ' ',
											columnWidth: 1,
											margin: '0 0 10 0'
										},
										{
											xtype:'textfield',
											id: 'bccmailid',
											cls:"textbox",
											name: 'bccmailid',
											fieldLabel : 'Bcc',
											labelAlign: 'top',
											labelSeparator: ' ',
											columnWidth: 1,
											margin: '0 0 10 0'
										}
									]
								}
							]
						}
					]
				},
				{
					xtype: 'fieldset',
					id : 'mailsmsalerts',
					title: '<b>Alert Settings</b>',
					collapsible: true,
					margin: 20,
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								width: 580,
								labelWidth: 300
							},
							items: [
								{
									xtype: 'checkboxgroup',
									id : 'tmpAlarmGroup',
									fieldLabel: 'Alarms by mail / SMS',
									cls: 'checkbt',
									columns: 3,
									vertical: false,
									items: [
										{ boxLabel: radioOptionCritical, labelAlign: 'top',name: 'high',id:'high',inputValue: 'high',checked: false},
										{ boxLabel: radioOptionMajor, labelAlign: 'top',name: 'medium',id:'medium',inputValue: 'medium',checked: false},
										{ boxLabel: radioOptionMinor, labelAlign: 'top',name: 'low',id:'low',inputValue: 'low',checked: false}
									]
								}
							]
						},
						{
							xtype: 'container',
							id : 'frmAlarmContainer',
							hidden : true,
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								width: 580,
								labelWidth: 300
							},
							items: [
								{
									xtype: 'textarea',
									fieldLabel: 'Command to be executed for alerts',
									//grow: true,
									id: 'customScript',
									cls: 'text-area',
									name: 'customScript'
								},
								{
									xtype: 'fieldcontainer',
									fieldLabel: 'Escalation mail ID / Mobile number',
									id : 'escMailIDsDiv',
									//layout: 'column',
									layout : {
										//type : 'hbox',
									},
									items: [
										{
											xtype : 'container',
											layout: 'column',
											items : [
												{
													xtype: 'textfield',
													fieldLabel: userIDValidationMsg50 + ' 1',
													labelAlign: 'top',
													labelSeparator: ' ',
													id : 'escmailid',
													name : 'escmailid',
													cls:"textbox",
													columnWidth: 0.97,
													margin: '1 0 10 0'
												},
												{
													xtype: 'component',
													html: '<center><div class="iconPlus" style="cursor:pointer;" onclick="javascript:addContact()"></center>',
													columnWidth: 0.03,
													margin: '20 0 5 2'
												}
											]
										}
									]
								},
								{
									xtype: 'radiogroup',
									fieldLabel: 'Type of notification',
									cls: 'radiobt',
									id : 'alarmNotify',
									columns: 2,
									vertical: false,
									items: [
										{ boxLabel: New, labelAlign: 'top',name: 'notify',id: 'alarmNotifyNew',inputValue: 'N',checked: true},
										{ boxLabel: alarmNotifyComplete, labelAlign: 'top',name: 'notify',id: 'alarmNotifyComplete',inputValue: 'C',checked: false}
									]
								},
								{
									xtype: 'radiogroup',
									fieldLabel: 'Message mode',
									id : 'alarmMsgMode',
									cls: 'radiobt',
									columns: 2,
									vertical: false,
									items: [
										{ boxLabel: radioOptionHtml, labelAlign: 'top',name: 'msgmode',id:'alarmMsgHtml',inputValue: 'H',checked: true},
										{ boxLabel: radioOptionText, labelAlign: 'top',name: 'msgmode',id : 'alarmMsgText',inputValue: 'T',checked: false}
									]
								},
								{
									xtype:'scrollcombo',
									id: 'measure_in_mail_mode',
									name: 'measure_in_mail_mode',
									//cls: 'dropdown',
									editable : false,
									fieldLabel : 'Include measure details in mail alerts',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									disabled : false
								},
								{
									xtype: 'radiogroup',
									id : 'detailsDiagnosisAlerts',
									fieldLabel: 'Include detailed diagnosis in mail alerts',
									cls: 'radiobt',
									columns: 2,
									vertical: false,
									items: [
										{ boxLabel: radioOptionYes, labelAlign: 'top',name: 'dd_in_mail_mode',inputValue: 'Yes',checked: false},
										{ boxLabel: radioOptionNo, labelAlign: 'top',name: 'dd_in_mail_mode',inputValue: 'No',checked: true}
									]
								},
								{
									xtype : 'container',
									id : 'eGShiftPeriods',
									padding : 0,
									defaults: {
										labelSeparator: '',
										margin: '5 0 5 0',
										width: 580,
										labelWidth: 300
									},
									items : [
									{
										xtype: 'radiogroup',
										fieldLabel: 'Send Email alerts only during shift periods',
										columns: 2,
										margin: '0 0 5 0',
										cls: 'radiobt',
										id : 'mailshift',
										vertical: false,
										items: [
											{ boxLabel: radioOptionYes, name: 'mailshift', id: 'emailAlert_0' , inputValue: 'yes' },
											{ boxLabel: radioOptionNo, name: 'mailshift', id: 'emailAlert_1',inputValue: 'no', checked : true }
										]
									},
									{
										xtype: 'container',
										id : 'emailMailAlert',
										hidden : true,
										layout: {
											type: 'vbox',
											align: 'stretch'
										},
										items: [
											{
												xtype: 'container',
												margin: 5,
												layout: 'column',
												items: [
													{
														xtype: 'textfield',
														fieldLabel: userIDValidationMsg52,
														labelAlign: 'top',
														labelSeparator: ' ',
														columnWidth: 0.4,
														margin: '1 0 10 20',
														id: 'mailday0',
														cls:"textbox",
														name: 'mailday0',
														readOnly : true
													},
													{
														xtype: 'component',
														html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\'mailday0\')"></center>',
														columnWidth: 0.03,
														margin: '22 0 5 2'
													},
													{
														xtype: 'textfield',
														fieldLabel: userIDValidationMsg53,
														labelAlign: 'top',
														labelSeparator: ' ',
														columnWidth: 0.4,
														margin: '1 0 10 20',
														id: 'mailshift0',
														cls:"textbox",
														name: 'mailshift0',
														readOnly : true
													},
													{
														xtype: 'component',
														html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\'mailshift0\')"></center>',
														columnWidth: 0.03,
														margin: '22 0 5 2'
													},
													{
														xtype : 'container',
														columnWidth: 0.04,
														margin: '22 0 5 30',
														items : [{
															xtype : 'button',
															iconCls : 'iconPlus',
															tooltip : '<b>add shift period</b>',
															style : {
																background : 'none',
																border : '0px'
															},
															handler: function()
															{
																addShifts('mail');
															}
														}]
													}
												]
											}
										]
									},
									{
										xtype: 'radiogroup',
										fieldLabel: 'Execute command only during shift periods',
										columns: 2,
										cls: 'radiobt',
										id : 'Execshift',
										vertical: false,
										items: [
											{ boxLabel: radioOptionYes, name: 'Execshift', id: 'shiftAlert_0' , inputValue: 'yes'},
											{ boxLabel: radioOptionNo, name: 'Execshift',id: 'shiftAlert_1', inputValue: 'no', checked: true }
										]
									},
									{
										xtype: 'container',
										hidden : true,
										layout: {
											type: 'vbox',
											align: 'stretch'
										},
										id : 'commandAlert',
										items: [
											{
												xtype: 'container',
												margin: 5,
												layout: 'column',
												items: [
													{
														xtype: 'textfield',
														fieldLabel: userIDValidationMsg52,
														labelAlign: 'top',
														labelSeparator: ' ',
														columnWidth: 0.4,
														margin: '1 0 10 20',
														id: 'Execday0',
														cls:"textbox",
														name: 'Execday0',
														readOnly : true
													},
													{
														xtype: 'component',
														html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\'Execday0\')"></center>',
														columnWidth: 0.03,
														margin: '22 0 5 2'
													},
													{
														xtype: 'textfield',
														fieldLabel: userIDValidationMsg53,
														labelAlign: 'top',
														labelSeparator: ' ',
														columnWidth: 0.4,
														margin: '1 0 10 20',
														id: 'Execshift0',
														cls:"textbox",
														name: 'Execshift0',
														readOnly : true
													},
													{
														xtype: 'component',
														html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\'Execshift0\')"></center>',
														columnWidth: 0.03,
														margin: '22 0 5 2'
													},
													{
														xtype : 'container',
														columnWidth: 0.04,
														margin: '22 0 5 30',
														items : [{
															xtype : 'button',
															iconCls : 'iconPlus',
															tooltip : '<b>add shift period</b>',
															style : {
																background : 'none',
																border : '0px'
															},
															handler: function()
															{
																addShifts('Exec');
															}
														}]
													}
												]
											}
										]
									},
									{
										xtype: 'radiogroup',
										fieldLabel: 'Send SMS alerts only during shift periods',
										id : 'smsshift',
										cls : 'radiobt',
										columns: 2,
										vertical: false,
										items: [
											{ boxLabel: radioOptionYes, name: 'smsshift',id: 'smsAlert_0' , inputValue: 'yes'},
											{ boxLabel: radioOptionNo, name: 'smsshift',id: 'smsAlert_1' ,inputValue: 'no', checked: true }
										]
									},
									{
										xtype: 'container',
										hidden : true,
										layout: {
											type: 'vbox',
											align: 'stretch'
										},
										id : 'smsAlert',
										items: [
											{
												xtype: 'container',
												margin: 5,
												layout: 'column',
												items: [
													{
														xtype: 'textfield',
														fieldLabel: userIDValidationMsg52,
														labelAlign: 'top',
														labelSeparator: ' ',
														columnWidth: 0.4,
														margin: '1 0 10 20',
														id: 'smsday0',
														cls:"textbox",
														name: 'smsday0',
														readOnly : true
													},
													{
														xtype: 'component',
														html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\'smsday0\')"></center>',
														columnWidth: 0.03,
														margin: '22 0 5 2'
													},
													{
														xtype: 'textfield',
														fieldLabel: userIDValidationMsg53,
														labelAlign: 'top',
														labelSeparator: ' ',
														columnWidth: 0.4,
														margin: '1 0 10 20',
														id: 'smsshift0',
														cls:"textbox",
														name: 'smsshift0',
														readOnly : true
													},
													{
														xtype: 'component',
														html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\'smsshift0\')"></center>',
														columnWidth: 0.03,
														margin: '22 0 5 2'
													},
													{
														xtype : 'container',
														columnWidth: 0.04,
														margin: '22 0 5 30',
														items : [{
															xtype : 'button',
															iconCls : 'iconPlus',
															tooltip : '<b>add shift period</b>',
															style : {
																background : 'none',
																border : '0px'
															},
															handler: function()
															{
																addShifts('sms');
															}
														}]
													}
												]
											}
										]
									},
									{
										xtype: 'radiogroup',
										fieldLabel: 'Send Escalation alerts only during shift periods',
										columns: 2,
										id : 'escshift',
										cls : 'radiobt',
										vertical: false,
										items: [
											{ boxLabel: 'Yes', name: 'escshift',id: 'escAlert_0' ,inputValue: 'yes' },
											{ boxLabel: 'No', name: 'escshift',id: 'escAlert_1', inputValue: 'no' , checked: true}
										]
									},
									{
										xtype: 'container',
										hidden : true,
										layout: {
											type: 'vbox',
											align: 'stretch'
										},
										id : 'escMailAlert',
										items: [
											{
												xtype: 'container',
												margin: 5,
												layout: 'column',
												items: [
													{
														xtype: 'textfield',
														fieldLabel: userIDValidationMsg52,
														labelAlign: 'top',
														labelSeparator: ' ',
														columnWidth: 0.4,
														margin: '1 0 10 20',
														id: 'escday0',
														cls:"textbox",
														name: 'escday0',
														readOnly : true
													},
													{
														xtype: 'component',
														html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\'escday0\')"></center>',
														columnWidth: 0.03,
														margin: '22 0 5 2'
													},
													{
														xtype: 'textfield',
														fieldLabel: userIDValidationMsg53,
														labelAlign: 'top',
														labelSeparator: ' ',
														columnWidth: 0.4,
														margin: '1 0 10 20',
														id: 'escshift0',
														cls:"textbox",
														name: 'escshift0',
														readOnly : true
													},
													{
														xtype: 'component',
														html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\'escshift0\')"></center>',
														columnWidth: 0.03,
														margin: '22 0 5 2'
													},
													{
														xtype : 'container',
														columnWidth: 0.04,
														margin: '22 0 5 30',
														items : [{
															xtype : 'button',
															iconCls : 'iconPlus',
															tooltip : '<b>add shift period</b>',
															style : {
																background : 'none',
																border : '0px'
															},
															handler: function()
															{
																addShifts('esc');
															}
														}]
													}
												]
											}
										]
									}]
								},
								{
									xtype: 'radiogroup',
									id : 'mail_filter_optionGrp',
									fieldLabel: 'Configure email/SMS filters for',
									cls: 'radiobt',
									columns: 2,
									vertical: false,
									items: [
										{ boxLabel: pageIntnl93, labelAlign: 'top',name: 'mail_filter_option',id : 'mail_filter_option1', inputValue: 'All_Elements',checked: true},
										{ boxLabel: pageIntnl94, labelAlign: 'top',name: 'mail_filter_option',id : 'mail_filter_option2',inputValue: 'Descriptors_Only',checked: false}
									]
								}
							]
						}






//
//						{
//							xtype: 'checkbox',
//							id : 'configureMailAlert',
//							boxLabel: 'Alarms by mail / SMS',
//							checked: false,
//							listeners : {
//								click : {
//									element : 'el',
//									fn : function(id)
//									{
//										appCnt.configureMailAlert(Ext.getCmp(this.id).getValue());
//									}
//								}
//							}
//						},
//						{
//							xtype: 'container',
//							id : 'frmAlarmContainer',
//							hidden :true,
//							margin: '5 0 20 0',
//							border: 1,
//							style: {
//								borderColor: 'grey',
//								borderStyle: 'solid',
//								borderWidth: '1px'
//							},
//							items: [
//								{
//									xtype: 'container',
//									layout: 'column',
//									items : [
//										{
//											xtype: 'checkboxgroup',
//											id : 'tmpAlarmGroup',
//											fieldLabel: 'Alarms by mail / SMS',
//											//cls: 'checkbt',
//											columns: 3,
//											vertical: false,
//											items: [
//												{ boxLabel: radioOptionCritical, labelAlign: 'top',name: 'high',id:'high',inputValue: 'high',checked: false},
//												{ boxLabel: radioOptionMajor, labelAlign: 'top',name: 'medium',id:'medium',inputValue: 'medium',checked: false},
//												{ boxLabel: radioOptionMinor, labelAlign: 'top',name: 'low',id:'low',inputValue: 'low',checked: false}
//											],
//											labelAlign: 'top',
//											labelSeparator: ' ',
//											columnWidth: 0.33,
//											margin: '10 0 15 20'
//										},
//										{
//											xtype: 'radiogroup',
//											fieldLabel: 'Type of notification',
//											//cls: 'radiobt',
//											id : 'alarmNotify',
//											columns: 2,
//											vertical: false,
//											items: [
//												{ boxLabel: New, labelAlign: 'top',name: 'notify',id: 'alarmNotifyNew',inputValue: 'N',checked: true},
//												{ boxLabel: alarmNotifyComplete, labelAlign: 'top',name: 'notify',id: 'alarmNotifyComplete',inputValue: 'C',checked: false}
//											],
//											columnWidth: 0.33,
//											margin: '10 0 15 20',
//											labelAlign: 'top',
//											labelSeparator: ' ',
//										},
//										{
//											xtype: 'radiogroup',
//											fieldLabel: 'Message mode',
//											id : 'alarmMsgMode',
//											//cls: 'radiobt',
//											columns: 2,
//											vertical: false,
//											items: [
//												{ boxLabel: radioOptionHtml, labelAlign: 'top',name: 'msgmode',id:'alarmMsgHtml',inputValue: 'H',checked: true},
//												{ boxLabel: radioOptionText, labelAlign: 'top',name: 'msgmode',id : 'alarmMsgText',inputValue: 'T',checked: false}
//											],
//											columnWidth: 0.33,
//											margin: '10 0 15 20',
//											labelAlign: 'top',
//											labelSeparator: ' ',
//										},
//										{
//											xtype:'combo',
//											id: 'measure_in_mail_mode',
//											name: 'measure_in_mail_mode',
//											//cls: 'dropdown',
//											editable : false,
//											fieldLabel : 'Include measure details in mail alerts',
//											store: new Ext.data.Store({
//												fields : ['displayField', 'valueField'],
//												data : []
//											}),
//											displayField : 'displayField',
//											valueField : 'valueField',
//											queryMode : 'local',
//											columnWidth: 0.33,
//											margin: '0 0 15 20',
//											labelAlign: 'top',
//											labelSeparator: ' ',
//											disabled : false
//										},
//										{
//											xtype: 'radiogroup',
//											id : 'detailsDiagnosisAlerts',
//											fieldLabel: 'Include detailed diagnosis in mail alerts',
//											//cls: 'radiobt',
//											columns: 2,
//											vertical: false,
//											items: [
//												{ boxLabel: radioOptionYes, labelAlign: 'top',name: 'dd_in_mail_mode',inputValue: 'Yes',checked: false},
//												{ boxLabel: radioOptionNo, labelAlign: 'top',name: 'dd_in_mail_mode',inputValue: 'No',checked: true}
//											],
//											labelAlign: 'top',
//											labelSeparator: ' ',
//											columnWidth: 0.33,
//											margin: '0 0 15 20'
//										},
//										{
//											xtype:'combo',
//											id: 'mailSenders',
//											name: 'mailSenders',
//											//cls: 'dropdown',
//											labelAlign: 'top',
//											labelSeparator: ' ',
//											editable : false,
//											fieldLabel : 'Mail Sender',
//											store: new Ext.data.Store({
//												fields : ['displayField', 'valueField'],
//												data : []
//											}),
//											displayField : 'displayField',
//											valueField : 'valueField',
//											queryMode : 'local',
//											columnWidth: 0.33,
//											margin: '0 0 15 20',
//											disabled : false
//										},
//										{
//											xtype: 'textarea',
//											fieldLabel: 'Command to be executed for alerts',
//											labelAlign: 'top',
//											labelSeparator: ' ',
//											columnWidth: 0.70,
//											grow: true,
//											id: 'customScript',
//											//cls: 'textbox24',
//											name: 'customScript',
//											margin: '0 0 15 20'
//										},
//										{
//											xtype: 'fieldcontainer',
//											fieldLabel: 'Mail ID / Mobile number',
//											id : 'mailIDsContainer',
//											labelAlign: 'top',
//											labelSeparator: ' ',
//											layout: 'column',
//											margin: '0 0 15 20',
//											columnWidth: 0.99,
//											items: [
//												{
//													xtype:'textfield',
//													id: 'tomailid',
//													//cls: 'textbox24',
//													name: 'tomailid',
//													fieldLabel : 'To',
//													labelAlign: 'top',
//													labelSeparator: ' ',
//													columnWidth: 0.70,
//													margin: '1 0 10 100'
//												},
//												{
//													xtype:'textfield',
//													id: 'ccmailid',
//													//cls: 'textbox24',
//													name: 'ccmailid',
//													fieldLabel : 'Cc',
//													labelAlign: 'top',
//													labelSeparator: ' ',
//													columnWidth: 0.70,
//													margin: '0 0 10 100'
//												},
//												{
//													xtype:'textfield',
//													id: 'bccmailid',
//													//cls: 'textbox24',
//													name: 'bccmailid',
//													fieldLabel : 'Bcc',
//													labelAlign: 'top',
//													labelSeparator: ' ',
//													columnWidth: 0.70,
//													margin: '0 0 10 100'
//												},
//											]
//										},
//									]
//								},
//								{
//									xtype: 'displayfield',
//									fieldLabel: 'Escalation mail ID / Mobile number',
//									id : 'escMailIDsContainer',
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									margin: '0 0 5 20',
//								},
//								{
//									xtype : 'container',
//									id : 'escMailIDsDiv',
//									layout : {
//										type : 'vbox',
//									},
//									margin: '1 0 0 120',
//									items : [
//										{
//											xtype : 'container',
//											layout : {
//												type : 'hbox',
//											},
//											items : [
//												{
//													xtype:'textfield',
//													id: 'escmailid',
//													//cls: 'textbox24',
//													name: 'escmailid',
//													fieldLabel : userIDValidationMsg50+' 1',
//													labelAlign: 'top',
//													labelSeparator: ' ',
//													width: 510
//												},
//												{
//													xtype: 'tbspacer',
//													width  : 5
//												},
//												{
//													xtype : 'container',
//													margin: '20 0 5 2',
//													items : [{
//														xtype : 'button',
//														iconCls : 'iconPlus',
//														tooltip : '<b>add level</b>',
//														style : {
//															background : 'none',
//															border : '0px'
//														},
//														handler : function()
//														{
//															addContact();
//														}
//													}]
//												}
//											]
//										}
//									]
//								},
//								{
//									xtype: 'checkbox',
//									//cls: 'checkbt',
//									id : 'mailshift',
//									name : 'mailshift',
//									boxLabel: 'Send Email alerts only during shift periods',
//									checked: false,
//									margin: '10 0 5 20',
//									inputValue : 'yes',
//								},
//								{
//									xtype: 'container',
//									id : 'emailShiftAlertConfig',
//									hidden : true,
//									layout : {
//										type : 'vbox',
//									},
//									margin: '1 0 0 120',
//									items: [
//										{
//											xtype : 'container',
//											id : 'emailMailAlert',
//											layout : {
//												type : 'vbox',
//												align : 'center',
//											},
//											hidden : false,
//											items : [
//												{
//													xtype : 'container',
//													layout : {
//														type : 'hbox',
//													},
//													items : [
//														{
//															xtype: 'textfield',
//															fieldLabel: userIDValidationMsg52,
//															labelAlign: 'top',
//															labelSeparator: ' ',
//															width : 200,
//															id: 'mailday0',
//															//cls: 'textbox24',
//															name: 'mailday0',
//															readOnly : true,
//														},
//														{
//															xtype: 'component',
//															html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\'mailday0\')"></center>',
//															margin: '20 0 5 2'
//														},
//														{
//															xtype: 'tbspacer',
//															width  : 10
//														},
//														{
//															xtype:'textfield',
//															id: 'mailshift0',
//															//cls: 'textbox24',
//															name: 'mailshift0',
//															readOnly : true,
//															fieldLabel: userIDValidationMsg53,
//															labelAlign: 'top',
//															labelSeparator: ' ',
//															width : 260
//														},
//														{
//															xtype: 'component',
//															html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\'mailshift0\')"></center>',
//															margin: '20 0 5 2'
//														},
//														{
//															xtype : 'container',
//															margin: '18 0 5 2',
//															items : [{
//																xtype : 'button',
//																iconCls : 'iconPlus',
//																tooltip : '<b>add shift period</b>',
//																style : {
//																	background : 'none',
//																	border : '0px'
//																},
//																handler: function()
//																{
//																	addShifts('mail');
//																}
//															}]
//														}
//													]
//												}
//											]
//										}
//									]
//								},
//								{
//									xtype: 'checkbox',
//									boxLabel: 'Execute command only during shift periods',
//									checked: false,
//									//cls: 'checkbt',
//									id : 'Execshift',
//									name : 'Execshift',
//									margin: '0 0 5 20',
//									inputValue : 'yes',
//									//cls : 'checkbt'
//								},
//								{
//									xtype: 'container',
//									id : 'cmdShiftAlertConfig',
//									hidden : true,
//									layout : {
//										type : 'vbox',
//									},
//									margin: '1 0 0 120',
//									items: [
//										{
//											xtype : 'container',
//											id : 'commandAlert',
//											layout : {
//												type : 'vbox',
//												align : 'center',
//											},
//											hidden : false,
//											items : [
//												{
//													xtype : 'container',
//													layout : {
//														type : 'hbox',
//													},
//													items : [
//														{
//															xtype: 'textfield',
//															fieldLabel: userIDValidationMsg52,
//															labelAlign: 'top',
//															labelSeparator: ' ',
//															id: 'Execday0',
//															//cls: 'textbox24',
//															name: 'Execday0',
//															readOnly : true,
//															width : 200
//														},
//														{
//															xtype: 'component',
//															html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\'Execday0\')"></center>',
//															margin: '20 0 5 2'
//														},
//														{
//															xtype: 'tbspacer',
//															width  : 10
//														},
//														{
//															xtype:'textfield',
//															id: 'Execshift0',
//															//cls: 'textbox24',
//															name: 'Execshift0',
//															readOnly : true,
//															fieldLabel: userIDValidationMsg53,
//															labelAlign: 'top',
//															labelSeparator: ' ',
//															width : 260
//														},
//														{
//															xtype: 'component',
//															html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\'Execshift0\')"></center>',
//															margin: '20 0 5 2'
//														},
//														{
//															xtype : 'container',
//															margin: '18 0 5 2',
//															items : [{
//																xtype : 'button',
//																iconCls : 'iconPlus',
//																tooltip : '<b>add shift period</b>',
//																style : {
//																	background : 'none',
//																	border : '0px'
//																},
//																handler: function()
//																{
//																	addShifts('Exec');
//																}
//															}]
//														}
//													]
//												}
//											]
//										}
//									]
//								},
//								{
//									xtype: 'checkbox',
//									boxLabel: 'Send SMS alerts only during shift periods',
//									checked: false,
//									margin: '0 0 5 20',
//									id : 'smsshift',
//									name : 'smsshift',
//									inputValue : 'yes',
//									//cls : 'checkbt'
//								},
//								{
//									xtype: 'container',
//									id : 'smsShiftAlertConfig',
//									hidden : true,
//									layout : {
//										type : 'vbox',
//									},
//									margin: '1 0 0 120',
//									items: [
//										{
//											xtype : 'container',
//											id : 'smsAlert',
//											layout : {
//												type : 'vbox',
//												align : 'center',
//											},
//											hidden : false,
//											items : [
//												{
//													xtype : 'container',
//													layout : {
//														type : 'hbox',
//													},
//													items : [
//														{
//															xtype: 'textfield',
//															fieldLabel: userIDValidationMsg52,
//															labelAlign: 'top',
//															labelSeparator: ' ',
//															id: 'smsday0',
//															//cls: 'textbox24',
//															name: 'smsday0',
//															readOnly : true,
//															width : 200
//														},
//														{
//															xtype: 'component',
//															html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\'smsday0\')"></center>',
//															margin: '20 0 5 2'
//														},
//														{
//															xtype: 'tbspacer',
//															width  : 10
//														},
//														{
//															xtype:'textfield',
//															id: 'smsshift0',
//															//cls: 'textbox24',
//															name: 'smsshift0',
//															readOnly : true,
//															fieldLabel: userIDValidationMsg53,
//															labelAlign: 'top',
//															labelSeparator: ' ',
//															width : 260
//														},
//														{
//															xtype: 'component',
//															html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\'smsshift0\')"></center>',
//															margin: '20 0 5 2'
//														},
//														{
//															xtype : 'container',
//															margin: '18 0 5 2',
//															items : [{
//																xtype : 'button',
//																iconCls : 'iconPlus',
//																tooltip : '<b>add shift period</b>',
//																style : {
//																	background : 'none',
//																	border : '0px'
//																},
//																handler: function()
//																{
//																	addShifts('sms');
//																}
//															}]
//														}
//													]
//												}
//											]
//										}
//									]
//								},
//								{
//									xtype: 'checkbox',
//									boxLabel: 'Send Escalation alerts only during shift periods',
//									checked: false,
//									margin: '0 0 5 20',
//									id : 'escshift',
//									name : 'escshift',
//									inputValue : 'yes',
//									//cls : 'checkbt'
//								},
//								{
//									xtype: 'container',
//									id : 'escShiftAlertConfig',
//									hidden : true,
//									layout : {
//										type : 'vbox',
//									},
//									margin: '1 0 10 120',
//									items: [
//										{
//											xtype : 'container',
//											id : 'escMailAlert',
//											layout : {
//												type : 'vbox',
//												align : 'center',
//											},
//											hidden : false,
//											items : [
//												{
//													xtype : 'container',
//													layout : {
//														type : 'hbox',
//													},
//													items : [
//														{
//															xtype: 'textfield',
//															fieldLabel: userIDValidationMsg52,
//															labelAlign: 'top',
//															labelSeparator: ' ',
//															id: 'escday0',
//															//cls: 'textbox24',
//															name: 'escday0',
//															readOnly : true,
//															width : 200
//														},
//														{
//															xtype: 'component',
//															html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\'escday0\')"></center>',
//															margin: '20 0 5 2'
//														},
//														{
//															xtype: 'tbspacer',
//															width  : 10
//														},
//														{
//															xtype:'textfield',
//															id: 'escshift0',
//															//cls: 'textbox24',
//															name: 'escshift0',
//															readOnly : true,
//															fieldLabel: userIDValidationMsg53,
//															labelAlign: 'top',
//															labelSeparator: ' ',
//															width : 260
//														},
//														{
//															xtype: 'component',
//															html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\'escshift0\')"></center>',
//															margin: '20 0 5 2'
//														},
//														{
//															xtype : 'container',
//															margin: '18 0 5 2',
//															items : [{
//																xtype : 'button',
//																iconCls : 'iconPlus',
//																tooltip : '<b>add shift period</b>',
//																style : {
//																	background : 'none',
//																	border : '0px'
//																},
//																handler: function()
//																{
//																	addShifts('esc');
//																}
//															}]
//														}
//													]
//												}
//											]
//										}
//									]
//								},
//							]
//						},
//						{
//							xtype: 'container',
//							layout: 'column',
//							margin: '10 0 0 0',
//							items: [
//								{
//									xtype: 'checkboxgroup',
//									id : 'displayAlamGroup',
//									fieldLabel: 'Alarm display',
//									//cls: 'checkbt',
//									columns: 3,
//									vertical: false,
//									items: [
//										{ boxLabel: radioOptionCritical, labelAlign: 'top',name: 'alarm_h',id:'alarm_h',inputValue: 'H',checked: true},
//										{ boxLabel: radioOptionMajor, labelAlign: 'top',name: 'alarm_m',id:'alarm_m',inputValue: 'I',checked: true},
//										{ boxLabel: radioOptionMinor, labelAlign: 'top',name: 'alarm_l',id:'alarm_l',inputValue: 'L',checked: true}
//									],
//									columnWidth: 0.25,
//									margin: '0 0 10 0',
//									labelAlign: 'top',
//									labelSeparator: ' ',
//								},
//								{
//									xtype: 'radiogroup',
//									id : 'alrmDeletion',
//									fieldLabel: 'Allow alarm deletion',
//									//cls: 'radiobt',
//									columns: 2,
//									vertical: false,
//									items: [
//										{ boxLabel: radioOptionYes, labelAlign: 'top',name: 'alarmdelete',inputValue: 'true',checked: false},
//										{ boxLabel: radioOptionNo, labelAlign: 'top',name: 'alarmdelete',inputValue: 'false',checked: true}
//									],
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									columnWidth: 0.25,
//									margin: '0 0 10 20'
//								},
//								{
//									xtype: 'radiogroup',
//									id : 'alrmAck',
//									fieldLabel: 'Allow alarm acknowledgement',
//									//cls: 'radiobt',
//									columns: 2,
//									vertical: false,
//									items: [
//										{ boxLabel: radioOptionYes, labelAlign: 'top',name: 'acknowledgment',inputValue: 'true',checked: false},
//										{ boxLabel: radioOptionNo, labelAlign: 'top',name: 'acknowledgment',inputValue: 'false',checked: true}
//									],
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									columnWidth: 0.25,
//									margin: '0 0 10 20'
//								},
//								{
//									xtype:'combo',
//									id: 'monitorHomePage',
//									name: 'monitorHomePage',
//									//cls: 'dropdown',
//									editable : false,
//									fieldLabel : 'Monitor home page',
//									store: new Ext.data.Store({
//										fields : ['displayField', 'valueField'],
//										data : []
//									}),
//									displayField : 'displayField',
//									valueField : 'valueField',
//									queryMode : 'local',
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									columnWidth: 0.33,
//									disabled : false
//								}
//							]
//						},
//						{
//							xtype: 'container',
//							layout : 'column',
//							//layout: {
//							//	type: 'hbox',
//							//	pack: 'start'
//							//},
//							margin: '10 0 0 0',
//							items: [
//								{
//									xtype: 'radiogroup',
//									id : 'eGRemoteExec',
//									fieldLabel: 'Remote control',
//									//cls: 'radiobt',
//									columns: 2,
//									vertical: false,
//									items: [
//										{ boxLabel: radioOptionEnable,name: 'remotecontrol',id:'remotecontrol_1',inputValue: 'true',checked: false},
//										{ boxLabel: radioOptionDisable,name: 'remotecontrol',id:'remotecontrol_2',inputValue: 'false',checked: true}
//									],
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									columnWidth: 0.22,
//									//width : 250
//								},
//								{
//									xtype:'combo',
//									id: 'execcommands',
//									name: 'execcommands',
//									//cls: 'dropdown',
//									editable : false,
//									fieldLabel : 'Remote command execution',
//									store: new Ext.data.Store({
//										fields : ['displayField', 'valueField'],
//										data : []
//									}),
//									displayField : 'displayField',
//									valueField : 'valueField',
//									queryMode : 'local',
//									labelAlign: 'top',
//									labelSeparator: ' ',
//									//width : 200,
//									columnWidth: 0.33,
//									disabled : false,
//									hidden : true
//								}
//							]
//						},
//						{
//							xtype: 'fieldcontainer',
//							layout: {
//								type: 'vbox',
//								pack: 'start'
//							},
//							margin: '10 0 0 0',
//							items: [
//								{
//									xtype: 'checkbox',
//									boxLabel: userIDValidationMsg56,
//									checked: false,
//									//cls: 'checkbt',
//									name : 'chkuser',
//									id : 'chkuser',
//									inputValue : 'H',
//									hidden: true
//								},
//								{
//									xtype: 'fieldcontainer',
//									id : 'userAssociate',
//									hidden : true,
//									margin: '10 0 0 0',
//									items: [
//										{
//											xtype: 'label',
//											text: 'Available user(s)'
//										},
//										{
//											xtype: 'multiselect',
//											margin: '6 0 0 0',
//											id : 'availusers',
//											width: 350,
//											height: 120,
//											autoScroll: true,
//											scroll: false,
//											displayField: 'displayField',
//											valueField: 'valueField',
//											store: Ext.create('Ext.data.Store', {
//												fields: ['valueField', 'displayField'],
//												data: []
//											})
//										}
//									]
//								}
//							]
//						}
					]
				},


				{
					xtype: 'fieldset',
					id : 'monitorFieldsContainer',
					title: '<b>Monitor</b>',
					collapsible: true,
					margin: 20,
					scroll : false,
					autoScroll : false,
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								width: 580,
								labelWidth: 300
							},
							items: [
								{
									xtype: 'checkboxgroup',
									id : 'displayAlamGroup',
									fieldLabel: 'Alarm display',
									cls: 'checkbt',
									columns: 3,
									vertical: false,
									items: [
										{ boxLabel: radioOptionCritical, labelAlign: 'top',name: 'alarm_h',id:'alarm_h',inputValue: 'H',checked: true},
										{ boxLabel: radioOptionMajor, labelAlign: 'top',name: 'alarm_m',id:'alarm_m',inputValue: 'I',checked: true},
										{ boxLabel: radioOptionMinor, labelAlign: 'top',name: 'alarm_l',id:'alarm_l',inputValue: 'L',checked: true}
									]
								},
								{
									xtype: 'radiogroup',
									id : 'alrmDeletion',
									fieldLabel: 'Allow alarm deletion',
									cls: 'radiobt',
									columns: 2,
									vertical: false,
									items: [
										{ boxLabel: radioOptionYes, labelAlign: 'top',name: 'alarmdelete',inputValue: 'true',checked: false},
										{ boxLabel: radioOptionNo, labelAlign: 'top',name: 'alarmdelete',inputValue: 'false',checked: true}
									]
								},
								{
									xtype: 'radiogroup',
									id : 'alrmAck',
									fieldLabel: 'Allow alarm acknowledgement',
									cls: 'radiobt',
									columns: 2,
									vertical: false,
									items: [
										{ boxLabel: radioOptionYes, labelAlign: 'top',name: 'acknowledgment',inputValue: 'true',checked: false},
										{ boxLabel: radioOptionNo, labelAlign: 'top',name: 'acknowledgment',inputValue: 'false',checked: true}
									]
								},
								{
									xtype: 'fieldcontainer',
									fieldLabel: homePageLabel,
									layout: 'column',
									items: [
										{
											xtype: 'radiogroup',
											cls: 'radiobt',
											column: 2,
											vertical: false,
											id: 'userProf_monitorHomeOpt',
											name: 'userProf_monitorHomeOpt',
											columnWidth: 1,
											items: [
												{
													boxLabel: homePageOpt1,
													name: 'selectedMonHomeOpt',
													inputValue: 'default',
													labelAlign: 'top',
													checked: true
												},
												{
													boxLabel: homePageOpt2,
													name: 'selectedMonHomeOpt',
													inputValue: 'dynamic',
													labelAlign: 'top',
													checked: false
												}
											]
										},
										{
											xtype:'scrollcombo',
											id: 'monitorHomePage',
											name: 'monitorHomePage',
											cls: 'dropdown24',
											editable : false,
											forceSelection:false,
											store: new Ext.data.Store({
												fields : ['displayField', 'valueField'],
												data : []
											}),
											displayField : 'displayField',
											valueField : 'valueField',
											queryMode : 'local',
											columnWidth: 1
										}
									]
								},
								{
									xtype: 'radiogroup',
									id : 'eGRemoteExec',
									fieldLabel: 'Remote control',
									cls: 'radiobt',
									columns: 2,
									vertical: false,
									items: [
										{ boxLabel: radioOptionEnable,name: 'remotecontrol',id:'remotecontrol_1',inputValue: 'true',checked: false},
										{ boxLabel: radioOptionDisable,name: 'remotecontrol',id:'remotecontrol_2',inputValue: 'false',checked: true}
									]
								},
								{
									xtype:'scrollcombo',
									id: 'execcommands',
									name: 'execcommands',
									//cls: 'dropdown',
									editable : false,
									fieldLabel : 'Remote command execution',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									disabled : false,
									hidden : true
								},
								{	
									xtype: 'radiogroup',
									id : 'userDashboardCreationPrivilege',
									fieldLabel: 'Allow user to create mydashboard',
									cls: 'radiobt',
									columns: 2,
									vertical: false,
									items: [
										{ boxLabel: radioOptionYes, labelAlign: 'top',name: 'dashboardPrivilege',id:'dashboardPrivilegeYes',inputValue: 'true',checked: true},
										{ boxLabel: radioOptionNo, labelAlign: 'top',name: 'dashboardPrivilege',id:'dashboardPrivilegeNo',inputValue: 'false',checked: false}
									]
								}
							]
						}
					]
				},
				{
					xtype: 'fieldset',
					id : 'reporterTimeLine',
					title: '<b>Reporter</b>',
					collapsible: true,
					margin: 20,
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								width: 580,
								labelWidth: 300
							},
							items: [
								{
									xtype:'scrollcombo',
									id: 'timeOpt',
									name: 'timeOpt',
									//cls: 'dropdown',
									editable : false,
									fieldLabel : 'Maximum timeline for reports',
									store: new Ext.data.Store({
										fields : ['displayField', 'valueField'],
										data : []
									}),
									displayField : 'displayField',
									valueField : 'valueField',
									queryMode : 'local',
									disabled : false
								}
							]
						}
					]
				},
				{
					xtype: 'fieldset',
					id : 'autoassociatetousers',
					title: '<b>Associate segments/services/service groups/zones/components</b>',
					collapsible: true,
					hidden : true,
					margin: 20,
					items: [
						{
							xtype: 'container',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'center'
							},
							defaults: {
								labelSeparator: '',
								margin: 5,
								width: 580,
								labelWidth: 300
							},
							items: [
								{
									xtype: 'checkboxgroup',
									fieldLabel: 'Auto-associate to other users',
									cls: 'checkbt',
									columns: 1,
									vertical: false,
									items: [
										{ labelAlign: 'top',name: 'chkuser',id:'chkuser',inputValue: 'yes',checked: false}
									]
								},
								{
									xtype: 'multiselectSi',
									fieldLabel: 'Available user(s)',
									id : 'availusers',
									height: 120,
									cls:"multiselect",
									autoScroll: true,
									displayField: 'displayField',
									valueField: 'valueField',
									store: Ext.create('Ext.data.Store', {
										fields: ['valueField', 'displayField'],
										data: []
									})
								}
							]
						}
					]
				}
			]
		},
		{
			title: pageIntnl81,
			itemId: 'tab3',
			xtype : 'container',
			id : 'elementAssociationTab',
			cls:'tabLayoutInnerBorder',
			style:{'border-top':'0px'},
			items : [
				{
					//xtype : 'elementassociationform',
					//border :false
				}
			],
			hidden : true
		},
		{
			title: pageIntnl82,
			itemId: 'tab4',
			xtype : 'container',
			id : 'elementFilteringTab',
			items : [
				{
					//xtype : 'egmailalertsuppress',
					//border :false
				}
			],
			hidden : true
		}
	],

	buttonAlign : 'center',
	buttons : [
		{
			text : pageIntnl89,
			//cls : 'button20',
			margin : '15 0 0 0',
			cls: "button20",
			id : 'btnNext'
		},
		{
			text : pageIntnl90,
			//cls : 'button20',
			margin : '15 15 0 0',
			cls: "button20",
			hidden : true,
			id : 'btnPrev'
		},
		{
			text : pageIntnl83,
			//cls : 'button20',
			hidden : true,
			margin : '15 0 0 0',
			cls: "button20",
			id : 'btnAddUser'
		}
	]

});



