
Ext.define('EgAddUser.view.UserFormPanel', {
	extend: 'Ext.form.Panel',
	requires : [
		'utilities.DatePicker',
		'Ext.ux.form.MultiSelectSI',
		'EgAddUser.view.ShiftsPicker',
		//'utilities.Multiselector'
	],
	alias: 'widget.userformpanel',
	id : 'userformpanel',
	cls:'outerpanel',
	layout : {
		type : 'vbox',
		align : 'center',
		pack : 'center'
	},
	border :false,
	buttonAlign : 'center',
	items : [
		{
			xtype : 'container',
			id : 'frmContainer1',
			items : [
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 620,
				labelWidth: 320,
				editable : false,
				fieldLabel:'User role',
				name: 'utype',
				id: 'utype',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField',"groupField"],
					data : []
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				groupField: 'groupField',
				queryMode : 'local',
				listConfig: {
				  tpl: Ext.create('Ext.XTemplate',
					  '<ul><tpl for=".">',
					  '<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
					  '<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
					  '</tpl>',
					  '<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 1">padding-left: 12px</tpl>">{displayField}</li>',
					  '</tpl>' +
					  '</ul>',
					  {
						getGroupLabel: function (values) {
						  return values.groupField
						}
					  }
					)
				}
			},
			{
				xtype: 'radiogroup',
				fieldLabel: 'User authentication',
				cls: 'radiobt',
				id : 'userAuth',
				name : 'userAuth',
				columns: 2,
				vertical: true,
				items: [
					{ boxLabel: 'Domain', labelAlign: 'top',name: 'authentication',id:'domainAuth',inputValue: 'Domain'},
					{ boxLabel: 'Local', labelAlign: 'top',name: 'authentication',id:'eGAuth',inputValue: 'Eg',checked: true}
				],
				width: 620,
				labelWidth: 320
			}]
		},
		{
			xtype : 'container',
			id : 'fieldsContainer',
		}
	],
	buttons: [
		{
			text : submitBtn,
			id : 'submit',
			name : 'submit',
			cls: 'button20',
			margin: '0 0 10 0',
			hidden : true
		},
		{
			text : validateBtn,
			id : 'validate',
			name : 'validate',
			cls: 'button20',
			margin: '0 0 10 0',
			hidden : true
		},
		{
			text : NextBtn,
			id : 'next',
			name : 'next',
			cls: 'button20',
			margin: '0 0 10 0',
			hidden : true
		}
	]
});

function addContact()
{
	var mainForm = Ext.getCmp('userformpanel');
	if(inputs == 4)
	{
		Ext.Msg.show({
			title: pageTitle,
			msg: userIDValidationMsg46+".",
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	var levelStr = inputs+2
	var conId = "con_"+inputs
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout : {
			type : 'hbox',
			padding : '5px'
		},
		items : [
			{
				xtype:'textfield',
				id: 'email'+inputs,
				cls: 'textbox',
				name: 'email'+inputs,
				fieldLabel : 'Level '+levelStr,
				width: 420,
				labelWidth: 100
			},
			{
				xtype: 'tbspacer',
				width  : 5
			},
			{
				xtype : 'container',
				//cls : 'iconBg',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					tooltip : '<b>remove level</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeContact(conId);
					}
				}]
			}
		]
	}
	escMailIDsDiv.add(tmpContainer);
	//escMailIDsDiv.doLayout();
	mainForm.doLayout();
	inputs++;
}


function addEscLevel(fieldValue)
{
	var mainForm = Ext.getCmp('userformpanel');
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	var levelStr = inputs+2;
	var conId = "con_"+inputs;
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout : {
			type : 'hbox',
			padding : '5px'
		},
		items : [
			{
				xtype:'textfield',
				id: 'email'+inputs,
				cls: 'textbox',
				name: 'email'+inputs,
				fieldLabel : 'Level '+levelStr,
				width: 420,
				value : fieldValue,
				labelWidth: 100
			},
			{
				xtype: 'tbspacer',
				width  : 5
			},
			{
				xtype : 'container',
				//cls : 'iconBg',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					tooltip : '<b>remove level</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeContact(conId);
					}
				}]
			}
		]
	}
	escMailIDsDiv.add(tmpContainer);
	inputs++;
}

function removeContact(containerID)
{
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	escMailIDsDiv.remove(containerID);
	inputs--;

	var conLength = escMailIDsDiv.items.length - 1;
	if (conLength > 0)
	{
		inputs = 0;
		var tnpCount = 0;
		for (var i = 0;i<=conLength;i++)
		{
			var tmpLevelObj = Ext.getCmp("con_"+i);
			if (tmpLevelObj == null || tmpLevelObj == undefined)
			{
				continue;
			}
			var tmpID = tmpLevelObj.getId();
			var value = Ext.getCmp('email'+i).getValue();
			escMailIDsDiv.remove(tmpID);
			addEscLevel(value);
		}
	}
}

function addShifts(type)
{
	var shiftPeriodsCount;
	if (type == "mail")
	{
		var emailMailAlert = Ext.getCmp('emailMailAlert');
		if (mailShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg47+' ('+noOfShiftPeriods+')'+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		shiftPeriodsCount = mailShiftPeriodsCount;
		emailMailAlert.add(getMailShiftTemplate(shiftPeriodsCount));
		mailShiftPeriodsCount++;
		emailMailAlert.doLayout();
	}
	else if (type == "Exec")
	{
		var commandObj = Ext.getCmp('commandAlert');
		if (ExecShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg47+' ('+noOfShiftPeriods+')'+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		shiftPeriodsCount = ExecShiftPeriodsCount;
		commandObj.add(getExecTemplate(shiftPeriodsCount));
		ExecShiftPeriodsCount++;
		commandObj.doLayout();
	}
	else if (type == "sms")
	{
		var smsAlert = Ext.getCmp('smsAlert');
		if (smsShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg47+' ('+noOfShiftPeriods+')'+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		shiftPeriodsCount = smsShiftPeriodsCount;
		smsAlert.add(getSMSTemplate(shiftPeriodsCount));
		smsShiftPeriodsCount++;
		smsAlert.doLayout();
	}
	else if (type == "esc")
	{
		var escMailAlert = Ext.getCmp('escMailAlert');
		if (escShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg47+' ('+noOfShiftPeriods+')'+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		shiftPeriodsCount = escShiftPeriodsCount;
		escMailAlert.add(getEscTemplate(shiftPeriodsCount));
		escShiftPeriodsCount++;
		escMailAlert.doLayout();
	}
}

function removeMailShift(containerID)
{
	var escMailIDsDiv = Ext.getCmp('emailMailAlert');
	escMailIDsDiv.remove(containerID);
	mailShiftPeriodsCount--;
}

function removeExecShift(containerID)
{
	var commandAlert = Ext.getCmp('commandAlert');
	commandAlert.remove(containerID);
	ExecShiftPeriodsCount--;
}

function removeSMSShift(containerID)
{
	var smsAlert = Ext.getCmp('smsAlert');
	smsAlert.remove(containerID);
	smsShiftPeriodsCount--;
}

function removeEscShift(containerID)
{
	var escMailAlert = Ext.getCmp('escMailAlert');
	escMailAlert.remove(containerID);
	escShiftPeriodsCount--;
}

function getMailShiftTemplate(id)
{
	var tmpId = "mailday"+(id+1);
	var tmpId2 = "mailshift"+(id+1);
	var conId = "mailShift_"+id
	var tmpShiftData = {
		xtype : 'container',
		id : conId,
		layout : {
			type : 'hbox',
			padding : '5px'
		},
		items : [
			{
				xtype : 'panel',
				html : "<div sttle=\"cursor:hand\" onclick=\"javascript:showDaysPicker('"+tmpId+"')\">Days&nbsp;<img src='/final/admin/eg_images/calendar.gif' border=\"0\"  align=\"absmiddle\"></div>",
			},
			{
				xtype: 'tbspacer',
				width  : 3
			},
			{
				xtype:'textfield',
				id: tmpId,
				cls: 'textbox',
				name: tmpId,
				width: 200,
				readOnly : true,
			},
			{
				xtype: 'tbspacer',
				width  : 10
			},
			{
				xtype : 'panel',
				html : "<div sttle=\"cursor:hand\" onclick=\"javascript:showShiftsPicker('"+tmpId2+"')\">Shifts&nbsp;<img src='/final/admin/eg_images/calendar.gif' border=\"0\"  align=\"absmiddle\"></div>",
			},
			{
				xtype: 'tbspacer',
				width  : 3
			},
			{
				xtype:'textfield',
				id: tmpId2,
				cls: 'textbox',
				name: tmpId2,
				width: 200,
				readOnly : true,
			},
			{
				xtype: 'tbspacer',
				width  : 5
			},
			{
				xtype : 'container',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeMailShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function getExecTemplate(id)
{
	var tmpId = "Execday"+(id+1);
	var tmpId2 = "Execshift"+(id+1);
	var conId = "ExecShift_"+id
	var tmpShiftData = {
		xtype : 'container',
		id : conId,
		layout : {
			type : 'hbox',
			padding : '5px'
		},
		items : [
			{
				xtype : 'panel',
				html : "<div sttle=\"cursor:hand\" onclick=\"javascript:showDaysPicker('"+tmpId+"')\">Days&nbsp;<img src='/final/admin/eg_images/calendar.gif' border=\"0\"  align=\"absmiddle\"></div>",
			},
			{
				xtype: 'tbspacer',
				width  : 3
			},
			{
				xtype:'textfield',
				id: tmpId,
				cls: 'textbox',
				name: tmpId,
				width: 200,
				readOnly : true,
			},
			{
				xtype: 'tbspacer',
				width  : 10
			},
			{
				xtype : 'panel',
				html : "<div sttle=\"cursor:hand\" onclick=\"javascript:showShiftsPicker('"+tmpId2+"')\">Shifts&nbsp;<img src='/final/admin/eg_images/calendar.gif' border=\"0\"  align=\"absmiddle\"></div>",
			},
			{
				xtype: 'tbspacer',
				width  : 3
			},
			{
				xtype:'textfield',
				id: tmpId2,
				cls: 'textbox',
				name: tmpId2,
				width: 200,
				readOnly : true,
			},
			{
				xtype: 'tbspacer',
				width  : 5
			},
			{
				xtype : 'container',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeExecShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function getSMSTemplate(id)
{
	var tmpId = "smsday"+(id+1);
	var tmpId2 = "smsshift"+(id+1);
	var conId = "SMSShift_"+id
	var tmpShiftData = {
		xtype : 'container',
		id : conId,
		layout : {
			type : 'hbox',
			padding : '5px'
		},
		items : [
			{
				xtype : 'panel',
				html : "<div sttle=\"cursor:hand\" onclick=\"javascript:showDaysPicker('"+tmpId+"')\">Days&nbsp;<img src='/final/admin/eg_images/calendar.gif' border=\"0\"  align=\"absmiddle\"></div>",
			},
			{
				xtype: 'tbspacer',
				width  : 3
			},
			{
				xtype:'textfield',
				id: tmpId,
				cls: 'textbox',
				name: tmpId,
				width: 200,
				readOnly : true,
			},
			{
				xtype: 'tbspacer',
				width  : 10
			},
			{
				xtype : 'panel',
				html : "<div sttle=\"cursor:hand\" onclick=\"javascript:showShiftsPicker('"+tmpId2+"')\">Shifts&nbsp;<img src='/final/admin/eg_images/calendar.gif' border=\"0\"  align=\"absmiddle\"></div>",
			},
			{
				xtype: 'tbspacer',
				width  : 3
			},
			{
				xtype:'textfield',
				id: tmpId2,
				cls: 'textbox',
				name: tmpId2,
				width: 200,
				readOnly : true,
			},
			{
				xtype: 'tbspacer',
				width  : 5
			},
			{
				xtype : 'container',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeSMSShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function getEscTemplate(id)
{
	var tmpId = "escday"+(id+1);
	var tmpId2 = "escshift"+(id+1);
	var conId = "ESCShift_"+id
	var tmpShiftData = {
		xtype : 'container',
		id : conId,
		layout : {
			type : 'hbox',
			padding : '5px'
		},
		items : [
			{
				xtype : 'panel',
				html : "<div sttle=\"cursor:hand\" onclick=\"javascript:showDaysPicker('"+tmpId+"')\">Days&nbsp;<img src='/final/admin/eg_images/calendar.gif' border=\"0\"  align=\"absmiddle\"></div>",
			},
			{
				xtype: 'tbspacer',
				width  : 3
			},
			{
				xtype:'textfield',
				id: tmpId,
				cls: 'textbox',
				name: tmpId,
				width: 200,
				readOnly : true,
			},
			{
				xtype: 'tbspacer',
				width  : 10
			},
			{
				xtype : 'panel',
				html : "<div sttle=\"cursor:hand\" onclick=\"javascript:showShiftsPicker('"+tmpId2+"')\">Shifts&nbsp;<img src='/final/admin/eg_images/calendar.gif' border=\"0\"  align=\"absmiddle\"></div>",
			},
			{
				xtype: 'tbspacer',
				width  : 3
			},
			{
				xtype:'textfield',
				id: tmpId2,
				cls: 'textbox',
				name: tmpId2,
				width: 200,
				readOnly : true,
			},
			{
				xtype: 'tbspacer',
				width  : 5
			},
			{
				xtype : 'container',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeEscShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function showDaysPicker(mailDayID)
{
	var tmpStore = publicJSON['daysPicker'];
	var expandWindow = Ext.create('Ext.window.Window',{
		title:'DAYS',
		width:150,
		height:200,
		doClose: function() {
			this.destroy();
		},
		buttonAlign:'center',
		items:[
			{
				xtype: 'multiselectSi',
				cls:"multiselect",
				width: 200,
				height:100,
				scroll:true,
				name: 'multiselect',
				labelAlign:'left',
				allowBlank: false,
				id: 'daysList',
				name: 'daysList',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []					
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			}
		],
		buttons : [
			{
				text : 'Add',
				id : 'daysAdd',
				name : 'daysAdd',
				cls: 'button20',
				margin: '0 0 10 0',
				handler : function()
				{
					var tmpStr = "";
					var daysList = Ext.getCmp('daysList');
					var objTemp = daysList.getSelected();
					if (!Ext.isEmpty(objTemp))
					{
						for (key in objTemp)
						{
							tmpStr = tmpStr + objTemp[key].get("valueField") + ",";
						}
						tmpStr = tmpStr.substring(0,tmpStr.length - 1);
						Ext.getCmp(mailDayID).setValue(tmpStr);
						expandWindow.destroy();
						expandWindow = null;
					}
					else
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: userIDValidationMsg64+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				}
			}
		]
	}).show();
	var daysListObj = Ext.getCmp('daysList');
	daysListObj.getStore().loadRawData(tmpStore);
	var selectedDays = Ext.getCmp(mailDayID).getValue();
	daysListObj.setValue(selectedDays);
}

function showShiftsPicker(shiftId)
{
	var tmpHeight = 0;
	var expandWindow = Ext.create('Ext.window.Window',{
		title:'SHIFTS',
		requires : ['EgAddUser.view.ShiftsPicker'],
		width:460,
		height:128,
		id : 'shiftsPickerWinow',
		//autoScroll:true,
		doClose: function() {
			tmpShiftPeriodsCount = 0
			this.destroy();
		},
		buttonAlign:'center',
		items : [
			{
				xtype: 'shiftspicker',
				listeners : {
					afterrender : function()
					{
						var selectedTimeVal = Ext.getCmp(shiftId).getValue();
						var shiftsPickerHour = publicJSON['shiftsPickerHour'];
						var shiftsPickerMi = publicJSON['shiftsPickerMi'];
						Ext.getCmp('frHr0').getStore().loadRawData(shiftsPickerHour);
						Ext.getCmp('frMi0').getStore().loadRawData(shiftsPickerMi);
						Ext.getCmp('toHr0').getStore().loadRawData(shiftsPickerHour);
						Ext.getCmp('toMi0').getStore().loadRawData(shiftsPickerMi);
					
						if (Ext.isEmpty(selectedTimeVal))
						{
							Ext.getCmp('frHr0').setValue(Ext.getCmp('frHr0').getStore().getAt(0).get("valueField"));
							Ext.getCmp('frMi0').setValue(Ext.getCmp('frMi0').getStore().getAt(0).get("valueField"));
							Ext.getCmp('toHr0').setValue(Ext.getCmp('toHr0').getStore().getAt(0).get("valueField"));
							Ext.getCmp('toMi0').setValue(Ext.getCmp('toMi0').getStore().getAt(0).get("valueField"));
						}
						else
						{
							var shiftTimeArr = selectedTimeVal.split(",");
							var tmpcount = 1;
							for (var i = 0;i<shiftTimeArr.length;i++)
							{
								if (tmpcount > 1)
								{
									tmpHeight = tmpHeight + 30;
									addShiftTimeTemp();
								}
								var tmpData = shiftTimeArr[i];
								var from = tmpData.substring(0,tmpData.indexOf("-"));
								var to = tmpData.substring(tmpData.indexOf("-")+1);
								var fromHr = from.substring(0,from.indexOf(":"));
								var fromMi = from.substring(from.indexOf(":")+1);
								var toHr = to.substring(0,to.indexOf(":"));
								var toMi = to.substring(to.indexOf(":")+1);
								Ext.getCmp('frHr'+i).setValue(fromHr);
								Ext.getCmp('frMi'+i).setValue(fromMi);
								Ext.getCmp('toHr'+i).setValue(toHr);
								Ext.getCmp('toMi'+i).setValue(toMi);
								tmpcount++;
							}
						}
					}
				}
			}
		],
		buttons : [
			{
				text : 'Add',
				cls: 'button20',
				margin: '0 0 10 0',
				handler : function()
				{
					if (checkInputs())
					{
						var tmpStr = "";
						for (var i=0;i<5;i++)
						{
							var tmpFHr = Ext.getCmp('frHr'+i);
							if (tmpFHr == null)
								continue;

							var tmpFMi = Ext.getCmp('frMi'+i);
							var tmpTHr = Ext.getCmp('toHr'+i);
							var tmpTMi = Ext.getCmp('toMi'+i);
							var tmp = tmpFHr.value+":"+tmpFMi.value+"-"+tmpTHr.value+":"+tmpTMi.value;
							tmpStr += tmp+",";
						}
						tmpStr = tmpStr.substring(0,tmpStr.length-1);
						Ext.getCmp(shiftId).setValue(tmpStr);
						expandWindow.destroy();
						expandWindow = null; 
						tmpShiftPeriodsCount = 0;
					}
				}
			}
		]
	}).show();
	//Ext.getCmp(shiftId).setValue(tmpStr);
	if (tmpHeight != 0)
	{
		var windowHeight = 128+tmpHeight;
		expandWindow.setHeight(windowHeight);
	}
}

function addShiftTime()
{
	var shiftspickerObj = Ext.getCmp('shiftspicker');
	if (tmpShiftPeriodsCount > 3)
	{
		Ext.Msg.show({
			title: pageTitle,
			msg: userIDValidationMsg48+".",
			buttons: Ext.Msg.OK,
			icon: 'iconExclamation'
		});
		return;
	}
	shiftspickerObj.add(getShiftTimeTemplate(tmpShiftPeriodsCount));
	addValuesToTimePicker(tmpShiftPeriodsCount);
	tmpShiftPeriodsCount++;
	var winObj = Ext.getCmp('shiftsPickerWinow');
	var windowHeight = winObj.getHeight();
	windowHeight = windowHeight + 30;
	winObj.setHeight(windowHeight);
	shiftspickerObj.doLayout();
}

function addShiftTimeTemp()
{
	var shiftspickerObj = Ext.getCmp('shiftspicker');
	shiftspickerObj.add(getShiftTimeTemplate(tmpShiftPeriodsCount));
	addValuesToTimePicker(tmpShiftPeriodsCount);
	tmpShiftPeriodsCount++;
	var winObj = Ext.getCmp('shiftsPickerWinow');
	var windowHeight = winObj.getHeight();
	windowHeight = windowHeight + 30;
	winObj.setHeight(windowHeight);
	shiftspickerObj.doLayout();
}

function removeShiftTime(containerID)
{
	var shiftspickerObj = Ext.getCmp('shiftspicker');
	shiftspickerObj.remove(containerID);
	tmpShiftPeriodsCount--;
	var winObj = Ext.getCmp('shiftsPickerWinow');
	var windowHeight = winObj.getHeight();
	windowHeight = windowHeight - 30;
	winObj.setHeight(windowHeight);
	shiftspickerObj.doLayout();
}


function getShiftTimeTemplate(id)
{
	var tmpId1 = "frHr"+(id+1);
	var tmpId2 = "frMi"+(id+1);
	var tmpId3 = "toHr"+(id+1);
	var tmpId4 = "toMi"+(id+1);
	var conId = "shiftTime"+id
	var tmpShiftData = {
		xtype : 'container',
		id : 'shiftTime'+id,
		layout : {
			type : 'hbox',
			padding : '5px'
		},
		items : [
			{
				xtype:'scrollcombo',
				id: tmpId1,
				name: tmpId1,
				cls: 'dropdown',
				editable : false,
				fieldLabel : 'From',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local',
				width: 100,
				labelWidth: 50,
			},
			{
				xtype : 'tbspacer',
				width : 20
			},
			{
				xtype:'scrollcombo',
				id: tmpId2,
				name: tmpId2,
				cls: 'dropdown',
				editable : false,
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local',
				width: 50,
			},
			{
				xtype : 'tbspacer',
				width : 20
			},
			{
				xtype:'scrollcombo',
				id: tmpId3,
				name: tmpId3,
				cls: 'dropdown',
				editable : false,
				fieldLabel : 'To',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local',
				width: 100,
				labelWidth: 50,
			},
			{
				xtype : 'tbspacer',
				width : 20
			},
			{
				xtype:'scrollcombo',
				id: tmpId4,
				name: tmpId4,
				cls: 'dropdown',
				editable : false,
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local',
				width: 50,
			},
			{
				xtype : 'tbspacer',
				width : 20
			},
			{
				xtype : 'container',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					//tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeShiftTime(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function addValuesToTimePicker(id)
{
	id = id +1;
	var shiftsPickerHour = publicJSON['shiftsPickerHour'];
	var shiftsPickerMi = publicJSON['shiftsPickerMi'];
	Ext.getCmp('frHr'+id).getStore().loadRawData(shiftsPickerHour);
	Ext.getCmp('frHr'+id).setValue(Ext.getCmp('frHr'+id).getStore().getAt(0).get("valueField"));
	Ext.getCmp('frMi'+id).getStore().loadRawData(shiftsPickerMi);
	Ext.getCmp('frMi'+id).setValue(Ext.getCmp('frMi'+id).getStore().getAt(0).get("valueField"));
	Ext.getCmp('toHr'+id).getStore().loadRawData(shiftsPickerHour);
	Ext.getCmp('toHr'+id).setValue(Ext.getCmp('toHr'+id).getStore().getAt(0).get("valueField"));
	Ext.getCmp('toMi'+id).getStore().loadRawData(shiftsPickerMi);
	Ext.getCmp('toMi'+id).setValue(Ext.getCmp('toMi'+id).getStore().getAt(0).get("valueField"));
}


function checkInputs()
{
	for (var i=0;i<5;i++)
	{
		var tmpFHr = Ext.getCmp('frHr'+i);
		if (tmpFHr == null)
			continue;

		var tmpFMi = Ext.getCmp('frMi'+i);
		var tmpTHr = Ext.getCmp('toHr'+i);
		var tmpTMi = Ext.getCmp('toMi'+i);

		if ((tmpFHr.value == tmpTHr.value && tmpFMi.value == tmpTMi.value) ||
			(tmpFHr.value > tmpTHr.value) || ((tmpFHr.value == tmpTHr.value) && (tmpFMi.value > tmpTMi.value)))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg49+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
	}
	return true;
}


function uploadUserImage(imageFor)
{
	var url  = "";
	var logoPath  = "";
	if (imageFor == "login")
	{
		url = "../servlet/com.eg.EgFileUpload?fromPage=EgConfigLogoMsg.jsp&uploadFor=login&fileExt=gif&uploadFir=manager/tomcat/webapps/final/admin/eg_images/";
		logoPath = "manager/tomcat/webapps/final/admin/eg_images/";
	}
	var uname = Ext.getCmp('uname').getValue();
	var grpname = Ext.getCmp('grpname').getValue();
	var authenticationType = Ext.getCmp('userAuth').getValue().authentication;
	if(uname !='' && uname != undefined)
	{

		var logoname = uname+"_"+imageFor+".gif";
		if(authenticationType=="Domain")
		{
			var domainName = Ext.getCmp('domainName').getValue();
			logoname = domainName.toLowerCase()+"_"+logoname;
		}
		logoPath = logoPath +logoname;
		url=url+escape(logoname);
	}
	else if(grpname!='-1' && grpname!=undefined && grpname!='')
	{
		if(authenticationType == "Domain")
		{
			var domainName = Ext.getCmp('domainName').getValue();
			var logoname=domainName.toLowerCase()+"_"+grpname+"_"+imageFor+".gif";
			url=url+escape(logoname);
		}
		logoPath = logoPath +logoname;
	}
	showUserImageUploader(imageFor,url,logoPath);
}

function showUserImageUploader(imageFor,url,logoPath)
{
	fileUploadURI = url;
	filePath = logoPath;
	var expandWindow = Ext.create('Ext.window.Window',{
		extend: 'Ext.panel.Panel',
		title:'Files to be uploaded',
		requires : ['EgAddUser.view.FileUpload'],
		width:500,
		height:200,
		doClose: function() {
			this.destroy();
		},
		items : [
			{
				xtype : 'fileupload',
			}
		],
	}).show();
}


