var taskRunner = new Ext.util.TaskRunner();

var genericTask = taskRunner.newTask({
	run: function() {
		appCnt.processTask();
	},
	interval: 60000
});

Ext.define('EgAdminHome.controller.Main',{
	extend:'Ext.app.Controller',
	views : ['Main','UploadAgentsWizard','DownloadAgentsWizard','DownloadUtils'],
	refs: [
		{selector:'main',ref:'main'},
		{selector:'DownloadUtils', ref:'DownloadUtils'},
		{selector:'UploadAgentsWizard', ref:'UploadAgentsWizard'},
		{selector:'DownloadAgentsWizard', ref:'DownloadAgentsWizard'}
	],
	init: function(){
		appCnt = this;
		this.buildMainData();
		this.control({
			'main': {
				'afterrender': this.afterMainRender
			},
			'main tabpanel':
			{
				'afterrender': this.loadDefaultValues,
				'beforetabchange': this.getServerData
			},
			'main grid[id="unconfiguredTestsSummary"]':
			{
				'viewready':this.loadGridData
			}
		});
	},

	processTask : function()
	{
		var viewName = Ext.getCmp('homepanel').items.keys[0];
		this.buildMainData();
		var showUploadAgentUI = publicJSON['showUploadAgentUI'];
		var showDownloadAgentUI = publicJSON['showDownloadAgentUI'];
		if (viewName != null && viewName == 'UploadAgentsWizard')
		{
			if (!showUploadAgentUI)
			{
				Ext.getCmp('uploadAgentMsgCont').update('<div class="agentBuildGuide"><div class="aPanelMsg" style="margin:16px 10px 5px 10px;">eG Agents are responsible for continuous monitoring of your applications and infrastructure. You may download these agents at any time from the eG Manager.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;">Download the agents from the location <br><span style="font-weight:500;">'+agentUploadLink+'</span><br> and upload the downloaded zip files to the location<br><span style="font-weight:500;">&lt;EG_INSTALL_DIR&gt;\\manager\\agents\\Universal\\Latest</span>.</div></div>');
				if (!Ext.isEmpty(Ext.getCmp('nextStep')))
				{
					Ext.getCmp('nextStep').setDisabled(false);
					genericTask.stop();
				}
			}
			else
			{
				Ext.getCmp('uploadAgentMsgCont').update('<div class="agentBuildGuide"><div class="aPanelMsg" style="margin:16px 10px 5px 10px;">eG Agents are responsible for continuous monitoring of your applications and infrastructure. You may download these agents at any time from the eG Manager.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;">Currently, you have not uploaded any eG Agent to the eG Manager.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;">Download the agents from the location <br><span style="font-weight:500;">'+agentUploadLink+'</span><br> and upload the downloaded zip files to the location<br> <span style="font-weight:500;">&lt;EG_INSTALL_DIR&gt;\\manager\\agents\\Universal\\Latest</span>.</div></div>');
				genericTask.start();
				if (!Ext.isEmpty(Ext.getCmp('nextStep')))
				{
					Ext.getCmp('nextStep').setDisabled(true);
				}
			}
		}
		else if (viewName != null && viewName == 'DownloadAgentsWizard')
		{
			Ext.Ajax.request({
				url : 'EgAdminHome/data/EgAdminOperationsJson.jsp?osName='+osName,
				method : 'POST',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
				}
			});
			var isAgentFileExists = publicJSON['isAgentFileExists'];
			if (isAgentFileExists)
			{
				Ext.getCmp('donwloadAgentMsgCont').update('<div class="agentBuildGuide"><div class="aPanelMsg" style="margin:16px 10px 5px 10px;">Currently, no agent has been installed on the system '+hostName+'.</div><div class="aPanelMsg" style="margin:16px 10px 5px 10px;"> An eG Agent must be installed on this system for external monitoring of applications, servers and network devices.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;"><a href="javascript:void(0)" style="text-decoration:underline;" class="aPanelHighlightText aLinkBottomBorder"  id="uploadAgentMsg" onclick="javascript:appCnt.goToDownloadAgentsUI()">Download and install the eG Agent </a>for <span style="font-weight:500;">'+displayOsNameWithBit+'</span> on the system '+hostName+'.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;">Extract the downloaded zip file. Execute the extracted executable as an administrator.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;"><span style="font-weight:500;">Note: Please ensure you have atleast 4 GB of memory on the system  '+hostName+' for installing this agent.</span></div></div>');
			}
			else
			{
				Ext.getCmp('donwloadAgentMsgCont').update('<div class="agentBuildGuide"><div class="aPanelMsg" style="margin:16px 10px 5px 10px;">Currently, no agent has been installed on the system '+hostName+'.</div><div class="aPanelMsg" style="margin:16px 10px 5px 10px;"> An eG Agent must be installed on this system for external monitoring of applications, servers and network devices.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;">The eG Manager has not been configured to allow download of <span style="font-weight:500;">'+displayOsNameWithBit+'</span> agents. Please <a href="javascript:void(0)" style="text-decoration:underline;" class="aPanelHighlightText aLinkBottomBorder"  id="uploadAgentMsg" onclick="javascript:appCnt.goToUploadAgents()">configure</a> the eG Manager to allow download of agents.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;"><span style="font-weight:500;">Note: Please ensure you have atleast 4 GB of memory on the system '+hostName+' for installing this agent.</span></div></div>');
			}

			if (!showDownloadAgentUI)
			{
				if (!Ext.isEmpty(Ext.getCmp('proceedBtn')))
				{
					Ext.getCmp('proceedBtn').setDisabled(false);
					Ext.getCmp('skipBtn1').hide();
					Ext.getCmp('donwloadAgentMsgCont').hide();
					Ext.getCmp('donwloadAgentSuccessMsgCont').show();
					genericTask.stop();
				}
			}
			else
			{
				if (!Ext.isEmpty(Ext.getCmp('proceedBtn')))
				{
					Ext.getCmp('proceedBtn').setDisabled(true);
					Ext.getCmp('skipBtn1').show();
					Ext.getCmp('donwloadAgentMsgCont').show();
					Ext.getCmp('donwloadAgentSuccessMsgCont').hide();
				}
			}
		}
	},
	
	goToUploadAgents : function()
	{
		var viewportObj = Ext.getCmp('homepanel');
		viewportObj.removeAll();
		viewportObj.add({
			xtype: 'UploadAgentsWizard'
		});
		viewportObj.doLayout();
	},

	goToDownloadAgentsUI : function()
	{
		var downloadUtils =  Ext.widget('DownloadUtils');
		var urlStr = '/final/servlet/com.eg.AgentDownloadServlet?from='+encodeURIComponent('Internal')+'&os='+encodeURIComponent(osName)+'&folder='+encodeURIComponent('Universal')+'&agentVersion='+encodeURIComponent('Latest')+'&unzipit=false&issueUID=yes&issueSilentScript=false';
		downloadUtils.download(urlStr,displayOsName,'Internal',true);
	},

	goToSkip : function(skipTo)
	{
		if (!Ext.isEmpty(skipTo) && skipTo == 'DownloadAgentsWizard')
		{
			var viewportObj = Ext.getCmp('homepanel');
			viewportObj.removeAll();
			viewportObj.add({
				xtype: skipTo
			});
			viewportObj.doLayout();
			Ext.getCmp('backbutton').show();
		}
		else
		{
			var viewportObj = Ext.getCmp('homepanel');
			viewportObj.removeAll();
			viewportObj.add({
				xtype: 'main'
			});
			viewportObj.doLayout();
		}
		Ext.Ajax.request({
			url : 'EgAdminHome/data/EgAdminOperationsJson.jsp?reqFrom=iniWrite&skip='+skipTo,
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},

	buildMainData : function()
	{
		Ext.Ajax.request({
			url : 'EgAdminHome/data/EgAdminOperationsJson.jsp',
			method : 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	afterMainRender : function()
	{
		if (publicJSON.hasAllComponentAccess == true)
		{
			var licenseUsageDetails = Ext.getCmp('licenseUsageDetails');
			var userSummaryDetails = Ext.getCmp('userSummaryDetails');
			var agentSummary = Ext.getCmp('agentSummary');

			licenseUsageDetails.getStore().loadRawData(publicJSON.licenseInformation);
			Ext.getCmp('licenseInfo').update("<div style='display:inline-block;margin:2px 0px 0px 0px;'><div style='padding:3px 2px 0px 3px;float:left;text-align:left;' class='font_bold11'>"+publicJSON.licenseText+".</div><div style='float:left;display:inline-block;'><a href='/final/admin/EgLicenseInfo.jsp?from=AdminHome'><div style='float:left;padding:3px 3px 0px 3px;' class='font_bold11'>Click here</div><div style='float:left' class='iconClickHere'></div><div style='float:left;padding:3px 2px 0px 3px;' class='font_bold11'>to know more</div> </a></div></div>");
			if (Ext.isEmpty(publicJSON.registedUsers))
			{
				Ext.getCmp('componentDockItems5').hide();
			}
			else
			{
				userSummaryDetails.getStore().loadRawData(publicJSON.registedUsers);
				Ext.getCmp('displayMessage5').update('<div style="padding:2px;" class="font_bold11"> <a id="mouse" href=\'javascript:loadUserSummaryDetails("-1")\'  class="eg_monlink">'+publicJSON.totalUsers+'</a></div>');
				Ext.getCmp('componentDockItems5').show();
			}
			if (Ext.isEmpty(publicJSON.agentGrid))
			{
				Ext.getCmp('componentDockItems4').hide();
			}
			else
			{
				agentSummary.getStore().loadRawData(publicJSON.agentGrid);
				Ext.getCmp('displayMessage4').update('<div style="padding:2px;" class="font_bold11">'+publicJSON.totalAgents+'</div>');
				Ext.getCmp('componentDockItems4').show();
			}
		}
	},
	startupActivities : function(showActivity)
	{
		if (showActivity)
		{
			var activityWindow = Ext.create('Ext.window.Window',{
				id : 'activityWindow',
				frame : true,
				title : 'Manager Notification',
				floating : true,
				items : [
					{
						xtype : 'container',
						flex : 1,
						html : "<div style='text-align:left;font-size:11px;width:350px;margin:10 10 5 10; background-color: #FEEFB3;border:red 1px solid;padding:5px;'><div><img src='/final/admin/eg_images/eg_warning.gif'/></div><div style='margin:4px 4px'>The following components have not been configured for agentless monitoring</div></div><div style='text-align:left;font-size:11px;width:350px;margin:5 10 10 10; background-color: #FEEFB3;border:red 1px solid;padding:5px;'><div><img src='/final/admin/eg_images/eg_warning.gif'/></div><div style='margin:4px 4px'>The following components have not been configured for agentless monitoring</div></div>"
					}
				]
			});
			activityWindow.setPosition(Ext.getCmp('homepanel').getWidth() - 430,30);
			activityWindow.show();
		}
	},
	showManagerTasks : function()
	{
		if (Ext.getCmp('mgrTaskWindow') == undefined || Ext.getCmp('mgrTaskWindow') == null)
		{
			Ext.widget('window',{
				id : 'mgrTaskWindow',
				title : 'Manager Tasks',
				width : 600,
				height: 500,
				closeAction: 'destroy',
				doClose: function() {
					this.destroy();
				},
			}).show();
		}
	},
	showManagerNotifications : function()
	{
		if (Ext.getCmp('mgrNotificationWindow') == undefined || Ext.getCmp('mgrNotificationWindow') == null)
		{
			Ext.widget('window',{
				id : 'mgrNotificationWindow',
				title : 'Notifications',
				width : 600,
				height: 500,
				closeAction: 'destroy',
				doClose: function() {
					this.destroy();
				},
			}).show();
		}
	},
	updateDeferText : function(ct, column, e, t, eOpts)
	{
		var tmpStore = Ext.getCmp('unconfiguredTestsSummary').getStore();
		if (tmpStore.getCount() == 0)
		{
			var deferMessageObj = Ext.select("#deferMessage");
			if (deferMessageObj != null && deferMessageObj != undefined)
			{
				if (unconfigComponentState == "allconfigured")
				{
					deferMessageObj.update(intnlMessage14+'.');
				}
				else
				{
					deferMessageObj.update(intnlMessage15+'.');
				}
			}
		}
	},
	loadDefaultValues : function()
	{
		this.getServerDetails('individual');
	},
	getServerDetails : function(activityType)
	{
		var tmpMask = new Ext.LoadMask(Ext.getCmp('managedComponentsDiv'), {msg: 'Loading...'});
		tmpMask.show();
		Ext.Ajax.request({
			url : 'EgAdminHome/data/EgShowServerTypesJson.jsp?showOnly='+activityType,
			method : 'POST',
			success: function(response)
			{
				tmpMask.hide();
				var jsonText = response.responseText;
				serverJson = Ext.decode(jsonText);
				var componentView = Ext.getCmp('componentView');
				var aggView = Ext.getCmp('aggView');
				if (serverJson.aggregateSupported == false)
				{
					var tab2 = Ext.getCmp('managedComponentsDiv').child('#tab2');
					tab2.tab.hide();
					Ext.getCmp('managedComponentsDiv').getTabBar().setVisible(false);
				}
				else
				{
					var tab2 = Ext.getCmp('managedComponentsDiv').child('#tab2');
					tab2.tab.show();
				}
				if (activityType == "individual")
				{
					if (serverJson.componentListArr == undefined || Ext.isEmpty(serverJson.componentListArr))
					{
						if (Ext.getCmp('componentDockItems1') != undefined)
						{
							//Ext.getCmp('componentView').removeDocked(Ext.getCmp('componentDockItems1'));
							Ext.getCmp('componentDockItems1').hide();
						}
						//Ext.getCmp('aggView').getView().el.select('.x-grid3-header').setStyle('display', 'none');
					}
					else
					{
						Ext.getCmp('componentDockItems1').show();
						componentView.getStore().loadRawData(serverJson.componentListArr);
						Ext.getCmp('displayMessage1').update('<div style="padding:2px;" class="font_bold11">'+serverJson.totalcount+'</div>');
					}


				}
				else
				{

					if (serverJson.componentListArr == undefined || Ext.isEmpty(serverJson.componentListArr))
					{
						if (Ext.getCmp('componentDockItems2') != undefined)
						{
							//Ext.getCmp('aggView').removeDocked(Ext.getCmp('componentDockItems2'));
							Ext.getCmp('componentDockItems2').hide();
						}
						//Ext.getCmp('aggView').getView().el.select('.x-grid3-header').setStyle('display', 'none');
					}
					else
					{
						Ext.getCmp('componentDockItems2').show();
						aggView.getStore().loadRawData(serverJson.componentListArr);
						Ext.getCmp('displayMessage2').update('<div style="padding:2px;" class="font_bold11">'+serverJson.totalcount+'</div>');
					}
				}
			}
		});
	},
	getServerData : function(tabPanel, newCard, oldCard, eOpts)
	{
		var selectedTab = newCard.itemId;
		if (selectedTab == "tab1")
		{
			this.getServerDetails('individual');
		}
		else
		{
			this.getServerDetails('aggregate');
		}
	},
	loadGridData : function()
	{
		if (publicJSON.hasAllComponentAccess == true)
		{
			var unconfiguredTestsSummary = Ext.getCmp('unconfiguredTestsSummary');
			if (publicJSON.hasManagedComponents == true && publicJSON.hasUnConfiguredTests == true)
			{
				Ext.getCmp('displayMessage3').update('<div style="padding:2px;" class="font_bold11">'+publicJSON.unConfiguredTestsCount+'</div>');
				Ext.getCmp('componentDockItems3').show();
				unconfiguredTestsSummary.getStore().loadRawData(publicJSON.unconfiguredComponentTestsArr);
				//if (publicJSON.isConfigSupported == false)
				//{
				//	unconfiguredTestsSummary.columns[2].hide();
				//}
				//else
				//{
				//	unconfiguredTestsSummary.columns[2].show();
				//}
			}
			else if (publicJSON.hasManagedComponents == true && publicJSON.hasUnConfiguredTests == false)
			{
				var deferMessageObj = Ext.select("#deferMessage");
				if (deferMessageObj != null && deferMessageObj != undefined)
				{
					deferMessageObj.update(intnlMessage14+'.');
				}
				Ext.getCmp('componentDockItems3').hide();
				unconfigComponentState = "allconfigured";
			}
			else
			{
				var deferMessageObj = Ext.select("#deferMessage");
				if (deferMessageObj != null && deferMessageObj != undefined)
				{
					deferMessageObj.update(intnlMessage15+'.');
				}
				Ext.getCmp('componentDockItems3').hide();
				unconfigComponentState = "nocompfound";
			}
		}
	},
	getNotReportingAgentsInfo : function()
	{
		alertAgents = alertAgents.toLowerCase();
		if (alertAgents != 'null' && alertAgents == "yes" && parseInt(agentsNotRunningList) > 0)
		{
			Ext.Ajax.request({
				url : 'EgAdminHome/data/EgAgentsNotRunningDetailsJson.jsp',
				method : 'POST',
				success: function(response)
				{
					var agentsInfo = Ext.decode(response.responseText);
					var gridObj = Ext.getCmp('agentReporting');
					gridObj.getStore().loadRawData(agentsInfo.agentsGrid);
					Ext.getCmp('displayMessage7').setValue(agentsInfo.notReportingAgentsCount);
					gridObj.hide();
					//ridObj.hide();
				}
			});
		}
		else
		{
			var gridObj = Ext.getCmp('agentReporting');
			gridObj.hide();
			//gridObj.show();
		}
	},
	searchOnChange : function(obj)
	{
		this.searchAgents(obj.getValue());
	},
	searchAgents : function(strValue)
	{
		var url1 = "";
		if (strValue == null || strValue=="" || strValue.length == 0)
		{
			url1 = "EgAdminHome/data/EgAgentsNotRunningDetailsJson.jsp";
		}
		else if(strValue != null)
		{
			url1 = "EgAdminHome/data/EgAgentsNotRunningDetailsJson.jsp?egTitleSearchStr="+encodeURI(strValue);
		}

		Ext.Ajax.request({
			url : url1,
			method : 'POST',
			success: function(response)
			{
				var agentsInfo = Ext.decode(response.responseText);
				var gridObj = Ext.getCmp('agentReporting');
				gridObj.getStore().loadRawData(agentsInfo.agentsGrid);
				Ext.getCmp('displayMessage7').setValue(agentsInfo.notReportingAgentsCount);
			}
		});
	}
});

function loadURL(activity, actionType,rowIndex,store)
{
	if (activity == "component")
	{
		if (actionType == "agg")
		{
			var server = Ext.getCmp('aggView').getStore().getAt(rowIndex).get("hiddenColumn");
			window.location.href = "/final/admin/EgAggregateTree.jsp?qctr=1&server="+encodeURIComponent(server)+"&reqfrom=home";
		}
		else
		{
			var server = Ext.getCmp('componentView').getStore().getAt(rowIndex).get("hiddenColumn");
			window.location.href = "/final/admin/EgDispServer.jsp?comptype="+encodeURIComponent(server)+"&category=-1&reqfrom=home";
		}
	}
	else if (activity == "tests")
	{
		var componentType = Ext.getCmp('unconfiguredTestsSummary').getStore().getAt(rowIndex).get("hiddenColumn");
		var uri ="/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=unConfiguredSummary&componentType="+encodeURIComponent(componentType)+"&showTestType="+actionType;
		window.location.href = uri;
	}
	else if (activity == "agents")
	{
		var uri = "/final/admin/EgServerList.jsp?from=AdminHome";
		var agent =  Ext.getCmp('agentSummary').getStore().getAt(rowIndex).get("hiddenColumn");
		if (actionType == "" || actionType.length == 0)
		{
			uri += "&agentType="+agent+"&agentStatus=All";
		}
		else
		{
			uri += "&agentType="+agent+"&agentStatus="+actionType;
		}
		window.location.href = uri;
	}
}

function addComponent(actualName,ip,hostname,port,localname)
{
	var url ="/final/admin/EgNewServer.jsp?server=new&from=inventory&serverType="+actualName+"&allExternalTests=false&hostcheck=true&hostip="+encodeURIComponent(ip)+"&hostname="+encodeURIComponent(hostname)+"&discPort="+port+"&fromHomePopup=yes";
	window.location.href = url;
}

function loadConfigPage(server)
{
	var actualServerName = server.substring(server.indexOf("#$#")+3);
	actualServerName = actualServerName.substring(0,actualServerName.indexOf("#$#"));
	window.location.href = "EgConfigEnv.jsp?reqfrom=home&srvtype="+encodeURIComponent(actualServerName);
}

function loadUserSummaryDetails(row)
{
	if (row == -1)
	{
		window.location.href = "EgDispUserSites.jsp?expiry=all&reqfrom=home";
	}
	else
	{
		var userStore = Ext.getCmp('userSummaryDetails').getStore();
		var userType = userStore.getAt(row).get("hiddenColumn");
		window.location.href = "EgDispUserSites.jsp?expiry="+userType+"&reqfrom=home";
	}
}



