Ext.define('EgAdminHome.view.DiscoveredCompSummary', {
	extend: 'Ext.grid.Panel',
	alias:'widget.discoveredcompsummary',
	requires: [
		'Ext.grid.feature.Grouping',
		'Ext.grid.*'
	],
	store: new Ext.data.Store({
		fields: ['col_1','col_2','componentType'],
		groupField: 'componentType',
		data: []
	}),
	cls:'gridSkin',
	frame:true,
	collapsible: false,
	resizable: false,
	features: [{
		ftype: 'grouping',
		id : 'componentTypeGrouping',
		//groupHeaderTpl: '<div onclick="javascript:loadConfigPage(\'{name}\')">{name}',
		groupHeaderTpl: [
			'<div onclick="javascript:loadConfigPage(\'{name}\')">{name:this.formatServerName}</div>',
			{
				formatServerName: function(name) {
					var discArr = name.split("#$#");
					return name.substring(0,name.indexOf("#$#")) + " ("+discArr[2]+")";
				}
			}
		],
		hideGroupedHeader: false,
		startCollapsed: false,
	}],
	columns : [
		{
			header: '',
			sortable: false,
			menuDisabled : true,
			dataIndex: 'col_1',
			flex : 1,
			renderer : function(val)
			{
				if (val != "" && val.length > 0)
				{
					var tmpArr = val.split("#$#");
					var tmpTag = '<a id="mouse" href=\'javascript:addComponent("'+tmpArr[0]+'","'+tmpArr[1]+'","'+tmpArr[2]+'","'+tmpArr[3]+'","'+tmpArr[4]+'")\' target="main" class="eg_monlink">'+tmpArr[4]+'</a>';
					return tmpTag;
				}
				else
				{
					return val;
				}
			}
		},
		{
			header: '',
			sortable: false,
			menuDisabled : true,
			dataIndex: 'col_2',
			flex : 1,
			renderer : function(val)
			{
				if (val != "" && val.length > 0)
				{
					var tmpArr = val.split("#$#");
					var tmpTag = '<a id="mouse" href=\'javascript:addComponent("'+tmpArr[0]+'","'+tmpArr[1]+'","'+tmpArr[2]+'","'+tmpArr[3]+'","'+tmpArr[4]+'")\' target="main" class="eg_monlink">'+tmpArr[4]+'</a>';
					return tmpTag;
				}
				else
				{
					return val;
				}
			}
		}
	],
	hideHeaders : true
});