Ext.define('EgAdminHome.view.DownloadAgentsWizard', {
	extend:'Ext.form.Panel',
	alias:'widget.DownloadAgentsWizard',
	id:'DownloadAgentsWizard',
	margin:'8 8 0 8',
	style:{
        'background':'#ffffff'
	},
	title: 'Install Default External/Remote Agent',
	cls:"outerpanel",
	listeners: {
		afterrender: function()
		{
			Ext.getCmp('proceedBtn').setDisabled(true);
			Ext.Ajax.request({
				url : 'EgAdminHome/data/EgAdminOperationsJson.jsp?osName='+osName,
				method : 'POST',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
				}
			});
			var isAgentFileExists = publicJSON['isAgentFileExists'];
			if (isAgentFileExists)
			{
				Ext.getCmp('donwloadAgentMsgCont').update('<div class="agentBuildGuide"><div class="aPanelMsg" style="margin:16px 10px 5px 10px;">Currently, no agent has been installed on the system '+hostName+'.</div><div class="aPanelMsg" style="margin:16px 10px 5px 10px;"> An eG Agent must be installed on this system for external monitoring of applications, servers and network devices.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;"><a href="javascript:void(0)" style="text-decoration:underline;" class="aPanelHighlightText aLinkBottomBorder"  id="uploadAgentMsg" onclick="javascript:appCnt.goToDownloadAgentsUI()">Download and install the eG Agent </a>for <span style="font-weight:500;">'+displayOsNameWithBit+'</span> on the system '+hostName+'.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;">Extract the downloaded zip file. Execute the extracted executable as an administrator.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;"><span style="font-weight:500;">Note: Please ensure you have atleast 4 GB of memory on the system  '+hostName+' for installing this agent.</span></div></div>');
			}
			else
			{
				Ext.getCmp('donwloadAgentMsgCont').update('<div class="agentBuildGuide"><div class="aPanelMsg" style="margin:16px 10px 5px 10px;">Currently, no agent has been installed on the system '+hostName+'.</div><div class="aPanelMsg" style="margin:16px 10px 5px 10px;"> An eG Agent must be installed on this system for external monitoring of applications, servers and network devices.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;">The eG Manager has not been configured to allow download of <span style="font-weight:500;">'+displayOsNameWithBit+'</span> agents. Please <a href="javascript:void(0)" style="text-decoration:underline;" class="aPanelHighlightText aLinkBottomBorder"  id="uploadAgentMsg" onclick="javascript:appCnt.goToUploadAgents()">configure</a> the eG Manager to allow download of agents.</div>'+
				'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;"><span style="font-weight:500;">Note: Please ensure you have atleast 4 GB of memory on the system '+hostName+' for installing this agent.</span></div></div>');
			}
			genericTask.start();
		}
	},
	requires: [
		'EgAdminHome.view.Main'
	],
	items: [
		{
			xtype: 'container',
			id: 'donwloadAgentMsgCont',
			html: '<div class="agentBuildGuide"><div class="aPanelMsg" style="margin:16px 10px 5px 10px;">Currently, no agent has been installed on the system '+hostName+'.</div><div class="aPanelMsg" style="margin:16px 10px 5px 10px;"> An eG Agent must be installed on this system for external monitoring of applications, servers and network devices.</div>'+
			'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;">The eG Manager has not been configured to allow download of <span style="font-weight:500;">'+displayOsNameWithBit+'</span> agents. Please <a href="javascript:void(0)" style="text-decoration:underline;" class="aPanelHighlightText aLinkBottomBorder"  id="uploadAgentMsg" onclick="javascript:appCnt.goToUploadAgents()">configure</a> the eG Manager to allow download of agents.</div>'+
			'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;"><a href="javascript:void(0)" style="text-decoration:underline;" class="aPanelHighlightText aLinkBottomBorder"  id="uploadAgentMsg" onclick="javascript:appCnt.goToDownloadAgentsUI()">Download and install the eG Agent </a>for <span style="font-weight:500;">'+displayOsNameWithBit+'</span> on the system '+hostName+'.</div>'+
			'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;">Extract the downloaded zip file. Execute the extracted executable as an administrator.</div>'+
			'<div class="aPanelMsg" style="margin:16px 10px 5px 10px;"><span style="font-weight:500;">Note: Please ensure you have atleast 4 GB of memory on the system '+hostName+' for installing this agent.</span></div></div>'
		},
		{
			xtype: 'container',
			id: 'donwloadAgentSuccessMsgCont',
			html: '<div class="agentBuildGuide"><div class="aPanelMsg" style="margin:16px 10px 5px 10px;">An eG Agent has been installed on this system for external monitoring of applications, servers and network devices.</div></div>',
			hidden: true
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				align: 'center',
				pack: 'center'
			},
			items : [
				{
					xtype: 'button',
					id: 'skipBtn1',
					text: 'Skip',
					height:24,
					cls: "button20",
					margin: '16 10 5 10',
					width: 80,
					hidden: hideSkip,
					listeners: {
						click : function()
						{
							appCnt.goToSkip("main");
						}
					}
				},
				{
					xtype: 'button',
					id: 'proceedBtn',
					text: 'Finish',
					height:24,
					cls: "button20",
					margin: '16 10 5 10',
					width: 80,
					listeners: {
						click : function()
						{
							var viewportObj = Ext.getCmp('homepanel');
							viewportObj.removeAll();
							viewportObj.add({
								xtype: 'main'
							});
							viewportObj.doLayout();
						}
					}
				}
			]
		}
	],
	tools : [
		{
			xtype: 'button',
			id: 'backbutton',
			text: 'Back',
			cls:'backbutton',
			iconCls:'iconBack',
			hidden: true,
			listeners: {
				click : function()
				{
					appCnt.goToUploadAgents();
				}
			}
		}
	]
});



