Ext.define('EgAdminHome.view.DownloadUtils',{
	alias:'widget.DownloadUtils',
	id:'DownloadUtils',
	download : function(s_qryString,osname,AgentToBeConfigured,defaultAgent)
	{
		var progressBar = Ext.MessageBox.progress({
			title: downloadStatusTitle,
			value: 5,
			width: 500,
			increment: 15,
			closable: true,
			cls:'aProgressBar',
			progressText: 'Connecting..',
			wait: true,
			waitConfig: {
				interval: 200
			},
			msg: '<b>'+downloadStatusMsgPart1+' ('+osname.trim()+') '+downloadStatusMsgPart2+'...</b>'
		});

		var iFrameExists = Ext.query("#pdfIframe");
		if(Ext.isEmpty(iFrameExists))
		{
			Ext.DomHelper.append(document.body, {
				tag: 'iframe',
				frameBorder: 0,
				width: 0,
				height: 0,
				css: 'display:none;visibility:hidden;height:1px;',
				src: s_qryString,
				id: 'pdfIframe'
			});
		}
		else
		{
			Ext.select('#pdfIframe').set( { src :  s_qryString });
		}

		Ext.Ajax.request(
		{
			url : '/final/admin/LimitedAdminHome/data/DownloadStatusJson.jsp?osname='+encodeURIComponent(osname),
			scope:this,
			timeout:240000,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				if(!Ext.isEmpty(jsonData))
				{
					var downloadStatus = jsonData.isDownloaded;
					if(downloadStatus == true)
					{
						progressBar.hide();
						Ext.Msg.show({
							title: 'Install default External/Remote Agent',
							msg: downloadAgentSuccessMsg1+". "+downloadAgentSuccessMsg2+".",
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
					}
					else
					{
						progressBar.hide();
						Ext.Msg.show({
							 title: 'Install default External/Remote Agent',
							 msg: downloadAgentFailureMsg+'!',
							 buttons: Ext.Msg.OK,
							 icon: Ext.Msg.ERROR
						});
					}
				}
				else
				{
					progressBar.hide();
				}
			},
			failure: function()
			{
				progressBar.hide();
			}
		});
	}
});



