Ext.define('EgAdminHome.view.Main', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.main',
	requires: ['EgAdminHome.view.DiscoveredCompSummary','utilities.OuterPanel', 'utilities.CustomGrid', 'utilities.ScrollTabPanel'],
	margin : 0,
	padding:0,
	layout: {
		type: 'hbox',
		pack: 'center',
		align: 'stretch'
	},
	border: false,
	items: [
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'stretch'
			},
			margin:0,
			padding:0,
			flex:.5,
			items: [
				{
					xtype: 'scrolltabPanel',
					title: intnlMessage18,
					flex:.5,
					margin:'10 5 5 10',
					id: 'managedComponentsDiv',
					activeTab: 0,
					plain: false,
					cls: 'tablayout gridSkinOuter',
					bodyStyle:{'border':'0px !important'},
					border: false,
					frame: false,
					scroll:false,
					autoScroll:false,
					items: [
						{
							title: intnlMessage16,
							itemId: 'tab1',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'stretch'
							},
							items: [
								{
									xtype : 'customgrid',
									cls:'gridSkin',
									style:{'border-top-width':'0px'},
									scroll:true,
									autoScroll:true,
									flex:1,
									margin:0,
									dockedItems: [{
										xtype: 'toolbar',
										dock: 'top',
										id : 'componentDockItems1',
										layout:{
											type:'hbox',
											pack:'center',
											align:'center'
										},
										items: [
											{
												xtype:'container',
												id : 'displayMessage1',
												html:'Total Managed Components'
											}
										]
									}],
									id: 'componentView',
									border: false,
									defaults: {
										sortable: true,
										menuDisabled: true,
										draggable: false,
										resizable: false
									},
									store: new Ext.data.Store({
										fields: ['mcomponentType', 'count', 'hiddenColumn'],
										data: []
									}),
									columns: [{
										text: intnlMessage11,
										dataIndex: 'mcomponentType',
										flex: 1,
										menuDisabled: true,
										renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
											var tmpTag = '<a id="mouse" href=\'javascript:loadURL("component","individual","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
											return tmpTag;
										}
									}, {
										text: intnlMessage21,
										dataIndex: 'count',
										flex: 1,
										menuDisabled: true,
										renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
											var tmpTag = '<a id="mouse" href=\'javascript:loadURL("component","individual","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
											return tmpTag;
										}
									}, {
										text: '',
										dataIndex: 'hiddenColumn',
										flex: 1,
										hidden: true,
										menuDisabled: true
									}, ],
									emptyText: "<div style='margin:10% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText' id=\"deferMessage\">"+intnlMessage19+".</div></td></tr></table></div>",
									viewConfig: {
										deferEmptyText: false
									}
								}
							]
						},
						{
							title: intnlMessage17,
							itemId: 'tab2',
							layout: {
								type: 'vbox',
								pack: 'center',
								align: 'stretch'
							},
							items: [
								{
									xtype : 'customgrid',
									cls:'gridSkin',
									style:{'border-top-width':'0px'},
									flex:1,
									margin: 0,
									scroll: true,
									autoScroll:true,
									dockedItems: [{
										xtype: 'toolbar',
										dock: 'top',
										id : 'componentDockItems2',
										layout:{
											type:'hbox',
											pack:'center',
											align:'center'
										},
										items: [
											{
												xtype:'container',
												id : 'displayMessage2',
												html:'Total Components'
											}
										]
									}],
									id: 'aggView',
									border: false,
									defaults: {
										sortable: true,
										menuDisabled: true,
										draggable: false,
										resizable: false
									},
									store: new Ext.data.Store({
										fields: ['mcomponentType', 'count', 'hiddenColumn'],
										data: []
									}),
									columns: [{
										text: intnlMessage11,
										dataIndex: 'mcomponentType',
										flex: 1,
										menuDisabled: true,
										renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
											var tmpTag = '<a id="mouse" href=\'javascript:loadURL("component","agg","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
											return tmpTag;
										}
									}, {
										text: intnlMessage21,
										dataIndex: 'count',
										flex: 1,
										menuDisabled: true,
										renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
											var tmpTag = '<a id="mouse" href=\'javascript:loadURL("component","agg","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
											return tmpTag;
										}
									}, {
										text: '',
										dataIndex: 'hiddenColumn',
										flex: 1,
										hidden: true,
										menuDisabled: true
									}, ],
									hideHeaders: false,
									emptyText: "<div style='margin:10% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText' id=\"deferMessage\">"+intnlMessage20+".</div></td></tr></table></div>",
									viewConfig: {
										deferEmptyText: false
									}
								}
							]
						}
					]
				},
				{
					xtype : 'customgrid',
					frame:false,
					flex:.5,
					cls:'gridSkin gridSkinOuter',
					scroll: true,
					autoScroll: true,
					dockedItems: [{
						xtype: 'toolbar',
						dock: 'top',
						id : 'componentDockItems3',
						layout:{
							type:'hbox',
							pack:'center',
							align:'center'
						},
						items: [
							{
								xtype:'container',
								id : 'displayMessage3',
								html:'Total Components'
							}
						]
					}],
					id: 'unconfiguredTestsSummary',
					margin: '5 5 10 10',
					title: intnlMessage10,
					store: new Ext.data.Store({
						fields: ['componentType', 'numcomponents','hiddenColumn'],
						data: []
					}),
					columns: [{
						text: intnlMessage11,
						dataIndex: 'componentType',
						flex: 1,
						menuDisabled: true,
						sortable: true,
						renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
							var tmpTag = '<a id="mouse" href=\'javascript:loadURL("tests","perTestAndConTest","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
							return tmpTag;
						},
						listeners: {
							headerclick: function (header, column, e, t, eOpts) {
								appCnt.updateDeferText(header, column, e, t, eOpts);
							}
						}
					},
					{
						text: intnlMessage21,
						dataIndex: 'numcomponents',
						flex: 1,
						menuDisabled: true,
						sortable: true,
						renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
							var tmpTag = '<a id="mouse" href=\'javascript:loadURL("tests","perTestAndConTest","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
							return tmpTag;
						},
						listeners: {
							headerclick: function (header, column, e, t, eOpts) {
								appCnt.updateDeferText(header, column, e, t, eOpts);
							}
						}
					},
					{
						text: '',
						dataIndex: 'hiddenColumn',
						hidden: true,
						sortable: false,
						menuDisabled: true
					}],
					emptyText: "<div style='margin:12% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText' id=\"deferMessage\">"+intnlMessage15+".</div></td></tr></table></div>",
					viewConfig: {
						deferEmptyText: false
					}
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				pack: 'start',
				align: 'stretch'
			},
			margin:0,
			padding:0,
			flex: .5,
			items: [
				{
					xtype : 'customgrid',
					frame:false,
					margin: '10 10 5 5',
					flex: 0.278,
					cls:'gridSkin gridSkinOuter',
					scroll: true,
					autoScroll: true,
					dockedItems: [{
						xtype: 'toolbar',
						dock: 'top',
						id : 'componentDockItems4',
						layout:{
							type:'hbox',
							pack:'center',
							align:'center'
						},
						items: [
							{
								xtype:'container',
								id : 'displayMessage4',
								html:'Total Components'
							}
						]
					}],
					id: 'agentSummary',
					title: intnlMessage5,
					defaults: {
						menuDisabled: true,
						draggable: false,
						resizable: false
					},
					store: new Ext.data.Store({
						fields: ['agentType', 'totalAents', 'runningAgents', 'notrunningAgents', 'hiddenColumn'],
						data: []
					}),
					columns: [{
						text: intnlMessage9,
						dataIndex: 'agentType',
						flex: 1.5,
						menuDisabled: true,
						sortable: true,
						renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
							var tmpTag = '<a id="mouse" href=\'javascript:loadURL("agents","","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
							return tmpTag;
						}
					}, {
						text: intnlMessage6,
						dataIndex: 'totalAents',
						flex: 1,
						menuDisabled: true,
						sortable: true,
						renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
							var tmpTag = '<a id="mouse" href=\'javascript:loadURL("agents","","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
							return tmpTag;
						}
					}, {
						text: intnlMessage7,
						dataIndex: 'runningAgents',
						flex: 1,
						sortable: true,
						menuDisabled: true,
						renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
							var tmpTag = '<a id="mouse" href=\'javascript:loadURL("agents","Running","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
							return tmpTag;
						}
					}, {
						text: intnlMessage8,
						dataIndex: 'notrunningAgents',
						flex: 1,
						sortable: true,
						menuDisabled: true,
						renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
							var tmpTag = '<a id="mouse" href=\'javascript:loadURL("agents","NotRunning","' + rowIndex + '","' + store + '")\' class="eg_monlink">' + value + '</a>';
							return tmpTag;
						}
					}, {
						text: '',
						dataIndex: 'hiddenColumn',
						flex: 1,
						hidden: true,
						menuDisabled: true
					}, ],
					emptyText: "<table border='0' width='100%'><tr><td align=center valign=top height='30px'>" + intnlMessage4 + ".</td></tr></table>",
					viewConfig: {
						deferEmptyText: false
					}
				},
				{
					xtype : 'customgrid',
					frame:false,
					flex: 0.2074,
					scroll: true,
					autoScroll: true,
					cls:'gridSkin gridSkinOuter',
					dockedItems: [{
						xtype: 'toolbar',
						dock: 'top',
						id : 'componentDockItems5',
						layout:{
							type:'hbox',
							pack:'center',
							align:'center'
						},
						items: [
							{
								xtype:'container',
								id : 'displayMessage5',
								html:'Total Components'
							}
						]
					}],
					id: 'userSummaryDetails',
					margin: '5 10 5 5',
					padding:0,
					title: intnlMessage3,
					defaults: {
						sortable: false,
						menuDisabled: true,
						draggable: false,
						resizable: false
					},
					store: new Ext.data.Store({
						fields: ['userType', 'userCount', 'hiddenColumn'],
						data: []
					}),
					columns: [{
						text: '',
						dataIndex: 'userType',
						flex: 1,
						renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
							var tmpTag = '<a id="mouse" href=\'javascript:loadUserSummaryDetails("' + rowIndex + '")\'  class="eg_monlink">' + value + '</a>';
							return tmpTag;
						}

					}, {
						text: '',
						dataIndex: 'userCount',
						flex: 1,
						renderer: function (value, metaData, record, rowIndex, colIndex, store, view) {
							var tmpTag = '<a id="mouse" href=\'javascript:loadUserSummaryDetails("' + rowIndex + '")\' class="eg_monlink">' + value + '</a>';
							return tmpTag;
						}
					}, {
						text: '',
						dataIndex: 'hiddenColumn',
						hidden: true,
					}],
					hideHeaders: true,
					emptyText: "<div style='margin:4% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconInformation'></div><div class='commonErrorMsgText'>"+intnlMessage2+".</div></td></tr></table></div>",
					viewConfig: {
						deferEmptyText: false
					}
				},
				{
					xtype : 'customgrid',
					frame:false,
					cls:'gridSkin gridSkinOuter',
					id: 'licenseUsageDetails',
					flex: 0.5,
					margin: '5 10 10 5',
					title: intnlMessage1,
					store: new Ext.data.Store({
						fields: ['Attribute', 'Allowed','Used','Available'],
						data: []
					}),
					dockedItems: [{
						xtype: 'toolbar',
						dock: 'top',
						id : 'componentDockItems6',
						margin:0,
						padding:0,
						layout:{
							type:'hbox',
							pack:'center',
							align:'center'
						},
						items: [
							{
								xtype:'container',
								id : 'licenseInfo',
								height:24,
								html:'Total Components'
							}
						]
					}],
					columns: [
						{
							text: intnlMessage34,
							dataIndex: 'Attribute',
							flex: 1,
							sortable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						{
							text: intnlMessage31,
							dataIndex: 'Allowed',
							flex: 1,
							sortable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						{
							text: intnlMessage32,
							dataIndex: 'Used',
							flex: 1,
							sortable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						},
						{
							text: intnlMessage33,
							dataIndex: 'Available',
							flex: 1,
							sortable: false,
							menuDisabled: true,
							draggable: false,
							resizable: false
						}
					],
					autoScroll: true,
					scroll: true
				}
			]
		}
	]
});



