var fromUpdatefirstTab;
var fromPreviousUpdate;
var updateSettings;
var currExpDate;
var currPwd;
var currCheckExp;
var uTypeChange;
var btnClk = false;
Ext.define('EgChangeUserProfile.controller.Main',{
	extend:'Ext.app.Controller',
	requires : [
		'EgChangeUserProfile.view.FileUpload',
		'EgChangeUserProfile.view.UserFormContainer',
		'EgChangeUserProfile.view.ElementAssociationForm',
		'EgChangeUserProfile.view.EgMailAlertSuppress',
		'EgChangeUserProfile.view.UserGridPanel',
		'EgChangeUserProfile.view.ShiftsPicker',
		'EgChangeUserProfile.view.VmPattern',
		'Ext.ux.form.MultiSelectSI',
		'Ext.ux.form.ItemSelectorSI',
		'utilities.ScrollCombo',
		'utilities.ErUtils'
	],
	views:['Main','EmptyPanel','EgErrorPanel','ComponentGroupedSummaryGrid','ConfigureComponentTypes','VmPattern'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'fileupload', ref:'fileupload'},
		{selector:'userformcontainer', ref:'userformcontainer'},
		{selector:'userformcontainer #eGShiftPeriods', ref:'shifPeroidsCt'},
		{selector:'elementassociationform', ref:'elementassociationform'},
		{selector:'egmailalertsuppress', ref:'egmailalertsuppress'},
		{selector:'shiftspicker', ref:'shiftspicker'},
		{selector:'configurecomponenttypes', ref:'configurecomponenttypes'},
		{selector:'vmpattern', ref:'vmpattern'}
	],
	init:function(){

		appCnt = this;
		this.buildMainData();
		this.control({
			'main':
			{
				'boxready':this.afterMainRender
			},
			'main button[id="backButton"]':
			{
				'click':this.goBack
			},
			'userformcontainer treepicker[id="uname"]':
			{
				'select':this.onUserIDChange
			},
			'userformcontainer treepicker[id="org"]':
			{
				'select':this.onOrganizationChange
			},
			'userformcontainer combo[id="utype"]':
			{
				'select':this.userTypeOnChange
			},
			'userformcontainer radiogroup[id="alarmMsgMode"]':
			{
				'change':this.setMeasureInMailMode
			},
			'userformcontainer button[id="btnSubmit"]':
			{
				'click':this.submitUserDetails
			},
			'userformcontainer button[id="btnNext"]':
			{
				'click':this.moveTab
			},
			'userformcontainer button[id="btnPrev"]':
			{
				'click':this.movePreviousTab
			},
			'userformcontainer checkbox[id="chkuser"]':
			{
				//'change':this.showAvailableUsers
			},
			'userformcontainer checkbox[id="Never"]':
			{
				'change':this.userValidityChange
			},
			'userformcontainer checkbox[id="logoCheck"]':
			{
				'change':this.logoConfiguration
			},
			'userformcontainer checkbox[id="high"]':
			{
				'change':this.showalarmRet
			},
			'userformcontainer checkbox[id="medium"]':
			{
				'change':this.showalarmRet
			},
			'userformcontainer checkbox[id="low"]':
			{
				'change':this.showalarmRet
			},
			'userformcontainer radiogroup[id="eGRemoteExec"]':
			{
				//'change':this.eGRemoteExecution
			},
			//'userformcontainer radiogroup[id="mailshift"]':
			//{
				//'change':this.loadMailShiftAlerts
			//},
			//'userformcontainer radiogroup[id="Execshift"]':
			//{
				//'change':this.loadCommandShiftAlerts
			//},
			//'userformcontainer radiogroup[id="smsshift"]':
			//{
				//'change':this.loadSMSShiftAlerts
			//},
			//'userformcontainer radiogroup[id="escshift"]':
			//{
				//'change':this.loadESCShiftAlerts
			//},
			'userformcontainer combo[id="loginLogo1"]':
			{
				'select':this.loginLogoController
			},
			'userformcontainer combo[id="monitorLogo1"]':
			{
				'select':this.monitorLogoController
			},
			'userformcontainer combo[id="reporterLogo1"]':
			{
				'select':this.repLogoController
			},
			'userformcontainer combo[id="configLogo1"]':
			{
				'select':this.configLogoController
			},
			'fileupload #uploadUsrIcon':
			{
				'click':this.uploadUsrImage
			},
			'userformcontainer':
			{
				'beforetabchange':this.loadUserTab
			},
			'elementassociationform':
			{
				'afterrender':this.initUserElements
			},
			'egmailalertsuppress':
			{
				'afterrender':this.initUserMailConfigs
			},
			'elementassociationform combo[id="orgType"]':
			{
				'select':this.organizationOnChange
			},
			'elementassociationform combo[id="associate"]':
			{
				'select':this.associateOnChange
			},
			'elementassociationform checkbox[id="compAssociation"]':
			{
				'change':this.associateServerType
			},
			'elementassociationform combo[id="compType"]':
			{
				'select':this.getServerDetails
			},
			'elementassociationform combo[id="virtualTypes"]':
			{
				'select':this.callServerType
			},
			'elementassociationform radiogroup[id="vmSelection"]':
			{
				'change':this.getVmTypes
			},
			'elementassociationform multiselectfield[id="virtualServers"]':
			{
				//'change':this.getVMServers
				'change':this.getVmSelectedCheckBox
			},
			'elementassociationform button[id="apply"]':
			{
				'click':this.assignAndAddMore
			},
			'elementassociationform button[id="mailFilterConfig"]':
			{
				'click':this.loadMailFilterTab
			},
			'elementassociationform button[id="finish"]':
			{
				'click':this.submitUserElements
			},
			/*'elementassociationform button[id="getVm"]':
			{
				'click':this.getVMs
			},*/
			'egmailalertsuppress combo[id="filter"]':
			{
				'select':this.popFilterDetails
			},
			'egmailalertsuppress combo[id="CompTypes"]':
			{
				'select':this.popCompTypes
			},
			'egmailalertsuppress combo[id="TestTypes"]':
			{
				'select':this.popTestTypes
			},
			'egmailalertsuppress combo[id="compTypesIn"]':
			{
				'select':this.viewByCriteria
			},
			'egmailalertsuppress combo[id="serseg"]':
			{
				'select':this.changeByServer
			},
			'egmailalertsuppress combo[id="Test"]':
			{
				'select':this.changeByTest
			},
			'egmailalertsuppress multiselectSi[id="compName"]':
			{
				'change':this.changeByComponentName
			},
			'egmailalertsuppress button[id="includeMore"]':
			{
				'click':this.assignAndAddMoreFilters
			},
			'egmailalertsuppress button[id="mailSubmit"]':
			{
				'click':this.submitUserFilterElements
			},
			'elementassociationform button[id="btnViewElements"]':
			{
				'click':this.viewUserAssociatedElements
			},
			'egmailalertsuppress button[id="btnViewFilters"]':
			{
				'click':this.viewFilteredElements
			},
			//'egmailalertsuppress button[id="componentExpander"]':
			//{
			//	'click':this.showComponentSelector
			//},
			'egmailalertsuppress trigger[name="searchbox"]':
			{
				'change': this.egTitleSearch
			},
			'userformcontainer textfield[id="upass"]':
			{
				'change': this.passStrength
			},
			'userformcontainer textfield[id="confpasswd"]':
			{
				'change': this.getConfPass
			},
			'userformcontainer radio[id="alarmNotifyNew"]':
			{
				change:this.setDDInMailMode
			},
			'configurecomponenttypes button[id="btnApply"]':
			{
				'click':this.applySeverChange
			},
			'vmpattern button[id="patternAssociateBtn"]':
			{
				'click':this.viewUserAssociatedElements
			}
		});
	},
	configPatternTypes : function() {
		var pattern = Ext.getCmp('patternName').getValue();
		var _pwin = Ext.create('EgChangeUserProfile.view.VmPattern',{text:pattern}).show();
	},
	setDDInMailMode : function() {
		var typeVal = Ext.getCmp('alarmNotifyNew').getValue();
		if(typeVal == false || typeVal == 'false')
			Ext.getCmp('detailsDiagnosisAlerts').setVisible(false);
		else
			Ext.getCmp('detailsDiagnosisAlerts').setVisible(true);
	},
	passStrength: function(obj)
	{
		var newPwd = obj.getValue();
		var confPwd = Ext.getCmp('confpasswd').getValue();
		currPwd = publicJSON['changeObj'];
		var authenticationType = publicJSON['authenticationType'];
		if (!Ext.isEmpty(authenticationType) && authenticationType == "Eg")
		{
			var pwdCheck = currPwd;
			if(newPwd != null && newPwd != '' && newPwd != undefined)
			{
				if(pwdCheck != newPwd && confPwd != newPwd)
				{
					updateSettings = true;
				}
				else if(pwdCheck == newPwd && confPwd == newPwd)
				{
					updateSettings = false;
				}
			}
			if (uTypeChange != undefined && uTypeChange == true)
			{
				updateSettings = true;
			}
			var pwdLength = publicJSON.pwdLength;
			var pwdComplexityCount = publicJSON.pwdComplexityCount;
			if (pwdLength == "" || pwdLength < 2)
			{
				pwdLength = 8;
			}
			else if(pwdLength != "" && pwdLength < pwdComplexityCount)
			{
				pwdLength = pwdComplexityCount;
			}
			var loginPassword = Ext.getCmp('upass').getValue();
			if (loginPassword.length > 0)
			{
				pass = loginPassword;
			}
			Ext.getCmp('passScore').show();
			var regExp = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[^\da-zA-Z]).+$/;
			var regExp2 = /^(?=.*\d)(?=.*[a-zA-Z])(?=.*[^\da-zA-Z]).+$/;
			var regExp3 = /^(?=.*\d)(?=.*[a-zA-Z]).+$/;
			if (loginPassword.length >= pwdLength && regExp.test(loginPassword))
			{
				Ext.getCmp('passScore').setText(passStr+': '+Strong);
			}
			else if(loginPassword.length >= pwdLength && loginPassword.match(regExp2))
			{
				Ext.getCmp('passScore').setText(passStr+': '+Good);
			}
			else if(loginPassword.length >= pwdLength && loginPassword.match(regExp3))
			{
				Ext.getCmp('passScore').setText(passStr+': '+Fair);
			}
			else if (loginPassword.length == 0)
			{
				Ext.getCmp('passScore').setText(passLabel1+" "+pwdLength+" "+passLabel2);
			}
			else
			{
				Ext.getCmp('passScore').setText(passStr+': '+Weak);
			}
		}
	},
	getConfPass: function(obj)
	{
		var newConfPwd = obj.getValue();
		var uPwd = Ext.getCmp('upass').getValue();
		currConfPwd = publicJSON['changeObj'];
		var authenticationType = publicJSON['authenticationType'];
		if (!Ext.isEmpty(authenticationType) && authenticationType == "Eg")
		{
			var pwdCheck = currPwd;
			if(newConfPwd != null && newConfPwd != '' && newConfPwd != undefined)
			{
				if(pwdCheck != newConfPwd && uPwd != newConfPwd)
				{
					updateSettings = true;
				}
				else if(pwdCheck == newConfPwd && uPwd == newConfPwd)
				{
					updateSettings = false;
				}
			}
			if (uTypeChange != undefined && uTypeChange == true)
			{
				updateSettings = true;
			}
			var loginConfPassword = Ext.getCmp('confpasswd').getValue();
			if (loginConfPassword.length > 0)
			{
				confPass = loginConfPassword;
			}
		}
	},
	pwdComplexityCheck : function(loginPassword)
	{
		var oldPass = publicJSON['changeObj'];
		if (oldPass == loginPassword)
		{
			return "true";
		}
		var _start = "^";
		var _mid = "";
		var _end = ".+$";
		var result = "";
		var dot = ".";
		var brk = "<br/>";
		var pwdComplexity = publicJSON.pwdComplexity;
		if(pwdComplexity != null && pwdComplexity != undefined)
		{
			if(pwdComplexity.indexOf(",") > -1)
			{
				result = "false#";
				var pwdComplexVal = pwdComplexity.split(",");
				for(var k=0; k<pwdComplexVal.length; k++)
				{
					var temp = pwdComplexVal[k].toLowerCase().trim();
					if(temp == "lc")
					{
						_mid += "(?=.*[a-z])";
						result += brk+(k+1)+dot+" "+userIDValidationMsg69;
					}
					else if(temp == "uc")
					{
						_mid += "(?=.*[A-Z])";
						result += brk+(k+1)+dot+" "+userIDValidationMsg70;
					}
					else if(temp == "dg")
					{
						_mid += "(?=.*[0-9])";
						result += brk+(k+1)+dot+" "+userIDValidationMsg71;
					}
					else if(temp == "sp")
					{
						_mid += "(?=.*[^0-9a-zA-Z])";
						result += brk+(k+1)+dot+" "+userIDValidationMsg72;
					}
				}
			}
			else
			{
				result = "false#";
				var temp = pwdComplexity.toString().toLowerCase().trim();
				if(temp == "lc")
				{
					_mid += "(?=.*[a-z])";
					result += userIDValidationMsg69;
				}
				else if(temp == "uc")
				{
					_mid += "(?=.*[A-Z])";
					result +=  userIDValidationMsg70;
				}
				else if(temp == "dg")
				{
					_mid += "(?=.*[0-9])";
					result +=  userIDValidationMsg71;
				}
				else if(temp == "sp")
				{
					_mid += "(?=.*[^0-9a-zA-Z])";
					result +=  userIDValidationMsg72;
				}
			}
			var regExp = new RegExp(_start + _mid + _end);
			if(regExp.test(loginPassword))
			{
				result = "true";
			}
		}
		return result;
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url : appURL,
			async: false,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	getErrorMessageTemplate :function(tmpObj)
	{
		var tmpTable = '<div class="x-table"><table cellspacing="0" width="100%" cellpadding="5" border="0" align="center" class="x-grid-table" style="border:1px solid #c3c3c3"><thead><tr class="x-grid-row"><th class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">Error</div></td></tr></thead>'
		for (var key in tmpObj)
		{
			if (key == "title") continue ;
			var errorMessage = tmpObj[key];
			tmpTable = tmpTable + '<tr class="x-grid-row"><td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner" >'+errorMessage+'</div></td></tr>';
		}
		tmpTable = tmpTable + '</table></div>';
		return tmpTable;
	},
	getVmTypes : function()
	{
		try
		{
			var _type = Ext.getCmp('vmSelection');
			var selected = _type.lastValue.vmselectiongrp;
			if(!Ext.isEmpty(selected) && selected == 1)
			{
				Ext.getCmp('patternContainer').hide();
				Ext.getCmp('selectorFieldContainer').show();
				this.getVMs();
			}
			else if(!Ext.isEmpty(selected) && selected == 2)
			{
				Ext.getCmp('patternContainer').show();
				//Ext.getCmp('searchFieldContainer').hide();
				Ext.getCmp('selectorFieldContainer').hide();
				this.getVMsPattern();
			}
			else if(!Ext.isEmpty(selected) && selected == 3)
			{
				//Ext.getCmp('searchFieldContainer').hide();
				Ext.getCmp('selectorFieldContainer').hide();
				Ext.getCmp('patternContainer').hide();
			}
		}
		catch (e)
		{
		}
	},
	getVmSelectedCheckBox : function(ele,newValue,oldValue,eOpts)
	{
		updateSettings = false;
		this.virtualServersChange(ele,newValue,oldValue,eOpts);
		var obj = Ext.getCmp('virtualServers');
		var virtualTypesval = Ext.getCmp('virtualTypes').getValue();
		var selectedVMHosts = obj.getValue();
		var _type = Ext.getCmp('vmSelection');
		var selected = _type.lastValue.vmselectiongrp;
		
		if(selectedVMHosts == "-1" || selectedVMHosts.length == 0)
			return;
		
		if (selectedVMHosts.length > 1 || selectedVMHosts.indexOf(virtualTypesval+":*all*") > -1)
		{
			Ext.getCmp('vmselectionspecific').reset();
			Ext.getCmp('vmselectionspecific').setDisabled(true);

			//Ext.getCmp('searchFieldContainer').hide();
			Ext.getCmp('selectorFieldContainer').hide();

			if(!Ext.isEmpty(selected) && selected == 2)
			{
				//Ext.getCmp('searchFieldContainer').hide();
				Ext.getCmp('selectorFieldContainer').hide();
				Ext.getCmp('patternContainer').show();
				this.getVMsPattern();
			}
			else if(!Ext.isEmpty(selected) && selected == 3)
			{
				//Ext.getCmp('searchFieldContainer').hide();
				Ext.getCmp('selectorFieldContainer').hide();
				Ext.getCmp('patternContainer').hide();
			}
		}
		else
		{
			Ext.getCmp('vmselectionspecific').setDisabled(false);
			if(!Ext.isEmpty(selected) && selected == 1)
			{
				Ext.getCmp('patternContainer').hide();
				Ext.getCmp('selectorFieldContainer').show();
				this.getVMs();
			}
			else if(!Ext.isEmpty(selected) && selected == 2)
			{
				//Ext.getCmp('searchFieldContainer').hide();
				Ext.getCmp('selectorFieldContainer').hide();
				Ext.getCmp('patternContainer').show();
				this.getVMsPattern();
			}
			else if(!Ext.isEmpty(selected) && selected == 3)
			{
				//Ext.getCmp('searchFieldContainer').hide();
				Ext.getCmp('selectorFieldContainer').hide();
				Ext.getCmp('patternContainer').hide();
			}
		}
	},
	getVMsPattern : function()
	{
		var obj = Ext.getCmp('virtualServers');
		var selectedVMHosts = obj.getValue();
		if (selectedVMHosts == "-1" || selectedVMHosts.length == 0 )
		{
			return;
		}
		var virtualType = Ext.getCmp('virtualTypes').getValue();
		var selectedComponentType = Ext.getCmp('compType').getValue();

		var params = "&username=" +encodeURIComponent(parent.filterEncode(selectedUserID))+"&compType="+encodeURI(selectedComponentType)+"&vServer="+virtualType;

		var urlStr = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?showAssociatedData=yes&qctr=1&type=vmpattern&"+params;
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			params : {
				vHost : encodeURI(selectedVMHosts),
			},
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				var patternText = Ext.decode(jsonText);
				var pattern='';
				try
				{
					pattern = patternText.pattern;
					Ext.getCmp('patternName').setValue('');
					Ext.getCmp('patternName').setValue(pattern);
				}
				catch (e)
				{
				}
			}
		});

	},
	getVMs : function()
	{
		var obj = Ext.getCmp('virtualServers');
		var selectedVMHosts = obj.getValue();
		//if (selectedVMHosts == "-1" || selectedVMHosts.length == 0)
		//{
		//	return;
		//}
		var me = this;
		var roleName = Ext.getCmp('utype').getValue();
		var selectedComponentType = Ext.getCmp('compType').getValue();
		var associate = Ext.getCmp('associate').getValue();
		var virtualType = Ext.getCmp('virtualTypes').getValue();
		var vmspecificVal = Ext.getCmp('vmselectionspecific').getValue();
		var selectedOrgValue = "";
		if(!isEnterpriseModel)
		{
			var isShareAcrossOU = userElementJSON.shareNickAcrossOU != null && userElementJSON.shareNickAcrossOU != undefined && userElementJSON.shareNickAcrossOU;
			var superOrgName = userElementJSON.superOrgName;

			if(isShareAcrossOU || (!Ext.isEmpty(superOrgName) && superOrgName.toLowerCase() == 'egenterprise'))
			{
				selectedOrgValue = Ext.getCmp("orgType").getValue();
			}
		}
		var params = "associate="+associate+"&username=" +encodeURIComponent(parent.filterEncode(selectedUserID))+ "&qctr=1&compType="+encodeURI(selectedComponentType)+"&assousers="+encodeURIComponent(associatedUserIDs)+"&newusers="+encodeURIComponent(associatedUserIDs)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom="+reqFrom+"&utype="+roleName+"&vServer="+virtualType+"&orgName="+encodeURIComponent(selectedOrgValue);
		if(vmspecificVal)
			params += "&vmspecific=true"
		var urlStr = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?showAssociatedData=yes&qctr=1&selectedTab=3&"+params;
		//me.updateUserElementPage(urlStr);
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			params : {
				vHost : encodeURI(selectedVMHosts),
			},
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userElementJSON = Ext.decode(jsonText);
			}
		});

		var tmpStore = Ext.getCmp('otherHosts');
		tmpStore.getStore().removeAll();

		var toTitle = userElementJSON['toTitle'];
		var fromTitle = userElementJSON['fromTitle'];
		tmpStore.fromField.getComponent(0).setTitle(toTitle);
		tmpStore.toField.getComponent(0).setTitle(fromTitle);

		var associatedItems = userElementJSON['associatedItems'];
		var disAssociatedItems = userElementJSON['disAssociatedItems'];
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}

		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}

		if (!Ext.isEmpty(associatedItems))
		{
			tmpStore.fromField.store.add(associatedItems);
		}
		if (!Ext.isEmpty(disAssociatedItems))
		{
			tmpStore.toField.store.add(disAssociatedItems);
		}


		// commented for explicit search functionality coz search implemented inbuilt in itemselector xtype
		/*if (userElementJSON.showAssociateSearch == true || userElementJSON.showDissociateSearch == true)
		{
			//Ext.getCmp("searchFieldContainer").show();
			if (userElementJSON.showAssociateSearch == true)
			{
				Ext.getCmp('managedSeacrchBox').setDisabled(false);
			}
			else
			{
				Ext.getCmp('managedSeacrchBox').setDisabled(true);
			}

			if (userElementJSON.showDissociateSearch == true)
			{
				Ext.getCmp('unmanagedSeacrchBox').setDisabled(false);
			}
			else
			{
				Ext.getCmp('unmanagedSeacrchBox').setDisabled(true);
			}
		}
		else
		{
			//Ext.getCmp("searchFieldContainer").hide();
		}*/
	},
	getVMServers : function(obj, newValue, oldValue, eOpts)
	{
		var selectedVMHosts = obj.getValue();
		if (selectedVMHosts == "-1" || selectedVMHosts.length == 0)
		{
			return;
		}
		var me = this;
		var roleName = Ext.getCmp('utype').getValue();
		var selectedComponentType = Ext.getCmp('compType').getValue();
		var associate = Ext.getCmp('associate').getValue();
		var virtualType = Ext.getCmp('virtualTypes').getValue();

		var params = "associate="+associate+"&username=" +encodeURIComponent(parent.filterEncode(selectedUserID))+ "&qctr=1&compType="+encodeURI(selectedComponentType)+"&assousers="+encodeURIComponent(associatedUserIDs)+"&newusers="+encodeURIComponent(associatedUserIDs)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom="+reqFrom+"&utype="+roleName+"&vServer="+virtualType;
		var urlStr = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?showAssociatedData=yes&qctr=1&selectedTab=3&"+params;
		//me.updateUserElementPage(urlStr);

		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			params : {
				vHost : selectedVMHosts
			},
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userElementJSON = Ext.decode(jsonText);
			}
		});

		var tmpStore = Ext.getCmp('otherHosts');
		tmpStore.getStore().removeAll();
		var associatedItems = userElementJSON['associatedItems'];
		var disAssociatedItems = userElementJSON['disAssociatedItems'];
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}

		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}

		if (!Ext.isEmpty(associatedItems))
		{
			tmpStore.fromField.store.add(associatedItems);
		}
		if (!Ext.isEmpty(disAssociatedItems))
		{
			tmpStore.toField.store.add(disAssociatedItems);
		}
	},
	callServerType : function(obj,bHit,getSelCBHostVal)
	{
		var me = this;
		updateSettings = false;
		var tmpStore = Ext.getCmp('otherHosts');
		tmpStore.getStore().removeAll();
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		if (obj.getValue() == "-1")
		{
			var virtualServers = Ext.getCmp('virtualServers');
			virtualServers.getStore().removeAll();
			return false;
		}
		//var tmpUserID = Ext.getCmp('uname').getValue();
		var roleName = Ext.getCmp('utype').getValue();
		var selectedComponentType = Ext.getCmp('compType').getValue();
		var associate = Ext.getCmp('associate').getValue();
		var virtualType = obj.getValue();
		var selectedOrgValue = "";
		if(!isEnterpriseModel)
		{
			var isShareAcrossOU = userElementJSON.shareNickAcrossOU != null && userElementJSON.shareNickAcrossOU != undefined && userElementJSON.shareNickAcrossOU;
			var superOrgName = userElementJSON.superOrgName;

			if(isShareAcrossOU || (!Ext.isEmpty(superOrgName) && superOrgName.toLowerCase() == 'egenterprise'))
			{
				selectedOrgValue = Ext.getCmp("orgType").getValue();
			}
		}
		var params = "associate="+associate+"&username=" +encodeURIComponent(parent.filterEncode(selectedUserID))+ "&qctr=1&compType="+encodeURI(selectedComponentType)+"&assousers="+encodeURIComponent(associatedUserIDs)+"&newusers="+encodeURIComponent(associatedUserIDs)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom="+reqFrom+"&utype="+roleName+"&vServer="+virtualType+"&orgName="+encodeURIComponent(selectedOrgValue);
		var urlStr = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?showAssociatedData=yes&qctr=1&selectedTab=3&"+params;
		me.updateUserElementPage(urlStr);
		var tmpData = userElementJSON['virtualServers'];
		var virtualServersObj = Ext.getCmp('virtualServers');
		virtualServersObj.getStore().suspendEvents(true);
		EgChangeUserProfile.compRawData = tmpData;
		virtualServersObj.getStore().loadRawData(tmpData);
		try
		{
			if(!Ext.isEmpty(getSelCBHostVal) && getSelCBHostVal.length > -1)
			{
				virtualServersObj.setValue(getSelCBHostVal);
				me.virtualServersChange("",getSelCBHostVal)
			}
			else if(!Ext.isEmpty(bHit) && bHit == "true")
			{
				virtualServersObj.setValue(tmpData[0].valueField);
				me.virtualServersChange("",tmpData[0].valueField)
			}
			else
			{
				me.virtualServersChange("",[])
			}
		}
		catch (e)
		{
		}
		
		virtualServersObj.getStore().resumeEvents();
	},	
	virtualServersChange : function(ele,newValue,oldValue,eOpts)
	{
		if(newValue != null && newValue.length > 0)
		{
			var virtualServers = Ext.getCmp('virtualServers');
			var selectedVMHosts = virtualServers.getValue();
			var utype = Ext.getCmp('utype').getValue();
			var virtualTypesVal = Ext.getCmp('virtualTypes').getValue();
			var virtualTypesdispVal = Ext.getCmp('virtualTypes').getRawValue();
			var associateELValue = Ext.getCmp('associate').getValue();
			var url = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?getVmSelect=true&showAssociatedData=yes&qctr=1&selectedTab=3&assousers="+encodeURIComponent(associatedUserIDs)+"&username="+encodeURIComponent(parent.filterEncode(selectedUserID))+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom=add&utype="+utype+"&associate="+encodeURIComponent(associateELValue)+"&selHypervisorType="+virtualTypesVal;
			if (associateELValue == "Independent servers")
			{
				var componentType = Ext.getCmp('associate').getValue();
				url = url + "&compType="+encodeURIComponent(componentType)+"&type=allVms&vHost="+encodeURI(selectedVMHosts)+"&selPatternValue="+encodeURIComponent(patternVal);
			}
			Ext.Ajax.request({
				url : url,
				method: 'POST',
				async: false,
				success: function(response)
				{
					var jsonText = response.responseText;
					var usercheckJSON = Ext.decode(jsonText);
					if(usercheckJSON != null)
					{
						var selObj = usercheckJSON.vm_selection_hash;
						var selValue = "";
						if(selObj != undefined && selObj != null)
						{
							for(var t in selObj)
							{
								if(t.indexOf("_vm") > -1)
								{
									selValue =  selObj[t];
								}
							}
						}
						if(selValue != null && selValue.trim().length > 0 && selValue.indexOf("*all*") > -1)
						{
							Ext.getCmp('vmselectionall').setValue(true);
							//Ext.getCmp('searchFieldContainer').hide();
							Ext.getCmp('selectorFieldContainer').hide();
							Ext.getCmp('patternContainer').hide();
						}
						else if(selValue != null && selValue.trim().length > 0 && selValue.indexOf("*pattern") > -1)
						{
							Ext.getCmp('vmselectionpattern').setValue(true);
							Ext.getCmp('patternContainer').show();
							//Ext.getCmp('searchFieldContainer').hide();
							Ext.getCmp('selectorFieldContainer').hide();
							EgChangeUserProfile.app.getController('Main').getVMsPattern();
						}
						else if(selValue != null && selValue.trim().length > 0)
						{
							Ext.getCmp('vmselectionspecific').setValue(true);
							Ext.getCmp('patternContainer').hide();
							//Ext.getCmp('searchFieldContainer').show();
							Ext.getCmp('selectorFieldContainer').show();
							EgChangeUserProfile.app.getController('Main').getVMs();
						}
						else
						{
							Ext.getCmp('vmselectionspecific').setValue(false);
							Ext.getCmp('vmselectionpattern').setValue(false);
							Ext.getCmp('vmselectionall').setValue(false);
							//Ext.getCmp('searchFieldContainer').hide();
							Ext.getCmp('selectorFieldContainer').hide();
							Ext.getCmp('patternContainer').hide();
						}						
					}
				}
			});
		}
		else
		{
			Ext.getCmp('vmselectionspecific').setValue(false);
			Ext.getCmp('vmselectionpattern').setValue(false);
			Ext.getCmp('vmselectionall').setValue(false);
			//Ext.getCmp('searchFieldContainer').hide();
			Ext.getCmp('selectorFieldContainer').hide();
			Ext.getCmp('patternContainer').hide();
		}
	},
	setMeasureInMailMode : function(obj)
	{
		var selectedVal = obj.getValue().msgmode;
		var measure_in_mail_mode = Ext.getCmp('measure_in_mail_mode');
		var tmpData = publicJSON['mailAlertSettings']['measure_in_mail_mode'];
		var selectedMailMode = publicJSON['mailAlertSettings']['selectedMailMode'];
		measure_in_mail_mode.getStore().loadRawData(tmpData);
		if (selectedMailMode != null && selectedMailMode == "DATA")
		{
			measure_in_mail_mode.setValue(selectedMailMode);
		}
		else
		{
			measure_in_mail_mode.setValue(measure_in_mail_mode.getStore().getAt(0).get("valueField"));
		}
		if (selectedVal == "T")
		{
			measure_in_mail_mode.getStore().removeAt(2);
		}
	},
	userValidityChange : function(obj,newValue,oldValue,eOpts)
	{
		var tmptilldateObj = Ext.getCmp('tmptilldate');
		var validity = obj.getValue();
		var userValidity = publicJSON['validtill'];
		if(userValidity == 'Never')
		{
			currCheckExp = true;
		}
		else
		{
			currCheckExp = false;
		}
		if(currCheckExp != validity)
		{
			updateSettings = true;
		}
		if (validity == true)
		{
			//tmptilldateObj.setValue("");
			tmptilldateObj.setDisabled(true);
		}
		else
		{
			tmptilldateObj.setDisabled(false);
		}
	},
	showAvailableUsers : function(obj)
	{
		var showUsers = obj.getValue();
		var userAssociateObj = Ext.getCmp('availusers');
		if (showUsers == true)
		{
			userAssociateObj.show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y);
		}
		else
		{
			userAssociateObj.hide();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y);
		}
	},
	loadMailFilterTab : function()
	{
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		userformcontainerObj.setActiveTab(2);
	},
	submitUserElements : function()
	{
		updateSettings = false;
		var itemObj = Ext.getCmp('otherHosts');
		var tmpList = itemObj.getValue();
		var disAssoElem = "";
		if (tmpList != null)
		{
			tmpList.toString();
		}
		var tmpURL = "EgChangeUserProfile/data/EgusersiteserverspJson.jsp?disAssociateElements="+disAssoElem+"&mode=change&date="+new Date().getTime();
		var me = this;
		me.associateValue('finish');
		var hiddenFieldsKeys = userElementJSON['hiddenFields'];
		//var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		me.setHiddenFieldsToForm();
		var thisForm = this.getElementassociationform().getForm();
		var compType_val = Ext.getCmp('compType').getValue();
		var virtualServers = Ext.getCmp('virtualServers');

		if (!Ext.isEmpty(compType_val) && compType_val == "Virtual_Machine")
		{
			var virtualType = Ext.getCmp('virtualTypes').getValue();

			if (Ext.isEmpty(virtualType) || virtualType == "-1")
			{
				Ext.Msg.alert('Status','Select hypervisor type');
				return;
			}
			
			//virtualServers.setDisabled(true);
			var selectedVMHosts = virtualServers.getValue();
			if (selectedVMHosts == "-1" || selectedVMHosts.length == 0)
			{
				Ext.Msg.alert('Status','Select hypervisor hosts');
				return;
			}
			

			if(selectedVMHosts.length > 1 && selectedVMHosts.indexOf(virtualType+":*all*") > -1)
			{
				Ext.Msg.alert('Error','All Hosts and other hosts cannot be selected simuntaneously!');
				Ext.getCmp('vmselectionspecific').setValue(false);
				Ext.getCmp('vmselectionpattern').setValue(false);
				Ext.getCmp('vmselectionall').setValue(false);
				Ext.getCmp('patternContainer').hide();
				return;
			}

			var _type = Ext.getCmp('vmSelection');
			var selected = _type.lastValue.vmselectiongrp;
			if (Ext.isEmpty(selected) || selected == "-1")
			{
				Ext.Msg.alert('Status','Select VM Association');
				return;
			}
			else if(selected == 2)
			{
				var _patVal = Ext.getCmp('patternName').getValue();
				if (Ext.isEmpty(_patVal) || _patVal == "")
				{
					Ext.Msg.alert('Error','Enter a valid pattern');
					return;
				}
			}
		}

		var myMask = '';
		if (reqFrom != "adduser")
		{
			myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
		}
		if (thisForm.isValid())
		{
			this.getElementassociationform().submit({
				url: tmpURL,
				method: 'POST',
				//standardSubmit: true,
				timeout: 1200,
				success: function(form, action){
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus != undefined && resultObj.requestStatus == "fail")
					{
						myMask.hide();
						Ext.Msg.show(
						{
							title: pageIntnl81,
							msg: resultObj.result.message1 +". "+ resultObj.result.message2,
							buttons: Ext.Msg.OK,
							icon: "iconExclamation"
						});
						var obj = Ext.getCmp('compType');
						me.getServerDetails(obj);
					}
					else
					{
						virtualServers.setDisabled(false);
						if (reqFrom != "adduser")
						{
							myMask.hide();
						}
						Ext.Msg.show({
							title: pageIntnl81,
							msg: pageIntnl98,
							buttons: Ext.Msg.OK,
							width : 400,
							icon: 'iconInformation',
							fn : function(){
								if ((isAlarmEnabled == true || isAlarmEnabled == 'true' )&& (isFilterMailAlertsEnabled == true || isFilterMailAlertsEnabled == 'true'))
								{
									var userformcontainerObj = Ext.getCmp('userformcontainer');
									userformcontainerObj.setActiveTab(3);
								}
								else
								{
									me.showUserAddForm();
								}
							}
						});
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					virtualServers.setDisabled(false);
					if (reqFrom != "adduser")
					{
						myMask.hide();
					}
				}
			});
		}
	},
	submitUserFilterElements : function(obj)
	{
		var me = this;
		obj.setDisabled(true);

		if (mailFilterOption == "Descriptors_Only")
		{
			var tmpURL = "EgChangeUserProfile/data/EgMailAlertIncludeSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(parent.filterEncode(selectedUserID));
			me.setFilterValues("finish");

			var tmpStore = Ext.getCmp('exclude');
			var arrInc1 = new Array();
			var arrExc1 = new Array();
			var fromStore = tmpStore.fromField.store;
			var toStore = tmpStore.toField.store;

			for(var z = 0;z<fromStore.getCount();z++)
			{
				var tmpVal = fromStore.getAt(z).get("valueField");
				arrExc1.push(tmpVal);
			}

			for(var z = 0;z<toStore.getCount();z++)
			{
				var tmpVal = toStore.getAt(z).get("valueField");
				arrInc1.push(tmpVal);
			}
			if (arrExc1.length == 0 && arrInc1.length == 0)
			{
				Ext.Msg.alert(pageIntnl82,"Please select the required parameters to Exclude/Include");
				obj.setDisabled(false);
				return;
			}

			var compNames = Ext.getCmp("compName").getValue();
			//tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			//var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			me.setHiddenFiledsForFilters(hiddenFieldsKeys,compNames);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();

			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						//me.showResultQBox(action.response.responseText);
						Ext.Msg.show({
							title: pageIntnl82,
							msg: pageIntnl99,
							buttons: Ext.Msg.OK,
							width : 400,
							icon: 'iconInformation',
							fn : function(){
								me.showUserAddForm();
							}
						});
						//me.showUserAddForm();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
						//me.showUserAddForm();
					}
				});
			}
		}
		else
		{
			var filterBy = Ext.getCmp('filter').getValue();
			var tmpURL = "EgChangeUserProfile/data/EgMailAlertSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(parent.filterEncode(selectedUserID));
			me.setFilterValues("finish");
			var compNames = "";
			if (filterBy == "filterByDescriptor")
			{
				compNames = Ext.getCmp("compName").getValue();
				//tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
			}
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			//var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			me.setHiddenFiledsForFilters(hiddenFieldsKeys,compNames);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						//me.showResultQBox(action.response.responseText);
						//me.showUserAddForm();
						Ext.Msg.show({
							title: pageIntnl82,
							msg: pageIntnl99,
							buttons: Ext.Msg.OK,
							width : 400,
							icon: 'iconInformation',
							fn : function(){
								me.showUserAddForm();
							}
						});
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
						me.showUserAddForm();
					}
				});
			}
		}
		obj.setDisabled(false);
	},
	assignAndAddMoreFilters : function(obj)
	{
		var me = this;
		obj.setDisabled(true);

		if (mailFilterOption == "Descriptors_Only")
		{
			var filterBy = Ext.getCmp('filter').getValue();
			var tmpURL = "EgChangeUserProfile/data/EgMailAlertIncludeSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(parent.filterEncode(selectedUserID));
			var compNames = Ext.getCmp("compName").getValue();
			tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);

			var tmpStore = Ext.getCmp('exclude');
			var arrInc1 = new Array();
			var arrExc1 = new Array();
			var fromStore = tmpStore.fromField.store;
			var toStore = tmpStore.toField.store;
			for(var z = 0;z<fromStore.getCount();z++)
			{
				var tmpVal = fromStore.getAt(z).get("valueField");
				arrExc1.push(tmpVal);
			}

			for(var z = 0;z<toStore.getCount();z++)
			{
				var tmpVal = toStore.getAt(z).get("valueField");
				arrInc1.push(tmpVal);
			}
			if (arrExc1.length == 0 && arrInc1.length == 0)
			{
				Ext.Msg.alert(pageIntnl82,"Please select the required parameters to Exclude/Include");
				obj.setDisabled(false);
				return;
			}

			me.setFilterValues("addMore");
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			//var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			me.setHiddenFiledsForFilters(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						me.showResultText();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
					}
				});
			}
		}
		else
		{
			var filterBy = Ext.getCmp('filter').getValue();
			var tmpURL = "EgChangeUserProfile/data/EgMailAlertSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(parent.filterEncode(selectedUserID));
			if(filterBy == "-1")
			{
				Ext.MessageBox.alert(pageIntnl82,pageIntnl90);
				obj.setDisabled(false);
				return;
			}

			me.setFilterValues("addMore");
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			//var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var compNames = "";
			if (filterBy == "filterByDescriptor")
			{
				compNames = Ext.getCmp("compName").getValue();
				//tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
			}
			me.setHiddenFiledsForFilters(hiddenFieldsKeys,compNames);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						me.showResultText();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
					}
				});
			}
		}
		obj.setDisabled(false);
	},
	showUserAddForm : function()
	{
		if (reqFrom == "adduser")
		{
			var selectedUserType = Ext.getCmp('utype').getValue();
			window.location.href = "EgAddUser.jsp?qctr=1&usertype="+encodeURIComponent(parent.filterEncode(selectedUserType));
		}
		else
		{
			var userformcontainerObj = Ext.getCmp('userformcontainer');
			userformcontainerObj.setActiveTab(0);
			appCnt.onUserIDChange(Ext.getCmp('uname'));
		}
	},
	onItemSelection : function () {
		btnClk = true;
	},
	assignAndAddMore : function(obj)
	{
		updateSettings = false;
		if(Ext.getCmp('associate').getValue() == "-1")
		{
			Ext.MessageBox.alert(pageIntnl81,pageIntnl89);
			return;
		}
		var tmpURL = "EgChangeUserProfile/data/EgusersiteserverspJson.jsp?mode=change&date="+new Date().getTime();
		var me = this;
		me.associateValue('apply');
		//var hiddenFieldsKeys = userElementJSON['hiddenFields'];
		//var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		me.setHiddenFieldsToForm();
		var compType_val = Ext.getCmp('compType').getValue();
		var virtualServers = Ext.getCmp('virtualServers');


		if (!Ext.isEmpty(compType_val) && compType_val == "Virtual_Machine")
		{
			var virtualType = Ext.getCmp('virtualTypes').getValue();
			if (Ext.isEmpty(virtualType) || virtualType == "-1")
			{
				Ext.Msg.alert('Status','Select hypervisor type');
				return;
			}
			
			//virtualServers.setDisabled(true);
			var selectedVMHosts = virtualServers.getValue();
			if (selectedVMHosts == "-1" || selectedVMHosts.length == 0)
			{
				Ext.Msg.alert('Status','Select hypervisor hosts');
				return;
			}

			if(selectedVMHosts.length > 1 && selectedVMHosts.indexOf(virtualType+":*all*") > -1)
			{
				Ext.Msg.alert('Error','All Hosts and other hosts cannot be selected simuntaneously!');
				Ext.getCmp('vmselectionspecific').setValue(false);
				Ext.getCmp('vmselectionpattern').setValue(false);
				Ext.getCmp('vmselectionall').setValue(false);
				Ext.getCmp('patternContainer').hide();
				return;
			}

			var _type = Ext.getCmp('vmSelection');
			var selected = _type.lastValue.vmselectiongrp;
			if (Ext.isEmpty(selected) || selected == "-1")
			{
				Ext.Msg.alert('Status','Select VM Association');
				return;
			}
			else if(selected == 1)
			{
				if(Ext.getCmp('associate').getValue() == "-1")
				{
					Ext.MessageBox.alert(pageIntnl81,pageIntnl89);
					return;
				}
			}
			else if(selected == 2)
			{
				var _patVal = Ext.getCmp('patternName').getValue();
				if (Ext.isEmpty(_patVal) || _patVal == "")
				{
					Ext.Msg.alert('Error','Enter a valid pattern');
					return;
				}
			}
		}


		var virtualServers = Ext.getCmp('virtualServers');
		//virtualServers.setDisabled(true);
		var thisForm = this.getElementassociationform().getForm();
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		if (thisForm.isValid())
		{
			this.getElementassociationform().submit({
				url: tmpURL,
				timeout: 1200,
				method: 'POST',
				//standardSubmit: true,
				success: function(form, action){
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus != undefined && resultObj.requestStatus == "fail")
					{
						myMask.hide();
						Ext.Msg.show(
						{
							title: pageIntnl81,
							msg: resultObj.result.message1 +". "+ resultObj.result.message2,
							buttons: Ext.Msg.OK,
							icon: "iconExclamation"
						});
						var obj = Ext.getCmp('compType');
						me.getServerDetails(obj);
					}
					else
					{
						virtualServers.setDisabled(false);
						myMask.hide();
						if(btnClk)
						{
							me.showResultText();
							btnClk = false;
						}
						else if(selected == 2 || selected == 3)
						{
							me.showResultText();
						}
						else 
						{
							//Ext.Msg.alert(pageIntnl81,pageIntn201);
							me.showResultText();
						}

						if(selected == 1)
							EgChangeUserProfile.app.getController('Main').getVMs();
						
						var associateStr = Ext.getCmp('associate').getValue();
						var compType = Ext.getCmp('compType').getValue();
						var selectedOrgValue = Ext.getCmp("orgType").getValue();

						if (associateStr == "Zone" || associateStr == "Service" ||
							associateStr == "ServiceGroup" || associateStr == "Segment" || associateStr == "Independent servers")
						{
							var selectedUserType = Ext.getCmp('utype').getValue();
							var url = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?showAssociatedData=yes&qctr=1&selectedTab=3&assousers="+encodeURIComponent(associatedUserIDs)+"&username="+encodeURIComponent(selectedUserID)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom="+reqFrom+"&utype="+selectedUserType+"&associate="+encodeURIComponent(associateStr)+"&orgName="+encodeURIComponent(selectedOrgValue)+"&date="+new Date().getTime();
							appCnt.updateUserElementPage(url);

							var associations = userElementJSON.associations;
							var associateObj = Ext.getCmp('associate');
							associateObj.getStore().loadRawData(associations);
							associateObj.setValue(associateStr);
							if (associateStr == "Independent servers")
							{
								var tmpStoreObj = userElementJSON['componentTypes'];
								if (!Ext.isEmpty(tmpStoreObj))
								{
									Ext.getCmp('compType').getStore().loadRawData(tmpStoreObj);
									var fieldIndex = Ext.getCmp('compType').getStore().findExact("valueField",compType);
									if (fieldIndex == -1)
									{
										Ext.getCmp('compType').setValue(Ext.getCmp('compType').getStore().getAt(0).get("valueField"));
									}
								}
								else
								{
									Ext.getCmp('compType').hide();
									associateObj.setValue(associateObj.getStore().getAt(0).get("valueField"));
									var tmpStore = Ext.getCmp('otherHosts');
									tmpStore.getStore().removeAll();
									if(tmpStore.fromField.store.getCount() > 0)
									{
										tmpStore.fromField.store.removeAll();
									}
									if(tmpStore.toField.store.getCount() > 0)
									{
										tmpStore.toField.store.removeAll();
									}
								}
							}
						}
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					virtualServers.setDisabled(false);
					myMask.hide();
				}
			});
		}
	},
	showResultText : function()
	{
		if (Ext.getCmp('resultCt') == null || Ext.getCmp('resultCt') == undefined)
		{
			var panelAbsolute = Ext.create('Ext.container.Container',{
				floatable : true,
				floating:true,
				id : 'resultCt',
				width : 380,
				items : [
					{
						xtype : 'component',
						padding :0,
						margin:5,
						cls : 'popupAlertUser',
						html  : '<table border="0" width="100%"><tr><td><div class="iconRight" style="margin:4px;float:left"></div><div style="margin:4px;float:left">Changes have been updated successfully.</div><div class="iconClosePopup" style="float:right;margin:4px"></div><td></tr></table>',
					}
				]
			});
			var VWidth = Ext.Element.getViewportWidth();
			panelAbsolute.showAt(VWidth-410,85);
			Ext.select('.iconClosePopup').on('click',function(){
				panelAbsolute.destroy();
			},this);

			var task = new Ext.util.DelayedTask(function(){
				panelAbsolute.destroy();
			});
			task.delay(2000);
		}
	},
	showEmptyDataText : function()
	{
		if (Ext.getCmp('resultCt') == null || Ext.getCmp('resultCt') == undefined)
		{
			var panelAbsolute = Ext.create('Ext.container.Container',{
				floatable : true,
				floating:true,
				id : 'resultCt',
				width : 380,
				items : [
					{
						xtype : 'component',
						padding :0,
						margin:5,
						cls : 'popupAlertUser',
						html  : '<table border="0" width="100%"><tr><td><div class="iconInfo" style="margin:2px 4px 0px 4px;float:left"></div><div style="margin:4px;float:left">No items found for the selected criteria.</div><div class="iconClosePopup" style="float:right;margin:4px"></div><td></tr></table>',
					}
				]
			});
			var VWidth = Ext.Element.getViewportWidth();
			panelAbsolute.showAt(VWidth-410,85);
			Ext.select('.iconClosePopup').on('click',function(){
				panelAbsolute.destroy();
			},this);

			var task = new Ext.util.DelayedTask(function(){
				panelAbsolute.destroy();
			});
			task.delay(2000);
		}
	},
	setFilterValues : function(cntValue)
	{
		var hiddenFieldsKeys = userMailJSON['hiddenFields'];
		var hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer');
		var tmpStore = Ext.getCmp('exclude');
		var arrInc = new Array();
		var arrExc = new Array();
		var fromStore = tmpStore.fromField.store;
		var toStore = tmpStore.toField.store;
		for(var z = 0;z<fromStore.getCount();z++)
		{
			var tmpVal = fromStore.getAt(z).get("valueField");
			arrExc.push(tmpVal);
		}

		for(var z = 0;z<toStore.getCount();z++)
		{
			var tmpVal = toStore.getAt(z).get("valueField");
			arrInc.push(tmpVal);
		}
		if(userMailJSON['excludedBoxHostVal'] && userMailJSON['excludedBoxHostVal'] != undefined)
		{
			var valueHost =userMailJSON['excludedBoxHostVal'];
			if(valueHost !=null && valueHost != "")
			{
				arrExc[arrExc.length] = valueHost;
			}
		}
		if (mailFilterOption == "Descriptors_Only")
		{
			var includedBoxVal = {
				xtype : 'hiddenfield',
				name : 'excludedBoxVal',
				value : arrInc
			}
			var excludedBoxVal = {
				xtype : 'hiddenfield',
				name : 'includedBoxVal',
				value : arrExc
			}
			var tmpActionObj = {
				xtype : 'hiddenfield',
				name : 'control',
				value : cntValue
			}
		}
		else
		{
			var includedBoxVal = {
				xtype : 'hiddenfield',
				name : 'includedBoxVal',
				value : arrInc
			}
			var excludedBoxVal = {
				xtype : 'hiddenfield',
				name : 'excludedBoxVal',
				value : arrExc
			}
			var tmpActionObj = {
				xtype : 'hiddenfield',
				name : 'control',
				value : cntValue
			}
		}
		hiddenFieldsContainerObj.removeAll();
		hiddenFieldsContainerObj.add(includedBoxVal);
		hiddenFieldsContainerObj.add(excludedBoxVal);
		hiddenFieldsContainerObj.add(tmpActionObj);
		//if (!Ext.isEmpty(hiddenFieldsKeys.previousExcVal))
		//{
			var tmpPrevExcValObj = {
				xtype : 'hiddenfield',
				name : 'previousExcVal',
				value : hiddenFieldsKeys.previousExcVal
			}
			hiddenFieldsContainerObj.add(tmpPrevExcValObj);
		//}
	},
	setHiddenFiledsForFilters: function(hiddenFields,compNames)
	{
		var hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer');
		for (key in hiddenFields)
		{
			if (key == "vsTypes")
			{
				continue;
			}
			var keyValue  = hiddenFields[key];
			hiddenFieldsContainerObj.add({xtype: 'hiddenfield',name : key,value : keyValue});
		}
		hiddenFieldsContainerObj.add({xtype: 'hiddenfield',name : 'compNames',value : compNames});
	},
	associateValue : function(actionMethod)
	{
		var hiddenFieldsKeys = userElementJSON['hiddenFields'];
		var elementassociationformObj = Ext.getCmp('elementassociationform');
		var elementsHiddenContainerObj = Ext.getCmp('elementsHiddenContainer');
		elementsHiddenContainerObj.removeAll();
		var associateObj = Ext.getCmp('associate');
		var tmpStore = Ext.getCmp('otherHosts');
		var marray = new Array();
		var fromStore = tmpStore.fromField.store;
		for(var z = 0;z<fromStore.getCount();z++)
		{
			var tmpVal = fromStore.getAt(z).get("valueField");
			marray.push(tmpVal);
		}
		elementsHiddenContainerObj.add({xtype: 'hiddenfield',name : 'majorType',value : associateObj.getValue()});
		var chosenHosts = {
			xtype : 'hiddenfield',
			name : 'chosenHosts',
			value : marray
		}
		var tmpActionObj = {
			xtype : 'hiddenfield',
			name : 'action',
			value : actionMethod
		}
		var tmpFinalOperateObj = {
			xtype : 'hiddenfield',
			name : 'finalOperation',
			value : 'added'
		}

		if (!Ext.isEmpty(hiddenFieldsKeys.previousSelectedValue))
		{
			var tmpHiddenObj = {
				xtype : 'hiddenfield',
				name : 'previousSelectedValue',
				value : hiddenFieldsKeys.previousSelectedValue
			}
			elementsHiddenContainerObj.add(tmpHiddenObj);
		}
		//if (!Ext.isEmpty(hiddenFieldsKeys.previousVMs))
		//{
			var tmpHiddenObj = {
				xtype : 'hiddenfield',
				name : 'previousVMs',
				value : hiddenFieldsKeys.previousVMs
			}
			elementsHiddenContainerObj.add(tmpHiddenObj);
		//}
		//if (!Ext.isEmpty(hiddenFieldsKeys.previouscomponents))
		//{
			var tmpHiddenObj = {
				xtype : 'hiddenfield',
				name : 'previouscomponents',
				value : hiddenFieldsKeys.previouscomponents
			}
			elementsHiddenContainerObj.add(tmpHiddenObj);
		//}
		//if (!Ext.isEmpty(hiddenFieldsKeys.previoussegments))
		//{
			var tmpHiddenObj = {
				xtype : 'hiddenfield',
				name : 'previoussegments',
				value : hiddenFieldsKeys.previoussegments
			}
			elementsHiddenContainerObj.add(tmpHiddenObj);
		//}
		//if (!Ext.isEmpty(hiddenFieldsKeys.previousservicegroup))
		//{
			var tmpHiddenObj = {
				xtype : 'hiddenfield',
				name : 'previousservicegroup',
				value : hiddenFieldsKeys.previousservicegroup
			}
			elementsHiddenContainerObj.add(tmpHiddenObj);
		//}
		//if (!Ext.isEmpty(hiddenFieldsKeys.previousservices))
		//{
			var tmpHiddenObj = {
				xtype : 'hiddenfield',
				name : 'previousservices',
				value : hiddenFieldsKeys.previousservices
			}
			elementsHiddenContainerObj.add(tmpHiddenObj);
		//}
		//if (!Ext.isEmpty(hiddenFieldsKeys.previouszones))
		//{
			var tmpHiddenObj = {
				xtype : 'hiddenfield',
				name : 'previouszones',
				value : hiddenFieldsKeys.previouszones
			}
			elementsHiddenContainerObj.add(tmpHiddenObj);
		//}
		var tmpHiddenObj = {
			xtype : 'hiddenfield',
			name : 'previousextagts',
			value : hiddenFieldsKeys.previousextagts
		}
		elementsHiddenContainerObj.add(tmpHiddenObj);
		var tmpHiddenObj = {
			xtype : 'hiddenfield',
			name : 'previousremagts',
			value : hiddenFieldsKeys.previousremagts
		}
		elementsHiddenContainerObj.add(tmpHiddenObj);
		elementsHiddenContainerObj.add(chosenHosts);
		elementsHiddenContainerObj.add(tmpActionObj);
		elementsHiddenContainerObj.add(tmpFinalOperateObj);
		var majorType = associateObj.getValue();
		if (!(majorType=="Segment") || (majorType == "Service"))
		{
			if (majorType == "Zone")
			{
				var dbArray = new Array();
				for(var i=0; i<fromStore.getCount();i++)
				{
					var tmpVal = fromStore.getAt(i).get("valueField");
					dbArray[i] = ",Zone:"+tmpVal;
				}
				var permanentAssociation = {
					xtype : 'hiddenfield',
					name : 'permanentAssociation',
					value : dbArray
				}
				elementsHiddenContainerObj.add(permanentAssociation);
			}
			else
			{
				var permanentAssociation = {
					xtype : 'hiddenfield',
					name : 'permanentAssociation',
					value : Ext.getCmp('compType').getValue()
				}
				elementsHiddenContainerObj.add(permanentAssociation);
			}
		}
	},
	getServerDetails : function(obj)
	{
		try
		{
			var patternCon = Ext.getCmp('patternContainer');
			if(!Ext.isEmpty(patternCon) && !patternCon.hidden)
				patternCon.hide();
		}
		catch (e)
		{
		}
		//var tmpUserID = Ext.getCmp('uname').getValue();
		var utype = Ext.getCmp('utype').getValue();
		var me = this;
		updateSettings = false;
		var selectedComponent = obj.getValue();
		var associate = Ext.getCmp('associate').getValue();
		var selectedOrgValue = "";
		if(!isEnterpriseModel)
		{
			var isShareAcrossOU = userElementJSON.shareNickAcrossOU != null && userElementJSON.shareNickAcrossOU != undefined && userElementJSON.shareNickAcrossOU;
			var superOrgName = userElementJSON.superOrgName;

			if(isShareAcrossOU || (!Ext.isEmpty(superOrgName) && superOrgName.toLowerCase() == 'egenterprise'))
			{
				selectedOrgValue = Ext.getCmp("orgType").getValue();
			}
		}
		var url = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?getVmSelect=true&showAssociatedData=yes&qctr=1&selectedTab=3&assousers="+encodeURIComponent(associatedUserIDs)+"&orgName="+encodeURIComponent(selectedOrgValue)+"&username="+encodeURIComponent(parent.filterEncode(selectedUserID))+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom="+reqFrom+"&utype="+utype+"&associate="+encodeURIComponent(associate)+"&compType="+encodeURIComponent(selectedComponent)+"&date="+new Date().getTime();
		me.updateUserElementPage(url);
		var tmpStore = Ext.getCmp('otherHosts');

		var toTitle = userElementJSON['toTitle'];
		var fromTitle = userElementJSON['fromTitle'];
		tmpStore.fromField.getComponent(0).setTitle(toTitle);
		tmpStore.toField.getComponent(0).setTitle(fromTitle);

		var associatedItems = userElementJSON['associatedItems'];
		var disAssociatedItems = userElementJSON['disAssociatedItems'];
		tmpStore.getStore().removeAll();
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		if (!Ext.isEmpty(associatedItems))
		{
			tmpStore.fromField.store.add(associatedItems);
		}
		if (!Ext.isEmpty(disAssociatedItems))
		{
			tmpStore.toField.store.add(disAssociatedItems);
		}

		if (userElementJSON.isAutoAssociated == true)
		{
			Ext.getCmp('compAssociation').setValue(true);
		}
		else
		{
			Ext.getCmp('compAssociation').setValue(false);
		}

		if (userElementJSON.isVMType == true)
		{
			var virtualTypesObj = Ext.getCmp('virtualTypes');
			var virtualServersContainer = Ext.getCmp('virtualServersContainer');
			virtualTypesObj.show();
			virtualServersContainer.show();
			virtualTypesObj.setFieldLabel(userElementJSON.vmTitle1);
			Ext.getCmp('vmTypeLabel').setText(userElementJSON.vmTitle2);
			virtualTypesObj.getStore().loadRawData(userElementJSON.virtualTypes);
			//virtualTypesObj.setValue("-1");
			Ext.getCmp('compAssociation').boxLabelEl.update(userElementJSON.autoVMs);
			Ext.getCmp('vmSelection').show();
			Ext.getCmp('selectorFieldContainer').hide();
			var valField = userElementJSON.virtualTypes[0].valueField;
			var getSelCheckBox = userElementJSON.vm_selection_hash;
			var getSelCheckBoxType = "";
			var getSelCheckBoxHost = "";
			var getSelCheckBoxAsc = "";
			for(var t in getSelCheckBox)
			{
				if(t.indexOf("_vm") > -1)
				{
					getSelCheckBoxAsc = getSelCheckBox[t];
				}
				else
				{
					getSelCheckBoxType = t;
					getSelCheckBoxHost = getSelCheckBox[t];
				}
			}
			if(getSelCheckBoxType != undefined && getSelCheckBoxType != null && getSelCheckBoxType.trim().length > 0)
			{
				virtualTypesObj.setValue(getSelCheckBoxType);
				this.callServerType(virtualTypesObj,"true",getSelCheckBoxHost);
			}				
			else if(valField != undefined && valField != null && valField.trim().length > 0)
			{
				virtualTypesObj.setValue(valField);
				this.callServerType(virtualTypesObj,"true");
			}				
			else
			{
				virtualTypesObj.setValue("-1");
			}
		}
		else
		{
			Ext.getCmp('compAssociation').boxLabelEl.update(userElementJSON.autoComp);
			Ext.getCmp('virtualTypes').hide();
			Ext.getCmp('virtualServersContainer').hide();
			Ext.getCmp('vmSelection').hide();
			Ext.getCmp('selectorFieldContainer').show();
		}
		

		// commented for explicit search functionality coz search implemented inbuilt in itemselector xtype
		/*if (userElementJSON.showAssociateSearch == true || userElementJSON.showDissociateSearch == true)
		{
			//Ext.getCmp("searchFieldContainer").show();
			if (userElementJSON.showAssociateSearch == true)
			{
				Ext.getCmp('managedSeacrchBox').setDisabled(false);
			}
			else
			{
				Ext.getCmp('managedSeacrchBox').setDisabled(true);
			}

			if (userElementJSON.showDissociateSearch == true)
			{
				Ext.getCmp('unmanagedSeacrchBox').setDisabled(false);
			}
			else
			{
				Ext.getCmp('unmanagedSeacrchBox').setDisabled(true);
			}
		}
		else
		{
			//Ext.getCmp("searchFieldContainer").hide();
		}*/
	},
	associateServerType : function(obj)
	{
		if (obj.getValue() == true)
		{
			var tmpStore = Ext.getCmp('otherHosts');
			var toStore = tmpStore.toField.store;
			var fromStore = tmpStore.fromField.store;
			for(var z = 0;z<toStore.getCount();z++)
			{
				var tmpVal = toStore.getAt(z);
				tmpStore.fromField.store.add(tmpVal);
			}
			tmpStore.toField.store.removeAll();
		}
	},
	organizationOnChange : function()
	{
		var me = this;
		var selectedOrgValue = Ext.getCmp("orgType").getValue();
		var utype = Ext.getCmp('utype').getValue();
		var selectedValue = Ext.getCmp("associate").getValue();
		updateSettings = false;
		var url = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?qctr=1&selectedTab=3&assousers="+encodeURIComponent(associatedUserIDs)+"&orgName="+encodeURIComponent(selectedOrgValue)+"&username="+encodeURIComponent(parent.filterEncode(selectedUserID))+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom="+reqFrom+"&utype="+utype+"&associate="+encodeURIComponent(selectedValue)+"&date="+new Date().getTime();
		me.updateUserElementPage(url);
		var associations = userElementJSON.associations;
		var associateObj = Ext.getCmp('associate');
		associateObj.getStore().loadRawData(associations);
		associateObj.setValue("-1");
		var tmpStore = Ext.getCmp('otherHosts');
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		//this.updateResultPanel();
		this.setLangEntries(userElementJSON.langEntries);
		Ext.getCmp('compType').hide();
		Ext.getCmp('compAssociation').hide();
		Ext.getCmp('virtualTypes').hide();
		Ext.getCmp('virtualServersContainer').hide();
		Ext.getCmp('vmSelection').hide();
		Ext.getCmp('patternContainer').hide();
		//Ext.getCmp('selectorFieldContainer').show();
		//me.associateOnChange(Ext.getCmp("associate"));
	},
	associateOnChange : function(obj)
	{
	  	try
  		{
  			var patternCon = Ext.getCmp('patternContainer');
  			if(!Ext.isEmpty(patternCon) && !patternCon.hidden)
  				patternCon.hide();
  		}
  		catch (e)
  		{
  		}

  		var me = this;
		var selectedOrgValue = "";

		if(!isEnterpriseModel)
		{
			var isShareAcrossOU = userElementJSON.shareNickAcrossOU != null && userElementJSON.shareNickAcrossOU != undefined && userElementJSON.shareNickAcrossOU;
			var superOrgName = userElementJSON.superOrgName;

			if(isShareAcrossOU || (!Ext.isEmpty(superOrgName) && superOrgName.toLowerCase() == 'egenterprise'))
			{
				selectedOrgValue = Ext.getCmp("orgType").getValue();
				if(selectedOrgValue != null && selectedOrgValue != undefined && selectedOrgValue.length>0)
				{
					if(selectedOrgValue == -1)
					{
						Ext.Msg.alert(pageTitle,userIDValidationMsg74);
						Ext.getCmp("orgType").focus(true);
						return;
					}
				}
			}
		}
		var url = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?qctr=1&selectedTab=3&assousers="+encodeURIComponent(associatedUserIDs)+"&orgName="+encodeURIComponent(selectedOrgValue)+"&username="+encodeURIComponent(parent.filterEncode(selectedUserID))+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom="+reqFrom+"&utype="+utype+"&associate="+encodeURIComponent(selectedValue)+"&date="+new Date().getTime();
		updateSettings = false;
		var selectedValue = obj.getValue();
		Ext.getCmp('virtualTypes').hide();
		Ext.getCmp('virtualServersContainer').hide();
		Ext.getCmp('vmSelection').hide();
		if (selectedValue == "-1")
		{
			var tmpStore = Ext.getCmp('otherHosts');
			Ext.getCmp('compType').hide();
			Ext.getCmp('compAssociation').hide();
			tmpStore.getStore().removeAll();
			if(tmpStore.fromField.store.getCount() > 0)
			{
				tmpStore.fromField.store.removeAll();
			}
			if(tmpStore.toField.store.getCount() > 0)
			{
				tmpStore.toField.store.removeAll();
			}
		}
		else
		{
			var utype = Ext.getCmp('utype').getValue();
			var url = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?showAssociatedData=yes&qctr=1&selectedTab=3&assousers="+encodeURIComponent(associatedUserIDs)+"&orgName="+encodeURIComponent(selectedOrgValue)+"&username="+encodeURIComponent(selectedUserID)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom="+reqFrom+"&utype="+utype+"&associate="+encodeURIComponent(selectedValue)+"&date="+new Date().getTime();
			me.updateUserElementPage(url);
			var associatedItems = userElementJSON['associatedItems'];
			var disAssociatedItems = userElementJSON['disAssociatedItems'];
			var toTitle = userElementJSON['toTitle'];
			var fromTitle = userElementJSON['fromTitle'];
			var tmpStore = Ext.getCmp('otherHosts');
			tmpStore.fromField.getComponent(0).setTitle(toTitle);
			tmpStore.toField.getComponent(0).setTitle(fromTitle);
			if (selectedValue == "Independent servers")
			{
				var tmpStoreObj = Ext.getCmp('compType');
				var compAssociation = Ext.getCmp('compAssociation');
				tmpStoreObj.getStore().loadRawData(userElementJSON['componentTypes']);
				tmpStoreObj.setValue(tmpStoreObj.getStore().getAt(0).get("valueField"));
				tmpStoreObj.show();
				//compAssociation.show();
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(associatedItems))
				{
					tmpStore.fromField.store.add(associatedItems);
				}
				if (!Ext.isEmpty(disAssociatedItems))
				{
					tmpStore.toField.store.add(disAssociatedItems);
				}

				if (userElementJSON.isAutoAssociated == true)
				{
					Ext.getCmp('compAssociation').setValue(true);
				}
				else
				{
					Ext.getCmp('compAssociation').setValue(false);
				}

				var isVMType = userElementJSON['isVMType'];
				if (isVMType == true)
				{
					var vmTitle1 = userElementJSON['vmTitle1'];
					var vmTitle2 = userElementJSON['vmTitle2'];
					Ext.getCmp('virtualTypes').setFieldLabel(vmTitle1);
					Ext.getCmp('vmTypeLabel').setText(vmTitle2);
					Ext.getCmp('virtualTypes').show();
					Ext.getCmp('virtualServersContainer').show();
					var virtualTypes = userElementJSON['virtualTypes'];
					Ext.getCmp('virtualTypes').getStore().loadRawData(virtualTypes);

					Ext.getCmp('vmSelection').show();
				}
				me.getServerDetails(tmpStoreObj);
			}
			else if (selectedValue == "Segment")
			{
				Ext.getCmp('compType').hide();
				Ext.getCmp('compAssociation').hide();
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(associatedItems))
				{
					//tmpStore.getStore().loadRawData(associatedItems);
					tmpStore.fromField.store.add(associatedItems);
				}
				if (!Ext.isEmpty(disAssociatedItems))
				{
					tmpStore.toField.store.add(disAssociatedItems);
				}

				if (Ext.isEmpty(associatedItems) && Ext.isEmpty(disAssociatedItems))
				{
					me.showEmptyDataText();
				}

				Ext.getCmp('selectorFieldContainer').show();
			}
			else if (selectedValue == "Zone")
			{
				Ext.getCmp('compType').hide();
				Ext.getCmp('compAssociation').hide();
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(associatedItems))
				{
					//tmpStore.getStore().loadRawData(associatedItems);
					tmpStore.fromField.store.add(associatedItems);
				}
				if (!Ext.isEmpty(disAssociatedItems))
				{
					tmpStore.toField.store.add(disAssociatedItems);
				}

				if (Ext.isEmpty(associatedItems) && Ext.isEmpty(disAssociatedItems))
				{
					me.showEmptyDataText();
				}

				Ext.getCmp('selectorFieldContainer').show();
			}
			else if (selectedValue == "Service")
			{
				Ext.getCmp('compType').hide();
				Ext.getCmp('compAssociation').hide();
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(associatedItems))
				{
					//tmpStore.getStore().loadRawData(associatedItems);
					tmpStore.fromField.store.add(associatedItems);
				}
				if (!Ext.isEmpty(disAssociatedItems))
				{
					tmpStore.toField.store.add(disAssociatedItems);
				}

				if (Ext.isEmpty(associatedItems) && Ext.isEmpty(disAssociatedItems))
				{
					me.showEmptyDataText();
				}

				Ext.getCmp('selectorFieldContainer').show();
			}
			else if (selectedValue == "ServiceGroup")
			{
				Ext.getCmp('compType').hide();
				Ext.getCmp('compAssociation').hide();
				tmpStore.getStore().removeAll();
				//alert(tmpStore.getStore().getCount())
				//alert("1-->"+tmpStore.fromField.store.getCount())
				//alert("2-->"+tmpStore.toField.store.getCount())
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(associatedItems))
				{
					//tmpStore.getStore().loadRawData(associatedItems);
					tmpStore.fromField.store.add(associatedItems);
				}
				if (!Ext.isEmpty(disAssociatedItems))
				{
					tmpStore.toField.store.add(disAssociatedItems);
				}
				
				if (Ext.isEmpty(associatedItems) && Ext.isEmpty(disAssociatedItems))
				{
					me.showEmptyDataText();
				}

				Ext.getCmp('selectorFieldContainer').show();
			}
			else if (selectedValue == "ExternalAgent" || selectedValue == "RemoteAgent")
			{
				Ext.getCmp('compType').hide();
				Ext.getCmp('compAssociation').hide();
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(associatedItems))
				{
					//tmpStore.getStore().loadRawData(associatedItems);
					tmpStore.fromField.store.add(associatedItems);
				}
				if (!Ext.isEmpty(disAssociatedItems))
				{
					tmpStore.toField.store.add(disAssociatedItems);
				}

				if (Ext.isEmpty(associatedItems) && Ext.isEmpty(disAssociatedItems))
				{
					me.showEmptyDataText();
				}

				Ext.getCmp('selectorFieldContainer').show();
			}

		}
	},
	uploadUsrImage : function()
	{
		var me = this;
		var fileExt = 'gif/jpg/jpeg/png';
		var isUpload=false;
		var fileObj = Ext.getCmp('FILE_0');
		var fileName = fileObj.getValue();
		var fileExtension = fileName.substring((fileName.lastIndexOf('.'))+1,fileName.length);

		if(!validateSingleByte(fileObj.getValue()))
		{
			Ext.Msg.alert(pageTitle,userIDValidationMsg62);
			return false;
		}

		//if ((fileObj.getValue().toLowerCase().indexOf(fileExt)) == -1)
		if (fileExtension.toLowerCase() != 'gif' && fileExtension.toLowerCase() != 'jpg' && fileExtension.toLowerCase() != 'jpeg' && fileExtension.toLowerCase() != 'png')
		{
			Ext.Msg.alert(pageTitle,userIDValidationMsg63+": '" +fileExt+ "'" );
			return false;
		}

		var nameStr = "FILE_0_dstFile";
		var valueStr = filePath;
		valueStr = valueStr.replace(".gif","."+fileExtension);

		var fileuploadObj = Ext.getCmp('hiddenFieldsContainer');
		fileuploadObj.removeAll();
		var tmpHiddenElement = {
			xtype: 'hiddenfield',
			name : 'FILE_0_dstFile',
			value : valueStr
		}
		fileuploadObj.add(tmpHiddenElement);
		var me = this;
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Uploading...'});
		myMask.show();
		var userForm = this.getFileupload().getForm();
		fileUploadURI = fileUploadURI.replace("fileExt=gif","fileExt="+fileExtension);
		if (userForm.isValid())
		{
			this.getFileupload().submit({
				url: fileUploadURI,
				method: 'POST',
				success: function(form, action){
					Ext.Msg.show({
						title: pageTitle,
						msg: pageIntnl100 + ".",
						buttons: Ext.Msg.OK,
						width : 400,
						icon: 'iconInformation'
					});
					myMask.hide();
					me.updateImageStatus();
					Ext.getCmp('fileUpLoader').destroy();
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					Ext.getCmp('fileUpLoader').destroy();
				}
			});
		}
	},
	updateImageStatus : function()
	{
		var fileUpLoaderEx = Ext.getCmp('fileUpLoader');
		if (fileUpLoaderEx.getCurrentUploaderInfo() == "login")
		{
			isLoginImgUpdated = true;
		}
		else if (fileUpLoaderEx.getCurrentUploaderInfo() == "monitor")
		{
			isAdminMonImgUpdated = true;
		}
		else if (fileUpLoaderEx.getCurrentUploaderInfo() == "reporter")
		{
			isRepImgUpdated = true;
		}
		else if (fileUpLoaderEx.getCurrentUploaderInfo() == "config")
		{
			isConfigImgUpdated = true;
		}
	},
	monitorLogoController : function(obj)
	{
		var selectedOption = obj.getValue();
		var logoObj = Ext.getCmp('monitorLogoIMG');
		if (selectedOption == "show")
		{
			logoObj.show();
		}
		else
		{
			logoObj.hide();
		}
	},
	loginLogoController : function(obj)
	{
		var selectedOption = obj.getValue();
		var logoObj = Ext.getCmp('loginLogoIMG');
		if (selectedOption == "show")
		{
			logoObj.show();
		}
		else
		{
			logoObj.hide();
		}
	},
	repLogoController : function(obj)
	{
		var selectedOption = obj.getValue();
		var logoObj = Ext.getCmp('reporterLogoIMG');
		if (selectedOption == "show")
		{
			logoObj.show();
		}
		else
		{
			logoObj.hide();
		}
	},
	configLogoController : function(obj)
	{
		var selectedOption = obj.getValue();
		var logoObj = Ext.getCmp('configLogoIMG');
		if (selectedOption == "show")
		{
			logoObj.show();
		}
		else
		{
			logoObj.hide();
		}
	},
	loadMailShiftAlerts : function(obj)
	{
		var regExp1=/^(\+\d\d)?[0-9]+$/g;

		var selectedOption =  obj.getValue().mailshift;
		if (selectedOption == 'yes')
		{
			var isMailValid = true;
			var tmpVal1 = Ext.getCmp('tomailid').getValue();
			var tmpVal2 = Ext.getCmp('ccmailid').getValue();
			var tmpVal3 = Ext.getCmp('bccmailid').getValue();
			var tmpVal4 = Ext.getCmp('escmailid').getValue();

			var toMailResult=validateEmail(tmpVal1);
			var ccMailResult=validateEmail(tmpVal2);
			var bccMailResult=validateEmail(tmpVal3);
			var escMailResult=validateEmail(tmpVal4);

			if(tmpVal1 =="" && tmpVal3 =="" && tmpVal2 =="")
			{
				isMailValid = false;
			}
			
			if((tmpVal1 !="" && toMailResult==false) || (tmpVal3 != "" && bccMailResult==false) || (tmpVal2 != "" && ccMailResult==false))
			{
				var flag1 = validateMailID(tmpVal1);
				var flag2 = validateMailID(tmpVal3);
				var flag3 = validateMailID(tmpVal2);

				if(!flag1 && !flag2 && !flag3)
				{
					isMailValid = false;
				}
			}
			if(!isMailValid)
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg23);
				Ext.getCmp('emailAlert_1').setValue(true);
				return false;
			}
			Ext.getCmp('emailMailAlert').show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
		}
		else
		{
			Ext.getCmp('emailMailAlert').hide();
			//if (!Ext.getCmp('emailMailAlert').isHidden())
			//{
				Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
			//}
		}
	},
	loadCommandShiftAlerts : function(obj)
	{
		var selectedOption = obj.getValue().Execshift;
		if (selectedOption == 'yes')
		{
			var toCmd = Ext.getCmp('customScript');
			if (toCmd.getValue() == null || toCmd.getValue() == "")
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg40);
				Ext.getCmp('shiftAlert_1').setValue(true);
				return false;
			}
			else if(!checkspecial(toCmd.getValue(),"@*+=[]|;\"\'<>?~`"))
			{
				toCmd.focus(true);
				Ext.getCmp('shiftAlert_1').setValue(true);
				return false;
			}
			Ext.getCmp('commandAlert').show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
		}
		else
		{
			Ext.getCmp('commandAlert').hide();
			//if (!Ext.getCmp('commandAlert').isHidden())
			//{
				Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
			//}
		}
	},
	loadSMSShiftAlerts : function(obj)
	{
		var regExp1=/^(\+\d\d)?[0-9]+$/g;

		var selectedOption = obj.getValue().smsshift;
		if (selectedOption == 'yes')
		{
			var isValidMobileNo = true;
			var tmpVal1 = Ext.getCmp('tomailid').getValue();
			var tmpVal2 = Ext.getCmp('ccmailid').getValue();
			var tmpVal3 = Ext.getCmp('bccmailid').getValue();
			var tmpVal4 = Ext.getCmp('escmailid').getValue();

			var toMobResult=(tmpVal1).match(regExp1);
			var ccMobResult=(tmpVal2).match(regExp1);
			var bccMobResult=(tmpVal3).match(regExp1);
			var escMobResult=(tmpVal4).match(regExp1);

			if(tmpVal1 =="" && tmpVal3 =="" && tmpVal2 =="")
			{
				isValidMobileNo = false;
			}
			
			if((tmpVal1 !="" && toMobResult!=tmpVal1) || (tmpVal3 != "" && bccMobResult!=tmpVal3) || (tmpVal2 != "" && ccMobResult!=tmpVal2))
			{
				var flag1 = validateMobileNo(tmpVal1);
				var flag2 = validateMobileNo(tmpVal3);
				var flag3 = validateMobileNo(tmpVal2);

				if(!flag1 && !flag2 && !flag3)
				{
					isValidMobileNo = false;
				}
			}
			if(!isValidMobileNo)
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg26);
				Ext.getCmp('smsAlert_1').setValue(true);
				return false;
			}
			Ext.getCmp('smsAlert').show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
		}
		else
		{
			Ext.getCmp('smsAlert').hide();
			//if (!Ext.getCmp('smsAlert').isHidden())
			//{
				Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
			//}
		}
	},
	loadESCShiftAlerts : function(obj)
	{
		var regExp1=/^(\+\d\d)?[0-9]+$/g;
		var reg3 = /(((([\+]?([0-9]){4,15})|([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])+)\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z])|((\+\d\d)?[0-9]+))/g

		var selectedOption = obj.getValue().escshift;
		if (selectedOption == 'yes')
		{
			var escMail = Ext.getCmp('escmailid').getValue();
			var escshiftNo = Ext.getCmp("escshiftNo");
			var escMailResult=validateEmail(escMail);
			var escMobResult=(escMail).match(regExp1);
			var escResult=(escMail).match(reg3);

			if (escMail != null && escMail == '' && !checkmultiplemailid(escMail))
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg28);
				Ext.getCmp('escAlert_1').setValue(true);
				return false;
			}
			
			if ((escMail != "") && (escMailResult==null || escMailResult==false) && escMobResult  == null && escResult != escMail )
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg22,function(btn){
					Ext.getCmp('escmailid').focus(true);
				});
				Ext.getCmp('escAlert_1').setValue(true);
				return false;
			}
			Ext.getCmp('escMailAlert').show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
		}
		else
		{
			Ext.getCmp('escMailAlert').hide();
			//if (!Ext.getCmp('escMailAlert').isHidden())
			//{
				Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y - 200);
			//}
		}
	},
	eGRemoteExecution : function(obj)
	{
		var remotecontrol = obj.getValue().remotecontrol;
		if (remotecontrol == "true")
		{
			Ext.getCmp('execcommands').show();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y);
		}
		else
		{
			Ext.getCmp('execcommands').hide();
			Ext.getCmp('userpref').body.scroll('bottom',obj.getBox().y);
		}
	},
	configureMailAlert : function(isChecked)
	{
		if (isChecked == true)
		{
			Ext.getCmp('high').setValue(true);
			Ext.getCmp('medium').setValue(true);
			Ext.getCmp('low').setValue(true);
			Ext.getCmp('frmAlarmContainer').show();
		}
		else
		{
			Ext.getCmp('high').setValue(false);
			Ext.getCmp('medium').setValue(false);
			Ext.getCmp('low').setValue(false);
			Ext.getCmp('frmAlarmContainer').hide();
		}
	},
	showalarmRet : function(obj,newValue,oldValue,eOpts)
	{
		var high = Ext.getCmp('high').getValue();
		var medium = Ext.getCmp('medium').getValue();
		var low = Ext.getCmp('low').getValue();
		if (high == true || medium == true || low == true)
		{
			Ext.getCmp('frmAlarmContainer').show();
			if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no')
			{
				Ext.getCmp('customScript').hide();
				Ext.getCmp('Execshift').hide();
			}
		}
		else
		{
			Ext.getCmp('frmAlarmContainer').hide();
		}
		try
		{
			Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('high').getBox().y - 200);	
		}
		catch (e)
		{
		}
		
	},
	logoConfiguration : function(obj,newValue,oldValue,eOpts)
	{
		var repLogoContainer = Ext.getCmp('imgRepPage');
		var configLogoContainer = Ext.getCmp('imgConfigPage');
		var isConfigSupported = publicJSON['isConfigSupported'];
		if (obj.getValue() == true)
		{
			repLogoContainer.hide();
			configLogoContainer.hide();
		}
		else
		{
			if (isConfigSupported == true)
			{
				repLogoContainer.show();
				configLogoContainer.show();
			}
			else
			{
				repLogoContainer.show();
			}
		}
	},

	onOrganizationChange : function(obj)
	{
		var selectedOrg = obj.getValue();
		var uname = Ext.getCmp('uname').getValue();

		if (!Ext.isEmpty(selectedOrg) && selectedOrg != '-1')
		{
			var existingOrg = publicJSON['organizationValue'];

			if (!Ext.isEmpty(existingOrg) && existingOrg.toLowerCase() != selectedOrg.toLowerCase())
			{
				Ext.Msg.show({
					title:pageTitle5,
					msg : orgChangePrompt,
					buttons : Ext.Msg.YESNO,
					icon : 'iconConfirmation',
					fn : function(response)
					{
						if(response == 'yes')
						{
							appCnt.orgChangeFunction(Ext.getCmp('org'));
						}
						else
						{
							Ext.getCmp('org').setValue(existingOrg);
							return false;
						}
					}
				});
			}
			else
			{
				appCnt.orgChangeFunction(Ext.getCmp('org'));
			}
		}
		else
		{
			Ext.Msg.alert(pageTitle,userIDValidationMsg74,function(btn){
				if (btn == "ok")
				{
					appCnt.onUserIDChange(Ext.getCmp('uname'));
					Ext.getCmp('org').focus(true);
				}
			});
			Ext.getCmp('userformcontainer').setActiveTab(0);
			return false;
		}
	},

	orgChangeFunction : function(obj)
	{
		var selectedOrg = obj.getValue();
		var uname = Ext.getCmp('uname').getValue();

		var urlString = "EgChangeUserProfile/data/EgChangeUserProfileJson.jsp?selectedTab=1&qctr=1&username="+encodeURIComponent(uname)+"&org="+encodeURIComponent(selectedOrg)+"&date="+new Date().getTime();

		Ext.Ajax.request({
			url : urlString,
			method: 'POST',
			success: function(response)
			{
				var JSONObj = Ext.decode(response.responseText);
				Ext.getCmp('utype').getStore().loadRawData(JSONObj['userRolesArr']);
				if (JSONObj.requestStatus == "failed")
				{
					Ext.Msg.show({
						title: JSONObj.errors.title,
						msg: JSONObj.errors.message1 + ". "+JSONObj.errors.message2+".",
						width: 500,
						buttons: Ext.Msg.OK,
						icon: 'iconError',
						fn : function (btn){
							if (btn == "ok")
							{
								appCnt.onUserIDChange(Ext.getCmp('uname'));
								Ext.getCmp('org').focus(true);
							}
						}
					});
					return false;
				}
				else
				{
					var record = obj.getStore().getNodeById(selectedOrg);
					var uvalidtill = record.raw.uvalidtill;

					Ext.getCmp('tilldate').setValue("");
					Ext.getCmp('tmptilldate').setValue("");
					Ext.getCmp('Never').setValue("");

					if (uvalidtill != null && uvalidtill != "12/12/9999")
					{
						Ext.getCmp('tmptilldate').setValue(uvalidtill);
						var selected = Ext.getCmp('tmptilldate').getValue();
						var tillDate = Ext.Date.dateFormat(selected, mgrDateFormat);
						if (tillDate != null && tillDate.length > 0)
						{
							Ext.getCmp('tilldate_h').setValue(tillDate);
							var tmpDate = tillDate + " 23:59:59";
							Ext.getCmp('tilldate').setValue(tmpDate);
						}
						Ext.getCmp('tmptilldate').setMaxValue(uvalidtill);
						Ext.getCmp('Never').setDisabled(true);
						Ext.getCmp('Never').setValue(false);
					}
					else
					{
						Ext.getCmp('tmptilldate').setMaxValue("12/12/9999");
						Ext.getCmp('Never').setDisabled(false);
						Ext.getCmp('Never').setValue(true);
					}

					var userModel = publicJSON['userModel'];
					Ext.getCmp('utype').getStore().clearFilter();
					if (!Ext.isEmpty(userModel) && userModel == 'Organization')
					{
						Ext.getCmp('org').hide();
						Ext.getCmp('selectedServerListGrid').hide();

						Ext.getCmp('utype').setValue("none");
						Ext.getCmp('utype').getStore().filter('isShareRole',true);
					}
					else if (!Ext.isEmpty(userModel) && userModel == 'SubOrganization')
					{
						Ext.getCmp('org').show();
						Ext.getCmp('selectedServerListGrid').show();

						Ext.getCmp('utype').setValue("none");
						Ext.getCmp('utype').getStore().filter('isShareRole',true);
					}
					else
					{
						Ext.getCmp('org').show();
						Ext.getCmp('selectedServerListGrid').show();
						if (selectedOrg.toLowerCase() == 'egenterprise')
						{
							Ext.getCmp('utype').setValue("none");
							Ext.getCmp('utype').getStore().filter('isShareRole',false);
						}
						else
						{
							Ext.getCmp('utype').setValue("none");
							Ext.getCmp('utype').getStore().filter('hasallcompaccess',false);
						}
					}
				}
			},
			failure : function(response)
			{
			}
		});
	},

	userTypeOnChange : function(obj)
	{
		if (obj.getValue() != '-1' && obj.getValue() != 'none')
		{
			var me = this;
			var tmpName = Ext.getCmp('uname').getValue();
			uTypeChange = true;
			updateSettings = true;
			var urlString = "EgChangeUserProfile/data/EgChangeUserProfileJson.jsp?selectedTab=1&qctr=1&usertype="+encodeURIComponent(obj.getValue())+"&username="+encodeURIComponent(tmpName)+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : urlString,
				method: 'POST',
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					//me.getMain().getForm().reset();
					me.loadUserProfileControls(false,'usertypeCombo');
				},
				failure : function()
				{
				}
			});
		}
		//else
		//{
			//Ext.Msg.alert(pageTitle,userRoleValidationMsg,function(btn){
				//if (btn == "ok")
				//{
					//Ext.getCmp('utype').focus(true);
				//}
			//});
		//}
	},
	onUserIDChange : function(obj)
	{
		var me = this;
		var fieldsContainer = Ext.getCmp('fieldsContainer');
		var selectedUserType = obj.getValue();
		var userformcontainerObj1 = Ext.getCmp('userformcontainer');
		var btnNext = Ext.getCmp('btnNext');
		if (selectedUserType == "none" || selectedUserType == "-1" || selectedUserType.toLowerCase() == "egenterprise")
		{
			userformcontainerObj1.child("#tab2").tab.setDisabled(true);
			var elementFilteringTabObj1 = Ext.getCmp('elementFilteringTab');
			var elementAssociationTab1 = Ext.getCmp('elementAssociationTab');
			elementAssociationTab1.removeAll();
			elementFilteringTabObj1.removeAll();
			userformcontainerObj1.child("#tab4").tab.hide();
			userformcontainerObj1.child("#tab3").tab.hide();
			btnNext.setDisabled(true);
			userformcontainerObj1.child("#tab1").getForm().reset();
			Ext.getCmp('org').hide();
			delete elementFilteringTabObj1;
			delete elementFilteringTabObj1;
			if (selectedUserType.toLowerCase() == "egenterprise")
			{
				Ext.Msg.show({
					title: pageTitle2,
					msg: usrModWarn1+" "+selectedUserType+" "+usrModWarn2+".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
			return false;
		}
		userformcontainerObj1.child("#tab2").tab.setDisabled(false);
		btnNext.setDisabled(false);
		delete btnNext;
		delete userformcontainerObj1;
		selectedTab = "1";
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();
		var urlString = "EgChangeUserProfile/data/EgChangeUserProfileJson.jsp?selectedTab=1&qctr=1&username="+encodeURIComponent(selectedUserType)+"&date="+new Date().getTime();
		//me.updateUserPage(urlString);
		Ext.Ajax.request({
			url : urlString,
			method: 'POST',
			success: function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				me.getMain().getForm().reset();
				me.hiddenParamsForAuditLog(publicJSON);

				obj.setValue(selectedUserType);
				me.loadUserProfileControls(false,'userCombo');
			},
			failure : function()
			{
				myMask.hide();
			}
		});
	},
	hiddenParamsForAuditLog: function() {
		var headers = Array.prototype.slice.call(arguments);
		var bodyData = headers.pop();
		if(!Ext.isEmpty(bodyData))
		{
			var userData = bodyData.hiddenFields;
			if(!Ext.isEmpty(userData))
			{
				var hiddenFieldsContainerObj = Ext.getCmp('auditsHiddenContainer');
				hiddenFieldsContainerObj.removeAll();
				for (key in userData)
				{
					var keyValue  = userData[key];
					hiddenFieldsContainerObj.add({xtype: 'hiddenfield',name : key,value : keyValue});
				}
			}			
		}
	},
	loadUserProfileControls : function(selectUserConfigTab,fromWhere)
	{
		inputs = 0;
		mailShiftPeriodsCount = 0;
		smsShiftPeriodsCount = 0;
		escShiftPeriodsCount = 0;
		ExecShiftPeriodsCount= 0;
		isAlarmEnabled = false;

		Ext.suspendLayouts();
		isFromMainPage = true;
		var me = this;
		var fieldsContainer = Ext.getCmp('fieldsContainer');
		Ext.getCmp('eGAuth').setValue(true);

		var loginLogo1 = Ext.getCmp('loginLogo1');
		var monitorLogo1 = Ext.getCmp('monitorLogo1');
		var reporterLogo1 = Ext.getCmp('reporterLogo1');
		var configLogo1 = Ext.getCmp('configLogo1');
		var timeZone = Ext.getCmp('timeZone');
		var utypeObj = Ext.getCmp('utype');
		var userDataFormat = Ext.getCmp('userDataFormat');
		var upass = Ext.getCmp('upass');
		var confpasswd = Ext.getCmp('confpasswd');
		var domainNameObj = Ext.getCmp('domainName');
		var idpNameObj = Ext.getCmp('idpName');
		var timeOpt = Ext.getCmp('timeOpt');

		var strUserRole = publicJSON['utype'];
		var hasmonitoraccess = publicJSON['hasmonitoraccess'];
		var hasAllComponentAccess = publicJSON['hasallcompaccess'];
		var authenticationType = publicJSON['authenticationType'];
		var isSAMLLoginEnabled = publicJSON.isSAMLLoginEnabled;
		hideOrganization = publicJSON['hideOrganization'];
		var tmp_id = Ext.getCmp('uname').getValue();
		selectedUserID = publicJSON[tmp_id];
		if (authenticationType == "Eg")
		{
			upass.setValue(publicJSON['changeObj']);
			confpasswd.setValue(publicJSON['changeObj']);
			pass = upass.getValue();
			confPass = confpasswd.getValue();
			if (isSAMLLoginEnabled)
			{
				if (Ext.getCmp('userAuth').isHidden())
				{
					Ext.getCmp('eGAuthSAML').setValue(true);
				}
				else
				{
					Ext.getCmp('eGAuth').setValue(true);
				}
			}
			else
			{
				Ext.getCmp('eGAuth').setValue(true);
			}
			domainNameObj.hide();
			Ext.getCmp('pasCont').show();
			upass.show();
			confpasswd.show();
			idpNameObj.hide();
		}
		else if (authenticationType == "SAML")
		{
			Ext.getCmp('idpAuthSAML').setValue(true);
			idpNameObj.getStore().loadRawData(publicJSON['ssoList']);
			idpNameObj.setValue(publicJSON['selectedSso']);
			idpNameObj.show();
			upass.hide();
			Ext.getCmp('pasCont').hide();
			domainNameObj.hide();
			confpasswd.hide();
		}
		else
		{
			if (isSAMLLoginEnabled)
			{
				if (Ext.getCmp('userAuth').isHidden())
				{
					Ext.getCmp('domainAuthSAML').setValue(true);
				}
				else
				{
					Ext.getCmp('domainAuth').setValue(true);
				}
			}
			else
			{
				Ext.getCmp('domainAuth').setValue(true);
			}
			domainNameObj.getStore().loadRawData(publicJSON['domainsList']);
			domainNameObj.setValue(publicJSON['selectedDomain']);
			upass.hide();
			Ext.getCmp('pasCont').hide();
			confpasswd.hide();
			domainNameObj.show();
			idpNameObj.hide();
		}
		var isDescEnabled = publicJSON['isDescEnabled'];
		if(isDescEnabled != null && isDescEnabled != undefined && (isDescEnabled == "yes" || isDescEnabled == "true"))
		{
			Ext.getCmp('description').setValue(publicJSON['description']);
			Ext.getCmp('description').show();
		}

		utypeObj.getStore().loadRawData(publicJSON['userRolesArr']);

		if (hideOrganization == true)
		{
			Ext.getCmp('org').hide();
			Ext.getCmp('Never').setDisabled(false);
			Ext.getCmp('utype').getStore().clearFilter();
			Ext.getCmp('utype').getStore().filter('isShareRole',true);
		}
		else
		{
			Ext.getCmp('org').show();
			var rootData = {
				text: 'Choose Organization / Organizational Unit',
				id: '-1',
				name: '-1',
				expanded: true,
				children:publicJSON['organization']
			};
			Ext.getCmp('org').getStore().setRootNode(rootData);
			if (fromWhere != 'usertypeCombo')
			{
				Ext.getCmp('org').setValue(publicJSON['organizationValue']);
			}

			var record = Ext.getCmp('org').getStore().getNodeById(Ext.getCmp('org').getValue());
			
			if (publicJSON['userModel'] == 'SubOrganization')
			{
				Ext.getCmp('org').setDisabled(true);
				Ext.getCmp('utype').getStore().clearFilter();
				Ext.getCmp('utype').getStore().filter('isShareRole',true);
			}
			else
			{
				Ext.getCmp('org').setDisabled(false);

				var org = Ext.getCmp('org').getValue();
				Ext.getCmp('utype').getStore().clearFilter();
				if (!Ext.isEmpty(org) && org.toLowerCase() == "egenterprise")
				{
					Ext.getCmp('utype').getStore().filter('isShareRole',false);
				}
				else
				{
					Ext.getCmp('utype').getStore().filter('hasallcompaccess',false);
				}
			}
			var org = Ext.getCmp('org').getValue();
		}

		if (fromWhere != 'usertypeCombo')
		{
			if (publicJSON['userModel'] != 'Organization')
			{
				var record = Ext.getCmp('org').getStore().getNodeById(Ext.getCmp('org').getValue());
				var uvalidtill = record.raw.uvalidtill;

				if (uvalidtill != null && uvalidtill != "12/12/9999")
				{
					Ext.getCmp('tmptilldate').setMaxValue(uvalidtill);
					Ext.getCmp('Never').setDisabled(true);
				}
				else
				{
					Ext.getCmp('tmptilldate').setMaxValue("12/12/9999");
					Ext.getCmp('Never').setDisabled(false);
				}
				Ext.getCmp('tmptilldate').setValue("");
				Ext.getCmp('tilldate').setValue("");
				Ext.getCmp('Never').setValue("");
			}
			else
			{
				Ext.getCmp('tmptilldate').setMaxValue("12/12/9999");
				Ext.getCmp('Never').setDisabled(false);

				Ext.getCmp('tmptilldate').setValue("");
				Ext.getCmp('tilldate').setValue("");
				Ext.getCmp('Never').setValue("");
			}
		}

		// date and time zone
		var tmptilldateObj = Ext.getCmp('tmptilldate');
		currExpDate = tmptilldateObj;
		var NeverObj = Ext.getCmp('Never');
		var userValidity = publicJSON['validtill'];
		if (fromWhere != 'usertypeCombo')
		{
			if (userValidity == "Never")
			{
				NeverObj.setValue(true);
				tmptilldateObj.setDisabled(true);
			}
			else
			{
				tmptilldateObj.setDisabled(false);
				NeverObj.setValue(false);
				tmptilldateObj.setValue(publicJSON['validtill_h_pre']);
				Ext.getCmp('tilldate').setValue(userValidity);
				Ext.getCmp('tilldate_h').setValue(publicJSON['validtill_h_pre']);
			}
		}

		timeZone.getStore().loadRawData(publicJSON['timeZone']);
		
		userDataFormat.getStore().loadRawData(publicJSON['userDataFormat']);

		timeZone.setValue(publicJSON['selectedTimeZone']);
		userDataFormat.setValue(publicJSON['selectedDateFormat']);
		utypeObj.setValue(strUserRole);

		var mailAlertSettings = publicJSON['mailAlertSettings'];
		var mailSendersData = mailAlertSettings['mailSenders'];

		var selectedMailSender = mailAlertSettings['selectedMailSender'];
		var mailSenders = Ext.getCmp('mailSenders');
		mailSenders.getStore().loadRawData(mailSendersData);
		if (!Ext.isEmpty(selectedMailSender) && selectedMailSender != undefined)
		{
			mailSenders.setValue(selectedMailSender);
		}
		else
		{
			mailSenders.setValue(mailSenders.getStore().getAt(0).get("valueField"));
		}

		var tomailidObj = Ext.getCmp('tomailid');
		var ccmailidObj = Ext.getCmp('ccmailid');
		var bccmailidObj = Ext.getCmp('bccmailid');

		tomailidObj.setValue(mailAlertSettings['tomailid']);
		ccmailidObj.setValue(mailAlertSettings['ccmailid']);
		bccmailidObj.setValue(mailAlertSettings['bccmailid']);

		if (hasmonitoraccess == true)
		{
			var monhomecombo = Ext.getCmp('monitorHomePage');
			var monitorHomePageSelection=publicJSON['monitorHomePageSelection'];
			var monitorHomeOptRadioGrpObj=Ext.getCmp('userProf_monitorHomeOpt');
			
			if(!Ext.isEmpty(monitorHomeOptRadioGrpObj))
			{
				monitorHomeOptRadioGrpObj.suspendEvents(false);
				monitorHomeOptRadioGrpObj.setValue({
					selectedMonHomeOpt: monitorHomePageSelection
				});
				
				monitorHomeOptRadioGrpObj.resumeEvents();
				monitorHomeOptRadioGrpObj.on('change',function(){
					var monitorHomeOptObj = monitorHomeOptRadioGrpObj.getChecked();
					var monitorHomeOpt = monitorHomeOptObj[0].inputValue;
					if(monitorHomeOpt!=null && monitorHomeOpt=='dynamic')
					{
						monhomecombo.getStore().removeAll();
						monhomecombo.getStore().loadRawData(publicJSON['monitoringDomains']);
						monhomecombo.setValue(publicJSON['selectedMonitorDomain']);
					}
					else
					{
						monhomecombo.getStore().removeAll();
						monhomecombo.getStore().loadRawData(publicJSON['monhomearray']);
						monhomecombo.setValue(publicJSON['monHomePage']);
					}
				});
			}
			if(monitorHomePageSelection!=null && monitorHomePageSelection=='dynamic')
			{
				monhomecombo.getStore().removeAll();
				monhomecombo.getStore().loadRawData(publicJSON['monitoringDomains']);
				monhomecombo.setValue(publicJSON['selectedMonitorDomain']);
			}
			else
			{
				monhomecombo.getStore().removeAll();
				monhomecombo.getStore().loadRawData(publicJSON['monhomearray']);
				monhomecombo.setValue(publicJSON['monHomePage']);
			}
			
			Ext.getCmp('monitorFieldsContainer').show();
			Ext.getCmp('mailsmsalerts').show();

			//var monitorHomePage = Ext.getCmp('monitorHomePage');
			var measure_in_mail_mode = Ext.getCmp('measure_in_mail_mode');
			//var mailSenders = Ext.getCmp('mailSenders'); 
			var alarm_h = Ext.getCmp('alarm_h');
			var alarm_m = Ext.getCmp('alarm_m');
			var alarm_l = Ext.getCmp('alarm_l');

			var remoteEnabled = publicJSON['remoteEnabled'];
			var td = publicJSON['td'];
			//var mailSendersData = publicJSON['mailAlertSettings']['mailSenders']; 
			//var selectedMailSender = publicJSON['mailAlertSettings']['selectedMailSender']; 
			var alarmH = publicJSON['alarm_h'];
			var alarmM = publicJSON['alarm_m'];
			var alarmL = publicJSON['alarm_l'];


			// if alarm policy enabled
			var highObj = Ext.getCmp('high');
			var mediumObj = Ext.getCmp('medium');
			var lowObj = Ext.getCmp('low');

			var mailAlertSettings = publicJSON['mailAlertSettings'];
			var isShiftPeriodsEnabled = mailAlertSettings['isShiftPeriodsEnabled'];
			var highAlarmOption = mailAlertSettings['high'];
			var mediumAlarmOption = mailAlertSettings['medium'];
			var lowAlarmOption = mailAlertSettings['low'];
			var hasAlramList = mailAlertSettings['hasAlramList'];

			if (fromWhere == 'usertypeCombo')
			{
				var measureInMailModeData = publicJSON['mailAlertSettings']['measure_in_mail_mode'];
				var selectedMailMode = publicJSON['mailAlertSettings']['selectedMailMode'];
				measure_in_mail_mode.getStore().loadRawData(measureInMailModeData);
				measure_in_mail_mode.setValue(selectedMailMode);
			}

			var mailFilterObj = Ext.getCmp('mail_filter_optionGrp');
			if (publicJSON.isFilterControlEnabled == true)
			{
				mailFilterObj.show();
				mailFilterOption = publicJSON.filterControlDefaultSelection;
				if (mailFilterOption == "Descriptors_Only")
				{
					Ext.getCmp("mail_filter_option2").setValue(true);
				}
				else
				{
					Ext.getCmp("mail_filter_option1").setValue(true);
				}
			}
			else
			{
				mailFilterObj.hide();
			}

			measure_in_mail_mode.getStore().loadRawData(publicJSON['mailAlertSettings']['measure_in_mail_mode']);
			measure_in_mail_mode.setValue(publicJSON['mailAlertSettings']['selectedMailMode']);


			//mailSenders.getStore().loadRawData(mailSendersData);
			//if (!Ext.isEmpty(selectedMailSender) && selectedMailSender != undefined)
			//{
				//mailSenders.setValue(selectedMailSender);
			//}
			//else
			//{
				//mailSenders.setValue(mailSenders.getStore().getAt(0).get("valueField"));
			//}

			//var tomailidObj = Ext.getCmp('tomailid');
			//var ccmailidObj = Ext.getCmp('ccmailid');
			//var bccmailidObj = Ext.getCmp('bccmailid');

			//tomailidObj.setValue(mailAlertSettings['tomailid']);
			//ccmailidObj.setValue(mailAlertSettings['ccmailid']);
			//bccmailidObj.setValue(mailAlertSettings['bccmailid']);

			if (hasAlramList == true)
			{
				isAlarmEnabled = true;
				var customScriptObj = Ext.getCmp('customScript');
				var escmailidObj = Ext.getCmp('escmailid');
				
				//tomailidObj.setValue(mailAlertSettings['tomailid']);
				//ccmailidObj.setValue(mailAlertSettings['ccmailid']);
				//bccmailidObj.setValue(mailAlertSettings['bccmailid']);
				customScriptObj.setValue(mailAlertSettings['customScript']);

				if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no')
				{
					customScriptObj.hide();
					Ext.getCmp('Execshift').hide();
				}

				if (highAlarmOption == "checked")
				{
					highObj.setValue(true);
				}
				else
				{
					highObj.setValue(false);
				}

				if (mediumAlarmOption == "checked")
				{
					mediumObj.setValue(true);
				}
				else
				{
					mediumObj.setValue(false);
				}

				if (lowAlarmOption == "checked")
				{
					lowObj.setValue(true);
				}
				else
				{
					lowObj.setValue(false);
				}

				var escmailid = mailAlertSettings['escmailid'];
				var escmailids = mailAlertSettings['escmailids'];
				var existLevel = publicJSON['existLevel'];
				escmailidObj.setValue(escmailid);

				var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
				var escMailIDsDivElementsCount = escMailIDsDiv.items.length;
				
				if (escMailIDsDivElementsCount > 1)
				{
					var removableCt = new Array();
					for (var i = 0;i<escMailIDsDivElementsCount;i++)
					{
						var tmpObj = escMailIDsDiv.items.items[i];
						if (tmpObj == undefined || tmpObj.getId() == "staticEscContainer")
						{
							continue;
						}
						else
						{
							//escMailIDsDiv.remove(tmpObj);
							removableCt.push(tmpObj);
						}
					}
					Ext.suspendLayouts();
					for (var k = 0;k<removableCt.length;k++)
					{
						escMailIDsDiv.remove(removableCt[k]);
					}
					Ext.resumeLayouts(true);
					removableCt = null;
				}

				if (!Ext.isEmpty(escmailids))
				{
					for (var value in escmailids)
					{
						addEscLevel(escmailids[value]);
					}
				}

				var notify = mailAlertSettings['notify'];
				var msgmode = mailAlertSettings['msgmode'];
				var dd_in_mail_mode = mailAlertSettings['dd_in_mail_mode'];


				if (notify.toLowerCase() == "new")
				{
					Ext.getCmp('alarmNotifyNew').setValue(true);
				}
				else
				{
					Ext.getCmp('alarmNotifyComplete').setValue(true);
				}
			
				if (msgmode.toLowerCase() == "html")
				{
					Ext.getCmp('alarmMsgHtml').setValue(true);
				}
				else
				{
					Ext.getCmp('alarmMsgText').setValue(true);
				}

				if (dd_in_mail_mode == true)
				{
					Ext.getCmp('ddMailYes').setValue(true);
				}
				else
				{
					Ext.getCmp('ddMailNo').setValue(true);
				}

				// for alarm shify periods
				if (isShiftPeriodsEnabled == true)
				{
					me.getShifPeroidsCt().show();
					var hasMailshift = mailAlertSettings['mailshift'];
					var hasExecshift = mailAlertSettings['Execshift'];
					var hasSmsshift = mailAlertSettings['smsshift'];
					var hasEscshift = mailAlertSettings['escshift'];
					var mailList = mailAlertSettings['mailList'];
					var ExeComList = mailAlertSettings['ExeComList'];
					var SmsList = mailAlertSettings['SmsList'];
					var EscList = mailAlertSettings['EscList'];
					//mailShiftPeriodsCount = parseInt(publicJSON['mailShiftPeriodsCount']);
					//smsShiftPeriodsCount = parseInt(publicJSON['smsShiftPeriodsCount']);
					//escShiftPeriodsCount = parseInt(publicJSON['escShiftPeriodsCount']);
					//ExecShiftPeriodsCount = parseInt(publicJSON['execShiftPeriodCount']);

					var emailMailAlert = Ext.getCmp('emailMailAlert');
					var emailAlert_0_Obj = Ext.getCmp('emailAlert_0')
					var emailMailAlertElementsCount = emailMailAlert.items.length;
				
					if (emailMailAlertElementsCount > 1)
					{
						var removableCt = new Array();
						for (var i = 0;i<emailMailAlertElementsCount;i++)
						{
							var tmpObj = emailMailAlert.items.items[i];
							if (tmpObj == undefined || tmpObj.getId() == "staticMailContainer")
							{
								continue;
							}
							else
							{
								//emailMailAlert.remove(tmpObj);
								removableCt.push(tmpObj);
							}
						}
						Ext.suspendLayouts();
						for (var k = 0;k<removableCt.length;k++)
						{
							emailMailAlert.remove(removableCt[k]);
						}
						Ext.resumeLayouts(true);
						removableCt = null;
					}

					if (hasMailshift == "Yes")
					{
						emailAlert_0_Obj.setValue(true);
						emailMailAlert.show();
						var initId = 0;
						for (var key in mailList)
						{
							var tmpObj = mailList[key];
							var mailDay = tmpObj["mailday"+initId];
							var mailShift = tmpObj["mailshift"+initId];
							if (parseInt(initId) == 0)
							{
								//insertShiftData('mail',mailDay,mailShift);
								Ext.getCmp('mailday0').setValue(mailDay);
								Ext.getCmp('mailshift0').setValue(mailShift);
							}
							else
							{
								addMoreShifts('mail',mailDay,mailShift);
							}
							initId++;
						}
					}
					else
					{
						emailAlert_0_Obj.setValue(false);
						emailMailAlert.hide();
					}

					var commandAlertObj = Ext.getCmp('commandAlert');
					var shiftAlert_0_Obj = Ext.getCmp('shiftAlert_0')
					var commandAlertElementsCount = commandAlertObj.items.length;
				
					if (commandAlertElementsCount > 1)
					{
						var removableCt = new Array();
						for (var i = 0;i<commandAlertElementsCount;i++)
						{
							var tmpObj = commandAlertObj.items.items[i];
							if (tmpObj == undefined || tmpObj.getId() == "staticCmdContainer")
							{
								continue;
							}
							else
							{
								//commandAlertObj.remove(tmpObj);
								removableCt.push(tmpObj);
							}
						}
						Ext.suspendLayouts();
						for (var k = 0;k<removableCt.length;k++)
						{
							commandAlertObj.remove(removableCt[k]);
						}
						Ext.resumeLayouts(true);
						removableCt = null;
					}

					if (hasExecshift == "Yes")
					{
						shiftAlert_0_Obj.setValue(true);
						var initId = 0;
						commandAlertObj.show();
						for (var key in ExeComList)
						{
							var tmpObj = ExeComList[key];
							var Day = tmpObj["Execday"+initId];
							var Shift = tmpObj["ExecShift"+initId];
							if (parseInt(initId) == 0)
							{
								Ext.getCmp('Execday0').setValue(Day);
								Ext.getCmp('Execshift0').setValue(Shift);
								//insertShiftData('Exec',Day,Shift);
							}
							else
							{
								addMoreShifts('Exec',Day,Shift);
							}
							initId++;
						}
					}
					else
					{
						shiftAlert_0_Obj.setValue(false);
						commandAlertObj.hide();
					}

					if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no')
					{
						commandAlertObj.hide();
					}

					var smsAlertObj = Ext.getCmp('smsAlert');
					var smsAlert_0_Obj = Ext.getCmp('smsAlert_0')
					var smsAlertElementsCount = smsAlertObj.items.length;
				
					if (smsAlertElementsCount > 1)
					{
						var removableCt = new Array();
						for (var i = 0;i<smsAlertElementsCount;i++)
						{
							var tmpObj = smsAlertObj.items.items[i];
							if (tmpObj == undefined || tmpObj.getId() == "staticSMSContainer")
							{
								continue;
							}
							else
							{
								//smsAlertObj.remove(tmpObj);
								removableCt.push(tmpObj);
							}
						}
						Ext.suspendLayouts();
						for (var k = 0;k<removableCt.length;k++)
						{
							smsAlertObj.remove(removableCt[k]);
						}
						Ext.resumeLayouts(true);
						removableCt = null;
					}

					if (hasSmsshift == "Yes")
					{
						smsAlert_0_Obj.setValue(true);
						var initId = 0;
						smsAlertObj.show();
						for (var key in SmsList)
						{
							var tmpObj = SmsList[key];
							var Day = tmpObj["smsday"+initId];
							var Shift = tmpObj["smsShift"+initId];
							if (parseInt(initId) == 0)
							{
								Ext.getCmp('smsday0').setValue(Day);
								Ext.getCmp('smsshift0').setValue(Shift);
								//insertShiftData('Exec',Day,Shift);
							}
							else
							{
								addMoreShifts('sms',Day,Shift);
							}
							initId++;
						}
					}
					else
					{
						smsAlert_0_Obj.setValue(false);
						smsAlertObj.hide();
					}

					var escMailAlert = Ext.getCmp('escMailAlert');
					var escAlert_0_Obj = Ext.getCmp('escAlert_0')
					var escAlertElementsCount = escMailAlert.items.length;
				
					if (escAlertElementsCount > 1)
					{
						var removableCt = new Array();
						for (var i = 0;i<escAlertElementsCount;i++)
						{
							var tmpObj = escMailAlert.items.items[i];
							if (tmpObj == undefined || tmpObj.getId() == "staticESContainer")
							{
								continue;
							}
							else
							{
								//escMailAlert.remove(tmpObj);
								removableCt.push(tmpObj);
							}
						}
						Ext.suspendLayouts();
						for (var k = 0;k<removableCt.length;k++)
						{
							escMailAlert.remove(removableCt[k]);
						}
						Ext.resumeLayouts(true);
						removableCt = null;
					}

					if (hasEscshift == "Yes")
					{
						escAlert_0_Obj.setValue(true);
						var initId = 0;
						escMailAlert.show();
						for (var key in EscList)
						{
							var tmpObj = EscList[key];
							var Day = tmpObj["escday"+initId];
							var Shift = tmpObj["escShift"+initId];
							if (parseInt(initId) == 0)
							{
								Ext.getCmp('escday0').setValue(Day);
								Ext.getCmp('escshift0').setValue(Shift);
								//insertShiftData('esc',Day,Shift);
							}
							else
							{
								addMoreShifts('esc',Day,Shift);
							}
							initId++;
						}
					}
					else
					{
						escAlert_0_Obj.setValue(false);
						escMailAlert.hide();
					}
				}
				else
				{
					me.getShifPeroidsCt().hide();
				}
			}
			else
			{
				isAlarmEnabled = false;

				var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
				var emailMailAlert = Ext.getCmp('emailMailAlert');
				var commandAlert = Ext.getCmp('commandAlert');
				var smsAlert = Ext.getCmp('smsAlert');
				var escMailAlert = Ext.getCmp('escMailAlert');
				me.removeDynamicElements(escMailIDsDiv.items.length,escMailIDsDiv,"staticEscContainer");
				me.removeDynamicElements(emailMailAlert.items.length,emailMailAlert,"staticMailContainer");
				me.removeDynamicElements(commandAlert.items.length,commandAlert,"staticCmdContainer");
				me.removeDynamicElements(smsAlert.items.length,smsAlert,"staticSMSContainer");
				me.removeDynamicElements(escMailAlert.items.length,escMailAlert,"staticESContainer");
				emailMailAlert.hide();
				commandAlert.hide();
				smsAlert.hide();
				escMailAlert.hide();
			}
			// end


			if (alarmH == "checked")
			{
				alarm_h.setValue(true);
			}
			else
			{
				alarm_h.setValue(false);
			}

			if (alarmM == "checked")
			{
				alarm_m.setValue(true);
			}
			else
			{
				alarm_m.setValue(false);
			}

			if (alarmL == "checked")
			{
				alarm_l.setValue(true);
			}
			else
			{
				alarm_l.setValue(false);
			}

			if (remoteEnabled == false)
			{
				Ext.getCmp('eGRemoteExec').hide();
			}
			else
			{
				var remotecontrol_1Obj = Ext.getCmp('remotecontrol_1');
				var remotecontrol_2Obj = Ext.getCmp('remotecontrol_2');
				var execcommandsObj = Ext.getCmp('execcommands').show();
				if (publicJSON.remotecontrol == true)
				{
					execcommandsObj.show();
					remotecontrol_1Obj.setValue(true);
				}
				else
				{
					execcommandsObj.hide();
					remotecontrol_2Obj.setValue(true);
				}
				var execcommands = Ext.getCmp('execcommands');
				execcommands.getStore().loadRawData(publicJSON['execcommands']);
				execcommands.setValue(publicJSON['selectedCommandMode']);
				Ext.getCmp('eGRemoteExec').show();
			}
			//monitorHomePage.getStore().loadRawData(publicJSON['monitorHomePage']);
			//var monhomepage = publicJSON['selectedMonitorHomePage'];
			//if (monitorHomePageSelection != undefined)
			//{
				//monhomecombo.setValue(publicJSON['selectedMonitorHomePage']);
			//}
			//else
			//{
				//monhomecombo.setValue(monhomecombo.getStore().getAt(0).get("valueField"));
			//}

			var monitorHomeDisable = publicJSON['monitorHomeDisable'];
			if (monitorHomeDisable == "disabled")
			{
				monhomecombo.setDisabled(true);
			}
			else
			{
				monhomecombo.setDisabled(false);
			}
			//mailSenders.getStore().loadRawData(mailSendersData);
			//if (selectedMailSender != null && selectedMailSender != undefined)
			//{
				//mailSenders.setValue(selectedMailSender);
			//}
			//else
			//{
				//mailSenders.setValue(mailSenders.getStore().getAt(0).get("valueField"));
			//}

			var alarmdelete = publicJSON['alarmdelete'];
			var acknowledgment = publicJSON['acknowledgment'];
			var dashboardCreationPrivilege = publicJSON['dashboardCreationPrivilege'];

			if (alarmdelete == true)
			{
				Ext.getCmp('alarmDeleteYes').setValue(true);
			}
			else
			{
				Ext.getCmp('alarmDeleteNo').setValue(true);
			}

			if (acknowledgment == true)
			{
				Ext.getCmp('acknowledgmentYes').setValue(true);
			}
			else
			{
				Ext.getCmp('acknowledgmentNo').setValue(true);
			}
			if (dashboardCreationPrivilege == true)
			{
				Ext.getCmp('dashboardPrivilegeYes').setValue(true);
			}
			else
			{
				Ext.getCmp('dashboardPrivilegeNo').setValue(true);
			}

			Ext.getCmp('availusers').hide();
			Ext.getCmp('autoassociatetousers').hide();
			Ext.getCmp('selectedServerListGrid').hide();

			var hasAllCompAccess = publicJSON['hasAllCompAccess'];

			if (hasAllCompAccess == false)
			{
				if (hideOrganization == false)
				{
					if (publicJSON['userModel'] == 'User')
					{
						if (!Ext.isEmpty(publicJSON['isShareRole']) && publicJSON['isShareRole'] == false)
						{
							Ext.getCmp('selectedServerListGrid').show();
							var confServList = publicJSON['generalSettings']['configuredServersList'];
							if (confServList != 'undefined' && !Ext.isEmpty(confServList))
							{
								var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
								selectedServerListGridObj.getStore().loadRawData(publicJSON['generalSettings']['configuredServersList']);
								var tmpCount = parseInt(publicJSON['generalSettings']['configuredServersCount']);
								selectedServerListGridObj.doLayout();
								selectedServerListGridObj.view.refresh();
								if (tmpCount > 9)
								{
									selectedServerListGridObj.setHeight(100);
								}
							}
							else
							{
								var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
								selectedServerListGridObj.getStore().loadRawData("");
							}
						}
					}
					else if (publicJSON['userModel'] == 'SubOrganization')
					{
						Ext.getCmp('selectedServerListGrid').show();
						var confServList = publicJSON['generalSettings']['configuredServersList'];
						if (confServList != 'undefined' && !Ext.isEmpty(confServList))
						{
							var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
							selectedServerListGridObj.getStore().loadRawData(publicJSON['generalSettings']['configuredServersList']);
							var tmpCount = parseInt(publicJSON['generalSettings']['configuredServersCount']);
							selectedServerListGridObj.doLayout();
							selectedServerListGridObj.view.refresh();
							if (tmpCount > 9)
							{
								selectedServerListGridObj.setHeight(100);
							}
						}
						else
						{
							var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
							selectedServerListGridObj.getStore().loadRawData("");
						}
					}
				}
			}
			else
			{
				Ext.getCmp('selectedServerListGrid').hide();
			}

			if (td == true)
			{
				Ext.getCmp('chkuser').show();
				if (hideOrganization == false)
				{
					if (publicJSON['userModel'] == 'User')
					{
						if (!Ext.isEmpty(publicJSON['isShareRole']) && publicJSON['isShareRole'] == false)
						{
							Ext.getCmp('autoassociatetousers').show();
						}
					}
					else if (publicJSON['userModel'] == 'SubOrganization')
					{
						Ext.getCmp('autoassociatetousers').hide();
					}
				}

				var AutoAssociated = publicJSON['AutoAssociated'];
				var userStr = publicJSON['userStr'];
				Ext.getCmp('availusers').getStore().loadRawData(publicJSON['availusers']);
				if (AutoAssociated == true)
				{
					Ext.getCmp('chkuser').setValue(true);
					Ext.getCmp('availusers').show();
					if (userStr.length > 0)
					{
						var users = userStr.replace(/~,~/g,",");
						Ext.getCmp('availusers').setValue(users);
						associatedUserIDs = userStr;
					}
				}
				else
				{
					Ext.getCmp('chkuser').setValue(false);
					Ext.getCmp('availusers').hide();
					associatedUserIDs = '';
				}
			}
			else
			{
				Ext.getCmp('autoassociatetousers').hide();
				associatedUserIDs = '';
			}
		}
		else
		{
			Ext.getCmp('monitorFieldsContainer').hide();
			Ext.getCmp('mailsmsalerts').hide();
			Ext.getCmp('reporterTimeLine').hide();
			Ext.getCmp('autoassociatetousers').hide();
			Ext.getCmp('selectedServerListGrid').hide();
		}

		var hasReporterTab  = publicJSON['hasReporterTab'];
		var  hasMemReporterChek =publicJSON['hasMemReporterChek'];
		if (hasReporterTab == false || hasMemReporterChek == false)
		{
			timeOpt.getStore().removeAll();
			Ext.getCmp('reporterTimeLine').hide();
		}
		else
		{
			timeOpt.getStore().loadRawData(publicJSON['chgTimeOpt']);
			timeOpt.setValue(publicJSON['chgTimeOptSeleted']);
			Ext.getCmp('reporterTimeLine').show();
		}

		var tmpLogoArr = publicJSON['logoArr'];
		var selectedLoginPageLogo = publicJSON['selectedLoginPageLogo'];
		var selectedAdminPageLogo = publicJSON['selectedAdminPageLogo'];
		var logoCheck = publicJSON['logoCheck'];

		loginLogo1.getStore().loadRawData(tmpLogoArr);
		loginLogo1.setValue(selectedLoginPageLogo);
		if (selectedLoginPageLogo == "show")
		{
			isLoginImgUpdated = true;
			Ext.getCmp('loginLogoIMG').show();
		}
		else
		{
			isLoginImgUpdated = false;
			Ext.getCmp('loginLogoIMG').hide();
		}

		monitorLogo1.getStore().loadRawData(tmpLogoArr);
		monitorLogo1.setValue(selectedAdminPageLogo);
		if (selectedAdminPageLogo == "show")
		{
			isAdminMonImgUpdated = true;
			Ext.getCmp('monitorLogoIMG').show();
		}
		else
		{
			isAdminMonImgUpdated = false;
			Ext.getCmp('monitorLogoIMG').hide();
		}

		var logoCheck = Ext.getCmp('logoCheck');
		logoCheck.hide();
		if(strUserRole != null && strUserRole != "AlarmViewer" && strUserRole != "SuperAlarmViewer")
		{
			var logoCheckVal = publicJSON['logoCheck'];
			if (logoCheckVal == true)
			{
				logoCheck.setValue(true);
				Ext.getCmp('imgRepPage').hide();
				Ext.getCmp('imgConfigPage').hide();
			}
			else
			{
				logoCheck.setValue(false);
				Ext.getCmp('imgRepPage').show();
				Ext.getCmp('imgConfigPage').show();
			}
			logoCheck.show();
			var selectedRepPageLogo = publicJSON['selectedRepPageLogo'];
			reporterLogo1.getStore().loadRawData(tmpLogoArr);
			reporterLogo1.setValue(selectedRepPageLogo);
			if (selectedRepPageLogo == "show")
			{
				isRepImgUpdated = true;
				Ext.getCmp('reporterLogoIMG').show();
			}
			else
			{
				isRepImgUpdated = false;
				Ext.getCmp('reporterLogoIMG').hide();
			}

			var isConfigSupported = publicJSON['isConfigSupported'];
			var configLogoContainer = Ext.getCmp('imgConfigPage');
			if (isConfigSupported == true)
			{
				var selectedConfigPageLogo = publicJSON['selectedConfigPageLogo'];
				configLogo1.getStore().loadRawData(tmpLogoArr);
				configLogo1.setValue(selectedConfigPageLogo);
				if (selectedConfigPageLogo == "show")
				{
					isConfigImgUpdated = true;
					Ext.getCmp('configLogoIMG').show();
				}
				else
				{
					isConfigImgUpdated = false;
					Ext.getCmp('configLogoIMG').hide();
				}

				var applyToOtherModule = Ext.getCmp('logoCheck').getValue();
				if (applyToOtherModule == true)
				{
					configLogoContainer.hide();
				}
				else
				{
					configLogoContainer.show();
				}
			}
			else
			{
				configLogoContainer.hide();
			}
		}
		else
		{
			Ext.getCmp('imgRepPage').hide();
			Ext.getCmp('imgConfigPage').hide();
		}
		Ext.resumeLayouts(true);
		var elementAssociationTab = Ext.getCmp('elementAssociationTab');
		var elementFilteringTabObj = Ext.getCmp('elementFilteringTab');
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		elementFilteringTabObj.removeAll();
		elementAssociationTab.removeAll();
		if (fromWhere == 'usertypeCombo')
		{
			userformcontainerObj.child("#tab4").tab.hide();
			userformcontainerObj.child("#tab3").tab.hide();
		}
		else
		{
			if (hasAllComponentAccess == true)
			{
				if(fromWhere == 'formSubmit' || fromWhere == 'main' || fromWhere == 'userCombo')
				{
					updateSettings = false;
				}
				if ((isAlarmEnabled == true || isAlarmEnabled == 'true' ) && (isFilterMailAlertsEnabled == true || isFilterMailAlertsEnabled == 'true'))
				{
					me.loadMailFilterAndConfigTab(selectUserConfigTab,fromWhere);
				}
				else
				{
					userformcontainerObj.child("#tab3").tab.hide();
					userformcontainerObj.child("#tab4").tab.hide();
					userformcontainerObj.setActiveTab(0);
				}
			}
			else
			{
				if(fromWhere == 'formSubmit' || fromWhere == 'main' || fromWhere == 'userCombo')
				{
					updateSettings = false;
				}
				
				if (publicJSON['userModel'] == 'Organization')
				{
					if (!Ext.isEmpty(publicJSON['ShareCompsAcrossOU']) && publicJSON['ShareCompsAcrossOU'] == 'true')
					{
						me.loadUserElementsTab(selectUserConfigTab,fromWhere);
					}
					else
					{
						if ((isAlarmEnabled == true || isAlarmEnabled == 'true' )&& (isFilterMailAlertsEnabled == true || isFilterMailAlertsEnabled == 'true'))
						{
							me.loadMailFilterAndConfigTab(selectUserConfigTab,fromWhere);
						}
						else
						{
							userformcontainerObj.child("#tab3").tab.hide();
							userformcontainerObj.child("#tab4").tab.hide();
							userformcontainerObj.setActiveTab(0);
						}
					}
				}
				else if (publicJSON['userModel'] == 'User')
				{
					if (!Ext.isEmpty(publicJSON['isShareRole']) && publicJSON['isShareRole'] == false)
					{
						me.loadUserElementsTab(selectUserConfigTab,fromWhere);
					}
					else
					{
						if ((isAlarmEnabled == true || isAlarmEnabled == 'true' )&& (isFilterMailAlertsEnabled == true || isFilterMailAlertsEnabled == 'true'))
						{
							me.loadMailFilterAndConfigTab(selectUserConfigTab,fromWhere);
						}
						else
						{
							userformcontainerObj.child("#tab3").tab.hide();
							userformcontainerObj.child("#tab4").tab.hide();
							userformcontainerObj.setActiveTab(0);
						}
					}
				}
				else
				{
					if(strUserRole != 'FannieMae-InfoSec')
						me.loadUserElementsTab(selectUserConfigTab,fromWhere);
				}
			}
		}
		isFromMainPage = false;
	},
	removeDynamicElements : function(count,objId,staticId)
	{
		if (count > 1)
		{
			var removableCt = new Array();
			for (var i = 0;i<count;i++)
			{
				var tmpObj = objId.items.items[i];
				if (tmpObj == undefined || tmpObj.getId() == staticId)
				{
					continue;
				}
				else
				{
					//objId.remove(tmpObj);
					removableCt.push(tmpObj);
				}
			}
			Ext.suspendLayouts();
			for (var k = 0;k<removableCt.length;k++)
			{
				objId.remove(removableCt[k]);
			}
			Ext.resumeLayouts(true);
			removableCt = null;
		}
	},
	loadMailFilterAndConfigTab : function(selectUserConfigTab,fromWhere)
	{
		var me = this;
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		var elementFilteringTabObj = Ext.getCmp('elementFilteringTab');
		//elementFilteringTabObj.removeAll();
		elementFilteringTabObj.add({xtype : 'egmailalertsuppress'});
		userformcontainerObj.child("#tab4").tab.show();
		userformcontainerObj.child("#tab3").tab.hide();

		//if (selectedTab == "4")
		{
			if (fromWhere == "formSubmit" || selectedTab == "4")
			{
				userformcontainerObj.setActiveTab(3);
			}
			if (mailFilterOption == "Descriptors_Only")
			{
				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').hide();
					Ext.getCmp('filterLabelID').show();
					me.showFilterDetails();
					Ext.getCmp('btnViewFilters').setText(pageIntnl97);
				}
			}
			else
			{
				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').show();
					Ext.getCmp('filterLabelID').hide();
					Ext.getCmp('btnViewFilters').setText(pageIntnl87);
				}
			}
		}
	},
	loadUserElementsTab : function(selectUserConfigTab,fromWhere)
	{
		var me = this;
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		var elementAssociationTab = Ext.getCmp('elementAssociationTab');
		var roleName = Ext.getCmp('utype').getValue();
		//var url = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?qctr=1&selectedTab=3&assousers="+encodeURIComponent(associatedUserIDs)+"&username="+encodeURIComponent(selectedUserID)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom="+reqFrom+"&utype="+roleName+"&date="+new Date().getTime();
		//this.updateUserElementPage(url);

		//elementAssociationTab.removeAll();
		elementAssociationTab.add({xtype : 'elementassociationform'});
		userformcontainerObj.child("#tab3").tab.show();

		if ((isAlarmEnabled == true || isAlarmEnabled == 'true' )&& (isFilterMailAlertsEnabled == true || isFilterMailAlertsEnabled == 'true'))
		{
			var elementFilteringTab = Ext.getCmp('elementFilteringTab');
			elementFilteringTab.removeAll();
			elementFilteringTab.add({xtype : 'egmailalertsuppress'});
			userformcontainerObj.child("#tab4").tab.show();
			if (mailFilterOption == "Descriptors_Only")
			{
				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').hide();
					Ext.getCmp('filterLabelID').show();
					me.showFilterDetails();
					Ext.getCmp('btnViewFilters').setText(pageIntnl97);
				}
			}
			else
			{
				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').show();
					Ext.getCmp('filterLabelID').hide();
					Ext.getCmp('btnViewFilters').setText(pageIntnl87);
				}
			}
		}
		else
		{
			userformcontainerObj.child("#tab4").tab.hide();
		}

		if (fromWhere == "formSubmit" && fromUpdatefirstTab == 'Yes')
		{
			fromUpdatefirstTab = 'No';
			userformcontainerObj.setActiveTab(1);
		}
		else if(fromWhere == "formSubmit" && fromPreviousUpdate == 'Yes')
		{
			fromPreviousUpdate = 'No';
			userformcontainerObj.setActiveTab(0);
		}
		else if (fromWhere == "formSubmit")
		{
			userformcontainerObj.setActiveTab(2);
		}
		else
		{
			if (selectedTab == "3")
			{
				userformcontainerObj.setActiveTab(2);
			}
			else if (selectedTab == "4")
			{
				userformcontainerObj.setActiveTab(3);
			}
		}
	},
	goBack : function()
	{
		if (reqfrom == 'twofa')
		{
			window.location.href = backHref+'&choose=twofa';
		}
		else
		{
			window.location.href = backHref;
		}
	},
	afterMainRender:function()
	{
		if (reqfrom != 'navlink' && reqfrom != 'adduser')
		{
			Ext.getCmp('backButton').show();
		}

		if (reqfrom == 'adduser' && showAlert == "yes")
		{
			Ext.Msg.show({
				title : "ADD USER",
				msg : pageIntnl92,
				icon : 'iconInformation',
				buttons : Ext.Msg.OK
			});
		}

		var isSAMLLoginEnabled = publicJSON.isSAMLLoginEnabled
		
		if (!Ext.isEmpty(isSAMLLoginEnabled) && isSAMLLoginEnabled)
		{
			Ext.getCmp('userAuthSAML').show();
			Ext.getCmp('userAuthSAML').setDisabled(true);

			Ext.getCmp('userAuth').hide();
			Ext.getCmp('userAuth').setDisabled(true);
		}
		else
		{
			Ext.getCmp('userAuth').show();
			Ext.getCmp('userAuth').setDisabled(true);

			Ext.getCmp('userAuthSAML').hide();
			Ext.getCmp('userAuthSAML').setDisabled(true);
		}

		if (!isEnterpriseModel)
		{
			Ext.getCmp('userAuth').hide();
			Ext.getCmp('userAuthSAML').hide();
		}

		//Ext.getCmp('isorg').setDisabled(true);
		var me = this;
		var userPrefContainerObj = Ext.getCmp('main');
		var btnNext = Ext.getCmp('btnNext');
		var isUsersCreated = publicJSON['isUsersCreated'];
		if (isUsersCreated == true)
		{
			var availableUsers = publicJSON['availableUsers'];
			var unameObj = Ext.getCmp('uname');
			
			var rootNodeText = publicJSON['RootNodeText'];
			if (Ext.isEmpty(rootNodeText))
			{
				rootNodeText = 'Choose Organization / Organizational Unit / User';
			}

			var rootData = {
				text: rootNodeText,
				id: '-1',
				name: '-1',
				expanded: true,
				children:publicJSON['exportDataArr']
			};
			unameObj.getStore().setRootNode(rootData);
			unameObj.setValue(selectedUserID);

			if (selectedUserID != "-1" && selectedUserID.length > 0)
			{
				btnNext.setDisabled(false);
				me.loadUserProfileControls(false,'main');
				me.hiddenParamsForAuditLog(publicJSON);
			}
			else
			{
				var userformcontainerObj = Ext.getCmp('userformcontainer');
				userformcontainerObj.child("#tab2").tab.setDisabled(true);
				btnNext.setDisabled(true);
				Ext.getCmp('org').hide();
			}
			me.setLangEntries(publicJSON.langEntries);
			var pwdLength = publicJSON.pwdLength;
			var pwdComplexityCount = publicJSON.pwdComplexityCount;
			if (pwdLength == "" || pwdLength < 2)
			{
				pwdLength = 8;
			}
			else if(pwdLength != "" && pwdLength < pwdComplexityCount)
			{
				pwdLength = pwdComplexityCount;
			}
			Ext.getCmp('passScore').setText(passLabel1+" "+pwdLength+" "+passLabel2);
		}
		else
		{
			userPrefContainerObj.remove(Ext.getCmp('userformcontainer'));
			userPrefContainerObj.add({xtype : 'errorpanel', border : false});
		}
	},
	setLangEntries : function(landEntriesJson)
	{
		for (var key in landEntriesJson)
		{
			var tmpObj = Ext.getCmp(key);
			if (tmpObj ==  null || tmpObj == 'undefined')
			{
				continue;
			}
			if (tmpObj.getXType() == "checkboxfield" || tmpObj.getXType() == "radiofield")
			{
				if (tmpObj.boxLabelEl == null || tmpObj.boxLabelEl == undefined || tmpObj.boxLabelEl == 'undefined')
				{
					continue;
				}
				tmpObj.boxLabelEl.update(landEntriesJson[key]);
			}
			else
			{
				tmpObj.setFieldLabel(landEntriesJson[key]);
			}
		}
	},
	updateUserPage : function(urlStr)
	{
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	showCommandInWindow : function(obj)
	{
		var commandVal = Ext.getCmp('customScript').getValue();
		obj.setDisabled(true);
		Ext.widget('window', {
			extend: 'Ext.panel.Panel',
			title: "Command",
			id : 'commandWindow',
			closeAction: 'destory',
			width: 625,
			height: 300,
			modal: true,
			scroll: true,
			autoScroll: true,
			doClose: function() {
				obj.setDisabled(false);
				this.destroy();
			},
			padding : '40px 5px 10px 5px',
			buttonAlign : 'center',
			items : [
			{
				xtype: 'textareafield',
				id : 'tmpTextArea',
				cls: 'text-area',
				fieldLabel : 'Command',
				height : 160,
				grow : true,
				value: commandVal,
				rows : 9,
				cols : 72
			}],
			buttons : [{
				text : 'Apply',
				id : 'applyCommand',
				cls: 'button20',
				margin: '0 0 10 0',
				handler: function()
				{
					obj.setDisabled(false);
					Ext.getCmp('customScript').setValue(Ext.getCmp('tmpTextArea').getValue());
					Ext.getCmp('commandWindow').destroy();
				}
			}]
			
		}).show();
	},
	showResultWindow : function(resultText,btObj)
	{
		var resultJsonObj = Ext.decode(resultText);
		var requestStatus = resultJsonObj['requestStatus'];
		var title = 'Domain Error';
		if (requestStatus != "success")
		{
			Ext.widget('window', {
				title: title,
				closeAction: 'destory',
				width: 600,
				height: 300,
				modal: true,
				scroll: true,
				autoScroll: true,
				doClose: function() {
					var me = this;
					btObj.setDisabled(false);
					this.destroy();
				},
				html: resultText
			}).show()
		}
	},
	showResultQBox : function(resultText)
	{
		var resultJsonObj = Ext.decode(resultText);
		var requestStatus = resultJsonObj['requestStatus'];
		var title = '';
		if (requestStatus == "success")
		{
			var resultObj = resultJsonObj['result'];
			title = resultObj.title;
		}
		else
		{
			var resultObj = resultJsonObj['errors'];
			title = resultObj.title;
		}
		Ext.widget('window', {
			title: title,
			closeAction: 'destory',
			width: 600,
			height: 300,
			scroll: true,
			autoScroll: true,
			doClose: function() {
				resultJsonObj = '';
				this.destroy();
			},
			html: resultText
		}).show()
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			if ((key == 'previousSelectedValue' || key == 'previousVMs' || key == 'previouscomponents' || key == 'previoussegments' || key == 'previousservicegroup' || key == 'previousservices' || key == 'previouszones' || key == 'previousExcVal' || key == 'previousextagts' || key == 'previousremagts') && !Ext.isEmpty(key))
			{
				continue;
			}

			if (key == "vsTypes")
			{
				continue;
			}
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	setHiddenFieldsToForm : function()
	{
		var hiddenFields = userElementJSON['hiddenFields'];
		var elementassociationformObj = Ext.getCmp('elementassociationform');
		var elementsHiddenContainerObj = Ext.getCmp('elementsHiddenContainer');
		for (key in hiddenFields)
		{
			if ((key == 'previousSelectedValue' || key == 'previousVMs' || key == 'previouscomponents' || key == 'previoussegments' || key == 'previousservicegroup' || key == 'previousservices' || key == 'previouszones' || key == 'previousExcVal' || key == 'previousextagts' || key == 'previousExcVal') && !Ext.isEmpty(key))
			{
				continue;
			}
			if (key == "vsTypes")
			{
				continue;
			}
			var keyValue  = hiddenFields[key];
			elementsHiddenContainerObj.add({xtype: 'hiddenfield',name : key,value : keyValue});
		}
	},
	moveTab : function(obj)
	{
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		userformcontainerObj.setActiveTab(1);
		obj.hide();
		Ext.getCmp('btnSubmit').show();
		Ext.getCmp('btnPrev').show();

		var selectedUserType = Ext.getCmp('utype').getValue();
		if (selectedUserType == "FannieMae-InfoSec"){
			Ext.getCmp('mailsmssettings').hide();
			Ext.getCmp('imgAdminPage').hide();
			Ext.getCmp('imgRepLogin').hide();
		}
	},
	movePreviousTab : function(obj)
	{
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		userformcontainerObj.setActiveTab(0);
		obj.hide();
		Ext.getCmp('btnSubmit').hide();
		Ext.getCmp('btnNext').show();
	},
	submitUserDetails : function(obj)
	{
		var me = this;
		var validationStatus = me.validateUserForm();
		if (validationStatus == true)
		{
			var assoUsers = me.getSelectedUsers();
			var servType = "";
			Ext.getCmp('selectedServerListGrid').getStore().each(function(rec)
			{
				if (!Ext.isEmpty(rec.get("valueField_1")))
				{
					servType+=rec.get("valueField_1") + ",";
				}
				if (!Ext.isEmpty(rec.get("valueField_2")))
				{
					servType+=rec.get("valueField_2") + ",";
				}
				if (!Ext.isEmpty(rec.get("valueField_3")))
				{
					servType+=rec.get("valueField_3") + ",";
				}
			});
			servType = servType.substring(0,servType.length-1);
			Ext.getCmp('interestedDomains').setValue(servType);
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			//var hiddenFields = this.getHiddenFields();
			var userForm = me.getMain().getForm();
			Ext.getCmp('availusers').setDisabled(true);
			var virtualServers = Ext.getCmp('virtualServers');
			if (virtualServers != null && virtualServers != undefined)
			{
				virtualServers.setDisabled(true);
			}
			if (userForm.isValid())
			{
				me.getMain().submit({
					url: 'EgChangeUserProfile/data/EgchangeuserprofilepJson.jsp?esCount='+inputs+'&newusers='+encodeURIComponent(assoUsers)+'&date='+new Date().getTime(),
					method: 'POST',
					//standardSubmit : true,
					success: function(form, action){
						myMask.hide();
						Ext.getCmp('availusers').setDisabled(false);
						if (virtualServers != null && virtualServers != undefined)
						{
							virtualServers.setDisabled(false);
						}
						var tmpJosnData = Ext.decode(action.response.responseText);

						var hiddenFieldsContainerObj = Ext.getCmp('auditsHiddenContainer');
						if (!Ext.isEmpty(hiddenFieldsContainerObj))
						{
							hiddenFieldsContainerObj.removeAll();
						}

						if (tmpJosnData.requestStatus == "success")
						{
							associatedUserIDs = assoUsers;
							var hasallcompaccess = tmpJosnData.hasallcompaccess;
							isAlarmEnabled = tmpJosnData.isAlarmEnabled;
							isFilterMailAlertsEnabled = tmpJosnData.isFilterMailAlertsEnabled;
							mailFilterOption = tmpJosnData.filterControlDefaultSelection

							var resutlObj = tmpJosnData.result;
							updateSettings = false;
							Ext.Msg.show({
								title: resutlObj.title,
								msg: resutlObj.message1,
								buttons: Ext.Msg.OK,
								width : 350,
								icon: 'iconInformation'
							});
							var selectedUserType = Ext.getCmp('utype').getValue();
							if(selectedUserType == 'FannieMae-InfoSec'){
								var userformcontainerObj = Ext.getCmp('userformcontainer');
								userformcontainerObj.setActiveTab(0);
							}
							else{
								if(resutlObj.message1=='The user has been modified successfully.')
								{
									var uname = Ext.getCmp('uname').getValue();
									var upass = Ext.getCmp('upass').getValue();
									var confpasswd = Ext.getCmp('confpasswd').getValue();
									if (tmpJosnData.isLSPortalUser != null && tmpJosnData.isLSPortalUser == true && tmpJosnData.sendUserDataToCMS != null && tmpJosnData.sendUserDataToCMS == 'true' && tmpJosnData.isPwdModified != null && tmpJosnData.isPwdModified == 'true')
									{
										jQuery.ajax({
											type: "POST",
											url: "https://www.eginnovations.com/solutions/product_pw_change.php",
											 data: {
												'Email': uname,
												'New_Password': upass
											},
											cache: false,
											success: function(result)
											{
												var resultRes = result;
											},
											error: function(error)
											{
												console.log(error);
											}
										});
									}
								}
								var tmpTabNumber = "1";
								if (hasallcompaccess == true)
								{
									if ((isAlarmEnabled == true || isAlarmEnabled == 'true' )&& (isFilterMailAlertsEnabled == true || isFilterMailAlertsEnabled == 'true'))
									{
										tmpTabNumber = "4";
									}
								}
								else
								{
									tmpTabNumber = "3";
								}

								var t_uname = Ext.getCmp('uname').getValue();
								var urlString = "EgChangeUserProfile/data/EgChangeUserProfileJson.jsp?selectedTab="+tmpTabNumber+"&qctr=1&username="+encodeURIComponent(t_uname)+"&date="+new Date().getTime();
								me.updateUserPage(urlString);
								me.getMain().getForm().reset();

								var rootNodeText = publicJSON['RootNodeText'];
								if (Ext.isEmpty(rootNodeText))
								{
									rootNodeText = 'Choose Organization / Organizational Unit / User';
								}

								var rootData = {
									text: rootNodeText,
									id: '-1',
									name: '-1',
									expanded: true,
									children:publicJSON['exportDataArr']
								};
								Ext.getCmp('uname').getStore().setRootNode(rootData);

								Ext.getCmp('uname').setValue(t_uname);
								me.loadUserProfileControls(true,'formSubmit');

								/*if (hasallcompaccess == false)
								{
									var resutlObj = tmpJosnData.result;
									Ext.Msg.alert(resutlObj.title,resutlObj.message1);
									me.loadUserElementsTab();
								}
								else if (isAlarmEnabled == true && isFilterMailAlertsEnabled == true)
								{
									var resutlObj = tmpJosnData.result;
									Ext.Msg.alert(resutlObj.title,resutlObj.message1);
									var userformcontainerObj = Ext.getCmp('userformcontainer');
									var elementAssociationTab = Ext.getCmp('elementAssociationTab');
									elementAssociationTab.removeAll();
									userformcontainerObj.child("#tab3").tab.hide();
									me.loadMailFilterAndConfigTab();
								}
								else
								{
									var userformcontainerObj = Ext.getCmp('userformcontainer');
									var elementAssociationTab = Ext.getCmp('elementAssociationTab');
									var elementFilteringTab = Ext.getCmp('elementFilteringTab');
									elementAssociationTab.removeAll();
									elementFilteringTab.removeAll();
									userformcontainerObj.child("#tab3").tab.hide();
									userformcontainerObj.child("#tab4").tab.hide();
									var resutlObj = tmpJosnData.result;
									Ext.Msg.alert(resutlObj.title,resutlObj.message1);
								}*/
							}
						}
						else
						{
							//me.showResultQBox(action.response.responseText);
							var resutlObj = tmpJosnData.errors;
							//var errorText = me.getErrorMessageTemplate(resutlObj);
							Ext.Msg.show({
								title: resutlObj.title,
								msg: resutlObj.message1,
								buttons: Ext.Msg.OK,
								width : 350,
								icon: 'iconError'
							});
							if (resutlObj.tabRedirect != null && resutlObj.tabRedirect != undefined && resutlObj.tabRedirect == "0")
							{
								var userformcontainerObj = Ext.getCmp('userformcontainer');
								userformcontainerObj.setActiveTab(0);
							}
						}
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						if (virtualServers != null && virtualServers != undefined)
						{
							virtualServers.setDisabled(false);
						}
						Ext.getCmp('availusers').setDisabled(false);
						Ext.Msg.show({
							title: "Ajax Failed",
							msg: "Could not update user details.",
							buttons: Ext.Msg.OK,
							icon: 'iconError'
						});
						
						var hiddenFieldsContainerObj = Ext.getCmp('auditsHiddenContainer');
						if (!Ext.isEmpty(hiddenFieldsContainerObj))
						{
							hiddenFieldsContainerObj.removeAll();
						}
						myMask.hide();
					}
				});
			}
		}
	},
	loadUserAssociations : function()
	{
		var userAssociateObj = Ext.getCmp('userAssociate');
		var tmpField = {
			layout : {
					type : 'hbox'
			},
			items :[
				{
					xtype:'label',
					text:'Available user(s)',
					id:'userLabel',
					width: 320,
				},
				{
					xtype:'multiselectorpanel',
					cls:'multiselect',
					height:80,
					items:[
					{
						xtype: 'multiselectSi',
						cls:"multiselect",
						autoScroll:true,
						scroll:true,
						width: 300,
						id: 'availusers',
						name: 'availusers',
						store: Ext.data.Store({
							fields: ['displayField','valueField'],
							data : publicJSON['availusers']
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local'
					}]
				}
			]
		}
		userAssociateObj.add(tmpField);
		userAssociateObj.doLayout();
	},
	loadUserTab : function(tabPanel, newCard, oldCard, eOpts)
	{
		var me = this;
		var utype = Ext.getCmp('utype').getValue();
		var username = Ext.getCmp('uname').getValue();
		var selectedConTab = newCard.itemId;
		var updateBtn = Ext.getCmp('btnSubmit');
		var btnNext = Ext.getCmp('btnNext');
		var mainObj = Ext.getCmp('main');
		var btnPrev = Ext.getCmp('btnPrev');
		if (selectedConTab == "tab1")
		{
			if(updateSettings == true)
			{
				Ext.Msg.show({
					title:pageTitle5,
					msg : pageIntn200,
					buttons : Ext.Msg.YESNO,
					icon : 'iconConfirmation',
					fn : function(response)
					{
						if(response == 'yes')
						{
							fromPreviousUpdate = 'Yes';
							me.submitUserDetails();
						}
						else
						{
							//fromPreviousUpdate = 'Yes';
							//me.loadUserProfileControls(false,'userCombo');
							//if(uTypeChange == true)
							{
								var urlString = "EgChangeUserProfile/data/EgChangeUserProfileJson.jsp?username="+encodeURIComponent(username)+"&selectedTab=1&qctr=1&date="+new Date().getTime();

								Ext.Ajax.request({
									url : urlString,
									method: 'POST',
									success: function(response)
									{
										var jsonText = response.responseText;
										publicJSON = Ext.decode(jsonText);
										Ext.getCmp('utype').setValue(publicJSON['utype']);
										fromPreviousUpdate = 'Yes';
										me.loadUserProfileControls(false,'formSubmit');
									}
								});
							}
						}
					}
				});
			}
			updateSettings = false;
			Ext.getCmp('btnNext').show();
			Ext.getCmp('btnSubmit').hide();
			if (reqFrom == "adduser")
			{
				mainObj.setTitle(pageTitle2);
			}
			else
			{
				mainObj.setTitle(pageTitle5);
			}
			me.hiddenParamsForAuditLog(publicJSON);
			updateBtn.hide();
			btnNext.show();
			btnPrev.hide();
		}
		if (selectedConTab == "tab2")
		{
			if(updateSettings == true)
			{
				Ext.Msg.show({
					title:pageTitle5,
					msg : pageIntn200,
					buttons : Ext.Msg.YESNO,
					icon : 'iconConfirmation',
					fn : function(response)
					{
						if(response == 'yes')
						{
							fromUpdatefirstTab = 'Yes';
							me.submitUserDetails();
						}
						else
						{
							
							//me.loadUserProfileControls(false,'userCombo');
							//if(uTypeChange == true)
							{
								var urlString = "EgChangeUserProfile/data/EgChangeUserProfileJson.jsp?username="+encodeURIComponent(username)+"&selectedTab=1&qctr=1&date="+new Date().getTime();
								Ext.Ajax.request({
									url : urlString,
									method: 'POST',
									success: function(response)
									{
										var jsonText = response.responseText;
										publicJSON = Ext.decode(jsonText);
										Ext.getCmp('utype').setValue(publicJSON['utype']);
										fromUpdatefirstTab = 'Yes';
										me.loadUserProfileControls(false,'formSubmit');
									}
								});
							}
						}
					}
				});
			}
			updateSettings = false;
			Ext.getCmp('btnNext').hide();
			Ext.getCmp('btnSubmit').show();
			//if (reqFrom == "adduser")
			//{
			//	mainObj.setTitle(pageTitle2);
			//}
			//else
			//{
			//	mainObj.setTitle(pageTitle5);
			//}
			me.hiddenParamsForAuditLog(publicJSON);
			updateBtn.show();
			btnNext.hide();
			btnPrev.show();
			mainObj.setTitle(pageTitle6 +" '"+changeDisplayName(selectedUserID)+"'");
			var selectedUserType = Ext.getCmp('utype').getValue();
			if (selectedUserType == "FannieMae-InfoSec"){
				Ext.getCmp('mailsmssettings').hide();
				Ext.getCmp('imgAdminPage').hide();
				Ext.getCmp('imgRepLogin').hide();
			}
		}
		else if (selectedConTab == "tab4")
		{
			if(updateSettings == true)
			{
				Ext.Msg.show({
					title:pageTitle5,
					msg : pageIntn200,
					buttons : Ext.Msg.YESNO,
					icon : 'iconConfirmation',
					fn : function(response)
					{
						if(response == 'yes')
						{
							me.submitUserDetails();
						}
						else
						{
							//me.loadUserProfileControls(false,'userCombo');
							//if(uTypeChange == true)
							{
								var urlString = "EgChangeUserProfile/data/EgChangeUserProfileJson.jsp?username="+encodeURIComponent(username)+"&selectedTab=1&qctr=1&date="+new Date().getTime();
								Ext.Ajax.request({
									url : urlString,
									method: 'POST',
									success: function(response)
									{
										var jsonText = response.responseText;
										publicJSON = Ext.decode(jsonText);
										Ext.getCmp('utype').setValue(publicJSON['utype']);
										me.loadUserProfileControls(false,'formSubmit');
									}
								});
							}
						}
					}
				});
			}
			updateSettings = false;
			mainObj.setTitle(pageTitle4 +" '"+changeDisplayName(selectedUserID)+"'");
			updateBtn.hide();
			btnNext.hide();
			btnPrev.hide();
			var tmpUserID = Ext.getCmp('uname').getValue();
			var url = "EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(tmpUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
			me.updateUserMailSuppressList(url);
			me.updateFilterComponents();
			if (mailFilterOption == "Descriptors_Only")
			{
				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').hide();
					Ext.getCmp('filterLabelID').show();
					me.showFilterDetails();
					Ext.getCmp('btnViewFilters').setText(pageIntnl97);
				}
			}
			else
			{
				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').show();
					Ext.getCmp('filterLabelID').hide();
					Ext.getCmp('btnViewFilters').setText(pageIntnl87);
				}
			}
		}
		else if (selectedConTab == "tab3")
		{
			if(updateSettings == true)
			{
				Ext.Msg.show({
					title:pageTitle5,
					msg : pageIntn200,
					buttons : Ext.Msg.YESNO,
					icon : 'iconConfirmation',
					fn : function(response)
					{
						if(response == 'yes')
						{
							me.submitUserDetails();
						}
						else
						{
							//me.loadUserProfileControls(false,'userCombo');
							//if(uTypeChange == true)
							{
								var urlString = "EgChangeUserProfile/data/EgChangeUserProfileJson.jsp?username="+encodeURIComponent(username)+"&selectedTab=1&qctr=1&date="+new Date().getTime();
								Ext.Ajax.request({
									url : urlString,
									method: 'POST',
									success: function(response)
									{
										var jsonText = response.responseText;
										publicJSON = Ext.decode(jsonText);
										Ext.getCmp('utype').setValue(publicJSON['utype']);
										me.loadUserProfileControls(false,'formSubmit');
									}
								});
							}
						}
					}
				});
			}
			updateSettings = false;
			var url = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?showAssociatedData=yes&qctr=1&selectedTab=3&assousers="+encodeURIComponent(associatedUserIDs)+"&username="+encodeURIComponent(selectedUserID)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom="+reqFrom+"&utype="+utype+"&date="+new Date().getTime();
			this.updateUserElementPage(url);
			mainObj.setTitle(pageTitle3 +" '"+changeDisplayName(selectedUserID)+"'");
			Ext.getCmp('elementUserID').setValue(selectedUserID);
			updateBtn.hide();
			btnNext.hide();
			btnPrev.hide();
		}

		Ext.Ajax.request({
			url: 'EgChangeUserProfile/data/changeusrprofilehelpJson.jsp?selectTab='+selectedConTab,
			method: 'POST',
			//async: false,
		});
	},
	updateFilterComponents : function()
	{
		var me = this;
		var elementFilteringTabObj = Ext.getCmp('elementFilteringTab');
		var isComponentsAssociated = userMailJSON.isComponentsAssociated;
		if (isComponentsAssociated == true)
		{
			var egmailalertsuppressObj = Ext.getCmp('egmailalertsuppress');
			if (egmailalertsuppressObj == null || egmailalertsuppressObj == 'undefined' || egmailalertsuppressObj == undefined)
			{
				elementFilteringTabObj.removeAll();
				elementFilteringTabObj.add({xtype : 'egmailalertsuppress'});
			}
			Ext.getCmp('filterUserID').setValue(selectedUserID);
		}
		else
		{
			var tmpUserID = Ext.getCmp('uname').getValue();
			var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No components have been associated for <b>'"+tmpUserID+"'</b></div>";
			elementFilteringTabObj.removeAll();
			elementFilteringTabObj.add({
				xtype : 'panel',
				border : false,
				padding:160,
				style:{'text-align':'center'},
				html:message
			});
		}
	},
	initUserElements : function()
	{
		if(!isEnterpriseModel)
		{
			var isShareAcrossOU = userElementJSON.shareNickAcrossOU != null && userElementJSON.shareNickAcrossOU != undefined && userElementJSON.shareNickAcrossOU;
			var superOrgName = userElementJSON.superOrgName;
			if((isShareAcrossOU && hideOrganization) || (!Ext.isEmpty(superOrgName) && superOrgName.toLowerCase() == 'egenterprise'))
			{
				var organizations = userElementJSON.organizations;
				var orgTypeObj = Ext.getCmp('orgType');
				orgTypeObj.getStore().loadRawData(organizations);
				orgTypeObj.setValue("-1");
				orgTypeObj.show();
			}
		}
		var associations = userElementJSON.associations;
		var associateObj = Ext.getCmp('associate');
		associateObj.getStore().loadRawData(associations);
		associateObj.setValue("-1");
		var tmpStore = Ext.getCmp('otherHosts');
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		//this.updateResultPanel();
		this.setLangEntries(userElementJSON.langEntries);
	},
	initUserMailConfigs : function()
	{
		var me = this;
		var queryStatus = userMailJSON.requestStatus;
		if (queryStatus == "success")
		{
			var tmpUserID = Ext.getCmp('uname').getValue();
			this.setLangEntries(userMailJSON.langEntries);
			var filters = userMailJSON.filters;
			var isComponentsAssociated = userMailJSON.isComponentsAssociated;
			if (isComponentsAssociated == true)
			{
				var associateObj = Ext.getCmp('filter');
				associateObj.getStore().loadRawData(filters);
				associateObj.setValue("-1");
				Ext.getCmp('CompTypes').hide();
				var tmpStore = Ext.getCmp('exclude');
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
			}
			else
			{
				var userformcontainerObj = Ext.getCmp('userformcontainer');
				var elementFilteringTabObj = Ext.getCmp('elementFilteringTab');
				var tmpUserID = Ext.getCmp('uname').getValue();
				var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No components have been associated for <b>'"+tmpUserID+"'</b></div>";
				elementFilteringTabObj.removeAll();
				elementFilteringTabObj.add({
					xtype : 'component',
					border : false,
					padding:160,
					style:{'text-align':'center'},
					html:message
				});
			}
		}
		else
		{
			var userformcontainerObj = Ext.getCmp('userformcontainer');
			var elementFilteringTabObj = Ext.getCmp('elementFilteringTab');
			var message = me.getErrorMessageTemplate(userMailJSON.errors);
			elementFilteringTabObj.removeAll();
			elementFilteringTabObj.add({
				xtype : 'component',
				border : false,
				padding:160,
				style:{'text-align':'center'},
				html:message
			});
		}
	},
	updateFilterResultPanel : function()
	{
				var me = this;
		var userFilterContainerObj = Ext.getCmp('userFilterContainer');
		var filters = userMailJSON.filters;
		userFilterContainerObj.removeAll();
		if (userMailJSON['isFiltersAvailable'] != null && userMailJSON['isFiltersAvailable'] != undefined && userMailJSON['isFiltersAvailable'] == true)
		{
			var excludedElements = userMailJSON.excludedElements;
			var gridHeaderMapping = userMailJSON.gridHeaderMapping;
			for (var key in excludedElements)
			{
				var gridObj = excludedElements[key];
				if (key == "excludedComponents" || key == "allExcludedLayersByType" || key == "exculdedTestsForAllTypes" || key == "exculdedDescriptor")
				{
					var gridTitle = gridHeaderMapping[key];
					if (gridObj == "" || gridObj.length == 0)
					{
						continue;
					}
					var tmpPanel = {
						xtype : 'panel',
						cls : 'outerpanel',
						border : false,
						width : '95%',
						title : gridTitle,
						html : gridObj
					}
					userFilterContainerObj.add(tmpPanel);
				}
				else
				{
					var gridTitle = gridHeaderMapping[key];
					if (Ext.isEmpty(gridObj))
					{
						continue;
					}
					var tmpResult = me.getGridPanel(gridObj,gridTitle);
					userFilterContainerObj.add(tmpResult);
				}
			}
			userFilterContainerObj.doLayout();
		}
		else
		{
			var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No elements are excluded for this user</b></div>";
			var tmpPanel = {
				xtype : 'component',
				border : false,
				padding : 120,
				html : message
			}
			userFilterContainerObj.add(tmpPanel);
		}
		Ext.getCmp('userFilterWindow').doLayout();
	},
	updateHTMLFilterResultPanel : function(urlStr)
	{
		var me = this;
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var userFilterContainerObj = Ext.getCmp('userFilterContainer');
				userFilterContainerObj.update(jsonText);
				Ext.getCmp('userFilterWindow').doLayout();
				delete jsonText;
				delete userFilterContainerObj;
			}
		});
	},
	updateDescriptorHTMLFiltePanel : function(urlStr)
	{
		var me = this;
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var userFilterContainerObj = Ext.getCmp('userFilterContainer');
				userFilterContainerObj.update(jsonText);
				Ext.getCmp('userFilterWindow').doLayout();
				delete jsonText;
				delete userFilterContainerObj;
			}
		});
	},
	updateFilterResultPanel2 : function()
	{
		var me = this;
		var userFilterContainerObj = Ext.getCmp('userFilterContainer');
		var filters = userMailJSON.filters;
		userFilterContainerObj.removeAll();
		if (userMailJSON['isFiltersAvailable'] != null && userMailJSON['isFiltersAvailable'] != undefined && userMailJSON['isFiltersAvailable'] == true)
		{
			var excludedElements = userMailJSON.excludedElements;
			var gridHeaderMapping = userMailJSON.gridHeaderMapping;
			for (var key in excludedElements)
			{
				var gridObj = excludedElements[key];
				if (key == "exculdedDescriptor")
				{
					var gridTitle = gridHeaderMapping[key];
					if (gridObj == "" || gridObj.length == 0)
					{
						continue;
					}
					var tmpPanel = {
						xtype : 'panel',
						cls : 'outerpanel',
						border : false,
						width : '95%',
						title : gridTitle,
						html : gridObj
					}
					userFilterContainerObj.add(tmpPanel);
				}
			}
		}
		else
		{
			var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No elements are included for this user</b></div>";
			var tmpPanel = {
				xtype : 'component',
				border : false,
				padding : 120,
				html : message
			}
			userFilterContainerObj.add(tmpPanel);
		}
		Ext.getCmp('userFilterWindow').doLayout();
	},
	getGridPanel : function(gridArray,gridTitle)
	{
		var fieldstoStore =  new Array();
		fieldstoStore.push("compType_1");
		fieldstoStore.push("compType_2");
		fieldstoStore.push("compType_3");
		var mainColumnsObjArray	=  new Array();
		var itemsArray	=  new Array();
		for (var key in fieldstoStore)
		{
			var gridColumn = fieldstoStore[key];
			mainColumnsObjArray.push({
				header: gridColumn,
				dataIndex: gridColumn,
				align:'left',
				flex:1
			});
		}
		var gridpanel = Ext.widget('usergridpanel',{
			store:new Ext.data.Store({
				fields: fieldstoStore,
				data: gridArray
			}),
			sortableColumns:false,
			cls:'gridSkin',
			title : gridTitle,
			width : '95%',
			columns:mainColumnsObjArray,
			viewConfig: {
				forceFit: true,
				stripeRows : false
			},
			sortable: false,
			hideable: false,
			hideHeaders : true
		});
		return gridpanel;
	},
	//showComponentSelector : function()
	//{
		//var me = this;
		//if (Ext.getCmp('componentWinSelector') == undefined)
		//{
			//var cloneStore = Ext.getCmp('compName').getStore();
			//var expandWindow = Ext.create('Ext.window.Window',{
					//title:'Components',
					//id : 'componentWinSelector',
					////width:650,
					////height:370,
					//doClose: function() {
						//this.destroy();
					//},
					//buttonAlign:'center',
					//items:[
						//{
							//xype:'container',
							//cls:'multisearchlist',
							//width: 580,
							//layout : {
								//type : 'hbox',
								//pack : 'center'
							//},
							//margin : '5 5 0 5',
							//items:[
							//{
								//xtype: 'trigger',
								//name:'componentSearch',
								//id:'componentSearch',
								//trigger1Cls: 'x-form-clear-trigger',
								//trigger2Cls: 'x-form-search-trigger', 
								//cls: 'whitedropdown_search',
								//emptyText:'Search',
								//margin: '5 5 5 5',
								//labelAlign: 'top',
								//width: 400,
								//getTriggerMarkup: function() {
									//var me = this,
										//i = 0,
										//hideTrigger = (me.readOnly || me.hideTrigger),
										//triggerCls,
										//triggerBaseCls = me.triggerBaseCls,
										//triggerConfigs = [],
										//unselectableCls = Ext.dom.Element.unselectableCls,
										//style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
										//cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

									//// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
									//// single triggerCls config. Should rethink this, perhaps something more structured like a list of
									//// trigger config objects that hold cls, handler, etc.
									//// triggerCls is a synonym for trigger1Cls, so copy it.
									//if (!me.trigger1Cls) {
										//me.trigger1Cls = me.triggerCls;
									//}

									//// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
									//for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

										//if (i == 0)
										//{
											//triggerConfigs.push({
												//tag: 'td',
												//role: 'presentation',
												//valign: 'top',
												//cls: cls,
												//id : 'MyTrigger_'+i,
												//style: style + "display:none;",
												//cn: {
													//cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													//role: 'presentation'
												//}
											//});
										//}
										//else
										//{
											//triggerConfigs.push({
												//tag: 'td',
												//role: 'presentation',
												//valign: 'top',
												//cls: cls,
												//id : 'MyTrigger_'+i,
												//style: style,
												//cn: {
													//cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													//role: 'presentation'
												//}
											//});
										//}
									//}
									//triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

									//return Ext.DomHelper.markup(triggerConfigs);
								//},
								//onTrigger1Click : function() { 
									//this.reset(); 
								//},
								//onTriggerClick: function()
								//{
									//me.egTitleSearch(this.getValue());
								//},
								//listeners : {
									//specialkey: function(field, e)
									//{
										//// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN, // e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN 
										//if(e.getKey() == e.ENTER) 
										//{ 
											//me.egTitleSearch(field.getValue());
										//}
									//}
								//}
							//}]
						//},
						//{
							//xtype: 'multiselectfieldSi',
							//margin : '0 5 5 5',
							//autoScroll:true,
							//scroll:true,
							//name: 'multiselect',
							//id: 'componentClonedID',
							//store: cloneStore,
							//value: Ext.getCmp('compName').getValue(),
							//displayField: 'displayField',
							//valueField: 'valueField',
							//queryMode: 'local',
							//width: 580,
							//height:230
						//}
					//],
					//buttons:[
						//{
							//text:'Select',
							//id: 'expand',
							//cls:'button20',
							//name: 'expand',
							//handler: function()
							//{
								//if (Ext.getCmp('componentClonedID').getValue() != '' )
								//{
									//var selectedList = Ext.getCmp('componentClonedID').getValue();
									//Ext.getCmp('compName').setValue(selectedList);
									//expandWindow.destroy();
								//}
							//}
						//}
					//]
			//}).show();
		//}
	//},
	egTitleSearch : function(id)
	{
		var value = id.value;
		var cloneStore = Ext.getCmp('compName').getStore();
		var clonedStore = compNameArrTemp;
		var compNameObj = Ext.getCmp('compName');
		var excludeItemObj = Ext.getCmp('exclude');
		excludeItemObj.getStore().removeAll();
		if(excludeItemObj.fromField.store.getCount() > 0)
		{
			excludeItemObj.fromField.store.removeAll();
		}
		if(excludeItemObj.toField.store.getCount() > 0)
		{
			excludeItemObj.toField.store.removeAll();
		}

		if (Ext.isEmpty(value))
		{
			Ext.get('MyTrigger_searchbox_0').setStyle('display','none');
			Ext.get('MyTrigger_searchbox_1').setStyle('display','block');
			//compNameObj.getStore().clearFilter(true);
			compNameObj.getStore().loadRawData(compNameArrTemp);
		}
		else
		{
			Ext.get('MyTrigger_searchbox_1').setStyle('display','none');
			Ext.get('MyTrigger_searchbox_0').setStyle('display','block');
			//clonedStore.filter('displayField',value);
			var compNameObj = Ext.getCmp('compName');
			var findVal = value;
			var isRecordFound = false;
			//var genStore = new Ext.data.Store({
			//						fields : ['displayField','valueField'],
			//						data : []                                
			//					});
			var genStoreArr = new Array();
			for ( var i = 0; i < clonedStore.length ; i++ )
			{
				var getRecord = clonedStore[i]['displayField'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStoreArr.push({
						'displayField': clonedStore[i]['displayField'],
						'valueField': clonedStore[i]['valueField'],
					});
				}
			}

			compNameObj.getStore().removeAll();    
			if ( isRecordFound )
			{
				compNameObj.getStore().loadRawData(genStoreArr);
				//for ( var i = 0; i < genStore.getCount() ; i++ )
				//{
					//var getRecord = genStore.getAt(i);
					//compNameObj.getStore().add(getRecord);
				//}
			}
			else
			{
				compNameObj.store.loadData({
						'displayField': 'No data found',
						'valueField': '-1',
					},true);
			}
			Ext.getCmp('searchbox').focus();
		}
	},
	popFilterDetails : function(obj)
	{
		var me = this;
		updateSettings = false;
		var page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
		var selectedOption = obj.getValue();
		if(selectedOption != "-1")
		{
			page = page+"&filterBy="+selectedOption;
			if(selectedOption == "filterByCName" || selectedOption == "filterByDescriptor")
			{
				page = page + "&serverType=-1";
			}
			else if(selectedOption == "filterByLayer" || selectedOption == "filterByTest")
			{
				page = page + "&serverType=filterByAll";
			}
			page = page + "&date="+new Date().getTime();
			//me.updateUserMailSuppressList(page);
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						//tmpStore.getStore().loadRawData(excludedItems);
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}
					var compTypeContainer = Ext.getCmp('CompTypes');
					var compTypesInCt = Ext.getCmp('compTypesIn');
					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					compTypeContainer.hide();
					compTypesInCt.hide();
					serverTestsOuterCt.hide();
					Ext.getCmp('serseg').hide();
					if(selectedOption == "filterByCName" || selectedOption == "filterByLayer" || selectedOption == "filterByTest" || 
						selectedOption == "filterByDescriptor")
					{
						var tmpCompObj = Ext.getCmp('CompTypes');
						var compopnentTypes = userMailJSON['compopnentTypes'];
						tmpCompObj.getStore().loadRawData(compopnentTypes);
						if (selectedOption == "filterByCName" || selectedOption == "filterByDescriptor")
						{
							tmpCompObj.setValue("-1");
						}
						else
						{
							tmpCompObj.setValue("filterByAll");
						}
						if (userMailJSON.isOtherGroupsFound)
						{
							compTypesInCt.getStore().loadRawData(userMailJSON.viewBy);
							compTypesInCt.setValue(userMailJSON.displayText);
							compTypesInCt.show();
							if (compTypesInCt.getValue() != 'cType')
							{
								Ext.getCmp('serseg').show();
							}
						}
						else
						{
							compTypesInCt.hide();
						}

						compTypeContainer.show();
						if (selectedOption == "filterByDescriptor")
						{
							var testObj = Ext.getCmp('Test');
							Ext.getCmp('compName').getStore().removeAll();
							serverTestsOuterCt.show();
							Ext.getCmp('searchbox').setDisabled(true);
							Ext.getCmp('searchbox').setValue('');
							testObj.show();
							testObj.getStore().removeAll();
							testObj.getStore().loadRawData(userMailJSON.testArray);
							testObj.setValue("-1");
						}
					}
					var testTypeObj = Ext.getCmp('TestTypes');
					if(isConfigEnabled == "true")
					{
						if(selectedOption == "filterByTest")
						{
							testTypeObj.show();
							testTypeObj.getStore().removeAll();
							testTypeObj.getStore().loadRawData(userMailJSON.testTypesArr);
							testTypeObj.setValue("performance");
						}
						else
						{
							testTypeObj.hide();
						}
					}
					else
					{
						testTypeObj.hide();
					}
					tmpStore.fromField.getComponent(0).setTitle(userMailJSON['itemTitle1']);
					tmpStore.toField.getComponent(0).setTitle(userMailJSON['itemTitle2']);
				}
			});
		}
		else
		{
			Ext.suspendLayouts();
			var tmpStore = Ext.getCmp('exclude');
			tmpStore.fromField.getComponent(0).setTitle("Excluded from alerts");
			tmpStore.toField.getComponent(0).setTitle("Included for alerts");
			Ext.getCmp('CompTypes').hide();
			Ext.getCmp('compTypesIn').hide();
			Ext.getCmp('serseg').hide();
			Ext.getCmp('serverTestsOuterCt').hide();
			Ext.resumeLayouts(true);
		}
	},
	showFilterDetails : function(obj)
	{
		var me = this;
		var page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&filterBy=filterByDescriptor&reqfrom="+reqFrom;

		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				var includedItems = userMailJSON['includedAlerts'];
				var excludedItems = userMailJSON['excludedAlerts'];
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(excludedItems))
				{
					tmpStore.fromField.store.add(excludedItems);
				}
				if (!Ext.isEmpty(includedItems))
				{
					tmpStore.toField.store.add(includedItems);
				}
				var compTypeContainer = Ext.getCmp('CompTypes');
				var compTypesInCt = Ext.getCmp('compTypesIn');
				var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
				compTypeContainer.hide();
				compTypesInCt.hide();
				serverTestsOuterCt.hide();
				Ext.getCmp('serseg').hide();
				//if(selectedOption == "filterByCName" || selectedOption == "filterByLayer" || selectedOption == "filterByTest" || 
				//	selectedOption == "filterByDescriptor")
				{
					var tmpCompObj = Ext.getCmp('CompTypes');
					var compopnentTypes = userMailJSON['compopnentTypes'];
					tmpCompObj.getStore().loadRawData(compopnentTypes);
					tmpCompObj.setValue("-1");
					if (userMailJSON.isOtherGroupsFound)
					{
						compTypesInCt.getStore().loadRawData(userMailJSON.viewBy);
						compTypesInCt.setValue(userMailJSON.displayText);
						compTypesInCt.show();
						if (compTypesInCt.getValue() != 'cType')
						{
							Ext.getCmp('serseg').show();
						}
					}
					else
					{
						compTypesInCt.hide();
					}

					compTypeContainer.show();
					var testObj = Ext.getCmp('Test');
					Ext.getCmp('compName').getStore().removeAll();
					serverTestsOuterCt.show();
					testObj.show();
					testObj.getStore().removeAll();
					testObj.getStore().loadRawData(userMailJSON.testArray);
					testObj.setValue("-1");
				}
			}
		});
	},
	viewByCriteria : function(obj)
	{
		updateSettings = false;
		var viewByValue = obj.getValue();
		var filterObj = Ext.getCmp('filter');
		var filterBy = filterObj.getValue();
		var sersegObj = Ext.getCmp('serseg');
		var compTypes = Ext.getCmp('CompTypes');
		var testCombo = Ext.getCmp('Test');
		var page = "";
		var me = this;
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(viewByValue)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}

					if (viewByValue != 'cType')
					{
						sersegObj.setFieldLabel(userMailJSON.trDisplayText);
						sersegObj.getStore().loadRawData(userMailJSON.viewByType);
						sersegObj.setValue(userMailJSON.selectedGrpText);
						sersegObj.show();
						compTypes.getStore().removeAll();
						compTypes.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						testCombo.getStore().removeAll();
						testCombo.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
					}
					else
					{
						me.popFilterDetails(filterObj);
						sersegObj.hide();
					}
					if(compTypes.getStore().getCount() > 0)
					{
						compTypes.setValue(compTypes.getStore().getAt(0));
					}
					if(testCombo.getStore().getCount() > 0)
					{
						testCombo.setValue(testCombo.getStore().getAt(0));
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(viewByValue)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}

					if (viewByValue != 'cType')
					{
						sersegObj.setFieldLabel(userMailJSON.trDisplayText);
						sersegObj.getStore().loadRawData(userMailJSON.viewByType);
						sersegObj.setValue(userMailJSON.selectedGrpText);
						sersegObj.show();
						compTypes.getStore().removeAll();
						compTypes.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						testCombo.getStore().removeAll();
						testCombo.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
					}
					else
					{
						me.popFilterDetails(filterObj);
						sersegObj.hide();
					}
					if(compTypes.getStore().getCount() > 0)
					{
						compTypes.setValue(compTypes.getStore().getAt(0));
					}
					if(testCombo.getStore().getCount() > 0)
					{
						testCombo.setValue(testCombo.getStore().getAt(0));
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	changeByServer : function(obj)
	{
		updateSettings = false;
		var viewByServer = obj.getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var CompTypesObj = Ext.getCmp('CompTypes');
		var testCombo = Ext.getCmp('Test');
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(viewByServer)+"&date="+new Date().getTime();
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(viewByServer)+"&date="+new Date().getTime();
		}

		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				CompTypesObj.getStore().loadRawData(userMailJSON.compopnentTypes);
				if(viewByServer == "-1")
				{
					CompTypesObj.getStore().removeAll();
					CompTypesObj.getStore().loadData([
						{
							'displayField' : 'Not Applicable',
							'valueField' : '-1'
						}
					]);
				}
				testCombo.getStore().removeAll();
				testCombo.getStore().loadData([
					{
						'displayField' : 'Not Applicable',
						'valueField' : '-1'
					}
				]);
				Ext.getCmp('compName').getStore().removeAll();
				Ext.getCmp('searchbox').setDisabled(true);
				Ext.getCmp('searchbox').setValue('');
				if(CompTypesObj.getStore().getCount() > 0)
				{
					CompTypesObj.setValue(CompTypesObj.getStore().getAt(0));
				}
				if(testCombo.getStore().getCount() > 0)
				{
					testCombo.setValue(testCombo.getStore().getAt(0));
				}
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	changeByTest : function(obj)
	{
		updateSettings = false;
		var viewByTest = obj.getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var serseg = Ext.getCmp('serseg').getValue();
		var configTestType = "no";
		if(isConfigEnabled == "true")
		{
			var testType = Ext.getCmp('TestTypes').getValue();
			if(testType == "configuration")
			{
				configTestType = "yes";
			}
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		if (!Ext.isEmpty(viewByTest) && viewByTest == '-1')
		{
			Ext.getCmp('searchbox').setDisabled(true);
			Ext.getCmp('searchbox').setValue('');
		}
		else
		{
			Ext.getCmp('searchbox').setDisabled(false);
			Ext.getCmp('searchbox').setValue('');
		}
		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				var compNameObj = Ext.getCmp('compName');
				compNameObj.getStore().loadRawData(userMailJSON.compNameArr);
				compNameArrTemp = userMailJSON.compNameArr;
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	changeByComponentName : function(obj)
	{
		var compNames = obj.getValue();
		if(compNames == "" || compNames == "-1")
		{
			var excludeItemObj = Ext.getCmp('exclude');
			excludeItemObj.getStore().removeAll();
			if(excludeItemObj.fromField.store.getCount() > 0)
			{
				excludeItemObj.fromField.store.removeAll();
			}
			if(excludeItemObj.toField.store.getCount() > 0)
			{
				excludeItemObj.toField.store.removeAll();
			}
			return;
		}
		var filterBy = Ext.getCmp('filter').getValue();
		var Test = Ext.getCmp('Test').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var compTypesInObj = Ext.getCmp('compTypesIn');

		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compNames="+encodeURIComponent(compNames)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(Test);

			if (userMailJSON.isOtherGroupsFound == true)
			{
				var compTypesIn = compTypesInObj.getValue();
				page = page + "&compTypesIn="+compTypesIn;

				if (compTypesInObj.getValue() != 'cType')
				{
					var sersegObj = Ext.getCmp('serseg');
					if(sersegObj!=null && sersegObj!=undefined)
					{
						var sersegVal = sersegObj.getValue();
						if(sersegVal!=null && sersegVal!=undefined && sersegVal!="")
						{
							page = page + "&serseg="+sersegVal;
						}
					}
				}
			}

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					if (!Ext.isEmpty(includedItems))
					{
						//tmpStore.fromField.store.add(excludedItems);
						tmpStore.fromField.store.add(includedItems);
					}
					if (!Ext.isEmpty(excludedItems))
					{
						//tmpStore.toField.store.add(includedItems);
						tmpStore.toField.store.add(excludedItems);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compNames="+encodeURIComponent(compNames)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(Test);

			if (userMailJSON.isOtherGroupsFound == true)
			{
				var compTypesIn = compTypesInObj.getValue();
				page = page + "&compTypesIn="+compTypesIn;

				if (compTypesInObj.getValue() != 'cType')
				{
					var sersegObj = Ext.getCmp('serseg');
					if(sersegObj!=null && sersegObj!=undefined)
					{
						var sersegVal = sersegObj.getValue();
						if(sersegVal!=null && sersegVal!=undefined && sersegVal!="")
						{
							page = page + "&serseg="+sersegVal;
						}
					}
				}
			}

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	popCompTypes : function(obj)
	{
		updateSettings = false;
		var tmpUserID = Ext.getCmp('uname').getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var serverType = obj.getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var serseg = Ext.getCmp('serseg').getValue();
		var configTestType = "no";
		if(isConfigEnabled == "true")
		{
			var testType = Ext.getCmp('TestTypes').getValue();
			if(testType == "configuration")
			{
				configTestType = "yes";
			}
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page+"&filterBy=filterByDescriptor&serverType="+encodeURIComponent(serverType)+"&date="+new Date().getTime()+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg);
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}

					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					var testCt = Ext.getCmp('Test');
					//if (filterBy == "filterByDescriptor")
					{
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
						testCt.getStore().removeAll();
						Ext.getCmp('compName').getStore().removeAll();
						testCt.getStore().loadRawData(userMailJSON.testArray);
						testCt.setValue(userMailJSON.selectedDescriptorText);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy="+filterBy+"&serverType="+encodeURIComponent(serverType)+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&date="+new Date().getTime();

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}

					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					var testCt = Ext.getCmp('Test');
					//var serverTestsCt = Ext.getCmp('serverTestsCt');
					if (filterBy == "filterByDescriptor")
					{
						testCt.getStore().removeAll();
						testCt.getStore().loadRawData(userMailJSON.testArray);
						testCt.setValue(userMailJSON.selectedDescriptorText);
						serverTestsOuterCt.show();
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
						testCt.show();
						//serverTestsCt.hide();
					}
					else
					{
						serverTestsOuterCt.hide();
						testCt.hide();
						//serverTestsCt.hide();
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		//this.updateUserMailSuppressList(page);

		
	},
	popTestTypes : function(obj)
	{
		updateSettings = false;
		var filterBy = Ext.getCmp('filter').getValue();
		var testType = obj.getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var serseg = Ext.getCmp('serseg').getValue();
		
		var configTestType = "no";
		if(testType == "configuration")
		{
			configTestType = "yes";
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="EgChangeUserProfile/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		else
		{
			page ="EgChangeUserProfile/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&serverType="+encodeURIComponent(compTypes)+"&configTestType="+configTestType;
			page = page + "&filterBy="+filterBy+"&serverType="+encodeURIComponent(serverType)+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&date="+new Date().getTime();
		}
		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				var includedItems = userMailJSON['includedAlerts'];
				var excludedItems = userMailJSON['excludedAlerts'];
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(excludedItems))
				{
					tmpStore.fromField.store.add(excludedItems);
				}
				if (!Ext.isEmpty(includedItems))
				{
					tmpStore.toField.store.add(includedItems);
				}
				var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
				var testCt = Ext.getCmp('Test');
				//var serverTestsCt = Ext.getCmp('serverTestsCt');
				if (filterBy == "filterByDescriptor")
				{
					testCt.getStore().removeAll();
					testCt.getStore().loadRawData(userMailJSON.testArray);
					testCt.setValue(userMailJSON.selectedDescriptorText);
					serverTestsOuterCt.show();
					Ext.getCmp('compName').getStore().removeAll();
					Ext.getCmp('searchbox').setDisabled(true);
					Ext.getCmp('searchbox').setValue('');
					testCt.show();
					//serverTestsCt.hide();
				}
				else
				{
					serverTestsOuterCt.hide();
					testCt.hide();
					//serverTestsCt.hide();
				}
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	getSelectedUsers : function()
	{
		var asso_users="";
		if(Ext.getCmp('chkuser').getValue() == true)
		{
			var tmpAssoStore= Ext.getCmp('availusers').getSelected();
			for (var key in tmpAssoStore)
			{
				asso_users = asso_users+tmpAssoStore[key].get("valueField")+"~,~";	
			}
			if(asso_users.length>0)
			{
				asso_users = asso_users.substring(0,asso_users.length-3);
			}
		}
		return asso_users;
	},
	updateResultPanel : function()
	{
		var isElementsAssociated = userElementJSON.isElementsAssociated;
		var userAssociationContainer = Ext.getCmp('userAssociationContainer');
		var elementassociationcontainer = Ext.getCmp('elementassociationcontainer');
		userAssociationContainer.removeAll();
		if (isElementsAssociated == true)
		{
			
			userAssociationContainer.add(
				{
				xtype : 'componentgroupedsummarygrid',
				store: new Ext.data.Store({
					fields: ['col_1', 'category','col_2','col_3'],
					groupField: 'category',
					data: userElementJSON.userTableData,
				})
			});
			userAssociationContainer.doLayout();
			Ext.getCmp('Expand').show();
		}
		else
		{
			Ext.getCmp('Expand').hide();
			var message = "<div class = \"iconInformation\" style=\"margin:12% auto auto auto\"></div><div>"+intnlLabel5+".</div>";
			var tmpPanel = {
				xtype : 'component',
				width : '100%',
				border : false,
				style:{'text-align':'center'},
				html : message
			}
			userAssociationContainer.add(tmpPanel);
		}
	},
	updateUserMailSuppressList : function(urlStr)
	{
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userMailJSON = Ext.decode(jsonText);
			}
		});
	},
	updateUserElementPage : function(urlStr)
	{
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userElementJSON = Ext.decode(jsonText);
			}
		});
	},
	validateUserForm : function(from)
	{
		var me = this;
		var userformcontainerObj = Ext.getCmp('userformcontainer');
		var tmpUname = Ext.getCmp('uname').getValue();
		if (tmpUname == "-1" || tmpUname == "none")
		{
			Ext.Msg.alert(pageTitle,userIDValidationMsg2);
			userformcontainerObj.setActiveTab(0);
			return false;
		}

		var org = Ext.getCmp('org').getValue();
		if (org == "-1" || org == "none")
		{
			Ext.Msg.alert(pageTitle,userIDValidationMsg74,function(btn){
				if (btn == "ok")
				{
					Ext.getCmp('org').focus(true);
				}
			});
			userformcontainerObj.setActiveTab(0);
			return false;
		}

		var tmpUtype = Ext.getCmp('utype').getValue();
		if (tmpUtype == "-1" || tmpUtype == "none")
		{
			Ext.Msg.alert(pageTitle,userRoleValidationMsg,function(btn){
				if (btn == "ok")
				{
					Ext.getCmp('utype').focus(true);
				}
			});
			userformcontainerObj.setActiveTab(0);
			return false;
		}
		var monitoraccess = publicJSON['hasmonitoraccess'];
		var pwdminlen = publicJSON['pwdLength'];
		var pwdComplexityCount = publicJSON['pwdComplexityCount'];
		if (pwdminlen == "" || pwdminlen < 2)
		{
			pwdminlen = 8;
		}
		else if(pwdminlen != "" && pwdminlen < pwdComplexityCount)
		{
			pwdminlen = pwdComplexityCount;
		}
		var checkStr = "";
		var radioval = "";
		var msgmode = "";
		var high = "";
		var medium = "";
		var low = "";
		var sub = true;
		var utype = Ext.getCmp('utype').getValue();
		var never = Ext.getCmp('Never').getValue();
		var tomail;
		var ccmail;
		var bccmail;
		var customScr;//add by sunder
		var escmail;
		var checkToStr
		var checkCcStr;
		var checkBccStr;
		var checkScriptStr;//add by sunder
		var checkEscStr;
		var orStr = " or ";
		var sep="'";

		tomail= Ext.getCmp('tomailid');
		ccmail = Ext.getCmp('ccmailid');
		bccmail = Ext.getCmp('bccmailid');

		checkToStr = tomail.getValue();
		checkCcStr = ccmail.getValue();
		checkBccStr = bccmail.getValue();

		if(monitoraccess == true || monitoraccess == 'true')
		{
			//tomail= Ext.getCmp('tomailid');
			//ccmail = Ext.getCmp('ccmailid');
			//bccmail = Ext.getCmp('bccmailid');
			escmail = Ext.getCmp('escmailid');
			customScr =  Ext.getCmp('customScript');

			//checkToStr = tomail.getValue();
			//checkCcStr = ccmail.getValue();
			//checkBccStr = bccmail.getValue();
			checkScriptStr = customScr.getValue();
			checkEscStr = escmail.getValue();
		}	
		var tilldate = Ext.getCmp('tilldate').getValue();
		var tilldate_h = Ext.getCmp('tilldate_h').getValue();
		var hiddenFields = publicJSON.hiddenFields;

		var tillhr = hiddenFields.endHr;
		var tillmin = hiddenFields.endMin;
		var currentdate = hiddenFields.currentdate;
		var currenthr = hiddenFields.startHr;
		var currentmin = hiddenFields.startMin;
		var eedateforpro;
		var authType='';

		if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
		{
			if (Ext.getCmp('eGAuthSAML').getValue() == true)
			{
				authType ='Eg';
			}
			else if (Ext.getCmp('idpAuthSAML').getValue() == true)
			{
				authType ='SAML';
			}
			else
			{
				authType = 'Domain';
			}
		}
		else
		{
			if (Ext.getCmp('eGAuth').getValue() == true)
			{
				authType ='Eg';
			}
			else
			{
				authType = 'Domain';
			}
		}
		var user_Id = true;
		var user_pwd = true;
		var regExp1=/^(\+\d\d)?[0-9]+$/g;
		var reg3 = /(((([\+]?([0-9]){4,15})|([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])+)\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z])|((\+\d\d)?[0-9]+))/g

		var tmpVal1 = Ext.getCmp('tomailid').getValue();
		var tmpVal2 = Ext.getCmp('ccmailid').getValue();
		var tmpVal3 = Ext.getCmp('bccmailid').getValue();
		var tmpVal4 = Ext.getCmp('escmailid').getValue();

		var toMailResult=validateEmail(tmpVal1);
		var ccMailResult=validateEmail(tmpVal2);
		var bccMailResult=validateEmail(tmpVal3);
		var escMailResult=validateEmail(tmpVal4);

		var toMobResult=(tmpVal1).match(regExp1);
		var ccMobResult=(tmpVal2).match(regExp1);
		var bccMobResult=(tmpVal3).match(regExp1);
		var escMobResult=(tmpVal4).match(regExp1);

		var toResult=(tmpVal1).match(reg3);
		var ccResult=(tmpVal2).match(reg3);
		var bccResult=(tmpVal3).match(reg3);
		var escResult=(tmpVal4).match(reg3);

		if (authType == 'Eg')
		{
			var passObj =  Ext.getCmp('upass');
			var cpassObj =  Ext.getCmp('confpasswd');
			var loginPassword = Ext.getCmp('upass').getValue();
			var cloginPassword = Ext.getCmp('confpasswd').getValue();
			var oldPass = publicJSON['changeObj'];
			var pwdComplexity = me.pwdComplexityCheck(loginPassword);
			if(loginPassword == "")
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg7,function(btn){
					if (btn == "ok")
					{
						passObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!checkloginpass(loginPassword))
			{
				userformcontainerObj.setActiveTab(0);
				passObj.focus(true);
				return false;
			}
			else if ((oldPass != loginPassword) && (loginPassword.length < pwdminlen))
			{
				Ext.Msg.alert(pageTitle,passLabel1+" "+pwdminlen+" "+passLabel2,function(btn){
					if (btn == "ok")
					{
						passObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(pwdComplexity.indexOf("false") > -1)
			{
				var resMsg = pwdComplexity.substring(pwdComplexity.indexOf("false#")+6);
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg73+". "+passLabel1+" "+resMsg+".",
					width : 400,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						passObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!user_pwd)
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg9,function(btn){
					if (btn == "ok")
					{
						passObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(cloginPassword == "")
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg10,function(btn){
					if (btn == "ok")
					{
						cpassObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!checkloginpass(cloginPassword))
			{
				userformcontainerObj.setActiveTab(0);
				cpassObj.focus(true);
				return false;
			}
			else if(loginPassword != cloginPassword)
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg11,function(btn){
					if (btn == "ok")
					{
						cpassObj.focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
		}

		if((checkToStr != "") && (toMailResult==false && toMobResult == null) && (toResult != tmpVal1))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg15 +".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					tomail.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(tmpVal1))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg16 +".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					tomail.focus(true);
				}
			});
			return false;
		}
		else if((checkCcStr != "") && (ccMailResult==null || ccMailResult==false) && ccMobResult == null && (ccResult!= tmpVal2))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg17 +".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					ccmail.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(tmpVal2))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg18 +".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					ccmail.focus(true);
				}
			});
			return false;
		}
		else if((checkBccStr != "") && (bccMailResult==null || bccMailResult==false) && bccMobResult == null && bccResult != tmpVal3)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg19 +".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					bccmail.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(tmpVal3))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: userIDValidationMsg20 +".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					bccmail.focus(true);
				}
			});
			return false;
		}
		
		if(Ext.getCmp('Never').getValue() == false)
		{
			var comFormat = "";
			var ssdate = currentdate;

			var eedateforpro = formatDate(new Date(getDateFromFormat(Ext.getCmp('tilldate_h').getValue(),currentDFormat)),"MM/dd/yyyy");
			Ext.getCmp('dateforpro').setValue(eedateforpro);
			if(!checkblank(tilldate))
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg13,function(btn){
					if (btn == "ok")
					{
						Ext.getCmp('tmptilldate').focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
			else if(!checkUserValidityTime(ssdate,eedateforpro,currenthr,tillhr,currentmin,tillmin))
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg14,function(btn){
					if (btn == "ok")
					{
						Ext.getCmp('tmptilldate').focus(true);
					}
				});
				userformcontainerObj.setActiveTab(0);
				return false;
			}
		}

		if(from == "logoUpload")
		{
			return 'userValid';//if valform called from logoUpload return back,after checking valid uName;
		}

		if(monitoraccess==true || monitoraccess=='true')
		{
			var high = Ext.getCmp('high').getValue();
			var medium = Ext.getCmp('medium').getValue();
			var low = Ext.getCmp('low').getValue();
			var a_high = Ext.getCmp('alarm_h').getValue();
			var a_medium = Ext.getCmp('alarm_m').getValue();
			var a_low = Ext.getCmp('alarm_l').getValue();

			if(high==true || medium==true || low ==true)
			{
				radioval = Ext.getCmp('alarmNotify').notify;
				msgmode = Ext.getCmp('alarmMsgMode').msgmode;

				if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no')
				{
					if (!customScr.isVisible() && !Ext.isEmpty(checkScriptStr) && checkScriptStr.length > 0)
					{
						checkScriptStr = '';
					}
				}
				if(checkToStr == "" && checkScriptStr == "")
				{
					var msgStr = userIDValidationMsg43+sep+userIDValidationMsg44+sep+orStr+sep+userIDValidationMsg45+sep +".";
					var widthVal = 500;
					if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no')
					{
						msgStr = userIDValidationMsg64;
						widthVal = 400;
					}

					if (checkToStr == "")
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: msgStr,
							buttons: Ext.Msg.OK,
							width : widthVal,
							icon: 'iconExclamation',
							fn : function(btn){
								tomail.focus(true);
							}
						});
						return false;
					}
					else
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: msgStr,
							buttons: Ext.Msg.OK,
							width : widthVal,
							icon: 'iconExclamation',
							fn : function(btn){
								customScr.focus(true);
							}
						});
						return false;
					}
					
				}

				if((checkToStr != "") && (toMailResult==false && toMobResult == null) && (toResult != tmpVal1))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg15 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							tomail.focus(true);
						}
					});
					return false;
				}
				else if(!validateSingleByte(tmpVal1))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg16 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							tomail.focus(true);
						}
					});
					return false;
				}
				else if((checkCcStr != "") && (ccMailResult==null || ccMailResult==false) && ccMobResult == null && (ccResult!= tmpVal2))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg17 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							ccmail.focus(true);
						}
					});
					return false;
				}
				else if(!validateSingleByte(tmpVal2))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg18 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							ccmail.focus(true);
						}
					});
					return false;
				}
				else if((checkBccStr != "") && (bccMailResult==null || bccMailResult==false) && bccMobResult == null && bccResult != tmpVal3)
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg19 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							bccmail.focus(true);
						}
					});
					return false;
				}
				else if(!validateSingleByte(tmpVal3))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: userIDValidationMsg20 +".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							bccmail.focus(true);
						}
					});
					return false;
				}

				if(!checkspecial(checkScriptStr,"@*+=[]|;\"\'<>?"))
				{
						customScr.focus(true);
						return false;
				}

				if (checkEscStr != "" && (escMailResult==null || escMailResult==false) && escMobResult  == null && escResult != tmpVal4 )
				{
					Ext.Msg.alert(pageTitle,userIDValidationMsg22,function(btn){
						if (btn == "ok")
						{
							escmail.focus(true);
						}
					});
					return false;
				}
				else if(!validateSingleByte(tmpVal4))
				{
					Ext.Msg.alert(pageTitle,userIDValidationMsg21,function(btn){
						if (btn == "ok")
						{
							escmail.focus(true);
						}
					});
					return false;
				}

				if(checkBccStr != "" || checkCcStr != "")
				{
					if(checkToStr == "")
					{
						Ext.Msg.alert(pageTitle,userIDValidationMsg15,function(btn){
							if (btn == "ok")
							{
								Ext.getCmp('tomailid').focus(true);
							}
						});
						return false;
					}
				}

				var mailshiftField = Ext.getCmp('mailshift').getValue();
				if(checkToStr == "" && mailshiftField == true)
				{
					Ext.Msg.alert(pageTitle,userIDValidationMsg23+orStr+userIDValidationMsg24+sep+userIDValidationMsg25+sep,function(btn){
						if (btn == "ok")
						{
							Ext.getCmp('tomailid').focus(true);
						}
					});
					return false;
				}
				
				if(checkToStr !="" && mailshiftField == "yes")
				{
					var isMailValid = true;
					if((checkToStr !="" && toMailResult==false) || (checkBccStr != "" && bccMailResult==false) || (checkCcStr != "" && ccMailResult==false))
					{
						var flag1 = validateMailID(tmpVal1);
						var flag2 = validateMailID(tmpVal3);
						var flag3 = validateMailID(tmpVal2);

						if(!flag1 && !flag2 && !flag3)
						{
							isMailValid = false;
						}
					}
					if(!isMailValid)
					{
						Ext.Msg.alert(pageTitle,userIDValidationMsg23+orStr+userIDValidationMsg24+sep+userIDValidationMsg25+sep,function(btn){
							if (btn == "ok")
							{
								Ext.getCmp('tomailid').focus(true);
							}
						});
						return false;
					}
				}
				
				var smsshiftField = Ext.getCmp('smsshift').getValue();
				if(checkToStr =="" && smsshiftField == true)
				{
					Ext.Msg.alert(pageTitle,userIDValidationMsg26+orStr+userIDValidationMsg24+sep+userIDValidationMsg27+sep,function(btn){
						if (btn == "ok")
						{
							Ext.getCmp('tomailid').focus(true);
						}
					});
					return false;
				}
				if(checkToStr !="" && smsshiftField == "yes")
				{
					var isMobileValid = true;
					if((checkToStr !="" && toMobResult!=tmpVal1) || (checkBccStr != "" && bccMobResult!=tmpVal3) || (checkCcStr != "" && ccMobResult!=tmpVal2))
					{
						var flag1 = validateMobileNo(tmpVal1);
						var flag2 = validateMobileNo(tmpVal3);
						var flag3 = validateMobileNo(tmpVal2);

						if(!flag1 && !flag2 && !flag3)
						{
							isMobileValid = false;
						}
					}
					if(!isMobileValid)
					{
						Ext.Msg.alert(pageTitle,userIDValidationMsg26+orStr+userIDValidationMsg24+sep+userIDValidationMsg27+sep,function(btn){
							if (btn == "ok")
							{
								Ext.getCmp('tomailid').focus(true);
							}
						});
						return false;
					}
				}
				//if((checkEscStr == "") ||(checkEscStr != ""))
			//	if(true)
				{
					var firstlevel="";
					var firstlev;
					if (inputs>0)
					{
						var escLev1=Ext.getCmp('escmailid');
						var escLev1Value = escLev1.getValue();
						var escLev1Result=validateEmail(escLev1Value);
						var escLev1MobResult=(escLev1Value).match(regExp1);
						var escResult=(escLev1Value).match(reg3);
						
						if (escLev1Value == "")
						{
							Ext.Msg.alert(pageTitle,userIDValidationMsg28,function(btn){
								if (btn == "ok")
								{
									escLev1.focus(true);
								}
							});
							return false;
						}
						else if((escLev1Result==null || escLev1Result==false) && escLev1MobResult == null && escResult != escLev1Value)
						{
							Ext.Msg.alert(pageTitle,userIDValidationMsg28,function(btn){
								if (btn == "ok")
								{
									escLev1.focus(true);
								}
							});
							return false;
						}
						else if(!validateSingleByte(escLev1.value))
						{
							Ext.Msg.alert(pageTitle,userIDValidationMsg29,function(btn){
								if (btn == "ok")
								{
									escLev1.focus(true);
								}
							});
							return false;
						}
					}

					for(var i=0;i<=inputs;i++)
					{
						var ecsElclevelvar = (("escmailid")+i);
						var inpVal = Ext.getCmp(ecsElclevelvar);
						if (inpVal == null)
						{
							continue;
						}

						var thisMailID = inpVal.getValue();
						if (thisMailID=="")
						{
							Ext.Msg.alert(pageTitle,userIDValidationMsg30+(i+2)+userIDValidationMsg31,function(){
								if (escmail.getValue() =="")
								{
									escmail.focus(true);
								}else
								{
									inpVal.focus(true);
								}
							});
							return false
						}

						var tempResult=validateEmail(thisMailID);
						var tempMobResult=(thisMailID).match(regExp1);
						var tempRegResult=(thisMailID).match(reg3);
						if((tempResult==null || tempResult==false) && tempMobResult == null && tempRegResult != thisMailID)
						{
							Ext.Msg.alert(pageTitle,userIDValidationMsg30+(i+2)+userIDValidationMsg31,function(){
								if (escmail.value=="")
								{
									escmail.focus(true);
								}else
								{
									inpVal.focus(true);
								}
							});
							return false;
						}
						else if(!validateSingleByte(thisMailID))
						{
							Ext.Msg.alert(pageTitle,userIDValidationMsg30+(i+2)+userIDValidationMsg32);
							return false;
						}
					}
				}
				if(radioval == "")
				{
					Ext.Msg.alert(pageTitle,userIDValidationMsg33);
					return false
				}
				if(msgmode == "")
				{
					Ext.Msg.alert(pageTitle,userIDValidationMsg34);
					return false
				}
			}
			if(a_high == false && a_medium== false && a_low == false)
			{
					Ext.Msg.alert(pageTitle,userIDValidationMsg35);
					return false
			}
		}

		var count = parseInt(noOfShiftPeriods);
		var mailshiftField = Ext.getCmp('mailshift').getValue().mailshift;
		if (mailshiftField != null && mailshiftField == 'yes')
		{
			for (var i=0;i<count;i++)
			{
				var mailday = Ext.getCmp('mailday'+i);
				var mailshift = Ext.getCmp('mailshift'+i);
				if (mailday == null || mailshift == null)
				{
					continue;
				}
				if ((high == true || medium == true || low == true) && (!checkblank(mailday.getValue()) || !checkblank(mailshift.getValue())))
				{
					Ext.Msg.alert(pageTitle,userIDValidationMsg36);
					return false;
				}
			}
		}

		var smsShiftAlerts = Ext.getCmp('smsshift').getValue().smsshift;
		if (smsShiftAlerts != null && smsShiftAlerts == 'yes')
		{
			for (var i=0;i<count;i++)
			{
				var smsday =  Ext.getCmp('smsday'+i);
				var smsshift =  Ext.getCmp('smsshift'+i);
				if (smsday == null || smsshift == null)
				{
					continue;
				}
				if ((high == true || medium == true || low == true) && (!checkblank(smsday.getValue()) || !checkblank(smsshift.getValue())))
				{
					Ext.Msg.alert(pageTitle,userIDValidationMsg37);
					return false;
				}
			}
		}

		var escShiftAlerts = Ext.getCmp('escshift').getValue().escshift;
		if (escShiftAlerts != null && escShiftAlerts == 'yes')
		{
			if (escmail != null && escmail.value=='')
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg28+orStr+userIDValidationMsg24+sep+userIDValidationMsg38+sep);
				return false;
			}
			for (var i=0;i<count;i++)
			{
				var escday = Ext.getCmp('escday'+i);
				var escshift = Ext.getCmp('escshift'+i);
				if (escday == null || escshift == null)
				{
					continue;
				}
				if ((high == true || medium == true || low == true) && (!checkblank(escday.getValue()) || !checkblank(escshift.getValue())))
				{
					Ext.Msg.alert(pageTitle,userIDValidationMsg39);
					return false;
				}
			}
		}

		var commandShiftAlerts = Ext.getCmp('Execshift').getValue().Execshift;
		if(commandShiftAlerts != null && commandShiftAlerts == 'yes')
		{
			var command = Ext.getCmp('customScript').getValue();
			if(command == "")
			{
				Ext.Msg.alert(pageTitle,userIDValidationMsg40+orStr+userIDValidationMsg24+sep+userIDValidationMsg41+sep,function(btn){
					if (btn == "ok")
					{
						Ext.getCmp('customScript').focus(true);
					}
				});
				return false;
			}
			for (var i=0;i<count;i++)
			{
				var mailday = Ext.getCmp('Execday'+i);
				var mailshift = Ext.getCmp('Execshift'+i);
				if (mailday == null || mailshift == null)
				{
					continue;
				}
				if ((high == true || medium == true || low == true) && (!checkblank(mailday.getValue()) || !checkblank(mailshift.getValue())))
				{
					Ext.Msg.alert(pageTitle,userIDValidationMsg42);
					return false;
				}
			}

		}
		//if(sub)
		{
			var loginLogo1 = Ext.getCmp('loginLogo1').getValue();
			var monitorLogo1 = Ext.getCmp('monitorLogo1').getValue();
			var reporterLogo1 = Ext.getCmp('reporterLogo1').getValue();
			var configLogo1 = Ext.getCmp('configLogo1').getValue();
			if(loginLogo1 == "hide")
			{
				Ext.getCmp('loginImageStatus').setValue('');
				Ext.getCmp('loginImageUploadStatusForAudit').setValue('no');
			}
			else
			{
				if (!isLoginImgUpdated)
				{
					Ext.Msg.alert(pageTitle,uploadImgMsg + " '"+uploadImgMsg4+"'");
					return false;
				}
				Ext.getCmp('loginImageUploadStatusForAudit').setValue('yes');
			}

			if(monitorLogo1=="hide")
			{
				Ext.getCmp('monitorImageStatus').setValue('');
				Ext.getCmp('monitorImageUploadStatusForAudit').setValue('no');
			}
			else
			{
				if (!isAdminMonImgUpdated)
				{
					Ext.Msg.alert(pageTitle,uploadImgMsg + " '"+uploadImgMsg5+"' "+uploadImgMsg1);
					return false;
				}
				Ext.getCmp('monitorImageUploadStatusForAudit').setValue('yes');
			}

			if(reporterLogo1=="hide")
			{
				Ext.getCmp('reporterImageStatus').setValue('');
				Ext.getCmp('reporterImageUploadStatusForAudit').setValue('no');
			}
			else
			{
				Ext.getCmp('reporterImageUploadStatusForAudit').setValue('yes');
			}

			if(configLogo1=="hide")
			{
				Ext.getCmp('configMgmtImageStatus').setValue('');
				Ext.getCmp('configMgmtImageUploadStatusForAudit').setValue('no');
			}
			else
			{
				Ext.getCmp('configMgmtImageUploadStatusForAudit').setValue('yes');
			}

			var logoCheck = Ext.getCmp('logoCheck').getValue();
			if (logoCheck == true)
			{
				Ext.getCmp('reporterImageStatus').setValue('');
				Ext.getCmp('reporterImageUploadStatusForAudit').setValue('no');
				Ext.getCmp('configMgmtImageStatus').setValue('');
				Ext.getCmp('configMgmtImageUploadStatusForAudit').setValue('no');
			}
			else
			{
				if(reporterLogo1 == "show" && utype != "AlarmViewer" && utype != "SuperAlarmViewer")
				{
					if (!isRepImgUpdated)
					{
						Ext.Msg.alert(pageTitle,uploadImgMsg + " '"+uploadImgMsg6+"' "+uploadImgMsg1);
						return false;
					}
				}

				if(configLogo1 == "show" && utype != "AlarmViewer" && utype != "SuperAlarmViewer" && isConfigEnabled == 'true')
				{
					if (!isConfigImgUpdated)
					{
						Ext.Msg.alert(pageTitle,uploadImgMsg + " '"+uploadImgMsg7+"' "+uploadImgMsg1);
						return false;
					}
				}
			}
		}

		// 2fa validation - starts here

		var flag = new Boolean(true);
		var is2FACFlagEnabled = publicJSON['is2FACFlagEnabled'];

		var isVisibleUserAuthSAML = Ext.getCmp('userAuthSAML').isVisible();
		var userAuthSAMLVal = Ext.getCmp('idpAuthSAML').getGroupValue();

		if (isVisibleUserAuthSAML && userAuthSAMLVal.toLowerCase() == 'saml')
		{
			flag = new Boolean(false);
		}

		if (flag == true && !Ext.isEmpty(is2FACFlagEnabled) && is2FACFlagEnabled.toLowerCase() == "yes")
		{
			var tomailid2FAVal = Ext.getCmp('tomailid').getValue();

			if (Ext.isEmpty(tomailid2FAVal) || Ext.String.trim(tomailid2FAVal).length == 0)
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: userIDValidationMsg65+'. '+userIDValidationMsg66,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('tomailid').focus(true);
					}
				});
				return false;
			}
		}

		// 2fa validation - ends here
		return true;
	},
	removeVM : function(vm)
	{
		var removeVmUrl ='/final/admin/EgChangeUserProfile/data/EgUserSiteServersJson.jsp?qctr=1&reqfrom=removeVM&vmdetails='+encodeURI(vm);
		Ext.Ajax.request({
			url : removeVmUrl,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				var virtualServers = Ext.getCmp('virtualServers');
				var selectedVMHosts = virtualServers.getValue();
				var utype = Ext.getCmp('utype').getValue();
				var associateELValue = Ext.getCmp('associate').getValue();
				var url = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?showAssociatedData=yes&qctr=1&selectedTab=3&assousers="+encodeURIComponent(associatedUserIDs)+"&username="+encodeURIComponent(selectedUserID)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom=add&utype="+utype+"&associate="+encodeURIComponent(associateELValue);
				if (associateELValue == "Independent servers")
				{
					var componentType = Ext.getCmp('associate').getValue();
					var vmselectionall = Ext.getCmp('vmselectionall').getValue();
					var vmselectionpattern = Ext.getCmp('vmselectionpattern').getValue();
					var vmselectionspecific = Ext.getCmp('vmselectionspecific').getValue();
					patternVal = Ext.getCmp('patternName').getValue();
					if(!Ext.isEmpty(vmselectionall) && vmselectionall)
						url = url + "&compType="+encodeURIComponent(componentType)+"&type=allVms&vHost="+encodeURI(selectedVMHosts)+"&selPatternValue="+encodeURIComponent(patternVal);
					else if(!Ext.isEmpty(vmselectionpattern) && vmselectionpattern)
						url = url + "&compType="+encodeURIComponent(componentType)+"&type=vmPattern&vHost="+encodeURI(selectedVMHosts)+"&selPatternValue="+encodeURIComponent(patternVal);
					else if(!Ext.isEmpty(vmselectionspecific) && vmselectionspecific) 
						url = url + "&compType="+encodeURIComponent(componentType)+"&type=specVms&vHost="+encodeURI(selectedVMHosts)+"&selPatternValue="+encodeURIComponent(patternVal);
					else  
						url = url + "&compType="+encodeURIComponent(componentType);
				}
				EgChangeUserProfile.app.getController("Main").updateUserElementPage(url);
				EgChangeUserProfile.app.getController("Main").updateResultPanel();
			}
		});
	},
	viewUserAssociatedElements : function()
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			title : intnlLabel6,
			id:'userElementsWindow',
			width: '95%',
			padding:'5 10 10 10',
			height: 450,
			modal : true,
			border : false,
			autoScroll:true,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},			
			listeners : {
				afterrender : function()
				{
					var virtualServers = Ext.getCmp('virtualServers');
					var selectedVMHosts = virtualServers.getValue();
					var utype = Ext.getCmp('utype').getValue();
					var associateELValue = Ext.getCmp('associate').getValue();
					var url = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?showAssociatedData=yes&qctr=1&selectedTab=3&assousers="+encodeURIComponent(associatedUserIDs)+"&username="+encodeURIComponent(selectedUserID)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom=add&utype="+utype+"&associate="+encodeURIComponent(associateELValue);
					if (associateELValue == "Independent servers")
					{
						var componentType = Ext.getCmp('associate').getValue();
						var vmselectionall = Ext.getCmp('vmselectionall').getValue();
						var vmselectionpattern = Ext.getCmp('vmselectionpattern').getValue();
						var vmselectionspecific = Ext.getCmp('vmselectionspecific').getValue();
						patternVal = Ext.getCmp('patternName').getValue();
						if(!Ext.isEmpty(vmselectionall) && vmselectionall)
							url = url + "&compType="+encodeURIComponent(componentType)+"&type=allVms&vHost="+encodeURI(selectedVMHosts)+"&selPatternValue="+encodeURIComponent(patternVal);
						else if(!Ext.isEmpty(vmselectionpattern) && vmselectionpattern)
							url = url + "&compType="+encodeURIComponent(componentType)+"&type=vmPattern&vHost="+encodeURI(selectedVMHosts)+"&selPatternValue="+encodeURIComponent(patternVal);
						else if(!Ext.isEmpty(vmselectionspecific) && vmselectionspecific) 
							url = url + "&compType="+encodeURIComponent(componentType)+"&type=specVms&vHost="+encodeURI(selectedVMHosts)+"&selPatternValue="+encodeURIComponent(patternVal);
						else  
							url = url + "&compType="+encodeURIComponent(componentType);
					}
					me.updateUserElementPage(url);
					me.updateResultPanel();
				}
			},
			items:[
			{
				xtype:'container',
				layout:'hbox',
			layout: {
			type: 'hbox',
			align: 'end',
			pack: 'end'
			},
			items:[
				{
				xtype:'container',
				flex:1,
				},				
				{
				xtype:'button',
				cls:'dummybtuserprofile',
				id: 'Expand',
				margin:'5 6 0 10',
				currentStatus : 'expanded',
				html:'<div style="cursor:pointer;text-decoration:underline;float:right;font-size:11px;padding:2px;text-transform: lowercase;" id="exx">collapse all</div>',
				handler : function()
				{
				var obj = Ext.getCmp('Expand');
				if (obj.currentStatus == "expanded")
				{
				obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:11px;padding:2px;text-transform: lowercase;" id="exx">expand all</div>');
				obj.currentStatus = "collapse";
				var thisGrid = Ext.getCmp('componentgroupedsummarygrid');
				var groupingFeature = thisGrid.view.getFeature('componentGrouping');
				groupingFeature.collapseAll();
				}
				else
				{
				obj.currentStatus = "expanded";
				obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:11px;padding:2px;text-transform: lowercase;" id="exx">collapse all</div>');
				var thisGrid = Ext.getCmp('componentgroupedsummarygrid');
				var groupingFeature = thisGrid.view.getFeature('componentGrouping');
				groupingFeature.expandAll();
				}

				}
				}
				]},
				{
					xtype: 'container',
					id: 'userAssociationContainer',
					layout: {
						type: 'hbox',
					},
					margin: '5 10 10 10',					
				}
			]
		}).show();
	},
	viewFilteredElements : function()
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			id:'userFilterWindow',
			width: '95%',
			height: 450,
			border : false,
			modal : true,
			autoScroll:true,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					if (mailFilterOption == "Descriptors_Only")
					{
						var title = filterMessage2 + ": "+changeDisplayName(selectedUserID);
						Ext.getCmp('userFilterWindow').setTitle(title);
						var url = "EgChangeUserProfile/data/EgMailAlertIncludeSuppress.jsp?showAssociatedData=yes&selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
						//me.updateUserMailSuppressList(url);
						me.updateDescriptorHTMLFiltePanel(url);
					}
					else
					{
						var title = filterMessage + ": "+changeDisplayName(selectedUserID);
						Ext.getCmp('userFilterWindow').setTitle(title);
						var url = "EgChangeUserProfile/data/EgMailAlertSuppress.jsp?showAssociatedData=yes&selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
						//me.updateUserMailSuppressList(url);
						me.updateHTMLFilterResultPanel(url);
					}
				}
			},
			items:[
				{
					xtype: 'container',
					id: 'userFilterContainer',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					defaults: {
						margin : 8
					}
				}
			]
		}).show();
	},
	searchComponent : function(strComponent,searchVal)
	{
		var me = this , id;
		if (strComponent == "managed")
		{
			id = "managedSeacrchBox";
		}
		else
		{
			id = "unmanagedSeacrchBox";
		}

		if (searchVal == "" || searchVal.length == 0)
		{
			Ext.get('MyTrigger_'+id+'_0').setStyle('display','none');
			Ext.get('MyTrigger_'+id+'_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_'+id+'_1').setStyle('display','none');
			Ext.get('MyTrigger_'+id+'_0').setStyle('display','block');
		}

		var selectedVMHosts = Ext.getCmp('virtualServers').getValue();
		var urlString = '';
		var me = this;
		var roleName = Ext.getCmp('utype').getValue();
		var selectedComponentType = Ext.getCmp('compType').getValue();
		var associate = Ext.getCmp('associate').getValue();
		var virtualType = Ext.getCmp('virtualTypes').getValue();

		var params = "associate="+associate+"&username=" +encodeURIComponent(selectedUserID)+ "&qctr=1&compType="+encodeURI(selectedComponentType)+"&assousers="+encodeURIComponent(associatedUserIDs)+"&newusers="+encodeURIComponent(associatedUserIDs)+"&isAlarmEnabled="+isAlarmEnabled+"&filterMailAlt="+isFilterMailAlertsEnabled+"&reqfrom="+reqFrom+"&utype="+roleName+"&vServer="+virtualType;
		if (searchVal.length == 0 || searchVal == "Search" )
		{
			urlString = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?qctr=1&selectedTab=3&"+params;
		}
		else
		{
			urlString = "EgChangeUserProfile/data/EgUserSiteServersJson.jsp?qctr=1&selectedTab=3&"+params+"&strSearch="+searchVal+"&strComponent="+strComponent;
		}

		Ext.Ajax.request({
			url : urlString,
			method: 'POST',
			params : {
				vHost : encodeURI(selectedVMHosts)
			},
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userElementJSON = Ext.decode(jsonText);
				if (strComponent == "managed")
				{
					var tmpStore = Ext.getCmp('otherHosts');
					var managedServers = userElementJSON['associatedItems'];
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					tmpStore.fromField.store.add(managedServers);
				}
				else
				{
					var tmpStore = Ext.getCmp('otherHosts');
					var unmanagedServers = userElementJSON['disAssociatedItems'];
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					tmpStore.toField.store.add(unmanagedServers);
				}
			}
		});
	},

	onSrvGroupChange : function(obj)
	{
		var selectedValue = obj.getValue();
		//if (srvListArray.length == 0 && loadCount == 0)
		//{
			//var compObj = Ext.getCmp('c_types').getValue();
			//srvListArray = compObj;
		//}

		Ext.getCmp('selectedServerListGrid').getStore().each(function(rec)
		{
			if (!Ext.isEmpty(rec.get("valueField_1")))
			{
				srvListArray.push(rec.get("valueField_1"));
			}
			if (!Ext.isEmpty(rec.get("valueField_2")))
			{
				srvListArray.push(rec.get("valueField_2"));
			}
			if (!Ext.isEmpty(rec.get("valueField_3")))
			{
				srvListArray.push(rec.get("valueField_3"));
			}
		});

		var tmpStore = Ext.getCmp('selectedCompDetails');
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		if(tmpStore.toField.store.getCount() > 0)
		{
			tmpStore.toField.store.removeAll();
		}
		
		var url = 'EgChangeUserProfile/data/EgConfigureCompTypeJson.jsp?from=commonSettings&DiscOptions='+selectedValue+'&ServerDisplay='+srvListArray+'&LoadCount='+loadCount;
		this.updateCofigData(url);
		
		var managedServers = userCompJSON['generalSettings']['discSrvrArray'];
		var unmanagedServers = userCompJSON['generalSettings']['allSrvrArray'];

		tmpStore.fromField.store.add(managedServers);
		tmpStore.toField.store.add(unmanagedServers);
		loadCount++;
	},
	
	updateCofigData : function(url)
	{
		Ext.Ajax.request({
			url : url,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userCompJSON = Ext.decode(jsonText);
			}
		});
	},
	
	applySeverChange : function()
	{
		var me = this;
		var selectedSrvList = srvListArray;
		//if (selectedSrvList.length > 0)
		{
			var selectedCompDetails = srvListArray.toString();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg:'Saving...'});
			myMask.show();
			Ext.Ajax.request({
				url : 'EgChangeUserProfile/data/EgConfigureCompTypeJson.jsp?LoadCount='+loadCount,
				params : {
					'from' : 'commonSettings',
					'selectedCompDetails' : selectedCompDetails
				},
				success: function(response)
				{
					myMask.hide();
					userCompJSON = Ext.decode(response.responseText);
					var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
					selectedServerListGridObj.getStore().loadRawData(userCompJSON['generalSettings']['configuredServersList']);
					var tmpCount = parseInt(userCompJSON['generalSettings']['configuredServersCount']);
					selectedServerListGridObj.doLayout();
					selectedServerListGridObj.view.refresh();
					if (tmpCount > 9)
					{
						selectedServerListGridObj.setHeight(100);
					}
					Ext.getCmp('resultHeaderCt').show();
					isApplied = true;
					if(isSavedFromPrompt)
					{
						compSaveMask.hide();
						Ext.getCmp('configurationWindow').close();
					}
				}
			});
		}
		//else
		//{
			//Ext.MessageBox.show({
				//title: pageTitle2,
				//msg: intnlLabel13 + ".",
				//buttons: Ext.MessageBox.OK,
				//icon: 'iconExclamation'
			//});
			//return;
		//}
	},

	refreshWindow:function()
	{
		var selectedServerListGridObj = Ext.getCmp('selectedServerListGrid');
		selectedServerListGridObj.getStore().loadRawData(userCompJSON['generalSettings']['configuredServersList']);
		selectedServerListGridObj.doLayout();
		selectedServerListGridObj.view.refresh();
	}

});

function validateMailID(toMail)
{
	var regExp1=/^(\+\d\d)?[0-9]+$/g;
	var arr = toMail.split(',');
	var arrCnt = arr.length;
	var isValidMailid = false;
	if(arrCnt != null && arrCnt == 1)
	{
		var toMailResult= validateEmail(arr);
		if (arr != null && toMailResult == true)
		{
			var isValidMailid = true;
		}
	}
	else
	{
		for(var i=0; i<arr.length; i++)
		{
			var toMailResult= validateEmail(arr[i]);
			var toSmsResult= arr[i].match(regExp1);
			if (arr[i] != null && toMailResult == true)
			{
				isValidMailid = true;
				//break;
			}
			else if (arr[i] != null && toSmsResult == arr[i])
			{
				continue;
			}
			else
			{
				isValidMailid = false;
				break;
			}
		}
	}
	return isValidMailid;
}

function validateMobileNo(toSms)
{
	var regExp1=/^(\+\d\d)?[0-9]+$/g;
	var arr = toSms.split(',');
	var arrCnt = arr.length;
	var isValidNumber = false;

	if(arrCnt != null && arrCnt == 1)
	{
		var toSmsResult= arr.toString().match(regExp1);
		if (arr != null && toSmsResult == arr.toString())
		{
			isValidNumber = true;
		}
	}
	else
	{
		for(var i=0; i<arr.length; i++)
		{
			var toSmsResult= arr[i].match(regExp1);
			var toMailResult= validateEmail(arr[i]);
			if (arr[i] != null && toSmsResult == arr[i])
			{
				isValidNumber = true;
				//break;
			}
			else if (arr[i] != null && toMailResult == true)
			{
				continue;
			}
			else
			{
				isValidNumber = false;
				break;
			}
		}
	}
	return isValidNumber;
}

function addContact()
{
	var mainForm = Ext.getCmp('userformcontainer');
	if(inputs == 4)
	{
		Ext.MessageBox.alert(pageTitle,userIDValidationMsg46);
		return;
	}
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	var levelStr = inputs+2
	var conId = "con_"+inputs
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: 'escmailid'+inputs,
				cls: 'textbox',
				name: 'escmailid'+inputs,
				fieldLabel : 'Level '+levelStr,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.97,
				margin: '1 0 10 0'
			},
			{
				xtype : 'container',
				columnWidth: 0.03,
				margin: '20 0 5 2',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove level'
					});
					}
					},
					//tooltip : '<b>remove level</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeContact(conId);
					}
				}]
			}
		]
	}
	escMailIDsDiv.add(tmpContainer);
	mainForm.doLayout();
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('escmailid').getBox().y - 200);
	inputs++;
}


function addEscLevel(fieldValue)
{
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	var levelStr = inputs+2;
	var conId = "con_"+inputs;
	var tmpContainer = {
		xtype : 'container',
		id : conId,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: 'escmailid'+inputs,
				cls: 'textbox',
				name: 'escmailid'+inputs,
				fieldLabel : 'Level '+levelStr,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.97,
				margin: '1 0 10 0',
				value : fieldValue,
			},
			{
				xtype : 'container',
				columnWidth: 0.03,
				margin: '20 0 5 2',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove level'
					});
					}
					},
					//tooltip : '<b>remove level</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeContact(conId);
					}
				}]
			}
		]
	}
	escMailIDsDiv.add(tmpContainer);
	inputs++;
}

function removeContact(containerID)
{
	var escMailIDsDiv = Ext.getCmp('escMailIDsDiv');
	escMailIDsDiv.remove(containerID);
	inputs--;

	var conLength = escMailIDsDiv.items.length - 1;
	if (conLength > 0)
	{
		inputs = 0;
		var tnpCount = 0;
		for (var i = 0;i<=conLength;i++)
		{
			var tmpLevelObj = Ext.getCmp("con_"+i);
			if (tmpLevelObj == null || tmpLevelObj == undefined)
			{
				continue;
			}
			var tmpID = tmpLevelObj.getId();
			var value = Ext.getCmp('escmailid'+i).getValue();
			escMailIDsDiv.remove(tmpID);
			addEscLevel(value);
		}
	}
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('escmailid').getBox().y - 200);
}

function addShifts(type)
{
	var shiftPeriodsCount;
	if (type == "mail")
	{
		var emailMailAlert = Ext.getCmp('emailMailAlert');
		if (mailShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.MessageBox.alert(pageTitle,userIDValidationMsg47+' ('+noOfShiftPeriods+')');
			return;
		}
		shiftPeriodsCount = mailShiftPeriodsCount;
		emailMailAlert.add(getMailShiftTemplate(shiftPeriodsCount,'',''));
		mailShiftPeriodsCount++;
		emailMailAlert.doLayout();
		Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('mailday0').getBox().y - 200);
	}
	else if (type == "Exec")
	{
		var commandObj = Ext.getCmp('commandAlert');
		if (ExecShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.MessageBox.alert(pageTitle,userIDValidationMsg47+' ('+noOfShiftPeriods+')');
			return;
		}
		shiftPeriodsCount = ExecShiftPeriodsCount;
		commandObj.add(getExecTemplate(shiftPeriodsCount,'',''));
		ExecShiftPeriodsCount++;
		commandObj.doLayout();
		Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('Execday0').getBox().y - 200);
	}
	else if (type == "sms")
	{
		var smsAlert = Ext.getCmp('smsAlert');
		if (smsShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.MessageBox.alert(pageTitle,userIDValidationMsg47+' ('+noOfShiftPeriods+')');
			return;
		}
		shiftPeriodsCount = smsShiftPeriodsCount;
		smsAlert.add(getSMSTemplate(shiftPeriodsCount,'',''));
		smsShiftPeriodsCount++;
		smsAlert.doLayout();
		Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('smsday0').getBox().y - 200);
	}
	else if (type == "esc")
	{
		var escMailAlert = Ext.getCmp('escMailAlert');
		if (escShiftPeriodsCount == noOfShiftPeriods-1)
		{
			Ext.MessageBox.alert(pageTitle,userIDValidationMsg47+' ('+noOfShiftPeriods+')');
			return;
		}
		shiftPeriodsCount = escShiftPeriodsCount;
		escMailAlert.add(getEscTemplate(shiftPeriodsCount,'',''));
		escShiftPeriodsCount++;
		escMailAlert.doLayout();
		Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('escday0').getBox().y - 200);
	}
}

function getMailTemplate(type,day,time,tmpId,tmpId2)
{
	var tmpShiftData = {
		xtype : 'container',
		margin: 5,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: tmpId,
				name : tmpId,
				cls: 'textbox',
				fieldLabel: userIDValidationMsg52,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				value : day,
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\''+tmpId+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype:'textfield',
				id: tmpId2,
				name : tmpId2,
				cls: 'textbox',
				fieldLabel: userIDValidationMsg53,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				value : time,
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\''+tmpId2+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype : 'container',
				columnWidth: 0.04,
				margin: '22 0 5 30',
				items : [{
					xtype : 'button',
					iconCls : 'img_addShift',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'add shift period'
					});
					}
					},
					//tooltip : '<b>add shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						addShifts(type);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function insertShiftData(type,day,time)
{
	if (type == "mail")
	{
		var emailMailAlert = Ext.getCmp('emailMailAlert');
		emailMailAlert.add(getMailTemplate(type,day,time,"mailday0","mailshift0"));
	}
	else if (type == "Exec")
	{
		var commandObj = Ext.getCmp('commandAlert');
		commandObj.add(getMailTemplate(type,day,time,"Execday0","Execshift0"));
	}
	else if (type == "sms")
	{
		var smsAlert = Ext.getCmp('smsAlert');
		smsAlert.add(getMailTemplate(type,day,time,"smsday0","smsshift0"));
	}
	else if (type == "esc")
	{
		var escMailAlert = Ext.getCmp('escMailAlert');
		escMailAlert.add(getMailTemplate(type,day,time,"escday0","escshift0"));
	}
}

function addMoreShifts(type,day,time)
{
	var shiftPeriodsCount;
	if (type == "mail")
	{
		var emailMailAlert = Ext.getCmp('emailMailAlert');
		shiftPeriodsCount = mailShiftPeriodsCount;
		emailMailAlert.add(getMailShiftTemplate(shiftPeriodsCount,day,time));
		mailShiftPeriodsCount++;
		emailMailAlert.doLayout();
	}
	else if (type == "Exec")
	{
		var commandObj = Ext.getCmp('commandAlert');
		shiftPeriodsCount = ExecShiftPeriodsCount;
		commandObj.add(getExecTemplate(shiftPeriodsCount,day,time));
		ExecShiftPeriodsCount++;
		commandObj.doLayout();
	}
	else if (type == "sms")
	{
		var smsAlert = Ext.getCmp('smsAlert');
		shiftPeriodsCount = smsShiftPeriodsCount;
		smsAlert.add(getSMSTemplate(shiftPeriodsCount,day,time));
		smsShiftPeriodsCount++;
		smsAlert.doLayout();
	}
	else if (type == "esc")
	{
		var escMailAlert = Ext.getCmp('escMailAlert');
		shiftPeriodsCount = escShiftPeriodsCount;
		escMailAlert.add(getEscTemplate(shiftPeriodsCount,day,time));
		escShiftPeriodsCount++;
		escMailAlert.doLayout();
	}
}

function removeMailShift(containerID)
{
	var escMailIDsDiv = Ext.getCmp('emailMailAlert');
	escMailIDsDiv.remove(containerID);
	mailShiftPeriodsCount--;
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('mailday0').getBox().y - 200);
}

function removeExecShift(containerID)
{
	var commandAlert = Ext.getCmp('commandAlert');
	commandAlert.remove(containerID);
	ExecShiftPeriodsCount--;
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('Execday0').getBox().y - 200);
}

function removeSMSShift(containerID)
{
	var smsAlert = Ext.getCmp('smsAlert');
	smsAlert.remove(containerID);
	smsShiftPeriodsCount--;
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('smsday0').getBox().y - 200);
}

function removeEscShift(containerID)
{
	var escMailAlert = Ext.getCmp('escMailAlert');
	escMailAlert.remove(containerID);
	escShiftPeriodsCount--;
	Ext.getCmp('userpref').body.scroll('bottom',Ext.getCmp('escday0').getBox().y - 200);
}

function getMailShiftTemplate(id,day,time)
{
	var tmpId = "mailday"+(id+1);
	var tmpId2 = "mailshift"+(id+1);
	var conId = "mailShift_"+id

		var tmpShiftData = {
		xtype : 'container',
		id : conId,
		margin: 5,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: tmpId,
				name : tmpId,
				cls: 'textbox',
				fieldLabel: userIDValidationMsg52,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				value : day,
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\''+tmpId+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype:'textfield',
				id: tmpId2,
				name : tmpId2,
				cls: 'textbox',
				fieldLabel: userIDValidationMsg53,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				value : time,
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\''+tmpId2+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype : 'container',
				columnWidth: 0.04,
				margin: '22 0 5 30',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove shift peroid'
					});
					}
					},
					//tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeMailShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function getExecTemplate(id,day,time)
{
	var tmpId = "Execday"+(id+1);
	var tmpId2 = "Execshift"+(id+1);
	var conId = "ExecShift_"+id

	var tmpShiftData = {
		xtype : 'container',
		id : conId,
		margin: 5,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: tmpId,
				cls: 'textbox',
				name: tmpId,
				fieldLabel: userIDValidationMsg52,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				value : day,
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\''+tmpId+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype:'textfield',
				id: tmpId2,
				cls: 'textbox',
				name: tmpId2,
				fieldLabel: userIDValidationMsg53,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				value : time,
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\''+tmpId2+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype : 'container',
				columnWidth: 0.04,
				margin: '22 0 5 30',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove shift peroid'
					});
					}
					},
					//tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeExecShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function getSMSTemplate(id,day,time)
{
	var tmpId = "smsday"+(id+1);
	var tmpId2 = "smsshift"+(id+1);
	var conId = "SMSShift_"+id
	var tmpShiftData = {
		xtype : 'container',
		id : conId,
		margin: 5,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: tmpId,
				cls: 'textbox',
				name: tmpId,
				fieldLabel: userIDValidationMsg52,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				value : day,
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\''+tmpId+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype:'textfield',
				id: tmpId2,
				cls: 'textbox',
				name: tmpId2,
				fieldLabel: userIDValidationMsg53,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				value : time,
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\''+tmpId2+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype : 'container',
				columnWidth: 0.04,
				margin: '22 0 5 30',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove shift peroid'
					});
					}
					},
					//tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeSMSShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function getEscTemplate(id,day,time)
{
	var tmpId = "escday"+(id+1);
	var tmpId2 = "escshift"+(id+1);
	var conId = "ESCShift_"+id
	var tmpShiftData = {
		xtype : 'container',
		id : conId,
		margin: 5,
		layout: 'column',
		items : [
			{
				xtype:'textfield',
				id: tmpId,
				cls: 'textbox',
				name: tmpId,
				fieldLabel: userIDValidationMsg52,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				value : day,
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showDaysPicker(\''+tmpId+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype:'textfield',
				id: tmpId2,
				cls: 'textbox',
				name: tmpId2,
				fieldLabel: userIDValidationMsg53,
				labelAlign: 'top',
				labelSeparator: ' ',
				columnWidth: 0.4,
				margin: '1 0 10 20',
				value : time,
				readOnly : true,
			},
			{
				xtype: 'component',
				html: '<center><img src="/final/admin/eg_images/calendar.gif" style="cursor:pointer;" border="0" width="20" height="18" onclick="javascript:showShiftsPicker(\''+tmpId2+'\')"></center>',
				columnWidth: 0.03,
				margin: '22 0 5 2'
			},
			{
				xtype : 'container',
				columnWidth: 0.04,
				margin: '22 0 5 30',
				items : [{
					xtype : 'button',
					iconCls : 'iconMinus',
					listeners: {
					afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
					target: this.id,
					anchor: 'top',
					cls: 'yellowTip',
					trackMouse: true,
					html: 'remove shift peroid'
					});
					}
					},
					//tooltip : '<b>remove shift period</b>',
					style : {
						background : 'none',
						border : '0px'
					},
					handler: function()
					{
						removeEscShift(conId);
					}
				}]
			}
		]
	}
	return tmpShiftData;
}

function showDaysPicker(mailDayID)
{
	var tmpStore = publicJSON['daysPicker'];
	var expandWindow = Ext.create('Ext.window.Window',{
		title:'DAYS',
		width:150,
		modal : true,
		doClose: function() {
			this.destroy();
		},
		buttonAlign:'center',
		items:[
			{
				xtype: 'multiselectSi',
				cls:"multiselect",
				width: 200,
				scroll:true,
				name: 'multiselect',
				labelAlign:'left',
				id: 'daysList',
				name: 'daysList',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			}
		],
		buttons : [
			{
				text : 'Add',
				id : 'daysAdd',
				name : 'daysAdd',
				cls: 'button20',
				margin: '0 0 10 0',
				handler : function()
				{
					var tmpStr = "";
					var daysList = Ext.getCmp('daysList');
					var objTemp = daysList.getSelected();
					if (!Ext.isEmpty(objTemp))
					{
						for (key in objTemp)
						{
							tmpStr = tmpStr + objTemp[key].get("valueField") + ",";
						}
						tmpStr = tmpStr.substring(0,tmpStr.length - 1);
						Ext.getCmp(mailDayID).setValue(tmpStr);
						expandWindow.destroy();
						expandWindow = null;
					}
					else
					{
						
						Ext.MessageBox.alert(pageTitle,"Please choose a day");
					}
				}
			}
		]
	}).show();
	var daysListObj = Ext.getCmp('daysList');
	daysListObj.getStore().loadRawData(tmpStore);
	var selectedDays = Ext.getCmp(mailDayID).getValue();
	daysListObj.setValue(selectedDays);
}

function showShiftsPicker(shiftId)
{
	var tmpHeight = 0;
	var expandWindow = Ext.create('Ext.window.Window',{
		title:'SHIFTS',
		requires : ['EgChangeUserProfile.view.ShiftsPicker'],
		width:460,
		//height:128,
		modal : true,
		id : 'shiftsPickerWinow',
		doClose: function() {
			tmpShiftPeriodsCount = 0
			this.destroy();
		},
		buttonAlign:'center',
		items : [
			{
				xtype: 'shiftspicker',
				border :false,
				listeners : {
					afterrender : function()
					{
						var selectedTimeVal = Ext.getCmp(shiftId).getValue();
						var shiftsPickerHour = publicJSON['shiftsPickerHour'];
						var shiftsPickerMi = publicJSON['shiftsPickerMi'];
						Ext.getCmp('frHr0').getStore().loadRawData(shiftsPickerHour);
						Ext.getCmp('frMi0').getStore().loadRawData(shiftsPickerMi);
						Ext.getCmp('toHr0').getStore().loadRawData(shiftsPickerHour);
						Ext.getCmp('toMi0').getStore().loadRawData(shiftsPickerMi);
					
						if (Ext.isEmpty(selectedTimeVal))
						{
							Ext.getCmp('frHr0').setValue(Ext.getCmp('frHr0').getStore().getAt(0).get("valueField"));
							Ext.getCmp('frMi0').setValue(Ext.getCmp('frMi0').getStore().getAt(0).get("valueField"));
							Ext.getCmp('toHr0').setValue(Ext.getCmp('toHr0').getStore().getAt(0).get("valueField"));
							Ext.getCmp('toMi0').setValue(Ext.getCmp('toMi0').getStore().getAt(0).get("valueField"));
						}
						else
						{
							var shiftTimeArr = selectedTimeVal.split(",");
							var tmpcount = 1;
							for (var i = 0;i<shiftTimeArr.length;i++)
							{
								if (tmpcount > 1)
								{
									tmpHeight = tmpHeight + 30;
									addShiftTimeTemp();
								}
								var tmpData = shiftTimeArr[i];
								var from = tmpData.substring(0,tmpData.indexOf("-"));
								var to = tmpData.substring(tmpData.indexOf("-")+1);
								var fromHr = from.substring(0,from.indexOf(":"));
								var fromMi = from.substring(from.indexOf(":")+1);
								var toHr = to.substring(0,to.indexOf(":"));
								var toMi = to.substring(to.indexOf(":")+1);
								Ext.getCmp('frHr'+i).setValue(fromHr);
								Ext.getCmp('frMi'+i).setValue(fromMi);
								Ext.getCmp('toHr'+i).setValue(toHr);
								Ext.getCmp('toMi'+i).setValue(toMi);
								tmpcount++;
							}
						}
					}
				}
			}
		],
		buttons : [
			{
				text : 'Add',
				cls: 'button20',
				margin: '0 0 10 0',
				handler : function()
				{
					if (checkInputs())
					{
						var tmpStr = "";
						for (var i=0;i<5;i++)
						{
							var tmpFHr = Ext.getCmp('frHr'+i);
							if (tmpFHr == null)
								continue;

							var tmpFMi = Ext.getCmp('frMi'+i);
							var tmpTHr = Ext.getCmp('toHr'+i);
							var tmpTMi = Ext.getCmp('toMi'+i);
							var tmp = tmpFHr.value+":"+tmpFMi.value+"-"+tmpTHr.value+":"+tmpTMi.value;
							tmpStr += tmp+",";
						}
						tmpStr = tmpStr.substring(0,tmpStr.length-1);
						Ext.getCmp(shiftId).setValue(tmpStr);
						expandWindow.destroy();
						expandWindow = null; 
						tmpShiftPeriodsCount = 0;
					}
				}
			}
		]
	}).show();
	//Ext.getCmp(shiftId).setValue(tmpStr);
	//if (tmpHeight != 0)
	//{
	//	var windowHeight = 128+tmpHeight;
	//	expandWindow.setHeight(windowHeight);
	//}
}

function addShiftTime()
{
	var shiftspickerObj = Ext.getCmp('shiftspicker');
	if (tmpShiftPeriodsCount > 3)
	{
		Ext.MessageBox.alert(pageTitle,userIDValidationMsg48);
		return;
	}
	shiftspickerObj.add(getShiftTimeTemplate(tmpShiftPeriodsCount));
	addValuesToTimePicker(tmpShiftPeriodsCount);
	tmpShiftPeriodsCount++;
	var winObj = Ext.getCmp('shiftsPickerWinow');
	//var windowHeight = winObj.getHeight();
	//windowHeight = windowHeight + 30;
	//winObj.setHeight(windowHeight);
	shiftspickerObj.doLayout();
}

function addShiftTimeTemp()
{
	var shiftspickerObj = Ext.getCmp('shiftspicker');
	shiftspickerObj.add(getShiftTimeTemplate(tmpShiftPeriodsCount));
	addValuesToTimePicker(tmpShiftPeriodsCount);
	tmpShiftPeriodsCount++;
	var winObj = Ext.getCmp('shiftsPickerWinow');
	//var windowHeight = winObj.getHeight();
	//windowHeight = windowHeight + 30;
	//winObj.setHeight(windowHeight);
	shiftspickerObj.doLayout();
}

function removeShiftTime(containerID)
{
	var shiftspickerObj = Ext.getCmp('shiftspicker');
	shiftspickerObj.remove(containerID);
	tmpShiftPeriodsCount--;
	var winObj = Ext.getCmp('shiftsPickerWinow');
	//var windowHeight = winObj.getHeight();
	//windowHeight = windowHeight - 30;
	//winObj.setHeight(windowHeight);
	shiftspickerObj.doLayout();
}

function getShiftTimeTemplate(id)
{
	var tmpId1 = "frHr"+(id+1);
	var tmpId2 = "frMi"+(id+1);
	var tmpId3 = "toHr"+(id+1);
	var tmpId4 = "toMi"+(id+1);
	var conId = "shiftTime"+id
	var tmpShiftData = {
		xtype : 'container',
		id : 'shiftTime'+id,
		layout : {
			type : 'hbox',
			padding : 5
		},
		items : [
			{
				xtype : 'fieldcontainer',
				layout : {
					type : 'hbox',
				},
				labelAlign: 'top',
				labelSeparator: ' ',
				fieldLabel : 'From',
				items : [
					{
						xtype:'scrollcombo',
						id: tmpId1,
						name: tmpId1,
						cls: 'dropdown',
						editable : false,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						width: 100,
					},
					{
						xtype : 'tbspacer',
						width : 20
					},
					{
						xtype:'scrollcombo',
						id: tmpId2,
						name: tmpId2,
						cls: 'dropdown',
						editable : false,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						width: 50,
					},
				]
			},
			{
				xtype : 'tbspacer',
				width : 20
			},
			{
				xtype : 'fieldcontainer',
				layout : {
					type : 'hbox',
				},
				labelAlign: 'top',
				labelSeparator: ' ',
				fieldLabel : 'From',
				items : [
					{
						xtype:'scrollcombo',
						id: tmpId3,
						name: tmpId3,
						cls: 'dropdown',
						editable : false,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						width: 100,
						labelWidth: 50,
					},
					{
						xtype : 'tbspacer',
						width : 20
					},
					{
						xtype:'scrollcombo',
						id: tmpId4,
						name: tmpId4,
						cls: 'dropdown',
						editable : false,
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						width: 50,
					},
					{
						xtype : 'tbspacer',
						width : 20
					},
					{
						xtype : 'container',
						items : [{
							xtype : 'button',
							iconCls : 'iconMinus',
							style : {
								background : 'none',
								border : '0px'
							},
							handler: function()
							{
								removeShiftTime(conId);
							}
						}]
					}
				]
			}
		]
	}
	return tmpShiftData;
}

function addValuesToTimePicker(id)
{
	id = id +1;
	var shiftsPickerHour = publicJSON['shiftsPickerHour'];
	var shiftsPickerMi = publicJSON['shiftsPickerMi'];
	Ext.getCmp('frHr'+id).getStore().loadRawData(shiftsPickerHour);
	Ext.getCmp('frHr'+id).setValue(Ext.getCmp('frHr'+id).getStore().getAt(0).get("valueField"));
	Ext.getCmp('frMi'+id).getStore().loadRawData(shiftsPickerMi);
	Ext.getCmp('frMi'+id).setValue(Ext.getCmp('frMi'+id).getStore().getAt(0).get("valueField"));
	Ext.getCmp('toHr'+id).getStore().loadRawData(shiftsPickerHour);
	Ext.getCmp('toHr'+id).setValue(Ext.getCmp('toHr'+id).getStore().getAt(0).get("valueField"));
	Ext.getCmp('toMi'+id).getStore().loadRawData(shiftsPickerMi);
	Ext.getCmp('toMi'+id).setValue(Ext.getCmp('toMi'+id).getStore().getAt(0).get("valueField"));
}


function checkInputs()
{
	for (var i=0;i<5;i++)
	{
		var tmpFHr = Ext.getCmp('frHr'+i);
		if (tmpFHr == null)
			continue;

		var tmpFMi = Ext.getCmp('frMi'+i);
		var tmpTHr = Ext.getCmp('toHr'+i);
		var tmpTMi = Ext.getCmp('toMi'+i);

		if ((tmpFHr.value == tmpTHr.value && tmpFMi.value == tmpTMi.value) ||
			(tmpFHr.value > tmpTHr.value) || ((tmpFHr.value == tmpTHr.value) && (tmpFMi.value > tmpTMi.value)))
		{
			Ext.MessageBox.alert(pageTitle,userIDValidationMsg49);
			return false;
		}
	}
	return true;
}


function uploadUserImage(imageFor)
{
	var result = appCnt.validateUserForm('logoUpload');
	if(result=="userValid")
	{
		var url  = "";
		var logoPath  = "";
		if (imageFor == "login")
		{
			url = "../servlet/com.eg.EgFileUpload?fromPage=EgConfigLogoMsg.jsp&uploadFor=login&fileExt=gif&uploadFir=manager/tomcat/webapps/final/admin/eg_images/";
			logoPath = "manager/tomcat/webapps/final/admin/eg_images/";
		}
		else if (imageFor == "monitor")
		{
			url = "../servlet/com.eg.EgFileUpload?fromPage=EgConfigLogoMsg.jsp&uploadFor=monitor&fileExt=gif&uploadFir=manager/tomcat/webapps/final/monitor/eg_images/";
			logoPath = "manager/tomcat/webapps/final/monitor/eg_images/";
		}
		else if (imageFor == "reporter")
		{
			url = "../servlet/com.eg.EgFileUpload?fromPage=EgConfigLogoMsg.jsp&uploadFor=reporter&fileExt=gif&uploadFir=manager/tomcat/webapps/final/reporter/images/";
			logoPath = "manager/tomcat/webapps/final/reporter/images/";
		}
		else if (imageFor == "config")
		{
			url = "../servlet/com.eg.EgFileUpload?fromPage=EgConfigLogoMsg.jsp&uploadFor=config&fileExt=gif&uploadFir=manager/tomcat/webapps/final/config/images/";
			logoPath = "manager/tomcat/webapps/final/config/images/";
		}

		var uname = Ext.getCmp('uname').getValue();

		var authenticationType = Ext.getCmp('userAuth').getValue().authentication;
		if (!Ext.isEmpty(publicJSON.isSAMLLoginEnabled) && publicJSON.isSAMLLoginEnabled)
		{
			authenticationType = Ext.getCmp('userAuthSAML').getValue().authenticationSAML
		}

		if(uname !='' && uname != undefined)
		{

			var logoname = uname+"_"+imageFor+".gif";
			if(uname.indexOf("/")>-1)
			{
				var domainName=uname.substring(0,uname.indexOf("/"));
				var userName=uname.substring(uname.indexOf("/")+1,uname.length);
				if(userName.indexOf("(")>-1)
				{
					userName=uname.substring(uname.indexOf("/")+1,uname.indexOf("(")-1);
				}
				logoname=domainName.toLowerCase()+"_"+userName+"_"+imageFor+".gif";
			}
			logoPath = logoPath +logoname;
			url=url+escape(logoname);
		}
		showUserImageUploader(imageFor,url,logoPath);
	}
}

function showUserImageUploader(imageFor,url,logoPath)
{
	fileUploadURI = url;
	filePath = logoPath;
	var expandWindow = Ext.create('Ext.window.Window',{
		title:'Files to be uploaded',
		requires : ['EgChangeUserProfile.view.FileUpload'],
		width:500,
		imageFor : imageFor,
		id : 'fileUpLoader',
		modal : true,
		doClose: function() {
			this.destroy();
		},
		getCurrentUploaderInfo : function()
		{
			return this.imageFor;
		},
		items : [
			{
				xtype : 'fileupload',
			}
		],
	}).show();
	if (!Ext.isEmpty(imageFor) && imageFor == 'login')
	{
		Ext.getCmp('specificationId').setValue('Type:GIF, JPEG, PNG, JPG;  Size:300KB;  Resolution:225x70pixels');
	}
}

function loadConfigPage(category,serverName)
{
	var tmpUsrStr = Ext.getCmp('uname').getValue();
	var url = '';
	if (category == "userExternalAgents")
	{
		url = "/final/admin/EgComponentZones.jsp?username="+tmpUsrStr+"&comefrom=userpage&qctr=0&mode=modify&zone="+encodeURIComponent(serverName);
	}

	if (category == "userRemoteAgents")
	{
		url = "/final/admin/EgComponentZones.jsp?username="+tmpUsrStr+"&comefrom=userpage&qctr=0&mode=modify&zone="+encodeURIComponent(serverName);
	}

	if (category == "userZones")
	{
		url = "/final/admin/EgComponentZones.jsp?username="+tmpUsrStr+"&comefrom=userpage&qctr=0&mode=modify&zone="+encodeURIComponent(serverName);
	}

	if (category == "userServices")
	{
		url = "/final/admin/EgComponentServices.jsp?username="+tmpUsrStr+"&comefrom=userpage&modify=true&site="+encodeURIComponent(serverName);
	}

	if (category == "userServiceGroups")
	{
		url = "/final/admin/EgComponentServiceGroup.jsp?username="+tmpUsrStr+"&returnToMain=userpage&modify=true&site="+encodeURIComponent(serverName);
	}

	if (category == "userSegments")
	{
		url = "/final/admin/EgComponentSegments.jsp?username="+tmpUsrStr+"&returnTo=userpage&qctr=0&segment="+encodeURIComponent(serverName);
	}

	if (category == "userComponenets" || category == "userAutoComps")
	{
		if (serverName.indexOf("Agg_") != -1)
		{
			url = "/final/admin/EgAggregateTree.jsp?qctr=1&isAggregateLink=true&reqfrom=modifyuser&username="+encodeURIComponent(tmpUsrStr)+"&server="+encodeURIComponent(serverName)+"&category=-1&isFromModifyUser=true";
		}
		else
		{
			url = "/final/admin/EgDispServer.jsp?username="+tmpUsrStr+"&comptype="+serverName+"&category=-1";
		}
	}
	window.location.href = url;
}

function changeDisplayName(name)
{
	if (!Ext.isEmpty(name) && name != 'undefined')
	{
		if (name.indexOf("/Grp/") != -1)
		{
			var grpDelimiter = "/Grp/";
			var idx = name.indexOf(grpDelimiter);
			var str_uname_A = name.substring(0,idx);
			var nextIdx = idx + grpDelimiter.length;
			var str_uname_B = name.substring(nextIdx);
			name = str_uname_A + "/" + str_uname_B + " (Group)";
		}
		else if (name.indexOf("samlsso/") != -1)
		{
			var idx = name.indexOf("/");
			var str_uname_A = name.substring(idx+1);
			name = str_uname_A + " (SAML)";
		}
		return name;
	}
	return "";
}

function addAutomanageSrvs(tmpSrvList,obj)
{
	var selectedCategoryList = Ext.getCmp('serverCategoryList').getValue();
	var tempSrvList = tmpSrvList.toString();
	
	var temp;
	if (tempSrvList != null)
	{
		temp = tempSrvList.split(",");
	}

	if (temp != "" && temp.length > 0)
	{
		if (selectedCategoryArr.indexOf(selectedCategoryList) == -1)
		{
			selectedCategoryArr.push(selectedCategoryList);
			for (var i=0; i<temp.length; i++)
			{
				var tmpStr = temp[i];
				if (srvListArray.indexOf(tmpStr) == -1)
				{
					srvListArray.push(tmpStr);
				}				
			}
			if (obj.getValue() !== undefined)
			{
				toFieldData(obj);
			}
		}
		else
		{
			for (var i=0; i<temp.length; i++)
			{
				var tmpStr2 = temp[i];
				if (srvListArray.indexOf(tmpStr2) == -1)
				{
					srvListArray.push(tmpStr2);
				}
			}
			if (obj.getValue() !== undefined)
			{
				toFieldData(obj);
			}
		}
	}
	else
	{
		toFieldData(obj);
	}
}

function fromFieldData(obj)
{
	var itemSelObj = obj;
	var storeObj = itemSelObj.fromField.store;
	var associatedNow = '';
	var count = storeObj.getCount();
	for (var s=0; s < count; s++)
	{
		var newVal = storeObj.getAt(s).get('valueField');
		if (s == (count-1))
		{
			associatedNow += newVal;
		}
		else
		{
			associatedNow += newVal+',';
		}
	}
	addAutomanageSrvs(associatedNow,obj);
}

function toFieldData(obj)
{
	unmanageList = obj.getValue();
	var tmpList = unmanageList.toString();
	var tmpArr = tmpList.split(",");

	if (tmpArr != "" && tmpArr.length > 0)
	{
		for (var i=0; i<tmpArr.length; i++)
		{
			var tmpStr = tmpArr[i];
			for (var u=0; u<srvListArray.length; u++)
			{
				if (srvListArray[u].indexOf(tmpStr) != -1)
				{
					var pos = srvListArray.indexOf(srvListArray[u]);
					srvListArray.splice(pos, 1);
				}
			}
		}
	}
}



