Ext.define('EgChangeUserProfile.view.ElementAssociationForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.elementassociationform',
	id : 'elementassociationform',
	name : 'elementassociationform',
	requires : ['utilities.ScrollCombo'],

	border : false,

	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	flex: 1,

	items : [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '15 0 0 0',
			items : [
				{
					xtype: 'displayfield',
					fieldLabel: '<b>'+userIDValidationMsg59+'</b>',
					labelAlign: 'top',
					labelSeparator: ' ',
					value: '',
					id : 'elementUserID',
					width: 150,
					hidden: true
				},
				{
					xtype:'scrollcombo',
					cls: 'dropdown',
					editable : false,
					fieldLabel: orgTypeLabel,
					name: 'orgType',
					id: 'orgType',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					hidden: true,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 230,
					margin: '0 20 0 0'
				},
				{
					xtype:'scrollcombo',
					cls: 'dropdown',
					editable : false,
					fieldLabel:'Associate',
					name: 'associate',
					id: 'associate',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 230
				},
				{
					xtype:'scrollcombo',
					cls: 'dropdown',
					editable : false,
					fieldLabel:'Component type',
					name: 'compType',
					id: 'compType',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					hidden: true,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 230,
					margin: '0 0 0 20'
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '15 0 0 0',
			items : [
				{
					xtype:'scrollcombo',
					cls: 'dropdown',
					editable : false,
					id : 'virtualTypes',
					name : 'virtualTypes',
					fieldLabel:'Vitual type',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					hidden : true,
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 230,
					margin: '0 20 0 0'
				},
				{
					xtype: 'container',
					id : 'virtualServersContainer',
					hidden : true,
					width: 230,
					items: [
						{
							xtype: 'label',
							id : 'vmTypeLabel',
							text: 'Hypervisor Hosts'
						},
						{
							xype: 'container',
							layout:{
								type:'hbox',
								align:'center'
							},
							items: [
								{
									xype: 'container',
									cls: 'multisearchlist',
									items: [
										{
											xtype: 'trigger',
											labelAlign: 'top',
											name: 'compSearch',
											emptyText: 'Search Components',
											cls: 'whitedropdown_search',
											width: 198,
											listeners:
											{
												'change':function(obj)
												{
													if (Ext.isEmpty(EgChangeUserProfile.app.erUtils))
														EgChangeUserProfile.app.erUtils = Ext.widget("erutils");

													EgChangeUserProfile.app.erUtils.filterComboStore(obj,Ext.getCmp("virtualServers"),EgChangeUserProfile.compRawData);
												}
											}
										}
									]
								},
								{
									xtype: 'container',
									margin: '0 0 0 2',
									items: [
										{
											xtype: 'button',
											iconCls: 'iconMultiselectExpand',
											listeners: {
												'afterrender': function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html: 'Components'
													});
												},
												'click':function(btn){
													if (Ext.isEmpty(EgChangeUserProfile.app.erUtils))
														EgChangeUserProfile.app.erUtils = Ext.widget("erutils");
													
														EgChangeUserProfile.app.erUtils.expandMultiComboButton(Ext.getCmp('virtualServers'),'Hypervisor Hosts',btn);	
												}
											},
											style: {
												background: 'none',
												border: '0px'
											}
										}
									 ]
								}
							]
						}, 
						{
							xtype: 'multiselectfield',
							autoScroll:true,
							scroll:true,
							labelAlign:'left',
							width: 210,
							height: 100,
							id: 'virtualServers',
							name: 'virtualServers',
							store: Ext.data.Store
							({
								fields: ['displayField','valueField'],
								data : [{displayField: "",valueField:""}]
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local'
						},
						{
							hidden:true,
							xtype: 'button',
							text : 'Get VMs',
							id : 'getVm',
							cls: 'button20',
							width: 100,
							margin: '5 0 0 0'
						}
					]
				},
				{
					xtype: 'container',
					margin: '0 0 0 20',
					width: 230,
					items : [
						{
							xtype: 'radiogroup',
							id : 'vmSelection',
							fieldLabel: '',
							cls: 'radiobt',
							columns: 1,
							vertical: true,
							hidden:true,
							items: [
								{ boxLabel: 'Associate specific VMs', name: 'vmselectiongrp', id:'vmselectionspecific', inputValue:1},
								{ boxLabel: 'Associate VMs by Names/Patterns', name: 'vmselectiongrp', id:'vmselectionpattern', inputValue:2},
								{ boxLabel: 'All VMs', name: 'vmselectiongrp', id:'vmselectionall', inputValue: 3}
							]
						},
						{
							xtype: 'container',
							id : 'patternContainer',
							layout: {
								type: 'hbox',
								pack: 'start'
							},
							hidden: true,
							margin: '10 0 0 0',
							items: [
								{
									xtype: 'textfield',
									cls: 'textbox',
									id: 'patternName',
									name: 'patternName',
									fieldLabel:'Names/Patterns',
									labelAlign: 'top',
									labelSeparator: '',
									width: 230,
									//margin: '0 5 0 0',
									value: ''
								},
								{
									xtype : 'button',
									iconCls : 'iconAdd',
									tooltip: 'Add patterns',
									style : {
										background : 'none',
										border : '0px'
									},
									hidden:true,
									listeners: {
										click: function()
										{
											appCnt.configPatternTypes();
										}
									}
								}
							]
						}
					]
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'vbox',
						pack: 'start',
						align: 'left'
					},
					margin: '15 0 0 0',
					width: 500,
					items: [
						{
							xtype: 'checkboxfield',
							id : 'compAssociation',
							name : 'compAssociation',
							inputValue: 'on',
							boxLabel  : 'Auto associate all components',
							width: 350,
							cls: 'checkbt',
							checked : false,
							hidden: true
						}
					]
				}
			]
		},
		/*{
			xtype: 'container',
			id : 'searchFieldContainer',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			hidden: true,
			items: [
				{
					xtype: 'container',
					width: 385,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype: 'trigger',
							id : 'managedSeacrchBox',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							cls: 'whitedropdown_search',
							emptyText: 'Search',
							margin: '0 0 5 0',
							getTriggerMarkup: function() {
								var me = this,
									i = 0,
									hideTrigger = (me.readOnly || me.hideTrigger),
									triggerCls,
									triggerBaseCls = me.triggerBaseCls,
									triggerConfigs = [],
									unselectableCls = Ext.dom.Element.unselectableCls,
									style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
									cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}

								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+me.id+'_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+me.id+'_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

								return Ext.DomHelper.markup(triggerConfigs);
							},
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								appCnt.searchComponent("managed",this.getValue());
							},
							listeners :
							{
								change : function(obj)
								{
									appCnt.searchComponent("managed",obj.getValue());
								},
								specialkey: function(field, e){
									// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
									// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
									if (e.getKey() == e.ENTER) {
										appCnt.searchComponent("managed",field.getValue());
									}
								}
							}
						}
					]
				},
				{
					xtype: 'tbspacer',
					width: 30
				},
				{
					xtype: 'container',
					width: 385,
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					items: [
						{
							xtype: 'trigger',
							id : 'unmanagedSeacrchBox',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger',
							cls: 'whitedropdown_search',
							emptyText: 'Search',
							margin: '0 0 5 0',
							getTriggerMarkup: function() {
								var me = this,
									i = 0,
									hideTrigger = (me.readOnly || me.hideTrigger),
									triggerCls,
									triggerBaseCls = me.triggerBaseCls,
									triggerConfigs = [],
									unselectableCls = Ext.dom.Element.unselectableCls,
									style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
									cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}

								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+me.id+'_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+me.id+'_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

								return Ext.DomHelper.markup(triggerConfigs);
							},
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								appCnt.searchComponent("unmanaged",this.getValue());
							},
							listeners :
							{
								change : function(obj)
								{
									appCnt.searchComponent("unmanaged",obj.getValue());
								},
								specialkey: function(field, e){
									// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
									// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
									if (e.getKey() == e.ENTER) {
										appCnt.searchComponent("unmanaged",field.getValue());
									}
								}
							}
						}
					]
				}
			]
		},*/
		{
			xtype: 'container',
			id : 'selectorFieldContainer',
			//hidden:true,
			layout: {
				type: 'hbox',
				pack: 'center',
				align: 'stretch'
			},
			flex: 1,
			margin: '5 0 0 0',
			items : [
				{
					xtype: 'itemselector',
					id: 'otherHosts',
					name: 'otherHosts',
					cls: 'itemselector',
					style: {
					'background': 'none'
					},
					buttons: ['add', 'remove'],
					buttonsText: {
						add: "Disassociate",
						remove: "Associate",
					},
					fromTitle:'Associated',
					toTitle:'Available',
					titleAlign : 'center',
					multiSelect: true,
					height: 250,
					width: 800,
					displayField: 'displayField',
					valueField: 'valueField',
					store: Ext.create('Ext.data.Store', {
						fields: ['valueField', 'displayField'],
						data: []
					}),
					onRemoveBtnClick : function () {
								appCnt.onItemSelection();
								var me = this,
								selected = me.getSelections(me.toField.boundList);
								me.moveRec(false, selected);
								me.fromField.boundList.getSelectionModel().select(selected);
					},
					onAddBtnClick : function () {
								appCnt.onItemSelection();
								var me = this,
								selected = me.getSelections(me.fromField.boundList);
								me.moveRec(true, selected);
								me.toField.boundList.getSelectionModel().select(selected);
					},
					onItemDblClick: function(view, rec) {
								appCnt.onItemSelection();
								this.moveRec(view === this.fromField.boundList, rec);
					}
				}
			]
		},
		{
			xtype: 'container',
			id : 'elementsHiddenContainer',
			hidden: true
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '20 0 10 0',
			items: [
				{
					xtype: 'button',
					text : pageIntnl84,
					id : 'apply',
					cls: 'button20',
					width: 150
				},
				{
					xtype: 'button',
					text: pageIntnl85,
					width: 80,
					id : 'finish',
					cls: 'button20',
					margin: '0 0 0 20'
				},
				{
					xtype: 'button',
					text: pageIntnl86,
					id : 'btnViewElements',
					cls: 'button20',
					margin: '0 0 0 20',
					width: 180
				}
			]
		}
	]

});



