
var originalShow = Ext.window.MessageBox.prototype.show;
Ext.override(Ext.window.MessageBox,{

	minWidth : 300,

	show: function(cfg) {

		if (cfg != undefined && cfg.msg != undefined)
		{
			cfg.msg = Ext.String.trim(cfg.msg);
			var lastChar = cfg.msg.charAt(cfg.msg.length-1);
			if (lastChar  !=  '.'  &&  lastChar  !=  '?')
			{
				cfg.msg = cfg.msg + ".";
			}
		}

		if (cfg != undefined && cfg.msg != undefined && !cfg.hasOwnProperty("width"))
		{
			var tmpWidth = cfg.msg.length * 7;
			Ext.applyIf(cfg,{width : tmpWidth});
		}
		originalShow.apply(this, arguments);
	},

	alert: function(cfg, msg, fn, scope) {

		if (Ext.isString(cfg)) {

			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '.'  &&  lastChar  !=  '?')
				{
					msg = msg + ".";
				}
			}

			cfg = {
				title : cfg,
				msg : msg ,
				buttons: this.OK,
				icon : 'iconExclamation',
				fn: fn,
				scope : scope,
				minWidth: this.minWidth
			};
		}
		return this.show(cfg);
	},

	confirm: function(cfg, msg, fn, scope) {

		if (Ext.isString(cfg)) {

			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '?')
				{
								msg = msg + "?";
				}
			}

			cfg = {
				title: cfg,
				icon: 'iconConfirmation',
				msg: msg,
				buttons: this.YESNO,
				callback: fn,
				scope: scope
			};
		}
		return this.show(cfg);
	}
});

Ext.override(Ext.form.field.File,{
	listeners: {
		change: function(field, value) {
			if(value.indexOf("\\")> -1)
				filename = value.substring(value.lastIndexOf("\\")+1,value.length);
			else if(value.indexOf("/")> -1)
				filename = value.substring(value.lastIndexOf("/")+1,value.length);
			else
				filename = value;
			field.setRawValue(filename);
		}
	}
});

Ext.override(Ext.form.field.Text,{
	listeners: {
		change : function(field,newValue,OldValue) {
			if((newValue != OldValue) && (OldValue != undefined) && (OldValue != ''))
			{
				updateSettings = true;
			}
		}
	}
});

Ext.override(Ext.form.field.ComboBox,{
	listeners: {
		select : function(obj) {
			var id = obj.getId();
			if(id != 'uname' || id != 'associate' || id != 'virtualTypes' || id != 'compType' || id != 'filter' || id != 'CompTypes' || id != 'compTypesIn' || id != 'serseg' || id != 'Test' || id != 'orgType' || id != 'virtualTypes')
			{
				updateSettings = true;
			}
		}
	}
});

Ext.override(Ext.form.RadioGroup,{
	listeners: {
		change : function(field,newValue,OldValue) {
			if((newValue != OldValue) && (OldValue != undefined) && (OldValue != ''))
			{
				updateSettings = true;
			}
		}
	}
});

Ext.override(Ext.form.field.Checkbox,{
	listeners: {
		change : function(field,newValue,OldValue){
			if((newValue != OldValue) && (OldValue != undefined) && (OldValue != ''))
			{
				updateSettings = true;
			}
		}
	}
});

Ext.override(Ext.form.CheckboxGroup,{
	listeners: {
		change : function(field,newValue,OldValue){
			if((newValue != OldValue) && (OldValue != undefined) && (OldValue != ''))
			{
				updateSettings = true;
			}
		}
	}
});


Ext.define('EgChangeUserProfile.view.Viewport', {
	extend: 'Ext.container.Viewport',
	layout: 'fit',
	requires: [
		'EgChangeUserProfile.view.Main'
	],
	initComponent: function() {

		if (Ext.get('loadmask'))
		{
			Ext.get('loadmask').remove();
		}
		this.items = [
			{
				xtype: 'main'
			}
		];
		this.callParent();
	},
	listeners: {
		'beforerender': function() 
		{
			if (!Ext.isEmpty(fromWizard))
			{
				Ext.getCmp('main').closable=(true);
			}
		},
		'beforeadd': function() 
		{
			if (!Ext.isEmpty(fromWizard))
			{
				if (!Ext.isEmpty(Ext.getCmp('main')))
				{
					Ext.getCmp('main').closable=(true);
				}
			}
		}
	}

});



