<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.ini.IniUI"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import = "net.sf.json.*"%>
<jsp:useBean id="DiscBean" scope="page" class="egurkha.ServiceBean"/>
<jsp:useBean id="port" scope="page" class="egurkha.ServiceBean"/>

<%
	JSONObject rootObj = new JSONObject();
	JSONObject generalSettings = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	EgMappingInfo egMappingInfo=new EgMappingInfo(trackerLanguage);
	String from=request.getParameter("from");
	String selectedCompDetails = request.getParameter("selectedCompDetails");
	
	String userLanguage = _user.getLanguage();
	IniUI  iniUI = IniUI.getInstance();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();

	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	
	if (from.equalsIgnoreCase("commonSettings"))
	{
		IniFile infraPtr = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
		String DiscOptions = request.getParameter("DiscOptions");
		String serverDisplay = request.getParameter("ServerDisplay");
		String loadCount = request.getParameter("LoadCount");

		port.createAdmin();
		DiscBean.createAdmin();
		
		ArrayList server_list = new ArrayList();
		ArrayList serverDisplayList = new ArrayList();
		ArrayList compList = new ArrayList();
		ArrayList manageSrvrListShow = new ArrayList();

		String[] server_manage_types = null;
		if (serverDisplay != null && serverDisplay != "")
		{
			StringTokenizer serverDisplayTkns = new StringTokenizer(serverDisplay, ",");
			while(serverDisplayTkns.hasMoreElements())
			{
				String serverDisplayTkn = (String)serverDisplayTkns.nextToken();
				serverDisplayList.add(serverDisplayTkn);
			}
			server_manage_types = (String[])serverDisplayList.toArray(new String[0]);
		}

		if(DiscOptions==null || DiscOptions.length()==0) DiscOptions = "all";
		String categoryOptions="";
		StringBuffer categoryBuff = new StringBuffer();
		StringTokenizer stz = new StringTokenizer(DiscOptions,",");
		while(stz.hasMoreTokens())
		{
			String tok = stz.nextToken();
			if(tok.equalsIgnoreCase("all"))
			{
				DiscOptions = "all";
				break;
			}
		}
		if(DiscOptions.equalsIgnoreCase("all"))
		{
			String[] categVar = infraPtr.getSubjects();
			if(categVar!=null && categVar.length>0)
			{
				for(int i=0;i<categVar.length;i++)
				{
					String var = (String)categVar[i];
					categoryBuff.append(var);
					categoryBuff.append(",");
				}
			}
			categoryBuff.append("OTHERS");
			categoryOptions = categoryBuff.toString();
		}
		else 
		{
			categoryOptions = DiscOptions;
		}
		
		String[] server_types = port.getAllValidServerTypesForDiscovery();
		
		if(categoryOptions!=null)
		{
			categoryOptions = categoryOptions.trim();
			StringTokenizer st = new StringTokenizer(categoryOptions,",");
			while(st.hasMoreTokens())
			{
				String token = (String)st.nextToken();
				String[] filteredServerTypes= getServerTypesBasedOnPriority(token,server_types,infraPtr);
				for(int j=0;j<filteredServerTypes.length;j++)
				{
					if(filteredServerTypes[j] == null) continue;
					if(filteredServerTypes[j].startsWith("#"))
					{
						compList.add(filteredServerTypes[j].substring(1));
					}
					else
					{
						compList.add(filteredServerTypes[j]);
						//server_list.add(filteredServerTypes[j]);
					}
				}
					
				if (server_manage_types != null)
				{
					String[] filteredServerTypesShow= getServerTypesBasedOnPriority(token,server_manage_types,infraPtr);
					for(int j=0;j<filteredServerTypesShow.length;j++)
					{
						String servTypes = filteredServerTypesShow[j];
						if(servTypes == null || servTypes.startsWith("#")) 
						{
							continue;
						}
						manageSrvrListShow.add(servTypes);
					}
				}
			}
		}
		
		if (selectedCompDetails != null && selectedCompDetails.length() > 0)
		{
			StringTokenizer str = new StringTokenizer(selectedCompDetails,",");
			while (str.hasMoreTokens())
			{
				String tmp = str.nextToken();
				if (!server_list.contains(tmp))
				{
					server_list.add(tmp);
				}
			}
		}
		server_list = sorter.getSortedCompTypeList(server_list);

		JSONArray tmpList = new JSONArray();
		JSONObject tmpObject = new JSONObject();
		JSONObject availSrvrObj = new JSONObject();
		JSONArray discSrvrArray = new JSONArray();
		int colCount = 0;

		for (int i = 0;i<server_list.size();i++)
		{
			colCount++;
			EgName nameObj = (EgName)server_list.get(i);
			String tmpVal = nameObj.getActualName();
			String tmpDis = nameObj.getLocalName();
			availSrvrObj.put("displayField",tmpDis);
			availSrvrObj.put("valueField",tmpVal);
			discSrvrArray.add(availSrvrObj);
			
			if (colCount == 3)
			{
				tmpObject.put("col_"+colCount , tmpDis);
				tmpObject.put("valueField_"+colCount , tmpVal);
				tmpList.add(tmpObject);
				tmpObject = new JSONObject();
				colCount = 0;
			}
			else
			{
				tmpObject.put("col_"+colCount , tmpDis);
				tmpObject.put("valueField_"+colCount , tmpVal);
			}
		}
		if (colCount == 1)
		{
			tmpObject.put("col_2","");
			tmpObject.put("col_3","");
			tmpObject.put("valueField_2" , "");
			tmpObject.put("valueField_3" , "");
			tmpList.add(tmpObject);
		}
		if (colCount == 2)
		{
			tmpObject.put("col_3","");
			tmpObject.put("valueField_3" , "");
			tmpList.add(tmpObject);
		}

		generalSettings.put("configuredServersList",tmpList);
		generalSettings.put("configuredServersCount",server_list.size());

		// server category - start
		JSONObject serverCategory = new JSONObject();
		JSONArray serverCategoryArr = new JSONArray();
		generalSettings.put("isAllSelected",DiscOptions);

		serverCategory.put("displayField",_mapping.getTextDescription("admin.discovery.ALL"));
		serverCategory.put("valueField","all");
		serverCategoryArr.add(serverCategory);

		String[] servertypes=DiscBean.getAllValidServerTypesForDiscovery();
		ArrayList serverGrps = getAllServerGroups(servertypes);
		for(int i=0; i<serverGrps.size(); i++)
		{
			serverCategory = new JSONObject();
			String tmpServerGrp = (String)serverGrps.get(i);
			serverCategory.put("valueField",tmpServerGrp);
			serverCategory.put("displayField",getCapitalizedCategory(tmpServerGrp));
			serverCategoryArr.add(serverCategory);
		}
		generalSettings.put("serverCategoryArr",serverCategoryArr);
		// server category - end

		int count = 0;
		compList = sorter.getSortedCompTypeList(compList);
		JSONArray serverTypesArr = new JSONArray();
		for (int i=0;i<compList.size();i++)
		{
			JSONObject tmServer = new JSONObject();
			EgName tmpServer = (EgName)compList.get(i);
			String actualName = (String)tmpServer.getActualName();
			String displayName = (String)tmpServer.getLocalName();
			tmServer.put("displayField",displayName);
			tmServer.put("valueField",actualName);
			serverTypesArr.add(tmServer);
		}
		
		JSONArray selectedSrvrTypesArr = new JSONArray();
		if (serverDisplay != null && serverDisplay != "")
		{
			manageSrvrListShow = sorter.getSortedCompTypeList(manageSrvrListShow);
			JSONObject tempSrvr = new JSONObject();
			for(int m=0; m<manageSrvrListShow.size(); m++)
			{
				EgName nameObj1 = (EgName)manageSrvrListShow.get(m);
				String tmpVal1 = nameObj1.getActualName();
				String tmpDis1 = nameObj1.getLocalName();
				tempSrvr.put("displayField",tmpDis1);
				tempSrvr.put("valueField",tmpVal1);
				selectedSrvrTypesArr.add(tempSrvr);
			}
			generalSettings.put("discSrvrArray",selectedSrvrTypesArr);
			serverTypesArr.removeAll(selectedSrvrTypesArr);
		}
		else if (serverDisplay == null && loadCount != null)
		{
			if (loadCount.equalsIgnoreCase("0"))
			{
				generalSettings.put("discSrvrArray",discSrvrArray);
				serverTypesArr.removeAll(discSrvrArray);
			}
		}
		else
		{
			discSrvrArray.clear();
			generalSettings.put("discSrvrArray",discSrvrArray);
		}
		generalSettings.put("allSrvrArray",serverTypesArr);
		
		rootObj.put("generalSettings",generalSettings);
	}
	out.println(rootObj.toString());
%>

<%!
	public ArrayList tempServers = new ArrayList();

	public String[] getServerTypesBasedOnPriority(String categoryOption,String [] validServerTypes,IniFile infraPtr)
	{
		String [] result= null;
		if(categoryOption.equalsIgnoreCase("others"))
		{
			ArrayList serversGrpList = getOtherServers(validServerTypes);
			result=new String[serversGrpList.size()];
			for(int j=0;j<serversGrpList.size();j++)
			{
				String otherServer=(String)serversGrpList.get(j);
				result[j]=new String(otherServer);
			}
		}
		else
		{
			List validServerList = Arrays.asList(validServerTypes);
			String [] thisvars=infraPtr.getVariables(categoryOption);
			if(thisvars!=null)
			{
				result=new String[thisvars.length];
				for(int t=0; t<thisvars.length; t++)
				{
					String thisComp = (String)thisvars[t];
					if(validServerList.contains(thisComp)){
						result[t]=new String(thisComp);
					}
					else if(validServerList.contains("#"+thisComp)){
						result[t]=new String("#"+thisComp);
					}
				}
			}
		}
		return result;
	}
	
	public ArrayList getAllServerGroups(String[] servertypes)
	{
		List validServerList = Arrays.asList(servertypes);	
		ArrayList grp = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects = iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				String subject = Subjects[i];
				String[] allVariables = iniFile.getVariables(subject);
				if(allVariables==null || allVariables.length==0)
					continue;
				
				boolean hasVar = false;
				for(int g=0;g<allVariables.length;g++)
				{
					String variable = allVariables[g];
					if(validServerList.contains(variable) || validServerList.contains("#"+variable))
						hasVar = true;
				}
				if(!hasVar) continue;
				grp.add(subject);
			}
			Collections.sort(grp,String.CASE_INSENSITIVE_ORDER);
			grp.remove("AGGREGATES");
			ArrayList otherServers = getOtherServers(servertypes);
			if(otherServers!=null && otherServers.size()>0)
				grp.add("OTHERS");
			return grp;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return new ArrayList();
		}
	}

	public String getCapitalizedCategory(String categoryName)
	{
		StringBuffer buff = new StringBuffer();
		int j = 0;
		if (categoryName != null)
		{
			//for (int i = 0;i<grps.size();i++ )
			//{
				//String val = (String)grps.get(i);
				
				if (categoryName.equalsIgnoreCase("JAVAAPP_SERVERS")){
					categoryName = "JAVA_APPLICATION_SERVERS";
				}
				if (categoryName.indexOf("_") != -1)
				{
					categoryName = StringUtils.replace(categoryName,"_"," ");
				}
				StringTokenizer tokens = new StringTokenizer(categoryName," ");
				while(tokens.hasMoreTokens())
				{
					String token = tokens.nextToken();
					token = token.trim();
					token = token.toLowerCase();
					String sub = token.substring(1);
					String initial = (token.substring(0,1)).toUpperCase();
					if (token.equalsIgnoreCase("UPS"))
					{
						initial = "UPS";
					}
					else
					{
						initial = initial + sub;
					}
					if (j == 0)
					{
						buff.append(initial);
					}
					else
					{
						buff.append(" ");
						buff.append(initial);
					}
					j++;
				}
			//}
		}
		return buff.toString();
	}
	
	public void getAllInfraServers()
	{
		ArrayList comGroups = new ArrayList();
		try
		{
			IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() +"/manager/config/eg_infrastructure.ini");
			String[] Subjects= iniFile.getSubjects();
			for (int i = 0;i<Subjects.length;i++ )
			{
				if (Subjects[i] != null && Subjects[i].equalsIgnoreCase("AGGREGATES"))
				{
					continue;
				}

				String [] variables = iniFile.getVariables(Subjects[i]);
				for (int j = 0;j<variables.length;j++)
				{
					if(!tempServers.contains(variables[j]))
						tempServers.add(variables[j]);
				}
			}
		}
		catch (Exception e)
		{
		}
	}

	public ArrayList getOtherServers(String[] servertypes)
	{
		List validServerList = Arrays.asList(servertypes);
		getAllInfraServers();
		ArrayList serverList = new ArrayList();
		EgDiscInfo egDisc = new EgDiscInfo("manager");
		String[] otherServers = egDisc.getComponentTypes();
		if (otherServers == null || otherServers.length == 0)
		{
			return new ArrayList();
		}

		for(int i=0; i<otherServers.length; i++)
		{
			String otherServer = otherServers[i];
			if (!otherServer.equals("Site_servers"))
			{
				if (!tempServers.contains(otherServer))
				{
					if(validServerList.contains(otherServer))
						serverList.add(otherServer);
					else if(validServerList.contains("#"+otherServer))
						serverList.add("#"+otherServer);
				}
			}
		}
		return serverList;
	}
%>



