var elemList;
Ext.define('EgConfigEnv.controller.Main',{
	extend: 'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector: 'main', ref: 'main'},
		{selector: 'fileuploadform', ref: 'fileuploadform'}
	],
	init:function()
	{
		appCtn = this;
		this.buildMainData();
		this.control({
			'main':
			{
				'afterrender': this.initServerDetails
			},
			'main button[id="backButton"]':
			{
				'click':this.goBack
			},
			'main button[id="Update"]':
			{
				'click':this.updateComponentDetails
			},
			'main combo[id="servertypes"]':
			{
				'select':this.serverOnChange
			},
			'main button[id="deleteManaged"]':
			{
				'click':this.deleteManagedComponent
			},
			'main button[id="deleteUnManaged"]':
			{
				'click':this.deleteUnManagedComponent
			},
			'main itemselectorfield[id="componentDetails"]':
			{
				//'dirtychange':this.changeComponentState
			},
			'main checkboxfield[id="activeCompTypes"]':
			{
				'change':this.showActiveComponents
			},
			'main button[id="systems"]':
			{
				'click':this.loadManageBySystems
			},
			'main button[action="openPopupWin"]':
			{
				'click':this.openPopupWin
			},
			'fileuploadform button[action="bulkComponentAction"]' :
			{
				'click' : this.bulkComponentAction
			}
		})
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url : appURL,
			method : 'POST',
			async : false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	loadManageBySystems : function()
	{
		window.location.href = "EgManageServers.jsp?backButton=true&reqfrom="+reqfrom+"&srvtype="+encodeURIComponent(Ext.getCmp('servertypes').getValue())+"&fromWizard="+fromWizard;

		if(isLimitedAdmin == 'true')
		{
			Ext.getCmp('bulkManageOrUnmanage').hide();
		}
		else
		{
			Ext.getCmp('bulkManageOrUnmanage').show();
		}
	},
	changeComponentState : function()
	{
		isComponentUpdated = false;
	},
	deleteManagedComponent : function(isProceed)
	{
		var me = this;
		var funmng = "";
		var fmng = "";
		var fmngwithcomptype = "";
		var srvtype = Ext.getCmp('servertypes').getValue();
		Ext.getCmp("server").setValue(srvtype);
		var tmpStore = Ext.getCmp('componentDetails');
		//alert(tmpStore.fromField.getSelected());
		//var managedComponents = tmpStore.fromField.getSelectionModel().getSelection();
		var fromList = tmpStore.fromField.boundList;
		var selectedList = tmpStore.getSelections(fromList);
		for (var key in selectedList)
		{
			var tmpData = selectedList[key].get("valueField");
			fmng = fmng + tmpData + ",";
			fmngwithcomptype = fmngwithcomptype + srvtype + ":" + tmpData + ",";
		}
		if(fmng == "")
		{
			Ext.Msg.alert(pageTitle,intnlLabel8);
		}
		else if (isComponentUpdated != true)
		{
			Ext.Msg.alert(pageTitle,intnlLabel9);
		}
		else
		{
			if (isProceed != null && isProceed !== undefined && isProceed == true)
			{
				Ext.getCmp("fmanage").setValue(fmng);
				Ext.getCmp("funmanage").setValue(funmng);
				Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
				var tmpURL = "EgConfigEnv/data/EgdeleteserverpJson.jsp?performaction=true";
				tmpURL += "&isProceed="+isProceed;
				me.deleteSelectedComponent(tmpURL);
			}
			else
			{
				if(reDiscDelComp.toLowerCase() == 'no' || reDiscDelComp.toLowerCase() == 'false')
				{
					Ext.MessageBox.confirm(pageTitle, intnlLabel14,
						function (btn){
							if (btn == "yes")
							{
								Ext.getCmp("fmanage").setValue(fmng);
								Ext.getCmp("funmanage").setValue(funmng);
								Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
								var tmpURL = "EgConfigEnv/data/EgdeleteserverpJson.jsp?performaction=true";
								me.deleteSelectedComponent(tmpURL);
							}
						}
					);
				}
				else
				{
					Ext.getCmp("fmanage").setValue(fmng);
					Ext.getCmp("funmanage").setValue(funmng);
					Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
					var tmpURL = "EgConfigEnv/data/EgdeleteserverpJson.jsp?performaction=true";
					me.deleteSelectedComponent(tmpURL);
				}
			}
		}
	},
	deleteSelectedComponent : function(tmpURL)
	{
		var me = this;
		elemList = "";
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var hiddenFields = this.getHiddenFields();
		var frmMain = this.getMain().getForm();
		if (frmMain.isValid())
		{
			this.getMain().submit({
				url: tmpURL+'&'+hiddenFields,
				method: 'POST',
				timeout : 300,
				//standardSubmit: true,
				success: function(form, action){
					//me.showResultWindow(action.response.responseText);
					myMask.hide();
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus == "success")
					{
						var tmpObj = resultObj.result;
						Ext.Msg.show({
							title: tmpObj.title,
							width : 450,
							msg: tmpObj.message1,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
						elemList = resultObj.elemList;
						me.afterComponentChanged();
					}
					else
					{
						var tmpObj = resultObj.errors;
						var errorText = me.getErrorMessageTemplate(tmpObj);
						me.showResultWindow(tmpObj.title,errorText,"delete");
					}
					Ext.getCmp("fmanage").setValue("");
					Ext.getCmp("funmanage").setValue("");
					Ext.getCmp("fmanagewithcomptype").setValue("");
					if(isLimitedAdmin == 'true')
					{
						Ext.getCmp('bulkManageOrUnmanage').hide();
					}
					else
					{
						Ext.getCmp('bulkManageOrUnmanage').show();
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					Ext.getCmp("fmanage").setValue("");
					Ext.getCmp("funmanage").setValue("");
					Ext.getCmp("fmanagewithcomptype").setValue("");
				}
			});
		}
	},
	deleteUnManagedComponent : function()
	{
		var me = this;
		var funmng = "";
		var fmng = "";
		var fmngwithcomptype = "";
		var srvtype = Ext.getCmp('servertypes').getValue();
		Ext.getCmp("server").setValue(srvtype);
		var tmpStore = Ext.getCmp('componentDetails');
		var fromList = tmpStore.toField.boundList;
		var selectedList = tmpStore.getSelections(fromList);
		for (var key in selectedList)
		{
			var tmpData = selectedList[key].get("valueField");
			var tmpDis = selectedList[key].get("displayField");
			//if(tmpDis.charAt(0) == '*')
			//{
			//	Ext.Msg.alert(pageTitle,intnlLabel11);
			//	return;
			//}
			funmng = funmng + tmpData + ",";
			fmngwithcomptype = fmngwithcomptype + srvtype + ":" + tmpData + ",";
		}
		if(funmng == "")
		{
			Ext.Msg.alert(pageTitle,intnlLabel12);
		}
		else if (isComponentUpdated != true)
		{
			Ext.Msg.alert(pageTitle,intnlLabel9);
		}
		else
		{
			if(reDiscDelComp.toLowerCase() == 'no' || reDiscDelComp.toLowerCase() == 'false')
			{
				Ext.MessageBox.confirm(pageTitle, intnlLabel14,
					function (btn){
						if (btn == "yes")
						{
							Ext.getCmp("fmanage").setValue(fmng);
							Ext.getCmp("funmanage").setValue(funmng);
							Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
							var tmpURL = "EgConfigEnv/data/EgdeleteserverpJson.jsp?performaction=false";
							me.deleteSelectedComponent(tmpURL);
						}
					}
				);
			}
			else
			{
				Ext.getCmp("fmanage").setValue(fmng);
				Ext.getCmp("funmanage").setValue(funmng);
				Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
				var tmpURL = "EgConfigEnv/data/EgdeleteserverpJson.jsp?performaction=false";
				me.deleteSelectedComponent(tmpURL);
			}
		}
	},
	serverOnChange : function(obj)
	{
		var tmpStore = Ext.getCmp('componentDetails');
		var fromTriggerObj =  tmpStore.fromField.down('trigger');
		var toTriggerObj =  tmpStore.toField.down('trigger');
		if (!Ext.isEmpty(fromTriggerObj.getValue()))
		{
			fromTriggerObj.reset();
		}

		if (!Ext.isEmpty(toTriggerObj.getValue()))
		{
			toTriggerObj.reset();
		}

		var selectedValue = obj.getValue();
		if (selectedValue == "-1")
		{
			if(tmpStore.fromField.store.getCount() > 0)
			{
				tmpStore.fromField.store.removeAll();
			}
			if(tmpStore.toField.store.getCount() > 0)
			{
				tmpStore.toField.store.removeAll();
			}
			return ;
		}
		isComponentUpdated = true;
		var url = 'EgConfigEnv/data/EgConfigEnvJson.jsp?reqfrom='+reqfrom+'&server='+encodeURIComponent(selectedValue);
		this.updateCofigData(url);

		var managedServers = publicJSON['managedServers'];
		var unmanagedServers = publicJSON['unmanagedServers'];
		tmpStore.clearValue();
		if(tmpStore.fromField.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
		}
		Ext.getCmp('componentDetails').getStore().loadRawData(managedServers);
		tmpStore.toField.store.add(unmanagedServers);

		if(isLimitedAdmin == 'true')
		{
			Ext.getCmp('bulkManageOrUnmanage').hide();
		}
		else
		{
			Ext.getCmp('bulkManageOrUnmanage').show();
		}

		if (publicJSON.isSearchNeededForFromField == true || publicJSON.isSearchNeededForToField == true)
		{
			//Ext.getCmp("searchFieldContainer").show();
			if (publicJSON.isSearchNeededForFromField == true)
			{
				Ext.getCmp('managedSeacrchBox').setDisabled(false);
			}
			else
			{
				Ext.getCmp('managedSeacrchBox').setDisabled(true);
			}

			if (publicJSON.isSearchNeededForToField == true)
			{
				Ext.getCmp('unmanagedSeacrchBox').setDisabled(false);
			}
			else
			{
				Ext.getCmp('unmanagedSeacrchBox').setDisabled(true);
			}
		}
		else
		{
			//Ext.getCmp("searchFieldContainer").hide();
		}
	},
	goBack : function()
	{
		if (reqfrom == "managerNofification")
		{
			window.location.href ="/final/admin/EgViewManagerNotificationDetails.jsp?type="+type+"&fromWizard="+fromWizard;
		}
		else if (reqfrom == "EgDispServer")
		{
			window.location.href = "/final/admin/EgDispServer.jsp?comptype="+encodeURIComponent(strServer)+"&category=-1&reqfrom=config"+"&fromWizard="+fromWizard;
			//window.history.go(-1);
		}
		else
		{
			window.location.href = backHref+"&fromWizard="+fromWizard;
		}
	},
	checkNicks : function()
	{
		var result = true;
		var tmpStore = Ext.getCmp('componentDetails');
		var storeObj = tmpStore.fromField.store;
		var count = storeObj.getCount();
		for(var i=0; i<count; i++)
		{
			var value = storeObj.getAt(i).get('valueField');
			var pos = value.indexOf(':');
			if(pos != -1)
			{
				value = value.substring(0,pos);
			}
			if(value.toLowerCase() == "none")
			{
				result = false;
			}
		}
		return result;
	},
	initServerDetails: function()
	{
		if (reqfrom != 'navlink')
		{
			Ext.getCmp('backButton').show();
		}

		var servertypes = Ext.getCmp('servertypes');
		var servers = publicJSON['servers'];
		servertypes.getStore().clearFilter(true);
		servertypes.getStore().loadRawData(servers);
		servertypes.setValue(strServer);
		if (strServer != "-1")
		{
			var tmpStore = Ext.getCmp('componentDetails');
			var managedServers = publicJSON['managedServers'];
			var unmanagedServers = publicJSON['unmanagedServers'];
			if(tmpStore.fromField.store.getCount() > 0)
			{
				tmpStore.fromField.store.removeAll();
			}
			if(tmpStore.toField.store.getCount() > 0)
			{
				tmpStore.toField.store.removeAll();
			}
			Ext.getCmp('componentDetails').getStore().loadRawData(managedServers);
			tmpStore.toField.store.add(unmanagedServers);
			
			var tmpStrComponent  = new Array();
			if (strServer.toLowerCase() == 'oracle_server')
			{
				if (strComponent.indexOf(',') != -1)
				{
					var nick = strComponent.substring(0,strComponent.lastIndexOf(':'));
					var sid = strComponent.substring(strComponent.lastIndexOf(':')+1,strComponent.length);
					var sidStr = sid.split(',');
					
					for (var i=0;i<sidStr.length;i++)
					{
						tmpStrComponent.push(nick+':'+sidStr[i]);
					}
				} 
			}
			if (!Ext.isEmpty(tmpStrComponent))
			{
				var list = tmpStore.fromField.boundList;
				var store = list.getStore();
				for (var j=0;j<tmpStrComponent.length;j++)
				{
					var str = tmpStrComponent[j];
					var fieldIndex = store.findExact("valueField",str);
					if (fieldIndex != -1)
					{
						list.getSelectionModel().select(fieldIndex);
						//if (!Ext.isEmpty(fromWizard))
						{
							selected = tmpStore.getSelections(tmpStore.fromField.boundList);
							tmpStore.moveRec(true, selected);
						}
					}
				}
				tmpStore.toField.boundList.getSelectionModel().selectAll();
				tmpStore.fromField.boundList.refresh();
			}
			else
			{
				if (strComponent.length > 0)
				{
					var list = tmpStore.fromField.boundList;
					var store = list.getStore();
					var fieldIndex = store.findExact("valueField",strComponent);
					if (fieldIndex != -1)
					{
						list.getSelectionModel().select(fieldIndex);
						//if (!Ext.isEmpty(fromWizard))
						{
							selected = tmpStore.getSelections(tmpStore.fromField.boundList);
							tmpStore.moveRec(true, selected);
							tmpStore.toField.boundList.getSelectionModel().select(selected);
							tmpStore.fromField.boundList.refresh();
						}
					}
				}
			}

			if (activeCompTypes == "true")
			{
				Ext.getCmp('activeCompTypes').setValue(true);
			}
		}

		if(isLimitedAdmin == 'true')
		{
			Ext.getCmp('bulkManageOrUnmanage').hide();
		}
		else
		{
			Ext.getCmp('bulkManageOrUnmanage').show();
		}
	},
	getErrorMessageTemplate :function(tmpObj)
	{
		var me = this;
		var tmpTable = "";
		if (tmpObj.allow != null && tmpObj.allow !== undefined && tmpObj.allow == true)
		{
			tmpTable = "";
			for (var key in tmpObj)
			{
				if (key == "title" || key == "allow") continue ;
				var errorMessage = tmpObj[key];
				tmpTable = tmpTable + errorMessage;
			}
		}
		else
		{
			tmpTable = '<div class="x-table" style="width:100%"><table cellspacing="0" width="100%" cellpadding="5" border="1" align="center" class="x-grid-table" style="border:1px solid #c3c3c3"><thead><tr class="x-grid-row"><th class="x-grid-cell"><div class="x-grid-cell-inner">'
			+errorTitle+' : '+pageIntnl14+'</div></td></tr></thead>';
			for (var key in tmpObj)
			{
				if (key == "title") continue ;
				var errorMessage = tmpObj[key];
				tmpTable = tmpTable + '<tr class="x-grid-row"><td class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner" >'+errorMessage+'</div></td></tr>';
			}
			tmpTable = tmpTable + "</table></div>";
		}
		return tmpTable;
	},
	updateComponentDetails : function(isProceed)
	{
		var me = this;
		elemList = "";
		var nickValidation = me.checkNicks();
		if(!nickValidation)
		{
			Ext.Msg.alert(pageTitle,"You are not allowed to manage eG reserved keyword \'NONE\'");
			return;
		}

		var srvtype = Ext.getCmp('servertypes').getValue();
		var obj = Ext.getCmp("activeCompTypes");
		var isActiveComponentChecked = obj.getValue();
		if (srvtype == "-1")
		{
			Ext.Msg.alert(pageTitle,intnlLabel13);
			return;
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var hiddenFields = this.getHiddenFields();
		var componentDetails = Ext.getCmp('componentDetails');
		//var url = 'EgConfigEnv/data/EgconfigenvpJson.jsp';
		me.setAvailableConfigs();
		var urlStr = 'EgConfigEnv/data/EgconfigenvpJson.jsp?activeCompTypes='+isActiveComponentChecked+'&'+hiddenFields+"&date="+new Date().getTime()+"&fromWizard="+fromWizard;
		if (isProceed != null && isProceed !== undefined && isProceed == true)
		{
			urlStr += "&isProceed="+isProceed;
		}
		var frmMain = this.getMain().getForm();
		if (frmMain.isValid())
		{
			this.getMain().submit({
				url: urlStr,
				method: 'POST',
				timeout : 300,
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					isComponentUpdated = true;
					//me.showResultWindow(action.response.responseText);
					var resultObj = Ext.decode(action.response.responseText);
					if (resultObj.requestStatus == "success")
					{
						if (resultObj.hasRestrictedNicks != undefined && resultObj.hasRestrictedNicks)
						{
							me.showResultWindow(pageTitle,me.getErrorMessageTemplate(resultObj.errorStack),"unmanage");
						}
						else
						{
							var tmpObj = resultObj.result;
							Ext.Msg.show({
								title: tmpObj.title,
								width : 500,
								msg: tmpObj.message1,
								buttons: Ext.Msg.OK,
								icon : 'iconInformation'
							});
							elemList = resultObj.elemList;
						}
						if (isProceed != null && isProceed !== undefined && isProceed != false)
						{
							me.updateComponentInfo();
							me.showActiveComponents(obj);
						}
					}
					else
					{
						var tmpObj = resultObj.errors;
						var errorText = me.getErrorMessageTemplate(tmpObj);
						me.showResultWindow(tmpObj.title,errorText,"unmanage");
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					//console.log(action.response.responseText);
				}
			});
		}
	},
	updateCofigData : function(url)
	{
		Ext.Ajax.request({
			url : url,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	setAvailableConfigs : function()
	{
		Ext.getCmp("fmanage").setValue("");
		Ext.getCmp("funmanage").setValue("");
		Ext.getCmp("fmanagewithcomptype").setValue("");
		Ext.getCmp("funmanagewithcomptype").setValue("");
		Ext.getCmp("server").setValue("");

		var srvtype = Ext.getCmp('servertypes').getValue();
		var tmpStore = Ext.getCmp('componentDetails')//.getStore();
		var funmng = new Array();
		var fmng = new Array();
		var funmngwithcomptype = new Array();
		var fmngwithcomptype = new Array();
		var thisForm = document.list;
		var unmnglen = tmpStore.toField.store.getCount();
		var mnglen = tmpStore.fromField.store.getCount();
		var unmanagedList = tmpStore.toField.store;
		var managedList = tmpStore.fromField.store;
		for(var z = 0;z<unmnglen;z++)
		{
			var tmpVal = unmanagedList.getAt(z).get('valueField');
			funmng[z] = tmpVal;
			funmngwithcomptype[z] = srvtype + ":" + tmpVal;
		}
		for(var y = 0;y<mnglen;y++)
		{
			var tmpVal = managedList.getAt(y).get('valueField');
			fmng[y] = tmpVal;
			fmngwithcomptype[y] = srvtype + ":" + tmpVal;
		}


		Ext.getCmp("fmanage").setValue(fmng);
		Ext.getCmp("funmanage").setValue(funmng);
		Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
		Ext.getCmp("funmanagewithcomptype").setValue(funmngwithcomptype);
		Ext.getCmp("server").setValue(srvtype);
	},
	showResultWindow : function(title,resultText,action)
	{
		var me = this;
		var isProceed = false;
		Ext.Msg.show({
			title: title,
			msg: resultText,
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			fn: function(response) {
				if(response == 'yes') 
				{
					isProceed = true;
					if (action != null && action !== undefined && action == "unmanage")
					{
						me.updateComponentDetails(isProceed);
					}
					else if (action != null && action !== undefined && action == "delete")
					{
						me.deleteManagedComponent(isProceed);
					}
				}
				else
				{
					var obj = Ext.getCmp("activeCompTypes");
					me.updateComponentInfo();
					me.showActiveComponents(obj);
				}
			}
		});
	},
	viewAssociatedEntities : function(action)
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			title : associatedEntitiesTitle1,
			id:'assoEntitesWindow',
			width: '68%',
			bodyPadding:'10 10 10 10',
			height: 500,
			modal : true,
			border : false,
			
			autoScroll:true,
			scroll:true,
			ghost:false,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					me.updateEntityAssociationPage(action);
				}
			},
			items:[
				{
					xtype: 'container',
					flex:1,
					id: 'entityAssociationContainer',
					
					margin: 10
				}
			]
		}).show();
	},
	updateEntityAssociationPage : function(action)
	{
		var me = this;
		var servType = Ext.getCmp("server").getValue();
		var activeCompTypes = Ext.getCmp("activeCompTypes").getValue();
		var hiddenFields = me.getHiddenFields();
		var urlStr = "EgConfigEnv/data/EgComponentGroupedSummary.jsp?"+hiddenFields+"&date="+new Date().getTime()+"&fromWizard="+fromWizard+"&action="+action+"&srvtype="+servType+"&activeCompTypes="+activeCompTypes;
		if (action != null && action !== undefined && (action == "showMod" || action == "showDel"))
		{
			urlStr += "&elemList=true";
			Ext.getCmp('assoEntitesWindow').setTitle(associatedEntitiesTitle2);
			Ext.getCmp("hiddenElemList").setValue(elemList);
		}
		else
		{
			Ext.getCmp('assoEntitesWindow').setTitle(associatedEntitiesTitle1);
			if (action != null && action !== undefined && action == "unmanage")
			{
				me.setAvailableConfigs();
			}
			else if (action != null && action !== undefined && action == "delete")
			{
				var funmng = "", fmng = "", fmngwithcomptype = "";
				var tmpStore = Ext.getCmp('componentDetails');
				var fromList = tmpStore.fromField.boundList;
				var selectedList = tmpStore.getSelections(fromList);
				for (var key in selectedList)
				{
					var tmpData = selectedList[key].get("valueField");
					fmng = fmng + tmpData + ",";
					fmngwithcomptype = fmngwithcomptype + servType + ":" + tmpData + ",";
				}
				Ext.getCmp("fmanage").setValue(fmng);
				Ext.getCmp("fmanagewithcomptype").setValue(fmngwithcomptype);
			}
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var frmMain = this.getMain().getForm();
		if (frmMain.isValid())
		{
			this.getMain().submit({
				url: urlStr,
				method: 'POST',
				timeout : 300,
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					var resultObj = Ext.decode(action.response.responseText);
					me.updateResultPanel(resultObj);
				},
				failure: function(form, action)
				{
					myMask.hide();
				}
			});
		}
	},
	updateResultPanel : function(resultObj)
	{
		var me = this;
		var entityAssociationCont = Ext.getCmp('entityAssociationContainer');
		entityAssociationCont.removeAll();

		var isElementsAssociated = resultObj['isElementsAssociated'];
		if (isElementsAssociated != undefined && isElementsAssociated == true)
		{
			var message = "<div>"+resultObj.usersGridArr+"</div>";
			Ext.getCmp('entityAssociationContainer').update(message);
		}
		else
		{
			var message = "<div class = \"iconInformation\" style=\"margin:12% auto auto auto\"></div><div>No components associated.</div>";
			var tmpPanel = {
				xtype : 'component',
				width : '100%',
				border : false,
				style:{'text-align':'center'},
				html : message
			}
			entityAssociationCont.add(tmpPanel);
		}
	},
	getHiddenFields : function()
	{
		hiddenQstr = "";
		var hiddenFields = publicJSON['hiddenFields'];
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	updateComponentInfo :  function()
	{
		var selectedValue = Ext.getCmp("servertypes").getValue();
		var url = 'EgConfigEnv/data/EgConfigEnvJson.jsp?reqfrom='+reqfrom+'&server='+encodeURIComponent(selectedValue)+"&date="+new Date().getTime();
		this.updateCofigData(url);

		var tmpStore = Ext.getCmp('componentDetails');
		var managedServers = publicJSON['managedServers'];
		var unmanagedServers = publicJSON['unmanagedServers'];
		tmpStore.clearValue();
		if(tmpStore.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
        }
		Ext.getCmp('componentDetails').getStore().loadRawData(managedServers);
		tmpStore.toField.store.add(unmanagedServers);

		if(isLimitedAdmin == 'true')
		{
			Ext.getCmp('bulkManageOrUnmanage').hide();
		}
		else
		{
			Ext.getCmp('bulkManageOrUnmanage').show();
		}
	},
	afterComponentChanged :  function()
	{
		var selectedValue = Ext.getCmp("servertypes").getValue();
		var activeCompTypes = "false";
		if (Ext.getCmp('activeCompTypes').getValue() == true)
		{
			activeCompTypes = "true";
		}
		var url = 'EgConfigEnv/data/EgConfigEnvJson.jsp?reqfrom='+reqfrom+'&server='+encodeURIComponent(selectedValue)+"&activeCompTypes="
		+activeCompTypes;
		this.updateCofigData(url);
		var tmpStore = Ext.getCmp('componentDetails');
		var managedServers = publicJSON['managedServers'];
		var unmanagedServers = publicJSON['unmanagedServers'];
		tmpStore.clearValue();
		if(tmpStore.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
        }
		var servertypesObj = Ext.getCmp('servertypes');
		var servers = publicJSON['servers'];
		servertypesObj.getStore().loadRawData(servers);
		var isServerAvailable = servertypesObj.getStore().findExact('valueField', selectedValue, 0);
		if ( isServerAvailable == -1 )
		{
			servertypesObj.setValue(servertypesObj.getStore().getAt(0).get("valueField"));
		}
		else
		{
			Ext.getCmp('componentDetails').getStore().loadRawData(managedServers);
			tmpStore.toField.store.add(unmanagedServers);
		}
	},
	showActiveComponents : function(obj)
	{
		var url = "";
		var isActiveComponentChecked = obj.getValue();
		var servertypesObj = Ext.getCmp('servertypes');
		var selectedValue = servertypesObj.getValue();
		if (isActiveComponentChecked)
		{
			url = 'EgConfigEnv/data/EgConfigEnvJson.jsp?reqfrom='+reqfrom+'&server='+encodeURIComponent(selectedValue)+"&activeCompTypes=true";
		}
		else
		{
			url = 'EgConfigEnv/data/EgConfigEnvJson.jsp?reqfrom='+reqfrom+'&server='+encodeURIComponent(selectedValue)+"&activeCompTypes=false";
		}
		this.updateCofigData(url);
		var tmpStore = Ext.getCmp('componentDetails');
		var managedServers = publicJSON['managedServers'];
		var unmanagedServers = publicJSON['unmanagedServers'];
		tmpStore.clearValue();
		//tmpStore.removeAll();
		if(tmpStore.store.getCount() > 0)
		{
			tmpStore.fromField.store.removeAll();
        }

		var servers = publicJSON['servers'];
		servertypesObj.getStore().loadRawData(servers);
		var isServerAvailable = servertypesObj.getStore().findExact('valueField', selectedValue, 0);
		if ( isServerAvailable == -1 || selectedValue == "-1")
		{
			servertypesObj.setValue(servertypesObj.getStore().getAt(0).get("valueField"));
		}
		else
		{
			tmpStore.getStore().loadRawData(managedServers);
			tmpStore.toField.store.add(unmanagedServers);
		}

		if(isLimitedAdmin == 'true')
		{
			Ext.getCmp('bulkManageOrUnmanage').hide();
		}
		else
		{
			Ext.getCmp('bulkManageOrUnmanage').show();
		}
	},
	searchComponent : function(strComponent,searchVal)
	{
		var me = this , id;
		if (strComponent == "managed")
		{
			id = "managedSeacrchBox";
		}
		else
		{
			id = "unmanagedSeacrchBox";
		}

		if (searchVal == "" || searchVal.length == 0)
		{
			Ext.get('MyTrigger_'+id+'_0').setStyle('display','none');
			Ext.get('MyTrigger_'+id+'_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_'+id+'_1').setStyle('display','none');
			Ext.get('MyTrigger_'+id+'_0').setStyle('display','block');
		}

		var srvtype = Ext.getCmp('servertypes').getValue();
		if (srvtype == "-1")
		{
			Ext.Msg.alert(pageTitle,intnlLabel13);
			return;
		}

		var urlString = '';
		if (searchVal.length == 0 || searchVal == "Search" )
		{
			urlString = "EgConfigEnv/data/EgConfigEnvJson.jsp?reqfrom="+reqfrom+"&server=" +srvtype+"&date="+new Date().getTime();
		}
		else
		{
			urlString = "EgConfigEnv/data/EgConfigEnvJson.jsp?reqfrom="+reqfrom+"&server=" +srvtype+"&strSearch="+searchVal+"&strComponent="+strComponent+"&date="+new Date().getTime();
		}

		Ext.Ajax.request({
			url : urlString,
			method: 'POST',
			success: function(response)
			{
				var tmpJson = Ext.decode(response.responseText);
				if (strComponent == "managed")
				{
					var tmpStore = Ext.getCmp('componentDetails');
					var managedServers = tmpJson['managedServers'];
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					tmpStore.fromField.store.add(managedServers);
				}
				else
				{
					var tmpStore = Ext.getCmp('componentDetails');
					var unmanagedServers = tmpJson['unmanagedServers'];
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					tmpStore.toField.store.add(unmanagedServers);
				}
				if(isLimitedAdmin == 'true')
				{
					Ext.getCmp('bulkManageOrUnmanage').hide();
				}
				else
				{
					Ext.getCmp('bulkManageOrUnmanage').show();
				}
			}
		});
	},
	openPopupWin: function() {
		Ext.widget('fileupload').show();
	},
	bulkComponentAction: function() {
		var me = this;
		var uploadObj = Ext.getCmp('FILE_0').getValue();
		var manageOrUnmanage = Ext.getCmp('bulkManageOrUnmanage2').getValue().manageOrUnmanage;
		
		var alertWinTitle = manageOrUnmanageInBulkTitle;// default title
		
		if(manageOrUnmanage == 'manage') {
			alertWinTitle = manageInBulkTitle ;
		} else if(manageOrUnmanage == 'unmanage') {
			alertWinTitle = unmanageInBulkTitle;
		} else if(manageOrUnmanage == 'delete') {
			alertWinTitle = deleteInBulkTitle;
		}


		if (uploadObj != null && uploadObj != '' && uploadObj != undefined && uploadObj != 'undefined')
		{
			var getFileName = uploadObj;
			getFileName = getFileName.substring(getFileName.lastIndexOf('.') + 1);
			if (getFileName == 'csv')
			{
				
				var URL = "";
				if(manageOrUnmanage == 'unmanage') {
					URL = "/final/servlet/com.egurkha.admin.EgCLIBulkActionController?action=unmanage"; //defualt
					me.doAction(URL);
				} else if(manageOrUnmanage == 'manage') {
					URL = "/final/servlet/com.egurkha.admin.EgCLIBulkActionController?action=manage";
					me.doAction(URL);
				} else if(manageOrUnmanage == 'delete') {
					URL = "/final/servlet/com.egurkha.admin.EgCLIBulkActionController?action=delete";
					Ext.Msg.show({
						title: alertWinTitle,
						msg: deleteInBulkAlrtMsg,
						buttons: Ext.Msg.YESNO,
						icon: 'iconConfirmation',
						fn: function(response) {
							if(response == 'yes') {
								me.doAction(URL);
							}
						}
					});
				}
			}
			else
			{
				Ext.Msg.show({
					title: alertWinTitle,
					msg: selectValidFile,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation'
				});
			}
		}
		else
		{
			
			Ext.Msg.show({
			title: alertWinTitle,
			msg: selectCompsListFile,
			buttons: Ext.MessageBox.OK,
			icon: 'iconInformation'
			});
		}
	},
	doAction: function(URL) {
		var compListForm = this.getFileuploadform().getForm();
		var manageOrUnmanage = Ext.getCmp('bulkManageOrUnmanage2').getValue().manageOrUnmanage;
		
		var alertWinTitle = manageOrUnmanageInBulkTitle;// default title
		
		if(manageOrUnmanage == 'manage') {
			alertWinTitle = manageInBulkTitle ;
		} else if(manageOrUnmanage == 'unmanage') {
			alertWinTitle = unmanageInBulkTitle;
		} else if(manageOrUnmanage == 'delete') {
			alertWinTitle = deleteInBulkTitle;
		}

		if (compListForm.isValid())
		{
			var tmpMask = new Ext.LoadMask('fileUpload', {msg: 'Please wait...'});
			tmpMask.show();
			compListForm.submit(
			{
				url: URL,
				scope: this,
				async: true,
				//waitMsg: 'Please wait upload in progress',
				method: 'POST',
				enctype: 'multipart/form-data',
				success: function (form, action)
				{
					tmpMask.hide();
					var jsonText = action.response.responseText;
						jsonText = Ext.decode(jsonText);
					var errorMsg = jsonText['errorMsg'];
					var errorInfo = jsonText['errorInfo'];

					var resultMsg = jsonText['resultMsg'];
					var tempErrorMsg = jsonText['tempErrorMsg'];
					var ErrMsgsJson = jsonText['ErrMsgsJson'];
					if (!Ext.isEmpty(jsonText))
					{
						if(Ext.isEmpty(tempErrorMsg))
						{
							if(!Ext.isEmpty(resultMsg))
							{
								Ext.Msg.show({
								title: alertWinTitle,
								msg: resultMsg,
								icon: 'iconInformation',
								buttons: Ext.Msg.OK
								});
							} else {

								if(!Ext.isEmpty(ErrMsgsJson)){
									Ext.Msg.show({
										title:alertWinTitle,
										msg: errorMsg,
										icon: 'iconExclamation',
										buttons: Ext.Msg.OK
									});
								} else if(!Ext.isEmpty(errorInfo)) {
									
									Ext.Msg.show({
										title:alertWinTitle,
										msg: errorInfo,
										icon: 'iconInformation',
										buttons: Ext.Msg.OK
									});
								} else if(!Ext.isEmpty(errorMsg)) {
									Ext.Msg.show({
										title:alertWinTitle,
										msg: errorMsg,
										icon: 'iconExclamation',
										buttons: Ext.Msg.OK
									});
								}
							}
						} else {

							Ext.Msg.show({
								title: alertWinTitle,
								msg: tempErrorMsg,
								icon: 'iconExclamation',
								buttons: Ext.Msg.OK
							});
						}
					} 
				},
				failure: function (form, action)
				{
					tmpMask.hide();
					Ext.Msg.show({
								title: alertWinTitle,
								msg: 'Failure Notice',
								icon: 'iconExclamation',
								buttons: Ext.Msg.OK
					});
					
				}
			});
		}

	}
});