Ext.define('EgConfigEnv.view.FileUploadForm', {
	extend: 'Ext.FormPanel',
	alias: 'widget.fileuploadform',
	id: 'fileUploadForm',
	width:'100%',
	fileUpload : true,
	height: 200,
	resizable: false,
	draggable: false,
	modal: true,
	items: [{
			xtype: 'container',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'center'
			},
			defaults:{
				labelSeparator: '',
				margin: 5,
				anchor: '100%',
				labelWidth: 220
			},
			margin: 10,
			items:[{
					xtype: 'radiogroup',
					fieldLabel: selActionLabel,
					cls: 'radiobt',
					id: 'bulkManageOrUnmanage2',
					columnWidth:290,
					name: 'bulkManageOrUnmanage2',
					columns: 3,
					vertical: true,
					listeners:{
						change:function(grp, newValue, oldValue, eOpts){
							if(newValue['manageOrUnmanage'] === 'unmanage'){
								Ext.get('chg_href').dom.href = '/final/servlet/com.egurkha.admin.EgCLIBulkActionController?downloadCSV=UnmanageCSV';
							} else if(newValue['manageOrUnmanage'] === 'delete'){
								Ext.get('chg_href').dom.href = '/final/servlet/com.egurkha.admin.EgCLIBulkActionController?downloadCSV=DeleteCSV';
							} else {
								Ext.get('chg_href').dom.href = '/final/servlet/com.egurkha.admin.EgCLIBulkActionController?downloadCSV=ManageCSV';
							}
						}
					},
					items: [
							{ 
							boxLabel: manageLabel,
							width:95,
							labelAlign: 'top',
							name: 'manageOrUnmanage',
							id: 'manage',
							inputValue: 'manage'
							},
							{ 
							boxLabel: unmanageLabel,
							width:95,
							labelAlign: 'top',
							name: 'manageOrUnmanage',
							id: 'unmanage',
							inputValue: 'unmanage',
							checked: true
							},
							{ 
							boxLabel: deleteLabel,
							width:95,
							labelAlign: 'top',
							name: 'manageOrUnmanage',
							id: 'delete',
							inputValue: 'delete'
							
							}
						],
					width: 480,
					labelWidth: 220
				},
				{
					xtype: 'fileuploadfield',
					cls: 'fileupload',

					fieldLabel: ChooseFileLabel,
					//allowBlank: false,
					buttonText: browsebtnLabel,
					name : 'FILE_0',
					id : 'FILE_0',
				},
				{
							
				xtype: 'component',
				margin:0,
				id:'chg_href',
				
				autoEl: {
					tag: 'a',
					id: 'chg_href',
					href: '/final/servlet/com.egurkha.admin.EgCLIBulkActionController?downloadCSV=UnmanageCSV',//Here we are changing url dynamically  
					html: '<span style="padding-left:90px"><u>'+downloadlinkLabel+'</u></span>',
					
				}
					
				}
					
					
					
					]
			},
			{
			xtype: 'container',
			layout: {
			type: 'hbox',
			pack: 'center'
			},
			margin: 20,
			items: [
				{
					xtype: 'button',
					text: uploadbtnLabel,
					id: 'fileUploadBtn',
					action: 'bulkComponentAction',
					cls: 'button20'
				}]
			}]
});



