
Ext.define('EgConfigureDomains.controller.Main',{
	extend:'Ext.app.Controller',
	views:[
			'Main',
			'EgViewDomains',
			'DomainForm',
			'Mywindow',
			'InstallCertificateWizard',
			'DomainConfiguarationPanel',
			'ViewDomainData',
			'DeleteDomains',
			'ValidateDomainCredentials',
			'ResultPanel',
			'DeleteDomains',
			'GridTemplate',
			'UninstallCertificateWizard',
			'ErrorPanel',
			'DomainDetailsGrid',
			'DomainGroupsInfoGrid',
			'UpdateADUserDetails'
	],
	refs:[
		{ref:'domaintree',selector:'domaintree'},
		{selector:'main', ref:'main'},
		{selector:'viewdomains', ref:'viewdomains'},
		{selector:'domaintree', ref:'domaintree'},
		{selector:'mywindow', ref:'mywindow'},
		{selector:'domainform', ref:'domainform'},
		{selector:'installcertificatewizard', ref:'installcertificatewizard'},
		{selector:'uninstallcertificatewizard', ref:'uninstallcertificatewizard'},
		{selector:'domainconfiguarationpanel', ref:'domainconfiguarationpanel'},
		{selector:'viewdomaindata', ref:'viewdomaindata'},
		{selector:'deletedomains', ref:'deletedomains'},
		{selector:'validatedomaincredentials', ref:'validatedomaincredentials'},
		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'deletedomains', ref:'deletedomains'},
		{selector:'gridtemplate', ref:'gridtemplate'},
		{selector:'updateuserdetails', ref:'updateuserdetails'}
	],
	init:function(){
		appCnt = this;
		this.buildMainData();
		this.control({
			'main':
			{
				'boxready': this.afterMainRender
			},
			'domaintree':
			{
				'afterrender': this.loadTreeData,
				'itemmouseenter':this.showToolTip,
				'itemclick':this.loadDomainPage
			},
			'domaintree button[id="Expand"]':
			{
				'click':this.onExpandAllClick
			},
			'domaintree button[id="Collapse"]':
			{
				'click':this.onCollapseAllClick
			},
			'domainform radiogroup[id="dnsdiscover"]':
			{
				//'change':this.changeDomainDiscovery
			},
			'domainform #update':
			{
				'click':this.updateDomainDetails
			},
			'domainform button[id="validate"]':
			{
				'click':this.validateADServerCredentials
			},
			'domainform #domnam':
			{
				'blur':this.changeToUpperCase
			},
			'domainconfiguarationpanel combo[id="domAction"]':
			{
				//'afterrender':this.updateDomActionItems
				'select':this.loadActionPage
			},
			'domainconfiguarationpanel combo[id="validation"]':
			{
				'select':this.showValidationContainer
			},
			'validatedomaincredentials button[id="validate"]':
			{
				'click':this.getValidationInfo
			},
			'validatedomaincredentials button[id="btnGetIP"]':
			{
				'click':this.getDNSStackTrace
			},
			'deletedomains button[id="delete"]':
			{
				'click':this.deleteDomain
			},
			'main #backButton':
			{
				'click':this.loadHomePage
			},
			'installcertificatewizard':
			{
				'afterrender':this.loadCertificateDetails
			},
			'uninstallcertificatewizard':
			{
				'afterrender':this.loadUninstallInfo
			},
			'gridtemplate': {
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'updateuserdetails button[id="update"]':
			{
				'click':this.updateADUserDetails
			},
		});
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url: appURL,
			method: 'POST',
			async : false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	loadHomePage : function()
	{
		if (selectedDomainGroupNode == "fromDiscovery")
		{
			var discoveryUrl = "/final/admin/EgDiscoveryPane.jsp";
			window.location.href = discoveryUrl;
		}
		else
		{
			var me = this;
			var domainRightPanel = Ext.getCmp('domainRightPanel');
			Ext.getCmp("backButton").hide();
			domainRightPanel.removeAll();
			domainRightPanel.add({xtype:'viewdomains'});
			Ext.getCmp('domainInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc2+'</center>');
			me.displayAllDomains();
			delete domainRightPanel;
		}
	},
	showActions: function(view, task, node, rowIndex, e) {
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).removeCls('x-hidden');
		});
	},
	hideActions: function(view, task, node, rowIndex, e) {
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},
	updateDomainDetails : function()
	{
		var me = this;
		var validationResult = me.validateDomainForm();
		if (validationResult == true)
		{
			var qtype = c_type;
			var urlString = "";
			if (qtype == "Add")
			{
				urlString = 'EgConfigureDomains/data/EgAuthenticationspJson.jsp?ctype=Add';
			}
			else if (qtype == "Modify")
			{
				urlString = "EgConfigureDomains/data/EgAuthenticationspJson.jsp?ctype=Modify&"+queryStr;
			}
			else if (qtype == "addChild")
			{
				urlString = "EgConfigureDomains/data/EgAuthenticationspJson.jsp?ctype=addChild";
			}
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			var domainForm = this.getDomainform().getForm();
			if (domainForm.isValid())
			{
				this.getDomainform().submit({
					url: urlString,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						var resultJSON = Ext.decode(action.response.responseText);
						var requestStatus = resultJSON['requestStatus'];
						var title = '';
						if (requestStatus == "success")
						{
							var resultObj = resultJSON['result'];
							title = resultObj.title;
							//if (qtype == "Add" || qtype == "addChild")
							//{
								//Ext.Msg.show({
									//title: title,
									//msg: resultObj.message1 + ".",
									//buttons: Ext.Msg.OK,
									//icon: 'iconInformation'
								//});
								//Ext.getCmp('backButton').hide();
							//}
							//else
							{
								if (resultObj.message2 == null || resultObj.message2 == 'undefined')
								{
									Ext.Msg.show({
										title: title,
										msg: resultObj.message1+".",
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								}
								else
								{
									Ext.Msg.show({
										title: title,
										msg: resultObj.message1+". "+resultObj.message2+".",
										width : 400,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation'
									});
								}
							}

							if (qtype == "Add")
							{
								if (selectedDomainGroupNode == "fromDiscovery")
								{
									me.updateTree();
									Ext.Msg.show({
										title: title,
										msg: pageIntnl99+". "+pageIntn200,
										width : 400,
										buttons: Ext.Msg.YESNO,
										icon: 'iconInformation',
										fn : function(btn){
											if (btn == 'yes')
											{
												me.addNewDomain();
											}
											else
											{
												me.loadHomePage();
											}
										}
									});
								}
								else
								{
									var domainRightPanel = Ext.getCmp('domainRightPanel');
									domainRightPanel.removeAll();
									domainRightPanel.add({xtype:'viewdomains'});
									Ext.getCmp('backButton').hide();
									me.displayAllDomains();
									me.updateTree();
								}
							}
							else if (qtype == "addChild")
							{
								//var domainTreePanel = Ext.getCmp('domainTreePanel');
								//domainTreePanel.removeAll();
								//domainTreePanel.add({xtype:'domaintree'});
								me.updateTree();
								me.updateDomActionItems(Ext.getCmp('domainDisName').getValue());
								domainDetailsArray = publicJSON['domainSubValues'];
								var resultViews = Ext.getCmp('resultViews');
								resultViews.removeAll();
								resultViews.add({xtype: 'viewdomaindata'});
								me.viewSelectedDomain();
								Ext.getCmp('domAction').setValue("View");
							}
							else
							{
								me.updateDomActionItems(Ext.getCmp('domainDisName').getValue());
								domainDetailsArray = publicJSON['domainSubValues'];
								var resultViews = Ext.getCmp('resultViews');
								resultViews.removeAll();
								resultViews.add({xtype: 'viewdomaindata'});
								me.viewSelectedDomain();
								Ext.getCmp('domAction').setValue("View");
							}
						}
						else
						{
							var resultObj = resultJSON['errors'];
							if (resultObj.type == null || resultObj.type == 'undefined')
							{
								Ext.Msg.show({
									title: title,
									msg: resultObj.message1+".",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
							}
							else
							{
								title = resultObj.title;
								var errorMessageTemplate = me.getErrorMessageTemplate();
								//Ext.Msg.alert(title,errorMessageTemplate.apply(resultObj));
								me.showResultWindow(title,errorMessageTemplate.apply(resultObj));
							}
						}
					},
					failure: function(form, action) // if result page doest not return success:true, this method fires
					{
						switch (action.failureType) {
							case Ext.form.action.Action.CLIENT_INVALID:
								Ext.Msg.show({
									title: "Failure",
									msg: "Form fields may be submitted with invalid values.",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
								break;
							case Ext.form.action.Action.CONNECT_FAILURE:
								Ext.Msg.show({
									title: "Failure",
									msg: "Ajax communication failed.",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
								break;
							case Ext.form.action.Action.SERVER_INVALID:
								Ext.Msg.show({
									title: "Failure",
									msg: action.result.msg+".",
									buttons: Ext.Msg.OK,
									icon: 'iconError'
								});
						}
						myMask.hide();
					}
				});
			}
		}
	},
	deleteAllDomains : function(urlString)
	{
		var me = this;
		Ext.MessageBox.confirm({
			title : 'Confirm',
			msg: confirmMsg,
			icon : 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			width : 400,
			fn : function(btn){
				if (btn == 'yes')
				{
					var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Deleting...'});
					myMask.show();
					var viewdomains = me.getViewdomains().getForm();
					if (viewdomains.isValid())
					{
						me.getViewdomains().submit({
							url: urlString,
							method: 'POST',
							//standardSubmit: true,
							success: function(form, action){
								myMask.hide();
								var resultObj = Ext.decode(action.response.responseText);
								Ext.Msg.show({
									title: resultObj.result.title,
									msg: resultObj.result.message1+".",
									buttons: Ext.Msg.OK,
									icon: 'iconInformation'
								});
								me.updatedomainTree("EgConfigureDomains/data/EgViewDomainsJson.jsp?date="+new Date().getTime());
								me.updateTree();
								Ext.getCmp('domainGrid').getStore().loadRawData(publicJSON['alldomains']);
								
							},
							failure: function(form, action) // if result page doest not return success:true, this method fires
							{
								myMask.hide();
							}
						});
					}
				}
			}
		});
	},
	updatedomainTree : function(domainURL)
	{
		Ext.Ajax.request({
			url : domainURL,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			}
		});
	},
	showResultWindow : function(title,resultText)
	{	
		Ext.widget('window', {
			title: title,
			closeAction: 'destory',
			bodyPadding : 20,
			scroll: true,
			width : 700,
			modal : true,
			autoScroll: true,
			doClose: function() {
				this.destroy();
			},
			html: resultText
		}).show();
	},
	loadTreeData : function()
	{
		var domainTreeObj = Ext.getCmp('domainTreePanel');
		Ext.Ajax.request({
			url : 'EgConfigureDomains/data/EgBuildTreeJSON.jsp',
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				if( !Ext.isEmpty(jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					jsonData["expanded"] = true;
					domainTreeObj.setRootNode(jsonData);

					var record = domainTreeObj.getStore().getNodeById(selectedDomainGroupNode);
					domainTreeObj.getSelectionModel().select(record);

					Ext.get('Expand').on('click', function(event, target, options)
					{
						var obj = Ext.getCmp('Expand');
						if (obj.currentStatus == "expanded")
						{
							obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px;text-transform: lowercase;" id="exx">'+pageIntnl80+'</div>');
							obj.currentStatus = "collapse";
							Ext.getCmp('domainTreePanel').collapseAll();
						}
						else
						{
							obj.currentStatus = "expanded";
							obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px;text-transform: lowercase;" id="exx">'+pageIntnl81+'</div>');
							Ext.getCmp('domainTreePanel').expandAll();
						}
					});
				}
			},
			failure : function(response, opts){
			}
		});
	},
	windowopen:function(){
		//Ext.widget('mywindow').close();
		//Ext.widget('mywindow').show();
		//Ext.create('EgConfigureDomains.view.Mywindow',{title:'sdad', html:html,height:500,width:500}).show();
	},
	validateADServerCredentials : function(obj)
	{
		var me = this;
		obj.setDisabled(true);
		var validationResult = this.validateDomainForm();
		if (validationResult == true)
		{
			var validationLoadingMsg = "<table width='670' border='0' height='170px'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td align=center vlaign=top>Validating domain server credentials...<br>This may take a few minutes...</td></tr></table>";
			var winObj = Ext.getCmp('validateAdServer');
			Ext.create('EgConfigureDomains.view.Mywindow',{
				title:'Validating AD server credentials', 
				closeAction: 'destory',
				id : 'validateAdServer',
				html:validationLoadingMsg,
				height:250,
				align : 'center',
				width:700,
				padding:'5 10 10 10',
				modal: true,
				autoScroll : true,
				listeners : {
					'afterrender': function()
					{
						me.validateDomainCredentials();
					}
				},
				scroll : true,
				doClose: function() {
					obj.setDisabled(false);
					this.destroy();
				},
			}).show();
			//this.validateDomainCredentials();
		}
		else
		{
			obj.setDisabled(false);
		}
	},
	validateDomainCredentials : function()
	{
		var me = this;
		var frmAddDomain = this.getDomainform().getForm();
		var url = "EgConfigureDomains/data/validateADServerCredentials.jsp?";
		var displayName = Ext.getCmp("subjectypes").getValue();
		var domain_Name = Ext.getCmp("domnam").getValue();
		var domain_User = Ext.getCmp("duser").getValue();
		var domain_Pwd = Ext.getCmp("newpwd").getValue();
		var domAliasName = Ext.getCmp("domAliasName").getValue();
		var dnsMode = '';
		var ssl = '';
		var serverIP = '';
		var port = '';
		if (frmAddDomain.findField('dns').getValue())
		{
			dnsMode = "Yes";
		}
		else
		{
			serverIP = Ext.getCmp("dmnip").getValue();
			port = Ext.getCmp("prtno").getValue();
			dnsMode = "no";
		}
		if (frmAddDomain.findField('sslEnabled').getValue())
		{
			ssl = "Yes";
		}
		else
		{
			ssl = "no";
		}
		var params = "domainDisName="+displayName+"&domainName="+domain_Name+"&domain_User="+encodeURIComponent(domain_User)+"&domain_Pwd="+encodeURIComponent(domain_Pwd)+"&ssl="+ssl+"&dnsMode="+dnsMode+"&serverIP="+serverIP+"&port="+port+"&opt="+c_type+"&domAliasName="+domAliasName;
		url = url + params;

		Ext.Ajax.request({
			url : url,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				Ext.getCmp('validateAdServer').update(jsonText);
			}
		});
	},
	showToolTip : function(obj, record, item, index, e, eOpts)
	{
		var customqtip = record.raw.customqtip;
		if (customqtip != null && customqtip != undefined)
		{
			var mytip  = Ext.create("Ext.tip.ToolTip",{
				target: e.getTarget(),
				anchor:"top",
				hideDelay : 0,
				autoHide : true,
				trackMouse : true,
				cls:"yellowTip",
				html : customqtip
			}).showAt(e.getXY());

			if (!Ext.isEmpty(mytip))
			{
				mytip.destroy();
				mytip = null;
			}
		}
	},
	loadDomainPage: function(view,record,item,index,event)
	{
		if (selectedDomainGroupNode == "fromDiscovery")
		{
		}
		else
		{
			var me = this;
			var domainRightPanel = Ext.getCmp('domainRightPanel');
			//var treePanel = this.getTreePanel();
			var nodeName = record.data.text;
			var node_id = record.data.id;
			//this.getTreePanel().expandNode(record);
			var myLink = record.raw.link;
			Ext.getCmp("backButton").hide();
			if (nodeName != 'undefined' && !Ext.isEmpty(nodeName))
			{
				if (nodeName == "Domain(s)")
				{
					domainRightPanel.removeAll();
					domainRightPanel.add({xtype:'viewdomains'});
					Ext.getCmp('domainInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc2+'</center>');
					me.displayAllDomains();
					me.enableAllToolbarControls();
				}
				else
				{
					domainRightPanel.removeAll();
					domainRightPanel.add({xtype:'domainconfiguarationpanel'});
					me.updateDomActionItems(nodeName);
					Ext.getCmp('domainInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc+'</center>');
					Ext.getCmp('domainDisName').setValue(nodeName);
					domainDetailsArray = publicJSON['domainSubValues'];
					me.viewSelectedDomain();
				}
			}	
		}
	},
	enableAllToolbarControls : function()
	{
		var isDomainsConfigured = publicJSON['isDomainConfigured'];
		Ext.getCmp('addNewDomain').setDisabled(false);
		if (isDomainsConfigured == true)
		{
			Ext.getCmp('deleteAllDomain').setDisabled(false);
		}
		else
		{
			Ext.getCmp('deleteAllDomain').setDisabled(true);
		}
		Ext.getCmp('installCert').setDisabled(false);
		Ext.getCmp('uninstallCert').setDisabled(false);
	},
	disableAllToolbarControls : function()
	{
		Ext.getCmp('addNewDomain').setDisabled(true);
		Ext.getCmp('deleteAllDomain').setDisabled(true);
		Ext.getCmp('installCert').setDisabled(true);
		Ext.getCmp('uninstallCert').setDisabled(true);
	},
	disableDeleteIcon : function()
	{
		Ext.getCmp('deleteAllDomain').setDisabled(true);
	},
	afterMainRender : function()
	{
		var me = this;
		var domainRightPanel = Ext.getCmp('domainRightPanel');
		if (selectedDomainGroupNode == "domainroot")
		{
			domainRightPanel.removeAll();
			domainRightPanel.add({xtype:'viewdomains'});
			Ext.getCmp('domainInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc2+'</center>');

			var alldomains = publicJSON['alldomains'];
			var domainGridObj = Ext.getCmp('domainGrid');
			domainGridObj.getStore().loadRawData(alldomains);
			var gridColums = publicJSON['gridColums'];
			var gridCols = domainGridObj.columns.length;
			for (var i = 0;i<gridCols;i++)
			{
				domainGridObj.columns[i].setText(gridColums[i]);
			}
			me.enableAllToolbarControls();
			delete domainGridObj;
			delete gridCols;
			delete gridColums;
		}
		else if (selectedDomainGroupNode == "fromDiscovery")
		{
			me.addNewDomain();
		}
		else
		{
			domainRightPanel.removeAll();
			domainRightPanel.add({xtype:'domainconfiguarationpanel'});
			me.updateDomActionItems(selectedDomainGroupNode);
			Ext.getCmp('domainInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc+'</center>');
			Ext.getCmp('domainDisName').setValue(selectedDomainGroupNode);
			domainDetailsArray = publicJSON['domainSubValues'];
			me.viewSelectedDomain();
		}
	},
	changeDomainDiscovery : function(obj)
	{
		var frmAddDomain = this.getDomainform().getForm();
		if (c_type != "" && c_type == "addChild")
		{
			Ext.getCmp('dns1').setValue(true);
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl79+".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false
		}
		if (frmAddDomain.findField('dns').getValue())
		{
			frmAddDomain.findField('parentDomn').hide();
			frmAddDomain.findField('dmnip').hide();
			frmAddDomain.findField('prtno').hide();
		}
		else
		{
			frmAddDomain.findField('parentDomn').show();
			frmAddDomain.findField('dmnip').show();
			frmAddDomain.findField('prtno').show();
		}
	},
//	onExpandAllClick: function(){
//		var me = this.getTreePanel();
//        var toolbar = me.down('toolbar');
//        me.getEl().mask('Expanding tree...');
//        toolbar.disable();          
//        me.expandAll(function() {
//            me.getEl().unmask();
//            toolbar.enable();
//        });
//   },
//    onCollapseAllClick: function(){
//		var me = this.getTreePanel();
//        var toolbar = me.down('toolbar');
//        toolbar.disable();
//        me.collapseAll(function() {
//            toolbar.enable();
//        });
//  },
	onExpandAllClick: function(){
		Ext.getCmp('domainTreePanel').expandAll();
	},
	onCollapseAllClick: function(){
		Ext.getCmp('domainTreePanel').collapseAll();
	},
	getHiddenFields : function()
	{
		hiddenQstr = "";
		var hiddenFields = publicJSON['hiddenFields'];
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	updateTree : function()
	{
		var domainTreeObj = Ext.getCmp('domainTreePanel');
		Ext.Ajax.request({
			url : 'EgConfigureDomains/data/EgBuildTreeJSON.jsp?date='+new Date().getTime(),
			method : 'POST',
			async : false,
			success : function(response, opts){
				var jsonText = response.responseText;
				if( !Ext.isEmpty(jsonText))
				{
					var jsonData = Ext.decode(jsonText);
					jsonData["expanded"] = true;
					domainTreeObj.setRootNode(jsonData);
					var record = domainTreeObj.getStore().getNodeById(selectedDomainGroupNode);
					domainTreeObj.getSelectionModel().select(record);
				}
			}
		});
	},
	displayAllDomains : function()
	{
		var me = this;
		this.updatedomainTree("EgConfigureDomains/data/EgViewDomainsJson.jsp");
		Ext.getCmp('domainGrid').getStore().loadRawData(publicJSON.alldomains);
		if (Ext.isEmpty(publicJSON.alldomains))
		{
			me.disableDeleteIcon();
		}
	},
	installCert : function()
	{
		var tmpWindowObj = Ext.getCmp('installADCert')
		if (tmpWindowObj == null || tmpWindowObj == 'undefined')
		{
			tmpWindowObj = Ext.create('EgConfigureDomains.view.Mywindow',{
				title:'SSL Certificate Installation',
				id : 'installADCert',
				width:800,
				padding:'5 10 10 10',
				modal: true,
				doClose: function() {
					Ext.Ajax.request({
							url:'EgConfigureDomains/data/EgBuildTreeJSON.jsp', 
							method:'POST',
					});
					this.destroy();
				},
				items:[
					{xtype:'installcertificatewizard'}
				]
			}).show();
		}
	},
	loadCertificateDetails : function()
	{
		var certURL = 'EgConfigureDomains/data/EgSSLCertificateUploaderJson.jsp?mode=install';
		this.updateCertInfo(certURL);
		var certPath = certificateStoreJSON['keystorePath'];
		Ext.getCmp('Path').setValue(certPath);
	},
	loadUninstallInfo : function()
	{
		var certURL = 'EgConfigureDomains/data/EgSSLCertificateUploaderJson.jsp?mode=uninstall&doExecute=delete';
		this.updateCertInfo(certURL);
		var tmpAlias = Ext.getCmp('tmpAlias');
		tmpAlias.getStore().loadRawData(certificateStoreJSON['tmpAlias']);
		tmpAlias.setValue("-1");
		var certPath = certificateStoreJSON['keystorePath'];
		Ext.getCmp('Path').setValue(certPath);
	},
	viewInstalledCert : function()
	{
		var certURL = 'EgConfigureDomains/data/EgSSLCertificateUploaderJson.jsp?mode=view&doExecute=view';
		this.updateCertInfo(certURL);
		if (Ext.isEmpty(certificateStoreJSON['allCerts']))
		{
			Ext.Msg.show({
				title: 'SSL Certificate info',
				msg: "No SSL certificates have been installed.",
				buttons: Ext.Msg.OK,
				width : 300,
				icon: 'iconInformation',
				fn : closeAlert
			});
			return;
		}
		else
		{
			var tmpWindowObj = Ext.getCmp('viewinstalledADCert')
			if (tmpWindowObj == null || tmpWindowObj == undefined)
			{
				tmpWindowObj = Ext.create('EgConfigureDomains.view.Mywindow',{
					title:'Domain SSL Certificates',
					id : 'viewinstalledADCert',
					width:950,
					height : 400,
					scroll : true,
					autoScroll : true,
					modal: true,
					doClose: function() {
						Ext.Ajax.request({
							url:'EgConfigureDomains/data/EgBuildTreeJSON.jsp', 
							method:'POST',
						});
						this.destroy();
					},
					closeAction : 'destroy',
					items:[
						{
							xtype: 'grid',
							cls:'gridSkin',
							margin: '20 10 10 10',
							store: new Ext.data.Store({
								fields: ['AliasName', 'CertificateIssuerName','Version','CertificateValidity'],
								data: certificateStoreJSON['allSSLCerts']
							}),
							columns: [
								{
									dataIndex: 'AliasName',
									header: 'Alias Name',
									flex: 1,
									menuDisabled : true
								},
								{
									dataIndex: 'CertificateIssuerName',
									header: 'Certificate Issuer Name',
									flex: 1,
									menuDisabled : true
								},
								{
									dataIndex: 'Version',
									header: 'Version',
									flex: 1,
									menuDisabled : true
								},
								{
									dataIndex: 'CertificateValidity',
									header: 'Certificate Validity',
									flex: 1,
									sortable: false,
									menuDisabled : true
							}],
							hideHeaders: false
						}
					]
				}).show();
			}
		}
	},
	updateCertInfo : function(certURL)
	{
		Ext.Ajax.request({
			url : certURL,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				certificateStoreJSON = Ext.decode(jsonText);
			}
		});
	},
	unInstallCert : function()
	{
		var tmpWindowObj = Ext.getCmp('uninstallADCert')
		if (tmpWindowObj == null || tmpWindowObj == 'undefined')
		{
			tmpWindowObj = Ext.create('EgConfigureDomains.view.Mywindow',{
				title:'Uninstall SSL Certificate',
				id : 'uninstallADCert',
				width:800,
				padding:'5 10 10 10',
				modal: true,
				doClose: function() {
					Ext.Ajax.request({
							url:'EgConfigureDomains/data/EgBuildTreeJSON.jsp', 
							method:'POST',
					});
					this.destroy();
				},
				items:[
					{xtype:'uninstallcertificatewizard'}
				]
			}).show();
		}
	},
	removeCertificate : function()
	{
		var me = this;
		var tmpAliasObj = Ext.getCmp('tmpAlias');
		var selectedOption = tmpAliasObj.getValue();
		if (selectedOption == "-1")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl59 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		var diplayVal = tmpAliasObj.getDisplayValue();
		var urlStr = "../servlet/com.egurkha.EgCertificateController?date="+new Date().getTime()+"&aliasName="+diplayVal+"&doMethod=delete&certName="+selectedOption

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Uninstalling...'});
		myMask.show();
		var uninstallformObj = this.getUninstallcertificatewizard().getForm();
		if (uninstallformObj.isValid())
		{
			this.getUninstallcertificatewizard().submit({
				url: urlStr,
				method: 'POST',
				success: function(form, action){
					myMask.hide();
					var output = Ext.decode(action.response.responseText);
					if (output.requestStatus == "success")
					{
						Ext.Msg.show({
							title: "Uninstall Certificate",
							msg: pageIntnl60 + " "+pageIntnl61,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
						me.loadUninstallInfo();
					}
					else
					{
						Ext.Msg.show({
							title: "Uninstall Failed",
							msg: pageIntnl62,
							buttons: Ext.Msg.OK,
							icon: 'iconError'
						});
					}
				},
				failure: function(form, action) // if result page doest not return success:true, this method fires
				{
					myMask.hide();
				}
			});
		}
	},
	certificateValidation : function()
	{
		var me = this;
		var fileExt = "cer";
		var aliasName = Ext.getCmp('aliasName').getValue();
		var storePass = Ext.getCmp('storePass').getValue();
		var certfile = Ext.getCmp('certfile').getValue();
		//var domain = Ext.getCmp('domain').getValue();

		/*if (domain == null || domain == "" || domain.length == 0)
		{
			Ext.Msg.alert(pageTitle,pageIntnl57,function(btn){
				Ext.getCmp('domain').focus(true);
			});
			return false;
		}*/

		if(!checkblank(aliasName))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl53 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					Ext.getCmp('aliasName').focus(true);
				}
			});
			return false;
		}
		else if (!checkblank(storePass))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl54 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					Ext.getCmp('storePass').focus(true);
				}
			});
			return false;
		}

		if(isDoubleByteEnabled == "false")
		{
			if(!validateSingleByte(certfile))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntnl56 + ".",
					width : 400,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
		}

		if ((certfile.toLowerCase().indexOf(fileExt))==-1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl55+", '" +fileExt+ "'" + ".",
				width : 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return false;
		}
		var ADCerts = certificateStoreJSON['allCerts'];
		for (var key in ADCerts)
		{
			var certName = ADCerts[key];
			if(certName.toLowerCase() == aliasName.toLowerCase())
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntnl58 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('aliasName').focus(true);
					}
				});
				return false;
			}
		}

		var urlString  = "../servlet/com.egurkha.EgCertificateController?date="+new Date().getTime()+"&aliasName="+aliasName+"&storePass="+encodeURIComponent(storePass)+"&doMethod=install";

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Installing...'});
		myMask.show();
		var installcertificatewizardFormObj = this.getInstallcertificatewizard().getForm();
		if (installcertificatewizardFormObj.isValid())
		{
			this.getInstallcertificatewizard().submit({
				url: urlString,
				method: 'POST',
				success: function(form, action){
					myMask.hide();
					var output = Ext.decode(action.response.responseText);
					if (output.requestStatus == "success")
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: pageIntnl63 + " "+pageIntnl61,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
						});
						//me.loadUninstallInfo();
						var certURL = 'EgConfigureDomains/data/EgSSLCertificateUploaderJson.jsp?mode=install';
						me.updateCertInfo(certURL);
					}
					else
					{
						Ext.Msg.show({
							title: pageTitle,
							msg: pageIntnl64,
							buttons: Ext.Msg.OK,
							icon: 'iconError',
						});
					}
				},
				failure: function(form, action) // if result page doest not return success:true, this method fires
				{
					myMask.hide();
				}
			});
		}
	},
	changeToUpperCase : function(obj)
	{
		var domName = Ext.getCmp('domnam').getValue();
		var domName = domName.toUpperCase();
		Ext.getCmp('domnam').setValue(domName);
	},
	updateDomActionItems : function(domainName)
	{
		var tmpStore = Ext.getCmp('domAction');
		var url = "EgConfigureDomains/data/EgAuthenticationsJson.jsp?subjectypes="+encodeURIComponent(domainName);
		this.updatedomainTree(url);
		tmpStore.getStore().loadRawData(publicJSON['actionItems']);
		tmpStore.setValue(tmpStore.getStore().getAt(0).get("valueField"));
	},
	getSelectedDomainDetails : function(domainURL)
	{
		var tmpActions = '';
		Ext.Ajax.request({
			url : domainURL,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				tmpActions = Ext.decode(jsonText);
			}
		});
		return tmpActions;
	},
	viewSelectedDomain :  function()
	{
		var dataArray = new Array();
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var parent_domain_name = domainDetailsArray.parent_domain_name
		var dnsdiscover = domainDetailsArray.dnsdiscover
		var domAlias = domainDetailsArray.domAlias
		var domAliasName = domainDetailsArray.domAliasName
		var ssl = domainDetailsArray.ssl
		var domainName = domainDetailsArray.domainName
		var duser = domainDetailsArray.duser
		var domainPassword = domainDetailsArray.domainPassword
		var dmnip = domainDetailsArray.dmnip
		var prtno = domainDetailsArray.prtno
		var authenMode = domainDetailsArray.authenMode
		var saveDomainPwdAuth = domainDetailsArray.saveDomainPwdAuth
		var defaultDomain = domainDetailsArray.defaultDomain
		var showuserdetail = domainDetailsArray.showusrdetail

		var item1 = {
			value : domainDisplayName,
			fieldLabel :pageIntnl4,
			//margin: '5 0 30 0'
		}
		dataArray.push(item1);
		item1 = {
			value : (dnsdiscover.toLowerCase() == "yes"? "Auto" : "Manual"),
			fieldLabel :pageIntnl5,
			//margin: '5 0 30 10'
		}
		dataArray.push(item1);
		item1 = {
			value : domainName,
			fieldLabel :pageIntnl8,
			//margin: '5 0 30 0'
		}
		dataArray.push(item1);

		item1 = {
			value : (domAlias.toLowerCase() == "yes"? "Yes" : "No"),
			fieldLabel :pageIntnl93,
			//margin: '5 0 30 10'
		}
		dataArray.push(item1);
		if (domAlias == "Yes")
		{
			item1 = {
				value : domAliasName,
				fieldLabel :pageIntnl94,
				//margin: '5 0 30 10'
			}
			dataArray.push(item1);
		}

		if (dnsdiscover == "No")
		{
			item1 = {
				value : parent_domain_name,
				fieldLabel :pageIntnl9,
				//margin: '5 0 30 10'
			}
			dataArray.push(item1);

			item1 = {
				value : dmnip,
				fieldLabel :pageIntnl10,
				//margin: '5 0 30 0'
			}
			dataArray.push(item1);
			
			item1 = {
				value : prtno,
				fieldLabel : '<b>'+pageIntnl11+'</b>',
				//margin: '5 0 30 10'
			}
			dataArray.push(item1);
		}

		item1 = {
			value : duser,
			fieldLabel :pageIntnl12,
			//margin: '5 0 30 0'
		}
		dataArray.push(item1);

		//item1 = {
			//value : '***************',
			//fieldLabel :pageIntnl13,
			////margin: '5 0 30 10'
		//}
		//dataArray.push(item1);

		if (ssl.toLowerCase() == "true")
		{
			ssl = "Yes";
		}
		else
		{
			ssl = "No";
		}
		item1 = {
			value : ssl,
			fieldLabel :pageIntnl14,
			//margin: '5 0 30 0'
		}
		dataArray.push(item1);
		item1 = {
			value : authenMode,
			fieldLabel : pageIntnl17,
			//margin: '5 0 30 10'
			
		}
		dataArray.push(item1);
		item1 = {
			value : saveDomainPwdAuth,
			fieldLabel : pageIntnl20,
			//margin: '5 0 30 0',
			columnWidth: 1
		}
		dataArray.push(item1);
		item1 = {
			value : defaultDomain,
			fieldLabel : pageIntnl92,
			//margin: '5 0 30 0',
			columnWidth: 1
		}
		dataArray.push(item1);
		if(!Ext.isEmpty(authenMode) && authenMode != null && authenMode != undefined && authenMode == 'Ldap')
		{
			item1 = {
				value : showuserdetail,
				fieldLabel : 'Discover User Details from AD',
				//margin: '5 0 30 0',
				columnWidth: 1
			}
			dataArray.push(item1);
		}
		var tmpPanelObj = Ext.getCmp('displayFieldsContainer');
		tmpPanelObj.removeAll();
		tmpPanelObj.add(dataArray);
		this.getViewdomaindata().doLayout();
	},
	modifyDomainDetails : function()
	{
		var queryString = '';
		var me = this;
		c_type = "Modify";
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var parentDomName = domainDetailsArray.parent_domain_name
		var dnsdiscover = domainDetailsArray.dnsdiscover
		var domAlias = domainDetailsArray.domAlias
		var domAliasName = domainDetailsArray.domAliasName
		var ssl = domainDetailsArray.ssl
		var domainName = domainDetailsArray.domainName
		var duser = domainDetailsArray.duser
		var domainPassword = domainDetailsArray.domainPassword
		var dmnip = domainDetailsArray.dmnip
		var prtno = domainDetailsArray.prtno
		var authenMode = domainDetailsArray.authenMode
		var saveDomainPwdAuth = domainDetailsArray.saveDomainPwdAuth
		var defaultDomain = domainDetailsArray.defaultDomain
		var showuserdetails = domainDetailsArray.showusrdetail

		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		resultViews.add({xtype: 'domainform'});
		//Ext.getCmp('pageDescription').hide();
		Ext.getCmp('update').setText("Update");
		Ext.getCmp('subjectypes').setReadOnly(true);
		Ext.getCmp('subjectypes').setValue(domainDisplayName);
		queryString = "$domain="+encodeURIComponent(domainDisplayName);

		var parentDomains = publicJSON['parentDomainArray'];
		var parentDomnObj = Ext.getCmp('parentDomn');
		parentDomnObj.getStore().loadRawData(parentDomains);
		parentDomnObj.setValue(parentDomName);

		if (defaultDomain.toLowerCase() == "yes")
		{
			Ext.getCmp("yesDefault").setValue(true);
		}
		else
		{
			Ext.getCmp("noDefault").setValue(true);
		}
		if (dnsdiscover.toLowerCase() == "yes")
		{
			queryString = queryString + "&previousDnsMode=Auto";
			Ext.getCmp('dns').setValue(true);
		}
		else
		{
			queryString = queryString + "&previousDnsMode=Manual";
			queryString = queryString + "&$domainip="+encodeURIComponent(dmnip);
			queryString = queryString + "&$portnumber="+encodeURIComponent(prtno);
			Ext.getCmp('dns1').setValue(true);
			Ext.getCmp('parentDomn').show();
			Ext.getCmp('dmnip').show();
			Ext.getCmp('dmnip').setValue(dmnip);
			Ext.getCmp('prtno').show();
			Ext.getCmp('prtno').setValue(prtno);

		}

		if (domAlias.toLowerCase() == "true" || domAlias.toLowerCase() == "yes")
		{
			queryString = queryString + "&$_domAlias=Yes";
			Ext.getCmp('domAliasYes').setValue(true);

			queryString = queryString + "&$domAliasName="+encodeURIComponent(domAliasName);
			Ext.getCmp('domAliasName').setValue(domAliasName);
			Ext.getCmp('domAliasName').show();

		}
		else
		{
			queryString = queryString + "&$_domAlias=No";
			Ext.getCmp('domAliasNo').setValue(true);
			Ext.getCmp('domAliasName').setValue("");
			Ext.getCmp('domAliasName').hide();

		}

		queryString = queryString + "&$domainname="+encodeURIComponent(domainName);
		queryString = queryString + "&pdomain="+encodeURIComponent(parentDomName);
		queryString = queryString + "&$domainuser="+encodeURIComponent(duser);
		queryString = queryString + "&$domainpassword="+encodeURIComponent(domainPassword);
		queryString = queryString + "&$_authenMode="+encodeURIComponent(authenMode);
		Ext.getCmp('domnam').setValue(domainName);
		Ext.getCmp('duser').setValue(duser);
		Ext.getCmp('newpwd').setValue(domainPassword);
		if (ssl.toLowerCase() == "true" || ssl.toLowerCase() == "yes")
		{
			queryString = queryString + "&$_ssl=Yes";
			Ext.getCmp('sslEnabled').setValue(true);
		}
		else
		{
			queryString = queryString + "&$_ssl=No";
			Ext.getCmp('sslEnabled1').setValue(true);
		}

		if (authenMode.toLowerCase() == "kerberos")
		{
			Ext.getCmp('authenmode').setValue(true);
		}
		else
		{
			Ext.getCmp('authenmode1').setValue(true);
			Ext.getCmp('showuserdetailsradio').show();
		}

		if (saveDomainPwdAuth.toLowerCase() == "true" || saveDomainPwdAuth.toLowerCase() == "yes")
		{
			queryString = queryString + "&$_saveDomainPwdAuth=Yes";
			Ext.getCmp('savePass').setValue(true);
		}
		else
		{
			queryString = queryString + "&$_saveDomainPwdAuth=No";
			Ext.getCmp('savePass1').setValue(true);
		}

		if (showuserdetails.toLowerCase() == "true" || showuserdetails.toLowerCase() == "yes")
		{
			queryString = queryString + "&$_showuserdetails=Yes";
			Ext.getCmp('showuser').setValue(true);
		}
		else
		{
			queryString = queryString + "&$_showuserdetails=No";
			Ext.getCmp('hideuser').setValue(true);
		}
		queryStr = queryString;
	},
	deleteDomain : function()
	{
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var urlString = "EgConfigureDomains/data/EgAuthenticationspJson.jsp?ctype=delete&subjectypes="+encodeURIComponent(domainDisplayName);
		var me = this;
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Deleting...'});
		myMask.show();
		var deletedomains = this.getDeletedomains().getForm();
		if (deletedomains.isValid())
		{
			this.getDeletedomains().submit({
				url: urlString,
				method: 'POST',
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					//me.showResultWindow(action.response.responseText);
					var resultObj = Ext.decode(action.response.responseText);
					Ext.Msg.show({
						title: resultObj.result.title,
						msg: resultObj.result.message1 + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
					});

					me.updatedomainTree("EgConfigureDomains/data/EgViewDomainsJson.jsp");
					var domainTreePanel = Ext.getCmp('domainTreePanel');
					var domainRightPanel = Ext.getCmp('domainRightPanel');
					me.updateTree();
					domainRightPanel.removeAll();
					domainRightPanel.add({xtype:'viewdomains'});
					Ext.getCmp('domainGrid').getStore().loadRawData(publicJSON['alldomains']);
					if (Ext.isEmpty(publicJSON.alldomains))
					{
						me.disableDeleteIcon();
					}
				},
				failure: function(form, action) // if result page doest not return success:true, this method fires
				{
					myMask.hide();
					//console.log(action.response.responseText);
				}
			});
		}
	},
	deleteSelectedDomain : function()
	{
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var reqURI = "EgConfigureDomains/data/EgAuthenticationsJson.jsp?ctype=delete&subjectypes="+encodeURIComponent(domainDisplayName);
		this.updatedomainTree(reqURI);
		var canDelete = publicJSON['isUserExits'];

		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		if (canDelete == false)
		{
			var innerHTML = '<div><b>'+confirmMsg2+'&nbsp;</b><i>'+domainDisplayName+'</i>&nbsp;<b>'+pageIntnl91+'?</div>';
			var tmpWidget = Ext.widget("deletedomains",{
				buttonAlign : 'center',
				items : [
					{
						xtype : 'container',
						margin : '20 0 10 0',
						style:{'text-align':'center','margin':'0 auto 20 auto'},
						html:innerHTML
					}
				],
				buttons: [
					{
						text : pageIntnl71,
						id : 'delete',
						cls : 'button20'
					}
				]
			});
			resultViews.add(tmpWidget);
		}
		else
		{
			var innerHTML = "<div style='margin:15% auto auto auto'><table border='0'  width='100%'><tr><td align='center' valign='middle'><div class='iconExclamation'></div><div class='commonErrorMsgText'>"+pageIntnl88+". "+pageIntnl89+".</div></td></tr></table></div>";

			var tmpWidget = Ext.widget("deletedomains",{
				items : [
					{
						xtype : 'component',
						style:{'text-align':'center'},
						html:innerHTML
					}
				]
			});
			resultViews.add(tmpWidget);
		}
		Ext.getCmp('deletedomains').doLayout();
	},
	showValidationForm : function()
	{
		var tmpStore = Ext.getCmp('validation');
		var reqURI = "EgConfigureDomains/data/EgDomainValidationJson.jsp";
		var actItems = this.getSelectedDomainDetails(reqURI);
		tmpStore.getStore().loadRawData(actItems['validationActions']);
		tmpStore.setValue(tmpStore.getStore().getAt(0).get("valueField"));
		var validationTitle = tmpStore.getStore().getAt(0).get("displayField");
		this.setDefaultSelections(validationTitle);
	},
	showValidationContainer : function(tmpObj)
	{
		Ext.getCmp('validationResultPanel').hide();
		var me = this;
		var selectedValue = tmpObj.getValue();
		var displayValue = tmpObj.getDisplayValue();
		if (selectedValue == "1")
		{
			me.setDefaultSelections(displayValue);
		}
		else if (selectedValue == "2")
		{
			me.validateCredentials(displayValue);
		}
		else if (selectedValue == "3")
		{
			me.doesUserExists(displayValue);
		}
		else if (selectedValue == "4")
		{
			me.isLoginValid(displayValue);
		}
		else if (selectedValue == "5")
		{
			//alert("dis "+displayValue);
			me.enumerateADGroups(displayValue);
		}
		else if (selectedValue == "6")
		{
			me.fectchDNSConfiguration(displayValue);
		}
	},
	fectchDNSConfiguration : function(displayValue)
	{
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var domainName = domainDetailsArray.domainName;
		var saveDomainPwdAuth = domainDetailsArray.saveDomainPwdAuth;
		var user = domainDetailsArray.duser;
		var elementsArray = new Array();
		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		resultViews.add({xtype:'validatedomaincredentials'});
		var validatedomaincredentialsObj = Ext.getCmp('validattionControlsDiv');

		var e1 = {
			xtype:'textfield',
			id: 'subjectypes',
			name: 'subjectypes',
			fieldLabel : pageIntnl4,
			cls: 'textbox24',
			readOnly : true,
			value : domainDisplayName,
		};
		elementsArray.push(e1);
		e1 = {
			xtype:'textfield',
			id: 'dname',
			name: 'dname',
			fieldLabel : pageIntnl8,
			cls: 'textbox24',
			readOnly : true,
			value : domainName,
		};
		elementsArray.push(e1);
		if (saveDomainPwdAuth != null && saveDomainPwdAuth.toLowerCase() == "false" || saveDomainPwdAuth.toLowerCase() == "no")
		{
			e1 = {
				xtype:'textfield',
				id: 'aduname',
				name: 'aduname',
				fieldLabel : pageIntnl12,
				cls: 'textbox24',
				value : user,
				readOnly : true,
			};
			elementsArray.push(e1);

			e1 = {
				xtype:'textfield',
				id: 'adpwd',
				name: 'adpwd',
				fieldLabel : pageIntnl13,
				cls: 'textbox24',
				inputType : 'password',
			};
			elementsArray.push(e1);
		}
		var tmpFieldSet = {
			xtype:'fieldset',
			id : 'dnsFieldSet',
			margin : '20 20 10 0',
			width : '80%',
			title: displayValue,
			collapsible: false,
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 500,
				labelWidth: 250
			},
			layout : {
				type : 'vbox',
				align : 'center'
			},
			items: elementsArray
		}
		validatedomaincredentialsObj.removeAll();
		validatedomaincredentialsObj.add(tmpFieldSet);
		Ext.getCmp('validate').setText(pageIntnl84);
	},
	enumerateADGroups : function(displayValue)
	{
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var domainName = domainDetailsArray.domainName;
		var user = domainDetailsArray.duser;
		var saveDomainPwdAuth = domainDetailsArray.saveDomainPwdAuth;
		var elementsArray = new Array();
		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		resultViews.add({xtype:'validatedomaincredentials'});
		var validatedomaincredentialsObj = Ext.getCmp('validattionControlsDiv');
		//validatedomaincredentialsObj.setTitle(displayValue);

		var e1 = {
			xtype:'textfield',
			id: 'dname',
			name: 'dname',
			readOnly : true,
			fieldLabel : pageIntnl8,
			cls: 'textbox24',
			value : domainName,
		};
		elementsArray.push(e1);
		if (saveDomainPwdAuth != null && saveDomainPwdAuth.toLowerCase() == "false" || saveDomainPwdAuth.toLowerCase() == "no")
		{
			var e1 = {
				xtype:'textfield',
				id: 'aduname',
				name: 'aduname',
				fieldLabel : pageIntnl12,
				cls: 'textbox24',
				value : user,
				readOnly : true,
			};
			elementsArray.push(e1);

			e1 = {
				xtype:'textfield',
				id: 'adpwd',
				name: 'adpwd',
				fieldLabel : pageIntnl13,
				cls: 'textbox24',
				inputType : 'password',
			};
			elementsArray.push(e1);
		}
		var tmpFieldSet = {
			xtype:'fieldset',
			margin : '20 20 10 0',
			width : '80%',
			title: displayValue,
			collapsible: false,
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 500,
				labelWidth: 250
			},
			layout : {
				type : 'vbox',
				align : 'center'
			},
			items: elementsArray
		}
		validatedomaincredentialsObj.removeAll();
		validatedomaincredentialsObj.add(tmpFieldSet);
		validatedomaincredentialsObj.doLayout();
		Ext.getCmp('validate').setText(pageIntnl85);
	},
	doesUserExists : function(displayValue)
	{
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var domainName = domainDetailsArray.domainName;
		var user = domainDetailsArray.duser;
		var pass = domainDetailsArray.domainPassword;
		var saveDomainPwdAuth = domainDetailsArray.saveDomainPwdAuth;

		var elementsArray = new Array();
		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		resultViews.add({xtype:'validatedomaincredentials'});
		var validatedomaincredentialsObj = Ext.getCmp('validattionControlsDiv');
		var e1 = {
			xtype:'textfield',
			id: 'dname',
			name: 'dname',
			fieldLabel : pageIntnl8,
			readOnly : true,
			cls: 'textbox24',
			value : domainName,
		};
		elementsArray.push(e1);

		if (saveDomainPwdAuth != null && saveDomainPwdAuth.toLowerCase() == "false" || saveDomainPwdAuth.toLowerCase() == "no")
		{
			e1 = {
				xtype:'textfield',
				id: 'aduname',
				name: 'aduname',
				fieldLabel : pageIntnl12,
				cls: 'textbox24',
				value : user,
				readOnly : true,
			};
			elementsArray.push(e1);

			e1 = {
				xtype:'textfield',
				id: 'adpwd',
				name: 'adpwd',
				fieldLabel : pageIntnl13,
				cls: 'textbox24',
				inputType : 'password',
			};
			elementsArray.push(e1);
		}
		e1 = {
			xtype:'textfield',
			id: 'uname',
			name: 'uname',
			fieldLabel : pageIntnl72,
			cls: 'textbox24',
		};
		elementsArray.push(e1);
		var tmpFieldSet = {
			xtype:'fieldset',
			margin : '20 20 10 0',
			width : '80%',
			title: displayValue,
			collapsible: false,
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 500,
				labelWidth: 250
			},
			layout : {
				type : 'vbox',
				align : 'center'
			},
			items: elementsArray
		}
		validatedomaincredentialsObj.removeAll();
		validatedomaincredentialsObj.add(tmpFieldSet);
		Ext.getCmp('validate').setText(pageIntnl31);
	},
	isLoginValid : function(displayValue)
	{
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var domainName = domainDetailsArray.domainName;
		var user = domainDetailsArray.duser;
		var pass = domainDetailsArray.domainPassword;
		var saveDomainPwdAuth = domainDetailsArray.saveDomainPwdAuth;

		var elementsArray = new Array();
		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		resultViews.add({xtype:'validatedomaincredentials'});
		var validatedomaincredentialsObj = Ext.getCmp('validattionControlsDiv');
		var e1 = {
			xtype:'textfield',
			id: 'dname',
			name: 'dname',
			fieldLabel : pageIntnl8,
			cls: 'textbox24',
			readOnly : true,
			value : domainName,
		};
		elementsArray.push(e1);
		e1 = {
			xtype:'textfield',
			id: 'uname',
			name: 'uname',
			fieldLabel : pageIntnl72,
			cls: 'textbox24'
		};
		elementsArray.push(e1);

		e1 = {
			xtype:'textfield',
			id: 'upass',
			name: 'upass',
			fieldLabel : pageIntnl73,
			cls: 'textbox24',
			inputType : 'password'
		};
		elementsArray.push(e1);
		var tmpFieldSet = {
			xtype:'fieldset',
			margin : '20 20 10 0',
			width : '80%',
			title: displayValue,
			collapsible: false,
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 500,
				labelWidth: 250
			},
			layout : {
				type : 'vbox',
				align : 'center'
			},
			items: elementsArray
		}
		validatedomaincredentialsObj.removeAll();
		validatedomaincredentialsObj.add(tmpFieldSet);
		Ext.getCmp('validate').setText(pageIntnl86);
	},
	validateCredentials : function(displayValue)
	{
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var domainName = domainDetailsArray.domainName;
		var user = domainDetailsArray.duser;
		var pass = domainDetailsArray.domainPassword;

		var elementsArray = new Array();
		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		resultViews.add({xtype:'validatedomaincredentials'});
		var validatedomaincredentialsObj = Ext.getCmp('validattionControlsDiv');
		var e1 = {
			xtype:'textfield',
			id: 'dname',
			name: 'dname',
			fieldLabel : pageIntnl8,
			readOnly : true,
			cls: 'textbox24',
			value : domainName,
		};
		elementsArray.push(e1);

		e1 = {
			xtype:'textfield',
			id: 'aduname',
			name: 'aduname',
			fieldLabel : pageIntnl12,
			cls: 'textbox24',
			value : user,
			readOnly : true,
		};
		elementsArray.push(e1);

		e1 = {
			xtype:'textfield',
			id: 'adpwd',
			name: 'adpwd',
			fieldLabel : pageIntnl13,
			cls: 'textbox24',
			inputType : 'password',
			value : pass
		};
		elementsArray.push(e1);
		var tmpFieldSet = {
			xtype:'fieldset',
			margin : '20 20 10 0',
			width : '80%',
			title: displayValue,
			collapsible: false,
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 500,
				labelWidth: 250
			},
			layout : {
				type : 'vbox',
				align : 'center'
			},
			items: elementsArray
		}
		validatedomaincredentialsObj.removeAll();
		validatedomaincredentialsObj.add(tmpFieldSet);
		Ext.getCmp('validate').setText(pageIntnl31);
	},
	setDefaultSelections : function(validationTitle)
	{
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var parentDomName = domainDetailsArray.parent_domain_name;
		var domainName = domainDetailsArray.domainName;
		var dnsdiscover = domainDetailsArray.dnsdiscover

		var elementsArray = new Array();
		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		resultViews.add({xtype:'validatedomaincredentials'});
		var validatedomaincredentialsObj = Ext.getCmp('validattionControlsDiv');
		//validatedomaincredentialsObj.setTitle(validationTitle);
		var e1 = {
			xtype:'textfield',
			id: 'subjectypes',
			name: 'subjectypes',
			fieldLabel : pageIntnl4,
			cls: 'textbox24',
			value : domainDisplayName,
			readOnly : true,
		};
		elementsArray.push(e1);
		e1 = {
			xtype:'textfield',
			id: 'dname',
			name: 'dname',
			fieldLabel : pageIntnl8,
			cls: 'textbox24',
			value : domainName,
			readOnly : true,
		};

		if (dnsdiscover.toLowerCase() == "no" || dnsdiscover.toLowerCase() == "false")
		{
			var dmnip = domainDetailsArray.dmnip;
			var prtno = domainDetailsArray.prtno;
			e1 = {
				xtype:'textfield',
				id: 'ip',
				name: 'ip',
				fieldLabel : pageIntnl10,
				cls: 'textbox24',
				value : dmnip,
				readOnly : true,
			};
			elementsArray.push(e1);

			e1 = {
				xtype:'textfield',
				id: 'prtno',
				name: 'prtno',
				fieldLabel : pageIntnl11,
				cls: 'textbox24',
				value : prtno,
				readOnly : true,
			};
			elementsArray.push(e1);
		}

		elementsArray.push(e1);
		var tmpFieldSet = {
			xtype:'fieldset',
			margin : '20 20 10 0',
			width : '80%',
			title: validationTitle,
			collapsible: false,
			defaults: {
				labelSeparator: '',
				margin: 5,
				width: 500,
				labelWidth: 250
			},
			layout : {
				type : 'vbox',
				align : 'center'
			},
			items: elementsArray
		}
		validatedomaincredentialsObj.removeAll();
		validatedomaincredentialsObj.add(tmpFieldSet);
		validatedomaincredentialsObj.doLayout();
	},
	loadActionPage : function(actObj)
	{
		var me = this;
		var selectedCategory = actObj.getValue();
		selectedCategory = selectedCategory.toLowerCase();
		if (selectedCategory == "view")
		{
			Ext.getCmp('validation').hide();
			var resultViews = Ext.getCmp('resultViews');
			resultViews.removeAll();
			resultViews.add({xtype: 'viewdomaindata'});
			me.viewSelectedDomain();
		}
		else if (selectedCategory == "modify")
		{
			Ext.getCmp('validation').hide();
			me.modifyDomainDetails();
		}
		else if (selectedCategory == "delete")
		{
			Ext.getCmp('validation').hide();
			me.deleteSelectedDomain();
		}
		else if (selectedCategory == "validate")
		{
			Ext.getCmp('validation').show();
			me.showValidationForm();
		}
		else if (selectedCategory == "addchild")
		{
			me.addChildDomain();
		}
		else if (selectedCategory == "updateuserdetails")
		{
			Ext.getCmp('validation').hide();
			me.showADUpdateForm();
		}
	},
	addChildDomain : function()
	{
		Ext.getCmp("backButton").show();
		c_type = "addChild";

		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var url = "EgConfigureDomains/data/EgAuthenticationsJson.jsp?ctype=Add";
		this.updatedomainTree(url);

		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		resultViews.add({xtype: 'domainform'});
		//Ext.getCmp('pageDescription').hide();

		Ext.getCmp('dns1').setValue(true);
		var parentDomains = publicJSON['parentDomainArray'];
		var parentDomnObj = Ext.getCmp('parentDomn');
		parentDomnObj.getStore().loadRawData(parentDomains);
		parentDomnObj.setValue(domainDisplayName);
		Ext.getCmp('parentDomn').show();
		Ext.getCmp('dmnip').show();
		Ext.getCmp('prtno').show();
	},
	getDNSStackTrace : function(obj)
	{
		var me = this;
		obj.setDisabled(true);
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var selectedSiteName = Ext.getCmp('siteList').getValue();
		var url = "/final/servlet/com.egurkha.ADAuthentication?";
		var parems = "domainName="+encodeURIComponent(domainDisplayName)+"&operation=7&siteName="+selectedSiteName;
		url = url + parems;
		var resultObj = me.getSelectedDomainDetails(url);
		if (resultObj['requestStatus'] == 'success')
		{
			var serverIPs = resultObj['serverIPs'];
			Ext.getCmp('validationResultPanel').hide();
			var validationResultPanel2 = Ext.getCmp('validationResultPanel2');
			validationResultPanel2.removeAll();
			validationResultPanel2.add({xtype:'gridtemplate'});
			Ext.getCmp('gridtemplate').getStore().loadRawData(serverIPs);
			validationResultPanel2.show();
			validationResultPanel2.doLayout();
		}
		else
		{
			var errors = resultObj.errors;
			var errorMessageTemplate = me.getErrorMessageTemplate();
			Ext.getCmp('validationResultPanel').update(errorMessageTemplate.apply(errors));
			Ext.getCmp('validationResultPanel').show();
		}
		obj.setDisabled(false);
	},
	getDNSStackTraceInfo : function(ip,port)
	{
		var me = this;
		var url = "/final/servlet/com.egurkha.ADAuthentication?operation=8&ip="+ip+"&port="+port;
		var resultObj = me.getSelectedDomainDetails(url);
		if (resultObj.requestStatus == "success")
		{
			Ext.Msg.show({
				title: "DNS Info",
				msg: resultObj.message + ".",
				buttons: Ext.Msg.OK,
				//width : 500,
				icon: 'iconInformation',
			});
		}
		else
		{
			Ext.Msg.show({
				title: "DNS Info",
				msg: resultObj.message + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconError',
			});
		}
	},
	getReverseDNSStackTrace : function(ip)
	{
		var me = this;
		var url = "/final/servlet/com.egurkha.ADAuthentication?operation=9&ip="+ip;
		var resultObj = me.getSelectedDomainDetails(url);
		if (resultObj.requestStatus == "success")
		{
			Ext.Msg.show({
				title: "DNS Info",
				msg: resultObj.message + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconInformation',
			});
		}
		else
		{
			Ext.Msg.show({
				title: "DNS Info",
				msg: resultObj.message + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconError',
			});
		}
	},
	getErrorMessageTemplate :function()
	{
		 var tabledata = new Ext.XTemplate(
			'<div class="plainTable plainTableShadow">',
			'<table cellspacing="0" width="100%" cellpadding="0" border="0" ><col width="200px"><col width="70%">',
				'<thead>',
					'<tr>',
						'<th colspan="2">Error : '+pageIntnl75+'</th>',
					'</tr>',
				'</thead>',
			'<tbody>',
			'<tpl for=".">',
				'<tr>',
					'<td class="font_bold11">'+pageIntnl76+'</td>',
					'<td>{ERROR}</td>',
				'</tr>',
				'<tr>',
					'<td class="font_bold11">'+pageIntnl77+'</td>',
					'<td>{DESCRIPTION}</td>',
				'</tr>',
				'<tr>',
					'<td class="font_bold11">'+pageIntnl78+'</td>',
					'<td>{RESOLUTION}</td>',
				'</tr>',
			'</tpl>',
			'</tbody>',
			'</table>',
			'</div>'
		);
		return tabledata;
	},
	getValidationInfo : function(obj)
	{
		var validationResultPanel = Ext.getCmp('validationResultPanel');
		validationResultPanel.show();
		var me = this;
		Ext.getCmp('validate').show();
		Ext.getCmp('btnGetIP').hide();
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var parentDomName = domainDetailsArray.parent_domain_name;
		var domainName = domainDetailsArray.domainName;
		var saveDomainPwdAuth = domainDetailsArray.saveDomainPwdAuth;
		var url = "/final/servlet/com.egurkha.ADAuthentication?";
		var parems = "";

		var validationObj = Ext.getCmp('validation');
		var selectedOption = validationObj.getValue();
		if (selectedOption == "1")
		{
			obj.setDisabled(true);
			parems = "domainName="+encodeURIComponent(domainDisplayName)+"&operation=1";
			url = url + parems;
			var resultObj = me.getSelectedDomainDetails(url);
			if (resultObj['requestStatus'] == 'success')
			{
				validationResultPanel.update("<div><b>"+resultObj.result.message1+"</b></div>");
				validationResultPanel.show();
			}
			else
			{
				var errors = resultObj.errors;
				var errorMessageTemplate = me.getErrorMessageTemplate();
				validationResultPanel.update(errorMessageTemplate.apply(errors));
				validationResultPanel.show();
			}
		}
		else if (selectedOption == "2")
		{
			var userName = Ext.getCmp('aduname');
			var adpwd = Ext.getCmp('adpwd');

			if(!checkblank(adpwd.getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntnl44 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						adpwd.focus(true);
					}
				});
				return false;
			}
			parems = "domainName="+encodeURIComponent(domainDisplayName)+"&operation=2&domainUser="+encodeURIComponent(userName.getValue())+"&domainPwd="+encodeURIComponent(adpwd.getValue());
			url = url + parems;
			obj.setDisabled(true);
			var resultObj = me.getSelectedDomainDetails(url);
			if (resultObj['requestStatus'] == 'success')
			{
				validationResultPanel.update("<div><b>"+resultObj.result.message1+"</b></div>");
				validationResultPanel.show();
			}
			else
			{
				var errors = resultObj.errors;
				var errorMessageTemplate = me.getErrorMessageTemplate();
				validationResultPanel.update(errorMessageTemplate.apply(errors));
				validationResultPanel.show();
			}
		}
		else if (selectedOption == "3")
		{
			var userObj = Ext.getCmp('uname');
			if(!checkblank(userObj.getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntnl69 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						userObj.focus(true);
					}
				});
				return false;
			}
			var uname = userObj.getValue();
			parems = "domainName="+encodeURIComponent(domainDisplayName)+"&operation=3&user="+encodeURIComponent(uname);
			if (saveDomainPwdAuth != null && saveDomainPwdAuth.toLowerCase() == "false" || saveDomainPwdAuth.toLowerCase() == "no")
			{
				var userName = Ext.getCmp('aduname');
				var adpwd = Ext.getCmp('adpwd');
				if(!checkblank(userName.getValue()))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: pageIntnl41 + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							userName.focus(true);
						}
					});
					return false;
				}
				
				if(!checkblank(adpwd.getValue()))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: pageIntnl70 + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							adpwd.focus(true);
						}
					});
					return false;
				}

				parems = parems + "&domainUser="+encodeURIComponent(userName.getValue())+"&domainPwd="+encodeURIComponent(adpwd.getValue());
			}
			url = url + parems;
			obj.setDisabled(true);
			var resultObj = me.getSelectedDomainDetails(url);
			if (resultObj['requestStatus'] == 'success')
			{
				validationResultPanel.update("<div><b>"+resultObj.result.message1+"</b></div>");
				validationResultPanel.show();
			}
			else
			{
				var errors = resultObj.errors;
				var errorMessageTemplate = me.getErrorMessageTemplate();
				validationResultPanel.update(errorMessageTemplate.apply(errors));
				validationResultPanel.show();
			}
		}
		else if (selectedOption == "4")
		{
			if(!checkblank(Ext.getCmp('uname').getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntnl69 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('uname').focus(true);
					}
				});
				return false;
			}
			
			if(!checkblank(Ext.getCmp('upass').getValue()))
			{
				Ext.Msg.show({
					title: pageTitle,
					msg: pageIntnl44 + ".",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('upass').focus(true);
					}
				});
				return false;
			}

			var uname = Ext.getCmp('uname').getValue();
			var upass = Ext.getCmp('upass').getValue();
			parems = "domainName="+encodeURIComponent(domainDisplayName)+"&operation=4&user="+encodeURIComponent(uname)+"&userPass="+encodeURIComponent(upass);
			url = url + parems;
			obj.setDisabled(true);
			var resultObj = me.getSelectedDomainDetails(url);
			if (resultObj['requestStatus'] == 'success')
			{
				validationResultPanel.update("<div><b>"+resultObj.result.message1+"</b></div>");
				validationResultPanel.show();
			}
			else
			{
				var errors = resultObj.errors;
				var errorMessageTemplate = me.getErrorMessageTemplate();
				validationResultPanel.update(errorMessageTemplate.apply(errors));
				validationResultPanel.show();
			}
		}
		else if (selectedOption == "5")
		{
			var userName = Ext.getCmp('aduname');
			var adpwd = Ext.getCmp('adpwd');
			parems = "domainName="+encodeURIComponent(domainDisplayName)+"&operation=5";
			if (userName != null && userName != undefined)
			{
				if(!checkblank(userName.getValue()))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: pageIntnl41 + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							userName.focus(true);
						}
					});
					return false;
				}
				
				if(!checkblank(adpwd.getValue()))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: pageIntnl70 + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							adpwd.focus(true);
						}
					});
					return false;
				}

				parems = parems +"&domainUser="+encodeURIComponent(userName.getValue())+"&domainPwd="+encodeURIComponent(adpwd.getValue());
			}
			url = url + parems;
			obj.setDisabled(true);
			var resultObj = me.getSelectedDomainDetails(url);
			if (resultObj['requestStatus'] == 'success')
			{
//				var mainColumnsObjArray = new Array();
//				mainColumnsObjArray.push({
//					header: '',
//					sortable:false,
//					menuDisabled : true,
//					dataIndex: 'col_1',
//					flex : 1
//				});
//				mainColumnsObjArray.push({
//					header: '',
//					sortable:false,
//					menuDisabled : true,
//					dataIndex: 'col_2',
//					flex : 1
//				});
//				mainColumnsObjArray.push({
//					header: '',
//					sortable:false,
//					menuDisabled : true,
//					dataIndex: 'col_3',
//					flex : 1
//				});

				Ext.getCmp('validationResultPanel').hide();
				var validationResultPanel2 = Ext.getCmp('validationResultPanel2');
				validationResultPanel2.removeAll();
				validationResultPanel2.add({xtype:'domaingroupsinfogrid'});
				Ext.getCmp('domaingroupsinfogrid').getStore().loadRawData(resultObj.domainGroupArr);
				validationResultPanel2.show();
				validationResultPanel2.doLayout();

				//var gridpanel = Ext.widget('domaindetailsgrid',{
				//	store:new Ext.data.Store({
				//		fields: ["col_1","col_2","col_3"],
				//		data: domainGroupArr
				//	}),
				//	sortableColumns:true,
				//	hideHeaders : true,
				//	title : 'Domain Groups',
				//	columns:mainColumnsObjArray
				//});
				//validationResultPanel2.add(gridpanel);
				//validationResultPanel2.doLayout();
			}
			else
			{
				var errors = resultObj.errors;
				var errorMessageTemplate = me.getErrorMessageTemplate();
				validationResultPanel.update(errorMessageTemplate.apply(errors));
				validationResultPanel.show();
			}
		}
		else if (selectedOption == "6")
		{
			parems = "domainName="+encodeURIComponent(domainDisplayName)+"&operation=6";
			if (saveDomainPwdAuth != null && saveDomainPwdAuth.toLowerCase() == "false" || saveDomainPwdAuth.toLowerCase() == "no")
			{
				var userName = Ext.getCmp('aduname');
				var adpwd = Ext.getCmp('adpwd');

				if(!checkblank(userName.getValue()))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: pageIntnl41 + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							userName.focus(true);
						}
					});
					return false;
				}
				
				if(!checkblank(adpwd.getValue()))
				{
					Ext.Msg.show({
						title: pageTitle,
						msg: pageIntnl70 + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn){
							adpwd.focus(true);
						}
					});
					return false;
				}
				parems = parems + "&domainUser="+encodeURIComponent(userName.getValue())+"&domainPwd="+encodeURIComponent(adpwd.getValue());
			}
			url = url + parems;
			obj.setDisabled(true);
			var resultObj = me.getSelectedDomainDetails(url);
			if (resultObj['requestStatus'] == 'success')
			{
				var validatedomaincredentialsObj = Ext.getCmp('dnsFieldSet');
				var siteList = {
					xtype:'combo',
					id : 'siteList',
					cls: 'dropdown',
					editable: false,
					fieldLabel : pageIntnl87,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : resultObj['sites']
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local'
				};
				validatedomaincredentialsObj.add(siteList);
				var tmpSite = Ext.getCmp('siteList');
				tmpSite.setValue(tmpSite.getStore().getAt(0).get("valueField"));
				validatedomaincredentialsObj.doLayout();
				Ext.getCmp('validate').hide();
				Ext.getCmp('btnGetIP').show();
			}
			else
			{
				var errors = resultObj.errors;
				var errorMessageTemplate = me.getErrorMessageTemplate();
				validationResultPanel.update(errorMessageTemplate.apply(errors));
				validationResultPanel.show();
			}
		}
		obj.setDisabled(false);
	},
	addNewDomain : function()
	{
		Ext.getCmp('domainInfoHeader').update('<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle">&nbsp;&nbsp;'+pageDisc+'</center>');
		Ext.getCmp("backButton").show();
		c_type = "Add";
		var domainRightPanel = Ext.getCmp('domainRightPanel');
		domainRightPanel.removeAll();
		domainRightPanel.add({xtype:'domainform'});
		var url = "EgConfigureDomains/data/EgAuthenticationsJson.jsp?ctype=Add";
		this.updatedomainTree(url);
		//if (Ext.getCmp('dns').getValue())
		//{
			//Ext.getCmp('domAlias').show()
		//}
		//else
		//{
			//Ext.getCmp('domAlias').hide()
		//}
		var parentDomains = publicJSON['parentDomainArray'];
		var parentDomnObj = Ext.getCmp('parentDomn');
		parentDomnObj.getStore().loadRawData(parentDomains);
		parentDomnObj.setValue("none");
	},
	validateDomainForm : function()
	{
		var splChar = "`~!@#$%^&*()+=[]{}|\\:;\"\'<>?\/";
		var splChar2 = " `~!@#$%^&*()+=[]{}|\\:;\"\'<>?\/";
		var splChar3 = " `~!#$%^&*()+=[]{}|\\:;\"\'<>?\/";
		var d_name = Ext.getCmp('domnam').getValue();
		var subjectypes = Ext.getCmp('subjectypes');
		var domnam = Ext.getCmp('domnam');
		var duser = Ext.getCmp('duser');
		var newpwd = Ext.getCmp('newpwd');
		var dmnip = Ext.getCmp('dmnip');
		var prtno = Ext.getCmp('prtno');
		var dns = Ext.getCmp('dns1').getValue();
		var domAlias = Ext.getCmp('domAliasYes').getValue();
		var domAliasName = Ext.getCmp('domAliasName')

		if(!checkblank(subjectypes.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl33 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					subjectypes.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(subjectypes.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl34 + ".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					subjectypes.focus(true);
				}
			});
			return false;
		}
		else if(!checkspecialnomess(subjectypes.getValue(),splChar3))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl35 + ".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					subjectypes.focus(true);
				}
			});
			return false;
		}
		else if (parseInt(subjectypes.getValue()) < 0)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl36 + ".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					subjectypes.focus(true);
				}
			});
			return false;
		}
		else if(!checkblank(domnam.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl37 + ".",
				buttons: Ext.Msg.OK,
				width : 300,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(domnam.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl38 + ".",
				buttons: Ext.Msg.OK,
				width : 500,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
		else if(!checkspecialnomess(domnam.getValue()," !\"#$&()*+\':;<=>?@[\]^'{|}~,"))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl39 + ".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
		else if ((domnam.getValue()).charAt((domnam.getValue()).length-1) == ".")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _domainPeriod + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
		else if(d_name.indexOf(".") == -1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl40 + ".",
				buttons: Ext.Msg.OK,
				width : 300,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
		else if (!checkNonNumericals(domnam.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _aplhabets + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					domnam.focus(true);
				}
			});
			return false;
		}
		else if(!checkblank(duser.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl41 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					duser.focus(true);
				}
			});
			return false;
		}
		else if(!checkspecial(duser.getValue(),"@*+=|:;\"\'<>\/[]?,"))
		{
			duser.focus(true);
			return false;
		}
		else if(trim(duser.getValue()) == "")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl42 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					duser.focus(true);
				}
			});
			return false;
		}
		else if(duser.getValue().indexOf("..") > -1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _checkdots + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					duser.focus(true);
				}
			});
			return false;
		}
		else if ((duser.getValue()).indexOf("  ") > -1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _checkSpaces + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					duser.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(duser.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl43 + ".",
				buttons: Ext.Msg.OK,
				width : 500,
				icon: 'iconExclamation',
				fn : function(btn){
					duser.focus(true);
				}
			});
			return false;
		}
		else if(newpwd.getValue() == "")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl44 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					newpwd.focus(true);
				}
			});
			return false;
		}
		else if(!checkblank(newpwd.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl44 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					newpwd.focus(true);
				}
			});
			return false;
		}
		else if(!checkspecialnomess(newpwd.getValue(),"\""))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _notAllowCharInPwd + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					newpwd.focus(true);
				}
			});
			return false;
		}
		else if(!validateSingleByte(newpwd.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl45 + ".",
				buttons: Ext.Msg.OK,
				width : 500,
				icon: 'iconExclamation',
				fn : function(btn){
					newpwd.focus(true);
				}
			});
			return false;
		}
		else if(domAlias == true && !checkblank(domAliasName.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl95 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					domAliasName.focus(true);
				}
			});
			return false;
		}
		else if(domAlias == true && !validateSingleByte(domAliasName.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl96 + ".",
				buttons: Ext.Msg.OK,
				width : 500,
				icon: 'iconExclamation',
				fn : function(btn){
					domAliasName.focus(true);
				}
			});
			return false;
		}
		else if(domAlias == true && !checkspecialnomess(domAliasName.getValue()," !\"#$&()*+\':;<=>?@[\]^'{|}~,"))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl98 + ".",
				buttons: Ext.Msg.OK,
				width : 400,
				icon: 'iconExclamation',
				fn : function(btn){
					domAliasName.focus(true);
				}
			});
			return false;
		}
		else if (domAlias == true && (domAliasName.getValue()).charAt((domAliasName.getValue()).length-1) == ".")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: domAlaisNamePeriod + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					domAliasName.focus(true);
				}
			});
			return false;
		}
		else if(domAlias == true && domAliasName.getValue().indexOf(".") == -1)
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl97 + ".",
				buttons: Ext.Msg.OK,
				width : 300,
				icon: 'iconExclamation',
				fn : function(btn){
					domAliasName.focus(true);
				}
			});
			return false;
		}
		else if (domAlias == true && !checkNonNumericals(domAliasName.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: _aplhabets + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					domAliasName.focus(true);
				}
			});
			return false;
		}
		else if(dns == true && !checkblank(dmnip.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl46 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					dmnip.focus(true);
				}
			});
			return false;
		}
		else if(dns == true && !validateIp(dmnip.getValue()))
		{
			dmnip.focus(true);
			return false;
		}
		else if(dns == true && !checkspace(dmnip.getValue()))
		{
			dmnip.focus(true);
			return false;
		}
		else if(dns == true && !checkspecial(dmnip.getValue(),"`~!@#$%^&*()+={}[]|\\;\"\'<>,?/"))
		{
			dmnip.focus(true);
			return false;
		}
		else if(dns == true && !validateSingleByte(dmnip.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl47 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					dmnip.focus(true);
				}
			});
			return false;
		}
		else if(dns == true && !checkblank(prtno.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl48 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					prtno.focus(true);
				}
			});
			return false;
		}
		else if(dns == true && !checknumber("+",prtno.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl49 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					prtno.focus(true);
				}
			});
			return false;
		}
		else if(dns == true && !checkfordecimal(prtno.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl50 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					prtno.focus(true);
				}
			});
			return false
		}
		else if(dns == true && prtno.getValue() == "0")
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl51 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					prtno.focus(true);
				}
			});
			return false
		}
		else if(dns == true && !checkspace(prtno.getValue()))
		{
			Ext.Msg.show({
				title: pageTitle,
				msg: pageIntnl52 + ".",
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
				fn : function(btn){
					prtno.focus(true);
				}
			});
			return false
		}
		return true;
	},
	showADUpdateForm : function()
	{
		var domainDisplayName = Ext.getCmp('domainDisName').getValue();
		var reqURI = "EgConfigureDomains/data/EgAuthenticationsJson.jsp?ctype=updateADUserDetails&subjectypes="+encodeURIComponent(domainDisplayName);
		this.updatedomainTree(reqURI);
		var canUpdate = publicJSON['isUserExits'];

		var resultViews = Ext.getCmp('resultViews');
		resultViews.removeAll();
		//if (canUpdate == false)
		{
			var innerHTML = '<div><b>'+'Are you sure to update the User Details from AD for'+'&nbsp;</b><i>'+domainDisplayName+'</i>&nbsp;<b>'+pageIntnl91+' now ?</div>';
			var tmpWidget = Ext.widget("updateuserdetails",{
				buttonAlign : 'center',
				items : [
					{
						xtype : 'container',
						margin : '20 0 10 0',
						style:{'text-align':'center','margin':'0 auto 20 auto'},
						html:innerHTML
					}
				],
				buttons: [
					{
						text : 'Update',
						id : 'update',
						cls : 'button20'
					}
				]
			});
			resultViews.add(tmpWidget);
		}
		Ext.getCmp('updateuserdetails').doLayout();
	},
	updateADUserDetails : function()
	{
		var urlString = "EgConfigureDomains/data/EgAuthenticationspJson.jsp?ctype=updateADUserDetails";
		var me = this;
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var updatedomainuserdetails = this.getUpdateuserdetails().getForm();
		if (updatedomainuserdetails.isValid())
		{
			this.getUpdateuserdetails().submit({
				url: urlString,
				method: 'POST',
				timeout:3600000,
				success: function(form, action){
					myMask.hide();
					var resultObj = Ext.decode(action.response.responseText);
					Ext.Msg.show({
						title: resultObj.result.title,
						msg: resultObj.result.message1 + ".",
						buttons: Ext.Msg.OK,
						icon: 'iconInformation',
					});

					me.updatedomainTree("EgConfigureDomains/data/EgViewDomainsJson.jsp");
					var domainTreePanel = Ext.getCmp('domainTreePanel');
					var domainRightPanel = Ext.getCmp('domainRightPanel');
					me.updateTree();
					domainRightPanel.removeAll();
					domainRightPanel.add({xtype:'viewdomains'});
					Ext.getCmp('domainGrid').getStore().loadRawData(publicJSON['alldomains']);
					if (Ext.isEmpty(publicJSON.alldomains))
					{
						me.disableDeleteIcon();
					}
				},
				failure: function(form, action)
				{
					myMask.hide();
				}
			});
		}
	}
});


function selectDomain(displayName)
{
	var domainTreeObj = Ext.getCmp('domainTreePanel');
	var record = domainTreeObj.getStore().getNodeById(displayName);
	domainTreeObj.getSelectionModel().select(record);

	var nodeName = record.data.text;
	var node_id = record.data.id;
	var myLink = record.raw.link;

	var domainRightPanel = Ext.getCmp('domainRightPanel');
	domainRightPanel.removeAll();
	domainRightPanel.add({xtype:'domainconfiguarationpanel'});
	appCnt.updateDomActionItems(nodeName);
	Ext.getCmp('domainDisName').setValue(nodeName);
	domainDetailsArray = publicJSON['domainSubValues'];
	appCnt.viewSelectedDomain();
}

function closeAlert()
{
	Ext.Ajax.request({
		url:'EgConfigureDomains/data/EgBuildTreeJSON.jsp', 
		method:'POST',
	});
}
