
Ext.define('EgConfigureDomains.view.EgViewDomains',{
	extend:'Ext.form.Panel',
	alias:'widget.viewdomains',
	requires: [
		'EgConfigureDomains.view.ResultPanel',
	],
	id:'viewdomains',
	border:false,
	scroll: false,
	autoScroll : false,
	cls:'outerpanel',

	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	flex : 1,
	
	items : [
		{
			xtype: 'grid',
			id: 'domainGrid',
			flex :1,
			cls:'gridSkin',
			margin: 10,
			store: new Ext.data.Store({
				fields: ['Display Name','Domain Name','Domain Alias Name','Parent','Domain User','Domain IP','Port No','Discovery','SSL'],
				data: []
			}),

			emptyText : '<div class = "iconInformation" style="margin:18% auto auto auto"></div><div  id=\"userDeferMessage2\" class="commonErrorMsgText">'+pageIntnl1+'</div>',
			viewConfig: {
				deferEmptyText: false
			},

			tbar : [
				{
					xtype:'tbfill',
				},
				{
					xtype:'toolbar',
					ui:'footer',
					items:[
						{
							xtype : 'button',
							text : pageIntnl65,
							id : 'addNewDomain',
							cls : 'button20',
							handler : function()
							{
								appCnt.addNewDomain();
							}
						},
						{
							xtype : 'button',
							text : pageIntnl66,
							id : 'deleteAllDomain',
							cls : 'button20',
							handler : function()
							{
								var domainTreeURL = "EgConfigureDomains/data/EgAuthenticationspJson.jsp?ctype=deleteAll";
								appCnt.deleteAllDomains(domainTreeURL);
							}
						},
						{
							xtype : 'button',
							text : pageIntnl67,
							id : 'installCert',
							cls : 'button20',
							handler : function()
							{
								appCnt.installCert();
							}
						},
						{
							xtype : 'button',
							text : pageIntnl68,
							id : 'uninstallCert',
							cls : 'button20',
							handler : function()
							{
								appCnt.unInstallCert();
							}
						},
						{
							xtype : 'button',
							text : viewCertificate,
							id : 'viewCert',
							cls : 'button20',
							handler : function()
							{
								appCnt.viewInstalledCert();
							}
						}
					]
				}
			],

			columns: [{
				dataIndex: 'Display Name',
				header: 'Display Name',
				flex: 1,
				//renderer : function(value)
				//{
				//	return '<a id="mouse" href="javascript:void(0)" onclick=\'javascript:selectDomain("'+value+'")\' class="eg_monlink">'+value+'</a>';
				//}
			},
			{
				dataIndex: 'Domain Name',
				header: 'Domain Name',
				flex: 1
			},
			{
				dataIndex: 'Domain Alias Name',
				header: 'Domain Alias Name',
				flex: 1
			},
			{
				dataIndex: 'Parent',
				header: 'Parent',
				flex: 1
			},
			{
				dataIndex: 'Domain User',
				header: 'Domain User',
				flex: 1
			},
			{
				dataIndex: 'Domain IP',
				header: 'Domain IP',
				flex: 1
			},
			{
				dataIndex: 'Port No',
				header: 'Port No',
				width: 80
			},
			{
				dataIndex: 'Discovery',
				header: 'Discovery',
				width: 80
			},
			{
				dataIndex: 'SSL',
				header: 'SSL',
				width: 40
			}],
			hideHeaders: false,
			hidden : false
		}
	]
});



