
var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
	clicksToEdit: 1
});
 
Ext.define('EgConfigureDomains.view.GridTemplate',{
	extend:'EgConfigureDomains.view.DomainDetailsGrid',
	requires:['Ext.selection.CellModel','Ext.selection.CheckboxModel'],
	alias:'widget.gridtemplate',
	id : 'gridtemplate',
	initComponent : function()
	{
		this.callParent();
	},
	plugins: [cellEditing],
	store:Ext.create('Ext.data.Store',{
		fields:['ipaddress', 'hostName', 'port'],
		data:[]
	}),
	width:830,
	columns: [
		{
			header: "IP Address",
			menuDisabled : true,
			dataIndex: 'ipaddress',
			flex: 1, 
		},
		{
			header: "Host Name", 
			menuDisabled : true,
			dataIndex: 'hostName',
			flex: 1, 
		},
		{
			header: "Ports", 
			dataIndex: 'port',
			width : 150,
			sortable: false,
			menuDisabled : true,
			editor: new Ext.form.field.ComboBox({
				cls: 'dropdown',
				editable: false,
				width : 150,
				displayField : 'displayField',
				valueField : 'valueField',
				queryMode : 'local',
				fields : ['displayField', 'valueField'],
				store: [
					['389','389'],
					['636','636 - SSL'],
					['3268','3268'],
					['3269','3269 - SSL'],
				],
				value : '389'
			})
		},
		{
			
			xtype: 'actioncolumn',
			renderer: function(value, metaData, record, row, col, store, gridView)
			{
			metaData.tdAttr = "data-qtip='Bind' data-qclass='yellowTip'";
			},			
			width: 36,
			//icon: '../../../../resources/images/edit_task.png',
			iconCls: 'iconBind',
			sortable: false,
			menuDisabled : true,
			handler: function(grid, rowIndex, colIndex) {
				var rec = grid.getStore().getAt(rowIndex);
				appCnt.getDNSStackTraceInfo(rec.get('ipaddress'),rec.get('port'));
			}
		},
		{
			
			xtype: 'actioncolumn',
			renderer: function(value, metaData, record, row, col, store, gridView)
			{
			metaData.tdAttr = "data-qtip='Reverse Lookup' data-qclass='yellowTip'";
			},
			//icon: '../../../../resources/images/edit_task.png',
			width: 36,
			menuDisabled : true,
			items: [{
			iconCls: 'iconReverseLookup',
			sortable: false,
			menuDisabled : true,
			handler: function(grid, rowIndex, colIndex) {
				var rec = grid.getStore().getAt(rowIndex);
				appCnt.getReverseDNSStackTrace(rec.get('ipaddress'));
			}
			}]
		}
	]

});



