<%
/*
 *   File			:	EgConfigureVCTasks.jsp
 *   Purpose		:	UI for configuring tasks for vCenter server
 *   Creation Date	:	10/03/2009
 *   Author			:	Vaathsalya
 *   UI Design		:	Krishnamurthi
*/
%>

<%@ include file="EgTrackerA.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo"%>

<%@ taglib prefix ="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	IniFile egTestsini = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini");
	String strDescriptor = request.getParameter("descriptor");
	strDescriptor = (strDescriptor == null?"":strDescriptor);
%>

<%
	String[] descriptor_arr = egTestsini.getVariables("VCTaskFilterTypes");
	ArrayList aListDescriptor = new ArrayList();
	String tasks ="";
	String tasksEntry = "";
	ArrayList aListIncludedTasks = new ArrayList();
	ArrayList aListExcludedTasks = new ArrayList();

	for (int i=0; i<descriptor_arr.length; i++)
	{
		String strDesc = "";
		String strTestAndDescriptor = descriptor_arr[i];
		strDesc = strTestAndDescriptor.substring(strTestAndDescriptor.lastIndexOf(":")+1);
		aListDescriptor.add(strDesc);
	}
	Collections.sort(aListDescriptor,String.CASE_INSENSITIVE_ORDER);

	if (strDescriptor != null)
	{
		String thisToken = "";
		tasks = egTestsini.getValue("VirtualCenterTasks","VCTaskEvtTest:"+strDescriptor).trim();
		tasksEntry = egTestsini.getValue("VCTaskFilterTypes","VCTaskEvtTest:"+strDescriptor).trim();
		StringTokenizer st1 = new StringTokenizer(tasks,",");
		if (tasksEntry.equalsIgnoreCase("all:none"))
		{
			while (st1.hasMoreTokens())
			{
				thisToken = st1.nextToken().trim();
				aListIncludedTasks.add(thisToken);
			}
		}
		else if (tasksEntry.equalsIgnoreCase("none:all"))
		{
			while (st1.hasMoreTokens())
			{
				thisToken = st1.nextToken().trim();
				aListExcludedTasks.add(thisToken);
			}
		}
		else if (!tasksEntry.startsWith("all:") && tasksEntry.endsWith("none"))
		{
			String temp = tasksEntry.substring(0,tasksEntry.indexOf(":"));
			StringTokenizer st2 = new StringTokenizer(temp,",");
	
			while (st2.hasMoreTokens())
			{
				thisToken = st2.nextToken().trim();
				aListIncludedTasks.add(thisToken);
			}

			while (st1.hasMoreTokens())
			{
				String token = st1.nextToken().trim();
				if (aListIncludedTasks.contains(token)) continue;
				aListExcludedTasks.add(token);
			}
		}
		else if (tasksEntry.startsWith("all")&& !tasksEntry.endsWith(":none"))
		{
			String temp = tasksEntry.substring(tasksEntry.lastIndexOf(":")+1);
			StringTokenizer st3 = new StringTokenizer(temp,",");

			while (st3.hasMoreTokens())
			{
				thisToken = st3.nextToken().trim();
				aListExcludedTasks.add(thisToken);
			}

			while (st1.hasMoreTokens())
			{
				String token = st1.nextToken().trim();
				if (aListExcludedTasks.contains(token)) continue;
				aListIncludedTasks.add(token);
			}
		}
	}

	String fromPage = request.getParameter("fromPage");
	fromPage = (fromPage != null)?fromPage:"";

	String tmpUrl = "listSearch.jsp?title=VCENTER TASKS&subtitle=false";
	if (fromPage != null && fromPage.equalsIgnoreCase("TestConfiguration"))
	{
		tmpUrl = tmpUrl + "&backButton=true";
	}

	String requestFrom = request.getParameter("requestFrom");
	if (requestFrom != null && requestFrom.equals("EgConfigureComponentTests.jsp"))
	{
		String componentType = request.getParameter("componentType");
		String componentName = request.getParameter("componentName");
		String testName = request.getParameter("testName");
	}
%>

<html>
<head>
<egui:skin ui="admin"/>
<SCRIPT LANGUAGE="JavaScript">

function selectType()
{
	var thisForm = document.vctask;
	var selectedDesc =  thisForm.descriptor.options[thisForm.descriptor.selectedIndex].value;
	var fromPage = thisForm.fromPage.value;
	if (selectedDesc != "-1")
	{
		if (fromPage == "TestConfiguration")
		{
			window.location.href = "EgConfigureVCTasks.jsp?descriptor="+encodeURI(selectedDesc)+"&fromPage=TestConfiguration";
		}
		else
		{
			window.location.href = "EgConfigureVCTasks.jsp?descriptor="+encodeURI(selectedDesc);
		}
	}
	else
	{
		if (fromPage == "TestConfiguration")
		{
			window.location.href = "EgConfigureVCTasks.jsp?fromPage=TestConfiguration";
		}
		else
		{
			window.location.href = "EgConfigureVCTasks.jsp";
		}
	}
}

function addToExcluded()
{
	var thisForm = document.vctask;
	var includedTasksLen = thisForm.includedTasks.options.length;
	var excludedTasksLen = thisForm.excludedTasks.options.length;
	var includedTasksList = thisForm.includedTasks;
	var excludedTasksList = thisForm.excludedTasks;

	for (i=0;i<includedTasksLen;i++)
	{
		if (includedTasksList.options[i].selected==true)
		{
			testTxt = includedTasksList.options[i].text;
			testVal = includedTasksList.options[i].value;
			excludedTasksList.options[excludedTasksLen++]=new Option(testTxt,testVal);
		}
	}

	for (i=includedTasksLen;i>0;i--)
	{
		if (includedTasksList.options[i-1].selected==true)
		{
			includedTasksList.options[i-1]=null;
		}
	}

}

function addToIncluded()
{
	var thisForm = document.vctask;
	var includedTasksLen = thisForm.includedTasks.options.length;
	var excludedTasksLen = thisForm.excludedTasks.options.length;
	var includedTasksList = thisForm.includedTasks;
	var excludedTasksList = thisForm.excludedTasks;
	for (i=0;i<excludedTasksLen;i++)
	{
		if (excludedTasksList.options[i].selected==true)
		{
			testTxt = excludedTasksList.options[i].text;
			testVal = excludedTasksList.options[i].value;
			includedTasksList.options[includedTasksLen++]=new Option(testTxt,testVal);
		}
	}

	for (i=excludedTasksLen;i>0;i--)
	{
		if (excludedTasksList.options[i-1].selected==true)
		{
			excludedTasksList.options[i-1]=null;
		}
	}
}

function updateData()
{
	var thisForm = document.vctask;
	var prevIncludedTasks = "<%=aListIncludedTasks%>";
	var prevExcludedTasks = "<%=aListExcludedTasks%>";
	var selectedDescriptor  = thisForm.descriptor.options[thisForm.descriptor.selectedIndex].value;
	var includedTasksLen = thisForm.includedTasks.options.length;
	var excludedTasksLen = thisForm.excludedTasks.options.length;
	var includedTasksList = thisForm.includedTasks;
	var excludedTasksList = thisForm.excludedTasks;
	var includedTasks_arr = new Array();
	var excludedTasks_arr = new Array();

	if (selectedDescriptor == "-1")
	{
		alert('<egui:intnl text="admin.vctask.Please choose a task category"/>');
		return false;
	}

	for (var i=0;i<includedTasksLen;i++)
	{
		includedTasks_arr[i] = includedTasksList.options[i].value;
	}

	for (var i=0;i<excludedTasksLen;i++)
	{
		excludedTasks_arr[i] = excludedTasksList.options[i].value;
	}

	thisForm.prevIncludedTasks.value = prevIncludedTasks;
	thisForm.prevExcludedTasks.value = prevExcludedTasks;
	thisForm.strIncludedTasks.value = includedTasks_arr;
	thisForm.strExcludedTasks.value = excludedTasks_arr;
	thisForm.submit();
}

</SCRIPT>
</head>

<body style="overflow:auto" id="space6">
<form name="vctask" method="post" action="EgConfigureVCTasksp.jsp" style="margin:0px">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
	<jsp:include page="<%=tmpUrl%>" />
	<tr>
		<td width="100%" id="eg_whitebg" align="center" valign="middle">
			<table align="center" cellspacing="0" cellpadding="0" border="0" width="98%">
				<tr>
					<td height="6" id="inner_top_left" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
					<td height="6" id="eg_subcontentbg" width="100%" colspan="2"><img src="/final/admin/eg_images/spacer.gif" height="6"></td>
					<td height="6" id="inner_top_right" width="7" class="eg_subcontentbg"><img src="/final/admin/eg_images/spacer.gif" border="0" width="7" height="6"></td>
				</tr>
				<tr>
					<td colspan="4" id="eg_subcontentbg" class="form_border">
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td width="35%" align="right" nowrap><egui:intnl text="admin.vctask.Task category"/></td>
								<td>&nbsp;&nbsp;:&nbsp;&nbsp;</td>
								<td id="eg_subcontentbg" align="left" class="paddingright">
									<select name="descriptor" style="width:150px" onchange="javascript:selectType()">
<%
	if (aListDescriptor != null && aListDescriptor.size() > 0)
	{
%>
		<option value="-1"><egui:intnl text="admin.common.Choose one" /></option>
<%
		for (int j=0;j<aListDescriptor.size();j++)
		{
			String descVal = (String)aListDescriptor.get(j);
%>
			<option value="<%=descVal%>" <%=descVal.equals(strDescriptor)?"selected":""%>><%=descVal%></option>
<%
		}
	}
	else
	{
%>
		<option value="-1"><egui:intnl text="admin.vctask.Not Applicable" /></option>
<%
	}
%>
									</select>
								</td>
								<td width="50">&nbsp;</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td colspan="4" id="eg_subcontentbg" class="padding4"><br>
						<table align="center" cellspacing="0" cellpadding="0" border="0">
							<tr>
								<td width="45%">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4"><strong><egui:intnl text="admin.vctask.Included Tasks"/></strong></td>
										</tr>
										<tr>
											<td align="center" valign="middle">
												<select name="includedTasks" size="25" multiple style="width:400px;margin:0px;">
<%
	Collections.sort(aListIncludedTasks,String.CASE_INSENSITIVE_ORDER);
	for (int m=0;m<aListIncludedTasks.size();m++)
	{
		String inclTasks = (String)aListIncludedTasks.get(m);
%>
		<option value="<%=inclTasks%>"><%=inclTasks%></option>
<%
	}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
								<td id="tablebg2"  nowrap>&nbsp;&nbsp;&nbsp;</td>
								<td width="10%" align="center" valign="middle" id="head_padding2">
									<input type="button" value='&rsaquo;&rsaquo;' class="eg_lightbutton" name="Exclude" style="width: 60px; letter-spacing: 0px;" onclick="addToExcluded()">
									<br><br><br>
									<input type="button" value='&lsaquo;&lsaquo;' class="eg_lightbutton" name="include" style="width: 60px; letter-spacing: 0px;" onclick="addToIncluded()">
								</td>
								<td id="tablebg2"  nowrap>&nbsp;&nbsp;&nbsp;</td>
								<td width="45%">
									<table align="center" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td id="eg_subheadbg" align='center' valign='middle' class="head_padding4" style="border-left-width:1px"><strong><egui:intnl text="admin.vctask.Excluded Tasks"/></strong></td>
										</tr>
										<tr>
											<td align="center" valign="middle">
												<select name="excludedTasks" size="25" multiple style="width:400px;margin:0px">
<%
	Collections.sort(aListExcludedTasks,String.CASE_INSENSITIVE_ORDER);
	for (int mm=0;mm<aListExcludedTasks.size();mm++)
	{
		String exclTasks = (String)aListExcludedTasks.get(mm);
%>
		<option value="<%=exclTasks%>"><%=exclTasks%></option>
<%
	}
%>
												</select>
											</td>
										</tr>
										<tr>
											<td>&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td height="6" id="inner_bott_left" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="100%" colspan="2" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" id="inner_bott_right" width="7" class="eg_subcontentbg"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td colspan="4" align="center" height="40" valign="middle">
						<input type="button" name="updateButton" value='<egui:intnl text="admin.common.Update"/>' class="eg_back" style="width: 90px;" onClick="updateData()">
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>

<input type="hidden" name="prevIncludedTasks" value="">
<input type="hidden" name="prevExcludedTasks" value="">
<input type="hidden" name="strIncludedTasks" value="">
<input type="hidden" name="strExcludedTasks" value="">
<input type="hidden" name="fromPage" value="<%=fromPage%>">
</form>

<%
	session.setAttribute("adminLastAccessedURL","/final/admin/EgConfigureVCTasks.jsp?"+request.getQueryString());
%>

</body>
</html>



