Ext.define('EgConsolidatedReports.controller.Main',{
	extend:'Ext.app.Controller',
	views:['ConsolidatedReports','ConsolidatedMeasures'],
	refs:[
		{selector:'consolidatedreports', ref:'consolidatedreports'},
		{selector:'consolidatedmeasures', ref:'consolidatedmeasures'}
	],

	init: function(){
		addFlag = '';
		me = this;
		this.control({
			'consolidatedreports':
			{
				'afterrender': this.afterMainRender
			},
			'consolidatedreports button[id=UpdateBtn]':
			{
				'click': this.updateInReport
			},
			'consolidatedreports combo[id=Category]':
			{
				'select': this.changeCategory
			},
			'consolidatedreports button[id=configureMetrics]':
			{
				'click': this.configureMetrics
			},

			'consolidatedmeasures combo[id=category]':
			{
				'select': this.categoryChange
			},
			'consolidatedmeasures combo[id=componentType]':
			{
				'select': this.componentTypeChange
			},
			'consolidatedmeasures combo[id=test]':
			{
				'select': this.testsChange
			},
			'consolidatedmeasures combo[id=measureID]':
			{
				'select': this.measureChange
			},
			'consolidatedmeasures button[id=updateBtn]':
			{
				'click': this.update
			},
			'consolidatedmeasures button[id=addBtn]':
			{
				'click': this.addForUpdate
			},
			'consolidatedmeasures button[id=deleteBtn]':
			{
				'click': this.deleteForUpdate
			},
			'consolidatedmeasures button[id=backButton]':
			{
				'click': this.goToConsolidatedReports
			},
		});
	},

	afterMainRender: function()
	{
		if (!Ext.isEmpty(servicesFromSession) && servicesFromSession == 'Services')
		{
			this.configureMetrics();
		}
		else
		{
			var categoryObj = Ext.getCmp('Category');
			var timeFromObj = Ext.getCmp('timefrom');
			var timeToObj = Ext.getCmp('timeto');
			var timelineObj = Ext.getCmp('timeline');
			var dayObj = Ext.getCmp('multiselectDays');
			var secType = 'ZONE';
			var catType = 'Zone';

			Ext.getCmp('configureMetrics').setDisabled(false);

			var url = "/final/admin/EgConsolidatedReports/data/EgConsolidatedReportsJSON.jsp?catType="+catType+"&secType="+secType;
			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var selectedFromHourJson = jsonData.selectedFromTimeJson.Hourfrom;
					var selectedFromMinJson = jsonData.selectedFromMinJson.Minfrom;

					var selectedToHourJson = jsonData.selectedToTimeJson.Hourto;
					var selectedToMinJson = jsonData.selectedToMinJson.Minto;

					var selectedFromTime = selectedFromHourJson + ':' + selectedFromMinJson;
					var selectedToTime = selectedToHourJson + ':' + selectedToMinJson;

					var selectedTimeline = jsonData.selectedTimeLineJson.timeline;

					var selectedDays = jsonData.selectedDaysOfWeekArrayJson;

					if (!Ext.isEmpty(jsonData.catTypeArrayJson) && jsonData.catTypeArrayJson.length > 0)
					{
						categoryObj.getStore().removeAll();
						categoryObj.getStore().loadRawData(jsonData.catTypeArrayJson);
						categoryObj.setValue(jsonData.catTypeArrayJson[0].valueField);
					}

					timeFromObj.setValue(selectedFromTime);

					if (selectedToTime == '24:00')
					{
						timeToObj.setValue('23:59');
					}
					else
					{
						timeToObj.setValue(selectedToTime);
					}

					if (!Ext.isEmpty(jsonData.timeLineArrayJson) && jsonData.timeLineArrayJson.length > 0)
					{
						timelineObj.getStore().removeAll();
						timelineObj.getStore().loadRawData(jsonData.timeLineArrayJson);
					}

					if (!Ext.isEmpty(selectedTimeline))
					{
						timelineObj.setValue(selectedTimeline);
					}
					else
					{
						timelineObj.setValue(jsonData.timeLineArrayJson[0].valueField);
					}

					var valuesToSet = new Array();

					Ext.getCmp('multiselectDays').getStore().loadRawData(jsonData.daysOfWeekArrayJson);

					var timelineArray = new Array();

					for (var i=0; i<selectedDays.length; i++)
					{
						var selectedDay = selectedDays[i].displayField;
						timelineArray[i] = selectedDay;
					}

					dayObj.setValue(timelineArray);
				}
			});
		}
	},

	updateInReport: function()
	{
		var multiSelectValue = Ext.getCmp('multiselectDays').getValue();
		var catval = Ext.getCmp('Category').getValue();
		var excweekend = '';
		var serverType = 'Default';
		var Deleted = 'false';
		var timefromForAudit = '';
		var minfromForAudit = '';
		var timetoForAudit = '';
		var mintoForAudit = '';
		var currentWeekendForAudit = new Array();

		var secType = '';
		if (catval.toUpperCase()=='ZONE')
			secType='ZONE';
		else if (catval=='Server')
			secType='SERVER';
		else if (catval=='Services')
			secType='SERVICES'
		else if (catval=='Thin client session')
			secType='CITRIX SESSION'
		else if (catval=='Thin client application')
			secType='APPLICATION'
		else if (catval=='Thin client user')
			secType='CITRIX_USER'

		var url = "/final/admin/EgConsolidatedReports/data/EgConsolidatedReportsJSON.jsp?catType="+catval+"&secType="+secType;

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var selectedFromHourJson = jsonData.selectedFromTimeJson.Hourfrom;
				var selectedFromMinJson = jsonData.selectedFromMinJson.Minfrom;

				var selectedToHourJson = jsonData.selectedToTimeJson.Hourto;
				var selectedToMinJson = jsonData.selectedToMinJson.Minto;

				var selectedFromTime = selectedFromHourJson + ':' + selectedFromMinJson;
				var selectedToTime = selectedToHourJson + ':' + selectedToMinJson;

				var selectedTimeline = jsonData.selectedTimeLineJson.timeline;

				var selectedDays = jsonData.selectedDaysOfWeekArrayJson;

				Ext.getCmp('$_category').setValue(jsonData.catTypeArrayJson[0].displayField);

				for (var i=0; i<multiSelectValue.length; i++)
				{
					if (i==0)
					{
						excweekend = multiSelectValue[i];
						currentWeekendForAudit[i] = multiSelectValue[i];
					}
					else if (i == multiSelectValue.length-1)
					{
						excweekend = excweekend + "," + multiSelectValue[i];
						currentWeekendForAudit[i] = multiSelectValue[i];
					}
					else
					{
						excweekend = multiSelectValue[i]+ "," + excweekend;
						currentWeekendForAudit[i] = multiSelectValue[i];
					}
				}

				currentWeekendForAudit.sort();

				for (var i=0; i<currentWeekendForAudit.length; i++)
				{
					if (i==0)
					{
						excweekend = currentWeekendForAudit[i];
					}
					else if (i == currentWeekendForAudit.length-1)
					{
						excweekend = excweekend + "," + currentWeekendForAudit[i];
					}
					else
					{
						excweekend = currentWeekendForAudit[i]+ "," + excweekend;
					}
				}

				for (var i=0; i<jsonData.timeLineArrayJson.length; i++)
				{
					var displayField = jsonData.timeLineArrayJson[i].displayField;
					var valueField = jsonData.timeLineArrayJson[i].valueField;
				}

				Ext.getCmp('$_category').setValue(jsonData.selectedCatTypeJson.catType);
				Ext.getCmp('$_timefrom').setValue(selectedFromHourJson);
				Ext.getCmp('$_minfrom').setValue(selectedFromMinJson);

				Ext.getCmp('$_timeto').setValue(selectedToHourJson);
				Ext.getCmp('$_minto').setValue(selectedToMinJson);

				if (selectedTimeline == '168')
				{
					selectedTimeline = '1 week';
				}
				else if (selectedTimeline == '336')
				{
					selectedTimeline = '2 week';
				}
				else if (selectedTimeline == '504')
				{
					selectedTimeline = '3 week';
				}
				else if (selectedTimeline == '672')
				{
					selectedTimeline = '4 week';
				}
				else if (selectedTimeline == '720')
				{
					selectedTimeline = '1 month';
				}
				else if (selectedTimeline == '-1')
				{
					selectedTimeline = 'Unlimited';
				}

				Ext.getCmp('$_timeline').setValue(selectedTimeline);
				var valuesToSet = new Array();

				var timelineArray = new Array();
				for (var i=0; i<selectedDays.length; i++)
				{
					var selectedDay = selectedDays[i].displayField;
					timelineArray[i] = selectedDay;
				}
				timelineArray.sort();

				Ext.getCmp('$_exeweekend').setValue(timelineArray);

				var Category = Ext.getCmp('Category').getValue();

				var timeFrom = Ext.getCmp('timefrom').getValue();
				timeFrom = Ext.Date.format(timeFrom, 'H:i');
				timeFromStr = new String(timeFrom);
				var hourFrom = timeFromStr.substring(0,timeFromStr.indexOf(':'));
				timefromForAudit = hourFrom;

				minFromStr = new String(timeFrom);
				var minFrom = minFromStr.substring(minFromStr.indexOf(':')+1);
				minfromForAudit = minFrom;

				var timeTo = Ext.getCmp('timeto').getValue();
				timeTo = Ext.Date.format(timeTo, 'H:i');
				timeToStr = new String(timeTo);
				var hourTo = timeToStr.substring(0,timeToStr.indexOf(':'));
				timetoForAudit = hourTo;

				minToStr = new String(timeTo);
				var minTo = minToStr.substring(minToStr.indexOf(':')+1);
				mintoForAudit = minTo;

				var timeLine = Ext.getCmp('timeline').getValue();

				Ext.getCmp('excweekend').setValue(excweekend);

				Ext.getCmp('exeweekend').setValue(currentWeekendForAudit);

				Ext.getCmp('serverType').setValue(serverType);

				Ext.getCmp('Deleted').setValue(Deleted);

				Ext.getCmp('secType').setValue(secType);

				var consolidateForm = this.getConsolidatedreports().getForm();
				if (consolidateForm.isValid())
				{
					consolidateForm.submit({
						url: '/final/admin/EgConsolidatedReports/data/EgconsolidatedreportsJSONp.jsp?timefromForAudit='+timefromForAudit+'&minfromForAudit='+minfromForAudit+'&timetoForAudit='+timetoForAudit+'&mintoForAudit='+mintoForAudit,
						method: 'POST',
						success: function(form, action){
							Ext.Msg.show({
								title: consolidatedReportsTitle,
								msg: consolidatedReportSuccess,
								width: 400,
								buttons: Ext.Msg.OK,
								icon: 'iconInformation'
							});
						},
						failure: function(form, action) // if result page doest not contain success:true, this method fires
						{
							Ext.Msg.show({
								title: consolidatedReportsTitle,
								msg: consolidatedReportFailure,
								width: 400,
								buttons: Ext.Msg.OK,
								icon: 'iconExclamation'
							});
						}
					});
				}
			}
		});
	},

	changeCategory: function()
	{
		var catval = Ext.getCmp('Category').getValue();

		var secType = '';
		if (catval.toUpperCase()=='ZONE')
			secType='ZONE';
		else if (catval=='Server')
			secType='SERVER';
		else if (catval=='Services')
			secType='SERVICES';
		else if (catval=='Thin client session')
			secType='CITRIX SESSION';
		else if (catval=='Thin client application')
			secType='APPLICATION';
		else if (catval=='Thin client user')
			secType='CITRIX_USER';

		if (catval.toUpperCase() == 'ZONE' || catval.toUpperCase() == 'SERVER')
		{
			Ext.getCmp('configureMetrics').setDisabled(false);
		}
		else
		{
			Ext.getCmp('configureMetrics').setDisabled(true);
		}

		var url = "/final/admin/EgConsolidatedReports/data/EgConsolidatedReportsJSON.jsp?catType="+catval+"&secType="+secType;

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var selectedCatType = jsonData.selectedCatTypeJson.catType;

				var selectedFromTime = jsonData.selectedFromTimeJson.Hourfrom;
				var selectedMinTime = jsonData.selectedFromMinJson.Minfrom;
				var selectedToTime = jsonData.selectedToTimeJson.Hourto;
				var selectedToMin = jsonData.selectedToMinJson.Minto;
				var selectedTimeline = jsonData.selectedTimeLineJson.timeline;

				var selectedFromTime = selectedFromTime + ':' + selectedMinTime;
				var selectedToTime = selectedToTime + ':' + selectedToMin;

				if (!Ext.isEmpty(selectedFromTime))
				{
					Ext.getCmp('timefrom').setValue(selectedFromTime);
				}

				if (!Ext.isEmpty(selectedToTime) && selectedToTime == '24:00')
				{
					Ext.getCmp('timeto').setValue('23:59');
				}
				
				if (!Ext.isEmpty(selectedToTime) && selectedToTime != '24:00')
				{
					Ext.getCmp('timeto').setValue(selectedToTime);
				}

				if (!Ext.isEmpty(selectedTimeline))
				{
					Ext.getCmp('timeline').setValue(selectedTimeline);
				}

				var selectedWeekendDays = new Array();

				for (var j=0; j<jsonData.selectedDaysOfWeekArrayJson.length; j++)
				{
					selectedWeekendDays[j] = jsonData.selectedDaysOfWeekArrayJson[j].displayField;
				}

				Ext.getCmp('multiselectDays').setValue(selectedWeekendDays);

			}
		});
	},
	
	configureMetrics: function()
	{
		var mainViewId = Ext.getCmp('mainView');

		var categoryFromReport = Ext.getCmp('Category').getValue();

		mainViewId.removeAll();
		mainViewId.add({ xtype: 'consolidatedmeasures' });

		var catTypeObj = Ext.getCmp('category');
		var componentTypeObj = Ext.getCmp('componentType');
		var testObj = Ext.getCmp('test');
		var measureObj = Ext.getCmp('measureID');
		var functionsObj = Ext.getCmp('calfunc');
		var assocMeasuresObj = Ext.getCmp('associatem');
		var calfuncObj = Ext.getCmp('calfuncContainer');

		Ext.getCmp('displayMeasureField').reset();

		if (!Ext.isEmpty(catTypeFromSession) && catTypeFromSession != 'null')
		{
			categoryFromReport = catTypeFromSession
		}

		if (categoryFromReport == 'zone')
		{
			categoryFromReport = 'Zone';
		}

		catTypeObj.setValue(categoryFromReport);

		if (categoryFromReport == 'Server')
		{
			Ext.getCmp('componentType').hide();
			calfuncObj.hide();
		}
		else
		{
			Ext.getCmp('componentType').show();
			calfuncObj.show();
		}

		var catval = Ext.getCmp('category').getValue();

		if (Ext.isEmpty(catval))
		{
			catval='Zone';
		}
		var secType = '';
		if(catval=='Zone')
			secType='ZONE';
		else if(catval=='Server')
			secType='SERVER';
		else
			secType='SERVICES';

		var url = "/final/admin/EgConsolidatedReports/data/EgConsolidatedMeasuresJSON.jsp?secType="+secType+"&catType="+catval+"&category="+catval;

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);

				if (!Ext.isEmpty(publicJson.catTypeArrayJson) && publicJson.catTypeArrayJson.length > 0)
				{
					catTypeObj.getStore().removeAll();
					catTypeObj.getStore().loadRawData(publicJson.catTypeArrayJson);
					catTypeObj.setValue(categoryFromReport);
				}

				if (!Ext.isEmpty(publicJson.compTypeArrayJson) && publicJson.compTypeArrayJson.length > 0)
				{
					componentTypeObj.getStore().removeAll();
					componentTypeObj.getStore().loadRawData(publicJson.compTypeArrayJson);
					componentTypeObj.setValue(publicJson.compTypeArrayJson[0].valueField);
				}

				if (!Ext.isEmpty(publicJson.testsArrayJson) && publicJson.testsArrayJson.length > 0)
				{
					testObj.getStore().removeAll();
					testObj.getStore().loadRawData(publicJson.testsArrayJson);
					testObj.setValue(publicJson.testsArrayJson[0].valueField);
				}

				if (!Ext.isEmpty(publicJson.measuresArrayJson) && publicJson.measuresArrayJson.length > 0)
				{
					measureObj.getStore().removeAll();
					measureObj.getStore().loadRawData(publicJson.measuresArrayJson);
					measureObj.setValue(publicJson.measuresArrayJson[0].valueField);
				}

				if (!Ext.isEmpty(publicJson.functionsArrayJson) && publicJson.functionsArrayJson.length > 0)
				{
					functionsObj.getStore().removeAll();
					functionsObj.getStore().loadRawData(publicJson.functionsArrayJson);
					functionsObj.setValue(publicJson.functionsArrayJson[0].valueField);
				}

				if (categoryFromReport=='Zone' || categoryFromReport == 'zone')
				{
					assocMeasuresObj.getStore().removeAll();
					assocMeasuresObj.getStore().loadRawData(publicJson.assocMeasuresArrayJson);

					var assocMeasures = new Array();

					for (var j=0; j<publicJson.assocMeasuresArrayJson.length; j++)
					{
						assocMeasures[j] = publicJson.assocMeasuresArrayJson[j].valueField;
					}
					Ext.getCmp('associatem').setValue(assocMeasures);
				}
			}
		});
	},

	categoryChange: function()
	{
		var catval = Ext.getCmp('category').getValue();
		var testObj = Ext.getCmp('test');
		var measureObj = Ext.getCmp('measureID');
		var displayMeasureObj = Ext.getCmp('displayMeasureField');
		var calfuncObj = Ext.getCmp('calfuncContainer');
		var assocMeasuresObj = Ext.getCmp('associatem');

		if (catval == 'Server')
		{
			Ext.getCmp('componentType').hide();
			calfuncObj.hide();
		}
		else
		{
			Ext.getCmp('componentType').show();
			calfuncObj.show();
		}

		var secType = '';
		if(catval=='Zone')
			secType='ZONE';
		else if(catval=='Server')
			secType='SERVER';
		else
			secType='SERVICES'

		var url = "/final/admin/EgConsolidatedReports/data/EgConsolidatedMeasuresJSON.jsp?secType="+secType+"&catType="+catval+"&category="+catval;

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);

				if (!Ext.isEmpty(publicJson.hiddenJson.catType) && publicJson.hiddenJson.catType.toLowerCase() == 'zone' )
				{
					Ext.getCmp('componentType').getStore().loadRawData(publicJson.compTypeArrayJson);
					Ext.getCmp('componentType').setValue(publicJson.compTypeArrayJson[0].valueField);
				}

				if (!Ext.isEmpty(publicJson.testsArrayJson) && publicJson.testsArrayJson.length > 0)
				{
					testObj.getStore().loadRawData(publicJson.testsArrayJson);
					testObj.setValue(publicJson.testsArrayJson[0].valueField);
				}

				if (!Ext.isEmpty(publicJson.measuresArrayJson) && publicJson.measuresArrayJson.length > 0)
				{
					measureObj.getStore().loadRawData(publicJson.measuresArrayJson);
					measureObj.setValue(publicJson.measuresArrayJson[0].valueField);
				}
				displayMeasureObj.setValue(' ');

				if (catval=='Zone')
				{
					assocMeasuresObj.getStore().loadRawData(publicJson.assocMeasuresArrayJson);

					var assocMeasures = new Array();

					for (var j=0; j<publicJson.assocMeasuresArrayJson.length; j++)
					{
						assocMeasures[j] = publicJson.assocMeasuresArrayJson[j].displayField;
					}
					Ext.getCmp('associatem').setValue(assocMeasures);
				}
				else
				{
					Ext.getCmp('associatem').getStore().removeAll();
					//assocMeasuresObj.getStore().loadRawData(publicJson.serverMeasuresArrayJson);

					var assocMeasures = new Array();

					for (var j=0; j<publicJson.serverMeasuresArrayJson.length; j++)
					{
						assocMeasures[j] = publicJson.serverMeasuresArrayJson[j].displayField;
					}
					assocMeasuresObj.setValue(' ');
				}
			}
		});
	},

	componentTypeChange: function()
	{
		var catval = Ext.getCmp('category').getValue();
		var componentType = Ext.getCmp('componentType').getValue();
		var testObj = Ext.getCmp('test');
		var measureObj = Ext.getCmp('measureID');
		var assocMeasureObj = Ext.getCmp('associatem');

		var secType = '';
		if(catval=='Zone')
			secType='ZONE';
		else if(catval=='Server')
			secType='SERVER';
		else
			secType='SERVICES'

		var url = "/final/admin/EgConsolidatedReports/data/EgConsolidatedMeasuresJSON.jsp?secType="+secType+"&catType="+catval+"&category="+catval+"&serverType="+componentType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);

					testObj.getStore().loadRawData(publicJson.testsArrayJson);
					testObj.setValue(publicJson.testsArrayJson[0].valueField);

					assocMeasureObj.getStore().loadRawData(publicJson.assocMeasuresArrayJson);
					var assocMeasures = new Array();

					for (var j=0; j<publicJson.assocMeasuresArrayJson.length; j++)
					{
						assocMeasures[j] = publicJson.assocMeasuresArrayJson[j].displayField;
					}
					Ext.getCmp('associatem').setValue(assocMeasures);

					measureObj.setValue(publicJson.measuresArrayJson[0].valueField);
					Ext.getCmp('displayMeasureField').setValue(' ');
				}
			}
		);
	},

	testsChange: function()
	{
		var catval = Ext.getCmp('category').getValue();
		var componentType = Ext.getCmp('componentType').getValue();
		var test = Ext.getCmp('test').getValue();
		var measureObj = Ext.getCmp('measureID');
		var measure = Ext.getCmp('measureID').getValue();
		var assocMeasureObj = Ext.getCmp('associatem');
		assocMeasureObj.reset();

		var secType = '';
		if(catval=='Zone')
			secType='ZONE';
		else if(catval=='Server')
			secType='SERVER';
		else
			secType='SERVICES';

		var url = "/final/admin/EgConsolidatedReports/data/EgConsolidatedMeasuresJSON.jsp?secType="+secType+"&catType="+catval+"&category="+catval+"&serverType="+componentType+"&tests="+test;

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);

				measureObj.getStore().loadRawData(publicJson.measuresArrayJson);
				measureObj.setValue(publicJson.measuresArrayJson[0].valueField);
				Ext.getCmp('displayMeasureField').setValue(' ');

				assocMeasureObj.getStore().loadRawData(publicJson.assocMeasuresArrayJson);

					var associatedItems = new Array();
					for (var i=0;i<Ext.getCmp('associatem').getStore().getCount();i++)
					{
						var allValue = Ext.getCmp('associatem').getStore().getAt(i).get('valueField');
						var dispValue = Ext.getCmp('associatem').getStore().getAt(i).get('displayField');
						associatedItems[i] = allValue;
						
						if (!measuresToUpdateMap.containsKey(allValue))
						{
							measuresToUpdateMap.add(allValue,dispValue);
						}
					}

					var itemsLength = associatedItems.length;
					for (var i=0; i<measuresToUpdate; i++)
					{
						var measuresValue = measuresToUpdate[j];

						for (var j=0; j<itemsLength.length; j++)
						{
							var allValue = associatedItems[i];

							if (allValue == measuresValue)
							{
								break;
							}
							else
							{
								associatedItems[itemsLength++] = measuresToUpdate[j];
							}
						}
					}

					var aStore = new Ext.data.Store({
					fields: ['displayField','valueField'],
					});
					for (var i=0; i<associatedItems.length; i++)
					{
						var assocItems = associatedItems[i];
						var dispField = assocItems;
						if (measuresToUpdateMap != null && measuresToUpdateMap.containsKey(assocItems))
						{
							dispField = measuresToUpdateMap.get(assocItems);
						}
						Ext.getCmp('associatem').bindStore(aStore);
						aStore.add({'displayField': dispField, 'valueField': assocItems});
					}

					var dStore = new Ext.data.Store({
						fields: ['displayField','valueField'],
						});

					var measuresToUpdateAfterDeletion = new Array();
					for (var i=0;i<Ext.getCmp('associatem').getStore().getCount();i++)
					{
						var flag = 'false';
						var allValue = Ext.getCmp('associatem').getStore().getAt(i).get('valueField');

						for (var j=0; j<deletedMeasuresToUpdate.length; j++)
						{
							var assocItems = deletedMeasuresToUpdate[j];

							if (allValue == assocItems)
							{
								flag = 'true';
								break;
							}
							else
							{
								flag = 'false';
							}
						}

						if ( flag != 'true' )
						{
							var dispField = allValue;
							if (measuresToUpdateMap != null && measuresToUpdateMap.containsKey(allValue))
							{
								dispField = measuresToUpdateMap.get(allValue);
							}
							dStore.add({'displayField': dispField, 'valueField': allValue});
							measuresToUpdateAfterDeletion[i] = allValue;
						}
					}
					Ext.getCmp('associatem').bindStore(dStore);

					var assocMeasures = new Array();
					var measuresAfterDeleted = new Array();
					for (var j=0; j<deletedMeasuresToUpdate.length; j++)
					{
						var aDeletedMeasures = deletedMeasuresToUpdate[j];
						var indexOfDeletions = measuresToUpdate.indexOf(aDeletedMeasures);
						measuresAfterDeleted = measuresToUpdate.splice(indexOfDeletions,1);
					}

					for (var j=0; j<measuresAfterDeleted.length; j++)
					{
						associatedItems[itemsLength++] = measuresAfterDeleted[i];
					}

					if (catval == 'Server')
					{
						Ext.getCmp('associatem').getStore().removeAll();
						assocMeasureObj.getStore().loadRawData(publicJson.serverMeasuresArrayJson);

						var assocMeasures = new Array();

						for (var j=0; j<publicJson.serverMeasuresArrayJson.length; j++)
						{
							assocMeasures[j] = publicJson.serverMeasuresArrayJson[j].valueField;
						}

						if (publicJson.serverMeasuresArrayJson.length > 0)
						{
							Ext.getCmp('associatem').setValue(assocMeasures);
						}
						else
						{
							Ext.getCmp('associatem').setValue(' ');
							var aStore = new Ext.data.Store({
								fields: ['displayField','valueField'],
							});
							Ext.getCmp('associatem').getStore().removeAll();
							Ext.getCmp('associatem').bindStore(aStore);
						}
					}
				}
			}
		);
	},

	measureChange: function()
	{
		var catval = Ext.getCmp('category').getValue();
		var componentType = Ext.getCmp('componentType').getValue();
		var test = Ext.getCmp('test').getValue();
		var measure = Ext.getCmp('measureID').getDisplayValue();
		var measureValue = Ext.getCmp('measureID').getValue();

		var secType = '';
		if(catval=='Zone')
			secType='ZONE';
		else if(catval=='Server')
			secType='SERVER';
		else
			secType='SERVICES';

		if (measure != 'Not Applicable' && measure != 'Select any measure')
		{
			Ext.getCmp('displayMeasureField').setValue(measureValue);
		}
		else
		{
			Ext.getCmp('displayMeasureField').setValue(' ');
		}
	},

	addForUpdate: function()
	{
		var measure_all = new Array();
		addFlag = 'added';
		var testname = Ext.getCmp('test').getValue();
		var testDisplayName = Ext.getCmp('test').getDisplayValue();
		var measure = Ext.getCmp('measureID').getValue();
		var measureDisplayName = Ext.getCmp('measureID').getDisplayValue();
		var display = Ext.getCmp('displayMeasureField').getValue();
		var cattype = Ext.getCmp('category').getValue();
		var comptype = Ext.getCmp('componentType').getValue();
		var compTypeDispValue = Ext.getCmp('componentType').getDisplayValue();
		var catval = Ext.getCmp('category').getValue();

		var assocMeasuresObj = Ext.getCmp('associatem');

		var functionsVar = Ext.getCmp('calfunc').getValue();
		var functionsLength = functionsVar.length;
		var funcs = '';

		var secType = '';
		if(catval=='Zone')
			secType='ZONE';
		else if(catval=='Server')
			secType='SERVER';
		else
			secType='SERVICES';

		if (functionsLength == '1' || functionsLength == 1)
		{
			funcs = functionsVar;
		}
		else
		{
			for (var i=0; i<functionsLength; i++)
			{
				if (i==0)
				{
					funcs = functionsVar[i];
				}
				else if (i == functionsLength-1)
				{
					funcs = funcs + ',' + functionsVar[i];
				}
				else
				{
					funcs = functionsVar[i] + ',' + funcs;
				}
			}
		}

		if (cattype =="Zone" || cattype =="Services")
		{
			if (comptype!=null && comptype.length==0)
			{
				Ext.Msg.show({
					title: consolidatedMeasureTitle,
					msg: alertForComponentType,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
			if(testname!=null && testname=='Select any test')
			{
				Ext.Msg.show({
					title: consolidatedMeasureTitle,
					msg: alertForNoTest,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
			if(measure!=null && measure =='-1')
			{
				Ext.Msg.show({
					title: consolidatedMeasureTitle,
					msg: alertForNoMeasure,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
			if (funcs!=null && funcs=='')
			{
				Ext.Msg.show({
					title: consolidatedMeasureTitle,
					msg: noSelectionFuncMsg,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}
		}

		var associatedItemsVar = new Array();
		var itemsLength = Ext.getCmp('associatem').getStore().getCount();
		var selections = '';

		//for(var i=0;i<Ext.getCmp('associatem').getStore().getCount();i++)
		//{
			//var allValue = Ext.getCmp('associatem').getStore().getAt(i).get('valueField');
			//associatedItemsVar[i] = allValue;
		//}
		if (catval == 'Server')
		{
			if(testname!=null && testname=='Select any test')
			{
				Ext.Msg.show({
					title: consolidatedMeasureTitle,
					msg: alertForNoTest,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}

			if(measure!=null && measure =='-1')
			{
				Ext.Msg.show({
					title: consolidatedMeasureTitle,
					msg: alertForNoMeasure,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}




			var measure_all = new Array();
			var aTestsValueField = '';
			var aTestsDisplayField = '';
			var selectionForValue = '';
			var selectionForDisplay = '';
			var selections = '';

			var selection=testname+"="+measure;
			var selectionDisplay=measureDisplayName;
			if (display!=null && display!='')
			{
				selection=selection+"#"+display;
				selectionDisplay=selectionDisplay+"#"+display;
			}
			else
			{
				selection=selection+"#"+measure;
				selectionDisplay=selectionDisplay+"#"+measure;
			}
			x=0;

			if (!assoMeasuresMap.containsKey(testname))
			{
				assoMeasuresMap.add(testname,selectionDisplay);
			}
			else
			{
				var dispVal = assoMeasuresMap.get(testname);
				if (!Ext.isEmpty(selectionDisplay))
				{
					assoMeasuresMap.add(testname,dispVal+','+selectionDisplay);
				}
			}

			for(var i=0;i<Ext.getCmp('associatem').getStore().getCount();i++)
			{
				var allValue = Ext.getCmp('associatem').getStore().getAt(i).get('valueField');
				associatedItemsVar[i] = allValue;
			}
			var itemsLength = associatedItemsVar.length;
			var tmptestname=selection.substring(0,selection.indexOf("="));
			var mes=selection.substring(selection.indexOf("=")+1);

			for(var i=0;i<Ext.getCmp('associatem').getStore().getCount();i++)
			{
				var compl = Ext.getCmp('associatem').getStore().getAt(i).get('valueField');

				if(compl.indexOf(selection) > -1)
				{
					compl = compl.substring(0,compl.indexOf(selection)+selection.length);
				}
				if(selection==compl)
				{
					flag=0;
					break;
				}
			}
			
			if(flag==0)
			{
				Ext.Msg.show({
					title: consolidatedMeasureTitle,
					msg: alertforAlreadyAdded,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}

			var tmptestname=selection.substring(0,selection.indexOf("="));
			var mes=selection.substring(selection.indexOf("=")+1);

			var added=false;
			if(itemsLength > measure_all.length)
			{
				x=0;
				for(var i=0;i<itemsLength;i++)
				{
					if(associatedItemsVar[i]!=-1)
					{
						if (cattype == "Zone")
						{
							measure_all[i]=associatedItemsVar[i];
							x++;
						}
						else
						{
							if((associatedItemsVar[i]).indexOf(tmptestname)>-1)
							{
								measure_all[i]=(associatedItemsVar[i])+","+mes;
								added=true;
							}
							else
							{
								measure_all[i]=associatedItemsVar[i];
								x++;
							}
						}
					}
				}
			}

			if (measure_all != null && measure_all.length > 0)
			{
				if (!added)
				measure_all[x++]=selection;
			}
			if(measure_all.length==0)
			{
				x=0;
				measure_all[0]=selection;
				x++;
			}

			var associatedItems = new Array();

			for(var i=0;i<measure_all.length;i++)
			{
				associatedItems[i] = measure_all[i];
				measuresToUpdate[k++] = measure_all[i];
			}
			var aStore = new Ext.data.Store({
						fields: ['displayField','valueField'],
			});

			var serverTestsArray = new Array();
			var associatedMeasures = new Array();

			var url = "/final/admin/EgConsolidatedReports/data/EgConsolidatedMeasuresJSON.jsp?secType="+secType+"&catType="+catval+"&category="+catval+"&serverType="+comptype+"&tests="+testname;

			Ext.Ajax.request({
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);

					serverTestsArray = publicJson.testsArrayJson;
					var removeMeasures = '';
					for (var i=0; i<associatedItems.length; i++)
					{
						var assocItems = associatedItems[i];
						var displayTestName = assocItems.substring(0,assocItems.indexOf("="));
						var Measure = assocItems.substring(assocItems.indexOf("=")+1,assocItems.indexOf("#"));
						var displayMeasureName = assocItems.substring(assocItems.indexOf("#")+1,assocItems.length);

						for (var j=0; j<serverTestsArray.length; j++)
						{
							var aDisplayValue = serverTestsArray[j].displayField;
							var aValueField = serverTestsArray[j].valueField;

							if (aValueField == displayTestName)
							{
								aTestsValueField = serverTestsArray[j].valueField;
								aTestsDisplayField = serverTestsArray[j].displayField;
								//var index = Ext.getCmp('measureID').getStore().find('displayField',Measure,0,false,false,true);
								selectionForDisplay = aTestsDisplayField + "=" + Measure;
								selectionForDisplay = selectionForDisplay+"#"+displayMeasureName;
								
								selectionForValue = aTestsValueField+"="+Measure;
								selectionForValue = selectionForValue+"#"+displayMeasureName;

								var dispField = selectionForDisplay;
								if (assoMeasuresMap.containsKey(displayTestName))
								{
									dispField = aDisplayValue +'='+ assoMeasuresMap.get(displayTestName);
								}
								aStore.add({'displayField': dispField, 'valueField': selectionForValue});
								removeMeasures = selectionForValue;
							}
						}
						associatedMeasures[i] = selectionForValue;
						//Ext.getCmp('associatem').bindStore(aStore);
						//aStore.add({'displayField': selectionForDisplay, 'valueField': selectionForValue});
						Ext.getCmp('associatem').bindStore(aStore);
					}
					Ext.getCmp('associatem').setValue(associatedMeasures);
					
					var measStore = Ext.getCmp('measureID').getStore();
					var genStore = new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []                                
					});

					if (!Ext.isEmpty(measStore) && measStore.getCount() > 0)
					{
						var removeMeasArr = new Array();
						if (!Ext.isEmpty(removeMeasures))
						{
							var Measure = removeMeasures.substring(removeMeasures.indexOf("=")+1);
							var measArray = new Array();
							if (!Ext.isEmpty(Measure) && Measure.indexOf(',') != -1)
							{
								measArray = Measure.split(',');
							}
							else
							{
								measArray[0] = Measure;
							}
							for (var j=0;j<measArray.length ;j++ )
							{
								var measData = measArray[j];
								measData = measData.substring(0,measData.indexOf("#"));
								removeMeasArr.push(measData);
							}
						}
						var isRecordFound = false;
						for ( var i = 0; i < measStore.getCount() ; i++ )
						{
							var getRecord = measStore.getAt(i).get('valueField');
							if (!Ext.Array.contains(removeMeasArr,getRecord))
							{
								var getValRecord = measStore.getAt(i).get('displayField');
								isRecordFound = true;
									genStore.add({
										'displayField': getValRecord,'valueField': getRecord,
								});
							}
						}
						if (isRecordFound)
						{
							measStore.removeAll();  
							for ( var i = 0; i < genStore.getCount() ; i++ )
							{
								var getRecord = genStore.getAt(i);
								measStore.add(getRecord);
							}
							Ext.getCmp('measureID').setValue('-1');
						}
					}
					Ext.getCmp('displayMeasureField').setValue('');
				}
			});
		}
		else
		{
			var measure_all = new Array();
			var associatedItemsVar = Ext.getCmp('associatem').getValue();
			var itemsLength = associatedItemsVar.length;
			var selections = '';

			var selection = comptype + ":" + testname + ":" + measure;
			var selectionDisplay = compTypeDispValue + ":" + testDisplayName + ":" + measureDisplayName;
			if (display!=null && display!='')
			{
				selection=selection+"#"+display;
				selectionDisplay=selectionDisplay+"#"+display;
			}
			else
			{
				selection=selection+"#"+measureDisplayName;
				selectionDisplay=selectionDisplay+"#"+measureDisplayName;
			}

			var removeMeasures = measure;
			selection+="="+funcs;
			selectionDisplay+="="+funcs;

			if (!measuresToUpdateMap.containsKey(selection))
			{
				measuresToUpdateMap.add(selection,selectionDisplay);
			}
			
			var flag;
			for (var i=0;i<Ext.getCmp('associatem').getStore().getCount();i++)
			{
				var compl = Ext.getCmp('associatem').getStore().getAt(i).get('valueField');
				if(compl.indexOf(selection) > -1)
				{
					compl = compl.substring(0,compl.indexOf(selection)+selection.length);
				}
				if(selection==compl)
				{
					flag=0;
					break;
				}
			}
			if(flag==0)
			{
				Ext.Msg.show({
					title: consolidatedMeasureTitle,
					msg: alertforAlreadyAdded,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return false;
			}

			var added=false;
			var flag;
			if((measure_all!=null) && (measure_all.length>0))
			{
				if (!added)
				measure_all[x++]=selection;
			}
			if(measure_all.length==0)
			{
				x=0;
				measure_all[0]=selection;
				x++;
			}

			var associatedItems = new Array();
			for (var i=0;i<Ext.getCmp('associatem').getStore().getCount();i++)
			{
				var allValue = Ext.getCmp('associatem').getStore().getAt(i).get('valueField');
				var dispValue = Ext.getCmp('associatem').getStore().getAt(i).get('displayField');
				associatedItems[i] = allValue;
				measuresToUpdateMap.add(allValue,dispValue);
			}
			var itemsLength = associatedItems.length;

			for(var i=0;i<measure_all.length;i++)
			{
				associatedItems[itemsLength] = measure_all[i];
				measuresToUpdate[k++] = measure_all[i];
			}
			var aStore = new Ext.data.Store({
						fields: ['displayField','valueField'],
			});

			for (var i=0; i<associatedItems.length; i++)
			{
				var assocItems = associatedItems[i];
				Ext.getCmp('associatem').bindStore(aStore);
				var dispField = assocItems;
				if (measuresToUpdateMap != null && measuresToUpdateMap.containsKey(assocItems))
				{
					dispField = measuresToUpdateMap.get(assocItems);
				}
				var dispField = measuresToUpdateMap.get(assocItems);
				aStore.add({'displayField': dispField, 'valueField': assocItems});
			}

			Ext.getCmp('associatem').setValue(associatedItems);
			measure_all = new Array();

			var measStore = Ext.getCmp('measureID').getStore();
			var genStore = new Ext.data.Store({
				fields : ['displayField', 'valueField'],
				data : []                                
			});

			if (!Ext.isEmpty(measStore) && measStore.getCount() > 0)
			{
				var removeMeasArr = new Array();
				if (!Ext.isEmpty(removeMeasures))
				{
					var measArray = new Array();
					if (!Ext.isEmpty(removeMeasures) && removeMeasures.indexOf(',') != -1)
					{
						measArray = removeMeasures.split(',');
					}
					else
					{
						measArray[0] = removeMeasures;
					}
					for (var j=0;j<measArray.length ;j++ )
					{
						var measData = measArray[j];
						removeMeasArr.push(measData);
					}
				}
				var isRecordFound = false;
				for ( var i = 0; i < measStore.getCount() ; i++ )
				{
					var getRecord = measStore.getAt(i).get('valueField');
					if (!Ext.Array.contains(removeMeasArr,getRecord))
					{
						var getValRecord = measStore.getAt(i).get('displayField');
						isRecordFound = true;
							genStore.add({
								'displayField': getValRecord,'valueField': getRecord,
						});
					}
				}
				if (isRecordFound)
				{
					measStore.removeAll();  
					for ( var i = 0; i < genStore.getCount() ; i++ )
					{
						var getRecord = genStore.getAt(i);
						measStore.add(getRecord);
					}
					Ext.getCmp('measureID').setValue('-1');
				}
			}
			Ext.getCmp('displayMeasureField').setValue('');
		}
	},

	deleteForUpdate: function()
	{
		var selectionForValue = '';
		var assocMeasuresValue = Ext.getCmp('associatem').getValue();
		var testname = Ext.getCmp('test').getValue();
		var catval = Ext.getCmp('category').getValue();
		var assocMeasuresLength = assocMeasuresValue.length;
		var count = 0;
		if (!Ext.isEmpty(assocMeasuresLength) && assocMeasuresLength > 0)
		{
			for (var i=0;i<assocMeasuresLength ; i++)
			{
				var tempVar = assocMeasuresValue[i];
				if(!Ext.isEmpty(tempVar) && tempVar.length > 0)
				{
					count++;
				}
			}
		}

		if (count <= 0)
		{
			Ext.Msg.show({
				title: consolidatedMeasureTitle,
				msg: noSelectionMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation',
			});
			return;
		}
		Ext.MessageBox.confirm(consolidatedMeasureTitle,alertForDeleteConfirmation,
			function(id)
			{
				if (id == 'yes')
				{
					var aStore = new Ext.data.Store({
						fields: ['displayField','valueField'],
					});

					for (var i=0;i<Ext.getCmp('associatem').getStore().getCount();i++)
					{
						var allValue = Ext.getCmp('associatem').getStore().getAt(i).get('valueField');
						var dispValue = Ext.getCmp('associatem').getStore().getAt(i).get('displayField');
						var flag = 'false';

						if (!measuresToUpdateMap.containsKey(allValue))
						{
							measuresToUpdateMap.add(allValue,dispValue);
						}

						for (var j=0; j<assocMeasuresLength; j++)
						{
							var assocItems = assocMeasuresValue[j];

							if (allValue == assocItems)
							{
								flag = 'true';
								break;
							}
							else
							{
								flag = 'false';
							}
						}
						if ( flag != 'true' )
						{
							var dispField = allValue;
							if (measuresToUpdateMap != null && measuresToUpdateMap.containsKey(allValue))
							{
								dispField = measuresToUpdateMap.get(allValue);
							}
							aStore.add({'displayField': dispField, 'valueField': allValue});
						}
					}
					Ext.getCmp('associatem').bindStore(aStore);

					var toHighlight = new Array();
					for (var i=0;i<Ext.getCmp('associatem').getStore().getCount();i++)
					{
						var allValue = Ext.getCmp('associatem').getStore().getAt(i).get('valueField');
						toHighlight[i] = allValue;
					}
					Ext.getCmp('associatem').setValue(toHighlight);

					var removeMeasArr = new Array();
					if (catval == 'Server')
					{
						var associatedMeasures = new Array();

						var url = "/final/admin/EgConsolidatedReports/data/EgConsolidatedMeasuresJSON.jsp?secType="+secType+"&catType="+catval+"&category="+catval+"&tests="+testname;

						Ext.Ajax.request({
							url : url,
							scope:this,
							method : 'POST',
							async: false,
							success: function(response){
								var jsonText = response.responseText;
								publicJson = Ext.decode(jsonText);

								serverTestsArray = publicJson.testsArrayJson;
								for (var i=0; i<assocMeasuresValue.length; i++)
								{
									var assocItems = assocMeasuresValue[i];
									var displayTestName = assocItems.substring(0,assocItems.indexOf("="));
									var Measure = assocItems.substring(assocItems.indexOf("=")+1,assocItems.indexOf("#"));
									var displayMeasureName = assocItems.substring(assocItems.indexOf("#")+1,assocItems.length);

									for (var j=0; j<serverTestsArray.length; j++)
									{
										var aDisplayValue = serverTestsArray[j].valueField;
										if (aDisplayValue == displayTestName)
										{
											aTestsValueField = serverTestsArray[j].valueField;
											selectionForValue = aTestsValueField+"="+Measure;
											selectionForValue = selectionForValue+"#"+displayMeasureName;
										}
									}
									associatedMeasures[i] = selectionForValue;
								}

								for (var j=0; j<associatedMeasures.length; j++)
								{
									var assocItems = associatedMeasures[j];
									deletedMeasuresToUpdate[toDeleteIterator] = assocItems;
									toDeleteIterator = toDeleteIterator + 1;

									var Measure = assocItems.substring(assocItems.indexOf("=")+1);
									var delTestName = assocItems.substring(0,assocItems.indexOf("="));
									if (!Ext.isEmpty(assoMeasuresMap) &&  assoMeasuresMap.containsKey(delTestName))
									{
										assoMeasuresMap.removeAtKey(delTestName);
									}

									var measArray = new Array();
									if (!Ext.isEmpty(Measure) && Measure.indexOf(',') != -1)
									{
										measArray = Measure.split(',');
									}
									else
									{
										measArray[0] = Measure;
									}
									for (var j=0;j<measArray.length ;j++ )
									{
										var measData = measArray[j];
										measData = measData.substring(0,measData.indexOf("#"));
										removeMeasArr.push(delTestName+':'+measData);
									}
								}
							}
						});
					}
					else
					{
						for (var j=0; j<assocMeasuresLength; j++)
						{
							var assocItems = assocMeasuresValue[j];
							deletedMeasuresToUpdate[toDeleteIterator] = assocItems;
							toDeleteIterator = toDeleteIterator + 1;
							var deletedTestName = assocItems.substring(assocItems.indexOf(':')+1,assocItems.lastIndexOf(":"));
							var deletedMeasures = assocItems.substring(assocItems.lastIndexOf(':')+1,assocItems.indexOf("#"));
							removeMeasArr.push(deletedTestName+':'+deletedMeasures)
						}
					}

					var measureCount = Ext.getCmp('measureID').getStore().getCount()
					var genStore = new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []                                
					});
					if (!Ext.isEmpty(removeMeasArr) && removeMeasArr.length > 0)
					{
						if (measureCount <= 1)
						{
							Ext.getCmp('measureID').getStore().removeAll();
							genStore.add({
								'displayField': 'Select any measure','valueField': '-1'
							});
						}

						var isRecordFound = false;
						for ( var i = 0; i < removeMeasArr.length ; i++ )
						{
							var getValRecord = removeMeasArr[i];
							if (!Ext.isEmpty(publicJson.measuresMappingObj))
							{
								var getDispRecord = publicJson.measuresMappingObj[getValRecord];
								if (!Ext.isEmpty(getDispRecord))
								{
									getValRecord = getValRecord.substring(getValRecord.indexOf(':')+1);
									isRecordFound = true;
									genStore.add({
										'displayField': getDispRecord,'valueField': getValRecord,
									});
								}
								
							}
							
						}

						if (isRecordFound)
						{
							//Ext.getCmp('measureID').bindStore(genStore);
							for ( var i = 0; i < genStore.getCount() ; i++ )
							{
								var getRecord = genStore.getAt(i);
								Ext.getCmp('measureID').getStore().add(getRecord);
							}
							Ext.getCmp('measureID').setValue('-1');
						}
					}
				}
			}
		);
	},

	goToConsolidatedReports: function()
	{
		secTypeFromSession = 'Zone';
		var mainViewId = Ext.getCmp('mainView');

		mainViewId.removeAll();
		mainViewId.add({ xtype: 'consolidatedreports' });
		
		//var categoryObj = Ext.getCmp('Category');
		//var timeFromObj = Ext.getCmp('timefrom');
		//var timeToObj = Ext.getCmp('timeto');
		//var timelineObj = Ext.getCmp('timeline');
		//var dayObj = Ext.getCmp('multiselectDays');
		//var secType = 'ZONE';
		//var catType = 'Zone';

		//Ext.getCmp('configureMetrics').setDisabled(false);

		//var url = "/final/admin/EgConsolidatedReports/data/EgConsolidatedReportsJSON.jsp?catType="+catType+"&secType="+secType;

		//Ext.Ajax.request({
			//url : url,
			//scope:this,
			//method : 'POST',
			//success: function(response){
				//var jsonText = response.responseText;
				//var jsonData = Ext.decode(jsonText);

				//var selectedFromHourJson = jsonData.selectedFromTimeJson.Hourfrom;
				//var selectedFromMinJson = jsonData.selectedFromMinJson.Minfrom;

				//var selectedToHourJson = jsonData.selectedToTimeJson.Hourto;
				//var selectedToMinJson = jsonData.selectedToMinJson.Minto;

				//var selectedFromTime = selectedFromHourJson + ':' + selectedFromMinJson;
				//var selectedToTime = selectedToHourJson + ':' + selectedToMinJson;

				//var selectedTimeline = jsonData.selectedTimeLineJson.timeline;

				//var selectedDays = jsonData.selectedDaysOfWeekArrayJson;

				//categoryObj.getStore().loadRawData(jsonData.catTypeArrayJson);
				//categoryObj.setValue(jsonData.catTypeArrayJson[0].displayField);

				//timeFromObj.setValue(selectedFromTime);

				//if (selectedToTime == '24:00')
				//{
					//timeToObj.setValue('23:59');
				//}
				//else
				//{
					//timeToObj.setValue(selectedToTime);
				//}

				//if (!Ext.isEmpty(jsonData.timeLineArrayJson) && jsonData.timeLineArrayJson.length > 0)
				//{
					//timelineObj.getStore().removeAll();
					//timelineObj.getStore().loadRawData(jsonData.timeLineArrayJson);
				//}

				//if (!Ext.isEmpty(selectedTimeline))
				//{
					//timelineObj.setValue(selectedTimeline);
				//}
				//else
				//{
					//timelineObj.setValue(jsonData.timeLineArrayJson[0].valueField);
				//}



				//var valuesToSet = new Array();

				//Ext.getCmp('multiselectDays').getStore().loadRawData(jsonData.daysOfWeekArrayJson);

				//var timelineArray = new Array();

				//for (var i=0; i<selectedDays.length; i++)
				//{
					//var selectedDay = selectedDays[i].displayField;
					//timelineArray[i] = selectedDay;
				//}
				//dayObj.setValue(timelineArray);
			//}
		//});
	},

	update: function()
	{
		var Deleted = '';
		var valFlag = '';

		var catval = Ext.getCmp('category').getValue();
		var componentType = Ext.getCmp('componentType').getValue();
		var test = Ext.getCmp('test').getValue();
		var measure = Ext.getCmp('measureID').getValue();

		var secType = '';
		if(catval=='Zone')
			secType='ZONE';
		else if(catval=='Server')
			secType='SERVER';
		else
			secType='SERVICES';

		var cons = "Consolidated";

		var serverType = Ext.getCmp('componentType').getValue();

		var associatedItemsVar = Ext.getCmp('associatem').getValue();

		var itemsLength = associatedItemsVar.length;
		var associatedItemsSelections = '';

		var deletedItemsLength = deletedMeasuresToUpdate.length;
		var selectionsToDelete = '';

		if (deletedItemsLength > 0)
		{
			Deleted = true;
		}

		for (var i=0; i<deletedItemsLength; i++)
		{
			if (i==0)
			{
				selectionsToDelete = deletedMeasuresToUpdate[i] + '~';
			}
			else if (i == itemsLength-1)
			{
				selectionsToDelete = selectionsToDelete + '~' + deletedMeasuresToUpdate[i];
			}
			else
			{
				selectionsToDelete = deletedMeasuresToUpdate[i] + '~' + selectionsToDelete;
			}
		}

		var associatedItemsForServer = Ext.getCmp('associatem').getValue();

		if(catval=='Server')
		{
			for (var i=0;i<Ext.getCmp('associatem').getValue().length;i++)
			{
				var allValue = associatedItemsForServer[i];
				if (Ext.getCmp('associatem').getValue().length > 0)
				{
					if (i==0)
					{
						associatedItemsSelections = allValue + '$';
					}
					else if (i == itemsLength-1)
					{
						associatedItemsSelections = associatedItemsSelections + '$' + allValue;
					}
					else
					{
						associatedItemsSelections = allValue + '$' + associatedItemsSelections;
					}
				}
				else
				{
					associatedItemsSelections = allValue;
				}
			}
		}
		else
		{
			for (var i=0; i<itemsLength; i++)
			{
				if (i==0)
				{
					associatedItemsSelections = associatedItemsVar[i] + '$';
				}
				else if (i == itemsLength-1)
				{
					associatedItemsSelections = associatedItemsSelections + '$' + associatedItemsVar[i];
				}
				else
				{
					associatedItemsSelections = associatedItemsVar[i] + '$' + associatedItemsSelections;
				}
			}
		}

		Ext.getCmp('assocatedItems').setValue(associatedItemsSelections);
		Ext.getCmp('DeletedMeasure').setValue(selectionsToDelete);
		Ext.getCmp('serverType').setValue(serverType);
		Ext.getCmp('secType').setValue(secType);
		Ext.getCmp('catType').setValue(catval);
		Ext.getCmp('cons').setValue(cons);

		if (addFlag == 'added' || (Ext.getCmp('associatem').getStore().getCount() > 0 ||  !Ext.isEmpty(selectionsToDelete)))
		{
			valFlag = 'true';
		}
		else
		{
			valFlag = 'false';
		}

		var consolidateMeasureForm = this.getConsolidatedmeasures().getForm();
		if (consolidateMeasureForm.isValid())
		{
			if (valFlag == 'true')
			{
				consolidateMeasureForm.submit({
					url: '/final/admin/EgConsolidatedReports/data/EgconsolidatedreportsJSONp.jsp',
					method: 'POST',
					success: function(form, action){
						Ext.Msg.show({
							title: consolidatedMeasureTitle,
							msg: consolidatedReportSuccess,
							width: 400,
							buttons: Ext.Msg.OK,
							icon: 'iconInformation'
						});
						me.testsChange();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						Ext.Msg.show({
							title: consolidatedMeasureTitle,
							msg: consolidatedReportFailure,
							width: 400,
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation'
						});
					}
				});
			}
			else
			{
				Ext.Msg.show({
					title: consolidatedMeasureTitle,
					msg: alertForNoMeasure,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
		}
	}
});



