<!DOCTYPE html>

<%@ include file="EgTrackerA.jsp" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<html>
<head>
	<meta charset="utf-8">
	<title>DB Properties</title>

	<!--Skin color--------->
	<egui:skin ui = "admin"/>

	<!---Components, icons, skin and Core ext script--->
	<script type="text/javascript" src="../extjs/ext-all.js"></script>

	<!-- Fancy Scroll-->
	<script src="/final/jquery/jquery.js"></script>
	<script src="/final/styles/jscrollpane/jquery.jscrollpane.js" ></script>
	<script src="/final/styles/jscrollpane/jquery.mousewheel.js" ></script>
	<script src="/final/styles/jscrollpane/mwheelIntent.js" ></script>
	<link rel="stylesheet" href="/final/styles/jscrollpane/jquery.jscrollpane.css"/>

	<!-- Application folder -->
	<script type="text/javascript" src="EgDbProperties/app/app.js"></script>

	<script language="JavaScript">
		var csrfToken = '<%=strCsrfToken%>';
		var dbPropertiesTitle = '<egui:intnl text="admin.db.Database Properties" />';
		var dbPropertiesDesc = '<egui:intnl text="admin.db.This page enables the administrator to view the current configuration of the eG database" />.';
		var dbVendor = '<egui:intnl text="admin.db.Database Vendor" />';
		var dbHost = '<egui:intnl text="admin.db.Database Host/IP" />';
		var dbPort = '<egui:intnl text="admin.db.Listening Port" />';
		var instanceName = '<egui:intnl text="admin.db.Instance Name" />';
		var dbName = '<egui:intnl text="admin.db.Database Name" />';
		var dbSID = '<egui:intnl text="admin.db.SID" />';
		var dbDriver = '<egui:intnl text="admin.db.Driver" />';
		var dbUserName = '<egui:intnl text="admin.db.Database User Name" />';
		var dbDoubleByte = '<egui:intnl text="admin.db.Double Byte Enabled" />';

		var probsErrorMessage = '<egui:intnl text="admin.error.Problem encountered while loading the user interface"/>.';
		var requestTimeOut = '<egui:intnl text="admin.error.Response timed out"/>.';
		var errorTitle = '<egui:intnl text="admin.user.Error"/>';
	</script>

	<script language="javascript">
		Ext.onReady(function(){
			Ext.Ajax.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.Connection.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};
			Ext.data.ScriptTagProxy.prototype.extraParams = {"com.eg.CSRF_NONCE" : csrfToken};

			Ext.Ajax.on('requestexception', function (conn, response, options) {
				var errorStr = response.responseText;
				if (errorStr != undefined && errorStr != 'undefined' && errorStr.indexOf("customerror") != -1)
				{
					if (errorStr.indexOf("user-session-invalid") != -1)
					{
						callWindow(1);
					}
					else if (errorStr.indexOf("user-deleted") != -1)
					{
						callWindow(2);
					}
					else if (errorStr.indexOf("user-timedout") != -1)
					{
						callWindow(3);
					}
				}
				else
				{
					if (response.status == 302 || (response.timedout != undefined && response.timedout == true))
					{
						Ext.Msg.show({
							title : errorTitle,
							msg : requestTimeOut,
							buttons : Ext.Msg.OK,
							icon : Ext.MessageBox.ERROR
						});
					}
					else
					{
						console.log(response.responseText);
						Ext.Msg.show({
							title : errorTitle,
							msg : probsErrorMessage,
							buttons : Ext.Msg.OK,
							icon : Ext.MessageBox.ERROR
						});
					}
				}
			});
		});
	</script>
</head>
<body>

</body>
</html>



