Ext.define('EgDbProperties.controller.Main',{
	extend:'Ext.app.Controller',
	views:['DatabaseProperties'],
	refs:[
		{selector:'databaseproperties', ref:'databaseproperties'},
	],

	init: function()
	{
		this.control({
			'databaseproperties':
			{
				'afterrender': this.afterMainRender
			},
		});
	},

	afterMainRender: function()
	{
		Ext.Ajax.request({
				url: '/final/admin/EgDbProperties/data/EgDbPropertiesJSON.jsp',
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						publicJSON = Ext.decode( jsonText );

						var dbServerType = publicJSON['dbServerType'];

						if (dbServerType == 'Oracle')
						{
							var oraSID = publicJSON['oraSID'];
							Ext.getCmp('dbName').setFieldLabel('<b>' + dbSID + '</b>');
							Ext.getCmp('dbName').setValue(oraSID);
						}

						if (dbServerType == 'Microsoft SQL')
						{
							Ext.getCmp('dbName').setValue(publicJSON['sqlDbUserName']);
						}

						Ext.getCmp('vendor').setValue(publicJSON['dbServerType']);
						Ext.getCmp('dbIP').setValue(publicJSON['dbIP']);
						var port = publicJSON['port'];
						var instance = publicJSON['sqlInstance'];
						if (port != null && port.trim().length > 0)
						{
							Ext.getCmp('listeningPort').setValue(port);
						}
						else if (instance != null && instance.trim().length > 0)
						{
							Ext.getCmp('listeningPort').setFieldLabel(instanceName);
							Ext.getCmp('listeningPort').setValue(instance);
						}				
						Ext.getCmp('dbDriver').setValue(publicJSON['driver']);
						Ext.getCmp('dbUserName').setValue(publicJSON['user']);
						Ext.getCmp('isDoubleByteEnabled').setValue(publicJSON['doubleByte']);
					}
				}
			}
		);
	}

});