Ext.define('EgDbProperties.view.DatabaseProperties', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.databaseproperties',
	cls:'outerpanel',
	title: dbPropertiesTitle,
	scroll:true,
	autoScroll:true,
	layout:{type:'vbox',align:'stretch'},
	margin:'8 8 0 8',
	items: [
		{
			xtype: 'component',
			cls:'adminHeadInfoText',
			html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp;'+ dbPropertiesDesc +'</center>',
			height: 25,
			padding: 3,
			width:'100%'
		},
		{
			xtype: 'container',
			layout: 'ux.center',
			margin: 20,
			padding: 20,
			items : [
				{
					xtype: 'fieldset',
					title: '<b>' + dbPropertiesTitle +'</b>',
					width: 600,
					flex: 1,
					items: [
						{
							xtype: 'container',
							layout: 'column',
							defaultType: 'displayfield',
							defaults: {
								labelAlign: 'top',
								labelSeparator: '',
								columnWidth: 0.5
							},
							items: [
								{
									fieldLabel: '<b>' + dbVendor + '</b>',
									margin: '10 0 30 0',
									id: 'vendor'
								},
								{
									fieldLabel: '<b>' + dbHost + '</b>',
									margin: '10 0 30 10',
									id: 'dbIP'
								},
								{
									fieldLabel: '<b>' + dbPort +'</b>',
									margin: '0 0 30 0',
									id: 'listeningPort'
								},
								{
									fieldLabel: '<b>' +dbName + '</b>',
									margin: '0 0 30 10',
									id: 'dbName'
								},
								{
									fieldLabel: '<b>' + dbDriver +'</b>',
									margin: '0 0 30 0',
									id: 'dbDriver'
								},
								{
									fieldLabel: '<b>' + dbUserName + '</b>',
									margin: '0 0 30 10',
									id: 'dbUserName'
								},
								{
									fieldLabel: '<b>' + dbDoubleByte +'</b>',
									margin: '0 0 10 0',
									id: 'isDoubleByteEnabled'
								}
							]
						}
					]
				}
			]
		}
	]

});



