<%
/**
 *	Name            :	EgDbPropertiesJSON.jsp
 *	Purpose         :	To display the current configuration of eG database.
 *	Version         :	5.0
 *	CreationDate    :	25/6/2013
 *	Author          :	Abdul Khader
 *	Design          :	Abdul Khader
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp" %>
<%@ page import="net.sf.json.*" %>
<%@ page import="egurkha.TransactionBean" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setContentType("application/json");
	JSONObject rootJson = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	TransactionBean dbconfig = new TransactionBean();
%>

<%
	String dbIP = "";
	String port = "";
	String oraSID = "";
	String strUser = "";
	String strUrl = "";
	String strDriver = "";
	String sqlProperty = "";
	String strDoubleByte = "";
	String sqlDbUserName = "";
	String strDBServerType = "";
	String sqlInstance = "";
	boolean isSql = false;
	boolean isOracle = false;

	dbconfig.createFile("eg_db.ini");
	strUser= dbconfig.getStrValue("DB_PROPERTIES","sql.user");
	strDriver= dbconfig.getStrValue("DB_PROPERTIES","drivers");
	strDBServerType= dbconfig.getStrValue("DB_PROPERTIES","DB_Server_Type");
	strDBServerType = strDBServerType.substring(strDBServerType.indexOf("Eg")+2,strDBServerType.indexOf("Adapter"));
	
	if (strDBServerType.equals("MsSql"))
	{
		strDBServerType = "Microsoft SQL";
		isSql = true;
	}
	else if (strDBServerType.equals("Oracle"))
	{
		isOracle = true;
	}
	strDoubleByte= dbconfig.getStrValue("DB_PROPERTIES","DoubleByteEnabled");
	if (strDoubleByte.equalsIgnoreCase("true"))
	{
		strDoubleByte = "Yes";
	}
	else
	{
		strDoubleByte = "No";
	}
	strUrl= dbconfig.getStrValue("DB_PROPERTIES","sql.url");
	if (isSql)
	{
		String sqlScheme = strUrl.substring(0,strUrl.indexOf("//")+2);
		String sqlPath = strUrl.substring(strUrl.indexOf("//")+2);
		
		/** CODE FOR GETTING IP **/
		if (sqlPath.indexOf(":") != -1)
		{
			dbIP = sqlPath.substring(0,sqlPath.indexOf(":"));
		}
		else if (sqlPath.indexOf("/") != -1)
		{
			dbIP = sqlPath.substring(0,sqlPath.indexOf("/"));
		}
		else if (sqlPath.indexOf(";") != -1)
		{
			dbIP = sqlPath.substring(0,sqlPath.indexOf(";"));
		}
		else
		{
			dbIP = sqlPath; //means it ends with ip itself
		}

		/** CODE FOR GETTING OTHER PARAMETERS **/

		if (sqlPath.indexOf(":") != -1)
		{
			sqlPath = sqlPath.substring(sqlPath.indexOf(":")+1);
			if (sqlPath.indexOf("/") != -1)
			{
				port = sqlPath.substring(sqlPath.indexOf(":")+1,sqlPath.indexOf("/"));
			}
			else if (sqlPath.indexOf(";") != -1)
			{
				port = sqlPath.substring(sqlPath.indexOf(":")+1,sqlPath.indexOf(";"));
			}
			else
			{
				port = sqlPath.substring(sqlPath.indexOf(":")+1);
			}
		}
		if (sqlPath.indexOf("/") != -1)
		{
			//url contains DB user name
			if (sqlPath.indexOf(";") != -1)
			{
				sqlDbUserName = sqlPath.substring(sqlPath.indexOf("/")+1,sqlPath.indexOf(";"));
			}
			else
			{
				sqlDbUserName = sqlPath.substring(sqlPath.indexOf("/")+1);
			}
		}
		if (sqlPath.indexOf(";") != -1)
		{
			//url contains PROPERTY
			sqlProperty = sqlPath.substring(sqlPath.indexOf(";")+1);
		}
		int idx = strUrl.indexOf(";INSTANCE=");
		if (idx > -1)
		{
			sqlInstance = strUrl.substring(idx+10);
			sqlInstance = sqlInstance.substring(0,sqlInstance.indexOf(";"));
		}
	}
	else if (isOracle)
	{
		String oraScheme = strUrl.substring(strUrl.indexOf(":thin:")+6);
		if (oraScheme.indexOf("//") == -1 && oraScheme.indexOf("/") == -1)
		{
			oraSID = oraScheme.substring(oraScheme.lastIndexOf(":")+1);
			oraScheme = oraScheme.substring(0,oraScheme.lastIndexOf(":"));
		}
		else
		{
			oraSID = oraScheme.substring(oraScheme.lastIndexOf("/")+1);
			oraScheme = oraScheme.substring(0,oraScheme.lastIndexOf("/"));
		}
		oraScheme = oraScheme.substring(oraScheme.indexOf("@"));
		if(oraScheme.indexOf(":") != -1)
		{
			port = oraScheme.substring(oraScheme.indexOf(":")+1);
			oraScheme = oraScheme.substring(0,oraScheme.indexOf(":"));
		}
		if (!(oraScheme.equals("@//") || oraScheme.equals("@")))//to check if local host is given are not
		{
			dbIP = oraScheme.substring(1);
			if (dbIP.indexOf("//") != -1)
			{
				dbIP = oraScheme.substring(3);
			}
		}
	}
	rootJson.put("dbServerType",strDBServerType);
	rootJson.put("dbIP",dbIP);
	rootJson.put("port",port);
	rootJson.put("oraSID",oraSID);
	rootJson.put("sqlDbUserName",sqlDbUserName);
	rootJson.put("sqlInstance",sqlInstance);
	if (sqlProperty.length() >0)
	{
		if(sqlProperty.indexOf(";") != -1)
		{
			StringTokenizer stoken = new StringTokenizer(sqlProperty,";");
			while (stoken.hasMoreTokens())
			{
				String propKey = stoken.nextToken();
				String propVal = propKey.substring(propKey.indexOf("=")+1);
				propKey = propKey.substring(0,propKey.indexOf("="));

				rootJson.put("propKey",propKey);
				rootJson.put("propVal",propVal);
			}
		}
		else 
		{
			String propKey = sqlProperty.substring(0,sqlProperty.indexOf("="));
			String propVal = sqlProperty.substring(sqlProperty.indexOf("=")+1);
			rootJson.put("propKey",propKey);
			rootJson.put("propVal",propVal);
		}
	}
	rootJson.put("driver",strDriver);
	rootJson.put("user",strUser);
	rootJson.put("doubleByte",strDoubleByte);
	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbProperties.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgDbProperties.jsp");
	}
	out.println(rootJson);
%>



