var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
	clicksToEdit: 1,
	id: 'cellEditingPlugin'
	//listeners:{
		//'beforeedit': function()
		//{
			//thisController.checkEmptyData();
		//}
	//}
});

Ext.define('EgDbSettings.view.DDDPurgePeriods', {
	//extend: 'Ext.form.Panel',
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.dddpurgeperiods',
	cls:'outerpanel',
	title: ddPurgePeriodsTitle,
	header:{cls:'zonereporthead'},
	margin :'8 8 0 8',
	//autoScroll: true,
	frame: true,
	border:true,

	requires: [
		'utilities.ScrollCombo',
		'utilities.CustomGrid'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	tools : [
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'saveTool',
			items: [{
				xtype: 'button',
				iconCls: 'iconPdf',
				id: 'save',
				style: {
					background: 'none',
					border: '0px'
				},
				listeners:{
					afterrender:function(){
						Ext.create("Ext.tip.ToolTip",{
							target:this.id,
							anchor:"top",
							cls:"yellowTip",
							trackMouse:true,
							html:"Save"
						});
					}
				}
			}]
		},{xtype:"tbseparator"},
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'printTool',
			items: [{
					xtype: 'button',
					iconCls: 'iconPrinter',
					id: 'print',
					style: {
						background: 'none',
						border: '0px'
					},
					listeners:{
						afterrender:function(){
							Ext.create("Ext.tip.ToolTip",{
								target:this.id,
								anchor:"top",
								cls:"yellowTip",
								trackMouse:true,
								html:"Print"
							});
						}
					}
			}]
		},{xtype:"tbseparator"},
		{
			xtype:'container',
			margin:'0 1px 0 1px',
			items:[
				{
					xtype:'button',
					id: 'saveCSV',
					//disabled : true,
					iconCls:'iconCsv',
					style:{
						background:'none',border:'0px'
					},
					listeners:{
						afterrender:function(){
							Ext.create("Ext.tip.ToolTip",{
								target:this.id,
								anchor:"top",
								cls:"yellowTip",
								trackMouse:true,
								html:"CSV"
							});
						}
					}
				}
			]
		},{xtype:"tbseparator"},
		{
			xtype : 'button',
			cls:'backbutton',
			id : 'backButton',
			iconCls:'iconBack',
			text : backBtnText
		}
	],

	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		width:'100%',
		height: 25,
		padding: 3,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+ ddPurgePeriodsDesc +'</center>',
			}
		]
	}],

	items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			cls:'formOuter',
			padding:'10 0 10 0',
			margin: '10 10 0 10',
			defaults: {
				labelAlign: 'top',
				labelSeparator: ' ',
			},
			items: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: testTypeLabel,
					width: 150,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : [
							{"displayField":"Test","valueField":"test"},
							{"displayField":"Detailed Diagnosis","valueField":"detailed diagnosis"},
						]
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					value: 'test',
					editable: false,
					queryMode: 'local',
					name: 'Test_type',
					id: 'testType'
				},
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: compTypeLabel,
					width: 300,
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					editable: false,
					queryMode: 'local',
					name: 'Component_type',
					id: 'compType',
					margin: '0 0 0 20'
				}
			]
		},
		{
			xtype: 'customgrid',
			cls:'gridSkin',
			id: 'mainGrid',
			ptype: 'cellediting',
			margin: '10 10 0 10',
			store: new Ext.data.Store({
				fields : ['Test', 'purgePeriod', 'otherTests'],
				data : []
			}),
			flex: 1,
			//height:320,
			autoScroll:true,
			queryMode: 'local',
			viewConfig: {deferEmptyText:true},
			emptyText: "<table border='0' height='340' width='100%'><tr><td align=center valign=middle><div class='iconInformation'></div><div class='commonErrorMsgText'>" + noTests + "</div></td></tr></table>",
			plugins: cellEditing,
			//plugins: [
				//Ext.create('Ext.grid.plugin.CellEditing', {
					//clicksToEdit: 1,
					//id: 'cellEditingPlugin'
				//})
			//],
			selType: 'cellmodel',
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: testText,
						dataIndex: 'Test',
						flex: 1,
						id: 'testId'
					},
					{
						xtype: 'gridcolumn',
						text: purgePeriodText,
						dataIndex: 'purgePeriod',
						flex: 1,
						id: 'periodColumnId',
						updateEl: true
					},
					{
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-DDPurgePeriod-column-header',
						width: 40,
						//icon: '../../../../admin/eg_images/blue/icon_nextpage.png',
						//iconCls: 'x-hidden',
						iconCls:'iconApplyToOtherTests',
						//tooltip: applyToOtherTestsTooltip,
						sortable: false,
						id: 'applyToOtherTests',
						hideHeaders: false,
						hideMode: 'offset',
						dataIndex: 'otherTests',
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='"+applyToOtherTestsTooltip+"' data-qclass='yellowTip'";
						}
					}
				]
			},
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					id: 'searchId',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					emptyText: 'Search',
					padding: '2 6 2 2',
					onTrigger1Click: function()
					{
						thisController.clearSearch();
					},
					onTrigger2Click: function()
					{
						thisController.onChangeEvent(this.getValue());
					},
					getTriggerMarkup: function()
					{
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++)
						{
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i,
										triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					}
				}
			]
		},
		{
			xtype: 'container',
			items: [
				{
					xtype: 'hidden',
					name: 'ddPurgePeriodsForAudit',
					id: 'purgePeriodsIdForAudit'
				},
				{
					xtype: 'hidden',
					name: 'ddPurgePeriods',
					id: 'purgePeriodsId'
				},
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '10 0 10 0',
			items: [
				{
					xtype: 'button',
					cls:'button20',
					text: dbSettingsBtnText,
					id: 'updateInPurge'
				}
			]
		}
	]
});



