<%
/**
 *  File          :       Egdbsettingsp.jsp
 *  Purpose       :       To update the configured values in eg_db.ini file
 *  Version       :       6.0
 *  Created Date  :       28/06/2013
 *  Modified Date :       28/06/2013
 *  Author        :       Abdul Khader M
 */
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page errorPage="../../EgProbs.jsp" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgMemInfo" %>
<%@ page import = "com.egurkha.admin.AuditLogThread" %>
<%@ page import="com.eg.EgServicesInfo" %>
<%@ page import="net.sf.json.*"%>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.egurkha.ini.IniUI" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	JSONObject rootJson = new JSONObject();
%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<jsp:useBean id="dbconfig" class="egurkha.TransactionBean" scope="page" />

<%!
	String subject = "MANAGER_SETTINGS";
	String licenseCheck = new String("license");
%>

<%
	String meas = request.getParameter("MeasurementCleanPeriod");
	String hour = request.getParameter("HourlyCleanPeriod");
	String daily = request.getParameter("DailyCleanPeriod");
	String monthly = request.getParameter("MonthlyCleanPeriod");
	String event = request.getParameter("EventHistoryCleanPeriod");
	String fixhist = request.getParameter("FixHistoryCleanPeriod");
	String initconns = request.getParameter("Initconns");
	String maxconns = request.getParameter("Maxconns");
	String trendStartTime = request.getParameter("DailyTrendComputation");
	String CtxUserBilling=request.getParameter("CtxUserBillingCleanPeriod");
	String CtxUserMonthlyBilling=request.getParameter("CtxUserMonthlyBillingCleanPeriod");

	//dbconfig.createFile("eg_db.ini","save");
	dbconfig.createSyncFile("eg_db.ini","save");
	dbconfig.setValue(subject,"MeasurementCleanPeriod",meas);
	dbconfig.setValue(subject,"HourlyCleanPeriod",hour);
	dbconfig.setValue(subject,"DailyCleanPeriod",daily);
	dbconfig.setValue(subject,"MonthlyCleanPeriod",monthly);
	dbconfig.setValue(subject,"EventHistoryCleanPeriod",event);
	dbconfig.setValue(subject,"FixHistoryCleanPeriod",fixhist);
	
	try{
		IniFile egDbIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_db.ini");
		String[] cleanupTablesArray = egDbIni.getVariables("CleanUp_Tables");
		List cleanupTablesList = Arrays.asList(cleanupTablesArray);
		if(cleanupTablesList != null){
			for(int i=0;i<cleanupTablesList.size();i++){
				String tableName = (String)cleanupTablesList.get(i);
				String reqvalue = request.getParameter(tableName);
			
				if(reqvalue == null)
					continue;
				
				String afterValue = egDbIni.getValue("CleanUp_Tables",tableName);
				if(afterValue.indexOf("^!^") != -1)
					afterValue = afterValue.substring(afterValue.indexOf("^!^"));
				else
					afterValue = "";

				String updatedValue = reqvalue+afterValue;
				dbconfig.setValue("CleanUp_Tables",tableName,updatedValue);
			}
		}

	}catch(Exception e){
		e.printStackTrace();
	}
	
	EgServicesInfo egserInfo = new EgServicesInfo("manager");
	boolean isBillingEnabled = egserInfo.isBillingDataEnabled();
	if(isBillingEnabled)
	{
		dbconfig.setValue(subject,"CtxUserBillingCleanPeriod",CtxUserBilling);
		dbconfig.setValue(subject,"CtxUserMonthlyBillingCleanPeriod",CtxUserMonthlyBilling);
	}

	boolean ddEnabled = false;
	synchronized(licenseCheck)
	{
		ddEnabled = EgMemInfo.ddEnabled;
	}
	if (ddEnabled)
	{
		String diagnosis = request.getParameter("DetailedDiagnosisCleanPeriod");
		dbconfig.setValue(subject,"DetailedDiagnosisCleanPeriod",diagnosis);
	}

	boolean isAuditLogEnabled = egserInfo.isAuditlogEnabled();
	if (isAuditLogEnabled)
	{
		String audit = request.getParameter("AuditLogCleanPeriod");
		dbconfig.setValue(subject,"AuditLogCleanPeriod",audit);
	}

	boolean isConfigEnabled = EgInstallInfo.isConfigSupported;
	if (isConfigEnabled)
	{
		String configMeasure = request.getParameter("ConfigMeasurementCleanPeriod"); 
		String configChangeMaster = request.getParameter("ConfigChangeMasterCleanPeriod");
		configMeasure = (configMeasure != null && configMeasure.length()>0)?configMeasure:"42";
		configChangeMaster = (configChangeMaster != null && configChangeMaster.length()>0)?configChangeMaster:"42";
		dbconfig.setValue(subject,"ConfigMeasurementCleanPeriod",configMeasure);
		dbconfig.setValue(subject,"ConfigChangeMasterCleanPeriod",configChangeMaster);
	}

	long duration = 30;
	if (!StringUtils.isNull(trendStartTime) && trendStartTime.indexOf(":") > -1)
	{
		int index = trendStartTime.indexOf(":");
		String hours = trendStartTime.substring(0, index);
		String minutes = trendStartTime.substring(index+1);

		try
		{
			duration = Integer.parseInt(hours) * 60;
			duration += Integer.parseInt(minutes);
		}
		catch(NumberFormatException e)
		{
		}
	}

	dbconfig.setValue(subject,"TrendStartTime", String.valueOf(duration));

	dbconfig.setValue("DB_PROPERTIES","sql.initconns",initconns);
	dbconfig.setValue("DB_PROPERTIES","sql.maxconns",maxconns);
	dbconfig.saveFile();
	dbconfig.releaseInstance();
	Hashtable ht = new Hashtable();
	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Data Management");
	auditLogThread.setValue("Activity","Database Settings");
	Enumeration en = request.getParameterNames();
	while(en.hasMoreElements())
	{
		String name = ((String) en.nextElement()).toString().trim();
		if(name != null && !name.equalsIgnoreCase("null") && name.length()>0 && name.startsWith("$_"))
		{
			String value = request.getParameter(name);
			if(value != null && !value.equalsIgnoreCase("null") && value.length()>0 && value.indexOf("$") !=-1)
			{
				String label = null;
				String labelValue = null;
				StringTokenizer stokens = new StringTokenizer(value,"$");
				if(stokens.countTokens()==2)
				{
					label = stokens.nextToken().toString();
					labelValue = stokens.nextToken();
				}
				else
				{
					label = stokens.nextToken();
					labelValue = "";
				}
				if(label != null && labelValue != null && !labelValue.equalsIgnoreCase("null") && labelValue.trim().length()>0)
				{
					auditLogThread.setPreviousValue(label, labelValue.startsWith("_")?labelValue.substring(1):labelValue);
					ht.put(label, labelValue.startsWith("_")?labelValue.substring(1):labelValue);
				}

				String currentValue = request.getParameter(name.substring(2));
				if(currentValue == null || currentValue.equalsIgnoreCase("null") && currentValue.trim().length()==0)
					continue;
				currentValue = currentValue.trim();
				if(currentValue.length()>0)
				{
					auditLogThread.setCurrentValue(label, currentValue);
					if(ht.containsKey(label))
					{
						if(currentValue.equals(ht.get(label).toString()))
							ht.remove(label);
					}
				}
			}
		}
	}
	if(ht.size()>0)
	{
		auditLogThread.setValue("Description","Database settings have been configured");
		auditLogThread.sendItToDB();
	}
	/* code for auditlog ends */

	Vector sess_vec = new Vector();
	sess_vec.addElement(_mapping.getTextDescription("admin.db.Configure database settings"));//"Configure database settings");
	sess_vec.addElement("EgDbSettings.jsp");
	sess_vec.addElement(_mapping.getTextDescription("admin.db.Configure database settings")+".");
	sess_vec.addElement(_mapping.getTextDescription("admin.db.Database settings have been configured successfully")+"...");
	session.setAttribute("vec_Results",sess_vec);
	rootJson.put("success","true");
	rootJson.put("successUpdate","true");
	out.println(rootJson.toString());
%>



