Ext.define('EgDefaultReports.controller.Main',{
	extend:'Ext.app.Controller',
	views:['DefaultReports','DefaultReportsConfiguration'],
	refs:[
		{selector:'defaultreports', ref:'defaultreports'},
		{selector:'defaultreportsconfiguration', ref:'defaultreportsconfiguration'}
	],

	init: function()
	{
		me = this;
		this.control({
			'defaultreports':
			{
				'afterrender': this.afterMainRender
			},
			'defaultreports combo[id="categoryType"]':
			{
				'select': this.categoryChange
			},
			'defaultreports combo[id="reportTypeInView"]':
			{
				'select': this.reportChange
			},
			'defaultreports combo[id="selectedCompType"]':
			{
				'select': this.compTypeChange
			},
			'defaultreports button[id="addToSummary"]':
			{
				'click': this.addToSummary
			},
			//'defaultreports button[id="deleteInView"]':
			//{
				//'click': this.deleteInView
			//},
			'defaultreports button[id="addNew"]':
			{
				'click': this.addNew
			},
			'defaultreports actioncolumn[id="deleteInView"]':
			{
				'click': this.deleteTest
			},
			'defaultreports actioncolumn[id="updateInView"]':
			{
				'click': this.updateInView
			},
			'defaultreports grid[id="mainGrid"]':
			{
				//'itemmouseenter': this.onGridEnter,
				//'itemmouseleave': this.onGridLeave
			},

		//Code added to get events for add page in default reports
			'defaultreportsconfiguration combo[id="category"]':
			{
				'select': this.categoryInAddChange
			},
			'defaultreportsconfiguration combo[id="reportType"]':
			{
				'select': this.reportInAddChange
			},
			'defaultreportsconfiguration combo[id="servers"]':
			{
				'select': this.compTypeInAddChange
			},
			'defaultreportsconfiguration combo[id="tests"]':
			{
				'select': this.testsInAddChange
			},
			'defaultreportsconfiguration button[id="addBtn"]':
			{
				'click': this.addMeasures
			},
			'defaultreportsconfiguration button[id="backbutton"]':
			{
				'click': this.goToView
			},
		});
	},

	//Method to view the configured tests and measures in the default report
	afterMainRender: function()
	{
		var viewStoreObj = Ext.getCmp('mainGrid');

		if (Ext.isEmpty(catTypeFromSession) || catTypeFromSession == 'null' )
		{
			Ext.getCmp('categoryType').setValue('Choose category type');
		}
		else
		{
			Ext.getCmp('categoryType').setValue(catTypeFromSession);
		}

		if (!Ext.isEmpty(graphTypeFromSession) && graphTypeFromSession != 'null')
		{
			Ext.getCmp('reportTypeInView').setValue(graphTypeFromSession);
		}
		else
		{
			Ext.getCmp('reportTypeInView').setValue('Choose report type');
		}

		if (!Ext.isEmpty(serverTypeFromSession) && serverTypeFromSession != 'null')
		{
			Ext.getCmp('selectedCompType').setValue(serverTypeFromSession);
		}
		else
		{
			Ext.getCmp('selectedCompType').setValue('Select the component');
		}

		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var secType = 'Default';

		var testInAddObj = Ext.getCmp('tests');
		var serverTypeObj = Ext.getCmp('selectedCompType');

		if (catType == 'Application')
		{
			serverTypeObj.show();
		}
		else
		{
			serverTypeObj.hide();
		}

		if (graphType == 'Measure')
		{
			Ext.getCmp('addToSummary').setDisabled(false);
		}
		if (graphType == 'Summary')
		{
			Ext.getCmp('addToSummary').setDisabled(true);
		}

		viewStoreObj.setTitle('Reports');

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var viewArray = jsonData.summaryArrayJson;
					var viewArrayLength = jsonData.summaryArrayJson.length;

					viewStoreObj.getStore().loadRawData(viewArray);
					serverTypeObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
					//testInAddObj.getStore().loadRawData(jsonData.testsArrayJson);

					if (catType == 'Site')
					{
						testInAddObj.getStore().loadRawData(jsonData.siteTestsArrayJson);
					}
					else
					{
						testInAddObj.getStore().loadRawData(jsonData.testsArrayJson);
					}
				}
			}
		);
	},

	categoryChange: function()
	{
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var secType = 'Default';
		var serverTypeObj = Ext.getCmp('selectedCompType');
		if (catType == 'Application')
		{
			serverTypeObj.show();
		}
		else
		{
			serverTypeObj.hide();
		}

		Ext.getCmp('reportTypeInView').setValue('Choose report type');

		Ext.getCmp('addToSummary').setDisabled(true);

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType;

		Ext.Ajax.request({
			url : url,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);

				var viewArray = jsonData.summaryArrayJson;
				var viewArrayLength = jsonData.summaryArrayJson.length;

				var gridTitle = '';

				if (!Ext.isEmpty(serverTypeObj) && jsonData.CompTypeArrayJson.length > 0)
				{
					serverTypeObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
					serverTypeObj.setValue(jsonData.CompTypeArrayJson[0].valueField);
				}
				else
				{
					serverTypeObj.setValue('Select the component');
				}

				if (catType == 'Choose category type')
				{
					gridTitle = 'Reports';
					Ext.getCmp('mainGrid').setTitle(gridTitle);
				}

				if (catType == 'Network')
				{
					gridTitle = 'Network Reports';
					Ext.getCmp('mainGrid').setTitle(gridTitle);
				}

				if (catType == 'System')
				{
					gridTitle = 'System Reports';
					Ext.getCmp('mainGrid').setTitle(gridTitle);
				}

				if (catType == 'Application')
				{
					gridTitle = 'Application Reports';
					Ext.getCmp('mainGrid').setTitle(gridTitle);
				}

				if (catType == 'Site')
				{
					gridTitle = 'Site Reports';
					Ext.getCmp('mainGrid').setTitle(gridTitle);
				}
				//Ext.getCmp('mainGrid').doLayout();
				Ext.getCmp('mainGrid').getStore().removeAll();
				//Ext.getCmp('mainGrid').setValue(' ');
			}
		});
	},

	reportChange: function()
	{
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var secType = 'Default';
		var valFlag = 'true';

		var serverTypeObj = Ext.getCmp('selectedCompType');

		var viewStoreObj = Ext.getCmp('mainGrid');

		Ext.getCmp('selectedCompType').setValue('Select the component');

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType;

		if (graphType == 'Measure')
		{
			Ext.getCmp('addToSummary').setDisabled(false);
		}
		else
		{
			Ext.getCmp('addToSummary').setDisabled(true);
		}

		if (Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			Ext.Msg.show({
				title: defaultReportsTitle,
				msg: alertforNoCategory,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			Ext.getCmp('reportTypeInView').setValue('Choose report type');

			valFlag = 'false';
		}

		if (catType == 'Network')
		{
			gridTitle = 'Network Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'System')
		{
			gridTitle = 'System Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'Application')
		{
			gridTitle = 'Application Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		if (catType == 'Site')
		{
			gridTitle = 'Site Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
		}

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var viewArray = jsonData.summaryArrayJson;
					var viewArrayLength = jsonData.summaryArrayJson.length;
					var gridTitle = jsonData.summaryJson.summaryTitle;

					var compTypeArray = jsonData.CompTypeArrayJson;
					viewStoreObj.getStore().loadRawData(jsonData.summaryArrayJson);
					serverTypeObj.getStore().loadRawData(jsonData.CompTypeArrayJson);

					//Ext.getCmp('mainGrid').header = true;
					if (catType == 'Application')
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}
					else
					{
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Network' && graphType == 'Choose report type')
					{
						gridTitle = 'Network Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'System' && graphType == 'Choose report type')
					{
						gridTitle = 'System Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Application' && graphType == 'Choose report type')
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (catType == 'Site' && graphType == 'Choose report type')
					{
						gridTitle = 'Site Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
					}

					if (valFlag == 'false')
					{
						viewStoreObj.setTitle('Reports')
					}
					//Ext.getCmp('mainGrid').doLayout();
				}
			}
		);
	},

	compTypeChange: function()
	{
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var secType = 'Default';

		var serverTypeObj = Ext.getCmp('selectedCompType');

		var viewStoreObj = Ext.getCmp('mainGrid');

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

		if (graphType == 'Measure')
		{
			Ext.getCmp('addToSummary').setDisabled(false);
		}
		else
		{
			Ext.getCmp('addToSummary').setDisabled(true);
		}

		if (Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			Ext.Msg.show({
				title: defaultReportsTitle,
				msg: alertforNoCategory,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			serverTypeObj.setValue('Select the component');
		}

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type')
		{
			Ext.Msg.show({
				title: defaultReportsTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			serverTypeObj.setValue('Select the component');
		}

		if (catType == 'Network' && serverType == 'Select the component')
		{
			gridTitle = 'Network Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
			Ext.getCmp('mainGrid').getStore().removeAll();
			return;
		}

		if (catType == 'System' && serverType == 'Select the component')
		{
			gridTitle = 'System Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
			Ext.getCmp('mainGrid').getStore().removeAll();
			return;
		}

		if (catType == 'Application' && serverType == 'Select the component')
		{
			gridTitle = 'Application Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
			Ext.getCmp('mainGrid').getStore().removeAll();
			return;
		}

		if (catType == 'Site' && serverType == 'Select the component')
		{
			gridTitle = 'Site Reports';
			Ext.getCmp('mainGrid').setTitle(gridTitle);
			Ext.getCmp('mainGrid').getStore().removeAll();
			return;
		}

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var viewArray = jsonData.summaryArrayJson;
					var viewArrayLength = jsonData.summaryArrayJson.length;
					var gridTitle = jsonData.summaryJson.summaryTitle;

					var compTypeArray = jsonData.CompTypeArrayJson;
					viewStoreObj.getStore().loadRawData(jsonData.summaryArrayJson);
					serverTypeObj.getStore().loadRawData(jsonData.CompTypeArrayJson);

					Ext.getCmp('mainGrid').setTitle(gridTitle);

					if (catType == 'Network' && serverType == 'Select the component')
					{
						gridTitle = 'Network Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}

					if (catType == 'System' && serverType == 'Select the component')
					{
						gridTitle = 'System Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}

					if (catType == 'Application' && serverType == 'Select the component')
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}

					if (catType == 'Site' && serverType == 'Select the component')
					{
						gridTitle = 'Site Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}

					if (catType == 'Network' && (Ext.isEmpty(viewArray) || viewArray.length == 0))
					{
						gridTitle = 'Network Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}

					if (catType == 'System' && (Ext.isEmpty(viewArray) || viewArray.length == 0))
					{
						gridTitle = 'System Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}

					if (catType == 'Application' && (Ext.isEmpty(viewArray) || viewArray.length == 0))
					{
						gridTitle = 'Application Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}

					if (catType == 'Site' && (Ext.isEmpty(viewArray) || viewArray.length == 0))
					{
						gridTitle = 'Site Reports';
						Ext.getCmp('mainGrid').setTitle(gridTitle);
						Ext.getCmp('mainGrid').getStore().removeAll();
						return;
					}

				}
			}
		);
	},

	addToSummary: function()
	{
		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var graphTypeObj = Ext.getCmp('reportTypeInView');
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var secType = 'Default';

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var lenForApplySummary = jsonData.applyToSummaryJson.length;

					for (var i=0; i<lenForApplySummary; i=i+2)
					{
						var variable = jsonData.applyToSummaryJson[i];

						var urlForSummary = 
						"/final/admin/EgDefaultReports/data/EgdefaultreportsJSONp.jsp?mode=main&varMeas="+variable+"&applytosum=true"+"&catType="+catType+"&reportType="+graphType+"&secType=Default&servers="+encodeURIComponent(serverType);

						Ext.Ajax.request(
						{
							url : urlForSummary,
							scope:this,
							method : 'POST',
							success: function(response){
								Ext.getCmp('addToSummary').setDisabled(true);
								graphTypeObj.setValue('Summary');
								Ext.getCmp('mainGrid').setTitle(gridTitle);

								catTypeForTitle = Ext.getCmp('categoryType').getValue();
								graphTypeForTitle = 'Summary';
								serverTypeForTitle = Ext.getCmp('selectedCompType').getValue();
								secType = 'Default';

								var urlForTitle = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=main&catType="+catTypeForTitle+"&graphType="+graphTypeForTitle+"&secType="+secType+"&serverType="+encodeURIComponent(serverTypeForTitle);

								Ext.Ajax.request(
								{
									url : urlForTitle,
									scope:this,
									method : 'POST',
									success: function(response){
										var jsonText = response.responseText;
										var jsonData = Ext.decode(jsonText);
										var gridTitle = jsonData.summaryJson.summaryTitle;
										Ext.getCmp('mainGrid').setTitle(gridTitle);
									}
								});
							}
						});
					}
				}
			}
		);
	},

	onGridEnter: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
			Ext.each(icons, function(icon){
				Ext.get(icon).removeCls('x-hidden');
		});
	},

	onGridLeave: function(view, task, node, rowIndex, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		});
	},

	addNew: function()
	{
		var mainViewId = Ext.getCmp('mainView');
		isItemUpdated = false;

		mainViewId.getLayout().setActiveItem(1);

		var categoryInView = Ext.getCmp('categoryType').getValue();
		var reportTypeInView = Ext.getCmp('reportTypeInView').getValue();
		var compTypeInView = Ext.getCmp('selectedCompType').getDisplayValue();

		// pass value of combo field for component type in application category 
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var secType = "Default";

		var testsObj = Ext.getCmp('tests');

		Ext.getCmp('category').setValue('Choose category type');
		Ext.getCmp('reportType').setValue('Choose report type');
		Ext.getCmp('servers').setValue('Select the component')
		Ext.getCmp('tests').setValue('Select the test');
		if (catType == 'Site')
		{
			Ext.getCmp('sites').setValue('Select the site');
		}

		var catType = Ext.getCmp('category').getValue();
		var serverTypeObj = Ext.getCmp('servers');

		Ext.getCmp('category').setValue(categoryInView);
		Ext.getCmp('reportType').setValue(reportTypeInView);

		var categoryObj = Ext.getCmp('category');
		var reportTypeObj = Ext.getCmp('reportType');

		var serverTypeObj = Ext.getCmp('servers');
		var siteObj = Ext.getCmp('sites');

		if (categoryInView == 'Application')
		{
			serverTypeObj.show();
		}
		else if (categoryInView == 'Site')
		{
			serverTypeObj.hide();
		}
		else
		{
			serverTypeObj.hide();
		}

		categoryObj.setValue(categoryInView);
		reportTypeObj.setValue(reportTypeInView);
		serverTypeObj.setValue(serverType);

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=addnew&catType="+categoryInView+"&graphType="+reportTypeInView+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					serverTypeObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
					serverTypeObj.setValue(serverType);

					if (categoryInView == 'Site')
					{
						testsArray = jsonData.siteTestsArrayJson;
						testsObj.getStore().loadRawData(testsArray);
					}
					else
					{
						testsArray = jsonData.testsArrayJson;
						testsObj.getStore().loadRawData(testsArray);
					}

					Ext.getCmp('itemselectTests').getStore().removeAll();
					Ext.getCmp('itemselectTests').setValue(' ');
				}
			}
		);
	},

	// Code added to configure/add measures for default reports
	categoryInAddChange: function()
	{
		Ext.getCmp('servers').setValue('Select the component');

		var catType = Ext.getCmp('category').getValue();
		var compField = Ext.getCmp('compType');
		var serverTypeObj = Ext.getCmp('servers');
		var testInAddObj = Ext.getCmp('tests');

		var serverTypeApp = '';

		var graphType = Ext.getCmp('reportType').getValue();
		var serverType = Ext.getCmp('servers').getValue();
		var secType = 'Default';

		Ext.getCmp('itemselectTests').getStore().removeAll();
		Ext.getCmp('itemselectTests').reset();

		if (catType != 'Application')
		{
			serverTypeObj.hide();
		}
		else
		{
			serverTypeObj.show();
		}

		var serverTypeObj = Ext.getCmp('servers');

		if (catType != 'Application')
		{
			serverTypeObj.hide();
		}
		else
		{
			serverTypeObj.show();
		}

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=addnew&catType="+catType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					serverTypeObj.getStore().loadRawData(jsonData.CompTypeArrayJson);

					if (catType == 'Site')
					{
						testInAddObj.getStore().loadRawData(jsonData.siteTestsArrayJson);
					}
					else
					{
						testInAddObj.getStore().loadRawData(jsonData.testsArrayJson);
					}
					Ext.getCmp('reportType').setValue('Choose report type');
					Ext.getCmp('tests').setValue('Select the test');
				}
			}
		);
	},

	reportInAddChange: function()
	{
		var catType = Ext.getCmp('category').getValue();
		if (Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			Ext.Msg.show({
				title: configTitle,
				msg: alertforNoCategory,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			Ext.getCmp('reportType').setValue('Choose report type');
			return;
		}
		Ext.getCmp('servers').setValue('Select the component');
		Ext.getCmp('tests').setValue('Select the test');

		var serverTypeObj = Ext.getCmp('servers');
		var testInAddObj = Ext.getCmp('tests');

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=addnew&catType="+catType;

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					serverTypeObj.getStore().loadRawData(jsonData.CompTypeArrayJson);

					if (catType == 'Site')
					{
						testInAddObj.getStore().loadRawData(jsonData.siteTestsArrayJson);
					}
					else
					{
						testInAddObj.getStore().loadRawData(jsonData.testsArrayJson);
					}

					Ext.getCmp('itemselectTests').getStore().removeAll();
					Ext.getCmp('itemselectTests').setValue(' ');
				}
			}
		);
	},

	compTypeInAddChange: function()
	{
		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var serverType = Ext.getCmp('servers').getValue();
		var testName = Ext.getCmp('tests').getValue();
		var secType = 'Default';

		var testNameObj = Ext.getCmp('tests');
		var itemSelectObj = Ext.getCmp('itemselectTests');

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type')
		{
			Ext.Msg.show({
				title: configTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			Ext.getCmp('servers').setValue('Select the component');
			return;
		}

		if (!Ext.isEmpty(serverType) && serverType == 'Select the component')
		{
			testNameObj.setValue('Select the test');
			itemSelectObj.fromField.getStore().removeAll();
			itemSelectObj.toField.getStore().removeAll();
			return;
		}

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=addnew&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&tname="+testName+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					testNameObj.getStore().loadRawData(jsonData.testsArrayJson);
					testNameObj.setValue(jsonData.testsArrayJson[0].valueField);

					itemSelectObj.fromField.getStore().removeAll();
					itemSelectObj.toField.getStore().removeAll();
				}
			}
		);
	},

	testsInAddChange: function()
	{
		var compField = Ext.getCmp('compType');
		var serverTypeObj = Ext.getCmp('servers');
		var testObj = Ext.getCmp('tests');
		var itemSelectObj = Ext.getCmp('itemselectTests');
		var serverTypeApp = '';

		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var serverType = Ext.getCmp('servers').getValue();
		var testName = Ext.getCmp('tests').getValue();
		var secType = 'Default';
		var valFlag = 'true';

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type' || graphType == 'Choose report')
		{
			Ext.Msg.show({
				title: configTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			testObj.setValue('Select the test');
			valFlag = 'false';
		}

		if (catType == 'Application')
		{
			if (Ext.isEmpty(serverType) || serverType == 'Select the component')
			{
				Ext.Msg.show({
					title: configTitle,
					msg: alertforNoComponent,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});

				testObj.setValue('Select the test');
				valFlag = 'false';
			}
		}

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=addnew&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&tname="+testName+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var allMeasures = jsonData.allRealMeasuresArrayJson;
					var disAssociatedMeasures = jsonData.disAssocRealMeasuresArrayJson;

					if (valFlag == 'true')
					{
						itemSelectObj.getStore().loadRawData(allMeasures);
						itemSelectObj.setValue(disAssociatedMeasures);
					}
				}
			}
		);
	},

	addMeasures: function()
	{
		var secType = "Default";
		var deleteTest = "";
		var hassociated = "";
		var hdisassociated = "";

		var valFlag = "true";

		var reportType = Ext.getCmp('reportType').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var catType = Ext.getCmp('category').getValue();

		var categoryInViewObj = Ext.getCmp('categoryType');
		var reportTypeInViewObj = Ext.getCmp('reportTypeInView');
		var compTypeInViewObj = Ext.getCmp('selectedCompType');

		if(Ext.isEmpty(catType) || catType == 'Choose category type')
		{
			valFlag = 'false';

			Ext.Msg.show({
				title: configTitle,
				msg: alertforNoCategory,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		var serverType = Ext.getCmp('servers').getValue();
		var testName = Ext.getCmp('tests').getValue();
		var tests = Ext.getCmp('tests').getValue();

		if (Ext.isEmpty(graphType) || graphType == 'Choose report type')
		{
			valFlag = 'false';

			Ext.Msg.show({
				title: configTitle,
				msg: alertforNoType,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		if (Ext.isEmpty(testName) || testName == 'Select the test')
		{
			valFlag = 'false';

			Ext.Msg.show({
				title: configTitle,
				msg: alertforNoTest,
				width: 300,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
		}

		if (catType == 'Application')
		{
			if (Ext.isEmpty(serverType) || serverType == 'Select the component')
			{
				valFlag = 'false';

				Ext.Msg.show({
					title: configTitle,
					msg: alertforNoComponent,
					width: 300,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
			}
		}

		var disassociatedMeasures = Ext.getCmp('itemselectTests').getValue();

		var lenDisAssoc;
		if (!Ext.isEmpty(disassociatedMeasures))
		{
			lenDisAssoc = disassociatedMeasures.length;
		}
		var disassociatedMeasuresArray = new Array();
		var associatedMeasuresArray = new Array();
		var allValueArray = new Array();
		var i;

		for (var i=0;i<Ext.getCmp('itemselectTests').getStore().getCount();i++)
		{
			var allValue = Ext.getCmp('itemselectTests').getStore().getAt(i).get('valueField');
			allValueArray[i] = allValue;
		}

		for (i=0;i<lenDisAssoc; i++)
		{
			var adisAssocMeasure = disassociatedMeasures[i];
			disassociatedMeasuresArray[i] = adisAssocMeasure;
		}

		var k = 0;
		for (var i=0;i<Ext.getCmp('itemselectTests').getStore().getCount();i++)
		{
			var allValue = Ext.getCmp('itemselectTests').getStore().getAt(i).get('valueField');
			for (var j=0;j<disassociatedMeasures.length;j++)
			{
				var isData = false;
				if (allValue == disassociatedMeasures[j])
				{
					isData = true;
					break;
				}
			}
			if (!isData)
			{
				associatedMeasuresArray[associatedMeasuresArray.length]=allValue;
			}
		}

		if ( !isItemUpdated )
		{
			Ext.Msg.show({
				title: configTitle,
				msg: alertForMeasureSelection,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});

			valFlag = 'false';
		}

		if (valFlag == 'true')
		{
			var url = "/final/admin/EgDefaultReports/data/EgdefaultreportsJSONp.jsp?mode=main&catType="+catType+"&secType="+secType+"&reportType="+reportType+"&serverType="+encodeURIComponent(serverType)+"&testName="+testName+"&tests="+tests+"&hassociatem="+associatedMeasuresArray+"&hdisassociatem="+disassociatedMeasuresArray+"&deleteTest="+deleteTest+"&hassociated="+hassociated+"&hdisassociated="+hdisassociated+"&servers="+encodeURIComponent(serverType);

			Ext.Ajax.request(
				{
					url : url,
					scope: this,
					method : 'POST',
					success: function(response){
						var mainViewId = Ext.getCmp('mainView');

						mainViewId.getLayout().setActiveItem(0);

						var viewStoreObj = Ext.getCmp('mainGrid');

						var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

						Ext.Ajax.request(
							{
								url : url,
								scope:this,
								method : 'POST',
								success: function(response){
									var jsonText = response.responseText;
									var jsonData = Ext.decode(jsonText);

									var viewArray = jsonData.summaryArrayJson;
									var viewArrayLength = jsonData.summaryArrayJson.length;

									viewStoreObj.getStore().loadRawData(viewArray);

									categoryInViewObj.setValue(catType);
									reportTypeInViewObj.setValue(graphType);

									if (catType == 'Application')
									{
										compTypeInViewObj.show();
									}
									else
									{
										compTypeInViewObj.hide();
									}
									compTypeInViewObj.setValue(serverType);

									if (graphType == 'Measure')
									{
										Ext.getCmp('addToSummary').setDisabled(false);
									}
									else
									{
										Ext.getCmp('addToSummary').setDisabled(true);
									}

									var gridTitle = jsonData.summaryJson.title;
									Ext.getCmp('mainGrid').setTitle(gridTitle);

								}
							}
						);

					}
				}
			);
		}
	},

	goToView: function()
	{
		var graphType = Ext.getCmp('reportTypeInView').getValue();
		var catType = Ext.getCmp('categoryType').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var serverTypeObj = Ext.getCmp('selectedCompType');
		var secType = 'Default';

		//code added for the view after back button
		var viewStoreObj = Ext.getCmp('mainGrid');

		var categoryInViewObj = Ext.getCmp('categoryType');
		var reportTypeInViewObj = Ext.getCmp('reportTypeInView');
		var compTypeInViewObj = Ext.getCmp('selectedCompType');

		var serverTypeInAdd = Ext.getCmp('servers').getValue();
		var testName = Ext.getCmp('tests').getValue();
		var tests = Ext.getCmp('tests').getValue();
		var graphTypeInAdd = Ext.getCmp('reportType').getValue();
		var catTypeInAdd = Ext.getCmp('category').getValue();

		var mainViewId = Ext.getCmp('mainView');
		mainViewId.getLayout().setActiveItem(0);

		if (catTypeInAdd == 'Application')
		{
			serverTypeObj.show();
		}
		else
		{
			serverTypeObj.hide();
		}

		categoryInViewObj.setValue(catTypeInAdd);
		reportTypeInViewObj.setValue(graphTypeInAdd);

		if(Ext.isEmpty(catTypeInAdd) || catTypeInAdd == 'Choose category type')
		{
			viewStoreObj.setTitle('Reports');
			viewStoreObj.getStore().removeAll();
			return;
		}

		var serverType = Ext.getCmp('servers').getValue();
		var testName = Ext.getCmp('tests').getValue();
		var tests = Ext.getCmp('tests').getValue();

		if (Ext.isEmpty(graphTypeInAdd) || graphTypeInAdd == 'Choose report type')
		{
			viewStoreObj.setTitle(catTypeInAdd + ' ' + 'Reports');
			viewStoreObj.getStore().removeAll();
			return;
		}

		if (catTypeInAdd == 'Application')
		{
			if (Ext.isEmpty(serverTypeInAdd) || serverTypeInAdd == 'Select the component')
			{
				viewStoreObj.setTitle(catTypeInAdd + ' ' + 'Reports');
				viewStoreObj.getStore().removeAll();
				return;
			}
		}

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=main&catType="+catTypeInAdd+"&graphType="+graphTypeInAdd+"&secType="+secType+"&serverType="+encodeURIComponent(serverTypeInAdd);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var viewArray = jsonData.summaryArrayJson;
					var viewArrayLength = jsonData.summaryArrayJson.length;

					viewStoreObj.getStore().loadRawData(viewArray);

					if (!Ext.isEmpty(serverTypeObj) && jsonData.CompTypeArrayJson.length > 0)
					{
						serverTypeObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
						serverTypeObj.setValue(jsonData.CompTypeArrayJson[0].valueField);
					}

					if (!Ext.isEmpty(compTypeInViewObj))
					{
						compTypeInViewObj.setValue(serverTypeInAdd);
					}

					if (graphTypeInAdd == 'Measure')
					{
						Ext.getCmp('addToSummary').setDisabled(false);
					}
					else
					{
						Ext.getCmp('addToSummary').setDisabled(true);
					}

					var gridTitle = jsonData.summaryJson.title;

					if (!Ext.isEmpty(gridTitle))
					{
						viewStoreObj.setTitle(gridTitle);
					}
				}
			}
		);
	},

	deleteTest: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var secType = "Default";
		var deleteTest = "";
		var hassociated = "";
		var hdisassociated = "";
		var testValueName = '';
		var testName = '';
		var tests = '';

		var associatedMeasuresArray = new Array();
		var disassociatedMeasuresArray = new Array();
		var allValueArray = new Array();
		var deleteTest = 'yes';

		/* code added to get the selected test name */
		var viewStoreObj = Ext.getCmp('mainGrid');

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var displaytestName = record.get('Test');
		var displaytests = record.get('Test');

		associatedMeasuresArray = record.get('Measures');
		// End of code added 

		var catType = Ext.getCmp('categoryType').getValue();
		var graphType = Ext.getCmp('reportTypeInView').getValue();

		var secType = "Default";
		var reportType = Ext.getCmp('reportTypeInView').getValue();
		var serverType = Ext.getCmp('selectedCompType').getValue();

		var newCnfMsg = alertForDeleteConfirmation +" "+catType+":"+graphType+"?";
		Ext.MessageBox.confirm(defaultReportsTitle,newCnfMsg, function(id) 
			{
				if (id == 'yes')
				{
					var urlTest = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

					Ext.Ajax.request({
						url : urlTest,
						scope:this,
						method : 'POST',
						success: function(response){
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);

							var testArray = jsonData.testsArrayJson;
							if (catType == 'Site')
							{
								testArray = jsonData.siteTestsArrayJson;;
							}

							for (var i=0;i<testArray.length;i++)
							{
								var allValue = testArray[i].displayField;

								if (displaytestName == allValue)
								{
									testValueName = testArray[i].valueField;
								}
							}
							testName = testValueName;
							tests = testValueName;

							var url = "/final/admin/EgDefaultReports/data/EgdefaultreportsJSONp.jsp?mode=main&catType="+catType+"&secType="+secType+"&reportType="+reportType+"&serverType="+encodeURIComponent(serverType)+"&testName="+testName+"&tests="+tests+"&hassociatem="+associatedMeasuresArray+"&hdisassociatem="+disassociatedMeasuresArray+"&deleteTest="+deleteTest+"&hassociated="+hassociated+"&hdisassociated="+hdisassociated+"&servers="+encodeURIComponent(serverType);

							Ext.Ajax.request({
								url : url,
								scope: this,
								method : 'POST',
								success: function(response)
								{
									Ext.Msg.show({
										title: defaultReportsTitle,
										msg: alertLbl1,
										width: 350,
										buttons: Ext.Msg.OK,
										icon: 'iconInformation',
										fn: function() {
											var urlForSummary = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=main&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

											me.buildMainData(urlForSummary);
										}
									});
								}
							});
						}
					});
				}
			}
		);
	},

	buildMainData: function(urlWithQstr)
	{
		Ext.Ajax.request({
			url : urlWithQstr,
			scope:this,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				var viewArray = publicJson.summaryArrayJson;
				var viewStoreObj = Ext.getCmp('mainGrid');


				var gridTitle = publicJson.summaryJson.title;
				if (Ext.isEmpty(gridTitle))
				{
					var catType = Ext.getCmp('categoryType').getValue();
					if (catType == 'Choose category type')
					{
						gridTitle = 'Reports';
					}
					else if (catType == 'Network')
					{
						gridTitle = 'Network Reports';
					}
					else if (catType == 'System')
					{
						gridTitle = 'System Reports';
					}
					else if (catType == 'Application')
					{
						gridTitle = 'Application Reports';
					}
					else if (catType == 'Site')
					{
						gridTitle = 'Site Reports';
					}
				}
				viewStoreObj.setTitle(gridTitle);
				viewStoreObj.getStore().removeAll();
				if (!Ext.isEmpty(viewArray))
				{
					viewStoreObj.getStore().loadRawData(viewArray);
				}
			}
		});
	},

	updateInView: function(gridView, htmlSomething, rowIndex, columnIndex, theEvent)
	{
		var mainViewId = Ext.getCmp('mainView');
		isItemUpdated = false;

		mainViewId.getLayout().setActiveItem(1);

		/* code added to get the selected test name */
		var viewStoreObj = Ext.getCmp('mainGrid');

		var store = viewStoreObj.getStore();
		var record = store.getAt(rowIndex);

		var testValueName = '';

		var displaytestName = record.get('Test');
		var displaytests = record.get('Test');

		associatedMeasuresArray = record.get('Measures');
		// End of code added 

		var categoryInView = Ext.getCmp('categoryType').getValue();
		var reportTypeInView = Ext.getCmp('reportTypeInView').getValue();
		var compTypeInView = Ext.getCmp('selectedCompType').getDisplayValue();
		// pass value of combo field for component type in application category 
		var serverType = Ext.getCmp('selectedCompType').getValue();
		var secType = "Default";

		var categoryObj = Ext.getCmp('category');
		var reportTypeObj = Ext.getCmp('reportType');
		var compTypeObj = Ext.getCmp('servers');
		var testObj = Ext.getCmp('tests');
		var itemSelectObj = Ext.getCmp('itemselectTests');

		var serverTypeObj = Ext.getCmp('servers');

		if (categoryInView != 'Application')
		{
			serverTypeObj.hide();
		}
		else
		{
			serverTypeObj.show();
		}

		categoryObj.setValue(categoryInView);
		reportTypeObj.setValue(reportTypeInView);
		compTypeObj.setValue(serverType);

		var catType = Ext.getCmp('category').getValue();
		var graphType = Ext.getCmp('reportType').getValue();
		var secType = 'Default';

		var url = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=addnew&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&serverType="+encodeURIComponent(serverType);

		Ext.Ajax.request(
			{
				url : url,
				scope:this,
				method : 'POST',
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					if (catType == 'Site')
					{
						testObj.getStore().loadRawData(jsonData.siteTestsArrayJson);
						testObj.setValue(testValueName);
					}
					else
					{
						testObj.getStore().loadRawData(jsonData.testsArrayJson);
						testObj.setValue(testValueName);
					}

					for (var i=0;i<Ext.getCmp('tests').getStore().getCount();i++)
					{
						var allValue = Ext.getCmp('tests').getStore().getAt(i).get('displayField');

						if (displaytestName == allValue)
						{
							testValueName = Ext.getCmp('tests').getStore().getAt(i).get('valueField');
						}
					}

					if (Ext.isEmpty(testValueName) || testValueName == '')
					{
						testValueName = 'Select the test';
					}

					testObj.setValue(testValueName);
					var testName = Ext.getCmp('tests').getValue();

					var urlForMeasures = "/final/admin/EgDefaultReports/data/EgDefaultReportsJSON.jsp?mode=addnew&catType="+catType+"&graphType="+graphType+"&secType="+secType+"&tname="+testName+"&serverType="+encodeURIComponent(serverType);

					Ext.Ajax.request(
						{
							url : urlForMeasures,
							scope:this,
							method : 'POST',
							success: function(response){
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);

								serverTypeObj.getStore().loadRawData(jsonData.CompTypeArrayJson);
								serverTypeObj.setValue(serverType);

								var allMeasures = jsonData.allRealMeasuresArrayJson;
								var disAssociatedMeasures = jsonData.disAssocRealMeasuresArrayJson;

								itemSelectObj.getStore().loadRawData(allMeasures);
								itemSelectObj.setValue(disAssociatedMeasures);

								if (catType == 'Site')
								{
									testObj.getStore().loadRawData(jsonData.siteTestsArrayJson);
									testObj.setValue(testValueName);
								}
								else
								{
									testObj.getStore().loadRawData(jsonData.testsArrayJson);
									testObj.setValue(testValueName);
								}
							}
						}
					);
				}
			}
		);
	},

});



